/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.ControllerListenerAdapter;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.BoldFontTool;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.FontNameTool;
import oracle.dss.dataView.gui.FontSizeTool;
import oracle.dss.dataView.gui.HorizontalAlignmentTool;
import oracle.dss.dataView.gui.ItalicFontTool;
import oracle.dss.dataView.gui.WarningDialog;

public class ToolBar
extends JToolBar
implements PropertyChangeListener {
    protected UIView m_dataView;
    protected Vector m_toolsVector;
    protected ToolbarControllerListener m_controllerListener;
    protected boolean m_isRolloverEnabled;
    protected boolean m_bSuperCalled;
    protected WarningDialog m_warningDialog;

    public ToolBar() {
        this.$init$();
        this.m_bSuperCalled = true;
        this.setBorderPainted(true);
    }

    public ToolBar(UIView dataView) {
        this.$init$();
        this.m_bSuperCalled = true;
        this.setBorderPainted(true);
        this.setDataView(dataView);
    }

    public void setDataView(UIView dataView) {
        if (this.m_dataView != null) {
            this.m_dataView.removeControllerListener(this.m_controllerListener);
        }
        this.m_dataView = dataView;
        if (this.m_dataView != null) {
            this.m_controllerListener = new ToolbarControllerListener();
            this.m_dataView.addControllerListener(this.m_controllerListener);
            this.setSelectedObject(new ControllerEvent(this.m_dataView, this.m_dataView.getSelectedObject()));
            this.update();
        }
    }

    public UIView getDataView() {
        return this.m_dataView;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (this.m_warningDialog != null) {
            this.m_warningDialog.setLocale(loc);
        }
        if (!this.m_bSuperCalled) {
            return;
        }
        int i = 0;
        while (i < this.m_toolsVector.size()) {
            Object tool = this.m_toolsVector.elementAt(i);
            if (tool instanceof Component) {
                ((Component)tool).setLocale(loc);
            }
            ++i;
        }
    }

    public void setSelectedObject(ControllerEvent e) {
        if (e.getSource() == this.m_dataView) {
            int i = 0;
            while (i < this.m_toolsVector.size()) {
                ((DataviewTool)this.m_toolsVector.elementAt(i)).selectedAction(e, this.m_dataView, this);
                ++i;
            }
        }
    }

    public Vector getTools() {
        return this.m_toolsVector;
    }

    public void update() {
        int i = 0;
        while (i < this.m_toolsVector.size()) {
            ((DataviewTool)this.m_toolsVector.elementAt(i)).update();
            ++i;
        }
    }

    public void setRolloverIconEnabled(boolean bEnabled) {
        int i = 0;
        while (i < this.m_toolsVector.size()) {
            if (this.m_toolsVector.elementAt(i) instanceof DataviewToolbarRollover) {
                ((DataviewToolbarRollover)this.m_toolsVector.elementAt(i)).setRolloverIconEnabled(bEnabled);
            }
            ++i;
        }
        this.m_isRolloverEnabled = bEnabled;
    }

    public boolean isRolloverIconEnabled() {
        return this.m_isRolloverEnabled;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public Component add(Component tool) {
        if (tool instanceof DataviewTool) {
            this.m_toolsVector.addElement(tool);
        }
        return super.add(tool);
    }

    public void remove(Component tool) {
        if (tool instanceof DataviewTool) {
            this.m_toolsVector.removeElement(tool);
        }
        super.remove(tool);
    }

    public void cleanUp() {
        if (this.m_toolsVector != null) {
            int i = 0;
            while (i < this.m_toolsVector.size()) {
                if ((DataviewTool)this.m_toolsVector.elementAt(i) != null) {
                    ((DataviewTool)this.m_toolsVector.elementAt(i)).cleanUp();
                    super.remove((Component)this.m_toolsVector.elementAt(i));
                }
                ++i;
            }
            this.m_toolsVector.removeAllElements();
            this.m_toolsVector = null;
        }
        if (this.m_dataView != null) {
            this.m_dataView.removeControllerListener(this.m_controllerListener);
        }
        this.m_dataView = null;
        this.m_controllerListener = null;
    }

    public void displayFormatAlert() {
        if (this.m_warningDialog == null) {
            this.m_warningDialog = new WarningDialog(this.getLocale());
        }
        this.m_warningDialog.show();
    }

    public boolean hideAlertInFuture() {
        if (this.m_warningDialog == null) {
            return false;
        }
        return !this.m_warningDialog.isDisplayAlert();
    }

    public void addComDataviewTools() {
        FontNameTool m_fontNameTool = new FontNameTool();
        m_fontNameTool.addPropertyChangeListener(this);
        FontSizeTool m_fontSizeTool = new FontSizeTool();
        m_fontSizeTool.addPropertyChangeListener(this);
        BoldFontTool m_boldfontTool = new BoldFontTool();
        m_boldfontTool.addPropertyChangeListener(this);
        ItalicFontTool m_italicfontTool = new ItalicFontTool();
        m_italicfontTool.addPropertyChangeListener(this);
        HorizontalAlignmentTool m_alignmentTool = new HorizontalAlignmentTool();
        m_alignmentTool.addPropertyChangeListener(this);
        this.add(m_fontNameTool);
        this.addToolBarSeparator();
        this.add(m_fontSizeTool);
        this.addToolBarSeparator();
        this.add(m_boldfontTool);
        this.add(m_italicfontTool);
        this.addToolBarSeparator();
        this.add(m_alignmentTool);
    }

    protected void addToolBarSeparator() {
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            JSeparator separator = new JSeparator(1);
            separator.setPreferredSize(new Dimension(5, 24));
            separator.setMaximumSize(new Dimension(5, 24));
            separator.setMinimumSize(new Dimension(5, 24));
            separator.setAlignmentX(0.5f);
            this.add(separator);
            this.add(Box.createHorizontalStrut(2));
        } else {
            super.addSeparator(new Dimension(1, this.getPreferredSize().height - 4));
        }
    }

    private void $init$() {
        this.m_dataView = null;
        this.m_toolsVector = new Vector();
        this.m_controllerListener = null;
        this.m_isRolloverEnabled = false;
        this.m_bSuperCalled = false;
        this.m_warningDialog = null;
    }

    protected class ToolbarControllerListener
    extends ControllerListenerAdapter {
        ToolbarControllerListener() {
        }

        public void componentSelected(ControllerEvent e) {
            ToolBar.this.setSelectedObject(e);
        }
    }
}

