/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;

public class WarningDialog
extends JDialog {
    protected JLabel label;
    protected MultiLineLabel warningLabel;
    protected JButton okButton;
    protected ResourceBundle rBundle;
    protected boolean m_displayAlert;
    private final Border _sBorder;

    public WarningDialog() {
        this((Locale)null);
    }

    public WarningDialog(Locale loc) {
        this.$init$();
        this.updateResourceBundle(loc);
        this.setTitle(this.rBundle.getString("warning dialog title"));
        this.setModal(true);
        this.init();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getPreferredSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.height) / 2, (screenSize.height - frameSize.width) / 2);
    }

    private void init() {
        this.label = new JLabel(this.rBundle.getString("warning title"));
        this.label.setFont(new Font(this.label.getFont().getName(), 1, this.label.getFont().getSize()));
        String warningText = this.rBundle.getString("warning text");
        this.warningLabel = new MultiLineLabel(warningText);
        this.warningLabel.setTextWrapper(WordWrapper.getTextWrapper());
        JPanel scrollPane = new JPanel();
        scrollPane.setLayout(new BoxLayout(scrollPane, 1));
        scrollPane.add(this.label);
        scrollPane.add(Box.createRigidArea(new Dimension(0, 4)));
        scrollPane.add((Component)this.warningLabel);
        JScrollPane scroller = new JScrollPane(scrollPane, 20, 31);
        scroller.getViewport().setBackground(Color.white);
        scroller.setBorder(new LineBorder(Color.white));
        scroller.setViewportBorder(new LineBorder(Color.white));
        JCheckBox hideAlert = new JCheckBox(this.rBundle.getString("display alert"));
        hideAlert.addItemListener(new 1());
        this.label.setAlignmentX(0.0f);
        this.warningLabel.setAlignmentX(0.0f);
        scroller.setAlignmentX(0.0f);
        hideAlert.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(scroller);
        panel.add(hideAlert);
        panel.setBackground(Color.white);
        panel.setBorder(this._sBorder);
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.setBorder(this._sBorder);
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        String translatedText = this.rBundle.getString("OK");
        JButton okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        buttonPanel.add(okButton);
        okButton.addActionListener(new 2());
        this.getRootPane().setDefaultButton(okButton);
        content.add(panel);
        content.add(Box.createRigidArea(new Dimension(0, 4)));
        content.add(buttonPanel);
        this.setResizable(false);
        panel.setAlignmentX(0.0f);
        buttonPanel.setAlignmentX(0.0f);
        content.setPreferredSize(new Dimension(400, 187));
        content.setMinimumSize(content.getPreferredSize());
        content.setMaximumSize(content.getPreferredSize());
    }

    public void setDisplayAlert(boolean alert) {
        this.m_displayAlert = alert;
    }

    public boolean isDisplayAlert() {
        return this.m_displayAlert;
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void setLocale(Locale loc) {
        this.updateResourceBundle(loc);
        this.setTitle(this.rBundle.getString("warning dialog title"));
        if (this.label != null) {
            this.label.setText(this.rBundle.getString("warning title"));
        }
        if (this.warningLabel != null) {
            this.warningLabel.setText(this.rBundle.getString("warning text"));
        }
        if (this.okButton != null) {
            this.okButton.setText(this.rBundle.getString("OK"));
        }
    }

    private void $init$() {
        this.rBundle = null;
        this.m_displayAlert = true;
        this._sBorder = new EmptyBorder(6, 6, 8, 5);
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                WarningDialog.this.m_displayAlert = false;
            } else if (e.getStateChange() == 2) {
                WarningDialog.this.m_displayAlert = true;
            }
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            WarningDialog.this.setVisible(false);
            WarningDialog.this.dispose();
        }
    }
}

