/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.managers;

import java.util.BitSet;
import oracle.dss.rules.Mergeable;

public class ViewSizing
implements Mergeable {
    protected int m_rowHeight;
    protected int m_columnWidth;
    protected BitSet m_propertyUsedFlags;
    private static final int RowHeightPropertyBit = 0;
    private static final int ColumnWidthPropertyBit = 1;
    private static final int NumberOfPropertyBits = 2;
    private static BitSet NoBitsSet = new BitSet();

    public boolean isAnythingOverridden() {
        return this.m_propertyUsedFlags.equals(NoBitsSet) ^ true;
    }

    public Object clone() {
        ViewSizing myClone = new ViewSizing(this.m_rowHeight, this.m_columnWidth);
        myClone.merge(this);
        return myClone;
    }

    public ViewSizing() {
        this(10, 10);
    }

    public ViewSizing(int rowHeight, int columnWidth) {
        this.$init$();
        this.m_propertyUsedFlags = new BitSet(2);
        this.m_propertyUsedFlags.and(NoBitsSet);
        this.m_rowHeight = rowHeight;
        this.m_columnWidth = columnWidth;
    }

    public void setRowHeight(int rowHeight) {
        this.setRowHeightUsed(true);
        this.m_rowHeight = rowHeight;
    }

    public int getRowHeight() {
        return this.m_rowHeight;
    }

    public boolean isRowHeightUsed() {
        return this.m_propertyUsedFlags.get(0);
    }

    public void setRowHeightUsed(boolean used) {
        if (used) {
            this.m_propertyUsedFlags.set(0);
        } else {
            this.m_propertyUsedFlags.clear(0);
        }
    }

    public void setColumnWidth(int columnWidth) {
        this.setColumnWidthUsed(true);
        this.m_columnWidth = columnWidth;
    }

    public int getColumnWidth() {
        return this.m_columnWidth;
    }

    public boolean isColumnWidthUsed() {
        return this.m_propertyUsedFlags.get(1);
    }

    public void setColumnWidthUsed(boolean used) {
        if (used) {
            this.m_propertyUsedFlags.set(1);
        } else {
            this.m_propertyUsedFlags.clear(1);
        }
    }

    public void merge(Mergeable from) {
        ViewSizing fm = null;
        try {
            fm = (ViewSizing)from;
        }
        catch (ClassCastException e) {
            return;
        }
        if (fm.isRowHeightUsed()) {
            this.setRowHeight(fm.getRowHeight());
        }
        if (fm.isColumnWidthUsed()) {
            this.setColumnWidth(fm.getColumnWidth());
        }
    }

    public boolean equals(Object o) {
        ViewSizing other;
        if (o == null) {
            return false;
        }
        try {
            other = (ViewSizing)o;
        }
        catch (ClassCastException e) {
            boolean bl = false;
            return bl;
        }
        if (!this.m_propertyUsedFlags.equals(other.m_propertyUsedFlags)) {
            return false;
        }
        if (this.getRowHeight() != other.getRowHeight()) {
            return false;
        }
        return this.getColumnWidth() == other.getColumnWidth();
    }

    public void clearUsedBits() {
        this.m_propertyUsedFlags.and(NoBitsSet);
    }

    private void $init$() {
        int n = 0;
        while (n < 2) {
            NoBitsSet.clear(n);
            ++n;
        }
    }
}

