/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import oracle.dss.dataView.AlertEvent;
import oracle.dss.dataView.AlertListener;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.CommonBaseTitle;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DVTResources;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.ImageView;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.SVGWriterProvider;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.ThickDataview;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gauge.BottomLabel;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.DataSpecification;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.ElementA;
import oracle.dss.gauge.ElementB;
import oracle.dss.gauge.Gauge;
import oracle.dss.gauge.GaugeBackground;
import oracle.dss.gauge.GaugeConstants;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeExportXMLWriter;
import oracle.dss.gauge.GaugeFrame;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.gauge.GaugeSVGWriter;
import oracle.dss.gauge.GaugeSetBackground;
import oracle.dss.gauge.GaugeSetKey;
import oracle.dss.gauge.GaugeType;
import oracle.dss.gauge.GaugeXML;
import oracle.dss.gauge.Graphics2DRenderer;
import oracle.dss.gauge.Indicator;
import oracle.dss.gauge.IntersectionAB;
import oracle.dss.gauge.LEDStyleCallback;
import oracle.dss.gauge.LegendArea;
import oracle.dss.gauge.LegendText;
import oracle.dss.gauge.LegendTitle;
import oracle.dss.gauge.LowerLabelFrame;
import oracle.dss.gauge.MetricLabel;
import oracle.dss.gauge.PlotArea;
import oracle.dss.gauge.SVGParser;
import oracle.dss.gauge.ThickGauge;
import oracle.dss.gauge.Threshold;
import oracle.dss.gauge.TickLabel;
import oracle.dss.gauge.TickMark;
import oracle.dss.gauge.TopLabel;
import oracle.dss.gauge.UpperLabelFrame;
import oracle.dss.graph.ImagemapComponent;
import oracle.dss.graph.flash.GaugeFlashRenderer;
import oracle.dss.graph.flash.RangeGauge;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFWriter;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.GoToFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.pfj.png.PNGEncoder;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGInvalidParameterException;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.dss.util.xml.XMLObjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonGauge
extends CommonDataview
implements GaugeConstants,
ImageView,
Persistable {
    protected static final String DS_ROW = "DS_ROW";
    protected static final String DS_COLUMN = "DS_COLUMN";
    protected static final String m_version = "11.0.0.0.1";
    private GaugeSetBackground m_gsBackground;
    private GaugeBackground m_background;
    private GaugeFrame m_gaugeFrame;
    private PlotArea m_plotArea;
    private TickLabel m_tickLabel;
    private TickMark m_tickMark;
    private Indicator m_indicator;
    private Threshold m_threshold;
    private TopLabel m_topLabel;
    private BottomLabel m_bottomLabel;
    private MetricLabel m_metricLabel;
    private UpperLabelFrame m_upLblFrame;
    private LowerLabelFrame m_lowLblFrame;
    private LegendArea m_legendArea;
    private LegendText m_legendText;
    private LegendTitle m_legendTitle;
    private ElementA m_elementA;
    private ElementB m_elementB;
    private IntersectionAB m_intersectionAB;
    private CommonBaseTitle m_dataviewFootnote;
    private CommonBaseTitle m_dataviewTitle;
    private CommonBaseTitle m_dataviewSubtitle;
    private DataSpecification m_dataSpecs;
    private Dimension m_imageSize;
    private Image m_currImage;
    private boolean m_validateXML;
    private GaugeXML m_gaugeXML;
    private EventListenerList m_listenerList;
    private ComponentHandle m_selObj;
    private boolean m_metadataLabelFlag;
    protected Hashtable m_context;
    private String _saveXML;
    private HashMap m_gsKeys;
    private Map m_gaugeEngines;
    private int m_hashMapMode;
    private Map m_gaugeAttributes;
    private Map m_skinGaugeAttributes;
    public Map m_gaugeSetAttributes;
    public Map m_skinGaugeSetAttributes;
    private boolean m_isUsingExternalData;
    private int m_measureEdge;
    private int m_measureLayer;
    private int m_gsNumWide;
    private int m_gsNumTall;
    private int m_dsRows;
    private int m_dsColumns;
    private Object[][] m_dataLinks;
    private SVGWriterProvider m_SVGWriterProvider;
    private int m_svgHeaders;
    private List m_svgScriptIdList;
    private Rectangle2D.Double _legAreaRect;
    private CustomShapesParser m_csParser;
    protected EventListenerList listenerList;
    protected boolean m_metaDateSupported;
    protected boolean m_metaDrillParentDateSupported;
    protected boolean m_metaDrillParentDateSpanSupported;
    protected boolean m_metaDateSpanSupported;
    protected boolean m_metaDrillSupported;
    protected int m_recalcState;
    protected static final int RECALC_STATE_READY = 0;
    protected static final int RECALC_STATE_XML = 1;
    protected static final int RECALC_STATE_ALL = 2;
    private static final int NO_DATA_AVAILABLE = -1;
    private static final String m_method__addSlicesToMaps = "_addSlicesToMaps";
    private static final String m_method__createDataSpecsFromLabels = "_createDataSpecsFromLabels";
    private static final String m_method__generateGaugeEngines = "_generateGaugeEngines";
    private static final String m_method__getSliceLabels = "_getSliceLabels";
    private static final String m_method__getDataLabel = "_getDataLabel";
    private static final String m_method__getLayerIndex = "_getLayerIndex";
    private static final String m_method__prepareEntries = "_prepareMapEntries";
    private static final String m_method__prepareMaps = "_prepareMaps";
    private static final String m_method__prepareMapsFromSlice = "_prepareMapsFromSlice";
    private static final String m_method__prepareMapsWithoutDataSpecs = "_prepareMapsWithoutDataSpecs";
    private static final String m_method__setXML = "_setXML";
    private static final String m_method_exportToPNG = "exportToPNG";
    private static final String m_method_renderLegend = "renderLegend";
    private static final String m_method_setGaugeType = "setGaugeType";
    private static final String m_method_setLEDStyle = "setLEDStyle";
    private static final String m_method_setSpecularHighlight = "setSpecularHighlight";
    private static final String m_method_setGaugeSetAlignment = "setGaugeSetAlignment";
    private static final String m_method_setGaugeSetColumnCount = "setGaugeSetColumnCount";
    private static final String m_method_setGaugeSetDirection = "setGaugeSetDirection";
    private static final String m_method_setGridData = "setGridData";
    private static final String m_method_setNumberType = "setNumberType";
    private static final String m_method_setTabularData = "setTabularData";
    private static final String m_method_writeXML = "writeXML";
    private static final String m_method_setAngleExtent = "setAngleExtent";
    private static final GaugeSetKey GSKEY_UNDEFINED = new GaugeSetKey(-1, -1);
    protected static final int DEFAULT_MAP_ATTRCOUNT = 8;
    protected static final int DEFAULT_MAP_GSATTRCOUNT = 3;
    public static final String NAME_GAUGE = "Gauge";
    public static final String NAME_GAUGEFRAME = "GaugeFrame";
    public static final String NAME_TICKLABEL = "TickLabel";
    public static final String NAME_TICKMARK = "TickMark";
    public static final String NAME_INDICATOR = "Indicator";
    public static final String NAME_INDICATORBAR = "IndicatorBar";
    public static final String NAME_INDICATORBASE = "IndicatorBase";
    public static final String NAME_THRESHOLD = "Threshold";
    public static final String NAME_TOPLABEL = "TopLabel";
    public static final String NAME_BOTTOMLABEL = "BottomLabel";
    public static final String NAME_PLOTAREA = "PlotArea";
    public static final String NAME_SFX = "SFX";
    public static final String NAME_METRICLABEL = "MetricLabel";
    public static final String NAME_UPPERLABELFRAME = "UpperLabelFrame";
    public static final String NAME_LOWERLABELFRAME = "LowerLabelFrame";
    public static final String NAME_LEGENDAREA = "LegendArea";
    public static final String NAME_LEGENDTEXT = "LegendText";
    public static final String NAME_LEGENDTITLE = "LegendTitle";
    public static final String NAME_VENNELEMENT = "VennElement";
    public static final String NAME_VENNDATA = "VennData";
    public static final String NAME_GAUGEFONT = "GaugeFont";
    public static final String NAME_GAUGESETBACKGROUND = "GaugeSetBackground";
    public static final String NAME_DATASPECIFICATION = "DataSpecification";
    public static final String a_gauge = "gauge";
    public static final String a_gaugeType = "gaugeType";
    public static final String a_ledStyle = "ledStyle";
    public static final String a_specularHighlight = "specularHighlight";
    public static final String a_tdStyle = "thresholdDialStyle";
    public static final String a_angleExtent = "angleExtent";
    public static final String a_tdMaxValue = "thresholdMaxValue";
    public static final String a_customLayout = "customLayout";
    public static final String a_gsalignment = "gsAlignment";
    public static final String a_gscolcount = "gsColumnCount";
    public static final String a_gsdirection = "gsDirection";
    public static final String a_numberType = "numberType";
    public static final String a_minLength = "minLength";
    public static final String a_content = "content";
    public static final String a_majorTickCount = "majorTickCount";
    public static final String a_majorTickColor = "majorTickColor";
    public static final String a_indicatorType = "type";
    public static final String a_indicatorBarFillColor = "barFillColor";
    public static final String a_useThresholdFillColor = "useThresholdFillColor";
    public static final String a_thresholdColor = "thresholdColor";
    public static final String a_aValue = "aValue";
    public static final String a_aTopLabel = "aTopLabel";
    public static final String a_aBottomLabel = "aBottomLabel";
    public static final String a_abValue = "abValue";
    public static final String a_abTopLabel = "abTopLabel";
    public static final String a_abBottomLabel = "abBottomLabel";
    public static final String a_bValue = "bValue";
    public static final String a_bTopLabel = "bTopLabel";
    public static final String a_bBottomLabel = "bBottomLabel";
    public static final String DIAL_NAME = "DIAL";
    public static final String STATUSMETER_NAME = "STATUSMETER";
    public static final String LED_NAME = "LED";
    public static final String VENN_NAME = "VENN";
    public static final String VERTICALSTATUSMETER_NAME = "VERTICALSTATUSMETER";
    public static final String LABELGAUGE_NAME = "LABEL";
    public static final String ls_dot = "LS_DOT";
    public static final String ls_kpi = "LS_KPI";
    public static final String ls_arrow = "LS_ARROW";
    public static final String ls_triangle = "LS_TRIANGLE";
    public static final String ls_custom = "LS_CUSTOM";
    public static final String ls_rectangle = "LS_RECTANGLE";
    public static final String ls_square = "LS_SQUARE";
    public static final String tds_pie = "TDS_PIE_FILL";
    public static final String tds_ring = "TDS_RING_FILL";
    public static final String tds_segments = "TDS_SEGMENTS";
    public static final String sh_on = "SH_ON";
    public static final String sh_off = "SH_OFF";
    public static final String gsa_none = "GSA_NONE";
    public static final String gsa_topleft = "GSA_TOPLEFT";
    public static final String gsa_top = "GSA_TOP";
    public static final String gsa_topright = "GSA_TOPRIGHT";
    public static final String gsa_right = "GSA_RIGHT";
    public static final String gsa_bottomright = "GSA_BOTTOMRIGHT";
    public static final String gsa_bottom = "GSA_BOTTOM";
    public static final String gsa_bottomleft = "GSA_BOTTOMLEFT";
    public static final String gsa_left = "GSA_LEFT";
    public static final String gsa_center = "GSA_CENTER";
    public static final String gsc_auto = "GSC_AUTO";
    public static final String gsd_across = "GSD_ACROSS";
    public static final String gsd_down = "GSD_DOWN";
    public static final String tc_none = "TC_NONE";
    public static final String tc_minmax = "TC_MINMAX";
    public static final String tc_increments = "TC_INCREMENTS";
    public static final String tc_majortick = "TC_MAJORTICK";
    public static final String tc_threshold = "TC_THRESHOLD";
    public static final String tc_metric = "TC_METRIC";
    public static final String nt_number = "NT_NUMBER";
    public static final String nt_percent = "NT_PERCENT";
    public static final String dst_metric = "DST_METRIC";
    public static final String dst_minimum = "DST_MINIMUM";
    public static final String dst_maximum = "DST_MAXIMUM";
    public static final String dst_threshold = "DST_THRESHOLD";
    public static final String dst_toplabel = "DST_TOPLABEL";
    public static final String dst_bottomlabel = "DST_BOTTOMLABEL";
    public static final String veid_a = "ID_A";
    public static final String veid_b = "ID_B";
    public static final String veid_ab = "ID_AB";
    public static final String a_thresholdMaxValue = "thresholdMaxValue";
    public static final String cl_none = "CL_NONE";
    public static final String cl_title_separator = "CL_TITLE_SEPARATOR";
    public static final String cl_outer_frame = "CL_OUTER_FRAME";
    public static final int MODE_USER = 0;
    public static final int MODE_SKIN = 1;
    public static final String METRIC_ROW = "Metric_row";
    public static final String METRIC_COLUMN = "Metric_col";
    private HashMap m_jsfHashMap;
    private HashMap m_jsfHashMap_Gauge;
    private BitSet _styleOverrideFlags;
    private BitSet _userOverrideFlags;
    protected static final int ATTR_STYLE_MAXID = 27;
    private static final double EMPTY_THRESHOLD = 0.45344435444344;
    private boolean m_flashAnimation;
    private GaugeFlashRenderer m_gaugeFlashWriter;
    private int m_widthPerItem;
    private int m_legendRows;
    private int m_legendCols;
    private String[] m_legendItems;
    private DVTResources m_dvtResources;
    protected static int MARKER_TEXT_GAP = 3;
    protected static int MARKER_DIAMETER = 9;
    protected static int LEGEND_ITEM_GAP = 4;
    private static final String SERVER_SWF_RESOURCE = "as/serverChart.swf";
    private String m_flashGaugeLCID;
    private ArrayList m_imageMapObjList;
    public static String ADA_SCREEN_READER_MODE = "adaScreenReaderMode";

    public CommonGauge() {
        this(Locale.getDefault(), (ThickGauge)null);
    }

    public CommonGauge(Locale locale, ThickGauge gauge) {
        super(locale);
        this.$init$();
        this.setThickDataview(gauge);
        this._setupGaugeView(locale);
    }

    private void _setupGaugeView(Locale locale) {
        this.checkGraphicsEnvironment();
        this.setLocale(locale);
        ThickDataview view = this.getThickDataview();
        this.m_gaugeXML = view != null ? new GaugeXML((Gauge)view) : new GaugeXML(this);
        this.setViewXML(this.m_gaugeXML);
        this._createComponentObjects();
        this.setDataSpecification(new DataSpecification());
        this.createPropertyOverrideFlags();
        this.setUserOverrideMode(true);
        this.setStyleOverrideMode(true);
    }

    private void _createComponentObjects() {
        this.m_gsBackground = new GaugeSetBackground(this);
        this.m_background = new GaugeBackground(this);
        this.m_gaugeFrame = new GaugeFrame(this);
        this.m_plotArea = new PlotArea(this);
        this.m_tickLabel = new TickLabel(this);
        this.m_tickMark = new TickMark(this);
        this.m_indicator = new Indicator(this);
        this.m_threshold = new Threshold(this);
        this.m_topLabel = new TopLabel(this);
        this.m_bottomLabel = new BottomLabel(this);
        this.m_metricLabel = new MetricLabel(this);
        this.m_upLblFrame = new UpperLabelFrame(this);
        this.m_lowLblFrame = new LowerLabelFrame(this);
        this.m_legendArea = new LegendArea(this);
        this.m_legendText = new LegendText(this);
        this.m_legendTitle = new LegendTitle(this);
    }

    private void checkGraphicsEnvironment() {
        try {
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics graphics = ((Image)image).getGraphics();
        }
        catch (Throwable e) {
            this.updateResourceBundle();
            String code = "22003";
            ResourceBundle localStrings = null;
            localStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.graph.resource.GaugeBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.graph.resource.GaugeBundle");
            String msg = this.getErrorIntlString(code, localStrings);
            throw new RuntimeException(MessageFormat.format("DVT-{0} {1}", code, msg));
        }
    }

    public GaugeSetBackground getGaugeSetBackground() {
        return this.m_gsBackground;
    }

    public GaugeBackground getGaugeBackground() {
        return this.m_background;
    }

    public GaugeFrame getGaugeFrame() {
        return this.m_gaugeFrame;
    }

    public PlotArea getPlotArea() {
        return this.m_plotArea;
    }

    public TickLabel getTickLabel() {
        return this.m_tickLabel;
    }

    public TickMark getTickMark() {
        return this.m_tickMark;
    }

    public Indicator getIndicator() {
        return this.m_indicator;
    }

    public Threshold getThreshold() {
        return this.m_threshold;
    }

    public TopLabel getTopLabel() {
        return this.m_topLabel;
    }

    public BottomLabel getBottomLabel() {
        return this.m_bottomLabel;
    }

    public MetricLabel getMetricLabel() {
        return this.m_metricLabel;
    }

    public UpperLabelFrame getUpperLabelFrame() {
        return this.m_upLblFrame;
    }

    public LowerLabelFrame getLowerLabelFrame() {
        return this.m_lowLblFrame;
    }

    public LegendArea getLegendArea() {
        return this.m_legendArea;
    }

    public LegendText getLegendText() {
        return this.m_legendText;
    }

    public LegendTitle getLegendTitle() {
        return this.m_legendTitle;
    }

    public ElementA getElementA() {
        if (this.m_elementA == null) {
            this.m_elementA = new ElementA(this);
        }
        return this.m_elementA;
    }

    public ElementB getElementB() {
        if (this.m_elementB == null) {
            this.m_elementB = new ElementB(this);
        }
        return this.m_elementB;
    }

    public IntersectionAB getIntersectionAB() {
        if (this.m_intersectionAB == null) {
            this.m_intersectionAB = new IntersectionAB(this);
        }
        return this.m_intersectionAB;
    }

    public int getGaugeSetAlignment() {
        Object obj = this.getGaugeSetAttribute("GaugeSetAlignment");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getGaugeSetAlignment());
        }
        return (Integer)obj;
    }

    public void setGaugeSetAlignment(int alignment) {
        if (alignment < 0 || alignment > 15) {
            this.getErrorHandler().log("invalid gauge set alignment", this.getClass().getName(), m_method_setGaugeSetAlignment);
            return;
        }
        this.setGaugeSetAttribute("GaugeSetAlignment", new Integer(alignment));
    }

    public int getGaugeSetColumnCount() {
        Object obj = this.getGaugeSetAttribute("GaugeSetColumnCount");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getGaugeSetColumnCount());
        }
        return (Integer)obj;
    }

    public void setGaugeSetColumnCount(int columns) {
        if (columns < -1) {
            this.getErrorHandler().log("invalid gauge set column count", this.getClass().getName(), m_method_setGaugeSetColumnCount);
            return;
        }
        this.setGaugeSetAttribute("GaugeSetColumnCount", new Integer(columns));
    }

    public int getGaugeSetDirection() {
        Object obj = this.getGaugeSetAttribute("GaugeSetDirection");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getGaugeSetDirection());
        }
        return (Integer)obj;
    }

    public void setGaugeSetDirection(int direction) {
        if (direction < 0 || direction > 1) {
            this.getErrorHandler().log("invalid gauge set direction", this.getClass().getName(), m_method_setGaugeSetDirection);
            return;
        }
        this.setGaugeSetAttribute("GaugeSetDirection", new Integer(direction));
    }

    public int getAngleExtent() {
        Object obj = this.getAttribute("AngleExtent");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getAngleExtent());
        }
        return (Integer)obj;
    }

    public void setAngleExtent(int extent) {
        if (extent < 0 || extent > 360) {
            this.getErrorHandler().log("invalid angle extent", this.getClass().getName(), m_method_setAngleExtent);
            return;
        }
        this.setAttribute("AngleExtent", new Integer(extent));
    }

    public String getCustomShapesPath() {
        String path = (String)this.getAttribute("CustomShapesPath");
        return path;
    }

    public void setCustomShapesPath(String path) {
        this.setAttribute("CustomShapesPath", path);
    }

    public int getVisualEffects() {
        Object obj = this.getAttribute("VisualEffects");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getVisualEffects());
        }
        return (Integer)obj;
    }

    public void setVisualEffects(int effects) {
        if (effects < 0 || effects > 1) {
            this.getErrorHandler().log("invalid visual effects setting", this.getClass().getName(), "setVisualEffects");
            return;
        }
        this.setAttribute("VisualEffects", new Integer(effects));
    }

    public int getCustomLayout() {
        Object obj = this.getAttribute("CustomLayout");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getCustomLayout());
        }
        return (Integer)obj;
    }

    public void setCustomLayout(int layout) {
        if (layout < 0 || layout > 3) {
            this.getErrorHandler().log("invalid custom layout setting", this.getClass().getName(), "setCustomLayout");
            return;
        }
        this.setAttribute("CustomLayout", new Integer(layout));
    }

    public int getAnimationOnDataChange() {
        Object obj = this.getAttribute("AnimationOnDataChange");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getAnimationOnDataChange());
        }
        return (Integer)obj;
    }

    public void setAnimationOnDataChange(int type) {
        if (type < 0 || type > 2) {
            this.getErrorHandler().log("invalid animation type setting", this.getClass().getName(), "setAnimationOnDataChange");
            return;
        }
        this.setAttribute("AnimationOnDataChange", new Integer(type));
    }

    public int getAnimationIndicators() {
        Object obj = this.getAttribute("AnimationIndicators");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getAnimationIndicators());
        }
        return (Integer)obj;
    }

    public void setAnimationIndicators(int type) {
        if (type < 0 || type > 1) {
            this.getErrorHandler().log("invalid animation indicators setting", this.getClass().getName(), "setAnimationIndicators");
            return;
        }
        this.setAttribute("AnimationIndicators", new Integer(type));
    }

    public int getAnimationDuration() {
        Integer duration = (Integer)this.getAttribute("AnimationDuration");
        if (duration == null) {
            duration = GaugeDefaultValues.getAnimationDuration();
        }
        return duration;
    }

    public void setAnimationDuration(int duration) {
        this.setAttribute("AnimationDuration", new Integer(duration));
    }

    public int getAnimationOnDisplay() {
        Object obj = this.getAttribute("AnimationOnDisplay");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getAnimationOnDisplay());
        }
        return (Integer)obj;
    }

    public void setAnimationOnDisplay(int type) {
        if (type < 0 || type > 1) {
            this.getErrorHandler().log("invalid init effects setting", this.getClass().getName(), "setAnimationOnDisplay");
            return;
        }
        this.setAttribute("AnimationOnDisplay", new Integer(type));
    }

    public Color getAnimationUpColor() {
        Color clr = (Color)this.getAttribute("AnimationUpColor");
        if (clr == null) {
            clr = GaugeDefaultValues.getAnimationUpColor();
        }
        return clr;
    }

    public void setAnimationUpColor(Color color) {
        this.setAttribute("AnimationUpColor", color);
    }

    public Color getAnimationDownColor() {
        Color clr = (Color)this.getAttribute("AnimationDownColor");
        if (clr == null) {
            clr = GaugeDefaultValues.getAnimationDownColor();
        }
        return clr;
    }

    public void setAnimationDownColor(Color color) {
        this.setAttribute("AnimationDownColor", color);
    }

    @Override
    public void setDVTResources(DVTResources res) {
        this.m_dvtResources = res;
    }

    public static int convertNumberTypeToInt(String type) {
        int nType = 0;
        if (type.equals(nt_percent)) {
            nType = 1;
        }
        return nType;
    }

    public static String convertNumberTypeToString(int type) {
        String nType = nt_number;
        if (type == 1) {
            nType = nt_percent;
        }
        return nType;
    }

    public int getGaugeType() {
        Object obj = this.getGaugeSetAttribute(a_gaugeType);
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getGaugeType());
        }
        return (Integer)obj;
    }

    public void setGraphicAntialiasing(boolean value) {
        this.setGaugeSetAttribute("graphicAntialiasing", new Boolean(value));
    }

    public boolean isGraphicAntialiasing() {
        Object obj = this.getGaugeSetAttribute("graphicAntialiasing");
        if (obj == null) {
            obj = new Boolean(GaugeDefaultValues.isGraphicAntialiasing());
        }
        return (Boolean)obj;
    }

    public void setTextAntialiasing(boolean value) {
        this.setGaugeSetAttribute("textAntialiasing", new Boolean(value));
    }

    public boolean isTextAntialiasing() {
        Object obj = this.getGaugeSetAttribute("textAntialiasing");
        if (obj == null) {
            obj = new Boolean(GaugeDefaultValues.isTextAntialiasing());
        }
        return (Boolean)obj;
    }

    public void setGaugeType(int type) {
        if (type < 0 || type > 5) {
            this.getErrorHandler().log("invalid gauge type", this.getClass().getName(), m_method_setGaugeType);
            return;
        }
        this.setGaugeSetAttribute(a_gaugeType, new Integer(type));
    }

    public int getSpecularHighlight() {
        Object obj = this.getAttribute("SpecularHighlight");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getSpecularHighlight());
        }
        return (Integer)obj;
    }

    public void setSpecularHighlight(int style) {
        if (style < 0 || style > 1) {
            this.getErrorHandler().log("invalid SpecularHighlight Option", this.getClass().getName(), m_method_setSpecularHighlight);
            return;
        }
        this.setAttribute("SpecularHighlight", new Integer(style));
    }

    public static int convertGaugeTypeToInt(String type) {
        int gType = 0;
        if (type.equals(STATUSMETER_NAME)) {
            gType = 1;
        } else if (type.equals(LED_NAME)) {
            gType = 2;
        } else if (type.equals(VENN_NAME)) {
            gType = 3;
        } else if (type.equals(VERTICALSTATUSMETER_NAME)) {
            gType = 4;
        } else if (type.equals(LABELGAUGE_NAME)) {
            gType = 5;
        }
        return gType;
    }

    public static String convertGaugeTypeToString(int type) {
        String gType = DIAL_NAME;
        if (type == 1) {
            gType = STATUSMETER_NAME;
        } else if (type == 2) {
            gType = LED_NAME;
        } else if (type == 4) {
            gType = VERTICALSTATUSMETER_NAME;
        } else if (type == 3) {
            gType = VENN_NAME;
        } else if (type == 5) {
            gType = LABELGAUGE_NAME;
        }
        return gType;
    }

    public int getLEDStyle() {
        Object obj = this.getAttribute("LEDStyle");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getLEDStyle());
        }
        return (Integer)obj;
    }

    public void setLEDStyle(int style) {
        if (style < 0 || style > 6) {
            this.getErrorHandler().log("invalid LED style", this.getClass().getName(), m_method_setLEDStyle);
            return;
        }
        this.setAttribute("LEDStyle", new Integer(style));
    }

    public int getThresholdDialStyle() {
        Object obj = this.getAttribute("ThresholdDialStyle");
        if (obj == null) {
            obj = new Integer(GaugeDefaultValues.getThresholdDialStyle());
        }
        return (Integer)obj;
    }

    public void setThresholdDialStyle(int style) {
        if (style < 0 || style > 2) {
            this.getErrorHandler().log("invalid ThresholdDialStyle style", this.getClass().getName(), "setThresholdDialStyle");
            return;
        }
        this.setAttribute("ThresholdDialStyle", new Integer(style));
    }

    public LEDStyleCallback getLEDStyleCallback() {
        return (LEDStyleCallback)this.getAttribute("LEDStyleCallback");
    }

    public void setLEDStyleCallback(LEDStyleCallback callback) {
        this.setAttribute("LEDStyleCallback", callback);
    }

    public static int convertLEDStyleToInt(String style) {
        int styleName = 0;
        if (style.equals(ls_kpi)) {
            styleName = 1;
        } else if (style.equals(ls_arrow)) {
            styleName = 2;
        } else if (style.equals(ls_triangle)) {
            styleName = 3;
        } else if (style.equals(ls_custom)) {
            styleName = 4;
        } else if (style.equals(ls_rectangle)) {
            styleName = 5;
        }
        return styleName;
    }

    public static String convertLEDStyleToString(int style) {
        String styleName = ls_dot;
        switch (style) {
            case 1: {
                styleName = ls_kpi;
                break;
            }
            case 2: {
                styleName = ls_arrow;
                break;
            }
            case 3: {
                styleName = ls_triangle;
                break;
            }
            case 4: {
                styleName = ls_custom;
                break;
            }
            case 5: {
                styleName = ls_rectangle;
                break;
            }
        }
        return styleName;
    }

    public static int convertSpecularHighlightToInt(String style) {
        int styleName = GaugeDefaultValues.getSpecularHighlight();
        if (style.equals(sh_on)) {
            styleName = 0;
        } else if (style.equals(sh_off)) {
            styleName = 1;
        }
        return styleName;
    }

    public static String convertSpecularHighlightToString(int style) {
        String styleName = sh_on;
        if (style == 0) {
            styleName = sh_on;
        } else if (style == 1) {
            styleName = sh_off;
        }
        return styleName;
    }

    public static int convertTDStyleToInt(String style) {
        int styleName = 0;
        if (style.equals(tds_ring)) {
            styleName = 1;
        } else if (style.equals(tds_segments)) {
            styleName = 2;
        }
        return styleName;
    }

    public static String convertTDStyleToString(int style) {
        String styleName = tds_pie;
        switch (style) {
            case 1: {
                styleName = tds_ring;
            }
            case 2: {
                styleName = tds_segments;
                break;
            }
        }
        return styleName;
    }

    public static int convertCustomLayoutToInt(String type) {
        int styleName = 0;
        if (type != null && type.contains(cl_title_separator)) {
            ++styleName;
        }
        if (type != null && type.contains(cl_outer_frame)) {
            styleName += 2;
        }
        return styleName;
    }

    public static String convertCustomLayoutToString(int type) {
        String styleName = "";
        if ((type & 1) > 0) {
            styleName = styleName + cl_title_separator;
        }
        if ((type & 2) > 0) {
            styleName = styleName + cl_outer_frame;
        }
        if (styleName.length() > 0) {
            return styleName;
        }
        return cl_none;
    }

    @Override
    public void setDataAccess(DataAccess dataAccess) {
        super.setDataAccess(dataAccess);
        this.m_isUsingExternalData = (dataAccess != null && dataAccess instanceof LocalXMLDataSource) ^ true;
        this.setRecalcState(2);
    }

    @Override
    public void setDataDirector(DataDirector dataDirector) {
        super.setDataDirector(dataDirector);
        this.m_isUsingExternalData = (dataDirector != null && dataDirector instanceof LocalXMLDataSource) ^ true;
        this.setRecalcState(2);
    }

    public DataSpecification getDataSpecification() {
        return this.m_dataSpecs;
    }

    public void setDataSpecification(DataSpecification dataSpec) {
        boolean changed = false;
        if (dataSpec == null) {
            if (this.m_dataSpecs != null) {
                this.m_dataSpecs = null;
                changed = true;
            }
        } else if (!dataSpec.equals(this.m_dataSpecs)) {
            this.m_dataSpecs = dataSpec;
            this.m_dataSpecs.setCommonGauge(this);
            changed = true;
        }
        if (changed) {
            this.setRecalcState(2);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle();
    }

    public boolean getGaugeFontXML(ObjectNode node, Font font, Font defFont, Color color, Color defColor) {
        boolean nodeChanged = false;
        if (!font.getName().equals(defFont.getName())) {
            node.addProperty("name", font.getName());
            nodeChanged = true;
        }
        if (font.getSize() != defFont.getSize()) {
            node.addProperty("size", font.getSize());
            nodeChanged = true;
        }
        if (!color.equals(defColor)) {
            node.addProperty("fontColor", PresUtils.toHexStringWithAlpha(color.getRGB()));
        }
        if (font.isBold() != defFont.isBold()) {
            node.addProperty("bold", font.isBold());
            nodeChanged = true;
        }
        if (font.isItalic() != defFont.isItalic()) {
            node.addProperty("italic", font.isItalic());
            nodeChanged = true;
        }
        if (font.getAttributes().get(TextAttribute.UNDERLINE) != null) {
            node.addProperty("underline", true);
            nodeChanged = true;
        }
        return nodeChanged;
    }

    public void setGaugeFontXML(BaseObjectNode node, String attrName) {
        this.setGaugeFontXML(node, attrName, null);
    }

    public void setGaugeFontXML(BaseObjectNode node, String attrName, HashMap map) {
        PropertyNode pNode;
        HashMap<TextAttribute, Object> fontAttrs = new HashMap<TextAttribute, Object>();
        HashMap<String, Object> jsfMap = null;
        if (map != null) {
            jsfMap = new HashMap<String, Object>();
        }
        if ((pNode = node.getProperty("name")) != null) {
            if (jsfMap != null) {
                jsfMap.put("name", pNode.getValueAsString());
            } else {
                fontAttrs.put(TextAttribute.FAMILY, pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("size")) != null) {
            if (jsfMap != null) {
                jsfMap.put("size", new Float(pNode.getValueAsString()));
            } else {
                fontAttrs.put(TextAttribute.SIZE, new Float(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("fontColor")) != null) {
            if (jsfMap != null) {
                jsfMap.put("fontColor", DataviewUtils.hexStringToColor(pNode.getValueAsString()));
            } else {
                Color newClr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                if (attrName.equals("TopLabelFont")) {
                    this.getTopLabel().setFontColor(newClr);
                } else if (attrName.equals("BottomLabelFont")) {
                    this.getBottomLabel().setFontColor(newClr);
                } else if (attrName == "MetricLabelFont") {
                    this.getMetricLabel().setFontColor(newClr);
                } else if (attrName == "LegendTextFont") {
                    this.getLegendText().setFontColor(newClr);
                } else if (attrName == "LegendTitleFont") {
                    this.getLegendTitle().setFontColor(newClr);
                } else {
                    this.getTickLabel().setFontColor(newClr);
                }
            }
        }
        if ((pNode = node.getProperty("bold")) != null) {
            boolean isBold = pNode.getValueAsBoolean();
            if (jsfMap != null) {
                jsfMap.put("bold", isBold);
            } else if (isBold) {
                fontAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
        }
        if ((pNode = node.getProperty("italic")) != null) {
            boolean isItalic = pNode.getValueAsBoolean();
            if (jsfMap != null) {
                jsfMap.put("italic", isItalic);
            } else {
                fontAttrs.put(TextAttribute.POSTURE, isItalic ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            }
        }
        if ((pNode = node.getProperty("underline")) != null) {
            boolean isUnderline = pNode.getValueAsBoolean();
            if (jsfMap != null) {
                jsfMap.put("underline", isUnderline);
            } else if (isUnderline) {
                fontAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
        }
        if (map == null) {
            if (attrName == "LegendTextFont" || attrName == "LegendTitleFont") {
                this.setGaugeSetAttribute(attrName, new Font(fontAttrs));
            } else {
                this.setAttribute(attrName, new Font(fontAttrs));
            }
        } else {
            map.put(attrName, jsfMap);
        }
    }

    @Override
    public DataviewTitles getDataviewFootnote() {
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            return view.getDataviewFootnote();
        }
        if (this.m_dataviewFootnote == null) {
            this.m_dataviewFootnote = new CommonBaseTitle("", this, 8);
        }
        return this.m_dataviewFootnote;
    }

    @Override
    public DataviewTitles getDataviewSubtitle() {
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            return view.getDataviewSubtitle();
        }
        if (this.m_dataviewSubtitle == null) {
            this.m_dataviewSubtitle = new CommonBaseTitle("", this, 7);
        }
        return this.m_dataviewSubtitle;
    }

    @Override
    public DataviewTitles getDataviewTitle() {
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            return view.getDataviewTitle();
        }
        if (this.m_dataviewTitle == null) {
            this.m_dataviewTitle = new CommonBaseTitle("", this, 6);
        }
        return this.m_dataviewTitle;
    }

    public ComponentHandle getGaugeComponentHandle(int objID, int row, int column) {
        ComponentHandle componentID = null;
        switch (objID) {
            case 10: {
                componentID = new NonDataComponentHandle(10, "Background", this.m_background);
                break;
            }
            case 24: {
                componentID = new NonDataComponentHandle(24, NAME_GAUGEFRAME, this.m_gaugeFrame);
                break;
            }
            case 11: {
                componentID = new NonDataComponentHandle(11, NAME_PLOTAREA, this.m_plotArea);
                break;
            }
            case 25: {
                componentID = new NonDataComponentHandle(25, NAME_UPPERLABELFRAME, this.m_upLblFrame);
                break;
            }
            case 26: {
                componentID = new NonDataComponentHandle(26, NAME_LOWERLABELFRAME, this.m_lowLblFrame);
                break;
            }
            case 12: {
                componentID = new NonDataComponentHandle(12, NAME_TICKLABEL, this.m_tickLabel);
                break;
            }
            case 13: {
                componentID = new NonDataComponentHandle(13, NAME_TICKMARK, this.m_tickMark);
                break;
            }
            case 14: {
                componentID = new DataComponentHandle(14, NAME_INDICATOR, (Object)this.m_indicator, row, column);
                break;
            }
            case 15: {
                componentID = new DataComponentHandle(15, NAME_THRESHOLD, (Object)this.m_threshold, row, column);
                break;
            }
            case 16: {
                componentID = new DataComponentHandle(16, NAME_TOPLABEL, (Object)this.m_topLabel, row, column);
                break;
            }
            case 17: {
                componentID = new DataComponentHandle(17, NAME_BOTTOMLABEL, (Object)this.m_bottomLabel, row, column);
                break;
            }
            case 18: {
                componentID = new DataComponentHandle(18, NAME_METRICLABEL, (Object)this.m_metricLabel, row, column);
                break;
            }
            case 27: {
                componentID = new NonDataComponentHandle(27, NAME_LEGENDAREA, this.m_legendArea);
                break;
            }
            case 28: {
                componentID = new NonDataComponentHandle(27, NAME_LEGENDTEXT, this.m_legendText);
                break;
            }
            case 29: {
                componentID = new NonDataComponentHandle(29, NAME_LEGENDTITLE, this.m_legendTitle);
                break;
            }
            case 19: {
                componentID = new DataComponentHandle(19, "ElementA", (Object)this.m_elementA, row, column);
                break;
            }
            case 20: {
                componentID = new DataComponentHandle(20, "ElementB", (Object)this.m_elementB, row, column);
                break;
            }
            case 21: {
                componentID = new DataComponentHandle(21, "IntersectionAB", (Object)this.m_intersectionAB, row, column);
                break;
            }
        }
        return componentID;
    }

    @Override
    public String getAlternativeText(ComponentHandle handle) {
        return "";
    }

    @Override
    public int[] getDrillParameters(ComponentHandle handle) {
        return null;
    }

    public ComponentHandle getSelectedObject() {
        return this.m_selObj;
    }

    public String getToolTipText(MouseEvent e) {
        Point pt = e.getPoint();
        for (GaugeSetKey key : this.m_gaugeEngines.keySet()) {
            Rectangle bounds = key.getBounds();
            GaugeEngine engine = (GaugeEngine)this.m_gaugeEngines.get(key);
            if (!bounds.contains(pt)) continue;
            return engine.getToolTipText(pt);
        }
        return null;
    }

    @Override
    public boolean isXMLValidated() {
        return this.m_validateXML;
    }

    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = new XMLObjectReader(xmlString);
        return this._setXML(reader, reset);
    }

    public boolean readXML(InputStream stream, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = new XMLObjectReader(stream);
        return this._setXML(reader, reset);
    }

    public boolean selectObject(MouseEvent e) {
        Point pt = e.getPoint();
        boolean found = false;
        int foundType = -1;
        Iterator i = this.m_gaugeEngines.keySet().iterator();
        while (i.hasNext()) {
            GaugeSetKey key = (GaugeSetKey)i.next();
            Rectangle bounds = key.getBounds();
            GaugeEngine engine = (GaugeEngine)this.m_gaugeEngines.get(key);
            if (found) {
                engine.setSelectedObject(foundType);
                continue;
            }
            if (!bounds.contains(pt)) continue;
            found = true;
            foundType = engine.selectObject(pt);
            this.m_selObj = this.getGaugeComponentHandle(foundType, (Integer)engine.getAttribute(DS_ROW), (Integer)engine.getAttribute(DS_COLUMN));
            i = this.m_gaugeEngines.keySet().iterator();
        }
        return found;
    }

    public boolean setSelectedObject(int compID, int row, int column) {
        boolean oneGauge = false;
        if (row != -1 && column != -1) {
            oneGauge = true;
        }
        if (this.m_gaugeEngines != null && this.m_gaugeEngines.size() > 0) {
            int gaugeRow = -1;
            int gaugeColumn = -1;
            for (GaugeSetKey key : this.m_gaugeEngines.keySet()) {
                GaugeEngine engine = (GaugeEngine)this.m_gaugeEngines.get(key);
                if (oneGauge) {
                    gaugeRow = (Integer)engine.getAttribute(DS_ROW);
                    gaugeColumn = (Integer)engine.getAttribute(DS_COLUMN);
                    if (row == gaugeRow && column == gaugeColumn) {
                        engine.setSelectedObject(compID);
                    }
                }
                engine.setSelectedObject(compID);
            }
            this.m_selObj = this.getGaugeComponentHandle(compID, row, column);
            ThickDataview view = this.getThickDataview();
            if (view != null) {
                view.repaint();
            }
            return true;
        }
        return false;
    }

    public boolean setGridData(Object[] specs, Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        boolean retval = super.setGridData(columnLabels, rowLabels, data, false);
        if (specs == null || specs.length == 0) {
            this.getErrorHandler().log("specification list null", this.getClass().getName(), m_method_setGridData);
        }
        DataSpecification dataSpecs = null;
        if (specs != null && specs.length > 0) {
            dataSpecs = this._createDataSpecsFromLabels(specs, columnLabels);
        }
        if (dataSpecs != null) {
            this.setDataSpecification(dataSpecs);
        } else {
            this.setDataSpecification(new DataSpecification());
        }
        return retval;
    }

    public boolean setTabularData(Object[] specs, List tableRows) {
        if (specs == null || specs.length == 0) {
            this.getErrorHandler().log("specification list null", this.getClass().getName(), m_method_setTabularData);
        }
        boolean retval = super.setTabularData(tableRows, false);
        DataSpecification dataSpecs = null;
        if (specs != null && specs.length > 0) {
            Object[] colLabels = this._getSliceLabels(0, 0);
            dataSpecs = this._createDataSpecsFromLabels(specs, colLabels);
        }
        if (dataSpecs != null) {
            this.setDataSpecification(dataSpecs);
        } else {
            this.setDataSpecification(new DataSpecification());
        }
        return retval;
    }

    @Override
    public void exportToPNG(OutputStream os) {
        try {
            this.exportToPNGWithException(os);
        }
        catch (PNGInvalidParameterException pipe) {
            this.getErrorHandler().log("Encoder creation failed: " + pipe.getMessage(), this.getClass().getName(), m_method_exportToPNG);
        }
        catch (PNGException pe) {
            this.getErrorHandler().log("PNG encoding failed: " + pe.getMessage(), this.getClass().getName(), m_method_exportToPNG);
        }
    }

    @Override
    public void exportToPNGWithException(OutputStream os) throws PNGInvalidParameterException, PNGException {
        if (!this._isImageValid()) {
            this._generateImage(true);
        }
        this.renderGauges((Graphics2D)this.m_currImage.getGraphics());
        this._writeToPNG(os);
    }

    @Override
    public void setSVGWriterProvider(SVGWriterProvider provider) {
        this.m_SVGWriterProvider = provider;
    }

    @Override
    public SVGWriterProvider getSVGWriterProvider() {
        return this.m_SVGWriterProvider;
    }

    @Override
    public void setSvgHeaders(int headers) {
        this.m_svgHeaders = headers;
    }

    @Override
    public int getSvgHeaders() {
        return this.m_svgHeaders;
    }

    @Override
    public List getSvgScriptIdList() {
        return this.m_svgScriptIdList;
    }

    @Override
    public void exportToSVG(OutputStream os, int mode, String charEnc) {
        try {
            this.exportToSVGWithException(os, mode, charEnc);
        }
        catch (IOException ioe) {
            this.getErrorHandler().log(ioe.getMessage(), this.getClass().getName(), "exportToSVG(OutputStream os, int mode, String charEnc)");
        }
        catch (Exception e) {
            this.getErrorHandler().log(e.getMessage(), this.getClass().getName(), "exportToSVG(OutputStream os, int mode, String charEnc)");
        }
    }

    @Override
    public void exportToFlash(OutputStream os, boolean renderDynamic, boolean showDrawing) {
        try {
            SWFDocument document = new SWFDocument();
            this.m_gaugeFlashWriter = new GaugeFlashRenderer(document, this, renderDynamic);
            this._renderGaugesToFlash(this.m_gaugeFlashWriter);
            if (renderDynamic) {
                this.m_gaugeFlashWriter.generateActionScript("as/dial_gauge.swf");
            } else {
                this.m_gaugeFlashWriter.generateActionScript(SERVER_SWF_RESOURCE, false);
            }
            ThickDataview view = this.getThickDataview();
            Dimension imageSize = view != null ? ((ThickGauge)view).getSize() : this.getImageSize();
            Rectangle frameRect = new Rectangle(imageSize);
            document.setFrameSize(new Rect((long)(frameRect.getX() * 20.0), (long)(frameRect.getX() * 20.0 + frameRect.getWidth() * 20.0), (long)(frameRect.getY() * 20.0), (long)(frameRect.getY() * 20.0 + frameRect.getHeight() * 20.0)));
            DoAction action = new DoAction();
            if (!renderDynamic && showDrawing) {
                action.addAction(new GoToFrame(document.getFrameCount() - 1));
                document.addTag(action);
            } else {
                document.addTag(new ShowFrame());
            }
            SWFWriter writer = new SWFWriter(document, os);
            writer.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GaugeFlashRenderer getGaugeFlashRenderer() {
        return this.m_gaugeFlashWriter;
    }

    @Override
    public void exportToSVGWithException(OutputStream os, int mode, String charEnc) throws IOException, Exception {
        GaugeSVGWriter writer = this.createSVGWriter(os, charEnc);
        this._renderGaugesToSVG(writer, mode, charEnc);
        writer.close();
    }

    @Override
    public void exportToSVG(Writer writer, int mode, String charEnc) {
        try {
            this.exportToSVGWithException(writer, mode, charEnc);
        }
        catch (IOException ioe) {
            this.getErrorHandler().log(ioe.getMessage(), this.getClass().getName(), "exportToSVG(Writer writer, int mode, String charEnc)");
        }
        catch (Exception e) {
            this.getErrorHandler().log(e.getMessage(), this.getClass().getName(), "exportToSVG(Writer writer, int mode, String charEnc)");
        }
    }

    @Override
    public void exportToSVGWithException(Writer writer, int mode, String charEnc) throws IOException, Exception {
        GaugeSVGWriter svgWriter = this.createSVGWriter(writer, charEnc);
        this._renderGaugesToSVG(svgWriter, mode, charEnc);
        svgWriter.close();
    }

    @Override
    public void exportToXMLWithException(OutputStream os, int mode, String charEnc) throws IOException, Exception {
        GaugeExportXMLWriter writer = this.createExportXMLWriter(os, charEnc);
        this._renderGaugesToXML(writer, mode, charEnc);
        writer.close();
    }

    @Override
    public void exportToXMLWithException(Writer writer, int mode, String charEnc) throws IOException, Exception {
        GaugeExportXMLWriter xmlWriter = this.createExportXMLWriter(writer, charEnc);
        this._renderGaugesToXML(xmlWriter, mode, charEnc);
        xmlWriter.close();
    }

    private void _renderGaugesToSVG(GaugeSVGWriter writer, int mode, String charEnc) {
        boolean bFontEmbedding;
        boolean bHeader = (mode & 1) != 0 && this.getSvgHeaders() == -1;
        boolean bTooltips = (mode & 2) != 0;
        boolean bl = bFontEmbedding = (mode & 0x20) != 0;
        if (writer == null) {
            this.getErrorHandler().log("Couldn't write SVG, error: SVG writer is null.", this.getClass().getName(), "_renderGaugesToSVG(GaugeSVGWriter writer, int mode, String charEnc)");
        } else {
            try {
                ThickDataview view;
                writer.setFontEmbedding(bFontEmbedding);
                if (bHeader) {
                    writer.writeSVGHeader();
                }
                Dimension imageSize = (view = this.getThickDataview()) != null ? ((ThickGauge)view).getSize() : this.getImageSize();
                if (writer.startSVGElement()) {
                    writer.writeAttribute("width", imageSize.width);
                    writer.writeAttribute("height", imageSize.height);
                    if (bTooltips) {
                        writer.writeTooltipsScript();
                    }
                    if (this.m_dataLinks != null) {
                        writer.writeLinkScript();
                    }
                    this.renderGauges(writer, mode);
                    if (!this._isImageValid()) {
                        this._generateImage(false);
                    }
                    if (writer.isFontEmbedding()) {
                        writer.writeEmbeddedFonts(this.m_currImage.getGraphics());
                    }
                    writer.endElement();
                }
            }
            catch (IOException ioe) {
                this.getErrorHandler().log(ioe.getMessage(), this.getClass().getName(), "_renderGaugesToSVG(GaugeSVGWriter writer, int mode, String charEnc)");
            }
            catch (Exception e) {
                this.getErrorHandler().log(e.getMessage(), this.getClass().getName(), "_renderGaugesToSVG(GaugeSVGWriter writer, int mode, String charEnc)");
            }
            this.m_svgScriptIdList = writer.getScriptIdList();
        }
    }

    private void _renderGaugesToXML(GaugeExportXMLWriter writer, int mode, String charEnc) {
        if (writer == null) {
            this.getErrorHandler().log("Couldn't write XML, error: XML writer is null.", this.getClass().getName(), "_renderGaugesToXML(GaugeExportXMLWriter writer, int mode, String charEnc)");
        } else {
            try {
                ThickDataview view = this.getThickDataview();
                Dimension imageSize = view != null ? ((ThickGauge)view).getSize() : this.getImageSize();
                if (writer.startRootElement()) {
                    if (writer.startGaugeSetElement(imageSize, this.getGaugeType())) {
                        this.renderGauges(writer, mode);
                        writer.endElement();
                    }
                    writer.endElement();
                }
            }
            catch (IOException ioe) {
                this.getErrorHandler().log(ioe.getMessage(), this.getClass().getName(), "_renderGaugesToXML(GaugeExportXMLWriter writer, int mode, String charEnc)");
            }
            catch (Exception e) {
                this.getErrorHandler().log(e.getMessage(), this.getClass().getName(), "_renderGaugesToXML(GaugeExportXMLWriter writer, int mode, String charEnc)");
            }
        }
    }

    private void _renderGaugesToFlash(GaugeFlashRenderer writer) {
        if (writer == null) {
            this.getErrorHandler().log("Couldn't write Flash, error: Flash Document is null.", this.getClass().getName(), "exportToFlash(OutputStream os)");
        } else {
            try {
                this._renderGauges(null, writer);
            }
            catch (Exception e) {
                this.getErrorHandler().log(e.getMessage(), this.getClass().getName(), "exportToFlash(OutputStream os)");
                e.printStackTrace();
            }
        }
    }

    private void _renderGauges(Graphics2D g2d, GaugeFlashRenderer writer) {
        HashMap sfxMap;
        Color gsbBorderColor;
        Color gsbColor;
        Dimension imageSize;
        this.prepareGauges();
        writer.init();
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            imageSize = ((ThickGauge)view).getSize();
            if (imageSize.width == 0 && imageSize.width == 0) {
                imageSize = this.getImageSize();
            }
        } else {
            imageSize = this.getImageSize();
        }
        if ((gsbColor = (Color)this.getGaugeSetAttribute("GaugeSetBackgroundFillColor")) == null) {
            gsbColor = GaugeDefaultValues.getGaugeSetFillColor();
        }
        if ((gsbBorderColor = (Color)this.getGaugeSetAttribute("GaugeSetBackgroundBorderColor")) == null) {
            gsbBorderColor = GaugeDefaultValues.getGaugeSetBorderColor();
        }
        if ((sfxMap = (HashMap)this.getGaugeSetAttribute("GaugeSetBackgroundSFX")) == null) {
            sfxMap = GaugeDefaultValues.getGaugeSetSFX();
        }
        boolean gCreated = false;
        Rectangle clipBounds = new Rectangle(0, 0, imageSize.width - 1, imageSize.height - 1);
        GaugeRenderer renderer = writer;
        if (g2d != null) {
            renderer = new Graphics2DRenderer(g2d, this.m_eh);
        } else {
            renderer = writer;
            BufferedImage image = new BufferedImage(1, 1, 2);
            g2d = (Graphics2D)((Image)image).getGraphics();
            gCreated = true;
        }
        DrawableObject.Shape gsBackObj = new DrawableObject.Shape(23, clipBounds, gsbBorderColor, gsbColor, sfxMap, null);
        gsBackObj.render(renderer);
        this.renderLegend(renderer, g2d, clipBounds);
        Rectangle2D legRect = this._getLegendAreaFrame(g2d, clipBounds);
        int legPos = this.getLegendArea().getPosition();
        Rectangle2D.Double gsRect = legPos == 3 ? new Rectangle2D.Double((double)clipBounds.x + legRect.getWidth() + 5.0, clipBounds.y, (double)clipBounds.width - legRect.getWidth() - 5.0, clipBounds.height) : (legPos == 2 ? new Rectangle2D.Double(clipBounds.x, clipBounds.y, (double)clipBounds.width - legRect.getWidth() - 5.0, clipBounds.height) : (legPos == 0 ? new Rectangle2D.Double(clipBounds.x, (double)clipBounds.y + legRect.getHeight() + 5.0, clipBounds.width, (double)clipBounds.height - legRect.getHeight() - 5.0) : new Rectangle2D.Double(clipBounds.x, clipBounds.y, clipBounds.width, (double)clipBounds.height - legRect.getHeight() - 5.0)));
        double gaugeWidth = ((RectangularShape)gsRect).getWidth() / (double)this.m_gsNumWide;
        double gaugeHeight = ((RectangularShape)gsRect).getHeight() / (double)this.m_gsNumTall;
        int gaugeCount = 0;
        int align = this.getGaugeSetAlignment();
        double setWidth = gaugeWidth * (double)this.m_gsNumWide - 1.0;
        double setHeight = gaugeHeight * (double)this.m_gsNumTall - 1.0;
        double currX = ((RectangularShape)gsRect).getX();
        double currY = ((RectangularShape)gsRect).getY();
        double startX = currX;
        double endX = currX + (double)imageSize.width;
        if (align != 0) {
            Dimension newSize = this.getOptimalGaugeSize(new Dimension((int)gaugeWidth, (int)gaugeHeight));
            if ((align & 0xA) != 0) {
                gaugeWidth = newSize.width;
                setWidth = gaugeWidth * (double)this.m_gsNumWide - 1.0;
            }
            if ((align & 5) != 0) {
                gaugeHeight = newSize.height;
                setHeight = gaugeHeight * (double)this.m_gsNumTall - 1.0;
            }
            if (align == 15) {
                startX = (double)(imageSize.width / 2) - setWidth / 2.0;
                endX = setWidth;
                currY = (double)(imageSize.height / 2) - setHeight / 2.0;
            } else {
                if ((align & 2) != 0) {
                    endX = setWidth;
                } else if ((align & 8) != 0) {
                    startX = (double)imageSize.width - setWidth;
                    endX = startX + setWidth;
                }
                if ((align & 4) != 0) {
                    currY += (double)imageSize.height - setHeight;
                }
            }
            currX = startX;
        }
        int x = 0;
        while (x < this.m_gsNumTall) {
            int y = 0;
            while (y < this.m_gsNumWide) {
                GaugeSetKey gk = this._getGaugeSetKey(x, y);
                GaugeEngine ge = (GaugeEngine)this.m_gaugeEngines.get(gk);
                g2d.setClip((int)currX, (int)currY, (int)gaugeWidth, (int)gaugeHeight);
                gk.setBounds(new Rectangle((int)currX, (int)currY, (int)gaugeWidth, (int)gaugeHeight));
                int indicatorType = 0;
                Color indicatorColor = null;
                if (ge != null && writer != null) {
                    if (writer.isRenderDynamicOn()) {
                        RangeGauge gauge = new RangeGauge(x, y);
                        gauge.setMinValue(ge.getMin());
                        gauge.setMaxValue(ge.getMax());
                        gauge.setMetricValue(ge.getMetric());
                        indicatorType = ge.getAttribute("IndicatorType") != null ? (Integer)ge.getAttribute("IndicatorType") : GaugeDefaultValues.getIndicatorType();
                        gauge.setIndicatorType(indicatorType);
                        indicatorColor = ge.getAttribute("IndicatorFillColor") != null ? (Color)ge.getAttribute("IndicatorFillColor") : GaugeDefaultValues.getIndicatorFillColor();
                        if (indicatorType == 0) {
                            gauge.setIndicatorFillColor(indicatorColor.darker().getRGB());
                        } else {
                            gauge.setIndicatorFillColor(indicatorColor.getRGB());
                        }
                        indicatorColor = ge.getAttribute("IndicatorBorderColor") != null ? (Color)ge.getAttribute("IndicatorBorderColor") : GaugeDefaultValues.getIndicatorBorderColor();
                        if (indicatorType == 0) {
                            gauge.setIndicatorBorderColor(indicatorColor.getRGB());
                        } else {
                            gauge.setIndicatorBorderColor(indicatorColor.getRGB());
                        }
                        writer.setMCObj(gauge);
                    }
                    ge.render(g2d, writer);
                }
                if ((currX += gaugeWidth) >= endX || y == this.m_gsNumWide - 1) {
                    currX = startX;
                    currY += gaugeHeight;
                }
                ++gaugeCount;
                ++y;
            }
            ++x;
        }
        if (gCreated) {
            g2d.dispose();
            g2d = null;
        }
    }

    @Override
    public void refreshData() {
        this.setRecalcState(2);
    }

    public Object getAttribute(String name) {
        Object value;
        Map attrMap;
        if (this.m_hashMapMode == 0 && this.m_gaugeAttributes != null && (attrMap = (Map)this.m_gaugeAttributes.get(GSKEY_UNDEFINED)) != null && (value = attrMap.get(name)) != null) {
            return value;
        }
        if (this.m_skinGaugeAttributes != null) {
            return this.m_skinGaugeAttributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (this.m_hashMapMode == 0) {
            Map<String, Object> currMap;
            if (this.m_gaugeAttributes.get(GSKEY_UNDEFINED) == null) {
                currMap = new HashMap(8);
                this.m_gaugeAttributes.put(GSKEY_UNDEFINED, currMap);
            } else {
                currMap = (Map)this.m_gaugeAttributes.get(GSKEY_UNDEFINED);
            }
            currMap.put(name, value);
            this.setRecalcState(1);
        } else if (this.m_hashMapMode == 1) {
            Object oldSkinValue = this.getAttribute(name);
            if (value == null && value == oldSkinValue) {
                return;
            }
            if (this.m_skinGaugeAttributes == null) {
                this.m_skinGaugeAttributes = new HashMap(3);
                this.m_skinGaugeAttributes.put(name, value);
            } else {
                this.m_skinGaugeAttributes.put(name, value);
            }
            this.setRecalcState(1);
        }
    }

    public int getGaugeCount() {
        if (this.m_gaugeEngines != null) {
            return this.m_gaugeEngines.size();
        }
        return -1;
    }

    public Object getGaugeSetAttribute(String name) {
        Object obj;
        if (this.m_hashMapMode == 0 && this.m_gaugeSetAttributes != null && (obj = this.m_gaugeSetAttributes.get(name)) != null) {
            return obj;
        }
        if (this.m_skinGaugeSetAttributes != null) {
            return this.m_skinGaugeSetAttributes.get(name);
        }
        return null;
    }

    public void setGaugeSetAttribute(String name, Object value) {
        if (this.m_hashMapMode == 0) {
            Object oldValue = this.getGaugeSetAttribute(name);
            if (this.m_gaugeSetAttributes == null) {
                this.m_gaugeSetAttributes = new HashMap(3);
                this.m_gaugeSetAttributes.put(name, value);
            } else {
                this.m_gaugeSetAttributes.put(name, value);
            }
            this.setRecalcState(1);
            this.firePropertyChange(this, name, oldValue, value);
        } else if (this.m_hashMapMode == 1) {
            Object oldSkinValue = this.getGaugeSetAttribute(name);
            if (value == null && value == oldSkinValue) {
                return;
            }
            this.setMode(0);
            Object oldValue = this.getGaugeSetAttribute(name);
            if (this.m_skinGaugeSetAttributes == null) {
                this.m_skinGaugeSetAttributes = new HashMap(3);
                this.m_skinGaugeSetAttributes.put(name, value);
            } else {
                this.m_skinGaugeSetAttributes.put(name, value);
            }
            this.setRecalcState(1);
            this.firePropertyChange(this, name, oldValue, this.getGaugeSetAttribute(name));
            this.setMode(1);
        }
    }

    public int getMode() {
        return this.m_hashMapMode;
    }

    public void setMode(int mode) {
        this.m_hashMapMode = mode;
    }

    public Dimension getOptimalGaugeSize(Dimension maxSize) {
        int maxWidth = 0;
        int maxHeight = 0;
        this.prepareGauges();
        if (this.m_gaugeEngines == null || this.m_gaugeEngines.size() == 0) {
            return maxSize;
        }
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        for (GaugeSetKey key : this.m_gaugeEngines.keySet()) {
            GaugeEngine engine = (GaugeEngine)this.m_gaugeEngines.get(key);
            Rectangle clipBounds = key.getBounds();
            if (clipBounds != null) {
                g.setClip(clipBounds);
            }
            Dimension tempSize = engine.calcGaugeSize(g, maxSize);
            if (tempSize.width > maxWidth) {
                maxWidth = tempSize.width;
            }
            if (tempSize.height <= maxHeight) continue;
            maxHeight = tempSize.height;
        }
        g.dispose();
        g = null;
        return new Dimension(maxWidth, maxHeight);
    }

    @Override
    public Dimension getImageSize() {
        if (this.m_imageSize == null) {
            this.m_imageSize = new Dimension(GaugeDefaultValues.getImageWidth(), GaugeDefaultValues.getImageHeight());
        }
        return this.m_imageSize;
    }

    @Override
    public void setImageSize(Dimension size) {
        this.m_imageSize = size;
    }

    public int getRowCount() {
        return this.m_gsNumTall;
    }

    public int getColCount() {
        return this.m_gsNumWide;
    }

    public String getFlashGaugeLCID() {
        return this.m_flashGaugeLCID;
    }

    public void setFlashGaugeLCID(String id) {
        this.m_flashGaugeLCID = id;
    }

    public String getRowLabel(int row) {
        return this._getDataLabel(1, this.m_measureLayer, row);
    }

    public String getColumnLabel(int col) {
        return this._getDataLabel(0, this.m_measureLayer, col);
    }

    protected boolean prepareGauges() {
        int recalcState = this._getRecalcState();
        if (this.m_gaugeEngines == null || this.m_gaugeEngines.isEmpty() || recalcState != 0) {
            return this._generateGaugeEngines();
        }
        return true;
    }

    public boolean renderGauges(Graphics2D g) {
        if (g == null) {
            String code = "22004";
            ResourceBundle localStrings = null;
            localStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.graph.resource.GaugeBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.graph.resource.GaugeBundle");
            String msg = this.getErrorIntlString(code, localStrings);
            throw new RuntimeException(MessageFormat.format("DVT-{0} {1}", code, msg));
        }
        if (this.isGraphicAntialiasing()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!this.isTextAntialiasing()) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        } else if (this.isTextAntialiasing()) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return this._renderGauges(g, null, 0);
    }

    public boolean renderGauges(GaugeSVGWriter writer, int mode) {
        return this._renderGauges(null, writer, mode);
    }

    public boolean renderGauges(GaugeExportXMLWriter writer, int mode) {
        return this._renderGauges(null, writer, mode);
    }

    private boolean _renderGauges(Graphics2D g2d, GaugeRenderer gaugeRenderer, int mode) {
        RectangularShape gsBackRect;
        Rectangle clipBounds;
        GaugeRenderer renderer;
        HashMap sfxMap;
        Color gsbBorderColor;
        Color gsbColor;
        String customShapesPath = this.getCustomShapesPath();
        if (customShapesPath != null) {
            String xmlPath;
            InputStream xmlStream;
            this.m_csParser = new SVGParser(this.getErrorHandler());
            this.m_csParser.parseFile(customShapesPath);
            if (customShapesPath.endsWith(".svg") && (xmlStream = CommonGauge.class.getResourceAsStream(xmlPath = customShapesPath.replace(".svg", ".xml"))) != null) {
                try {
                    this.readXML(xmlStream, 0);
                }
                catch (Exception e) {
                    this.getErrorHandler().trace("Error in parsing custom shapes xml file: " + e, "CommonGauge", "_renderGauges");
                }
            }
        }
        this.prepareGauges();
        this.m_imageMapObjList = new ArrayList();
        Dimension imageSize = new Dimension();
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            imageSize = ((ThickGauge)view).getSize();
        }
        if (view == null || imageSize.width == 0 || imageSize.height == 0) {
            imageSize = this.getImageSize();
        }
        if ((gsbColor = (Color)this.getGaugeSetAttribute("GaugeSetBackgroundFillColor")) == null) {
            gsbColor = GaugeDefaultValues.getGaugeSetFillColor();
        }
        if ((gsbBorderColor = (Color)this.getGaugeSetAttribute("GaugeSetBackgroundBorderColor")) == null) {
            gsbBorderColor = GaugeDefaultValues.getGaugeSetBorderColor();
        }
        if ((sfxMap = (HashMap)this.getGaugeSetAttribute("GaugeSetBackgroundSFX")) == null) {
            sfxMap = GaugeDefaultValues.getGaugeSetSFX();
        }
        boolean gCreated = false;
        if (g2d != null) {
            renderer = new Graphics2DRenderer(g2d, this.m_eh);
        } else {
            renderer = gaugeRenderer;
            BufferedImage image = new BufferedImage(1, 1, 2);
            g2d = (Graphics2D)((Image)image).getGraphics();
            gCreated = true;
        }
        RoundRectangle2D.Double gsClipMask = null;
        if ((this.getCustomLayout() & 2) > 0) {
            int gapSize = 15;
            clipBounds = new Rectangle(gapSize, gapSize, imageSize.width - 2 * gapSize, imageSize.height - 2 * gapSize);
            sfxMap.putAll(GaugeDefaultValues.getOuterFrameVisualEffects());
            double arcRadius = Math.min(Math.min(clipBounds.width, clipBounds.height) / 20, 25);
            gsBackRect = new RoundRectangle2D.Double(clipBounds.x, clipBounds.y, clipBounds.width - 1, clipBounds.height - 1, arcRadius, arcRadius);
            gsClipMask = gsbBorderColor != null ? new RoundRectangle2D.Double(clipBounds.x + 1, clipBounds.y + 1, clipBounds.width - 2, clipBounds.height - 2, arcRadius, arcRadius) : new RoundRectangle2D.Double(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height, arcRadius, arcRadius);
        } else {
            clipBounds = new Rectangle(0, 0, imageSize.width, imageSize.height);
            gsBackRect = new Rectangle(clipBounds.x, clipBounds.y, clipBounds.width - 1, clipBounds.height - 1);
        }
        DrawableObject.Shape gsBackObj = new DrawableObject.Shape(23, gsBackRect, gsbBorderColor, gsbColor, sfxMap, null);
        gsBackObj.render(renderer);
        this.renderLegend(renderer, g2d, clipBounds);
        Rectangle2D legRect = this._getLegendAreaFrame(g2d, clipBounds);
        int legPos = this.getLegendArea().getPosition();
        Rectangle2D.Double gsRect = this.getLegendArea().isVisible() ? (legPos == 3 ? new Rectangle2D.Double((double)clipBounds.x + legRect.getWidth() + 5.0 + 1.0, clipBounds.y, (double)clipBounds.width - legRect.getWidth() - 5.0 - 1.0, clipBounds.height) : (legPos == 2 ? new Rectangle2D.Double(clipBounds.x, clipBounds.y, (double)clipBounds.width - legRect.getWidth() - 5.0, clipBounds.height) : (legPos == 0 ? new Rectangle2D.Double(clipBounds.x, (double)clipBounds.y + legRect.getHeight() + 5.0 + 1.0, clipBounds.width, (double)clipBounds.height - legRect.getHeight() - 5.0 - 1.0) : new Rectangle2D.Double(clipBounds.x, clipBounds.y, clipBounds.width, (double)clipBounds.height - legRect.getHeight() - 5.0)))) : new Rectangle2D.Double(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        int gaugeWidth = (int)((RectangularShape)gsRect).getWidth() / this.m_gsNumWide;
        int gaugeHeight = (int)((RectangularShape)gsRect).getHeight() / this.m_gsNumTall;
        int extraWidth = (int)((RectangularShape)gsRect).getWidth() - gaugeWidth * this.m_gsNumWide;
        int extraHeight = (int)((RectangularShape)gsRect).getHeight() - gaugeHeight * this.m_gsNumTall;
        int gaugeCount = 0;
        int align = this.getGaugeSetAlignment();
        int setWidth = extraWidth + gaugeWidth * this.m_gsNumWide;
        int setHeight = extraHeight + gaugeHeight * this.m_gsNumTall;
        int currX = (int)((RectangularShape)gsRect).getX();
        int currY = (int)((RectangularShape)gsRect).getY();
        int startX = currX;
        int startY = currY;
        int endX = setWidth;
        if (align != 0) {
            Dimension newSize = this.getOptimalGaugeSize(new Dimension(gaugeWidth, gaugeHeight));
            if ((align & 0xA) != 0) {
                extraWidth = 0;
                gaugeWidth = newSize.width;
                setWidth = gaugeWidth * this.m_gsNumWide - 1;
            }
            if ((align & 5) != 0) {
                extraHeight = 0;
                gaugeHeight = newSize.height;
                setHeight = gaugeHeight * this.m_gsNumTall - 1;
            }
            if (align == 15) {
                startX = (int)(((RectangularShape)gsRect).getX() + ((RectangularShape)gsRect).getWidth() / 2.0) - setWidth / 2;
                endX = setWidth;
                startY = (int)(((RectangularShape)gsRect).getY() + ((RectangularShape)gsRect).getHeight() / 2.0) - setHeight / 2;
            } else {
                if ((align & 2) != 0) {
                    endX = startX + setWidth;
                } else if ((align & 8) != 0) {
                    startX = (int)(((RectangularShape)gsRect).getX() + ((RectangularShape)gsRect).getWidth() - (double)setWidth - 1.0);
                    endX = startX + setWidth;
                }
                if ((align & 4) != 0) {
                    startY = (int)(((RectangularShape)gsRect).getY() + ((RectangularShape)gsRect).getHeight() - (double)setHeight - 1.0);
                }
            }
            currX = startX;
            currY = startY;
        }
        int standardGaugeHeight = gaugeHeight;
        int standardGaugeWidth = gaugeWidth;
        int totalExtraWidth = extraWidth;
        int x = 0;
        while (x < this.m_gsNumTall) {
            gaugeHeight = standardGaugeHeight;
            if (extraHeight > 0) {
                ++gaugeHeight;
                --extraHeight;
            }
            extraWidth = totalExtraWidth;
            int y = 0;
            while (y < this.m_gsNumWide) {
                GaugeSetKey gk = this._getGaugeSetKey(x, y);
                GaugeEngine ge = (GaugeEngine)this.m_gaugeEngines.get(gk);
                gaugeWidth = standardGaugeWidth;
                if (extraWidth > 0) {
                    ++gaugeWidth;
                    --extraWidth;
                }
                g2d.setClip(currX, currY, gaugeWidth, gaugeHeight);
                gk.setBounds(new Rectangle(currX, currY, gaugeWidth, gaugeHeight));
                if (ge != null) {
                    ge.setBackgroundClip(gsClipMask);
                    if (gaugeRenderer != null) {
                        this._renderGaugeEngine(ge, g2d, gaugeRenderer, mode);
                    } else {
                        ge.render(g2d);
                    }
                }
                if ((currX += gaugeWidth) >= endX || y == this.m_gsNumWide - 1) {
                    currX = startX;
                    currY += gaugeHeight;
                }
                ++gaugeCount;
                ++y;
            }
            ++x;
        }
        if (gCreated) {
            g2d.dispose();
            g2d = null;
        }
        return true;
    }

    private void _renderGaugeEngine(GaugeEngine ge, Graphics2D g2d, GaugeRenderer renderer, int mode) {
        if (renderer instanceof GaugeSVGWriter) {
            ge.render(g2d, (GaugeSVGWriter)renderer, mode);
        } else if (renderer instanceof GaugeExportXMLWriter) {
            ge.render(g2d, (GaugeExportXMLWriter)renderer, mode);
        }
    }

    public void renderLegend(GaugeRenderer renderer, Graphics2D g2d, Rectangle outerBounds) {
        if (this.getLegendArea().isVisible()) {
            DataSpecification ds = this.getDataSpecification();
            if (this.m_gaugeEngines.size() == 0) {
                return;
            }
            GaugeEngine ge = this._getGaugeEngine(0, 0);
            double[] tValues = (double[])ge.getAttribute("ThresholdValues");
            if (ds != null && ds.getThresholds().size() > 0 || tValues != null && tValues.length > 0) {
                Rectangle2D legendBounds = this.renderLegendArea(renderer, g2d, outerBounds);
                this.renderLegendTitle(renderer, g2d, legendBounds);
                this.renderLegendItems(renderer, g2d, legendBounds);
            } else {
                this.getErrorHandler().log("Unable to draw legend - no threshold data available.", this.getClass().getName(), m_method_renderLegend);
            }
        }
    }

    protected Rectangle2D renderLegendArea(GaugeRenderer renderer, Graphics2D g2d, Rectangle outerBounds) {
        Rectangle2D.Double legRect = new Rectangle2D.Double();
        legRect.setFrame(this._getLegendAreaFrame(g2d, outerBounds));
        HashMap sfxMap = (HashMap)this.getGaugeSetAttribute("LegendAreaSFX");
        Color fillColor = (Color)this.getGaugeSetAttribute("LegendAreaFillColor");
        if (fillColor == null) {
            fillColor = GaugeDefaultValues.getLegendAreaFillColor();
        } else {
            sfxMap = null;
        }
        Color borderColor = (Color)this.getGaugeSetAttribute("LegendAreaBorderColor");
        if (borderColor == null) {
            borderColor = GaugeDefaultValues.getLegendAreaBorderColor();
        }
        if (this.getGaugeSetAttribute("LegendAreaSFX") != null) {
            sfxMap = (HashMap)this.getGaugeSetAttribute("LegendAreaSFX");
        }
        if (borderColor != null || fillColor != null || sfxMap != null) {
            DrawableObject.Shape la = new DrawableObject.Shape(27, legRect, borderColor, fillColor, sfxMap, null);
            this.m_imageMapObjList.add(la);
            la.render(renderer);
        }
        return legRect;
    }

    protected void renderLegendTitle(GaugeRenderer renderer, Graphics2D g2d, Rectangle2D legendFrame) {
        Color titleFontColor;
        boolean titleVis = this.getLegendTitle().isVisible();
        String titleText = this.getLegendTitle().getText();
        if (!titleVis || titleText.equals(GaugeDefaultValues.getLegendTitleText())) {
            return;
        }
        Font titleFont = (Font)this.getGaugeSetAttribute("LegendTitleFont");
        if (titleFont == null) {
            titleFont = GaugeDefaultValues.getLegendTitleFont();
        }
        if ((titleFontColor = (Color)this.getGaugeSetAttribute("LegendTitleFontColor")) == null) {
            titleFontColor = GaugeDefaultValues.getLegendTitleFontColor();
        }
        Dimension legTitleDim = DrawableObject.getLabelDimensions(g2d, titleFont, titleText);
        if ((double)legTitleDim.width > legendFrame.getWidth()) {
            while ((double)legTitleDim.width > legendFrame.getWidth() && titleText.length() > 4) {
                titleText = titleText.substring(0, titleText.length() - 3);
                legTitleDim = DrawableObject.getLabelDimensions(g2d, titleFont, titleText + "...");
            }
            titleText = titleText.substring(0, titleText.length() - 1);
            legTitleDim = DrawableObject.getLabelDimensions(g2d, titleFont, titleText + "...");
            titleText = titleText + "...";
        }
        Rectangle titleRect = new Rectangle((int)(legendFrame.getX() + legendFrame.getWidth() / 2.0 - (double)(legTitleDim.width / 2)), (int)(legendFrame.getY() + 5.0), legTitleDim.width, legTitleDim.height);
        DrawableObject txtObj = DrawableObject.getLabelObject(g2d, titleText, titleFont, titleFontColor, titleRect, "LegendTitleFont");
        txtObj.render(renderer);
    }

    protected void renderLegendItems(GaugeRenderer renderer, Graphics2D g2d, Rectangle2D legendFrame) {
        int legPos = this.getLegendArea().getPosition();
        boolean vertLayout = legPos == 3 || legPos == 2;
        Font ltFont = this.getLegendText().getFont();
        Color ltFontColor = this.getLegendText().getFontColor();
        int numType = this.getLegendText().getNumberType();
        Dimension legTxtDim = DrawableObject.getLabelDimensions(g2d, ltFont, "W");
        double lineHgt = Math.max(MARKER_DIAMETER, legTxtDim.height) + 3;
        double itemGap = lineHgt * 0.66;
        double mrkrTextGap = lineHgt * 0.33;
        boolean titleVis = this.getLegendTitle().isVisible();
        Font titleFont = (Font)this.getGaugeSetAttribute("LegendTitleFont");
        if (titleFont == null) {
            titleFont = GaugeDefaultValues.getLegendTitleFont();
        }
        String titleText = this.getLegendTitle().getText();
        Dimension legTitleDim = DrawableObject.getLabelDimensions(g2d, titleFont, titleText);
        if (this.m_gaugeEngines.size() == 0) {
            return;
        }
        GaugeEngine ge = this._getGaugeEngine(0, 0);
        double[] tValues = (double[])ge.getAttribute("ThresholdValues");
        ArrayList tList = (ArrayList)ge.getAttribute("THRESHOLD_ATTRIBUTES");
        double currX = legendFrame.getX() + 5.0;
        double currY = legendFrame.getY() + 5.0;
        if (titleVis && !titleText.equals(GaugeDefaultValues.getLegendTitleText())) {
            currY += (double)legTitleDim.height + itemGap;
        }
        double startX = currX;
        double startY = currY;
        double maxX = legendFrame.getX() + legendFrame.getWidth();
        double nextItemWidth = 0.0;
        String fmtVal = null;
        Color tColor = null;
        HashMap sfxMap = null;
        double offset = 0.0;
        int index = 0;
        int textWidth = this.m_widthPerItem - (int)(itemGap + (double)MARKER_DIAMETER + mrkrTextGap);
        if (vertLayout) {
            int i = 0;
            while (i < this.m_legendCols) {
                int j = 0;
                while (j < this.m_legendRows) {
                    if (index == this.m_legendItems.length) break;
                    if (tList != null && index < tList.size()) {
                        HashMap tMap = (HashMap)tList.get(index);
                        fmtVal = (String)GaugeType.getThresholdAttribute(tMap, index, "ThresholdText");
                        tColor = (Color)GaugeType.getThresholdAttribute(tMap, index, "ThresholdFillColor");
                        sfxMap = (HashMap)GaugeType.getThresholdAttribute(tMap, index, "ThresholdSFX");
                    } else {
                        Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                        tColor = index < defClrs.length ? defClrs[index] : Color.white;
                    }
                    Rectangle2D.Double mrkrRect = new Rectangle2D.Double();
                    if (legTxtDim.height > MARKER_DIAMETER) {
                        offset = (legTxtDim.height - MARKER_DIAMETER) / 2;
                    }
                    mrkrRect.setFrame(currX, currY + offset, MARKER_DIAMETER, MARKER_DIAMETER);
                    DrawableObject.Shape mrkrObj = new DrawableObject.Shape(28, mrkrRect, null, tColor, sfxMap, null);
                    this.m_imageMapObjList.add(mrkrObj);
                    mrkrObj.render(renderer);
                    int textX = (int)(currX + (double)MARKER_DIAMETER + mrkrTextGap);
                    offset = 0.0;
                    if (MARKER_DIAMETER > legTxtDim.height) {
                        offset = (MARKER_DIAMETER - legTxtDim.height) / 2;
                    }
                    Rectangle txtRect = new Rectangle(textX, (int)(currY + offset - 2.0), textWidth, legTxtDim.height);
                    DrawableObject txtObj = DrawableObject.getLabelObject(g2d, this.m_legendItems[index], ltFont, ltFontColor, txtRect, "LegendTextFont");
                    this.m_imageMapObjList.add(txtObj);
                    txtObj.render(renderer);
                    currY += lineHgt;
                    offset = 0.0;
                    ++index;
                    ++j;
                }
                currX += (double)this.m_widthPerItem;
                currY = startY;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_legendRows) {
                int j = 0;
                while (j < this.m_legendCols) {
                    if (index == this.m_legendItems.length) break;
                    if (tList != null && index < tList.size()) {
                        HashMap tMap = (HashMap)tList.get(index);
                        fmtVal = (String)GaugeType.getThresholdAttribute(tMap, index, "ThresholdText");
                        tColor = (Color)GaugeType.getThresholdAttribute(tMap, index, "ThresholdFillColor");
                        sfxMap = (HashMap)GaugeType.getThresholdAttribute(tMap, index, "ThresholdSFX");
                    } else {
                        Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                        tColor = index < defClrs.length ? defClrs[index] : Color.white;
                    }
                    Rectangle2D.Double mrkrRect = new Rectangle2D.Double();
                    if (legTxtDim.height > MARKER_DIAMETER) {
                        offset = (legTxtDim.height - MARKER_DIAMETER) / 2;
                    }
                    mrkrRect.setFrame(currX, currY + offset, MARKER_DIAMETER, MARKER_DIAMETER);
                    DrawableObject.Shape mrkrObj = new DrawableObject.Shape(28, mrkrRect, null, tColor, sfxMap, null);
                    this.m_imageMapObjList.add(mrkrObj);
                    mrkrObj.render(renderer);
                    int textX = (int)(currX + (double)MARKER_DIAMETER + mrkrTextGap);
                    offset = 0.0;
                    if (MARKER_DIAMETER > legTxtDim.height) {
                        offset = (MARKER_DIAMETER - legTxtDim.height) / 2;
                    }
                    int labelWidth = Math.min(textWidth, (int)DrawableObject.getLabelDimensions(g2d, ltFont, this.m_legendItems[index]).getWidth());
                    Rectangle txtRect = new Rectangle(textX, (int)(currY + offset - 2.0), labelWidth, legTxtDim.height);
                    DrawableObject txtObj = DrawableObject.getLabelObject(g2d, this.m_legendItems[index], ltFont, ltFontColor, txtRect, "LegendTextFont");
                    this.m_imageMapObjList.add(txtObj);
                    txtObj.render(renderer);
                    currX += (double)this.m_widthPerItem;
                    offset = 0.0;
                    ++index;
                    ++j;
                }
                currY += lineHgt;
                currX = startX;
                ++i;
            }
        }
    }

    private Rectangle2D _getLegendAreaFrame(Graphics2D g2d, Rectangle outerBounds) {
        int legPos;
        if (!this.getLegendArea().isVisible()) {
            return new Rectangle2D.Double();
        }
        if (this.getDataSpecification() == null || this.getDataSpecification().getThresholds().size() == 0) {
            if (this.m_gaugeEngines.size() == 0) {
                return new Rectangle2D.Double();
            }
            GaugeEngine ge = this._getGaugeEngine(0, 0);
            double[] tValues = (double[])ge.getAttribute("ThresholdValues");
            if (tValues == null || tValues.length <= 0) {
                return new Rectangle2D.Double();
            }
        }
        boolean vertLayout = (legPos = this.getLegendArea().getPosition()) == 3 || legPos == 2;
        Font legTitleFont = this.getLegendTitle().getFont();
        Font legTxtFont = this.getLegendText().getFont();
        int numType = this.getLegendText().getNumberType();
        Dimension legTxtDim = DrawableObject.getLabelDimensions(g2d, legTxtFont, "W");
        double lineHgt = Math.max(MARKER_DIAMETER, legTxtDim.height) + 3;
        double itemGap = lineHgt * 0.66;
        double mrkrTextGap = lineHgt * 0.33;
        double maxX = outerBounds.x + outerBounds.width - 10;
        double currX = 0.0;
        double currY = lineHgt;
        double totX = currX;
        double totY = currY;
        double nextItemWidth = 0.0;
        double maxItemWidth = 0.0;
        double minItemWidth = 0.0;
        GaugeEngine ge = this._getGaugeEngine(0, 0);
        double[] tValues = (double[])ge.getAttribute("ThresholdValues");
        ArrayList tList = (ArrayList)ge.getAttribute("THRESHOLD_ATTRIBUTES");
        double minLength = legTxtDim.width * this.getLegendText().getMinLength();
        minItemWidth = itemGap + (double)MARKER_DIAMETER + mrkrTextGap + minLength;
        double widthPerItem = 0.0;
        int rows = 0;
        int cols = 0;
        int reqHeight = 0;
        int reqWidth = 0;
        boolean titleVis = this.getLegendTitle().isVisible();
        String legTitleText = this.getLegendTitle().getText();
        int maxLegendWidth = outerBounds.width;
        int maxLegendHeight = outerBounds.height / 3;
        if (vertLayout) {
            maxLegendWidth = outerBounds.width / 3;
            maxLegendHeight = outerBounds.height;
        }
        if (titleVis && !legTitleText.equals(GaugeDefaultValues.getLegendTitleText())) {
            Dimension legTitleDim = DrawableObject.getLabelDimensions(g2d, legTitleFont, legTitleText);
            maxLegendHeight = (int)((double)maxLegendHeight - ((double)legTitleDim.height + itemGap));
            reqHeight += (int)((double)legTitleDim.height + itemGap);
        }
        String[] legendText = new String[tValues.length + 1];
        int i = 0;
        while (i <= tValues.length) {
            double tValue = i == tValues.length ? tValues[i - 1] : tValues[i];
            String fmtVal = null;
            if (tList != null && i < tList.size()) {
                HashMap tMap = (HashMap)tList.get(i);
                fmtVal = (String)GaugeType.getThresholdAttribute(tMap, i, "ThresholdText");
            }
            if (fmtVal == null) {
                fmtVal = i == 0 || i == tValues.length ? this._formatLegendText(tValue, i == 0, numType == 1) : this._formatLegendText(tValues[i - 1], tValue, numType == 1);
            }
            legendText[i] = fmtVal;
            nextItemWidth = itemGap + (double)MARKER_DIAMETER + mrkrTextGap;
            Dimension txtDim = DrawableObject.getLabelDimensions(g2d, legTxtFont, fmtVal);
            if ((nextItemWidth += (double)txtDim.width) > maxItemWidth) {
                maxItemWidth = nextItemWidth;
            }
            ++i;
        }
        int numPerCol = (int)((double)maxLegendHeight / lineHgt);
        if (vertLayout) {
            if (legendText.length < numPerCol) {
                cols = 1;
                rows = legendText.length;
                widthPerItem = maxItemWidth < (double)maxLegendWidth ? maxItemWidth : (double)maxLegendWidth;
            } else {
                int numColsReq = legendText.length / numPerCol;
                if (legendText.length % numPerCol != 0) {
                    ++numColsReq;
                }
                if ((reqWidth = (int)((double)numColsReq * maxItemWidth)) > maxLegendWidth) {
                    reqWidth = (int)((double)numColsReq * minItemWidth);
                    if (reqWidth > maxLegendWidth) {
                        cols = (int)((double)maxLegendWidth / minItemWidth);
                        rows = numPerCol;
                        widthPerItem = minItemWidth;
                    } else {
                        widthPerItem = maxLegendWidth / numColsReq;
                        cols = numColsReq;
                        rows = numPerCol;
                    }
                } else {
                    rows = legendText.length / numColsReq;
                    cols = numColsReq;
                    widthPerItem = maxItemWidth;
                }
            }
        } else {
            int totalWidth = (int)(maxItemWidth * (double)legendText.length);
            if (totalWidth < maxLegendWidth) {
                widthPerItem = maxItemWidth;
                rows = 1;
                cols = legendText.length;
            } else {
                int numPerRow = (int)((double)maxLegendWidth / maxItemWidth);
                int numRowsReq = legendText.length / numPerRow;
                if (legendText.length % numPerRow != 0) {
                    ++numRowsReq;
                }
                if ((double)numRowsReq * lineHgt > (double)maxLegendHeight) {
                    numPerRow = (int)((double)maxLegendWidth / minItemWidth);
                    int maxRows = legendText.length / numPerRow;
                    if ((double)maxRows * lineHgt > (double)maxLegendHeight) {
                        cols = numPerRow;
                        rows = numPerCol;
                        widthPerItem = minItemWidth;
                    } else {
                        numPerRow = legendText.length / numPerCol;
                        if (legendText.length % numPerCol != 0) {
                            ++numPerRow;
                        }
                        widthPerItem = maxLegendWidth / numPerRow;
                        cols = numPerRow;
                        rows = numPerCol;
                    }
                } else {
                    widthPerItem = maxItemWidth;
                    cols = numPerRow;
                    rows = numRowsReq;
                }
            }
        }
        reqHeight += (int)((double)rows * lineHgt);
        reqWidth = (int)((double)cols * widthPerItem);
        this.m_widthPerItem = (int)widthPerItem;
        this.m_legendRows = rows;
        this.m_legendCols = cols;
        this.m_legendItems = legendText;
        Rectangle2D.Double legRect = new Rectangle2D.Double();
        int midX = outerBounds.x + outerBounds.width / 2;
        int midY = outerBounds.y + outerBounds.height / 2;
        if (legPos == 3) {
            legRect.setFrame(outerBounds.x + 5, midY - reqHeight / 2 - 2, reqWidth + 10, reqHeight + 10);
        } else if (legPos == 2) {
            legRect.setFrame(outerBounds.x + outerBounds.width - 10 - reqWidth, midY - reqHeight / 2 - 2, reqWidth + 5, reqHeight + 10);
        } else if (legPos == 0) {
            legRect.setFrame(midX - reqWidth / 2 - 5, outerBounds.y + 5, reqWidth + 10, reqHeight + 5);
        } else {
            legRect.setFrame(midX - reqWidth / 2 - 5, outerBounds.y + outerBounds.height - reqHeight - 10, reqWidth + 10, reqHeight + 5);
        }
        return legRect;
    }

    private String _formatLegendText(double value, boolean isLow, boolean isPercent) {
        GaugeEngine ge = this._getGaugeEngine(0, 0);
        double span = Math.abs(Math.abs(ge.getMax()) - Math.abs(ge.getMin()));
        StringBuilder fmtVal = new StringBuilder();
        fmtVal.append(isLow ? "< " : "> ");
        if (isPercent) {
            fmtVal.append(ge.formatValue((value - ge.getMin()) / span * 100.0, "TickLabelViewFormat"));
            fmtVal.append("%");
        } else {
            fmtVal.append(String.valueOf(value));
        }
        return fmtVal.toString();
    }

    private String _formatLegendText(double lowValue, double highValue, boolean isPercent) {
        GaugeEngine ge = this._getGaugeEngine(0, 0);
        double span = Math.abs(Math.abs(ge.getMax()) - Math.abs(ge.getMin()));
        StringBuilder fmtVal = new StringBuilder();
        if (isPercent) {
            fmtVal.append(ge.formatValue((lowValue - ge.getMin()) / span * 100.0, "TickLabelViewFormat"));
            fmtVal.append(" - ");
            fmtVal.append(ge.formatValue((highValue - ge.getMin()) / span * 100.0, "TickLabelViewFormat"));
            fmtVal.append("%");
        } else {
            fmtVal.append(String.valueOf(lowValue));
            fmtVal.append(" - ");
            fmtVal.append(String.valueOf(highValue));
        }
        return fmtVal.toString();
    }

    private GaugeEngine _getGaugeEngine(int row, int column) {
        if (this.m_gaugeEngines == null || this.m_gaugeEngines.size() == 0) {
            return null;
        }
        for (GaugeSetKey key : this.m_gaugeEngines.keySet()) {
            if (key.getRow() != row || key.getColumn() != column) continue;
            return (GaugeEngine)this.m_gaugeEngines.get(key);
        }
        return null;
    }

    protected GaugeSVGWriter createSVGWriter(OutputStream os, String charEnc) {
        GaugeSVGWriter svgWriter = null;
        SVGWriterProvider provider = this.getSVGWriterProvider();
        if (provider != null) {
            svgWriter = (GaugeSVGWriter)provider.createSVGWriter((CommonDataview)this, os, charEnc);
        }
        if (svgWriter == null) {
            svgWriter = new GaugeSVGWriter(os, this.getErrorHandler(), charEnc);
        }
        return svgWriter;
    }

    protected GaugeSVGWriter createSVGWriter(Writer writer, String charEnc) {
        GaugeSVGWriter svgWriter = null;
        SVGWriterProvider provider = this.getSVGWriterProvider();
        if (provider != null) {
            svgWriter = (GaugeSVGWriter)provider.createSVGWriter((CommonDataview)this, writer, charEnc);
        }
        if (svgWriter == null) {
            svgWriter = new GaugeSVGWriter(writer, this.getErrorHandler(), charEnc);
        }
        return svgWriter;
    }

    protected GaugeExportXMLWriter createExportXMLWriter(OutputStream os, String charEnc) {
        GaugeExportXMLWriter xmlWriter = null;
        SVGWriterProvider provider = this.getSVGWriterProvider();
        if (provider != null) {
            xmlWriter = (GaugeExportXMLWriter)provider.createExportXMLWriter((ImageView)this, os, charEnc);
        }
        if (xmlWriter == null) {
            xmlWriter = new GaugeExportXMLWriter(os, this.getErrorHandler(), charEnc);
        }
        return xmlWriter;
    }

    protected GaugeExportXMLWriter createExportXMLWriter(Writer writer, String charEnc) {
        GaugeExportXMLWriter xmlWriter = null;
        SVGWriterProvider provider = this.getSVGWriterProvider();
        if (provider != null) {
            xmlWriter = (GaugeExportXMLWriter)provider.createExportXMLWriter((ImageView)this, writer, charEnc);
        }
        if (xmlWriter == null) {
            xmlWriter = new GaugeExportXMLWriter(writer, this.getErrorHandler(), charEnc);
        }
        return xmlWriter;
    }

    @Override
    public Enumeration getImagemapEnumeration(int filter) {
        this.prepareGauges();
        Vector<ImagemapComponent> imgCompList = new Vector<ImagemapComponent>();
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        int x = 0;
        while (x < this.m_gsNumTall) {
            int y = 0;
            while (y < this.m_gsNumWide) {
                GaugeSetKey gk = this._getGaugeSetKey(x, y);
                GaugeEngine ge = (GaugeEngine)this.m_gaugeEngines.get(gk);
                Rectangle clipBounds = gk.getBounds();
                if (clipBounds != null) {
                    g.setClip(clipBounds);
                }
                if (ge != null) {
                    Enumeration geEnum = ge.getImagemapEnumeration(g, filter);
                    while (geEnum.hasMoreElements()) {
                        Object imgComp = geEnum.nextElement();
                        if (imgComp == null || !(imgComp instanceof ImagemapComponent)) continue;
                        imgCompList.add((ImagemapComponent)imgComp);
                    }
                }
                ++y;
            }
            ++x;
        }
        if (filter == -1) {
            Vector<ImagemapComponent> imgCompVector = this._createImagemapComponent(28, GaugeEngine.getCompNameForImagemapEnumeration(28));
            if (imgCompVector != null) {
                imgCompList.addAll(imgCompVector);
            }
            if ((imgCompVector = this._createImagemapComponent(27, GaugeEngine.getCompNameForImagemapEnumeration(27))) != null) {
                imgCompList.addAll(imgCompVector);
            }
        }
        g.dispose();
        g = null;
        return !imgCompList.isEmpty() ? imgCompList.elements() : null;
    }

    private Vector<ImagemapComponent> _createImagemapComponent(int compType, String compName) {
        Vector<ImagemapComponent> imgComp = new Vector<ImagemapComponent>();
        String[] tooltips = null;
        Vector<Polygon> polygons = new Vector<Polygon>(5);
        int objIndex = this.m_imageMapObjList.size() - 1;
        while (objIndex >= 0) {
            DrawableObject obj = (DrawableObject)this.m_imageMapObjList.get(objIndex);
            if (obj == null) {
                this.m_eh.log("Attempt made to process null DrawableObject on gauge.", this.getClass().getName(), "_createImagemapComponent");
            } else if (obj.getComponentType() == compType) {
                polygons.add(GaugeEngine._processImagemapPolygon(obj));
            }
            --objIndex;
        }
        NonDataComponentHandle componentID = new NonDataComponentHandle(compType, compName, null);
        if (polygons == null || polygons.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < polygons.size()) {
            imgComp.add(new ImagemapComponent(componentID, (Polygon)polygons.get(i), tooltips));
            ++i;
        }
        return imgComp;
    }

    public void writeImagemapXML(OutputStream os, int filter) {
        PrintWriter out = new PrintWriter(os);
        this.writeImagemapXML(out, filter);
    }

    public void writeImagemapXML(PrintWriter out, int filter) {
        Enumeration compEnum = this.getImagemapEnumeration(filter);
        out.println("<?xml version='1.0'?>");
        out.println("<!-- This document contains information for image map generation-->");
        out.println("<GaugeMap>");
        while (compEnum.hasMoreElements()) {
            ImagemapComponent comp = (ImagemapComponent)compEnum.nextElement();
            ComponentHandle handle = comp.getComponentHandle();
            Polygon poly = comp.getPlacement();
            out.print("<");
            out.print(handle.getName());
            out.println(">");
            String[] tooltips = comp.getTooltips();
            if (tooltips != null && tooltips.length > 0) {
                out.println("<Tooltip>");
                int n = 0;
                while (n < tooltips.length) {
                    if (tooltips[n].length() > 0) {
                        out.print("<Line>");
                        out.print(tooltips[n]);
                        out.println("</Line>");
                    }
                    ++n;
                }
                out.println("</Tooltip>");
            }
            int iMax = poly.npoints;
            out.println("<Geometry>");
            int i = 0;
            while (i < iMax) {
                out.print("<Vertex x=\"");
                out.print(poly.xpoints[i]);
                out.print("\" y=\"");
                out.print(poly.ypoints[i]);
                out.println("\" />");
                ++i;
            }
            out.println("</Geometry>");
            out.print("</");
            out.print(handle.getName());
            out.println(">");
        }
        out.println("</GaugeMap>");
        out.flush();
    }

    public void writeXML(OutputStream stream, boolean allProperties) {
        XMLObjectWriter writer = new XMLObjectWriter(stream);
        try {
            writer.setIndentMode(1);
            writer.writeObjectNode((BaseObjectNode)this.getObjectNode(allProperties));
        }
        catch (BIIOException biioe) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), m_method_writeXML);
        }
    }

    @Override
    public void setXMLValidated(boolean validate) {
        this.m_validateXML = validate;
    }

    protected void resetToDefault(int reset, String version) {
        this.setUserOverrideMode(false);
        this.setStyleOverrideMode(false);
        this.m_gaugeXML.resetGaugeXML(reset);
        this.setName(GaugeDefaultValues.getName());
        this.setLocalName(GaugeDefaultValues.getLocalName());
        this.setDescription(GaugeDefaultValues.getDescription());
        this.setImageSize(new Dimension(GaugeDefaultValues.getImageWidth(), GaugeDefaultValues.getImageHeight()));
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.resetSuper(reset, version);
        }
        if (reset == 4 || reset == 2 || reset == 5) {
            this.removeErrorHandler();
            this.m_gaugeAttributes = new HashMap();
            this.m_gaugeSetAttributes = new HashMap();
            this.m_skinGaugeAttributes = new HashMap();
            this.m_skinGaugeSetAttributes = new HashMap();
            if (view != null) {
                view.resetEverything(reset);
            }
            this.setRecalcState(2);
        } else if (reset == 3 || reset == 1) {
            this.m_gaugeAttributes = new HashMap();
            this.m_gaugeSetAttributes = new HashMap();
            this.m_skinGaugeAttributes = new HashMap();
            this.m_skinGaugeSetAttributes = new HashMap();
            if (view != null) {
                view.resetXMLProps();
            }
            this.setRecalcState(1);
        }
        this.setImageSize(new Dimension(GaugeDefaultValues.getImageWidth(), GaugeDefaultValues.getImageHeight()));
        if (view != null) {
            view.setPagingControlVisible(false);
        }
        this.clearOverrideFlags();
        this.setUserOverrideMode(true);
        this.setStyleOverrideMode(true);
    }

    public void setMetadataLabelFlag(boolean metadataFlag) {
        this.m_metadataLabelFlag = metadataFlag;
    }

    @Override
    public void setLayerMetaLongLabelSupported(boolean supported) {
        super.setLayerMetaLongLabelSupported(supported);
    }

    public void setMetadataDrillSupported(boolean supported) {
        this.m_metaDrillSupported = supported;
    }

    protected boolean isMetadataDrillSupported() {
        return this.m_metaDrillSupported;
    }

    public void setMetadataDrillParentDateSupported(boolean supported) {
        this.m_metaDrillParentDateSupported = supported;
    }

    protected boolean isMetadataDrillParentDateSupported() {
        return this.m_metaDrillParentDateSupported;
    }

    public void setMetadataDrillParentDateSpanSupported(boolean supported) {
        this.m_metaDrillParentDateSpanSupported = supported;
    }

    protected boolean isMetadataDrillParentDateSpanSupported() {
        return this.m_metaDrillParentDateSpanSupported;
    }

    public void setMetadataDateSpanSupported(boolean supported) {
        this.m_metaDateSpanSupported = supported;
    }

    protected boolean isMetadataDateSpanSupported() {
        return this.m_metaDateSpanSupported;
    }

    /*
     * Unable to fully structure code
     */
    protected LocalXMLDataSource createLocalGridDataSource(ObjectNode node) {
        block46: {
            block45: {
                colCount = 0;
                rowCount = 0;
                pNode = node.getProperty("rowCount");
                if (pNode == null) {
                    this.getErrorHandler().log("no row count provided", this.getClass().getName(), "createLocalGridDataSource");
                    return null;
                }
                rowCount = pNode.getValueAsInteger();
                if (rowCount < 1) {
                    this.getErrorHandler().log("row count less than 1", this.getClass().getName(), "createLocalGridDataSource");
                    return null;
                }
                pNode = node.getProperty("colCount");
                if (pNode == null) {
                    this.getErrorHandler().log("no column count provided", this.getClass().getName(), "createLocalGridDataSource");
                    return null;
                }
                colCount = pNode.getValueAsInteger();
                if (colCount < 1) {
                    this.getErrorHandler().log("column count less than 1", this.getClass().getName(), "createLocalGridDataSource");
                    return null;
                }
                colLabels = new Object[colCount];
                rowLabels = new Object[rowCount];
                data = new Object[colCount][rowCount];
                dataLinks = new String[colCount][rowCount];
                row = 0;
                col = 0;
                rowLabelsNode = node.getContainer("RowLabels");
                if (rowLabelsNode == null) ** GOTO lbl52
                enumer = rowLabelsNode.getPropertyNodes("Label");
                while (enumer.hasMoreElements()) {
                    labelNode = (PropertyNode)enumer.nextElement();
                    if (labelNode != null) {
                        if (row < rowCount) {
                            rowLabels[row] = labelNode.getValueAsString();
                        } else {
                            this.getErrorHandler().log("label for out of bounds row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                        }
                    } else if (row < rowCount) {
                        rowLabels[row] = null;
                        this.getErrorHandler().log("null label node for row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                    } else {
                        this.getErrorHandler().log("null label node for out of bounds row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                    }
                    ++row;
                }
                while (row < rowCount) {
                    rowLabels[row] = null;
                    this.getErrorHandler().log("label missing for row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                    ++row;
                }
                break block45;
lbl-1000:
                // 1 sources

                {
                    rowLabels[row] = null;
                    this.getErrorHandler().log("no row labels: row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                    ++row;
lbl52:
                    // 2 sources

                    ** while (row < rowCount)
                }
            }
            colLabelsNode = node.getContainer("ColLabels");
            if (colLabelsNode == null) ** GOTO lbl81
            enumer = colLabelsNode.getPropertyNodes("Label");
            while (enumer.hasMoreElements()) {
                labelNode = (PropertyNode)enumer.nextElement();
                if (labelNode != null) {
                    if (col < colCount) {
                        colLabels[col] = labelNode.getValueAsString();
                    } else {
                        this.getErrorHandler().log("label for out of bounds column index " + col, this.getClass().getName(), "createLocalGridDataSource");
                    }
                } else if (col < colCount) {
                    colLabels[col] = null;
                    this.getErrorHandler().log("null label node for column index " + col, this.getClass().getName(), "createLocalGridDataSource");
                } else {
                    this.getErrorHandler().log("null label node for out of bounds column index " + col, this.getClass().getName(), "createLocalGridDataSource");
                }
                ++col;
            }
            while (col < colCount) {
                colLabels[col] = null;
                this.getErrorHandler().log("label missing for column index " + col, this.getClass().getName(), "createLocalGridDataSource");
                ++col;
            }
            break block46;
lbl-1000:
            // 1 sources

            {
                colLabels[col] = null;
                this.getErrorHandler().log("no column labels: column index " + col, this.getClass().getName(), "createLocalGridDataSource");
                ++col;
lbl81:
                // 2 sources

                ** while (col < colCount)
            }
        }
        col = 0;
        row = 0;
        dataValuesNode = node.getContainer("DataValues");
        if (dataValuesNode != null) {
            emptyString = "";
            enumer = dataValuesNode.getContainerNodes("RowData");
            row = 0;
            while (enumer.hasMoreElements()) {
                rowDataNode = (ContainerNode)enumer.nextElement();
                if (rowDataNode != null) {
                    enum2 = rowDataNode.getContainedObject("Cell");
                    col = 0;
                    while (enum2.hasMoreElements()) {
                        cellNode = (ObjectNode)enum2.nextElement();
                        if (cellNode != null) {
                            if (col < colCount && row < rowCount) {
                                lNode = cellNode.getProperty("link");
                                dataLinks[col][row] = lNode != null ? lNode.getValueAsString() : null;
                                sData = cellNode.getValueAsString();
                                data[col][row] = sData == null || sData.equals(emptyString) ? null : new Double(cellNode.getValueAsDouble());
                            } else {
                                this.getErrorHandler().log("cell at out of bounds (col, row) indexes (" + col + ", " + row + ")", this.getClass().getName(), "createLocalGridDataSource");
                            }
                        } else if (col < colCount && row < rowCount) {
                            dataLinks[col][row] = null;
                            data[col][row] = null;
                            this.getErrorHandler().log("null cell node at (col, row) indexes (" + col + ", " + row + ")", this.getClass().getName(), "createLocalGridDataSource");
                        } else {
                            this.getErrorHandler().log("null cell node at out of bounds (col, row) indexes (" + col + ", " + row + ")", this.getClass().getName(), "createLocalGridDataSource");
                        }
                        ++col;
                    }
                    while (col < colCount) {
                        if (row < rowCount) {
                            data[col][row] = null;
                            dataLinks[col][row] = null;
                            this.getErrorHandler().log("missing data for column index " + col + " at row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                        } else {
                            this.getErrorHandler().log("missing data for column index " + col + " at out of bounds row index " + row, this.getClass().getName(), "createLocalGridDataSource");
                        }
                        ++col;
                    }
                } else if (row < rowCount) {
                    col = 0;
                    while (col < colCount) {
                        data[col][row] = null;
                        dataLinks[col][row] = null;
                        this.getErrorHandler().log("null row data node at (col, row) indexes (" + col + ", " + row + ")", this.getClass().getName(), "createLocalGridDataSource");
                        ++col;
                    }
                } else {
                    col = 0;
                    while (col < colCount) {
                        this.getErrorHandler().log("null row data node at out of bounds (col, row) indexes (" + col + ", " + row + ")", this.getClass().getName(), "createLocalGridDataSource");
                        ++col;
                    }
                }
                ++row;
            }
            while (row < rowCount) {
                col = 0;
                while (col < colCount) {
                    data[col][row] = null;
                    dataLinks[col][row] = null;
                    this.getErrorHandler().log("missing data for row index " + row + " at column index " + col, this.getClass().getName(), "createLocalGridDataSource");
                    ++col;
                }
                ++row;
            }
        } else {
            col = 0;
            while (col < colCount) {
                row = 0;
                while (row < rowCount) {
                    data[col][row] = null;
                    dataLinks[col][row] = null;
                    this.getErrorHandler().log("no data for cell at (column, row) indexes (" + col + ", " + row + ")", this.getClass().getName(), "createLocalGridDataSource");
                    ++row;
                }
                ++col;
            }
        }
        this.m_dataLinks = dataLinks;
        return new LocalXMLDataSource(colLabels, rowLabels, data);
    }

    protected LocalXMLDataSource createLocalRelationalDataSource(ContainerNode node) {
        int colCount = 0;
        int rowCount = 0;
        PropertyNode pNode = node.getProperty("RowKeyCount");
        if (pNode != null && (rowCount = pNode.getValueAsInteger()) < 1) {
            this.getErrorHandler().log("row count less than 1", this.getClass().getName(), "createLocalRelationalDataSource");
            return null;
        }
        pNode = node.getProperty("ColumnKeyCount");
        if (pNode != null && (colCount = pNode.getValueAsInteger()) < 1) {
            this.getErrorHandler().log("column count less than 1", this.getClass().getName(), "createLocalRelationalDataSource");
            return null;
        }
        int rowKeyCount = 0;
        int colKeyCount = 0;
        Hashtable<String, Integer> rowKeys = new Hashtable<String, Integer>();
        Hashtable<String, Integer> colKeys = new Hashtable<String, Integer>();
        Hashtable<String, Object> dataVals = new Hashtable<String, Object>();
        Hashtable<String, String> dataValLinks = new Hashtable<String, String>();
        ArrayList<String> rowLabelsList = new ArrayList<String>();
        ArrayList<String> colLabelsList = new ArrayList<String>();
        ObjectNode rowNode = null;
        String rowLabel = null;
        String colLabel = null;
        String dataValue = null;
        Double doubleData = null;
        String emptyString = "";
        String dataKey = null;
        String dataLink = null;
        Enumeration rowsEnum = node.getContainedObject("Row");
        while (rowsEnum.hasMoreElements()) {
            rowNode = (ObjectNode)rowsEnum.nextElement();
            if (rowNode != null) {
                try {
                    rowLabel = rowNode.getPropertyValueAsString("rowKey");
                }
                catch (NoSuchPropertyException nspe) {
                    this.getErrorHandler().error((Throwable)nspe, this.getClass().getName(), "createLocalRelationDataSource");
                    rowLabel = "";
                }
                if (!rowKeys.containsKey(rowLabel)) {
                    rowKeys.put(rowLabel, new Integer(rowKeyCount++));
                    rowLabelsList.add(rowLabel);
                }
                try {
                    colLabel = rowNode.getPropertyValueAsString("columnKey");
                }
                catch (NoSuchPropertyException nspe) {
                    this.getErrorHandler().error((Throwable)nspe, this.getClass().getName(), "createLocalRelationalDataSource");
                    colLabel = "";
                }
                if (colLabel != null && !colKeys.containsKey(colLabel)) {
                    colKeys.put(colLabel, new Integer(colKeyCount++));
                    colLabelsList.add(colLabel);
                }
                dataKey = rowLabel.toString() + "," + colLabel.toString();
                try {
                    dataValue = rowNode.getPropertyValueAsString("dataValue");
                }
                catch (NoSuchPropertyException nspe) {
                    this.getErrorHandler().error((Throwable)nspe, this.getClass().getName(), "createLocalRelationalDataSource");
                    dataValue = "";
                }
                if (dataValue.equals(emptyString)) {
                    doubleData = null;
                } else {
                    try {
                        doubleData = new Double(rowNode.getPropertyValueAsDouble("dataValue"));
                    }
                    catch (NoSuchPropertyException nspe) {
                        this.getErrorHandler().error((Throwable)nspe, this.getClass().getName(), "createLocalRelationalDataSource");
                        doubleData = null;
                    }
                }
                if (dataVals.containsKey(dataKey)) {
                    this.getErrorHandler().log("duplicate data at (row,column) = (" + dataKey + ")", this.getClass().getName(), "createLocalRelationalDataSource");
                }
                if (doubleData != null) {
                    dataVals.put(dataKey, doubleData);
                } else {
                    dataVals.put(dataKey, CommonDataview.NullObject.getNullObject());
                }
                try {
                    dataLink = rowNode.getPropertyValueAsString("dataValueLink");
                }
                catch (NoSuchPropertyException nspe) {
                    dataLink = null;
                }
                if (dataLink == null || dataValLinks.containsKey(dataKey)) continue;
                dataValLinks.put(dataKey, dataLink);
                continue;
            }
            this.getErrorHandler().log("null Row node", this.getClass().getName(), "createLocalRelationalDataSource");
        }
        if (rowKeyCount < 1 || colKeyCount < 1) {
            this.getErrorHandler().log("fewer than 1 column or 1 row of data provided", this.getClass().getName(), "createLocalRelationalDataSource");
            return null;
        }
        if (rowCount < 1) {
            rowCount = rowKeyCount;
        }
        if (colCount < 1) {
            colCount = colKeyCount;
        }
        Object[] rowLabels = new Object[rowCount];
        Object[] colLabels = new Object[colCount];
        Object[][] data = new Object[colCount][rowCount];
        this.fillRelationalDataArrays(colCount, rowCount, colLabelsList, rowLabelsList, dataVals, colLabels, rowLabels, data);
        this.fillLinkArrays(colCount, rowCount, colLabels, rowLabels, dataValLinks);
        return new LocalXMLDataSource(colLabels, rowLabels, data);
    }

    protected void fillLinkArrays(int colCount, int rowCount, Object[] colLabels, Object[] rowLabels, Hashtable dataValLinks) {
        this.m_dataLinks = new Object[colCount][rowCount];
        int i = 0;
        while (i < colCount) {
            int j = 0;
            while (j < rowCount) {
                String key = rowLabels[j] + "," + colLabels[i];
                this.m_dataLinks[i][j] = dataValLinks.get(key);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected ObjectNode getObjectNode(String objName, boolean allProperties, String version) {
        ObjectNode node = super.getObjectNode(objName, allProperties, version);
        return this.getObjectNode(allProperties);
    }

    protected ObjectNode getObjectNode(boolean allProperties) {
        ObjectNode dataviewTitleNode;
        ObjectNode dataviewSubtitleNode;
        ObjectNode dataviewFootnoteNode;
        ObjectNode node = super.getObjectNode("GaugeSet", allProperties, m_version);
        ObjectNode fontNode = null;
        Object propValue = this.getGaugeSetAttribute(a_gaugeType);
        if (allProperties || propValue != null && (Integer)propValue != GaugeDefaultValues.getGaugeType()) {
            node.addProperty(a_gaugeType, CommonGauge.convertGaugeTypeToString((Integer)propValue));
        }
        if (allProperties || this.getAnimationOnDataChange() != GaugeDefaultValues.getAnimationOnDataChange()) {
            node.addProperty("animationOnDataChange", CommonGauge.convertAnimationOnDataChangeToString(this.getAnimationOnDataChange()));
        }
        if (allProperties || this.getAnimationIndicators() != GaugeDefaultValues.getAnimationIndicators()) {
            node.addProperty("animationIndicators", CommonGauge.convertAnimationIndicatorsToString(this.getAnimationIndicators()));
        }
        if (allProperties || this.getAnimationDuration() != GaugeDefaultValues.getAnimationDuration()) {
            node.addProperty("animationDuration", this.getAnimationDuration());
        }
        propValue = this.getAnimationUpColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getAnimationUpColor())) {
            node.addProperty("animationUpColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
        }
        propValue = this.getAnimationDownColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getAnimationDownColor())) {
            node.addProperty("animationDownColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
        }
        if (allProperties || this.getAnimationOnDisplay() != GaugeDefaultValues.getAnimationOnDisplay()) {
            node.addProperty("animationOnDisplay", CommonGauge.convertAnimationOnDisplayToString(this.getAnimationOnDisplay()));
        }
        if (allProperties || this.getVisualEffects() != GaugeDefaultValues.getVisualEffects()) {
            node.addProperty("visualEffects", CommonGauge.convertVisualEffectsToString(this.getVisualEffects()));
        }
        if (allProperties || this.getCustomLayout() != GaugeDefaultValues.getCustomLayout()) {
            node.addProperty(a_customLayout, CommonGauge.convertCustomLayoutToString(this.getCustomLayout()));
        }
        if (allProperties || this.isGraphicAntialiasing() != GaugeDefaultValues.isGraphicAntialiasing()) {
            node.addProperty("graphicAntialiasing", this.isGraphicAntialiasing());
        }
        if (allProperties || this.isTextAntialiasing() != GaugeDefaultValues.isTextAntialiasing()) {
            node.addProperty("textAntialiasing", this.isTextAntialiasing());
        }
        if (allProperties || this.getLEDStyle() != GaugeDefaultValues.getLEDStyle()) {
            node.addProperty(a_ledStyle, CommonGauge.convertLEDStyleToString(this.getLEDStyle()));
        }
        if (allProperties || this.getSpecularHighlight() != GaugeDefaultValues.getSpecularHighlight()) {
            node.addProperty(a_specularHighlight, CommonGauge.convertSpecularHighlightToString(this.getSpecularHighlight()));
        }
        if (allProperties || this.getThresholdDialStyle() != GaugeDefaultValues.getThresholdDialStyle()) {
            node.addProperty(a_tdStyle, CommonGauge.convertTDStyleToString(this.getThresholdDialStyle()));
        }
        if (allProperties || this.getAngleExtent() != GaugeDefaultValues.getAngleExtent()) {
            node.addProperty(a_angleExtent, this.getAngleExtent());
        }
        propValue = this.getGaugeSetAttribute("GaugeSetAlignment");
        if (allProperties || propValue != null && (Integer)propValue != GaugeDefaultValues.getGaugeSetAlignment()) {
            node.addProperty(a_gsalignment, CommonGauge.convertGaugeSetAlignmentToString((Integer)propValue));
        }
        propValue = this.getGaugeSetAttribute("GaugeSetColumnCount");
        if (allProperties || propValue != null && (Integer)propValue != GaugeDefaultValues.getGaugeSetColumnCount()) {
            node.addProperty(a_gscolcount, CommonGauge.convertGaugeSetColCountToString((Integer)propValue));
        }
        propValue = this.getGaugeSetAttribute("GaugeSetDirection");
        if (allProperties || propValue != null && (Integer)propValue != GaugeDefaultValues.getGaugeSetDirection()) {
            node.addProperty(a_gsdirection, CommonGauge.convertGaugeSetDirectionToString((Integer)propValue));
        }
        if ((propValue = this.getAttribute("maxValue")) != null) {
            node.addProperty("maxValue", ((Double)propValue).doubleValue());
        }
        if ((propValue = this.getAttribute("minValue")) != null) {
            node.addProperty("minValue", ((Double)propValue).doubleValue());
        }
        propValue = this.getImageSize();
        if (allProperties || propValue != null && !((Dimension)propValue).equals(new Dimension(GaugeDefaultValues.getImageWidth(), GaugeDefaultValues.getImageHeight()))) {
            ObjectNode imgSizeNode = new ObjectNode("ImageSize");
            Dimension imgDims = (Dimension)propValue;
            imgSizeNode.addProperty("width", imgDims.width);
            imgSizeNode.addProperty("height", imgDims.height);
            node.addProperty(imgSizeNode);
        }
        boolean nodeExists = false;
        ObjectNode tempNode = new ObjectNode(NAME_GAUGESETBACKGROUND);
        propValue = this.getGaugeSetBackground().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getGaugeSetFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getGaugeSetBackground().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getGaugeSetBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        ContainerNode sfxNode = this.getGaugeSetBackground().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            node.addProperty(tempNode);
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_LEGENDAREA);
        if (allProperties || this.getLegendArea().isVisible() != GaugeDefaultValues.isLegendAreaVisible()) {
            tempNode.addProperty("visible", this.getLegendArea().isVisible());
            nodeExists = true;
        }
        propValue = this.getLegendArea().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLegendAreaFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getLegendArea().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLegendAreaBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        if (allProperties || this.getLegendArea().getPosition() != GaugeDefaultValues.getLegendAreaPosition()) {
            tempNode.addProperty("position", LegendArea.convertPositionToString(this.getLegendArea().getPosition()));
            nodeExists = true;
        }
        sfxNode = this.getLegendArea().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            node.addProperty(tempNode);
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_LEGENDTEXT);
        propValue = this.getLegendText().getFont();
        Color propColor = this.getLegendText().getFontColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLegendTextFont()) || propColor != null && !propColor.equals(GaugeDefaultValues.getLegendTextFontColor())) {
            if (fontNode == null) {
                fontNode = new ObjectNode(NAME_GAUGEFONT);
            }
            nodeExists = this.getGaugeFontXML(fontNode, (Font)propValue, GaugeDefaultValues.getLegendTextFont(), propColor, GaugeDefaultValues.getLegendTextFontColor());
        }
        if (allProperties || this.getLegendText().getNumberType() != GaugeDefaultValues.getLegendTextNumberType()) {
            tempNode.addProperty(a_numberType, CommonGauge.convertNumberTypeToString(this.getLegendText().getNumberType()));
            nodeExists = true;
        }
        if (allProperties || this.getLegendText().getMinLength() != GaugeDefaultValues.getLegendTextMinLength()) {
            tempNode.addProperty(a_minLength, this.getLegendText().getMinLength());
            nodeExists = true;
        }
        if (nodeExists) {
            if (fontNode != null) {
                tempNode.addProperty(fontNode);
            }
            node.addProperty(tempNode);
        }
        nodeExists = false;
        fontNode = null;
        tempNode = new ObjectNode(NAME_LEGENDTITLE);
        if (allProperties || this.getLegendTitle().isVisible() != GaugeDefaultValues.isLegendTitleVisible()) {
            tempNode.addProperty("visible", this.getLegendTitle().isVisible());
            nodeExists = true;
        }
        propValue = this.getLegendTitle().getFont();
        propColor = this.getLegendTitle().getFontColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLegendTitleFont()) || propColor != null && !propColor.equals(GaugeDefaultValues.getLegendTitleFontColor())) {
            if (fontNode == null) {
                fontNode = new ObjectNode(NAME_GAUGEFONT);
            }
            nodeExists = this.getGaugeFontXML(fontNode, (Font)propValue, GaugeDefaultValues.getLegendTitleFont(), propColor, GaugeDefaultValues.getLegendTitleFontColor());
        }
        if (allProperties || !this.getLegendTitle().getText().equals(GaugeDefaultValues.getLegendTitleText())) {
            tempNode.addProperty("text", this.getLegendTitle().getText());
            nodeExists = true;
        }
        if (nodeExists) {
            if (fontNode != null) {
                tempNode.addProperty(fontNode);
            }
            node.addProperty(tempNode);
        }
        nodeExists = false;
        fontNode = null;
        ContainerNode gaugeNode = new ContainerNode(NAME_GAUGE);
        boolean gaugeNodeExists = false;
        tempNode = new ObjectNode("Background");
        propValue = this.getGaugeBackground().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getBackgroundFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getGaugeBackground().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getBackgroundBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        sfxNode = this.getGaugeBackground().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_GAUGEFRAME);
        if (allProperties || this.getGaugeFrame().isVisible() != GaugeDefaultValues.isGaugeFrameVisible()) {
            tempNode.addProperty("visible", this.getGaugeFrame().isVisible());
            nodeExists = true;
        }
        propValue = this.getGaugeFrame().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getGaugeFrameFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getGaugeFrame().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getGaugeFrameBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        sfxNode = this.getGaugeFrame().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_PLOTAREA);
        propValue = this.getPlotArea().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getPlotAreaFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getPlotArea().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getPlotAreaBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        if (allProperties || this.getPlotArea().isUseThresholdFillColor() != GaugeDefaultValues.isPlotAreaUseThresholdFillColor()) {
            tempNode.addProperty(a_useThresholdFillColor, this.getPlotArea().isUseThresholdFillColor());
            nodeExists = true;
        }
        sfxNode = this.getPlotArea().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_UPPERLABELFRAME);
        if (allProperties || this.getUpperLabelFrame().isVisible() != GaugeDefaultValues.isUpperLabelFrameVisible()) {
            tempNode.addProperty("visible", this.getUpperLabelFrame().isVisible());
            nodeExists = true;
        }
        propValue = this.getUpperLabelFrame().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLabelFrameFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getUpperLabelFrame().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLabelFrameBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        sfxNode = this.getUpperLabelFrame().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_LOWERLABELFRAME);
        if (allProperties || this.getLowerLabelFrame().isVisible() != GaugeDefaultValues.isLowerLabelFrameVisible()) {
            tempNode.addProperty("visible", this.getLowerLabelFrame().isVisible());
            nodeExists = true;
        }
        propValue = this.getLowerLabelFrame().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLabelFrameFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getLowerLabelFrame().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getLabelFrameBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        sfxNode = this.getLowerLabelFrame().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_TOPLABEL);
        propValue = this.getTopLabel().getFont();
        propColor = this.getTopLabel().getFontColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getTopLabelFont()) || propColor != null && !propColor.equals(GaugeDefaultValues.getTopLabelFontColor())) {
            if (fontNode == null) {
                fontNode = new ObjectNode(NAME_GAUGEFONT);
            }
            nodeExists = this.getGaugeFontXML(fontNode, (Font)propValue, GaugeDefaultValues.getTopLabelFont(), propColor, GaugeDefaultValues.getTopLabelFontColor());
        }
        if (allProperties || this.getTopLabel().getPosition() != GaugeDefaultValues.getTopLabelPosition()) {
            tempNode.addProperty("position", TopLabel.convertLabelPositionToString(this.getTopLabel().getPosition()));
            nodeExists = true;
        }
        if (allProperties || this.getTopLabel().getText() != GaugeDefaultValues.getTopLabelText()) {
            tempNode.addProperty("text", this.getTopLabel().getText());
            nodeExists = true;
        }
        if (nodeExists) {
            if (fontNode != null) {
                tempNode.addProperty(fontNode);
            }
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        fontNode = null;
        tempNode = new ObjectNode(NAME_BOTTOMLABEL);
        propValue = this.getBottomLabel().getFont();
        propColor = this.getBottomLabel().getFontColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getBottomLabelFont()) || propColor != null && !propColor.equals(GaugeDefaultValues.getBottomLabelFontColor())) {
            if (fontNode == null) {
                fontNode = new ObjectNode(NAME_GAUGEFONT);
            }
            nodeExists = this.getGaugeFontXML(fontNode, (Font)propValue, GaugeDefaultValues.getBottomLabelFont(), propColor, GaugeDefaultValues.getBottomLabelFontColor());
        }
        if (allProperties || this.getBottomLabel().getPosition() != GaugeDefaultValues.getBottomLabelPosition()) {
            tempNode.addProperty("position", BottomLabel.convertLabelPositionToString(this.getBottomLabel().getPosition()));
            nodeExists = true;
        }
        if (allProperties || this.getBottomLabel().getText() != GaugeDefaultValues.getBottomLabelText()) {
            tempNode.addProperty("text", this.getBottomLabel().getText());
            nodeExists = true;
        }
        if (nodeExists) {
            if (fontNode != null) {
                tempNode.addProperty(fontNode);
            }
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        fontNode = null;
        tempNode = new ObjectNode(NAME_METRICLABEL);
        propValue = this.getMetricLabel().getFont();
        propColor = this.getMetricLabel().getFontColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getBottomLabelFont()) || propColor != null && !propColor.equals(GaugeDefaultValues.getBottomLabelFontColor())) {
            if (fontNode == null) {
                fontNode = new ObjectNode(NAME_GAUGEFONT);
            }
            nodeExists = this.getGaugeFontXML(fontNode, (Font)propValue, GaugeDefaultValues.getMetricLabelFont(), propColor, GaugeDefaultValues.getMetricLabelFontColor());
        }
        if (allProperties || this.getMetricLabel().getPosition() != GaugeDefaultValues.getMetricLabelPosition()) {
            tempNode.addProperty("position", MetricLabel.convertLabelPositionToString(this.getMetricLabel().getPosition()));
            nodeExists = true;
        }
        if (allProperties || this.getMetricLabel().getViewFormat() != null) {
            tempNode.addProperty(this.getMetricLabel().getViewFormat().getXML(allProperties));
            nodeExists = true;
        }
        if (allProperties || this.getMetricLabel().getNumberType() != GaugeDefaultValues.getNumberType()) {
            tempNode.addProperty(a_numberType, CommonGauge.convertNumberTypeToString(this.getMetricLabel().getNumberType()));
            nodeExists = true;
        }
        if (nodeExists) {
            if (fontNode != null) {
                tempNode.addProperty(fontNode);
            }
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        fontNode = null;
        tempNode = new ObjectNode(NAME_INDICATOR);
        propValue = this.getIndicator().getFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getIndicatorFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getIndicator().getBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getIndicatorBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        if (allProperties || this.getIndicator().isUseThresholdFillColor() != GaugeDefaultValues.isIndicatorUseThresholdFillColor()) {
            tempNode.addProperty(a_useThresholdFillColor, this.getIndicator().isUseThresholdFillColor());
            nodeExists = true;
        }
        if (allProperties || this.getIndicator().getType() != GaugeDefaultValues.getIndicatorType()) {
            tempNode.addProperty(a_indicatorType, Indicator.convertTypeToString(this.getIndicator().getType()));
            nodeExists = true;
        }
        sfxNode = this.getIndicator().getSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_INDICATORBAR);
        propValue = this.getIndicator().getBarFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getIndicatorBarFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getIndicator().getBarBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getIndicatorBarBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        sfxNode = this.getIndicator().getBarSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        tempNode = new ObjectNode(NAME_INDICATORBASE);
        propValue = this.getIndicator().getBaseFillColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getIndicatorBaseFillColor())) {
            tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        propValue = this.getIndicator().getBaseBorderColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getIndicatorBaseBorderColor())) {
            tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        if (allProperties || this.getIndicator().isBaseVisible() != GaugeDefaultValues.isIndicatorBaseVisible()) {
            tempNode.addProperty("visible", this.getIndicator().isBaseVisible());
            nodeExists = true;
        }
        sfxNode = this.getIndicator().getBaseSFX().getXML(allProperties, true);
        if (allProperties || sfxNode != null) {
            tempNode.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        int tCount = this.getThreshold().size();
        int i = 0;
        while (i < tCount) {
            tempNode = new ObjectNode(NAME_THRESHOLD);
            tempNode.addProperty("index", i);
            propValue = this.getThreshold().getFillColor(i);
            if (propValue != null) {
                Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                if (allProperties || i >= defClrs.length || !propValue.equals(defClrs[i])) {
                    tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
                    nodeExists = true;
                }
            }
            propValue = this.getThreshold().getBorderColor(i);
            if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getThresholdBorderColor())) {
                tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
                nodeExists = true;
            }
            propValue = this.getThreshold().getText(i);
            if (allProperties || propValue != null) {
                tempNode.addProperty("text", (String)propValue);
                nodeExists = true;
            }
            sfxNode = this.getThreshold().getSFX(i).getXML(allProperties, true);
            if (allProperties || sfxNode != null) {
                tempNode.addContainer(sfxNode);
                nodeExists = true;
            }
            if (nodeExists) {
                gaugeNode.addContainedObject((BaseNode)tempNode);
                gaugeNodeExists = true;
            }
            nodeExists = false;
            ++i;
        }
        tempNode = new ObjectNode(NAME_TICKLABEL);
        propValue = this.getTickLabel().getFont();
        propColor = this.getTickLabel().getFontColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getTickLabelFont()) || propColor != null && !propColor.equals(GaugeDefaultValues.getTickLabelFontColor())) {
            if (fontNode == null) {
                fontNode = new ObjectNode(NAME_GAUGEFONT);
            }
            nodeExists = this.getGaugeFontXML(fontNode, (Font)propValue, GaugeDefaultValues.getTickLabelFont(), propColor, GaugeDefaultValues.getTickLabelFontColor());
        }
        if (allProperties || this.getTickLabel().getContent() != GaugeDefaultValues.getTickLabelContent()) {
            tempNode.addProperty(a_content, CommonGauge.convertTickContentToString(this.getTickLabel().getContent()));
            nodeExists = true;
        }
        if (allProperties || this.getTickLabel().getViewFormat() != null) {
            tempNode.addProperty(this.getTickLabel().getViewFormat().getXML(allProperties));
            nodeExists = true;
        }
        if (allProperties || this.getTickLabel().getNumberType() != GaugeDefaultValues.getNumberType()) {
            tempNode.addProperty(a_numberType, CommonGauge.convertNumberTypeToString(this.getTickLabel().getNumberType()));
            nodeExists = true;
        }
        if (nodeExists) {
            if (fontNode != null) {
                tempNode.addProperty(fontNode);
            }
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        fontNode = null;
        tempNode = new ObjectNode(NAME_TICKMARK);
        if (allProperties || this.getTickMark().getContent() != GaugeDefaultValues.getTickMarkContent()) {
            tempNode.addProperty(a_content, CommonGauge.convertTickContentToString(this.getTickMark().getContent()));
            nodeExists = true;
        }
        if (allProperties || this.getTickMark().getMajorTickCount() != GaugeDefaultValues.getMajorTickCount()) {
            tempNode.addProperty(a_majorTickCount, this.getTickMark().getMajorTickCount());
            nodeExists = true;
        }
        propValue = this.getTickMark().getMajorTickColor();
        if (allProperties || propValue != null && !propValue.equals(GaugeDefaultValues.getMajorTickMarkColor())) {
            tempNode.addProperty(a_majorTickColor, PresUtils.toHexStringWithAlpha(((Color)propValue).getRGB()));
            nodeExists = true;
        }
        if (nodeExists) {
            gaugeNode.addContainedObject((BaseNode)tempNode);
            gaugeNodeExists = true;
        }
        nodeExists = false;
        Color defElemBorderClr = GaugeDefaultValues.getElementBorderColor();
        tempNode = new ObjectNode(NAME_VENNELEMENT);
        propValue = this.getElementA();
        if (allProperties || propValue != null) {
            tempNode.addProperty("id", veid_a);
            Color vPropValue = ((ElementA)propValue).getFillColor();
            if (!((Object)vPropValue).equals(GaugeDefaultValues.getElementAFillColor())) {
                tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(vPropValue.getRGB()));
                nodeExists = true;
            }
            if (!((Object)(vPropValue = ((ElementA)propValue).getBorderColor())).equals(defElemBorderClr)) {
                tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(vPropValue.getRGB()));
                nodeExists = true;
            }
            sfxNode = ((ElementA)propValue).getSFX().getXML(allProperties, true);
            if (allProperties || sfxNode != null) {
                tempNode.addContainer(sfxNode);
                nodeExists = true;
            }
            if (nodeExists) {
                gaugeNode.addContainedObject((BaseNode)tempNode);
                gaugeNodeExists = true;
            }
            nodeExists = false;
        }
        tempNode = new ObjectNode(NAME_VENNELEMENT);
        propValue = this.getElementB();
        if (allProperties || propValue != null) {
            tempNode.addProperty("id", veid_b);
            Color vPropValue = ((ElementB)propValue).getFillColor();
            if (!((Object)vPropValue).equals(GaugeDefaultValues.getElementBFillColor())) {
                tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(vPropValue.getRGB()));
                nodeExists = true;
            }
            if (!((Object)(vPropValue = ((ElementB)propValue).getBorderColor())).equals(defElemBorderClr)) {
                tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(vPropValue.getRGB()));
                nodeExists = true;
            }
            sfxNode = ((ElementB)propValue).getSFX().getXML(allProperties, true);
            if (allProperties || sfxNode != null) {
                tempNode.addContainer(sfxNode);
                nodeExists = true;
            }
            if (nodeExists) {
                gaugeNode.addContainedObject((BaseNode)tempNode);
                gaugeNodeExists = true;
            }
            nodeExists = false;
        }
        tempNode = new ObjectNode(NAME_VENNELEMENT);
        propValue = this.getIntersectionAB();
        if (allProperties || propValue != null) {
            tempNode.addProperty("id", veid_ab);
            Color vPropValue = ((IntersectionAB)propValue).getFillColor();
            if (!((Object)vPropValue).equals(GaugeDefaultValues.getIntersectionABFillColor())) {
                tempNode.addProperty("fillColor", PresUtils.toHexStringWithAlpha(vPropValue.getRGB()));
                nodeExists = true;
            }
            if (!((Object)(vPropValue = ((IntersectionAB)propValue).getBorderColor())).equals(defElemBorderClr)) {
                tempNode.addProperty("borderColor", PresUtils.toHexStringWithAlpha(vPropValue.getRGB()));
                nodeExists = true;
            }
            sfxNode = ((IntersectionAB)propValue).getSFX().getXML(allProperties, true);
            if (allProperties || sfxNode != null) {
                tempNode.addContainer(sfxNode);
                nodeExists = true;
            }
            if (nodeExists) {
                gaugeNode.addContainedObject((BaseNode)tempNode);
                gaugeNodeExists = true;
            }
            nodeExists = false;
        }
        if (gaugeNodeExists) {
            node.addContainer(gaugeNode);
        }
        if ((dataviewFootnoteNode = ((BaseTitleAttributes)this.getDataviewFootnote()).getXML(allProperties)) != null) {
            node.addProperty(dataviewFootnoteNode);
        }
        if ((dataviewSubtitleNode = ((BaseTitleAttributes)this.getDataviewSubtitle()).getXML(allProperties)) != null) {
            node.addProperty(dataviewSubtitleNode);
        }
        if ((dataviewTitleNode = ((BaseTitleAttributes)this.getDataviewTitle()).getXML(allProperties)) != null) {
            node.addProperty(dataviewTitleNode);
        }
        return node;
    }

    @Override
    protected DataviewXML getViewXML() {
        return this.m_gaugeXML;
    }

    protected void setXML(ObjectNode node, int reset) {
        ObjectNode attrNode;
        ContainerNode attrCont;
        if (node == null) {
            return;
        }
        PropertyNode pNode = node.getProperty("version");
        String version = m_version;
        if (pNode != null) {
            version = pNode.getValueAsString();
        }
        if (reset != 0) {
            this.resetToDefault(reset, version);
        }
        if ((pNode = node.getProperty("name")) != null) {
            this.setName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty("localName")) != null) {
            this.setLocalName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty("description")) != null) {
            this.setDescription(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_gaugeType)) != null) {
            String gTypeStr = pNode.getValueAsString();
            int gType = CommonGauge.convertGaugeTypeToInt(gTypeStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_gaugeType, new Integer(gType));
            } else {
                this.setGaugeType(gType);
            }
        }
        if ((pNode = node.getProperty("graphicAntialiasing")) != null) {
            boolean anti = pNode.getValueAsBoolean();
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("graphicAntialiasing", new Boolean(anti));
            } else {
                this.setGraphicAntialiasing(anti);
            }
        }
        if ((pNode = node.getProperty("textAntialiasing")) != null) {
            boolean anti = pNode.getValueAsBoolean();
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("textAntialiasing", new Boolean(anti));
            } else {
                this.setTextAntialiasing(anti);
            }
        }
        if ((pNode = node.getProperty(a_ledStyle)) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertLEDStyleToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_ledStyle, new Integer(style));
            } else {
                this.setLEDStyle(style);
            }
        }
        if ((pNode = node.getProperty(a_specularHighlight)) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertSpecularHighlightToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_specularHighlight, new Integer(style));
            } else {
                this.setSpecularHighlight(style);
            }
        }
        if ((pNode = node.getProperty(a_angleExtent)) != null) {
            Integer extent = new Integer(pNode.getValueAsInteger());
            if (this.m_jsfHashMap_Gauge != null) {
                if (this.m_jsfHashMap_Gauge != null) {
                    this.m_jsfHashMap_Gauge.put(a_angleExtent, extent);
                } else {
                    this.setAngleExtent(extent);
                }
            }
        }
        if ((pNode = node.getProperty(a_tdStyle)) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertTDStyleToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_tdStyle, new Integer(style));
            } else {
                this.setThresholdDialStyle(style);
            }
        }
        if ((pNode = node.getProperty("animationOnDataChange")) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertAnimationOnDataChangeToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("animationOnDataChange", new Integer(style));
            } else {
                this.setAnimationOnDataChange(style);
            }
        }
        if ((pNode = node.getProperty("animationIndicators")) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertAnimationIndicatorsToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("animationIndicators", new Integer(style));
            } else {
                this.setAnimationOnDataChange(style);
            }
        }
        if ((pNode = node.getProperty("animationDuration")) != null) {
            Integer duration = new Integer(pNode.getValueAsInteger());
            if (this.m_jsfHashMap_Gauge != null) {
                if (this.m_jsfHashMap_Gauge != null) {
                    this.m_jsfHashMap_Gauge.put("animationOnDataChange", duration);
                } else {
                    this.setAnimationDuration(duration);
                }
            }
        }
        if ((pNode = node.getProperty("animationUpColor")) != null) {
            Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("animationUpColor", clr);
            } else {
                this.setAnimationUpColor(clr);
            }
        }
        if ((pNode = node.getProperty("animationDownColor")) != null) {
            Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("animationUpColor", clr);
            } else {
                this.setAnimationUpColor(clr);
            }
        }
        if ((pNode = node.getProperty("animationOnDisplay")) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertAnimationOnDisplayToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("animationOnDisplay", new Integer(style));
            } else {
                this.setAnimationOnDataChange(style);
            }
        }
        if ((pNode = node.getProperty("visualEffects")) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertVisualEffectsToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("visualEffects", new Integer(style));
            } else {
                this.setAnimationOnDataChange(style);
            }
        }
        if ((pNode = node.getProperty(a_customLayout)) != null) {
            String styleStr = pNode.getValueAsString();
            int style = CommonGauge.convertCustomLayoutToInt(styleStr);
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_customLayout, new Integer(style));
            } else {
                this.setAnimationOnDataChange(style);
            }
        }
        if ((pNode = node.getProperty(a_gsalignment)) != null) {
            Integer align = new Integer(CommonGauge.convertGaugeSetAlignmentToInt(pNode.getValueAsString()));
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_gsalignment, align);
            } else {
                this.setGaugeSetAlignment(align);
            }
        }
        if ((pNode = node.getProperty(a_gscolcount)) != null) {
            Integer colCount = new Integer(pNode.getValueAsInteger());
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_gscolcount, colCount);
            } else {
                this.setGaugeSetColumnCount(colCount);
            }
        }
        if ((pNode = node.getProperty(a_gsdirection)) != null) {
            String dStr = pNode.getValueAsString();
            Integer dir = new Integer(1);
            if (dStr.equals(gsd_across)) {
                dir = new Integer(0);
            }
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put(a_gsdirection, dir);
            } else {
                this.setGaugeSetDirection(dir);
            }
        }
        if ((pNode = node.getProperty("minValue")) != null) {
            double minValue = pNode.getValueAsDouble();
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("minValue", new Double(minValue));
            } else {
                this.setAttribute("minValue", new Double(minValue));
            }
        }
        if ((pNode = node.getProperty("maxValue")) != null) {
            double maxValue = pNode.getValueAsDouble();
            if (this.m_jsfHashMap_Gauge != null) {
                this.m_jsfHashMap_Gauge.put("maxValue", new Double(maxValue));
            } else {
                this.setAttribute("maxValue", new Double(maxValue));
            }
        }
        if ((attrCont = node.getContainer("ImageSize")) != null) {
            PropertyNode pHeight;
            Dimension imgSize = this.getImageSize();
            PropertyNode pWidth = attrCont.getProperty("width");
            if (pWidth != null) {
                imgSize.width = pWidth.getValueAsInteger();
            }
            if ((pHeight = attrCont.getProperty("height")) != null) {
                imgSize.height = pHeight.getValueAsInteger();
            }
            if (pWidth != null || pHeight != null) {
                if (this.m_jsfHashMap_Gauge != null) {
                    this.m_jsfHashMap_Gauge.put("imageWidth", new Integer(imgSize.width));
                    this.m_jsfHashMap_Gauge.put("imageHeight", new Integer(imgSize.height));
                } else {
                    this.setImageSize(imgSize);
                }
            }
        }
        HashMap<String, Object> map = null;
        attrCont = node.getContainer(NAME_GAUGESETBACKGROUND);
        if (attrCont != null) {
            if (this.m_jsfHashMap != null) {
                map = new HashMap<String, Object>();
                this.m_jsfHashMap.put(NAME_GAUGESETBACKGROUND, map);
            }
            if ((pNode = attrCont.getProperty("fillColor")) != null) {
                Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                if (map != null) {
                    map.put("fillColor", clr);
                } else {
                    this.getGaugeSetBackground().setFillColor(clr);
                }
            }
            if ((pNode = attrCont.getProperty("borderColor")) != null) {
                Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                if (map != null) {
                    map.put("borderColor", clr);
                } else {
                    this.getGaugeSetBackground().setBorderColor(clr);
                }
            }
            Enumeration sfxNodes = attrCont.getContainerNodes();
            while (sfxNodes.hasMoreElements()) {
                Object sfxNode = sfxNodes.nextElement();
                if (sfxNode == null || !(sfxNode instanceof ContainerNode)) continue;
                this.getGaugeSetBackground().getSFX().setXML((ContainerNode)sfxNode, reset != 0);
            }
        }
        if ((attrCont = node.getContainer(NAME_LEGENDAREA)) != null) {
            if (this.m_jsfHashMap != null) {
                map = new HashMap();
                this.m_jsfHashMap.put(NAME_LEGENDAREA, map);
            }
            if ((pNode = attrCont.getProperty("visible")) != null) {
                Boolean b = pNode.getValueAsBoolean();
                if (map != null) {
                    map.put("rendered", b);
                } else {
                    this.getLegendArea().setVisible(b);
                }
            }
            if ((pNode = attrCont.getProperty("rendered")) != null) {
                Boolean b = pNode.getValueAsBoolean();
                if (map != null) {
                    map.put("rendered", b);
                } else {
                    this.getLegendArea().setVisible(b);
                }
            }
            if ((pNode = attrCont.getProperty("fillColor")) != null) {
                Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                if (map != null) {
                    map.put("fillColor", clr);
                } else {
                    this.getLegendArea().setFillColor(clr);
                }
            }
            if ((pNode = attrCont.getProperty("borderColor")) != null) {
                Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                if (map != null) {
                    map.put("borderColor", clr);
                } else {
                    this.getLegendArea().setBorderColor(clr);
                }
            }
            if ((pNode = attrCont.getProperty("position")) != null) {
                Integer lap = new Integer(LegendArea.convertPositionToInt(pNode.getValueAsString()));
                if (map != null) {
                    map.put("position", lap);
                } else {
                    this.getLegendArea().setPosition(lap);
                }
            }
            Enumeration sfxNodes = attrCont.getContainerNodes();
            while (sfxNodes.hasMoreElements()) {
                Object sfxNode = sfxNodes.nextElement();
                if (sfxNode == null || !(sfxNode instanceof ContainerNode)) continue;
                this.getLegendArea().getSFX().setXML((ContainerNode)sfxNode, reset != 0);
            }
        }
        if ((attrCont = node.getContainer(NAME_LEGENDTEXT)) != null) {
            if (this.m_jsfHashMap != null) {
                map = new HashMap();
                this.m_jsfHashMap.put(NAME_LEGENDTEXT, map);
            }
            Enumeration nodes = attrCont.getContainerNodes();
            while (nodes.hasMoreElements()) {
                ContainerNode fontNode = (ContainerNode)nodes.nextElement();
                if (fontNode == null || !(fontNode instanceof ContainerNode)) continue;
                if (map != null) {
                    this.setGaugeFontXML((BaseObjectNode)fontNode, NAME_GAUGEFONT, map);
                    continue;
                }
                this.setGaugeFontXML((BaseObjectNode)fontNode, "LegendTextFont");
            }
            pNode = attrCont.getProperty(a_numberType);
            if (pNode != null) {
                Integer type = new Integer(CommonGauge.convertNumberTypeToInt(pNode.getValueAsString()));
                if (map != null) {
                    map.put(a_numberType, type);
                } else {
                    this.getLegendText().setNumberType(type);
                }
            }
            if ((pNode = attrCont.getProperty(a_minLength)) != null) {
                Integer type = new Integer(pNode.getValueAsInteger());
                if (map != null) {
                    map.put(a_minLength, type);
                } else {
                    this.getLegendText().setMinLength(type);
                }
            }
        }
        if ((attrCont = node.getContainer(NAME_LEGENDTITLE)) != null) {
            if (this.m_jsfHashMap != null) {
                map = new HashMap();
                this.m_jsfHashMap.put(NAME_LEGENDTITLE, map);
            }
            if ((pNode = attrCont.getProperty("visible")) != null) {
                Boolean b = pNode.getValueAsBoolean();
                if (map != null) {
                    map.put("rendered", b);
                } else {
                    this.getLegendTitle().setVisible(b);
                }
            }
            if ((pNode = attrCont.getProperty("rendered")) != null) {
                Boolean b = pNode.getValueAsBoolean();
                if (map != null) {
                    map.put("rendered", b);
                } else {
                    this.getLegendTitle().setVisible(b);
                }
            }
            Enumeration nodes = attrCont.getContainerNodes();
            while (nodes.hasMoreElements()) {
                ContainerNode fontNode = (ContainerNode)nodes.nextElement();
                if (fontNode == null || !(fontNode instanceof ContainerNode)) continue;
                if (map != null) {
                    this.setGaugeFontXML((BaseObjectNode)fontNode, NAME_GAUGEFONT, map);
                    continue;
                }
                this.setGaugeFontXML((BaseObjectNode)fontNode, "LegendTitleFont");
            }
            pNode = attrCont.getProperty("text");
            if (pNode != null) {
                String ltt = pNode.getValueAsString();
                if (map != null) {
                    map.put("text", ltt);
                } else {
                    this.getLegendTitle().setText(ltt);
                }
            }
        }
        LocalXMLDataSource xmlDS = null;
        DataSpecification dataSpecs = null;
        ObjectNode localGridData = node.getPropertyValueAsObjectNode("LocalGridData", true);
        ContainerNode localRelationalData = node.getContainer("LocalRelationalData");
        ObjectNode vennData = node.getPropertyValueAsObjectNode(NAME_VENNDATA, true);
        if (localGridData != null) {
            xmlDS = this.createLocalGridDataSource(localGridData);
            ContainerNode specCont = localGridData.getContainer(NAME_DATASPECIFICATION);
            if (specCont != null) {
                dataSpecs = new DataSpecification();
                dataSpecs.setXML(specCont);
            }
        } else if (localRelationalData != null) {
            xmlDS = this.createLocalRelationalDataSource(localRelationalData);
            Enumeration nodeEnum = localRelationalData.getContainerNodes(NAME_DATASPECIFICATION);
            if (nodeEnum != null) {
                while (nodeEnum.hasMoreElements()) {
                    Object objNode = nodeEnum.nextElement();
                    if (objNode == null || !(objNode instanceof ContainerNode)) continue;
                    dataSpecs = new DataSpecification();
                    dataSpecs.setXML((ContainerNode)objNode);
                }
            }
        } else if (vennData != null) {
            pNode = vennData.getProperty(a_aValue);
            if (pNode != null) {
                this.setAttribute("ElementAValue", new Double(pNode.getValueAsDouble()));
            }
            if ((pNode = vennData.getProperty(a_bValue)) != null) {
                this.setAttribute("ElementBValue", new Double(pNode.getValueAsDouble()));
            }
            if ((pNode = vennData.getProperty(a_abValue)) != null) {
                this.setAttribute("IntersectionABValue", new Double(pNode.getValueAsDouble()));
            }
            if ((pNode = vennData.getProperty(a_aTopLabel)) != null) {
                this.setAttribute("ElementATopLabel", pNode.getValueAsString());
            }
            if ((pNode = vennData.getProperty(a_aBottomLabel)) != null) {
                this.setAttribute("ElementABottomLabel", pNode.getValueAsString());
            }
            if ((pNode = vennData.getProperty(a_abTopLabel)) != null) {
                this.setAttribute("IntersectionABTopLabel", pNode.getValueAsString());
            }
            if ((pNode = vennData.getProperty(a_abBottomLabel)) != null) {
                this.setAttribute("IntersectionABBottomLabel", pNode.getValueAsString());
            }
            if ((pNode = vennData.getProperty(a_bTopLabel)) != null) {
                this.setAttribute("ElementBTopLabel", pNode.getValueAsString());
            }
            if ((pNode = vennData.getProperty(a_bBottomLabel)) != null) {
                this.setAttribute("ElementBBottomLabel", pNode.getValueAsString());
            }
        }
        boolean newDS = false;
        if (xmlDS != null) {
            ThickDataview view = this.getThickDataview();
            if (view != null) {
                view.setDataSource(xmlDS);
            } else {
                this._setLocalXMLDataSource(xmlDS);
            }
            newDS = true;
        }
        if (dataSpecs != null) {
            this.setDataSpecification(dataSpecs);
        }
        if (newDS) {
            this.setRecalcState(2);
            this._generateGaugeEngines();
        }
        if ((attrCont = node.getContainer(NAME_GAUGE)) != null) {
            Enumeration attrNodes = attrCont.getContainedObject();
            while (attrNodes.hasMoreElements()) {
                ObjectNode gaugeFont;
                attrNode = (ObjectNode)attrNodes.nextElement();
                if (attrNode.getName().equals("Background")) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put("Background", map);
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getGaugeBackground().setFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getGaugeBackground().setBorderColor(clr);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getGaugeBackground().getSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_GAUGEFRAME)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_GAUGEFRAME, map);
                    }
                    if ((pNode = attrNode.getProperty("visible")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getGaugeFrame().setVisible(b);
                        }
                    }
                    if ((pNode = attrCont.getProperty("rendered")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getGaugeFrame().setVisible(b);
                        }
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getGaugeFrame().setFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getGaugeFrame().setBorderColor(clr);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getGaugeFrame().getSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_PLOTAREA)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_PLOTAREA, map);
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getPlotArea().setFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getPlotArea().setBorderColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_useThresholdFillColor)) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put(a_useThresholdFillColor, b);
                        } else {
                            this.getPlotArea().setUseThresholdFillColor(b);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getPlotArea().getSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_UPPERLABELFRAME)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_UPPERLABELFRAME, map);
                    }
                    if ((pNode = attrNode.getProperty("visible")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getUpperLabelFrame().setVisible(b);
                        }
                    }
                    if ((pNode = attrCont.getProperty("rendered")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getUpperLabelFrame().setVisible(b);
                        }
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getUpperLabelFrame().setFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getUpperLabelFrame().setBorderColor(clr);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getUpperLabelFrame().getSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_LOWERLABELFRAME)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_LOWERLABELFRAME, map);
                    }
                    if ((pNode = attrNode.getProperty("visible")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getLowerLabelFrame().setVisible(b);
                        }
                    }
                    if ((pNode = attrCont.getProperty("rendered")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getLowerLabelFrame().setVisible(b);
                        }
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getLowerLabelFrame().setFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getLowerLabelFrame().setBorderColor(clr);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getLowerLabelFrame().getSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_TOPLABEL)) {
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_TOPLABEL, map);
                    }
                    if ((gaugeFont = attrNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "TopLabelFont");
                        }
                    }
                    if ((pNode = attrNode.getProperty("position")) != null) {
                        Integer mlp = new Integer(TopLabel.convertLabelPositionToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put("TopLabelPosition", mlp);
                        } else {
                            this.getTopLabel().setPosition(mlp);
                        }
                    }
                } else if (attrNode.getName().equals(NAME_BOTTOMLABEL)) {
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_BOTTOMLABEL, map);
                    }
                    if ((gaugeFont = attrNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "BottomLabelFont");
                        }
                    }
                    if ((pNode = attrNode.getProperty("position")) != null) {
                        Integer mlp = new Integer(BottomLabel.convertLabelPositionToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put("BottomLabelPosition", mlp);
                        } else {
                            this.getBottomLabel().setPosition(mlp);
                        }
                    }
                } else if (attrNode.getName().equals(NAME_METRICLABEL)) {
                    ObjectNode viewFormatNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_METRICLABEL, map);
                    }
                    if ((gaugeFont = attrNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "MetricLabelFont");
                        }
                    }
                    if ((pNode = attrNode.getProperty("position")) != null) {
                        Integer mlp = new Integer(MetricLabel.convertLabelPositionToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put("position", mlp);
                        } else {
                            this.getMetricLabel().setPosition(mlp);
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_numberType)) != null) {
                        Integer type = new Integer(CommonGauge.convertNumberTypeToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put(a_numberType, type);
                        } else {
                            this.getMetricLabel().setNumberType(type);
                        }
                    }
                    if ((viewFormatNode = attrNode.getPropertyValueAsObjectNode("ViewFormat", true)) != null) {
                        ViewFormat mvf = new ViewFormat();
                        if (map != null) {
                            mvf.setXML(viewFormatNode, version, reset, map);
                        } else {
                            mvf.setXML(viewFormatNode, version, reset);
                        }
                        this.getMetricLabel().setViewFormat(mvf);
                    }
                } else if (attrNode.getName().equals(NAME_INDICATOR)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_INDICATOR, map);
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getIndicator().setFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getIndicator().setBorderColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_indicatorType)) != null) {
                        Integer type = new Integer(Indicator.convertTypeToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put(a_indicatorType, type);
                        } else {
                            this.getIndicator().setType(type);
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_useThresholdFillColor)) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put(a_useThresholdFillColor, b);
                        } else {
                            this.getIndicator().setUseThresholdFillColor(b);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getIndicator().getSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_INDICATORBAR)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_INDICATORBAR, map);
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getIndicator().setBarFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getIndicator().setBarBorderColor(clr);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getIndicator().getBarSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_INDICATORBASE)) {
                    ContainerNode sfxNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_INDICATORBASE, map);
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("fillColor", clr);
                        } else {
                            this.getIndicator().setBaseFillColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put("borderColor", clr);
                        } else {
                            this.getIndicator().setBaseBorderColor(clr);
                        }
                    }
                    if ((pNode = attrNode.getProperty("visible")) != null) {
                        Boolean b = pNode.getValueAsBoolean();
                        if (map != null) {
                            map.put("rendered", b);
                        } else {
                            this.getIndicator().setBaseVisible(b);
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getIndicator().getBaseSFX().setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_THRESHOLD)) {
                    ContainerNode sfxNode;
                    int tIndex = -1;
                    pNode = attrNode.getProperty("index");
                    if (pNode != null) {
                        tIndex = pNode.getValueAsInteger();
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        this.getThreshold().setFillColor(tIndex, DataviewUtils.hexStringToColor(pNode.getValueAsString()));
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        this.getThreshold().setBorderColor(tIndex, DataviewUtils.hexStringToColor(pNode.getValueAsString()));
                    }
                    if ((pNode = attrNode.getProperty("text")) != null) {
                        this.getThreshold().setText(tIndex, pNode.getValueAsString());
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        this.getThreshold().getSFX(tIndex).setXML(sfxNode, reset != 0);
                    }
                } else if (attrNode.getName().equals(NAME_TICKLABEL)) {
                    ObjectNode viewFormatNode;
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_TICKLABEL, map);
                    }
                    if ((gaugeFont = attrNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "TickLabelFont");
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_content)) != null) {
                        Integer content = new Integer(CommonGauge.convertTickContentToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put(a_content, content);
                        } else {
                            this.getTickLabel().setContent(content);
                        }
                    }
                    if ((viewFormatNode = attrNode.getPropertyValueAsObjectNode("ViewFormat", true)) != null) {
                        ViewFormat mvf = new ViewFormat();
                        if (map != null) {
                            mvf.setXML(viewFormatNode, version, reset, map);
                        } else {
                            mvf.setXML(viewFormatNode, version, reset);
                        }
                        this.getTickLabel().setViewFormat(mvf);
                    }
                    if ((pNode = attrNode.getProperty(a_numberType)) != null) {
                        Integer type = new Integer(CommonGauge.convertNumberTypeToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put(a_numberType, type);
                        } else {
                            this.getTickLabel().setNumberType(type);
                        }
                    }
                } else if (attrNode.getName().equals(NAME_TICKMARK)) {
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        this.m_jsfHashMap.put(NAME_TICKMARK, map);
                    }
                    if ((pNode = attrNode.getProperty(a_content)) != null) {
                        Integer content = new Integer(CommonGauge.convertTickContentToInt(pNode.getValueAsString()));
                        if (map != null) {
                            map.put(a_content, content);
                        } else {
                            this.getTickMark().setContent(content);
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_majorTickCount)) != null) {
                        Integer majorTickCount = pNode.getValueAsInteger();
                        if (map != null) {
                            map.put(a_majorTickCount, majorTickCount);
                        } else {
                            this.getTickMark().setMajorTickCount(majorTickCount);
                        }
                    }
                    if ((pNode = attrNode.getProperty(a_majorTickColor)) != null) {
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put(a_majorTickColor, clr);
                        } else {
                            this.getTickMark().setMajorTickColor(clr);
                        }
                    }
                } else if (attrNode.getName().equals(NAME_VENNELEMENT)) {
                    ContainerNode sfxNode;
                    ObjectNode elemLblNode;
                    String id = veid_a;
                    pNode = attrNode.getProperty("id");
                    if (pNode != null) {
                        id = pNode.getValueAsString();
                    }
                    if (this.m_jsfHashMap != null) {
                        map = new HashMap();
                        if (id.equals(veid_a)) {
                            this.m_jsfHashMap.put("ElementA", map);
                        } else if (id.equals(veid_b)) {
                            this.m_jsfHashMap.put("ElementB", map);
                        } else {
                            this.m_jsfHashMap.put("IntersectionAB", map);
                        }
                    }
                    if ((pNode = attrNode.getProperty("fillColor")) != null) {
                        String key = "ElementAFillColor";
                        if (id.equals(veid_b)) {
                            key = "ElementBFillColor";
                        } else if (id.equals(veid_ab)) {
                            key = "IntersectionABFillColor";
                        }
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put(key, clr);
                        }
                        this.setAttribute(key, clr);
                    }
                    if ((pNode = attrNode.getProperty("borderColor")) != null) {
                        String key = "ElementABorderColor";
                        if (id.equals(veid_b)) {
                            key = "ElementBBorderColor";
                        } else if (id.equals(veid_ab)) {
                            key = "IntersectionABBorderColor";
                        }
                        Color clr = DataviewUtils.hexStringToColor(pNode.getValueAsString());
                        if (map != null) {
                            map.put(key, clr);
                        }
                        this.setAttribute(key, clr);
                    }
                    if ((elemLblNode = attrNode.getPropertyValueAsObjectNode(NAME_TOPLABEL, true)) != null && (gaugeFont = elemLblNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "TopLabelFont");
                        }
                    }
                    if ((elemLblNode = attrNode.getPropertyValueAsObjectNode(NAME_BOTTOMLABEL, true)) != null && (gaugeFont = elemLblNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "BottomLabelFont");
                        }
                    }
                    if ((elemLblNode = attrNode.getPropertyValueAsObjectNode(NAME_METRICLABEL, true)) != null && (gaugeFont = elemLblNode.getPropertyValueAsObjectNode(NAME_GAUGEFONT, true)) != null) {
                        if (map != null) {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, NAME_GAUGEFONT, map);
                        } else {
                            this.setGaugeFontXML((BaseObjectNode)gaugeFont, "MetricLabelFont");
                        }
                    }
                    if ((sfxNode = attrNode.getContainer(NAME_SFX)) != null) {
                        if (id.equals(veid_a)) {
                            this.getElementA().getSFX().setXML(sfxNode, reset != 0);
                        } else if (id.equals(veid_b)) {
                            this.getElementB().getSFX().setXML(sfxNode, reset != 0);
                        } else {
                            this.getIntersectionAB().getSFX().setXML(sfxNode, reset != 0);
                        }
                    }
                }
                if (map == null) continue;
                map = null;
            }
        }
        if ((attrNode = node.getPropertyValueAsObjectNode("DataviewTitle", true)) != null) {
            ((BaseTitleAttributes)this.getDataviewTitle()).setXML(attrNode, version, reset);
        }
        if ((attrNode = node.getPropertyValueAsObjectNode("DataviewSubtitle", true)) != null) {
            ((BaseTitleAttributes)this.getDataviewSubtitle()).setXML(attrNode, version, reset);
        }
        if ((attrNode = node.getPropertyValueAsObjectNode("DataviewFootnote", true)) != null) {
            ((BaseTitleAttributes)this.getDataviewFootnote()).setXML(attrNode, version, reset);
        }
    }

    @Override
    public void setStylePath(String stylePath) throws IOException, BIIOException, BISAXException, BIParseException {
    }

    protected void processAlertEvent(int eventID) {
        AlertEvent e = new AlertEvent(this, eventID);
        Object[] listeners = this.getAlertListenerList().getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == AlertListener.class) {
                ((AlertListener)listeners[i + 1]).alert(e);
            }
            i -= 2;
        }
    }

    protected EventListenerList getAlertListenerList() {
        return this.m_listenerList;
    }

    protected void setAlertListenerList(EventListenerList list) {
        this.m_listenerList = list;
    }

    private void _addLabelsToMap(int row, int column, Map dataMap) {
        String bottomLabel;
        String topLabel = this._getDataLabel(0, this.m_measureLayer, column);
        if (topLabel != null) {
            dataMap.put(NAME_TOPLABEL, topLabel);
        }
        if ((bottomLabel = this._getDataLabel(1, this.m_measureLayer, row)) != null) {
            dataMap.put(NAME_BOTTOMLABEL, bottomLabel);
        }
    }

    private boolean _addSlicesToMaps(List maps, String dataType, int tIndex, int startRow, int endRow, int startCol, int endCol) {
        int secEnd;
        int primEnd;
        int primIdx;
        boolean useRowAsPrimary;
        HashMap<String, Object> dataMap = null;
        boolean bl = useRowAsPrimary = this.getGaugeSetDirection() == 0;
        if (useRowAsPrimary) {
            primIdx = startRow;
            primEnd = endRow;
            secEnd = endCol;
        } else {
            primIdx = startCol;
            primEnd = endCol;
            secEnd = endRow;
        }
        if (dataType.equals(dst_metric)) {
            this.m_dsRows = endRow - startRow + 1;
            this.m_dsColumns = endCol - startCol + 1;
        }
        while (primIdx <= primEnd) {
            int secIdx = useRowAsPrimary ? startCol : startRow;
            while (secIdx <= secEnd) {
                dataMap = null;
                try {
                    Double value;
                    Object valueObj = this.getDataAccess().getValue(useRowAsPrimary ? primIdx : secIdx, useRowAsPrimary ? secIdx : primIdx, "dataValue");
                    Object linkObj = null;
                    if (this.m_dataLinks != null) {
                        linkObj = this.m_dataLinks[useRowAsPrimary ? secIdx : primIdx][useRowAsPrimary ? primIdx : secIdx];
                    }
                    if (valueObj == null) {
                        value = null;
                    } else {
                        Double d = value = valueObj instanceof Double ? (Double)valueObj : Double.valueOf(valueObj.toString());
                    }
                    if (dataType.equals(dst_metric)) {
                        dataType = "Metric";
                    } else if (dataType.equals(dst_minimum)) {
                        dataType = "minValue";
                    } else if (dataType.equals(dst_maximum)) {
                        dataType = "maxValue";
                    } else if (dataType.equals(dst_threshold)) {
                        dataType = "ThresholdValues";
                    }
                    boolean added = this._addValueToExistingMap(useRowAsPrimary ? primIdx : secIdx, useRowAsPrimary ? secIdx : primIdx, maps, value, linkObj, dataType, tIndex);
                    if (!added) {
                        dataMap = new HashMap<String, Object>(8);
                        if (dataType.equals("ThresholdValues")) {
                            this._addThresholdToMap(dataMap, tIndex, value);
                        } else {
                            dataMap.put(dataType, value);
                        }
                        if (linkObj != null) {
                            dataMap.put("Link", linkObj);
                        }
                        dataMap.put(DS_ROW, new Integer(useRowAsPrimary ? primIdx : secIdx));
                        dataMap.put(DS_COLUMN, new Integer(useRowAsPrimary ? secIdx : primIdx));
                        maps.add(dataMap);
                        if (dataType.equals("Metric")) {
                            this._addLabelsToMap(useRowAsPrimary ? primIdx : secIdx, useRowAsPrimary ? secIdx : primIdx, dataMap);
                            dataMap.put(METRIC_ROW, new Integer(useRowAsPrimary ? primIdx : secIdx));
                            dataMap.put(METRIC_COLUMN, new Integer(useRowAsPrimary ? secIdx : primIdx));
                        }
                    }
                }
                catch (ColumnOutOfRangeException coore) {
                    this.getErrorHandler().log(coore.getMessage(), this.getClass().getName(), m_method__addSlicesToMaps);
                }
                catch (RowOutOfRangeException roore) {
                    this.getErrorHandler().log(roore.getMessage(), this.getClass().getName(), m_method__addSlicesToMaps);
                }
                catch (NumberFormatException nfe) {
                    this.getErrorHandler().log(dataType + " cell contains non-Double data", this.getClass().getName(), m_method__addSlicesToMaps);
                }
                ++secIdx;
            }
            ++primIdx;
        }
        return true;
    }

    private boolean _addThresholdToMap(Map dataMap, int index, Double value) {
        boolean added = false;
        double[] values = (double[])dataMap.get("ThresholdValues");
        if (values == null || values.length < index + 1) {
            double[] newValues = new double[index + 1];
            int i = 0;
            while (i < newValues.length) {
                newValues[i] = 0.45344435444344;
                ++i;
            }
            if (values != null) {
                System.arraycopy(values, 0, newValues, 0, values.length);
            }
            if (value != null) {
                newValues[index] = value;
            }
            values = newValues;
            dataMap.put("ThresholdValues", values);
            added = true;
        } else if (values[index] == 0.45344435444344) {
            if (value != null) {
                values[index] = value;
            }
            dataMap.put("ThresholdValues", values);
            added = true;
        }
        return added;
    }

    private boolean _addValueToExistingMap(int row, int column, List maps, Number value, Object link, String dataType, int tIndex) {
        Double val = value == null ? null : Double.valueOf(value.toString());
        String attr = this.m_measureEdge == 0 ? DS_ROW : DS_COLUMN;
        boolean added = false;
        int i = 0;
        while (i < maps.size()) {
            Map tempMap = (Map)maps.get(i);
            int dsIndex = (Integer)tempMap.get(attr);
            if (tempMap.containsKey(attr) && dsIndex == (attr == DS_ROW ? row : column)) {
                if (dataType.equals("ThresholdValues")) {
                    added = this._addThresholdToMap(tempMap, tIndex, val);
                } else if (!tempMap.containsKey(dataType)) {
                    tempMap = (Map)maps.remove(i);
                    tempMap.put(dataType, val);
                    if (tempMap != null && dataType.equals("Metric")) {
                        tempMap.put(METRIC_ROW, new Integer(row));
                        tempMap.put(METRIC_COLUMN, new Integer(column));
                    }
                    if (link != null) {
                        tempMap.put("Link", link);
                    }
                    maps.add(i, tempMap);
                    if (dataType.equals("Metric")) {
                        this._addLabelsToMap(row, column, tempMap);
                    }
                    added = true;
                }
                if (added) break;
            }
            ++i;
        }
        return added;
    }

    private void _applySelectedObject() {
        if (this.m_selObj == null) {
            return;
        }
        for (GaugeSetKey key : this.m_gaugeEngines.keySet()) {
            GaugeEngine engine = (GaugeEngine)this.m_gaugeEngines.get(key);
            engine.setSelectedObject(this.m_selObj.getID());
        }
    }

    private int _buildGSKKey(int row, int col) {
        int code = 0;
        int[] primes = new int[]{1, 3, 5, 7, 11};
        int[] vars = new int[]{row, col};
        int i = 0;
        while (i < vars.length) {
            code += vars[i] * primes[primes.length - 1 - i];
            ++i;
        }
        return code;
    }

    private void _clearInternalLayoutProps() {
        this.m_gsNumWide = -1;
        this.m_gsNumTall = -1;
        this.m_gsKeys = new HashMap();
    }

    public static int convertTickContentToInt(String contentStr) {
        if (contentStr.equals(tc_none)) {
            return 0;
        }
        int content = 0;
        if (contentStr.indexOf(tc_minmax) != -1) {
            content |= 3;
        }
        if (contentStr.indexOf(tc_increments) != -1) {
            content |= 4;
        }
        if (contentStr.indexOf(tc_majortick) != -1) {
            content |= 0x20;
        }
        if (contentStr.indexOf(tc_threshold) != -1) {
            content |= 8;
        }
        if (contentStr.indexOf(tc_metric) != -1) {
            content |= 0x10;
        }
        return content;
    }

    public static String convertTickContentToString(int content) {
        if (content == 0) {
            return tc_none;
        }
        StringBuilder contentBuf = new StringBuilder();
        if ((content & 3) != 0) {
            contentBuf.append(tc_minmax);
            contentBuf.append(" ");
        }
        if ((content & 4) != 0) {
            contentBuf.append(tc_increments);
            contentBuf.append(" ");
        }
        if ((content & 0x20) != 0) {
            contentBuf.append(tc_majortick);
            contentBuf.append(" ");
        }
        if ((content & 8) != 0) {
            contentBuf.append(tc_threshold);
            contentBuf.append(" ");
        }
        if ((content & 0x10) != 0) {
            contentBuf.append(tc_metric);
            contentBuf.append(" ");
        }
        return contentBuf.toString();
    }

    public static int convertGaugeSetAlignmentToInt(String align) {
        int gsAlign = 0;
        if (align.equals(gsa_topleft)) {
            gsAlign = 3;
        } else if (align.equals(gsa_top)) {
            gsAlign = 1;
        } else if (align.equals(gsa_topright)) {
            gsAlign = 9;
        } else if (align.equals(gsa_right)) {
            gsAlign = 8;
        } else if (align.equals(gsa_bottomright)) {
            gsAlign = 12;
        } else if (align.equals(gsa_bottom)) {
            gsAlign = 4;
        } else if (align.equals(gsa_bottomleft)) {
            gsAlign = 6;
        } else if (align.equals(gsa_left)) {
            gsAlign = 2;
        } else if (align.equals(gsa_center)) {
            gsAlign = 15;
        }
        return gsAlign;
    }

    public static String convertGaugeSetAlignmentToString(int align) {
        String gsAlign = gsa_none;
        if (align == 3) {
            gsAlign = gsa_topleft;
        } else if (align == 1) {
            gsAlign = gsa_top;
        } else if (align == 9) {
            gsAlign = gsa_topright;
        } else if (align == 8) {
            gsAlign = gsa_right;
        } else if (align == 12) {
            gsAlign = gsa_bottomright;
        } else if (align == 4) {
            gsAlign = gsa_bottom;
        } else if (align == 6) {
            gsAlign = gsa_bottomleft;
        } else if (align == 2) {
            gsAlign = gsa_left;
        } else if (align == 15) {
            gsAlign = gsa_center;
        }
        return gsAlign;
    }

    public static int convertGaugeSetColCountToInt(String colCount) {
        int gsColCount = -1;
        if (!colCount.equals(gsc_auto)) {
            gsColCount = Integer.parseInt(colCount);
        }
        return gsColCount;
    }

    public static String convertGaugeSetColCountToString(int colCount) {
        String gsColCount = gsc_auto;
        if (colCount != -1) {
            gsColCount = Integer.toString(colCount);
        }
        return gsColCount;
    }

    public static int convertGaugeSetDirectionToInt(String value) {
        int align = 0;
        if (value.equals(gsd_down)) {
            align = 1;
        }
        return align;
    }

    public static String convertGaugeSetDirectionToString(int value) {
        String align = gsd_across;
        if (value == 1) {
            align = gsd_down;
        }
        return align;
    }

    private DataSpecification _createDataSpecsFromLabels(Object[] specs, Object[] labels) {
        int bottomLblColIndex;
        DataSpecification dataSpecs = null;
        Vector colList = Utility.copyArrayToVector((Object[])specs);
        int topLblColIndex = colList.indexOf(dst_toplabel);
        int numLabelTypes = (topLblColIndex != -1 ? 1 : 0) + ((bottomLblColIndex = colList.indexOf(dst_bottomlabel)) != -1 ? 1 : 0);
        int numDataTypes = specs.length - numLabelTypes;
        if (numDataTypes != labels.length) {
            this.getErrorHandler().log("number of data specifications do not match count", this.getClass().getName(), m_method__createDataSpecsFromLabels);
        } else {
            boolean atLeastOneAdded = false;
            dataSpecs = new DataSpecification();
            int lblIndex = 0;
            int spec = 0;
            while (spec < specs.length) {
                boolean added;
                if (spec != topLblColIndex && spec != bottomLblColIndex && (added = dataSpecs.setDataSpecByName((String)specs[spec], (String)labels[lblIndex++]))) {
                    atLeastOneAdded = true;
                }
                ++spec;
            }
            if (!atLeastOneAdded) {
                dataSpecs = null;
            }
        }
        return dataSpecs;
    }

    private boolean _generateGaugeEngines() {
        this._clearInternalLayoutProps();
        int gaugeType = this.getGaugeType();
        List<HashMap<String, Integer>> dataMaps = new ArrayList();
        if (gaugeType != 3) {
            dataMaps = this._prepareMapEntries();
        } else {
            HashMap<String, Integer> vennMap = new HashMap<String, Integer>(8);
            vennMap.put(DS_ROW, new Integer(0));
            vennMap.put(DS_COLUMN, new Integer(0));
            vennMap.put(METRIC_ROW, new Integer(0));
            vennMap.put(METRIC_COLUMN, new Integer(0));
            dataMaps.add(vennMap);
            if (this.m_elementA == null) {
                this.m_elementA = new ElementA(this);
                this.m_elementB = new ElementB(this);
                this.m_intersectionAB = new IntersectionAB(this);
            }
        }
        try {
            Map geMaps = this._prepareGaugeEngineMaps(dataMaps);
            this._mergeAttributeMap(geMaps);
            this.m_gaugeEngines = new HashMap(geMaps.size());
            Set keySet = geMaps.keySet();
            int index = 0;
            for (GaugeSetKey key : keySet) {
                Map entry = (Map)geMaps.get(key);
                GaugeEngine engine = new GaugeEngine(entry, gaugeType);
                engine.setCustomShapesParser(this.m_csParser);
                engine.setDVTResources(this.m_dvtResources);
                engine.setErrorHandler(this.getErrorHandler());
                engine.setId(String.valueOf(index));
                ++index;
                this._applySelectedObject();
                this.m_gaugeEngines.put(key, engine);
            }
            this.setRecalcState(0);
            boolean bl = true;
            return bl;
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("Edge out of range", this.getClass().getName(), m_method__generateGaugeEngines);
            boolean bl = false;
            return bl;
        }
    }

    private void _generateImage(boolean fullSize) {
        if (this.m_currImage != null) {
            this.m_currImage.flush();
        }
        if (fullSize) {
            Dimension imageSize = new Dimension();
            ThickDataview view = this.getThickDataview();
            if (view != null) {
                imageSize = ((ThickGauge)view).getSize();
            }
            if (view == null || imageSize.width == 0 || imageSize.height == 0) {
                imageSize = this.getImageSize();
            }
            this.m_currImage = new BufferedImage(imageSize.width, imageSize.height, 2);
        } else {
            this.m_currImage = new BufferedImage(1, 1, 2);
        }
    }

    private Object[] _getSliceLabels(int edge, int layer) {
        Object[] colLabels = null;
        try {
            DataAccess da = this.getDataAccess();
            int colCount = da.getEdgeExtent(edge);
            colLabels = new Object[colCount];
            int i = 0;
            while (i < colCount) {
                colLabels[i] = da.getMemberMetadata(edge, layer, i, this.getMemberMetadataLabelType(edge));
                ++i;
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("no column edge to process for data specification", this.getClass().getName(), m_method__getSliceLabels);
        }
        catch (LayerOutOfRangeException loore) {
            this.getErrorHandler().log("invalid layer during column edge label processing for data specification", this.getClass().getName(), m_method__getSliceLabels);
        }
        catch (SliceOutOfRangeException soore) {
            this.getErrorHandler().log("invalid slice during column edge label processing for data specification", this.getClass().getName(), m_method__getSliceLabels);
        }
        return colLabels;
    }

    private String _getDataLabel(int edge, int layer, int slice) {
        StringBuilder label = new StringBuilder();
        try {
            int l = 0;
            while (l < this.getDataAccess().getLayerCount(edge)) {
                if (edge != this.m_measureEdge || l != this.m_measureLayer) {
                    if (label.length() != 0) {
                        label.append("; ");
                    }
                    if (this.m_metadataLabelFlag) {
                        Object labelObj = this.getDataAccess().getMemberMetadata(edge, l, slice, "value");
                        if (labelObj instanceof String) {
                            label.append((CharSequence)new StringBuilder((String)labelObj));
                        } else if (labelObj instanceof Integer) {
                            label.append((CharSequence)new StringBuilder((Integer)labelObj));
                        }
                    } else {
                        label.append((CharSequence)new StringBuilder((String)this.getDataAccess().getMemberMetadata(edge, l, slice, this.getMemberMetadataLabelType(edge))));
                    }
                }
                ++l;
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("Edge out of range", this.getClass().getName(), m_method__getDataLabel);
        }
        catch (LayerOutOfRangeException loore) {
            this.getErrorHandler().log("Layer out of range", this.getClass().getName(), m_method__getDataLabel);
        }
        catch (SliceOutOfRangeException soore) {
            this.getErrorHandler().log("Slice out of range", this.getClass().getName(), m_method__getDataLabel);
        }
        if (label.length() > 0) {
            return label.toString();
        }
        return null;
    }

    private GaugeSetKey _getGaugeSetKey(int row, int col) {
        Integer key = new Integer(this._buildGSKKey(row, col));
        if (this.m_gsKeys != null && this.m_gsKeys.containsKey(key)) {
            return (GaugeSetKey)this.m_gsKeys.get(key);
        }
        if (this.m_gsKeys == null) {
            this.m_gsKeys = new HashMap();
        }
        GaugeSetKey gsk = new GaugeSetKey(row, col);
        this.m_gsKeys.put(key, gsk);
        return gsk;
    }

    private int _getLayerIndex(int edge, String dimName) {
        if (this.getDataAccess() == null) {
            this.getErrorHandler().log("Data unavailable", this.getClass().getName(), m_method__getLayerIndex);
            return -1;
        }
        try {
            int layerCount = this.getDataAccess().getLayerCount(edge);
            int layer = 0;
            while (layer < layerCount) {
                if (dimName != null) {
                    String layerName = (String)this.getDataAccess().getLayerMetadata(edge, layer, "dimName");
                    if (layerName.equalsIgnoreCase(dimName)) {
                        int n = layer;
                        return n;
                    }
                } else {
                    boolean isMeasure = (Boolean)this.getDataAccess().getLayerMetadata(edge, layer, "dimIsMeasure");
                    if (isMeasure) {
                        int n = layer;
                        return n;
                    }
                }
                ++layer;
            }
        }
        catch (LayerOutOfRangeException eoore) {
            this.getErrorHandler().log("Layer out of range", this.getClass().getName(), m_method__getLayerIndex);
            int n = -1;
            return n;
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("Edge out of range", this.getClass().getName(), m_method__getLayerIndex);
            int n = -1;
            return n;
        }
        return -1;
    }

    private int _getMeasureDimEdge(String measDimName) {
        int layer = -1;
        int edge = 0;
        while (edge <= 3) {
            layer = this._getLayerIndex(edge, measDimName);
            if (layer != -1) {
                return edge;
            }
            ++edge;
        }
        return layer;
    }

    private int _getRecalcState() {
        return this.m_recalcState;
    }

    public void setRecalcState(int state) {
        this.m_recalcState = state;
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            view.repaint();
        }
    }

    private boolean _isImageValid() {
        return false;
    }

    private boolean _mergeAttributeMap(Map maps) {
        Map dataMap = null;
        if (!(this.m_gaugeAttributes != null && this.m_gaugeAttributes.size() != 0 || this.m_skinGaugeAttributes != null && this.m_skinGaugeAttributes.size() != 0)) {
            return false;
        }
        for (GaugeSetKey key : maps.keySet()) {
            Map attrMap;
            dataMap = (Map)maps.get(key);
            if (this.m_skinGaugeAttributes != null) {
                dataMap.putAll(this.m_skinGaugeAttributes);
            }
            if (this.m_gaugeAttributes == null) continue;
            if (this.m_gaugeAttributes.size() == 1 && this.m_gaugeAttributes.containsKey(GSKEY_UNDEFINED)) {
                attrMap = (Map)this.m_gaugeAttributes.get(GSKEY_UNDEFINED);
                dataMap.putAll(attrMap);
                continue;
            }
            Set attrKeySet = this.m_gaugeAttributes.keySet();
            if (!attrKeySet.contains(key)) continue;
            attrMap = (Map)this.m_gaugeAttributes.get(key);
            dataMap.putAll(attrMap);
        }
        return true;
    }

    private List _prepareMapEntries() {
        ArrayList dataMaps;
        block28: {
            if (this.getDataAccess() == null) {
                this.getErrorHandler().log("No maps created due to lack of data", this.getClass().getName(), m_method__prepareEntries);
                return null;
            }
            dataMaps = new ArrayList();
            this.m_measureLayer = -1;
            this.m_measureEdge = -1;
            if (this.m_dataSpecs == null || this.m_dataSpecs.isEmpty()) break block28;
            String metricName = this.m_dataSpecs.getMetric();
            String minName = this.m_dataSpecs.getMinimum();
            String maxName = this.m_dataSpecs.getMaximum();
            ArrayList thresholds = this.m_dataSpecs.getThresholds();
            String measDimName = this.m_dataSpecs.getMeasureDimensionName();
            int n = this.m_measureEdge = this.m_isUsingExternalData && measDimName != null ? this._getMeasureDimEdge(measDimName) : 0;
            if (this.m_measureEdge == -1 || this.m_measureEdge == 2) {
                return this._prepareMapsWithoutDataSpecs();
            }
            int n2 = this.m_measureLayer = this.m_isUsingExternalData && measDimName != null ? this._getLayerIndex(this.m_measureEdge, measDimName) : 0;
            if (this.m_measureLayer == -1) {
                return this._prepareMapsWithoutDataSpecs();
            }
            try {
                int totalSlices = this.getDataAccess().getEdgeExtent(this.m_measureEdge);
                int layerCount = this.getDataAccess().getLayerCount(this.m_measureEdge);
                int thresholdIndex = -1;
                int slice = 0;
                while (slice < totalSlices) {
                    block30: {
                        String dataType;
                        block29: {
                            dataType = null;
                            String valueName = (String)this.getDataAccess().getMemberMetadata(this.m_measureEdge, this.m_measureLayer, slice, "value");
                            if (valueName != null) {
                                if (valueName.equalsIgnoreCase(metricName)) {
                                    dataType = dst_metric;
                                } else if (minName != null && valueName.equalsIgnoreCase(minName)) {
                                    dataType = dst_minimum;
                                } else if (maxName != null && valueName.equalsIgnoreCase(maxName)) {
                                    dataType = dst_maximum;
                                } else if (thresholds != null && thresholds.indexOf(valueName) >= 0) {
                                    dataType = dst_threshold;
                                    thresholdIndex = thresholds.indexOf(valueName);
                                }
                            }
                            if (dataType != null) break block29;
                            valueName = (String)this.getDataAccess().getMemberMetadata(this.m_measureEdge, this.m_measureLayer, slice, this.getMemberMetadataLabelType(this.m_measureEdge));
                            if (valueName == null) break block30;
                            if (valueName.equalsIgnoreCase(metricName)) {
                                dataType = dst_metric;
                            } else if (minName != null && valueName.equalsIgnoreCase(minName)) {
                                dataType = dst_minimum;
                            } else if (maxName != null && valueName.equalsIgnoreCase(maxName)) {
                                dataType = dst_maximum;
                            } else if (thresholds != null && thresholds.indexOf(valueName) >= 0) {
                                dataType = dst_threshold;
                                thresholdIndex = thresholds.indexOf(valueName);
                            }
                        }
                        if (dataType != null) {
                            this._prepareMapsFromSlice(dataMaps, this.m_measureEdge, this.m_measureLayer, slice, dataType, thresholdIndex);
                        }
                        if (this.m_measureLayer < layerCount - 1) {
                            int extent = this.getDataAccess().getMemberExtent(this.m_measureEdge, this.m_measureLayer, slice);
                            slice += extent - 1;
                        }
                    }
                    ++slice;
                }
            }
            catch (EdgeOutOfRangeException eoore) {
                this.getErrorHandler().log("Edge out of range", this.getClass().getName(), m_method__prepareMaps);
                List list = this._prepareMapsWithoutDataSpecs();
                return list;
            }
            catch (LayerOutOfRangeException loore) {
                this.getErrorHandler().log("Layer out of range", this.getClass().getName(), m_method__prepareMaps);
                List list = this._prepareMapsWithoutDataSpecs();
                return list;
            }
            catch (SliceOutOfRangeException soore) {
                this.getErrorHandler().log("Slice out of range", this.getClass().getName(), m_method__prepareMaps);
                List list = this._prepareMapsWithoutDataSpecs();
                return list;
            }
        }
        return this._prepareMapsWithoutDataSpecs();
        DataMapComparator comp = new DataMapComparator(this.getGaugeSetDirection());
        Collections.sort(dataMaps, comp);
        return dataMaps;
    }

    @Override
    public String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (this.m_dvtResources != null) {
            return this.m_dvtResources.getResourceString(key);
        }
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource \"" + key + "\" in " + rBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            String string = key;
            return string;
        }
        return strTemp;
    }

    public String getErrorIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource \"" + key + "\" in " + rBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            String string = key;
            return string;
        }
        return strTemp;
    }

    private Map _prepareGaugeEngineMaps(List maps) throws EdgeOutOfRangeException {
        GaugeSetKey gsKey;
        HashMap<String, Integer> dataMap;
        boolean isAcross;
        HashMap geMap = new HashMap();
        int gsColCount = this.getGaugeSetColumnCount();
        int row = 0;
        int column = 0;
        if (maps == null) {
            this.getErrorHandler().log("Null maps passed to _prepareGaugeEngineMaps", this.getClass().getName(), "_prepareGaugeEngineMaps");
            return geMap;
        }
        int gaugeSetSize = maps.size();
        this.m_gsNumWide = gsColCount == -1 ? Math.max(this.m_dsColumns, 1) : (gsColCount == 0 ? gaugeSetSize : gsColCount);
        this.m_gsNumTall = (int)Math.ceil((double)gaugeSetSize / (double)this.m_gsNumWide);
        boolean bl = isAcross = this.getGaugeSetDirection() == 0;
        if (isAcross) {
            row = 0;
            while (row < this.m_gsNumTall) {
                column = 0;
                while (column < this.m_gsNumWide) {
                    if (!maps.isEmpty()) {
                        dataMap = (HashMap<String, Integer>)maps.remove(0);
                        gsKey = new GaugeSetKey(row, column);
                        this.m_gsKeys.put(new Integer(this._buildGSKKey(row, column)), gsKey);
                        geMap.put(gsKey, dataMap);
                    }
                    ++column;
                }
                ++row;
            }
        } else {
            column = 0;
            while (column < this.m_gsNumWide) {
                row = 0;
                while (row < this.m_gsNumTall) {
                    if (!maps.isEmpty()) {
                        dataMap = (Map)maps.remove(0);
                        gsKey = new GaugeSetKey(row, column);
                        this.m_gsKeys.put(new Integer(this._buildGSKKey(row, column)), gsKey);
                        geMap.put(gsKey, dataMap);
                    }
                    ++row;
                }
                ++column;
            }
        }
        if (geMap.size() == 0) {
            this.m_gsNumWide = 1;
            this.m_gsNumTall = 1;
            gsKey = new GaugeSetKey(0, 0);
            this.m_gsKeys.put(new Integer(this._buildGSKKey(0, 0)), gsKey);
            dataMap = new HashMap<String, Integer>(8);
            dataMap.put(DS_ROW, new Integer(0));
            dataMap.put(DS_COLUMN, new Integer(0));
            dataMap.put(METRIC_ROW, new Integer(0));
            dataMap.put(METRIC_COLUMN, new Integer(0));
            geMap.put(gsKey, dataMap);
        }
        return geMap;
    }

    private void _prepareMapsFromSlice(ArrayList maps, int edge, int depth, int slice, String type, int tIndex) {
        try {
            DataAccess da = this.getDataAccess();
            int totalRows = da.getEdgeExtent(1);
            int totalCols = da.getEdgeExtent(0);
            if (edge == 2) {
                maps.ensureCapacity(maps.size() + totalRows * totalCols);
                this._addSlicesToMaps(maps, type, tIndex, 0, totalRows - 1, 0, totalCols - 1);
            } else {
                int startSlice = da.getMemberStartSlice(edge, depth, slice);
                int extent = da.getMemberExtent(edge, depth, slice);
                maps.ensureCapacity(maps.size() + extent);
                if (edge == 0) {
                    this._addSlicesToMaps(maps, type, tIndex, 0, totalRows - 1, startSlice, startSlice + extent - 1);
                } else {
                    this._addSlicesToMaps(maps, type, tIndex, startSlice, startSlice + extent - 1, 0, totalCols - 1);
                }
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("Edge out of range", this.getClass().getName(), m_method__prepareMapsFromSlice);
        }
        catch (LayerOutOfRangeException loore) {
            this.getErrorHandler().log("Layer out of range", this.getClass().getName(), m_method__prepareMapsFromSlice);
        }
        catch (SliceOutOfRangeException soore) {
            this.getErrorHandler().log("Slice out of range", this.getClass().getName(), m_method__prepareMapsFromSlice);
        }
    }

    private List _prepareMapsWithoutDataSpecs() {
        DataAccess da = this.getDataAccess();
        ArrayList dataMaps = null;
        int rowCount = 0;
        int colCount = 0;
        try {
            rowCount = da.getEdgeExtent(1);
            colCount = da.getEdgeExtent(0);
            dataMaps = new ArrayList(rowCount * colCount);
        }
        catch (EdgeOutOfRangeException eoore) {
            this.getErrorHandler().log("Edge out of range", this.getClass().getName(), m_method__prepareMapsWithoutDataSpecs);
            List list = this._prepareMapsWithoutDataSpecs();
            return list;
        }
        if (dataMaps != null && rowCount > 0 && colCount > 0) {
            int secCount;
            int primCount;
            boolean useRowAsPrimary;
            boolean bl = useRowAsPrimary = this.getGaugeSetDirection() == 0;
            if (useRowAsPrimary) {
                primCount = rowCount;
                secCount = colCount;
            } else {
                primCount = colCount;
                secCount = rowCount;
            }
            this.m_dsRows = rowCount;
            this.m_dsColumns = colCount;
            int primIdx = 0;
            while (primIdx < primCount) {
                int secIdx = 0;
                while (secIdx < secCount) {
                    try {
                        HashMap<String, Number> map;
                        int row = useRowAsPrimary ? primIdx : secIdx;
                        int col = useRowAsPrimary ? secIdx : primIdx;
                        Object dataVal = da.getValue(row, col, "dataValue");
                        if (dataVal == null) {
                            this.getErrorHandler().log("data value not present in no-specs data source", this.getClass().getName(), m_method__prepareMapsWithoutDataSpecs);
                            map = new HashMap(2);
                        } else {
                            Double value = new Double(Double.parseDouble(dataVal.toString()));
                            map = new HashMap<String, Number>(3);
                            map.put("Metric", value);
                            this._addLabelsToMap(row, col, map);
                        }
                        map.put(DS_ROW, new Integer(row));
                        map.put(DS_COLUMN, new Integer(col));
                        map.put(METRIC_ROW, new Integer(row));
                        map.put(METRIC_COLUMN, new Integer(col));
                        dataMaps.add(map);
                    }
                    catch (ColumnOutOfRangeException coore) {
                        this.getErrorHandler().log("column exceeds total column count in DataAccess", this.getClass().getName(), m_method__prepareMapsWithoutDataSpecs);
                    }
                    catch (RowOutOfRangeException roore) {
                        this.getErrorHandler().log("row exceeds total row count in DataAccess", this.getClass().getName(), m_method__prepareMapsWithoutDataSpecs);
                    }
                    catch (NumberFormatException nfe) {
                        this.getErrorHandler().log("cell contains non-Double data", this.getClass().getName(), m_method__prepareMapsWithoutDataSpecs);
                    }
                    ++secIdx;
                }
                ++primIdx;
            }
        }
        return dataMaps;
    }

    private void _setLocalXMLDataSource(LocalXMLDataSource ds) {
        this.setDataDirector((DataDirector)ds);
        this.setDataAccess((DataAccess)ds);
        this.setMetadataViewStyleSupported(true);
        this.setMetadataDateSupported(true);
        this.setMetadataMediumLabelSupported(true);
        this.setMetadataShortLabelSupported(true);
        this.setLayerMetaLongLabelSupported(true);
        this.setLayerMetaMediumLabelSupported(true);
        this.setLayerMetaShortLabelSupported(true);
    }

    private boolean _setXML(XMLObjectReader reader, int reset) throws BIIOException, BISAXException, BIParseException {
        if (this.m_validateXML) {
            reader.setValidationMode(true);
            reader.setDTD("/oracle/dss/gauge/Gauge.dtd", NAME_GAUGE);
        }
        ObjectNode node = reader.readObjectNode();
        int newReset = reset;
        if (newReset < 0 || newReset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), m_method__setXML);
            newReset = 0;
        }
        this.setXML(node, newReset);
        return true;
    }

    private void _writeToPNG(OutputStream os) throws PNGInvalidParameterException, PNGException {
        PNGEncoder pngEncoder = new PNGEncoder(this.m_currImage, os, System.out);
        pngEncoder.encode();
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        try {
            this._saveXML = xml;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new BIPersistenceException(e.getMessage(), e);
        }
    }

    public void setXML(String xml, HashMap map) {
        this.m_jsfHashMap = map;
        this.m_jsfHashMap_Gauge = new HashMap();
        this.m_jsfHashMap.put(a_gauge, this.m_jsfHashMap_Gauge);
        try {
            try {
                this.setXML(xml, 0);
            }
            catch (Exception exception) {
                this.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "setXML(String xml, HashMap map)");
            }
        }
        finally {
            this.m_jsfHashMap = null;
            this.m_jsfHashMap_Gauge = null;
        }
    }

    public String getXMLAsString() {
        return this.getXML("GaugeSet", false);
    }

    public void initialize(Hashtable env) {
        if (env != null && env.containsKey("persistence_errorhandler")) {
            this.addErrorHandler((ErrorHandler)env.get("persistence_errorhandler"));
        }
        if (env != null && env.containsKey("persistence_locale")) {
            this.setLocale((Locale)env.get("persistence_locale"));
        }
        if (env != null && env.containsKey("migration") && env.containsKey("full_path_to_guid_converter")) {
            this._setXMLContext(env.get("migration"), env.get("full_path_to_guid_converter"));
            this.setContext();
        }
    }

    private void _setXMLContext(Object migration, Object converter) {
        ObjectScope scope = new ObjectScope();
        scope.addObject("migration", migration);
        scope.addObject("full_path_to_guid_converter", converter);
        XMLContext xmlcontext = new XMLContext();
        xmlcontext.setScope(scope);
        if (this.m_context == null) {
            this.m_context = new Hashtable();
        }
        this.m_context.put("xml_context", xmlcontext);
        this.setContext();
    }

    public void setContext() {
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (oldAttrs != null) {
            result.merge(oldAttrs);
        }
        result.setObjectType("Graph");
        String titleText = null;
        if (!this.getDataviewTitle().getText().equals("")) {
            titleText = this.getDataviewTitle().getText();
        }
        result.setTitle(titleText);
        result.setCompSubType1(CommonGauge.convertGaugeTypeToString(this.getGaugeType()));
        result.setObjectTypeVersion(1);
        return result;
    }

    @Override
    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] superAggr = super.getPersistableComponents();
        return superAggr;
    }

    @Override
    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            super.setPersistableComponents(persistables);
        }
    }

    protected void createPropertyOverrideFlags() {
        this._userOverrideFlags = this.createPropertyOverrideFlags(27);
        this._styleOverrideFlags = this.createPropertyOverrideFlags(27);
    }

    public void clearOverrideFlags() {
        if (!this.isStyleModified()) {
            return;
        }
        this.createPropertyOverrideFlags();
        ThickDataview view = this.getThickDataview();
        if (view != null) {
            ((Title)this.getDataviewTitle()).createPropertyOverrideFlags();
            ((Subtitle)this.getDataviewSubtitle()).createPropertyOverrideFlags();
            ((Footnote)this.getDataviewFootnote()).createPropertyOverrideFlags();
        } else {
            ((CommonBaseTitle)this.getDataviewTitle()).createPropertyOverrideFlags();
            ((CommonBaseTitle)this.getDataviewSubtitle()).createPropertyOverrideFlags();
            ((CommonBaseTitle)this.getDataviewFootnote()).createPropertyOverrideFlags();
        }
    }

    @Override
    public BitSet createPropertyOverrideFlags(int maxID) {
        return new BitSet(maxID);
    }

    @Override
    public void clearPropertyOverrideFlag(int attrID, BitSet overrideFlags) {
        if (attrID >= 0 && attrID < overrideFlags.size()) {
            overrideFlags.clear(attrID);
        }
    }

    protected void setPropertyOverrideFlags(int attrID) {
        this.setPropertyOverrideFlags(attrID, this._userOverrideFlags, this._styleOverrideFlags);
    }

    protected boolean isStyleOverrideFlag(int attrID) {
        return this.isPropertyOverrideFlag(attrID, this._styleOverrideFlags);
    }

    protected boolean isUserOverrideFlag(int attrID) {
        return this.isPropertyOverrideFlag(attrID, this._userOverrideFlags);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(obj, propName, oldValue, newValue);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == PropertyChangeListener.class) {
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(e);
            }
            i -= 2;
        }
    }

    private void $init$() {
        this.m_dataviewFootnote = null;
        this.m_dataviewTitle = null;
        this.m_dataviewSubtitle = null;
        this.m_validateXML = false;
        this.m_selObj = null;
        this.m_context = null;
        this._saveXML = null;
        this.m_gsKeys = new HashMap();
        this.m_hashMapMode = 0;
        this.m_gaugeAttributes = new HashMap();
        this.m_skinGaugeAttributes = new HashMap();
        this.m_gaugeSetAttributes = new HashMap();
        this.m_skinGaugeSetAttributes = new HashMap();
        this.m_isUsingExternalData = false;
        this.m_measureEdge = -1;
        this.m_measureLayer = -1;
        this.m_dsRows = -1;
        this.m_dsColumns = -1;
        this.m_dataLinks = null;
        this.m_SVGWriterProvider = null;
        this.m_svgHeaders = -1;
        this.m_svgScriptIdList = null;
        this._legAreaRect = null;
        this.m_csParser = null;
        this.listenerList = new EventListenerList();
        this.m_metaDateSupported = false;
        this.m_metaDrillParentDateSupported = false;
        this.m_metaDrillParentDateSpanSupported = false;
        this.m_metaDateSpanSupported = false;
        this.m_metaDrillSupported = false;
        this.m_recalcState = 0;
        this.m_jsfHashMap = null;
        this.m_jsfHashMap_Gauge = null;
        this._styleOverrideFlags = null;
        this._userOverrideFlags = null;
        this.m_dvtResources = null;
        this.m_flashGaugeLCID = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DataMapComparator
    implements Comparator {
        private int m_direction;

        public DataMapComparator(int direction) {
            this.m_direction = direction;
        }

        public int compare(Object dataMap1, Object dataMap2) {
            int secondaryKey2;
            String secondaryKey;
            int result;
            int primaryKey2;
            String primaryKey;
            String string = primaryKey = this.m_direction == 0 ? CommonGauge.DS_ROW : CommonGauge.DS_COLUMN;
            if (!(dataMap1 instanceof Map) || !(dataMap2 instanceof Map)) {
                throw new ClassCastException("Object(s) to compare in data map are not Map objects");
            }
            Map map1 = (Map)dataMap1;
            Map map2 = (Map)dataMap2;
            if (!map1.containsKey(primaryKey) || !map2.containsKey(primaryKey)) {
                throw new IllegalArgumentException(primaryKey + " entry not found in map object(s)");
            }
            int primaryKey1 = (Integer)map1.get(primaryKey);
            int n = primaryKey1 < (primaryKey2 = ((Integer)map2.get(primaryKey)).intValue()) ? -1 : (result = primaryKey1 == primaryKey2 ? 0 : 1);
            if (result != 0) {
                return result;
            }
            String string2 = secondaryKey = this.m_direction == 0 ? CommonGauge.DS_COLUMN : CommonGauge.DS_ROW;
            if (!map1.containsKey(secondaryKey) || !map2.containsKey(secondaryKey)) {
                throw new IllegalArgumentException(secondaryKey + " entry not found in map object(s)");
            }
            int secondaryKey1 = (Integer)map1.get(secondaryKey);
            result = secondaryKey1 < (secondaryKey2 = ((Integer)map2.get(secondaryKey)).intValue()) ? -1 : (secondaryKey1 == secondaryKey2 ? 0 : 1);
            return result;
        }
    }
}

