/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeExportXMLWriter;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.gauge.GaugeSVGWriter;
import oracle.dss.gauge.Graphics2DRenderer;
import oracle.dss.graph.flash.GaugeFlashRenderer;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.presutil.PresUtils;

public abstract class DrawableObject {
    private int m_compType;
    private Map m_map;
    private boolean m_selected;
    protected AffineTransform m_transform;

    public DrawableObject(int compType, AffineTransform transform) {
        this.m_compType = compType;
        this.m_transform = transform;
        this.m_selected = false;
    }

    public DrawableObject(int compType, Map map, AffineTransform transform) {
        this.m_compType = compType;
        this.m_transform = transform;
        this.m_selected = false;
        this.m_map = map;
    }

    public int getComponentType() {
        return this.m_compType;
    }

    public AffineTransform getAffineTransform() {
        return this.m_transform;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
    }

    public boolean render(GaugeRenderer renderer) {
        if (renderer instanceof GaugeFlashRenderer) {
            ((GaugeFlashRenderer)renderer).setCompType(this.m_compType);
        } else if (renderer instanceof GaugeSVGWriter) {
            ((GaugeSVGWriter)renderer).setCompType(this.m_compType);
            ((GaugeSVGWriter)renderer).setMap(this.m_map);
        } else if (renderer instanceof GaugeExportXMLWriter) {
            ((GaugeExportXMLWriter)renderer).init(this.m_compType, this.m_map);
        }
        AffineTransform saveAT = renderer.getTransform();
        AffineTransform at = null;
        Color selColor = GaugeDefaultValues.getSelectedObjectColor(this.getComponentType());
        if (this instanceof Shape) {
            java.awt.Shape shape;
            Shape shapeObj = (Shape)this;
            Color fillColor = shapeObj.getFillColor();
            Color borderColor = shapeObj.isSelected() ? selColor : shapeObj.getBorderColor();
            HashMap sfxMap = shapeObj.getSFX();
            Rectangle outer = shapeObj.getOuterRect();
            at = shapeObj.getAffineTransform();
            if (at != null) {
                renderer.applyTransform(at);
            }
            if ((shape = shapeObj.getShape()) == null) {
                return false;
            }
            if (sfxMap != null && sfxMap.get("shadowColor") != null && !(renderer instanceof GaugeExportXMLWriter)) {
                Integer sInner;
                Color sClr = (Color)sfxMap.get("shadowColor");
                Double shadowOffset = (Double)sfxMap.get("shadowDistance");
                if (shadowOffset == null) {
                    shadowOffset = new Double(4.0);
                }
                if ((sInner = (Integer)sfxMap.get("shadowInner")) == null || sInner == 0) {
                    sClr = new Color(sClr.getRed(), sClr.getGreen(), sClr.getBlue(), (int)((double)sClr.getAlpha() / (shadowOffset * 1.5)));
                    int i = 1;
                    while ((double)i <= shadowOffset) {
                        AffineTransform translate = AffineTransform.getTranslateInstance(i, i);
                        Shape shadow = new Shape(this.m_compType, this.m_map, translate.createTransformedShape(shape), null, sClr, null, null);
                        shadow.render(renderer);
                        ++i;
                    }
                }
            }
            if (shape instanceof Rectangle2D) {
                Rectangle rect = ((Rectangle2D)shape).getBounds();
                renderer.drawAndFillRect(rect, borderColor, fillColor, sfxMap);
            } else if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D roundRect = (RoundRectangle2D)shape;
                Rectangle rect = shape.getBounds();
                int arcWidth = (int)roundRect.getArcWidth();
                int arcHeight = (int)roundRect.getArcHeight();
                renderer.drawAndFillRoundedRect(rect, arcWidth, arcHeight, borderColor, fillColor, sfxMap);
            } else if (shape instanceof Arc2D) {
                renderer.drawAndFillArc((Arc2D)shape, borderColor, fillColor, sfxMap);
            } else if (shape instanceof Line2D) {
                Line2D l2d = (Line2D)shapeObj.getShape();
                renderer.drawLine((int)l2d.getX1(), (int)l2d.getY1(), (int)l2d.getX2(), (int)l2d.getY2(), shapeObj.getBorderColor());
            } else if (shape instanceof Polygon) {
                renderer.drawAndFillPolygon((Polygon)shape, borderColor, fillColor, sfxMap);
            } else if (shape instanceof Area) {
                if (renderer instanceof Graphics2DRenderer) {
                    ((Graphics2DRenderer)renderer).drawAndFillArea((Area)shape, outer, borderColor, fillColor, sfxMap);
                } else {
                    renderer.drawAndFillArea((Area)shape, borderColor, fillColor, sfxMap);
                }
            } else {
                renderer.drawAndFillShape(shape, borderColor, fillColor, sfxMap);
            }
            if (at != null) {
                renderer.setTransform(saveAT);
            }
        } else if (this instanceof Label) {
            Label label = (Label)this;
            Rectangle bounds = label.getBounds();
            Color clr = label.getFontColor();
            double angle = label.getAngle();
            if (angle == 0.0) {
                bounds = new Rectangle(bounds.x, bounds.y - 1, bounds.width, bounds.height);
            } else if (angle == 270.0) {
                bounds = new Rectangle(bounds.x - 2, bounds.y, bounds.width, bounds.height);
            }
            String text = label.getTruncatedText();
            at = label.getAffineTransform();
            if (at != null) {
                renderer.applyTransform(at);
            }
            renderer.drawString(text != null ? text : label.getText(), bounds.x, bounds.y + bounds.height, label.getFont(), clr, angle);
            if (label.isSelected()) {
                renderer.drawRect(bounds, selColor);
            }
            if (at != null) {
                renderer.setTransform(saveAT);
            }
        } else if (this instanceof Image) {
            Image imgObj = (Image)this;
            String imgURL = imgObj.getURL();
            if (imgURL == null) {
                return false;
            }
            at = imgObj.getAffineTransform();
            if (at != null) {
                renderer.applyTransform(at);
            }
            Rectangle2D rect = imgObj.getBounds();
            renderer.drawImage(imgURL, imgObj.getImage(), (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), imgObj.getImageObserver());
            if (at != null) {
                renderer.setTransform(saveAT);
            }
        } else if (this instanceof Transform) {
            Transform transformObj = (Transform)this;
            AffineTransform transform = transformObj.getTransform();
            if (!transformObj.isResetTransform()) {
                renderer.applyTransform(transform);
            } else {
                renderer.setTransform(transform);
            }
        }
        return true;
    }

    public abstract boolean contains(double var1, double var3, boolean var5);

    public static DrawableObject getLabelObject(Graphics2D g, String label, Font font, Color fontColor, Rectangle bounds, String labelType) {
        if (font == null || fontColor == null) {
            return null;
        }
        FontMetrics fm = g.getFontMetrics(font);
        int width = fm.stringWidth(label);
        if (width > bounds.width) {
            label = PresUtils.truncateText(label, fm, 2, bounds.width);
        }
        int compType = labelType.equals("TopLabel") || labelType.equals("ElementATopLabel") || labelType.equals("ElementBTopLabel") || labelType.equals("IntersectionABTopLabel") ? 16 : (labelType.equals("BottomLabel") || labelType.equals("ElementABottomLabel") || labelType.equals("ElementBBottomLabel") || labelType.equals("IntersectionABBottomLabel") ? 17 : (labelType.equals("MetricLabelPosition") ? 18 : (labelType.equals("LegendTextFont") ? 28 : (labelType.equals("LegendTitleFont") ? 29 : 22))));
        return new Label(compType, g, label, font, fontColor, bounds, labelType, null);
    }

    public static TickLabel getTickLabelObject(Graphics2D g, String text, Font font, Color fontColor, Rectangle bounds, int tickType) {
        --bounds.x;
        Rectangle lblRect = GaugeEngine.trimRectToText(g, font, bounds.x, bounds.y, bounds.width, bounds.height);
        TickLabel tickLbl = new TickLabel(12, g, text, font, fontColor, bounds, "TickLabelContent", null, tickType);
        tickLbl.setTruncatedBounds(lblRect);
        return tickLbl;
    }

    public static Dimension getLabelDimensions(Graphics2D g, Font f, String label) {
        if (g == null || f == null || label == null) {
            return null;
        }
        FontMetrics fm = g.getFontMetrics(f);
        int width = fm.stringWidth(label);
        int height = TextStyleObj.getFontHeight(fm, null);
        return new Dimension(width, height);
    }

    public static class Shape
    extends DrawableObject {
        private java.awt.Shape m_shape;
        private Color m_borderColor;
        private Color m_fillColor;
        private HashMap m_sfxMap;
        private Rectangle m_outer;

        public Shape(int compType, Map map, java.awt.Shape shape, Color borderColor, Color fillColor, HashMap sfxMap, AffineTransform transform) {
            super(compType, map, transform);
            this.m_shape = shape;
            this.m_borderColor = borderColor;
            this.m_fillColor = fillColor;
            this.m_sfxMap = sfxMap;
        }

        public Shape(int compType, java.awt.Shape shape, Color borderColor, Color fillColor, HashMap sfxMap, AffineTransform transform) {
            super(compType, transform);
            this.m_shape = shape;
            this.m_borderColor = borderColor;
            this.m_fillColor = fillColor;
            this.m_sfxMap = sfxMap;
        }

        public Shape(int compType, java.awt.Shape shape, Rectangle rect, Color borderColor, Color fillColor, HashMap sfxMap, AffineTransform transform) {
            super(compType, transform);
            this.m_shape = shape;
            this.m_borderColor = borderColor;
            this.m_fillColor = fillColor;
            this.m_sfxMap = sfxMap;
            this.m_outer = rect;
        }

        public boolean contains(double x, double y, boolean useTruncated) {
            if (this.m_transform != null) {
                return this.m_transform.createTransformedShape(this.m_shape).contains(x, y);
            }
            return this.m_shape.contains(x, y);
        }

        public java.awt.Shape getShape() {
            return this.m_shape;
        }

        public Color getBorderColor() {
            return this.m_borderColor;
        }

        public Color getFillColor() {
            return this.m_fillColor;
        }

        public HashMap getSFX() {
            return this.m_sfxMap;
        }

        public Rectangle getOuterRect() {
            return this.m_outer;
        }
    }

    public static class Label
    extends DrawableObject {
        private Graphics2D m_graphics;
        private String m_text;
        private Font m_font;
        private Color m_fontColor;
        private double m_angle;
        private Rectangle m_bounds;
        private String m_labelType;
        private String m_truncatedText;
        private Rectangle m_truncatedBounds;

        public Label(int compType, Graphics2D g, String text, Font font, Color fontColor, Rectangle bounds, String labelType, AffineTransform transform) {
            super(compType, transform);
            this.$init$();
            this.m_graphics = g;
            this.m_text = text;
            this.m_font = font;
            this.m_fontColor = fontColor;
            this.m_bounds = bounds;
            this.m_labelType = labelType;
            this.m_angle = 0.0;
        }

        public Label(int compType, Graphics2D g, String text, Font font, Color fontColor, Rectangle bounds, String labelType, AffineTransform transform, double angle) {
            super(compType, transform);
            this.$init$();
            this.m_graphics = g;
            this.m_text = text;
            this.m_font = font;
            this.m_fontColor = fontColor;
            this.m_bounds = bounds;
            this.m_labelType = labelType;
            this.m_angle = angle;
        }

        public boolean contains(double x, double y, boolean useTruncated) {
            Rectangle testShape;
            Rectangle rectangle = testShape = useTruncated && this.m_truncatedBounds != null ? this.m_truncatedBounds : this.m_bounds;
            if (this.m_transform != null) {
                return this.m_transform.createTransformedShape(testShape).contains(x, y);
            }
            return testShape.contains(x, y);
        }

        public Graphics2D getGraphics() {
            return this.m_graphics;
        }

        public String getText() {
            return this.m_text;
        }

        public Font getFont() {
            return this.m_font;
        }

        public Color getFontColor() {
            return this.m_fontColor;
        }

        public double getAngle() {
            return this.m_angle;
        }

        public Rectangle getBounds() {
            return this.m_bounds;
        }

        public String getLabelType() {
            return this.m_labelType;
        }

        public String getTruncatedText() {
            return this.m_truncatedText;
        }

        public void setTruncatedText(String text) {
            this.m_truncatedText = text;
        }

        public Rectangle getTruncatedBounds() {
            return this.m_truncatedBounds;
        }

        public void setTruncatedBounds(Rectangle bounds) {
            this.m_truncatedBounds = bounds;
        }

        private void $init$() {
            this.m_truncatedText = null;
            this.m_truncatedBounds = null;
        }
    }

    public static class TickLabel
    extends Label {
        private int m_tickType;

        public TickLabel(int compType, Graphics2D g, String text, Font font, Color fontColor, Rectangle bounds, String labelType, AffineTransform transform, int tickType) {
            super(compType, g, text, font, fontColor, bounds, labelType, transform);
            this.m_tickType = tickType;
        }

        public int getTickType() {
            return this.m_tickType;
        }
    }

    public static class Image
    extends DrawableObject {
        private java.awt.Image m_image;
        private String m_url;
        private Rectangle2D m_bounds;
        private double m_scaleRatio;
        private ImageObserver m_imgObs;

        public Image(int compType, String url, java.awt.Image img, Rectangle2D rect, double scaleRatio, ImageObserver imgObs, AffineTransform transform) {
            super(compType, transform);
            this.m_url = url;
            this.m_image = img;
            this.m_bounds = rect;
            this.m_scaleRatio = scaleRatio;
            this.m_imgObs = imgObs;
        }

        public boolean contains(double x, double y, boolean useTruncated) {
            if (this.m_scaleRatio != 1.0) {
                java.awt.Image scaledImg = this.m_image.getScaledInstance((int)(this.m_bounds.getWidth() * this.m_scaleRatio), (int)(this.m_bounds.getWidth() * this.m_scaleRatio), 4);
                return scaledImg.getGraphics().getClipBounds().contains(x, y);
            }
            return this.m_bounds.contains(x, y);
        }

        public String getURL() {
            return this.m_url;
        }

        public java.awt.Image getImage() {
            return this.m_image;
        }

        public Rectangle2D getBounds() {
            return this.m_bounds;
        }

        public double getScaleRatio() {
            return this.m_scaleRatio;
        }

        public ImageObserver getImageObserver() {
            return this.m_imgObs;
        }
    }

    public static class Transform
    extends DrawableObject {
        private AffineTransform m_transform;
        private boolean m_reset;

        public Transform(AffineTransform transform, boolean reset) {
            super(22, null);
            this.m_transform = transform;
            this.m_reset = reset;
        }

        public boolean contains(double x, double y, boolean useTruncated) {
            return false;
        }

        public AffineTransform getTransform() {
            return this.m_transform;
        }

        public boolean isResetTransform() {
            return this.m_reset;
        }
    }
}

