/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.gauge.BaseGaugeComponent;
import oracle.dss.gauge.BottomLabel;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.DataSpecification;
import oracle.dss.gauge.GaugeBackground;
import oracle.dss.gauge.GaugeConstants;
import oracle.dss.gauge.GaugeController;
import oracle.dss.gauge.GaugeControllerAdapter;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeFrame;
import oracle.dss.gauge.GaugeModel;
import oracle.dss.gauge.GaugeModelAdapter;
import oracle.dss.gauge.GaugePanel;
import oracle.dss.gauge.GaugeSetBackground;
import oracle.dss.gauge.Indicator;
import oracle.dss.gauge.LEDStyleCallback;
import oracle.dss.gauge.LegendArea;
import oracle.dss.gauge.LegendText;
import oracle.dss.gauge.LegendTitle;
import oracle.dss.gauge.LowerLabelFrame;
import oracle.dss.gauge.MetricLabel;
import oracle.dss.gauge.PlotArea;
import oracle.dss.gauge.ThickGauge;
import oracle.dss.gauge.Threshold;
import oracle.dss.gauge.TickLabel;
import oracle.dss.gauge.TickMark;
import oracle.dss.gauge.TopLabel;
import oracle.dss.gauge.UpperLabelFrame;
import oracle.dss.graph.ImagemapComponent;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGInvalidParameterException;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataSource;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;

public class Gauge
extends Dataview
implements GaugeConstants,
PropertyChangeListener,
ThickGauge {
    protected GaugeModel _gaugeModel;
    protected GaugeController _gaugeController;
    protected GaugePanel _gaugePanel;
    private CommonGauge _commonGauge;
    protected Image _offscreenImage;
    protected boolean _printOrPreviewMode;
    protected boolean _stopRepaints;
    private boolean m_bExporting;

    public Gauge() {
        this.$init$();
        this._setupGaugeView(null);
    }

    public Gauge(DataSource dataSource) {
        this.$init$();
        this._setupGaugeView(dataSource);
    }

    public Gauge(ErrorHandler errorHandler) {
        this.$init$();
        this.addErrorHandler(errorHandler);
        this._setupGaugeView(null);
    }

    public CommonGauge getCommonGauge() {
        return this._commonGauge;
    }

    private void _setupGaugeView(DataSource dataSource) {
        this._commonGauge = new CommonGauge(this.getLocale(), this);
        this._commonGauge.addPropertyChangeListener(this);
        this.setCommonDataview(this._commonGauge);
        this.setUserOverrideMode(false);
        this.setStyleOverrideMode(false);
        this._gaugeModel = dataSource == null ? new GaugeModelAdapter(this) : new GaugeModelAdapter(this, dataSource);
        this._createPagingControl();
        this._gaugeController = new GaugeControllerAdapter(this, this._gaugeModel);
        if (this.isJavaComponent()) {
            this._gaugePanel = new GaugePanel(this._commonGauge);
            this._gaugePanel.addKeyListener((GaugeControllerAdapter)this._gaugeController);
            this._gaugePanel.addMouseListener((GaugeControllerAdapter)this._gaugeController);
            this._gaugePanel.addMouseMotionListener((GaugeControllerAdapter)this._gaugeController);
            this.add((Component)this._gaugePanel, "Center");
        }
        super.setModel(this._gaugeModel);
        super.setController(this._gaugeController);
        this.setDataSource(this.getGaugeModel().getDataSource());
        this.getPagingControl().setDataSource(this.getGaugeModel().getDataSource());
        this.pagingControl.setVisible(false);
        this.addSubcomponent(this._gaugePanel);
        this.addSubcomponent(this.pagingControl);
        this.positionPagingControl(GaugeDefaultValues.getPagingControlPosition());
        this._commonGauge.createPropertyOverrideFlags();
        this.setUserOverrideMode(true);
        this.setStyleOverrideMode(true);
    }

    protected void _initGauge(DataSource ds, ErrorHandler eh) {
        if (ds != null) {
            this.setDataSource(ds);
        }
        if (eh != null) {
            this.addErrorHandler(eh);
        } else {
            this.removeErrorHandler();
        }
    }

    protected void _createPagingControl() {
        this.pagingControl = new ViewPagingControl(this);
    }

    public Dimension getSize() {
        return this._gaugePanel.getSize();
    }

    public void paint(Graphics g) {
        if (this._stopRepaints) {
            return;
        }
        if (!this._printOrPreviewMode) {
            super.paint(g);
        } else if (this._offscreenImage != null) {
            g.drawImage(this._offscreenImage, 0, 0, null);
        }
    }

    public void setPrintOrPreviewMode(boolean bool) {
        Graphics offg = null;
        if (bool) {
            Dimension size = this.getSize();
            if (this._offscreenImage == null) {
                this._offscreenImage = this.createImage(size.width, size.height);
            }
            if (this._offscreenImage != null) {
                offg = this._offscreenImage.getGraphics();
                offg.setClip(0, 0, size.width, size.height);
                this.paint(offg);
            }
            this._printOrPreviewMode = bool;
        } else {
            this._printOrPreviewMode = bool;
            if (offg != null) {
                offg.dispose();
            }
            this._offscreenImage = null;
        }
    }

    public void exportToPNG(OutputStream os) {
        this._commonGauge.exportToPNG(os);
    }

    public void exportToPNGWithException(OutputStream os) throws PNGInvalidParameterException, PNGException {
        this._commonGauge.exportToPNGWithException(os);
    }

    public void exportToSVG(OutputStream os, int mode, String charEnc) {
        this._commonGauge.exportToSVG(os, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToFlash(OutputStream os, boolean renderDynamic, boolean showDrawing) {
        this._commonGauge.exportToFlash(os, renderDynamic, showDrawing);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVGWithException(OutputStream os, int mode, String charEnc) throws IOException, Exception {
        this._commonGauge.exportToSVGWithException(os, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVG(Writer writer, int mode, String charEnc) {
        this._commonGauge.exportToSVG(writer, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVGWithException(Writer writer, int mode, String charEnc) throws IOException, Exception {
        this._commonGauge.exportToSVGWithException(writer, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public DataSpecification getDataSpecification() {
        return this._commonGauge.getDataSpecification();
    }

    public void setDataSpecification(DataSpecification dataSpec) {
        this._commonGauge.setDataSpecification(dataSpec);
    }

    public GaugeController getGaugeController() {
        return this._gaugeController;
    }

    public void setGaugeController(GaugeController gaugeController) {
        super.setController(gaugeController);
        GaugeController oldController = this._gaugeController;
        if (oldController != null) {
            oldController.cleanUp();
        }
        this._gaugeController = gaugeController;
        this.firePropertyChange(this, "GaugeController", oldController, this._gaugeController);
    }

    public GaugeModel getGaugeModel() {
        return this._gaugeModel;
    }

    public void setGaugeModel(GaugeModel gaugeModel) {
        super.setModel(gaugeModel);
        GaugeModel oldModel = this._gaugeModel;
        this._gaugeModel = gaugeModel;
        this.firePropertyChange(this, "GaugeModel", oldModel, this._gaugeModel);
    }

    public Enumeration getImagemapEnumeration(int filter) {
        return this._commonGauge.getImagemapEnumeration(filter);
    }

    public Dimension getImageSize() {
        return this._commonGauge.getImageSize();
    }

    public void setImageSize(Dimension d) {
        this._commonGauge.setImageSize(d);
    }

    public Locale getLocale() {
        try {
            Locale locale = super.getLocale();
            return locale;
        }
        catch (Exception e) {
            Locale locale = Locale.getDefault();
            return locale;
        }
    }

    public Dimension getOptimalGaugeSize(Dimension maxSize) {
        return this._commonGauge.getOptimalGaugeSize(maxSize);
    }

    public ObjectNode getPagingControlXML(boolean allProperties) {
        return this.getPagingControl().getObjectNode(allProperties);
    }

    public void setPagingControlXML(ObjectNode pagingControl, String version, int reset) {
        this.getPagingControl().setObjectNode(pagingControl, version, reset);
    }

    public int getPresentationHeight() {
        return this._gaugePanel.getBounds().height;
    }

    public int getPresentationWidth() {
        return this._gaugePanel.getBounds().width;
    }

    public boolean selectObject(ComponentHandle id) {
        if (id == null) {
            this.getGaugeController().setSelectedObject(null);
            return true;
        }
        if (id instanceof PageItemComponentHandle) {
            this.getGaugeController().setSelectedObject(new PageItemComponentHandle(id.getID(), this.getNameFromID(id.getID()), this.getPagingControl(), ((PageItemComponentHandle)id).getPageItem()));
            return true;
        }
        if (id.getComponent() instanceof BaseTitle) {
            this.getGaugeController().setSelectedObject(id);
            return true;
        }
        this.getGaugeController().setSelectedObject(null);
        int row = -1;
        int column = -1;
        if (id instanceof DataComponentHandle) {
            row = ((DataComponentHandle)id).getRow();
            column = ((DataComponentHandle)id).getColumn();
        }
        ((BaseGaugeComponent)id.getComponent()).selectObject(row, column);
        return this.getSelectedObject() != null && id.getID() == this.getSelectedObject().getID();
    }

    public boolean selectObjectFromEvent(MouseEvent e) {
        boolean retval = this._commonGauge.selectObject(e);
        this.repaint();
        return retval;
    }

    public ComponentHandle getSelectedObject() {
        ComponentHandle comp = this.getGaugeController().getSelectedObject();
        if (comp != null) {
            return comp;
        }
        comp = this._commonGauge.getSelectedObject();
        return comp;
    }

    public String getVersion() {
        return "11.0.0.0.1";
    }

    public int getViewType() {
        return 3;
    }

    public boolean isPrintOrPreviewMode() {
        return this._printOrPreviewMode;
    }

    public boolean isSwapAllowed() {
        return this.getPagingControl().isSwapAllowed();
    }

    public void setSwapAllowed(boolean swap) {
        boolean oldSwapAllowed = this.getPagingControl().isSwapAllowed();
        this.getPagingControl().setSwapAllowed(swap);
        this.firePropertyChange(this, "SwapAllowed", oldSwapAllowed, swap);
    }

    public boolean readXML(InputStream stream, boolean reset) throws BIIOException, BISAXException, BIParseException {
        int resetFlag = 0;
        if (reset) {
            resetFlag = 2;
        }
        return this.readXML(stream, resetFlag);
    }

    public boolean readXML(InputStream stream, int reset) throws BIIOException, BISAXException, BIParseException {
        return this._commonGauge.readXML(stream, reset);
    }

    public boolean renderGauges(Graphics2D g) {
        return this._commonGauge.renderGauges(g);
    }

    public void resetEverything(int reset) {
        if (reset == 5) {
            this._gaugeModel.setDrillingEnabled(false);
        } else {
            this._gaugeModel = new GaugeModelAdapter(this);
        }
        this._gaugeController.cleanUp();
        this._gaugeController = new GaugeControllerAdapter(this, this._gaugeModel);
        this.setModel(this._gaugeModel);
        this.setController(this._gaugeController);
        if (reset != 5) {
            this.setDataSource(null);
        }
    }

    public void resetSuper(int reset, String version) {
        super.resetToDefault(reset, version);
    }

    public void resetToDefault(int reset) {
        super.resetToDefault(reset);
        this._commonGauge.resetToDefault(reset, this.getVersion());
    }

    public void resetXMLProps() {
        this.getGaugeController().setSelectedObject(null);
    }

    public void setContext() {
        this._commonGauge.setContext();
    }

    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
        this._commonGauge.setDataAccess(this.getModel().getDataAccess());
        this._commonGauge.setDataDirector(this.getModel().getDataDirector());
        this._commonGauge.setDataSpecification(new DataSpecification());
    }

    public void setDataSource(DataSource ds, DataSpecification specs) {
        super.setDataSource(ds);
        this._commonGauge.setDataAccess(this.getModel().getDataAccess());
        this._commonGauge.setDataDirector(this.getModel().getDataDirector());
        this._commonGauge.setDataSpecification(specs);
    }

    public boolean setGridData(Object[] specs, Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        return this._commonGauge.setGridData(specs, columnLabels, rowLabels, data);
    }

    public int getStartColumn() {
        this.getErrorHandler().log("unsupported method 'getStartColumn'", this.getClass().getName(), "public int getStartColumn()");
        return -1;
    }

    public void setStartColumn(int c) {
        this.getErrorHandler().log("unsupported method 'setStartColumn(c)'", this.getClass().getName(), "public void setStartColumn(c)");
    }

    public int getStartRow() {
        this.getErrorHandler().log("unsupported method 'getStartRow'", this.getClass().getName(), "public int getStartRow()");
        return -1;
    }

    public void setStartRow(int r) {
        this.getErrorHandler().log("unsupported method 'setStartRow(r)'", this.getClass().getName(), "public void setStartRow(r)");
    }

    public boolean setTabularData(Object[] specs, List tableRows) {
        return this._commonGauge.setTabularData(specs, tableRows);
    }

    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        return this._commonGauge.setXML(xmlString, reset);
    }

    public void writeImagemapXML(OutputStream os, int filter) {
        PrintWriter out = new PrintWriter(os);
        this.writeImagemapXML(out, filter);
    }

    public void writeImagemapXML(PrintWriter out, int filter) {
        Enumeration compEnum = this.getImagemapEnumeration(filter);
        out.println("<?xml version='1.0'?>");
        out.println("<!-- This document contains information for image map generation-->");
        out.println("<GaugeMap>");
        while (compEnum.hasMoreElements()) {
            ImagemapComponent comp = (ImagemapComponent)compEnum.nextElement();
            ComponentHandle handle = comp.getComponentHandle();
            Polygon poly = comp.getPlacement();
            out.print("<");
            out.print(handle.getName());
            out.println(">");
            String[] tooltips = comp.getTooltips();
            if (tooltips != null && tooltips.length > 0) {
                out.println("<Tooltip>");
                int n = 0;
                while (n < tooltips.length) {
                    if (tooltips[n].length() > 0) {
                        out.print("<Line>");
                        out.print(tooltips[n]);
                        out.println("</Line>");
                    }
                    ++n;
                }
                out.println("</Tooltip>");
            }
            int iMax = poly.npoints;
            out.println("<Geometry>");
            int i = 0;
            while (i < iMax) {
                out.print("<Vertex x=\"");
                out.print(poly.xpoints[i]);
                out.print("\" y=\"");
                out.print(poly.ypoints[i]);
                out.println("\" />");
                ++i;
            }
            out.println("</Geometry>");
            out.print("</");
            out.print(handle.getName());
            out.println(">");
        }
        out.println("</GaugeMap>");
        out.flush();
    }

    public void updatePageItems() {
        this.getPagingControl().updatePageItems();
    }

    public GaugeSetBackground getGaugeSetBackground() {
        return this._commonGauge.getGaugeSetBackground();
    }

    public GaugeBackground getGaugeBackground() {
        return this._commonGauge.getGaugeBackground();
    }

    public GaugeFrame getGaugeFrame() {
        return this._commonGauge.getGaugeFrame();
    }

    public PlotArea getPlotArea() {
        return this._commonGauge.getPlotArea();
    }

    public TickLabel getTickLabel() {
        return this._commonGauge.getTickLabel();
    }

    public TickMark getTickMark() {
        return this._commonGauge.getTickMark();
    }

    public Indicator getIndicator() {
        return this._commonGauge.getIndicator();
    }

    public Threshold getThreshold() {
        return this._commonGauge.getThreshold();
    }

    public TopLabel getTopLabel() {
        return this._commonGauge.getTopLabel();
    }

    public BottomLabel getBottomLabel() {
        return this._commonGauge.getBottomLabel();
    }

    public MetricLabel getMetricLabel() {
        return this._commonGauge.getMetricLabel();
    }

    public UpperLabelFrame getUpperLabelFrame() {
        return this._commonGauge.getUpperLabelFrame();
    }

    public LowerLabelFrame getLowerLabelFrame() {
        return this._commonGauge.getLowerLabelFrame();
    }

    public LegendArea getLegendArea() {
        return this._commonGauge.getLegendArea();
    }

    public LegendText getLegendText() {
        return this._commonGauge.getLegendText();
    }

    public LegendTitle getLegendTitle() {
        return this._commonGauge.getLegendTitle();
    }

    public int getGaugeSetAlignment() {
        return this._commonGauge.getGaugeSetAlignment();
    }

    public void setGaugeSetAlignment(int alignment) {
        this._commonGauge.setGaugeSetAlignment(alignment);
    }

    public int getGaugeSetColumnCount() {
        return this._commonGauge.getGaugeSetColumnCount();
    }

    public void setGaugeSetColumnCount(int columns) {
        this._commonGauge.setGaugeSetColumnCount(columns);
    }

    public int getGaugeSetDirection() {
        return this._commonGauge.getGaugeSetDirection();
    }

    public void setGaugeSetDirection(int direction) {
        this._commonGauge.setGaugeSetDirection(direction);
    }

    public int getGaugeType() {
        return this._commonGauge.getGaugeType();
    }

    public void setGaugeType(int type) {
        this._commonGauge.setGaugeType(type);
    }

    public int getLEDStyle() {
        return this._commonGauge.getLEDStyle();
    }

    public void setLEDStyle(int style) {
        this._commonGauge.setLEDStyle(style);
    }

    public int getThresholdDialStyle() {
        return this._commonGauge.getThresholdDialStyle();
    }

    public void setThresholdDialStyle(int style) {
        this._commonGauge.setThresholdDialStyle(style);
    }

    public LEDStyleCallback getLEDStyleCallback() {
        return this._commonGauge.getLEDStyleCallback();
    }

    public void setLEDStyleCallback(LEDStyleCallback callback) {
        this._commonGauge.setLEDStyleCallback(callback);
    }

    public void setBackgroundTransparent(boolean transparent) {
        this.setOpaque(transparent ^ true);
        this._gaugePanel.setOpaque(transparent ^ true);
    }

    public static int convertGaugeTypeToInt(String type) {
        return CommonGauge.convertGaugeTypeToInt(type);
    }

    public static String convertGaugeTypeToString(int type) {
        return CommonGauge.convertGaugeTypeToString(type);
    }

    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        this.boundSupport.firePropertyChange(propName, oldValue, newValue);
    }

    protected void refreshData() {
        if (this.getGaugeController() != null) {
            this.getGaugeController().setSelectedObject(null);
        }
        this.invalidate();
        this.repaint();
    }

    protected void setLayerMetaLongLabelSupported(boolean supported) {
        super.setLayerMetaLongLabelSupported(supported);
    }

    protected void setMetadataDrillSupported(boolean supported) {
        this._commonGauge.setMetadataDrillSupported(supported);
    }

    protected boolean isMetadataDrillSupported() {
        return this._commonGauge.isMetadataDrillSupported();
    }

    protected void setDataUnformattedSupported(boolean supported) {
        super.setDataUnformattedSupported(supported);
    }

    protected void setMetadataLongLabelSupported(boolean supported) {
        super.setMetadataLongLabelSupported(supported);
    }

    protected void setMetadataMediumLabelSupported(boolean supported) {
        super.setMetadataMediumLabelSupported(supported);
    }

    protected void setMetadataShortLabelSupported(boolean supported) {
        super.setMetadataShortLabelSupported(supported);
    }

    protected void setMetadataValueSupported(boolean supported) {
        super.setMetadataValueSupported(supported);
    }

    protected void setMetadataDrillParentDateSupported(boolean supported) {
        this._commonGauge.setMetadataDrillParentDateSupported(supported);
    }

    protected boolean isMetadataDrillParentDateSupported() {
        return this._commonGauge.isMetadataDrillParentDateSupported();
    }

    protected void setMetadataDrillParentDateSpanSupported(boolean supported) {
        this._commonGauge.setMetadataDrillParentDateSpanSupported(supported);
    }

    protected boolean isMetadataDrillParentDateSpanSupported() {
        return this._commonGauge.isMetadataDrillParentDateSpanSupported();
    }

    protected void setMetadataDateSupported(boolean supported) {
        this._commonGauge.setMetadataDateSupported(supported);
    }

    protected void setMetadataDateSpanSupported(boolean supported) {
        this._commonGauge.setMetadataDateSpanSupported(supported);
    }

    protected boolean isMetadataDateSpanSupported() {
        return this._commonGauge.isMetadataDateSpanSupported();
    }

    protected void setLayerMetaMediumLabelSupported(boolean supported) {
        super.setLayerMetaMediumLabelSupported(supported);
    }

    protected void setLayerMetaShortLabelSupported(boolean supported) {
        super.setLayerMetaShortLabelSupported(supported);
    }

    protected void setLayerMetaNameSupported(boolean supported) {
        super.setLayerMetaNameSupported(supported);
    }

    protected void metadataLabelTypeChanged() {
        super.metadataLabelTypeChanged();
        this._commonGauge.refreshData();
        this.repaint();
    }

    public DataviewXML getViewXML() {
        return this._commonGauge.getViewXML();
    }

    protected ObjectNode getObjectNode(boolean allProperties) {
        return this._commonGauge.getObjectNode(allProperties);
    }

    protected void processAlertEvent(int eventID) {
        this._commonGauge.processAlertEvent(eventID);
    }

    public void modelDataChanged(DataChangedEvent e) {
        super.modelDataChanged(e);
        this._commonGauge.setDataAccess(this.getModel().getDataAccess());
    }

    public void modelDataAvailable(DataAvailableEvent e) {
        if (e.getType() == 1) {
            this._stopRepaints = true;
            return;
        }
        this._stopRepaints = false;
        super.modelDataAvailable(e);
        this._commonGauge.setDataAccess(this.getModel().getDataAccess());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        return this._commonGauge.setXMLAsString(xml);
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            super.setPersistableComponents(persistables);
        }
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        return this._commonGauge.getPersistableAttributes(oldAttrs);
    }

    public boolean startExport() {
        this.m_bExporting = true;
        this.setPrintOrPreviewMode(true);
        return true;
    }

    public void endExport() {
        this.setPrintOrPreviewMode(false);
        this.m_bExporting = false;
    }

    public boolean isExporting() {
        return this.m_bExporting;
    }

    private void $init$() {
        this._offscreenImage = null;
        this._printOrPreviewMode = false;
        this._stopRepaints = false;
        this.m_bExporting = false;
    }
}

