/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DVTResources;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.DialGauge;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeExportXMLWriter;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.gauge.GaugeSVGWriter;
import oracle.dss.gauge.GaugeType;
import oracle.dss.gauge.Graphics2DRenderer;
import oracle.dss.gauge.LEDGauge;
import oracle.dss.gauge.LabelGauge;
import oracle.dss.gauge.StatusMeterGauge;
import oracle.dss.gauge.VennGauge;
import oracle.dss.gauge.VerticalStatusMeterGauge;
import oracle.dss.graph.ImagemapComponent;
import oracle.dss.graph.flash.GaugeFlashRenderer;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeEngine {
    protected static final int DEFAULT_OBJECTLIST_SIZE = 15;
    public static int BORDER_ONLY = 1;
    public static int FILL_ONLY = 2;
    public static int FILL_AND_BORDER = 3;
    private GaugeType _gaugeType;
    private ArrayList _objList;
    private String _id;
    private Map _map;
    private Graphics2D _graphics;
    private ErrorHandler _eh;
    private ResourceBundle _resBundle;
    private CustomShapesParser _csParser;
    protected Shape _gaugeSetClip;
    private double _min;
    private double _max;
    private boolean _isNullMetric;
    private double _metric;
    private double _incr;
    private int _numberOfSteps;
    private int _maxNumberOfSteps;
    private Rectangle _outerBounds;
    private Rectangle _innerBounds;
    private Dimension _requiredSize;
    private DVTResources m_dvtResources;
    private int _maxNumSteps;
    protected static double ASCENT_TEXT_HEIGHT = 0.7;
    private int _recalcState;
    private static final int RECALC_STATE_READY = 0;
    private static final int RECALC_STATE_ALL = 1;
    private static final String _method_prepareObjects = "prepareObjects";
    private static final String _method_render = "render";
    private ViewFormat m_defTickLabelViewFormat;
    private ViewFormat m_defMetricLabelViewFormat;

    public GaugeEngine(Map propMap) {
        this(propMap, 0);
    }

    public GaugeEngine(Map propMap, int gaugeType) {
        this.$init$();
        this._map = propMap;
        this._gaugeType = gaugeType == 1 ? new StatusMeterGauge(this) : (gaugeType == 2 ? new LEDGauge(this) : (gaugeType == 3 ? new VennGauge(this) : (gaugeType == 4 ? new VerticalStatusMeterGauge(this) : (gaugeType == 5 ? new LabelGauge(this) : new DialGauge(this)))));
        this._validateMinMax();
        Locale locale = (Locale)this._map.get("Locale");
        if (this.m_defTickLabelViewFormat == null) {
            this.m_defTickLabelViewFormat = new ViewFormat();
            if (locale != null) {
                this.m_defTickLabelViewFormat.setLocale(locale);
            }
        }
        if (this.m_defMetricLabelViewFormat == null) {
            this.m_defMetricLabelViewFormat = new ViewFormat();
            if (locale != null) {
                this.m_defMetricLabelViewFormat.setLocale(locale);
            }
        }
        try {
            this._resBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.gauge.resource.GaugeBundle", locale) : ResourceBundle.getBundle("oracle.dss.gauge.resource.GaugeBundle");
        }
        catch (MissingResourceException e) {
            this._resBundle = null;
        }
        if (this._map.get("ThresholdValues") != null && this._map.get("IndicatorType") != null && (Integer)this._map.get("IndicatorType") == 1) {
            this._map.put("IndicatorType", GaugeDefaultValues.getIndicatorType());
        }
    }

    public ErrorHandler getErrorHandler() {
        return this._eh;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this._eh = eh;
    }

    protected String getId() {
        return this._id;
    }

    protected void setId(String id) {
        this._id = id;
    }

    public String getIntlString(String key) {
        if (this.m_dvtResources != null) {
            return this.m_dvtResources.getResourceString(key);
        }
        return this._resBundle.getString(key);
    }

    public String getErrorIntlString(String key) {
        return this._resBundle.getString(key);
    }

    public void setDVTResources(DVTResources res) {
        this.m_dvtResources = res;
    }

    public Object getAttribute(String name) {
        if (this._map == null) {
            return null;
        }
        return this._map.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (this._map == null) {
            this._map = this._createHashMap();
        }
        this._map.put(name, value);
        this._setRecalcState(1);
    }

    public Dimension calcGaugeSize(Graphics2D g, Dimension maxSize) {
        Rectangle rect = new Rectangle(0, 0, maxSize.width, maxSize.height);
        this.autoLayout(g, rect);
        this._updateSteps();
        ViewFormat viewFmt = (ViewFormat)((Object)this._map.get("TickLabelViewFormat"));
        if (viewFmt == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(false);
        }
        if ((viewFmt = (ViewFormat)((Object)this._map.get("MetricLabelViewFormat"))) == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(true);
        }
        this._maxNumSteps = this.getMaxNumberOfSteps();
        this._requiredSize = this.autoLayout(g, rect);
        return this._requiredSize;
    }

    public String getToolTipText(Point pt) {
        String[] tooltips = null;
        if (this._objList != null && !this._objList.isEmpty()) {
            int objIndex = this._objList.size() - 1;
            while (objIndex >= 0) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj != null) {
                    int compType = obj.getComponentType();
                    if (!(this._gaugeType instanceof DialGauge && compType == 11 && obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Arc2D && ((DrawableObject.Shape)obj).getFillColor() == null || obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Rectangle && ((DrawableObject.Shape)obj).getFillColor() == null || !obj.contains(pt.x, pt.y, false))) {
                        switch (compType) {
                            case 13: {
                                tooltips = new String[]{"TickMark"};
                                break;
                            }
                            case 12: 
                            case 16: 
                            case 17: 
                            case 18: {
                                if (obj instanceof DrawableObject.Label) {
                                    String lblText = ((DrawableObject.Label)obj).getTruncatedText();
                                    if (lblText != null) {
                                        tooltips = new String[]{((DrawableObject.Label)obj).getText()};
                                        break;
                                    }
                                    tooltips = null;
                                    break;
                                }
                                tooltips = null;
                                break;
                            }
                            case 14: 
                            case 15: 
                            case 19: 
                            case 20: 
                            case 21: {
                                tooltips = this._getToolTipText(1);
                                break;
                            }
                        }
                        break;
                    }
                }
                --objIndex;
            }
        }
        if (tooltips != null) {
            StringBuilder tooltip = new StringBuilder();
            int i = 0;
            while (i < tooltips.length) {
                tooltip.append((String)tooltips[i]);
                if (i < tooltips.length - 1) {
                    tooltip.append(System.getProperty("line.separator"));
                }
                ++i;
            }
            return tooltip.toString();
        }
        return null;
    }

    public boolean render(Graphics2D g) {
        boolean retCode = true;
        this.prepareObjects(g);
        Graphics2DRenderer renderer = new Graphics2DRenderer(g, this.getErrorHandler());
        retCode = this._renderObjList(renderer);
        return retCode;
    }

    public boolean render(Graphics2D g, GaugeSVGWriter writer, int mode) {
        boolean retCode = true;
        this.setGraphics(g);
        writer.setSvgMode(mode);
        retCode = this._renderObjList(writer);
        return retCode;
    }

    public boolean render(Graphics2D g, GaugeExportXMLWriter writer, int mode) {
        boolean retCode = true;
        this.setGraphics(g);
        writer.init(this);
        retCode = this._renderObjList(writer);
        return retCode;
    }

    public boolean render(Graphics2D g, GaugeFlashRenderer writer) {
        boolean retCode = true;
        this.setGraphics(g);
        retCode = this._renderObjList(writer);
        return retCode;
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    private void setGraphics(Graphics2D g) {
        if (this._graphics == null && g == null || this._graphics == g) {
            return;
        }
        if (g == null) {
            this._graphics.dispose();
            this._graphics = null;
            return;
        }
        this._graphics = g;
        Rectangle clipBounds = this._graphics.getClipBounds();
        if (this._outerBounds == null || this._outerBounds.width != clipBounds.width || this._outerBounds.height != clipBounds.height) {
            this._setRecalcState(1);
        }
    }

    protected Rectangle getOuterBounds() {
        return this._outerBounds;
    }

    protected void setBackgroundClip(Shape clipShape) {
        this._gaugeSetClip = clipShape;
    }

    public int selectObject(Point pt) {
        int retType = -1;
        if (this._objList != null && !this._objList.isEmpty()) {
            int foundType = -1;
            boolean found = false;
            int objIndex = this._objList.size() - 1;
            while (objIndex >= 0) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj != null) {
                    if (found) {
                        obj.setSelected(foundType == obj.getComponentType());
                    } else if (!(this._gaugeType instanceof DialGauge && obj.getComponentType() == 11 && obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Arc2D && ((DrawableObject.Shape)obj).getFillColor() == null || obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Rectangle && ((DrawableObject.Shape)obj).getFillColor() == null || !(found = obj.contains(pt.x, pt.y, false)))) {
                        obj.setSelected(true);
                        foundType = obj.getComponentType();
                        objIndex = this._objList.size() - 1;
                    }
                }
                --objIndex;
            }
            if (found) {
                retType = foundType;
            }
        }
        return retType;
    }

    public boolean setSelectedObject(int type) {
        if (this._objList != null && !this._objList.isEmpty()) {
            int objIndex = 0;
            while (objIndex < this._objList.size()) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj == null) {
                    int column;
                    int row;
                    if (this._map == null) {
                        row = -1;
                        column = -1;
                    } else {
                        Object rowObj = this._map.get("DS_ROW");
                        row = rowObj != null ? Integer.parseInt((String)rowObj) : -1;
                        Object colObj = this._map.get("DS_COLUMN");
                        column = colObj != null ? Integer.parseInt((String)colObj) : -1;
                    }
                    this._eh.log("Attempt made to process null DrawableObject on gauge " + row + "," + column, this.getClass().getName(), _method_render);
                }
                obj.setSelected(type == obj.getComponentType());
                ++objIndex;
            }
            return true;
        }
        return false;
    }

    public static Rectangle trimRectToText(Graphics2D g, Font font, int x, int y, int width, int height) {
        FontMetrics fm = font != null ? g.getFontMetrics(font) : g.getFontMetrics();
        int baseline = y + (fm.getHeight() - fm.getDescent());
        int newHeight = (int)((double)fm.getAscent() * ASCENT_TEXT_HEIGHT);
        return new Rectangle(x, baseline - newHeight, width - 1, newHeight);
    }

    public Enumeration getImagemapEnumeration(Graphics2D g, int filter) {
        Boolean isScreenReader;
        if (this._getRecalcState() != 0) {
            this.prepareObjects(g);
        }
        Vector<ImagemapComponent> mapComps = new Vector<ImagemapComponent>(15);
        Vector<ImagemapComponent> imgComp = null;
        imgComp = this._createImagemapComponents(filter);
        if (imgComp != null) {
            mapComps.addAll(imgComp);
        }
        if ((isScreenReader = (Boolean)this._map.get(CommonGauge.ADA_SCREEN_READER_MODE)) != null && isScreenReader.booleanValue() && (imgComp = this._createGaugeImagemapComponent()) != null) {
            mapComps.addAll(imgComp);
        }
        return mapComps.elements();
    }

    protected static String getCompNameForImagemapEnumeration(int compType) {
        switch (compType) {
            case 14: {
                return "Indicator";
            }
            case 12: {
                return "TickLabel";
            }
            case 16: {
                return "TopLabel";
            }
            case 17: {
                return "BottomLabel";
            }
            case 18: {
                return "MetricLabel";
            }
            case 13: {
                return "TickMark";
            }
            case 11: {
                return "PlotArea";
            }
            case 27: {
                return "LegendArea";
            }
            case 28: {
                return "LegendText";
            }
            case 9: {
                return "Gauge";
            }
        }
        return null;
    }

    protected Dimension autoLayout(Graphics2D g, Rectangle rect) {
        if (this._outerBounds == null) {
            this._outerBounds = new Rectangle(rect);
        }
        Dimension reqSize = this._gaugeType.autoLayout(g, rect, this._map);
        this._innerBounds = this._gaugeType._innerBounds;
        return reqSize;
    }

    protected boolean prepareObjects(Graphics2D g) {
        Rectangle clip;
        ViewFormat viewFmt;
        this.setGraphics(g);
        if (this._getRecalcState() == 0) {
            return true;
        }
        if (this._objList != null) {
            this._objList.clear();
        }
        boolean metricAvailable = true;
        if (this._map.get("Metric") == null) {
            metricAvailable = false;
        }
        Double min = (Double)this._map.get("minValue");
        Double max = (Double)this._map.get("maxValue");
        if (metricAvailable) {
            double metric = (Double)this._map.get("Metric");
            if (min != null && metric < min) {
                this.getErrorHandler().log(this.getErrorIntlString("22002"), this.getClass().getName(), _method_prepareObjects);
            }
            if (max != null && metric > max) {
                this.getErrorHandler().log(this.getErrorIntlString("22001"), this.getClass().getName(), _method_prepareObjects);
            }
        }
        if ((viewFmt = (ViewFormat)((Object)this._map.get("TickLabelViewFormat"))) == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(false);
        }
        if ((viewFmt = (ViewFormat)((Object)this._map.get("MetricLabelViewFormat"))) == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(true);
        }
        if ((clip = g.getClipBounds()) == null) {
            clip = new Rectangle(0, 0, 200, 150);
        }
        this._outerBounds = clip;
        this._addToDrawableList(this._gaugeType.getBackgroundObject(this._map, this._outerBounds, this._gaugeSetClip));
        this.autoLayout(g, clip);
        this._updateSteps();
        Boolean drawRaised = (Boolean)this._map.get("GaugeFrameVisible");
        if (drawRaised == null) {
            drawRaised = GaugeDefaultValues.isGaugeFrameVisible();
        }
        if (drawRaised.booleanValue()) {
            this._addToDrawableList(this._gaugeType.getGaugeFrameObject(this._map));
        }
        if (this._map.get("IndicatorType") != null && (Integer)this._map.get("IndicatorType") == 1) {
            this._addToDrawableList(this._gaugeType.getPlotAreaObject(this._map, FILL_ONLY));
            this._addToDrawableList(this._gaugeType.getIndicatorObject(this._map));
            this._addToDrawableList(this._gaugeType.getPlotAreaObject(this._map, BORDER_ONLY));
        } else {
            this._addToDrawableList(this._gaugeType.getPlotAreaObject(this._map, FILL_AND_BORDER));
            this._addToDrawableList(this._gaugeType.getIndicatorObject(this._map));
        }
        this._addToDrawableList(this._gaugeType.getTickMarkObjects(this._map));
        this._addToDrawableList(this._gaugeType.getLabelObjects(this._map, this._outerBounds));
        this._addToDrawableList(this._gaugeType.getTickLabelObjects(this._map));
        this._addToDrawableList(this._gaugeType.getOverlayEffectObjects(this._map));
        if (this._map.get("Link") != null) {
            this._addToDrawableList(this._gaugeType.getGaugeLinkObject(this._map, this._outerBounds));
        }
        this._setRecalcState(0);
        return true;
    }

    protected void setCustomShapesParser(CustomShapesParser parser) {
        this._csParser = parser;
        this._gaugeType.setCustomShapesParser(this._csParser);
    }

    private Vector<ImagemapComponent> _createGaugeImagemapComponent() {
        Vector<ImagemapComponent> imgComp = new Vector<ImagemapComponent>();
        String[] tooltips = null;
        int compType = 9;
        String compName = GaugeEngine.getCompNameForImagemapEnumeration(9);
        int[] xpts = new int[]{this._outerBounds.x, this._outerBounds.x, this._outerBounds.x + this._outerBounds.width, this._outerBounds.x + this._outerBounds.width};
        int[] ypts = new int[]{this._outerBounds.y, this._outerBounds.y + this._outerBounds.height, this._outerBounds.y + this._outerBounds.height, this._outerBounds.y};
        Polygon poly = new Polygon(xpts, ypts, xpts.length);
        StringBuilder sb = new StringBuilder();
        sb.append("Gauge value: ");
        sb.append(this.formatValue(this.getMetric(), "MetricLabelViewFormat"));
        String text = this._getMetricThresholdText();
        if (text != null) {
            sb.append(", ");
            sb.append(text);
        }
        if ((text = (String)this._map.get("TopLabel")) != null) {
            sb.append(", top label: ");
            sb.append(text);
        }
        if ((text = (String)this._map.get("BottomLabel")) != null) {
            sb.append(", bottom label: ");
            sb.append(text);
        }
        sb.append(this._getThresholdsText());
        tooltips = new String[]{sb.toString()};
        imgComp.add(new ImagemapComponent(new NonDataComponentHandle(compType, compName, null), poly, tooltips));
        return imgComp;
    }

    private Vector<ImagemapComponent> _createImagemapComponents(int filter) {
        Vector<ImagemapComponent> imgComp = new Vector<ImagemapComponent>();
        String[] tooltips = null;
        Polygon poly = null;
        int objIndex = this._objList.size() - 1;
        while (objIndex >= 0) {
            poly = null;
            tooltips = null;
            DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
            if (obj == null) {
                int row = this._getRow();
                int column = this._getColumn();
                this._eh.log("Attempt made to process null DrawableObject on gauge " + row + "," + column, this.getClass().getName(), _method_render);
            } else {
                int compType = obj.getComponentType();
                boolean needsImagemap = false;
                if ((filter & 0x10) != 0 && compType == 12) {
                    needsImagemap = true;
                }
                if ((filter & 0x20) != 0) {
                    if (compType == 16) {
                        needsImagemap = true;
                    } else if (compType == 17) {
                        needsImagemap = true;
                    } else if (compType == 18) {
                        needsImagemap = true;
                    }
                }
                if (filter == -1 && compType == 13) {
                    needsImagemap = true;
                }
                if ((filter & 1) != 0) {
                    if (compType == 14) {
                        needsImagemap = true;
                    } else if (compType == 11) {
                        needsImagemap = true;
                    }
                }
                if (needsImagemap) {
                    boolean bScreenReader;
                    poly = GaugeEngine._processImagemapPolygon(obj);
                    String compName = GaugeEngine.getCompNameForImagemapEnumeration(compType);
                    ComponentHandle componentID = null;
                    componentID = compType == 14 || compType == 15 || compType == 16 || compType == 17 || compType == 18 || compType == 19 || compType == 20 || compType == 21 || compType == 11 ? new DataComponentHandle(compType, compName, null, this._getRow(), this._getColumn()) : new NonDataComponentHandle(compType, compName, null);
                    Boolean isScreenReader = (Boolean)this._map.get(CommonGauge.ADA_SCREEN_READER_MODE);
                    boolean bl = bScreenReader = isScreenReader != null && isScreenReader != false;
                    if ((compType == 11 || compType == 14 && this._gaugeType.getGaugeType() == 2) && !bScreenReader) {
                        tooltips = this._getToolTipText(17);
                    }
                    if (poly != null) {
                        imgComp.add(new ImagemapComponent(componentID, poly, tooltips));
                    }
                }
            }
            --objIndex;
        }
        return imgComp;
    }

    protected static Polygon _processImagemapPolygon(DrawableObject obj) {
        Polygon poly = null;
        if (obj instanceof DrawableObject.Label) {
            poly = PresUtils.rectToPoly(((DrawableObject.Label)obj).getBounds());
        } else if (obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Line2D) {
            Line2D line = (Line2D)((DrawableObject.Shape)obj).getShape();
            poly = PresUtils.lineToPoly(line);
        } else if (obj instanceof DrawableObject.Shape && (((DrawableObject.Shape)obj).getShape() instanceof Rectangle2D || ((DrawableObject.Shape)obj).getShape() instanceof RoundRectangle2D)) {
            poly = PresUtils.rectToPoly(((DrawableObject.Shape)obj).getShape().getBounds());
        } else if (obj instanceof DrawableObject.Shape) {
            Shape s = ((DrawableObject.Shape)obj).getShape();
            poly = PresUtils.shapeToPoly(s);
        }
        return poly;
    }

    private int _getRow() {
        int row = this._map == null ? -1 : (this._map.get("Metric_row") != null ? ((Integer)this._map.get("Metric_row")).intValue() : ((Integer)this._map.get("DS_ROW")).intValue());
        return row;
    }

    private int _getColumn() {
        int column = this._map == null ? -1 : (this._map.get("Metric_col") != null ? ((Integer)this._map.get("Metric_col")).intValue() : ((Integer)this._map.get("DS_COLUMN")).intValue());
        return column;
    }

    protected String[] _getToolTipText(int filter) {
        String[] tooltips;
        if (this._gaugeType.getGaugeType() == 3) {
            tooltips = this._getVennTooltips(filter);
        } else {
            String bottomLabel;
            boolean includeMetric = this.isNullMetric() ^ true;
            int count = 0;
            String topLabel = (String)this._map.get("TopLabelText");
            if (topLabel == null) {
                topLabel = (String)this._map.get("TopLabel");
            }
            StringBuilder colBuffer = null;
            if ((filter & 0x10) != 0 && topLabel != null) {
                colBuffer = new StringBuilder();
                colBuffer.append(topLabel);
                ++count;
            }
            if ((bottomLabel = (String)this._map.get("BottomLabelText")) == null) {
                bottomLabel = (String)this._map.get("BottomLabel");
            }
            StringBuilder rowBuffer = new StringBuilder();
            if ((filter & 0x10) != 0 && bottomLabel != null) {
                rowBuffer.append(bottomLabel + ":");
            } else {
                rowBuffer.append(this.getIntlString("af_dvt_gauge.LABEL_VALUE"));
            }
            if ((filter & 1) != 0 && includeMetric) {
                rowBuffer.append(" " + this.formatValue(this.getMetric(), "MetricLabelViewFormat"));
            } else {
                rowBuffer.append(ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("No data"));
            }
            ++count;
            String thresholdValues = null;
            if ((filter & 1) != 0 && includeMetric && this._map.get("ThresholdValues") != null) {
                HashMap tMap;
                ArrayList tList;
                double[] array = (double[])this._map.get("ThresholdValues");
                int index = -1;
                int i = 0;
                while (i < array.length) {
                    if (this.getMetric() <= array[i]) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index == -1) {
                    index = array.length;
                }
                if ((tList = (ArrayList)this._map.get("THRESHOLD_ATTRIBUTES")) != null && index < tList.size() && (tMap = (HashMap)tList.get(index)) != null) {
                    thresholdValues = (String)tMap.get("ThresholdText");
                }
                if (thresholdValues == null) {
                    double firstValue = 0.0;
                    firstValue = index == 0 ? this.getMin() : array[index - 1];
                    double secondValue = 0.0;
                    secondValue = index == array.length ? this.getMax() : array[index];
                    Object[] args = new String[]{this.formatValue(firstValue, "TickLabelViewFormat"), this.formatValue(secondValue, "TickLabelViewFormat")};
                    thresholdValues = MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_BETWEEN_THRESHOLD"), args);
                }
                ++count;
            }
            int lineNum = 0;
            tooltips = new String[count];
            if (colBuffer != null) {
                tooltips[lineNum++] = colBuffer.toString();
            }
            if (rowBuffer != null) {
                tooltips[lineNum++] = rowBuffer.toString();
            }
            if (thresholdValues != null) {
                tooltips[lineNum] = thresholdValues;
            }
        }
        return tooltips;
    }

    private String[] _getVennTooltips(int filter) {
        int count = 0;
        StringBuilder topBuffer = null;
        Object obj = this._map.get("ElementATopLabel");
        if (obj != null) {
            topBuffer = new StringBuilder(obj.toString());
            ++count;
        }
        StringBuilder bottomBuffer = null;
        obj = this._map.get("ElementABottomLabel");
        if (obj != null) {
            bottomBuffer = new StringBuilder(obj.toString());
            ++count;
        }
        ++count;
        obj = this._map.get("ElementAValue");
        StringBuilder valueBuffer = new StringBuilder();
        if (obj != null && obj instanceof Double) {
            valueBuffer.append(this.getIntlString("af_dvt_gauge.LABEL_VALUE"));
            valueBuffer.append(" " + this.formatValue((Double)obj, null));
        } else {
            valueBuffer.append("No data");
        }
        int lineNum = 0;
        String[] tooltips = new String[count];
        if (topBuffer != null) {
            tooltips[lineNum++] = topBuffer.toString();
        }
        if (bottomBuffer != null) {
            tooltips[lineNum++] = bottomBuffer.toString();
        }
        if (valueBuffer != null) {
            tooltips[lineNum] = valueBuffer.toString();
        }
        return tooltips;
    }

    private boolean _isLabelColliding(DrawableObject.Label lblObj, ArrayList savedRects) {
        boolean isColliding = false;
        Rectangle rect = lblObj.getBounds();
        int right = rect.x + rect.width;
        int bottom = rect.y + rect.height;
        int numRects = savedRects.size();
        int rectIndex = 0;
        while (rectIndex < numRects) {
            Rectangle savedRect = (Rectangle)savedRects.get(rectIndex);
            if (right > savedRect.x && savedRect.x + savedRect.width > rect.x && bottom > savedRect.y && savedRect.y + rect.height > rect.y) {
                isColliding = true;
                break;
            }
            ++rectIndex;
        }
        return isColliding;
    }

    private boolean _renderObjList(GaugeRenderer renderer) {
        boolean retCode;
        block6: {
            retCode = true;
            this.prepareObjects(this.getGraphics());
            if (this._objList == null || this._objList.isEmpty()) break block6;
            ArrayList<Rectangle> rectList = new ArrayList<Rectangle>();
            int objIndex = 0;
            while (objIndex < this._objList.size()) {
                block8: {
                    DrawableObject obj;
                    block9: {
                        block7: {
                            obj = (DrawableObject)this._objList.get(objIndex);
                            if (obj == null) {
                                int column;
                                int row;
                                if (this._map == null) {
                                    row = -1;
                                    column = -1;
                                } else {
                                    Object rowObj = this._map.get("DS_ROW");
                                    row = rowObj != null ? Integer.parseInt((String)rowObj) : -1;
                                    Object colObj = this._map.get("DS_COLUMN");
                                    column = colObj != null ? Integer.parseInt((String)colObj) : -1;
                                }
                                this._eh.log("Attempt made to process null DrawableObject on gauge " + row + "," + column, this.getClass().getName(), _method_render);
                                retCode = false;
                            }
                            if (!(obj instanceof DrawableObject.TickLabel) && (this._gaugeType.getGaugeType() != 3 || !(obj instanceof DrawableObject.Label))) break block7;
                            DrawableObject.Label lblObj = (DrawableObject.Label)obj;
                            Rectangle bounds = lblObj.getBounds();
                            boolean doNotRender = false;
                            doNotRender = this._isLabelColliding(lblObj, rectList);
                            if (doNotRender) break block8;
                            rectList.add(bounds);
                            break block9;
                        }
                        if (obj instanceof DrawableObject.Label) {
                            DrawableObject.Label lblObj = (DrawableObject.Label)obj;
                            Rectangle bounds = lblObj.getBounds();
                            rectList.add(bounds);
                        }
                    }
                    obj.render(renderer);
                }
                ++objIndex;
            }
            if (rectList != null) {
                rectList.clear();
            }
        }
        return retCode;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    protected boolean isNullMetric() {
        return this._isNullMetric;
    }

    protected double getMetric() {
        return this._metric;
    }

    protected double getIncrement() {
        return this._incr;
    }

    protected int getNumberOfSteps() {
        return this._numberOfSteps;
    }

    protected int getMaxNumberOfSteps() {
        return this._numberOfSteps;
    }

    protected int _getPowerOfTen(double dValue) {
        int power;
        block4: {
            double testValue;
            block3: {
                testValue = dValue >= 0.0 ? dValue : -dValue;
                power = 0;
                if (testValue < 1.0E-15) {
                    return 0;
                }
                if (!(testValue >= 10.0)) break block3;
                while (testValue >= 10.0) {
                    ++power;
                    testValue /= (double)10;
                }
                break block4;
            }
            if (!(testValue < 1.0)) break block4;
            while (testValue < 1.0) {
                --power;
                testValue *= (double)10;
            }
        }
        return power;
    }

    private void _addToDrawableList(Collection objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        if (this._objList == null) {
            this._objList = new ArrayList(15);
        }
        Object[] drawObjects = objects.toArray();
        int obj = 0;
        while (obj < drawObjects.length) {
            if (drawObjects[obj] instanceof Collection) {
                Object[] subObjList = ((Collection)drawObjects[obj]).toArray();
                int subobj = 0;
                while (subobj < subObjList.length) {
                    this._objList.add(subObjList[subobj]);
                    ++subobj;
                }
            } else {
                this._objList.add(drawObjects[obj]);
            }
            ++obj;
        }
    }

    private double _calcTickStep() {
        double minValue = this.getMin();
        double maxValue = this.getMax();
        boolean includeMetric = this.isNullMetric() ^ true;
        double metricValue = includeMetric ? this.getMetric() : 0.0;
        double tickStep = 0.0;
        boolean minMax = false;
        boolean threshold = false;
        boolean increments = false;
        boolean metric = false;
        double thresholdStep = 0.0;
        double minMaxStep = 0.0;
        double metricStep = 0.0;
        double incrStep = this.getIncrement();
        if (this._map.get("TickLabelContent") == null) {
            minMax = true;
            if (this._map.get("ThresholdValues") != null) {
                threshold = true;
            } else {
                increments = true;
            }
        } else {
            int content = (Integer)this._map.get("TickLabelContent");
            if ((content & 3) != 0) {
                minMax = true;
            }
            if ((content & 4) != 0) {
                increments = true;
            }
            if ((content & 8) != 0) {
                threshold = true;
            }
            if ((content & 0x10) != 0 && includeMetric) {
                metric = true;
            }
        }
        if (minMax) {
            minMaxStep = maxValue - minValue;
        }
        if (threshold && this._map.get("ThresholdValues") == null) {
            threshold = false;
        }
        if (threshold) {
            double[] array = (double[])this._map.get("ThresholdValues");
            int startIndex = 0;
            int count = array.length;
            while (array[startIndex] < minValue) {
                if (++startIndex >= count) break;
            }
            while (array[count - 1] > maxValue) {
                if (--count <= 0) break;
            }
            int i = startIndex;
            while (i <= count) {
                double diff = 0.0;
                double start = 0.0;
                double end = 0.0;
                start = i == startIndex ? minValue : array[i - 1];
                end = i == count ? maxValue : array[i];
                diff = end - start;
                if (i == 0) {
                    thresholdStep = diff;
                }
                if (thresholdStep == 0.0 && diff != 0.0) {
                    thresholdStep = diff;
                }
                if (metric && metricValue > start && metricValue < end) {
                    if (metricValue - start < diff) {
                        diff = metricValue - start;
                    }
                    if (end - metricValue < diff) {
                        diff = end - metricValue;
                    }
                }
                if (diff < thresholdStep && diff != 0.0) {
                    thresholdStep = diff;
                }
                ++i;
            }
        }
        if (increments && metric) {
            int steps = this.getNumberOfSteps();
            double diff = 0.0;
            double newIncr = incrStep;
            int i = 0;
            while (i <= steps) {
                diff = Math.abs(metricValue - (double)i * incrStep);
                if (diff != 0.0 && diff < newIncr) {
                    newIncr = diff;
                }
                ++i;
            }
            incrStep = newIncr;
        }
        if (metric) {
            if (metricValue == minValue || metricValue == maxValue) {
                metricStep = minMaxStep;
            } else {
                metricStep = metricValue - minValue;
                if (metricStep > maxValue - metricValue) {
                    metricStep = maxValue - metricValue;
                }
            }
        }
        if (threshold && increments && metric) {
            tickStep = incrStep;
            if (thresholdStep < tickStep) {
                tickStep = thresholdStep;
            }
            if (metricStep < tickStep) {
                tickStep = metricStep;
            }
        } else if (threshold && increments) {
            tickStep = incrStep;
            if (thresholdStep < tickStep) {
                tickStep = thresholdStep;
            }
        } else if (increments && minMax || increments && metric) {
            tickStep = incrStep;
        } else if (threshold && minMax || threshold && metric) {
            tickStep = thresholdStep;
        } else if (metric) {
            tickStep = metricStep;
        } else if (minMax) {
            tickStep = minMaxStep;
        }
        return tickStep;
    }

    protected void determineFormat(boolean metricLabel) {
        double minValue = this.getMin();
        double maxValue = this.getMax();
        boolean includeMetric = this.isNullMetric() ^ true;
        double metricValue = includeMetric ? this.getMetric() : 0.0;
        double tickStep = 0.0;
        ViewFormat viewFmt = metricLabel ? (this._map.get("MetricLabelViewFormat") == null ? this.m_defMetricLabelViewFormat : (ViewFormat)((Object)this._map.get("MetricLabelViewFormat"))) : (this._map.get("TickLabelViewFormat") == null ? this.m_defTickLabelViewFormat : (ViewFormat)((Object)this._map.get("TickLabelViewFormat")));
        if (includeMetric && metricLabel) {
            if (metricValue == minValue || metricValue == maxValue) {
                tickStep = maxValue - minValue;
            } else {
                tickStep = metricValue - minValue;
                if (tickStep > maxValue - metricValue) {
                    tickStep = maxValue - metricValue;
                }
            }
        } else {
            tickStep = this._calcTickStep();
        }
        Object numberType = null;
        numberType = metricLabel ? this._map.get("MetricLabelNumberType") : this._map.get("TickLabelNumberType");
        if (numberType != null && (Integer)numberType == 1) {
            minValue = (minValue - this.getMin()) / (this.getMax() - this.getMin());
            maxValue = (maxValue - this.getMin()) / (this.getMax() - this.getMin());
            tickStep = (tickStep - this.getMin()) / (this.getMax() - this.getMin());
            viewFmt.setNumberType(2);
            return;
        }
        boolean bUseDefaultScaleFactor = viewFmt.isScaleFactorUsed() ^ true;
        boolean bUseDefaultDecimalDigit = viewFmt.isDecimalDigitUsed() ^ true;
        double absMax = minValue < 0.0 && -minValue > maxValue ? -minValue : maxValue;
        int power = this._getPowerOfTen(absMax);
        int scaleFactor = viewFmt.getScaleFactor();
        int decimalPlaces = viewFmt.getDecimalDigit();
        int significantDigits = 0;
        if (bUseDefaultScaleFactor) {
            if (power <= 1) {
                scaleFactor = 0;
            } else if (power >= 16) {
                scaleFactor = 5;
            } else {
                int scaleFactorPower = power / 3 * 3;
                significantDigits = power % 3;
                switch (scaleFactorPower) {
                    case 3: {
                        scaleFactor = 1;
                        break;
                    }
                    case 6: {
                        scaleFactor = 2;
                        break;
                    }
                    case 9: {
                        scaleFactor = 3;
                        break;
                    }
                    case 12: {
                        scaleFactor = 4;
                        break;
                    }
                    case 15: {
                        scaleFactor = 5;
                        break;
                    }
                    default: {
                        scaleFactor = 0;
                        break;
                    }
                }
            }
        }
        if (bUseDefaultDecimalDigit) {
            double scaledMinVal;
            int tickStepPowerOfTen;
            int scaleFactorPowerOfTen = this._getScaleFactorPowerOfTen(scaleFactor);
            decimalPlaces = scaleFactorPowerOfTen - (tickStepPowerOfTen = this._getPowerOfTen(tickStep));
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            double scaledTickStep = tickStep;
            double d = scaledMinVal = minValue < maxValue ? minValue : maxValue;
            if (scaleFactorPowerOfTen > 0) {
                scaledTickStep *= Math.pow(10.0, -scaleFactorPowerOfTen);
                scaledMinVal *= Math.pow(10.0, -scaleFactorPowerOfTen);
            }
            double targetLevOfPrec = 1.0;
            if (decimalPlaces > 0) {
                targetLevOfPrec = Math.pow(10.0, -decimalPlaces);
            }
            double nearestStepAtTLOP = Math.rint(scaledTickStep / targetLevOfPrec) * targetLevOfPrec;
            double deltaIncrementAndNearestNumAtTLOP = scaledTickStep - nearestStepAtTLOP;
            double nearestStartAtTLOP = Math.rint(scaledMinVal / targetLevOfPrec) * targetLevOfPrec;
            double deltaStartAndNearestNumAtTLOP = scaledMinVal - nearestStartAtTLOP;
            if (Math.abs(deltaStartAndNearestNumAtTLOP) >= 0.1 * targetLevOfPrec) {
                ++decimalPlaces;
            } else if (Math.abs(deltaIncrementAndNearestNumAtTLOP) >= 0.001 * targetLevOfPrec) {
                int numTicks;
                double error;
                double axisRange = maxValue - minValue;
                if (minValue > maxValue) {
                    axisRange = minValue - maxValue;
                }
                if ((error = Math.abs(deltaIncrementAndNearestNumAtTLOP * (double)(numTicks = (int)Math.floor(axisRange / tickStep)) + deltaStartAndNearestNumAtTLOP)) >= 0.1 * targetLevOfPrec) {
                    ++decimalPlaces;
                }
            }
            if (bUseDefaultScaleFactor) {
                if (scaleFactor != 0) {
                    if (significantDigits == 2) {
                        decimalPlaces = 0;
                    }
                    if (significantDigits == 1 && decimalPlaces > 1) {
                        decimalPlaces = 1;
                    }
                    if (significantDigits == 0 && decimalPlaces > 2) {
                        decimalPlaces = 2;
                    }
                }
                if (absMax <= 1.0 && decimalPlaces >= 3) {
                    decimalPlaces = 3;
                } else if (decimalPlaces >= 2) {
                    decimalPlaces = 2;
                }
                if (scaleFactor == 0) {
                    if (tickStepPowerOfTen >= 1) {
                        decimalPlaces = 0;
                    } else if (tickStepPowerOfTen == 0 && decimalPlaces > 1) {
                        decimalPlaces = 1;
                    }
                    if (power >= 2 && decimalPlaces >= 1) {
                        decimalPlaces = 0;
                    }
                }
            }
        }
        if (bUseDefaultScaleFactor) {
            viewFmt.setScaleFactor(scaleFactor);
        }
        if (bUseDefaultDecimalDigit) {
            if (decimalPlaces >= 0) {
                viewFmt.setDecimalDigit(decimalPlaces);
            } else {
                viewFmt.setDecimalDigit(0);
            }
        }
        if (metricLabel) {
            this.m_defMetricLabelViewFormat = viewFmt;
        }
        if (!metricLabel) {
            this.m_defTickLabelViewFormat = viewFmt;
        }
    }

    private int _getRecalcState() {
        return this._recalcState;
    }

    private int _getScaleFactorPowerOfTen(int scaleFactor) {
        switch (scaleFactor) {
            case 1: {
                return 3;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    private void _setRecalcState(int state) {
        this._recalcState = state;
    }

    private void _updateSteps() {
        double spread;
        int power;
        Integer majorTickCount = (Integer)this._map.get("MajorTickValue");
        if (majorTickCount != null) {
            this._maxNumberOfSteps = majorTickCount - 1;
            if (this._maxNumberOfSteps >= 0) {
                this._incr = (this._max - this._min) / (double)this._maxNumberOfSteps;
                this._numberOfSteps = this._maxNumberOfSteps;
                return;
            }
        }
        this._maxNumberOfSteps = this._gaugeType.getMaxNumberOfSteps();
        if (this._maxNumberOfSteps > GaugeDefaultValues.getMaxIncrements()) {
            this._maxNumberOfSteps = GaugeDefaultValues.getMaxIncrements();
        }
        if (this._maxNumberOfSteps < GaugeDefaultValues.getMinIncrements()) {
            this._maxNumberOfSteps = GaugeDefaultValues.getMinIncrements();
        }
        if ((power = this._getPowerOfTen(spread = this.getMin() - this.getMax())) < 0) {
            spread = power == -1 ? (spread *= Math.pow(10.0, 2.0)) : (spread *= Math.pow(10.0, 3.0));
        } else {
            int significantDigits = power % 3;
            int maxDecimalDigits = 2 - significantDigits;
            int scaleFactorPower = power / 3 * 3;
            spread *= Math.pow(10.0, maxDecimalDigits);
            spread /= Math.pow(10.0, scaleFactorPower);
        }
        boolean done = false;
        while (!done) {
            int i = this._maxNumberOfSteps;
            while (i >= GaugeDefaultValues.getMinIncrements()) {
                int reminder = (int)spread % i;
                if (reminder == 0) {
                    done = true;
                    this._maxNumberOfSteps = i;
                    break;
                }
                --i;
            }
            if (done) continue;
            if (this._maxNumberOfSteps % 2 != 0) {
                --this._maxNumberOfSteps;
            }
            done = true;
        }
        this._incr = (this._max - this._min) / (double)this._maxNumberOfSteps;
        this._numberOfSteps = this._maxNumberOfSteps;
    }

    private void _validateMinMax() {
        double minVal = 0.0;
        double maxVal = 0.0;
        boolean minAuto = true;
        boolean maxAuto = true;
        Double min = (Double)this._map.get("minValue");
        Double max = (Double)this._map.get("maxValue");
        Double metric = (Double)this._map.get("Metric");
        boolean bl = this._isNullMetric = metric == null;
        if (min != null) {
            minVal = min;
            minAuto = false;
        } else if (this._isNullMetric) {
            minVal = 0.0;
        }
        if (max != null) {
            maxVal = max;
            maxAuto = false;
        } else if (this._isNullMetric) {
            maxVal = 100.0;
        }
        this._min = minVal;
        this._max = maxVal;
        if (!this._isNullMetric) {
            Object objNumType;
            int numType;
            this._metric = metric;
            if (minAuto && this._metric >= 0.0) {
                this._min = GaugeDefaultValues.getMin();
                minAuto = false;
            }
            if (maxAuto && this._metric < 0.0) {
                this._max = GaugeDefaultValues.getMin();
                maxAuto = false;
            }
            int n = numType = (objNumType = this._map.get("TickLabelNumberType")) != null ? (Integer)objNumType : GaugeDefaultValues.getNumberType();
            if (numType == 0) {
                if (maxAuto && this._metric >= 0.0 && this._metric <= 100.0) {
                    this._max = GaugeDefaultValues.getMax();
                    maxAuto = false;
                }
                if (minAuto && this._metric < 0.0 && this._metric >= -100.0) {
                    this._min = GaugeDefaultValues.getNegativeMin();
                    minAuto = false;
                }
                if (maxAuto || minAuto) {
                    double power = Math.log(Math.abs(this._metric)) / Math.log(10.0);
                    power = Math.ceil(power);
                    if (this._metric >= 0.0) {
                        this._max = Math.pow(10.0, power);
                    } else {
                        this._min = -Math.pow(10.0, power);
                    }
                }
            } else {
                if (maxAuto && this._metric >= 0.0 && this._metric <= 1.0) {
                    this._max = GaugeDefaultValues.getPercentMax();
                    maxAuto = false;
                }
                if (minAuto && this._metric < 0.0 && this._metric >= -1.0) {
                    this._min = GaugeDefaultValues.getPercentNegativeMin();
                    minAuto = false;
                }
                if (maxAuto || minAuto) {
                    double power = Math.log(Math.abs(this._metric)) / Math.log(10.0);
                    power = Math.ceil(power);
                    if (this._metric >= 0.0) {
                        this._max = Math.pow(10.0, power);
                    } else {
                        this._min = -Math.pow(10.0, power);
                    }
                }
            }
        }
    }

    private String _getMetricThresholdText() {
        String thresholdValues = null;
        if (this._map.get("ThresholdValues") != null) {
            HashMap tMap;
            ArrayList tList;
            double[] array = (double[])this._map.get("ThresholdValues");
            int index = -1;
            int i = 0;
            while (i < array.length) {
                if (this.getMetric() <= array[i]) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                index = array.length;
            }
            if ((tList = (ArrayList)this._map.get("THRESHOLD_ATTRIBUTES")) != null && index < tList.size() && (tMap = (HashMap)tList.get(index)) != null) {
                thresholdValues = (String)tMap.get("ThresholdText");
            }
            if (thresholdValues == null) {
                double firstValue = 0.0;
                firstValue = index == 0 ? this.getMin() : array[index - 1];
                double secondValue = 0.0;
                secondValue = index == array.length ? this.getMax() : array[index];
                String[] args = new String[]{this.formatValue(firstValue, "TickLabelViewFormat"), this.formatValue(secondValue, "TickLabelViewFormat")};
                thresholdValues = "between " + args[0] + " to " + args[1];
            }
        }
        return thresholdValues;
    }

    private String _getThresholdsText() {
        StringBuilder sb = new StringBuilder();
        if (this._map.get("ThresholdValues") != null) {
            double[] array = (double[])this._map.get("ThresholdValues");
            String threshold = this.formatValue(this.getMin(), "TickLabelViewFormat");
            int i = 0;
            while (i < array.length) {
                sb.append(", threshold ");
                sb.append(i + 1);
                sb.append(": ");
                sb.append(threshold);
                sb.append(" to ");
                threshold = this.formatValue(array[i], "TickLabelViewFormat");
                sb.append(threshold);
                ++i;
            }
            sb.append(", threshold ");
            sb.append(array.length + 1);
            sb.append(": ");
            sb.append(threshold);
            sb.append(" to ");
            sb.append(this.formatValue(this.getMax(), "TickLabelViewFormat"));
        }
        return sb.toString();
    }

    protected String formatValue(double data, String viewFormatKey) {
        if (viewFormatKey == null) {
            return String.valueOf(data);
        }
        boolean isPercentType = false;
        ViewFormat viewFmt = (ViewFormat)((Object)this._map.get(viewFormatKey));
        if (viewFmt == null) {
            Object numberType = null;
            if (viewFormatKey.equals("TickLabelViewFormat")) {
                viewFmt = this.m_defTickLabelViewFormat;
                numberType = this._map.get("TickLabelNumberType");
                if (numberType != null && (Integer)numberType == 1) {
                    data = (data - this.getMin()) / (this.getMax() - this.getMin());
                    viewFmt.setNumberType(2);
                    isPercentType = true;
                }
            } else {
                viewFmt = this.m_defMetricLabelViewFormat;
                numberType = this._map.get("MetricLabelNumberType");
                if (numberType != null && (Integer)numberType == 1) {
                    data = (data - this.getMin()) / (this.getMax() - this.getMin());
                    viewFmt.setNumberType(2);
                    isPercentType = true;
                }
            }
        }
        if (data == 0.0 && !isPercentType) {
            return String.valueOf(0);
        }
        return viewFmt.DoubleToString(data);
    }

    private Map _createHashMap() {
        return new HashMap(8);
    }

    protected void setInnerBounds(Rectangle innerBounds) {
        this._innerBounds = innerBounds;
    }

    private void $init$() {
        this._min = 0.0;
        this._max = 0.0;
        this._isNullMetric = false;
        this._metric = 0.0;
        this._incr = 0.0;
        this._numberOfSteps = 0;
        this._maxNumberOfSteps = 0;
        this._outerBounds = null;
        this._innerBounds = null;
        this._requiredSize = null;
        this.m_dvtResources = null;
        this._maxNumSteps = 0;
        this._recalcState = 1;
        this.m_defTickLabelViewFormat = null;
        this.m_defMetricLabelViewFormat = null;
    }
}

