/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.util.ErrorHandler;

public class GaugeExportXMLWriter
extends ImageViewExportXMLWriter
implements GaugeRenderer {
    private GaugeEngine m_gaugeEngine;
    private Map m_map;
    protected int m_compType;
    protected String m_compName;
    protected int m_column;
    protected int m_row;
    private Graphics m_graphics;
    public static final String ELEM_GAUGE_SET = "gaugeSet";
    public static final String ATTR_GAUGE_TYPE = "gaugeType";
    public static final String ATTR_POINT_OF_ROTATION = "por";
    protected CommonGauge m_gauge;

    public GaugeExportXMLWriter(OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.$init$();
    }

    public GaugeExportXMLWriter(OutputStream os, ErrorHandler eh) {
        super(os, eh);
        this.$init$();
    }

    public GaugeExportXMLWriter(Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.$init$();
    }

    public GaugeExportXMLWriter(Writer writer, ErrorHandler eh) {
        super(writer, eh);
        this.$init$();
    }

    protected void init(GaugeEngine engine) {
        this.m_gaugeEngine = engine;
        try {
            Integer extent;
            this.startElement("md");
            if (this.m_gaugeEngine.getId() != null) {
                this.writeAttribute("id", this.m_gaugeEngine.getId());
            }
            if ((extent = (Integer)this.m_gaugeEngine.getAttribute("AngleExtent")) == null) {
                extent = GaugeDefaultValues.getAngleExtent();
            }
            double angleStart = 90 - extent / 2;
            double angleExtent = extent.doubleValue();
            this.writeAttribute("ang", angleStart + "," + angleExtent);
            String metricLabel = this.m_gaugeEngine.formatValue(this.m_gaugeEngine.getMetric(), "MetricLabelViewFormat");
            String topLabel = (String)this.m_gaugeEngine.getAttribute("TopLabel");
            String btmLabel = (String)this.m_gaugeEngine.getAttribute("BottomLabel");
            StringBuilder s = new StringBuilder();
            s.append(this.m_gaugeEngine.getMin()).append("~:");
            s.append(this.m_gaugeEngine.getMax()).append("~:");
            s.append(this.m_gaugeEngine.getMetric()).append("~:");
            if (metricLabel != null) {
                s.append(metricLabel);
            }
            s.append("~:");
            if (topLabel != null) {
                s.append(topLabel);
            }
            s.append("~:");
            if (btmLabel != null) {
                s.append(btmLabel);
            }
            this.writeAttribute("d", s.toString());
            this.endElement();
        }
        catch (Exception e) {
            this.m_gaugeEngine.getErrorHandler().trace("Problem writing GaugeEngine xml information", "GaugeExportXMLWriter", "init(GaugeEngine engine)");
        }
    }

    protected void init(int compType, Map map) {
        this.m_compType = compType;
        this.m_compName = GaugeEngine.getCompNameForImagemapEnumeration(compType);
        this.m_map = map;
        this.m_column = -1;
        this.m_row = -1;
        if (map != null) {
            Object colObj;
            Object rowObj = this.m_map.get("DS_ROW");
            if (rowObj != null && rowObj instanceof Integer) {
                this.m_row = (Integer)rowObj;
            }
            if ((colObj = this.m_map.get("DS_COLUMN")) != null && colObj instanceof Integer) {
                this.m_column = (Integer)colObj;
            }
        }
    }

    public boolean startGaugeSetElement(Dimension size, int gaugeType) throws IOException, Exception {
        this.startElement(ELEM_GAUGE_SET);
        this.writeAttribute("w", size.width);
        this.writeAttribute("h", size.height);
        this.writeAttribute(ATTR_GAUGE_TYPE, CommonGauge.convertGaugeTypeToString(gaugeType));
        if (this.isActiveDataService() || this.isPPRAnimation()) {
            this.writeAttribute("ads", "on");
        }
        this.writeAnimationAttributes();
        return true;
    }

    public void drawShape(Shape shape, Color c) {
        this._writeShape(shape, c, null, null);
    }

    public void fillShape(Shape shape, Color c, HashMap sfxMap) {
        this._writeShape(shape, null, c, sfxMap);
    }

    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(shape, borderColor, fillColor, sfxMap);
    }

    public void drawArc(Arc2D arc, Color c) {
        this._writeShape(arc, c, null, null);
    }

    public void fillArc(Arc2D arc, Color c, HashMap sfxMap) {
        this._writeShape(arc, null, c, sfxMap);
    }

    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(arc, borderColor, fillColor, sfxMap);
    }

    public void drawArea(Area area, Color c) {
        this._writeShape(area, c, null, null);
    }

    public void fillArea(Area area, Color c, HashMap sfxMap) {
        this._writeShape(area, null, c, sfxMap);
    }

    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(area, borderColor, fillColor, sfxMap);
    }

    public void drawPolygon(Polygon poly, Color c) {
        this._writeShape(poly, c, null, null);
    }

    public void fillPolygon(Polygon poly, Color c, HashMap sfxMap) {
        this._writeShape(poly, null, c, sfxMap);
    }

    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(polygon, borderColor, fillColor, sfxMap);
    }

    public void drawRect(Rectangle rect, Color c) {
        this._writeShape(rect, c, null, null);
    }

    public void fillRect(Rectangle rect, Color c, HashMap sfxMap) {
        this._writeShape(rect, null, c, sfxMap);
    }

    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(rect, borderColor, fillColor, sfxMap);
    }

    public void drawRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color c) {
        this.drawAndFillRoundedRect(rect, arcWidth, arcHeight, c, null, null);
    }

    public void fillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color c, HashMap sfxMap) {
        this.drawAndFillRoundedRect(rect, arcWidth, arcHeight, null, c, sfxMap);
    }

    public void drawAndFillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (borderColor == null && fillColor == null && sfxMap == null) {
            return;
        }
        try {
            boolean ret = this.startRectElement(rect, arcWidth, arcHeight);
            if (ret) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                if (borderColor != null) {
                    this.writeAttribute("bc", borderColor);
                }
                this.writeFillAttributes(sfxMap, rect, fillColor);
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeShapeAttributesElement();
                this.writeFillChildren(sfxMap, rect);
                this.endElement();
            }
        }
        catch (Exception ioe) {
            this.m_eh.log(ioe.getMessage(), this.getClass().getName(), "drawAndFillRoundedRect(Rectangle rect, Color borderColor, Color fillColor, int arcWidth, int arcHeight, Hashmap sfxMap)");
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        try {
            boolean ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                if (thickness != 1) {
                    this.writeAttribute("bw", thickness);
                }
                if (c != null) {
                    this.writeCachedAttribute("c", c, "l");
                }
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeShapeAttributesElement();
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "drawLine(int x1, int y1, int x2, int y2, int thickness, Color c)");
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        this.drawLine(x1, y1, x2, y2, 1, c);
    }

    public void drawString(String label, int x, int y, Font f, Color c, double angle) {
        String s;
        if (label != null && label.length() > 0 && (s = label.trim()) != null && s.length() > 0) {
            try {
                Graphics graphics;
                String fontString = this.getFontAttributes(f, c, false);
                int fid = this.getFontID(fontString);
                if (this.m_gaugeEngine != null) {
                    graphics = this.m_gaugeEngine.getGraphics();
                } else if (this.m_graphics != null) {
                    graphics = this.m_graphics;
                } else {
                    BufferedImage image = new BufferedImage(1, 1, 2);
                    this.m_graphics = graphics = ((Image)image).getGraphics();
                }
                if (this.startTextElement(x, y, graphics.getFontMetrics(f).stringWidth(label))) {
                    String[] tooltipsArray;
                    this.writeFontIndexAttribute(fid);
                    this.writeCompTypeAttributes();
                    if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                        this.writeTooltipAttribute(tooltipsArray);
                    }
                    this.writeShapeAttributesElement();
                    this.writeText(label);
                    this.endElement();
                }
            }
            catch (Exception e) {
                this.m_eh.log(e.getMessage(), this.getClass().getName(), "drawString(String label, int x, int y, Font f, Color c)");
            }
        }
    }

    public void drawImage(String imgURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        try {
            if (this.startImageElement(x, y, width, height, imgURL)) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeShapeAttributesElement();
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "drawImage(String imgURL, int x, int y, int width, int height, ImageObserver imgObs)");
        }
    }

    public void applyTransform(AffineTransform transform) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform transform) {
    }

    protected boolean startImageElement(int x, int y, int width, int height, String url) throws IOException, Exception {
        if (url != null) {
            this.startElement("img");
            this.writeAttribute("url", url);
            this.writeAttribute("x", x);
            this.writeAttribute("y", y);
            this.writeAttribute("w", width);
            this.writeAttribute("h", height);
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("url null", this.getClass().getName(), "protected boolean startImageElement(int x, int y, int width, int height, String url)");
        }
        return false;
    }

    private String[] _getTooltips() {
        String[] tooltipsArray = null;
        if ((this.m_compType == 11 || this.m_compType == 14) && this.m_gaugeEngine != null) {
            tooltipsArray = this.m_gaugeEngine._getToolTipText(17);
        }
        if (this.m_compType == 11 && this.m_map != null && this.m_map.get("Link") != null) {
            tooltipsArray = new String[]{((Double)this.m_map.get("Metric")).toString()};
        }
        return tooltipsArray;
    }

    private boolean _writeShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        boolean ret = true;
        try {
            boolean bElementStarted;
            boolean bLink = false;
            String link = null;
            String id = null;
            if (this.m_compType == 11 && this.m_map != null && this.m_map.get("Link") != null) {
                bLink = true;
                link = (String)this.m_map.get("Link");
                Object rowObj = this.m_map.get("DS_ROW");
                int row = rowObj != null ? (Integer)rowObj : -1;
                Object colObj = this.m_map.get("DS_COLUMN");
                int column = colObj != null ? (Integer)colObj : -1;
                id = row + "," + column;
            }
            if (bElementStarted = this.startElement(shape)) {
                String[] tooltipsArray;
                this.writeCompTypeAttributes();
                this.writeFillAttributes(sfxMap, shape, fillColor);
                if (borderColor != null && borderColor.getAlpha() != 0) {
                    this.writeAttribute("bc", borderColor);
                }
                if (bLink) {
                    this.writeAttribute("link", link);
                }
                if (!this.hasAlt() && (tooltipsArray = this._getTooltips()) != null && tooltipsArray.length > 0) {
                    this.writeTooltipAttribute(tooltipsArray);
                }
                this.writeShapeAttributesElement();
                this.writeFillChildren(sfxMap, shape);
                this.endElement();
            }
            if (bLink) {
                this._writeLinkBorder(shape, Color.blue, id);
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "private boolean _writeShape");
            ret = false;
        }
        return ret;
    }

    protected boolean startElement(Shape shape) throws IOException, Exception {
        boolean bElementStarted = false;
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            bElementStarted = this.startRectElement(rect.x, rect.y, rect.width, rect.height);
        } else {
            bElementStarted = shape instanceof Polygon ? this.startPolygonElement((Polygon)shape) : (shape instanceof Arc2D ? this.startCircleOrOvalElement((Arc2D)shape) : this.startPathElement(shape));
        }
        return bElementStarted;
    }

    protected void writeFillAttributes(HashMap sfxMap, Shape shape, Color fillColor) throws IOException, Exception {
        if (sfxMap != null) {
            int direction;
            String sDirection;
            int fillType;
            this.writeVisualEffectsAttributes(sfxMap);
            Object fillTypeObj = sfxMap.get("SFX_FILL_TYPE");
            if (fillTypeObj != null && fillTypeObj instanceof Integer && (fillType = ((Integer)fillTypeObj).intValue()) == 2 && (sDirection = GaugeExportXMLWriter.convertGradientDirectionToXMLString(direction = ((Integer)sfxMap.get("SFX_GRADIENT_DIRECTION")).intValue())) != null && sDirection.length() > 0) {
                this.writeCachedAttribute("ft", "ftG", null);
                return;
            }
        }
        this.writeCachedAttribute("ft", "ftC", null);
        if (fillColor == null) {
            this.writeAttribute("fc", "");
        } else if (shape instanceof Polygon) {
            this.writeCachedAttribute("fc", fillColor, "pg");
        } else {
            this.writeAttribute("fc", fillColor);
        }
    }

    protected void writeFillChildren(HashMap sfxMap, Shape shape) throws IOException, Exception {
        int direction;
        String sDirection;
        int fillType;
        Object fillTypeObj;
        if (sfxMap != null && (fillTypeObj = sfxMap.get("SFX_FILL_TYPE")) != null && fillTypeObj instanceof Integer && (fillType = ((Integer)fillTypeObj).intValue()) == 2 && (sDirection = GaugeExportXMLWriter.convertGradientDirectionToXMLString(direction = ((Integer)sfxMap.get("SFX_GRADIENT_DIRECTION")).intValue())) != null && sDirection.length() > 0) {
            this.writeGradientElement(sfxMap, shape);
        }
    }

    protected void writeGradientElement(HashMap sfxMap, Shape shape) throws IOException, Exception {
        int direction = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
        String sDirection = GaugeExportXMLWriter.convertGradientDirectionToXMLString(direction);
        if (sDirection != null) {
            this.startElement("g");
            this.writeCachedAttribute("dir", sDirection, null);
            if (shape != null) {
                Rectangle2D bounds = shape.getBounds2D();
                this.writeAttribute("b", bounds.getX() + "," + bounds.getY() + "," + bounds.getWidth() + "," + bounds.getHeight());
                Rectangle rect = null;
                rect = shape.getBounds();
                Point2D gradientCenter = (Point2D)sfxMap.get("SFX_GRADIENT_CENTER");
                if (gradientCenter != null && rect != null) {
                    int cy;
                    int cx;
                    if (direction == 21) {
                        cx = (int)(rect.getX() + rect.getWidth() * gradientCenter.getX() / 100.0);
                        cy = (int)(rect.getY() + rect.getHeight() * gradientCenter.getY() / 100.0);
                    } else {
                        cx = (int)(gradientCenter.getX() + rect.getX());
                        cy = (int)(gradientCenter.getY() + rect.getY());
                    }
                    this.writeAttribute("cx", cx);
                    this.writeAttribute("cy", cy);
                    this.writeAttribute("r", Math.max(rect.width, rect.height) / 2);
                } else if (direction == 9 && rect != null) {
                    int cx = rect.x + rect.width / 2;
                    int cy = rect.y + rect.height / 2;
                    this.writeAttribute("cx", cx);
                    this.writeAttribute("cy", cy);
                    if (rect.width == rect.height) {
                        this.writeAttribute("r", rect.width / 2);
                    } else {
                        this.writeAttribute("rx", rect.width / 2);
                        this.writeAttribute("ry", rect.height / 2);
                    }
                } else if (direction == 20) {
                    Point2D start = (Point2D)sfxMap.get("SFX_START_POINT");
                    Point2D end = (Point2D)sfxMap.get("SFX_END_POINT");
                    int x1 = (int)(rect.getX() + rect.getWidth() * start.getX() / 100.0);
                    int y1 = (int)(rect.getY() + rect.getHeight() * start.getY() / 100.0);
                    int x2 = (int)(rect.getX() + rect.getWidth() * end.getX() / 100.0);
                    int y2 = (int)(rect.getY() + rect.getHeight() * end.getY() / 100.0);
                    StringBuilder sb = new StringBuilder();
                    sb.append(x1).append(",").append(y1).append(",").append(x2).append(",").append(y2);
                    this.writeAttribute("pts", sb.toString());
                }
            }
            this.writeGradientStopAttributes(sfxMap);
            this.endElement();
        }
    }

    protected void writeGradientStopAttributes(HashMap sfxMap) throws IOException, Exception {
        StringBuilder pos = new StringBuilder();
        StringBuilder c = new StringBuilder();
        int stopCount = (Integer)sfxMap.get("SFX_NUM_STOPS");
        ArrayList stops = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
        ArrayList colors = (ArrayList)sfxMap.get("SFX_STOP_COLORS");
        int stop = 0;
        while (stop < stopCount) {
            if (pos.length() > 0) {
                pos.append(",");
            }
            if (c.length() > 0) {
                c.append(",");
            }
            double offset = ((Double)stops.get(stop)).floatValue();
            Color color = (Color)colors.get(stop);
            pos.append(offset);
            c.append(GaugeExportXMLWriter.colorToHexWithAlpha(color));
            ++stop;
        }
        this.writeCachedAttribute("p", pos.toString(), null);
        this.writeAttribute("c", c.toString());
    }

    protected void writeCompTypeAttributes() throws IOException, Exception {
        if (this.m_compType >= 0) {
            Point2D center;
            String s = GaugeExportXMLWriter.convertCompTypeToString(this.m_compType);
            if (s != null && s.length() > 0) {
                this.writeCachedAttribute("O", s, null);
            }
            if (this.m_compType == 14 && (center = (Point2D)this.m_gaugeEngine.getAttribute("MetadataPointOfRotation")) != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(center.getX()).append(",").append(center.getY());
                this.writeAttribute(ATTR_POINT_OF_ROTATION, sb.toString());
            }
            if (this.m_compType == 34) {
                this.writeAttribute("go", "t");
            }
        }
    }

    public void writeVisualEffectsAttributes(Map map) throws IOException, Exception {
        if (map == null) {
            return;
        }
        int vfx = 1;
        if (map.get("SFX_VISUAL_EFFECTS") != null) {
            vfx = (Integer)map.get("SFX_VISUAL_EFFECTS");
        }
        if (vfx == 0) {
            return;
        }
        boolean bShadow = (vfx & 2) > 0;
        boolean bBevel = (vfx & 4) > 0;
        boolean bGlow = (vfx & 8) > 0;
        Color sColor = (Color)map.get("shadowColor");
        Double sDistance = (Double)map.get("shadowDistance");
        Double sStrength = (Double)map.get("shadowStrength");
        Double sAngle = (Double)map.get("shadowAngle");
        Double sBlurX = (Double)map.get("shadowBlurX");
        Double sBlurY = (Double)map.get("shadowBlurY");
        Integer sQuality = (Integer)map.get("shadowQuality");
        Integer sInner = (Integer)map.get("shadowInner");
        Integer sKnockout = (Integer)map.get("shadowKnockout");
        Integer sHide = (Integer)map.get("shadowHide");
        if (sColor != null || sDistance != null || sStrength != null || sAngle != null || sBlurX != null || sBlurY != null || sQuality != null || sInner != null || sKnockout != null || sHide != null || bShadow) {
            this.writeShadowAttribute(sColor, sDistance, sStrength, sAngle, sBlurX, sBlurY, sQuality, sInner, sKnockout, sHide);
        }
        Color bHighlightColor = (Color)map.get("bevelHighlightColor");
        Color bShadowColor = (Color)map.get("bevelShadowColor");
        Double bDistance = (Double)map.get("bevelDistance");
        Double bStrength = (Double)map.get("bevelStrength");
        Double bAngle = (Double)map.get("bevelAngle");
        Double bBlurX = (Double)map.get("bevelBlurX");
        Double bBlurY = (Double)map.get("bevelBlurY");
        Integer bQuality = (Integer)map.get("bevelQuality");
        String bType = (String)map.get("bevelType");
        if (bHighlightColor != null || bShadowColor != null || bDistance != null || bStrength != null || bAngle != null || bBlurX != null || bBlurY != null || bQuality != null || bType != null || bBevel) {
            this.writeBevelAttribute(bHighlightColor, bShadowColor, bDistance, bStrength, bAngle, bBlurX, bBlurY, bQuality, bType);
        }
        Color gColor = (Color)map.get("glowColor");
        Double gBlurX = (Double)map.get("glowBlurX");
        Double gBlurY = (Double)map.get("glowBlurY");
        Double gStrength = (Double)map.get("glowStrength");
        Integer gQuality = (Integer)map.get("glowQuality");
        Integer gInner = (Integer)map.get("glowInner");
        Integer gKnockout = (Integer)map.get("glowKnockout");
        if (gColor != null || gBlurX != null || gBlurY != null || gStrength != null || gQuality != null || gInner != null || gKnockout != null || bGlow) {
            this.writeGlowAttribute(gColor, gBlurX, gBlurY, gStrength, gQuality, gInner, gKnockout);
        }
    }

    protected static String convertCompTypeToString(int compType) {
        switch (compType) {
            case 10: {
                return "Background";
            }
            case 11: {
                return "PlotArea";
            }
            case 12: {
                return "TickLabel";
            }
            case 13: {
                return "TickMark";
            }
            case 14: {
                return "Indicator";
            }
            case 15: {
                return "Threshold";
            }
            case 16: {
                return "TopLabel";
            }
            case 17: {
                return "BottomLabel";
            }
            case 18: {
                return "MetricLabel";
            }
            case 19: {
                return "ElementA";
            }
            case 20: {
                return "ElementB";
            }
            case 21: {
                return "IntersectionAB";
            }
            case 23: {
                return "GaugeSetBackground";
            }
            case 24: {
                return "GaugeFrame";
            }
            case 25: {
                return "UpperLabelFrame";
            }
            case 26: {
                return "LowerLabelFrame";
            }
            case 27: {
                return "LA";
            }
            case 28: {
                return "LT";
            }
            case 29: {
                return "LegendTitle";
            }
            case 30: {
                return "IndicatorBase";
            }
            case 31: {
                return "IndicatorBar";
            }
            case 32: {
                return "TitleSeparator";
            }
            case 33: {
                return "LowerLabelFrameReflection";
            }
            case 34: {
                return "Overlay";
            }
        }
        return null;
    }

    public static String convertGradientDirectionToXMLString(int direction) {
        switch (direction) {
            case 1: {
                return "gdRi";
            }
            case 3: {
                return "gdD";
            }
            case 5: {
                return "gdD45";
            }
            case 7: {
                return "gdD135";
            }
            case 20: {
                return "gdC";
            }
            case 9: {
                return "gdR";
            }
            case 10: {
                return "GD_RADIAL_TOP_LEFT";
            }
            case 11: {
                return "GD_RADIAL_TOP_RIGHT";
            }
            case 12: {
                return "GD_RADIAL_BOTTOM_LEFT";
            }
            case 13: {
                return "GD_RADIAL_BOTTOM_RIGHT";
            }
            case 14: {
                return "gdR";
            }
            case 21: {
                return "gdR";
            }
        }
        return null;
    }

    private void _writeLinkBorder(Shape shape, Color borderColor, String id) {
        try {
            boolean bElementStarted = this.startElement(shape);
            if (bElementStarted) {
                this.writeAttribute("bc", borderColor);
                this.writeAttribute("v", "h");
                this.writeAttribute("id", id);
                this.writeCachedAttribute("ft", "ftC", null);
                this.writeAttribute("fc", "");
                this.writeAttribute("bw", "2");
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_eh.log(e.getMessage(), this.getClass().getName(), "_writeLinkBorder(Shape shape, Color borderColor, Color fillColor)");
        }
    }

    public void writeAnimationAttributes() throws IOException, Exception {
        Color animationDownColor;
        Color animationUpColor;
        int animationOnDisplay;
        int animationDuration;
        int animationIndicators;
        if (this.m_gauge == null) {
            return;
        }
        int animationOnDataChange = this.m_gauge.getAnimationOnDataChange();
        if (animationOnDataChange != GaugeDefaultValues.getAnimationOnDataChange()) {
            this.writeAttribute("aDC", CommonGauge.convertAnimationOnDataChangeToString(animationOnDataChange));
        }
        if ((animationIndicators = this.m_gauge.getAnimationIndicators()) != GaugeDefaultValues.getAnimationIndicators()) {
            this.writeAttribute("aI", CommonGauge.convertAnimationIndicatorsToString(animationIndicators));
        }
        if ((animationDuration = this.m_gauge.getAnimationDuration()) != GaugeDefaultValues.getAnimationDuration()) {
            this.writeAttribute("aDu", animationDuration);
        }
        if ((animationOnDisplay = this.m_gauge.getAnimationOnDisplay()) != GaugeDefaultValues.getAnimationOnDisplay()) {
            this.writeAttribute("aDi", CommonGauge.convertAnimationOnDisplayToString(animationOnDisplay));
        }
        if (!(animationUpColor = this.m_gauge.getAnimationUpColor()).equals(GaugeDefaultValues.getAnimationUpColor())) {
            this.writeAttribute("aU", animationUpColor);
        }
        if (!(animationDownColor = this.m_gauge.getAnimationDownColor()).equals(GaugeDefaultValues.getAnimationDownColor())) {
            this.writeAttribute("aD", animationDownColor);
        }
    }

    private void $init$() {
        this.m_gaugeEngine = null;
        this.m_map = null;
        this.m_compType = -1;
        this.m_compName = null;
        this.m_column = -1;
        this.m_row = -1;
        this.m_graphics = null;
    }
}

