/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import javax.swing.JPanel;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.gauge.CommonGauge;

public class GaugePanel
extends JPanel
implements ViewComponent {
    protected Image _gpOffscreenImage;
    protected boolean _gpPrintOrPreviewMode;
    private CommonGauge _cmnGauge;

    public GaugePanel(CommonGauge cmnGauge) {
        this.$init$();
        this._cmnGauge = cmnGauge;
    }

    public void setPrintOrPreviewMode(boolean bool) {
        Graphics offg = null;
        if (bool) {
            Dimension size = this.getSize();
            if (this._gpOffscreenImage == null) {
                this._gpOffscreenImage = this.createImage(size.width, size.height);
            }
            if (this._gpOffscreenImage != null) {
                offg = this._gpOffscreenImage.getGraphics();
                offg.setClip(0, 0, size.width, size.height);
                this.paint(offg);
            }
            this._gpPrintOrPreviewMode = bool;
        } else {
            this._gpPrintOrPreviewMode = bool;
            if (offg != null) {
                offg.dispose();
            }
            this._gpOffscreenImage = null;
        }
    }

    public void paint(Graphics g) {
        if (!this._gpPrintOrPreviewMode) {
            super.paint(g);
        } else if (this._gpOffscreenImage != null) {
            g.drawImage(this._gpOffscreenImage, 0, 0, null);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle bounds = this.getBounds();
        g.setClip(bounds);
        this._cmnGauge.renderGauges((Graphics2D)g);
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this._cmnGauge.getThickDataview().repaint();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this._cmnGauge.getThickDataview().repaint();
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this._cmnGauge.getThickDataview().repaint();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this._cmnGauge.getThickDataview().repaint();
    }

    public String getToolTipText(MouseEvent e) {
        return this._cmnGauge.getToolTipText(e);
    }

    public int getID() {
        return 9;
    }

    public String getComponentName() {
        return "Gauge";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    private void $init$() {
        this._gpOffscreenImage = null;
        this._gpPrintOrPreviewMode = false;
    }
}

