/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.presutil.SVGWriter;
import oracle.dss.util.ErrorHandler;

public class GaugeSVGWriter
extends SVGWriter
implements GaugeRenderer {
    private static final String GRADIENT_ID_BASE = "grad";
    private int m_gradientCount;
    private Map m_map;
    private int m_compType;
    private int _svgMode;
    private ErrorHandler m_errorHandler;

    public GaugeSVGWriter(OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.$init$();
        this.m_errorHandler = eh;
    }

    public GaugeSVGWriter(OutputStream os, ErrorHandler eh) {
        this(os, eh, null);
    }

    public GaugeSVGWriter(Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.$init$();
    }

    public GaugeSVGWriter(Writer writer, ErrorHandler eh) {
        this(writer, eh, null);
    }

    protected int getSvgMode() {
        return this._svgMode;
    }

    public void setSvgMode(int mode) {
        this._svgMode = mode;
    }

    public void setCompType(int type) {
        this.m_compType = type;
    }

    public void setMap(Map map) {
        this.m_map = map;
    }

    public void drawShape(Shape shape, Color c) {
        this._writeShape(shape, c, null, null);
    }

    public void fillShape(Shape shape, Color c, HashMap sfxMap) {
        this._writeShape(shape, null, c, sfxMap);
    }

    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(shape, borderColor, fillColor, sfxMap);
    }

    public void drawArc(Arc2D arc, Color c) {
        this._writeShape(arc, c, null, null);
    }

    public void fillArc(Arc2D arc, Color c, HashMap sfxMap) {
        this._writeShape(arc, null, c, sfxMap);
    }

    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(arc, borderColor, fillColor, sfxMap);
    }

    public void drawArea(Area area, Color c) {
        this._writeShape(area, c, null, null);
    }

    public void fillArea(Area area, Color c, HashMap sfxMap) {
        this._writeShape(area, null, c, sfxMap);
    }

    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(area, borderColor, fillColor, sfxMap);
    }

    public void drawPolygon(Polygon poly, Color c) {
        this._writeShape(poly, c, null, null);
    }

    public void fillPolygon(Polygon poly, Color c, HashMap sfxMap) {
        this._writeShape(poly, null, c, sfxMap);
    }

    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(polygon, borderColor, fillColor, sfxMap);
    }

    public void drawRect(Rectangle rect, Color c) {
        this._writeShape(rect, c, null, null);
    }

    public void fillRect(Rectangle rect, Color c, HashMap sfxMap) {
        this._writeShape(rect, null, c, sfxMap);
    }

    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, HashMap sfxMap) {
        this._writeShape(rect, borderColor, fillColor, sfxMap);
    }

    public void drawRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color c) {
        this.drawAndFillRoundedRect(rect, arcWidth, arcHeight, c, null, null);
    }

    public void fillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color c, HashMap sfxMap) {
        this.drawAndFillRoundedRect(rect, arcWidth, arcHeight, null, c, sfxMap);
    }

    public void drawAndFillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (borderColor == null && fillColor == null && sfxMap == null) {
            return;
        }
        try {
            String fillAttr = this.getFillAttribute(sfxMap, rect, fillColor);
            boolean ret = this.startRoundedRectElement(rect, arcWidth, arcHeight);
            if (ret) {
                if (borderColor != null) {
                    this.writeAttribute("stroke", borderColor);
                }
                this.writeAttribute("fill", fillAttr);
                if (fillColor != null) {
                    this.writeOpacityAttribute(fillColor, "fill-opacity");
                }
                this.endElement();
            }
        }
        catch (Exception ioe) {
            this.m_errorHandler.log(ioe.getMessage(), this.getClass().getName(), "drawAndFillRoundedRect(Rectangle rect, Color borderColor, Color fillColor, int arcWidth, int arcHeight, Hashmap sfxMap)");
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        try {
            boolean ret = this.startLineElement(x1, y1, x2, y2);
            if (ret) {
                if (thickness != 1) {
                    this.writeAttribute("stroke-width", thickness);
                }
                if (c != null) {
                    this.writeAttribute("stroke", c);
                }
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "drawLine(int x1, int y1, int x2, int y2, int thickness, Color c)");
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        this.drawLine(x1, y1, x2, y2, 1, c);
    }

    public void drawString(String label, int x, int y, Font f, Color c, double angle) {
        try {
            if (this.startTextElement(x, y)) {
                this.writeFontAttributes(f);
                this.writeAttribute("fill", c);
                this.writeText(label, f);
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "drawString(String label, int x, int y, Font f, Color c)");
        }
    }

    public void drawImage(String imgURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        try {
            this.writeImageElement(x, y, width, height, imgURL);
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "drawImage(String imgURL, int x, int y, int width, int height, ImageObserver imgObs)");
        }
    }

    public void applyTransform(AffineTransform transform) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform transform) {
    }

    private boolean _writeShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        boolean ret = true;
        try {
            boolean bStartA;
            boolean bOnMouseOverOutPresent;
            boolean bOnClickPresent;
            boolean bTooltips = (this._svgMode & 2) != 0;
            String[] tooltipsArray = null;
            if (bTooltips) {
                tooltipsArray = null;
            }
            boolean bShapeAttributes = (this._svgMode & 0x10) != 0;
            String clickEventJS = null;
            boolean bl = bOnClickPresent = bShapeAttributes && this.isOnClickPresent();
            if (bShapeAttributes && !bOnClickPresent) {
                clickEventJS = this.getClickEventJS();
            }
            boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && this.isOnMouseOverOutPresent();
            if (bOnMouseOverOutPresent) {
                bTooltips = false;
            }
            String saAlt = null;
            String saTitle = null;
            String saHRef = null;
            String saTarget = null;
            if (bShapeAttributes) {
                saAlt = this.getShapeAttributesAlt();
                saTitle = this.getShapeAttributesTitle();
                if (!bOnClickPresent) {
                    saHRef = this.getShapeAttributesHRef();
                }
                saTarget = this.getShapeAttributesTarget();
            }
            boolean bDrilling = (this._svgMode & 4) != 0;
            bDrilling = false;
            boolean bLink = false;
            String link = null;
            String id = null;
            if (this.m_compType == 11 && this.m_map != null && this.m_map.get("Link") != null) {
                bLink = true;
                link = (String)this.m_map.get("Link");
                Object rowObj = this.m_map.get("DS_ROW");
                int row = rowObj != null ? (Integer)rowObj : -1;
                Object colObj = this.m_map.get("DS_COLUMN");
                int column = colObj != null ? (Integer)colObj : -1;
                bTooltips = true;
                id = row + "," + column;
            }
            if (bTooltips) {
                if (bLink) {
                    tooltipsArray = new String[]{((Double)this.m_map.get("Metric")).toString()};
                }
                if (saAlt != null) {
                    tooltipsArray = new String[]{saAlt};
                } else if (saTitle != null) {
                    tooltipsArray = new String[]{saTitle};
                }
            }
            bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
            boolean bl3 = bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
            if (bStartA) {
                this.startElement("a");
                String href = "";
                if (clickEventJS == null && !bDrilling && saHRef != null) {
                    href = saHRef;
                } else if (clickEventJS == null && !bDrilling && bLink) {
                    href = link;
                }
                this.writeAttribute("xlink:href", href);
                if (saTarget != null) {
                    this.writeAttribute("target", saTarget);
                }
                if (clickEventJS != null) {
                    this.writeAttribute("onclick", clickEventJS);
                }
            }
            String fillAttr = this.getFillAttribute(sfxMap, shape, fillColor);
            boolean bElementStarted = false;
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                bElementStarted = this.startRectElement(rect.x, rect.y, rect.width, rect.height);
            } else {
                bElementStarted = shape instanceof Polygon ? this.startPolygonElement((Polygon)shape) : this.startPathElement(shape);
            }
            if (bElementStarted) {
                this.writeAttribute("fill", fillAttr);
                if (fillColor != null) {
                    this.writeOpacityAttribute(fillColor, "fill-opacity");
                }
                if (bShapeAttributes) {
                    this.writeShapeAttributes();
                } else if (saTitle != null) {
                    this.writeTitleElement(saTitle);
                }
                if (borderColor != null && borderColor.getAlpha() != 0) {
                    this.writeAttribute("stroke", borderColor);
                }
                if (bTooltips && bLink) {
                    String onMouseOverJS = "bi_link_show_mOver(evt,'" + id + "');";
                    String onMouseOutJS = "bi_link_hide_mOut(evt,'" + id + "');";
                    boolean bTooltipWritten = this.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
                }
                this.endElement();
            }
            if (bStartA) {
                this.endElement();
            }
            if (bLink) {
                this._writeLinkBorder(shape, Color.blue, id);
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "_writeShape(Shape shape, Color borderColor, Color fillColor)");
            ret = false;
        }
        return ret;
    }

    private void _writeLinkBorder(Shape shape, Color borderColor, String id) {
        try {
            boolean bElementStarted = false;
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                bElementStarted = this.startRectElement(rect.x, rect.y, rect.width, rect.height);
            } else {
                bElementStarted = shape instanceof Polygon ? this.startPolygonElement((Polygon)shape) : this.startPathElement(shape);
            }
            if (bElementStarted) {
                this.writeAttribute("stroke", borderColor);
                this.writeAttribute("visibility", "hidden");
                this.writeAttribute("id", id);
                this.writeAttribute("fill", "none");
                this.writeAttribute("stroke-width", "2");
                this.endElement();
            }
        }
        catch (Exception e) {
            this.m_errorHandler.log(e.getMessage(), this.getClass().getName(), "_writeLinkBorder(Shape shape, Color borderColor, Color fillColor)");
        }
    }

    public String getBeanName() {
        return "bigauge1";
    }

    public String getFilteredBeanName() {
        String name = this.getBeanName();
        if (name != null && name.length() > 0) {
            name = name.replace(':', '_');
        }
        return name;
    }

    public String getSimpleBeanName() {
        int i;
        String name = this.getBeanName();
        if (name != null && name.length() > 0 && (i = name.lastIndexOf(58)) > -1 && i < name.length() - 1) {
            name = name.substring(i + 1, name.length());
        }
        return name;
    }

    public String getClickEventJS() {
        return null;
    }

    public boolean isOnClickPresent() {
        return false;
    }

    public boolean isOnMouseOverOutPresent() {
        return false;
    }

    public String getShapeAttributesAlt() {
        return null;
    }

    public String getShapeAttributesTitle() {
        return null;
    }

    public String getShapeAttributesHRef() {
        return null;
    }

    public String getShapeAttributesTarget() {
        return null;
    }

    public void writeShapeAttributes() throws IOException, Exception {
    }

    public void writeShapeAttributesScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? "orabiscript" : "script");
        String scriptId = this.constructId("bi_shape_attributes");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_onClick(evt, snglClick, dblClick)");
        this.println("{");
        this.println("  if ((evt.detail == 2) && (dblClick != null))");
        this.println("    eval(dblClick);");
        this.println("  else");
        this.println("  {");
        this.println("    if (snglClick != null)");
        this.println("      eval(snglClick);");
        this.println("  }");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    public void writeLinkScript() throws IOException, Exception {
        this.startElement("defs");
        this.startElement(this.isEncodingScriptTag() ? "orabiscript" : "script");
        String scriptId = this.constructId("bi_gauge_link");
        if (scriptId != null) {
            this.writeAttribute("id", scriptId);
            this.addToScriptIdList(scriptId);
        }
        this.startCData();
        this.println();
        this.println("function bi_link_show_mOver(evt, id)");
        this.println("{");
        this.println("       var rect = document.getElementById(id);");
        this.println("       rect.setAttributeNS(null, \"visibility\", \"visible\");");
        this.println("}");
        this.println("function bi_link_hide_mOut(evt, id)");
        this.println("{");
        this.println("       var rect = document.getElementById(id);");
        this.println("       rect.setAttributeNS(null, \"visibility\", \"hidden\");");
        this.println("}");
        this.endCData();
        this.println();
        this.endElement();
        this.endElement();
    }

    protected String getFillAttribute(HashMap sfxMap, Shape shape, Color fillColor) throws IOException, Exception {
        String fillAttr = null;
        int fillType = sfxMap != null && sfxMap.get("SFX_FILL_TYPE") != null ? (Integer)sfxMap.get("SFX_FILL_TYPE") : 1;
        if (fillType == 2) {
            String gradientName = this._writeGradientElement(sfxMap, shape);
            if (gradientName != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("url(#");
                sb.append(gradientName);
                sb.append(')');
                fillAttr = sb.toString();
            } else {
                if (this.m_eh != null) {
                    this.m_eh.log("gradient name null", this.getClass().getName(), "protected String getFillAttribute");
                }
                fillAttr = fillColor != null ? GaugeSVGWriter.colorToHex(fillColor) : "none";
            }
        } else {
            fillAttr = fillColor != null ? GaugeSVGWriter.colorToHex(fillColor) : "none";
        }
        return fillAttr;
    }

    protected void writeOpacityAttribute(Color color, String attr) throws IOException, Exception {
        int alpha = color.getAlpha();
        if (alpha < 255) {
            double opacity = (double)alpha / 255.0;
            if (opacity < 0.0) {
                opacity = 0.0;
            } else if (opacity > 255.0) {
                opacity = 255.0;
            }
            this.writeAttribute(attr, opacity);
        }
    }

    private String _writeGradientElement(HashMap sfxMap, Shape shape) throws IOException, Exception {
        String elemID = this.getNextGradientID();
        this.startElement("defs");
        int direction = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
        switch (direction) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 20: {
                this._writeLinearGradientElement(sfxMap, shape, elemID, direction);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                this._writeRadialGradientElement(shape, sfxMap, elemID, direction);
                break;
            }
        }
        this.endElement();
        return elemID;
    }

    private void _writeLinearGradientElement(HashMap sfxMap, Shape shape, String elemID, int direction) throws IOException, Exception {
        this.startElement("linearGradient");
        this.writeAttribute("id", elemID);
        if (direction != 20) {
            this.writeAttribute("gradientUnits", "userSpaceOnUse");
        } else {
            this.writeAttribute("gradientUnits", "objectBoundingBox");
        }
        Rectangle bounds = shape.getBounds();
        if (shape instanceof Arc2D) {
            bounds = shape.getBounds2D().getBounds();
        }
        boolean gradRev = (Boolean)sfxMap.get("SFX_GRADIENT_REVERSED");
        switch (direction) {
            case 1: {
                if (!gradRev) {
                    this.writeAttribute("x1", bounds.getX());
                    this.writeAttribute("y1", bounds.y + bounds.height / 2);
                    this.writeAttribute("x2", bounds.x + bounds.width);
                    this.writeAttribute("y2", bounds.y + bounds.height / 2);
                    break;
                }
                this.writeAttribute("x1", bounds.x + bounds.width);
                this.writeAttribute("y1", bounds.y + bounds.height / 2);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y + bounds.height / 2);
                break;
            }
            case 3: {
                if (!gradRev) {
                    this.writeAttribute("x1", bounds.x + bounds.width / 2);
                    this.writeAttribute("y1", bounds.y);
                    this.writeAttribute("x2", bounds.x + bounds.width / 2);
                    this.writeAttribute("y2", bounds.y + bounds.height);
                    break;
                }
                this.writeAttribute("x1", bounds.x + bounds.width / 2);
                this.writeAttribute("y1", bounds.y + bounds.height);
                this.writeAttribute("x2", bounds.x + bounds.width / 2);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 5: {
                if (!gradRev) {
                    this.writeAttribute("x1", bounds.x + bounds.width);
                    this.writeAttribute("y1", bounds.y);
                    this.writeAttribute("x2", bounds.x);
                    this.writeAttribute("y2", bounds.y + bounds.height);
                    break;
                }
                this.writeAttribute("x1", bounds.x + bounds.width);
                this.writeAttribute("y1", bounds.y + bounds.height);
                this.writeAttribute("x2", bounds.x);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 7: {
                if (!gradRev) {
                    this.writeAttribute("x1", bounds.x);
                    this.writeAttribute("y1", bounds.y);
                    this.writeAttribute("x2", bounds.x + bounds.width);
                    this.writeAttribute("y2", bounds.y + bounds.height);
                    break;
                }
                this.writeAttribute("x1", bounds.x);
                this.writeAttribute("y1", bounds.y + bounds.height);
                this.writeAttribute("x2", bounds.x + bounds.width);
                this.writeAttribute("y2", bounds.y);
                break;
            }
            case 20: {
                Point2D startPoint = (Point2D)sfxMap.get("SFX_START_POINT");
                Point2D endPoint = (Point2D)sfxMap.get("SFX_END_POINT");
                int x1 = (int)startPoint.getX();
                int y1 = (int)startPoint.getY();
                int x2 = (int)endPoint.getX();
                int y2 = (int)endPoint.getY();
                this.writeAttribute("x1", x1 + "%");
                this.writeAttribute("y1", y1 + "%");
                this.writeAttribute("x2", x2 + "%");
                this.writeAttribute("y2", y2 + "%");
                break;
            }
        }
        this._writeGradientStopElements(sfxMap);
        this.endElement();
    }

    private void _writeRadialGradientElement(Shape shape, HashMap sfxMap, String elemID, int direction) throws IOException, Exception {
        this.startElement("radialGradient");
        this.writeAttribute("id", elemID);
        Point2D gradientCenter = (Point2D)sfxMap.get("SFX_GRADIENT_CENTER");
        switch (direction) {
            case 9: 
            case 14: {
                Rectangle rect = null;
                if (shape != null) {
                    rect = shape.getBounds();
                }
                if (gradientCenter != null && rect != null) {
                    if (shape != null && shape instanceof Arc2D) {
                        Rectangle2D arcRect = ((Arc2D)shape).getBounds2D();
                        double centerX = gradientCenter.getX() - (arcRect.getX() - rect.getX());
                        double centerY = gradientCenter.getY() - (arcRect.getY() - rect.getY());
                        int cx = (int)(100.0 * centerX / arcRect.getWidth());
                        int cy = (int)(100.0 * centerY / arcRect.getHeight());
                        this.writeAttribute("cx", cx + "%");
                        this.writeAttribute("cy", cy + "%");
                        this.writeAttribute("r", "100%");
                        break;
                    }
                    int cx = (int)(100.0 * gradientCenter.getX() / rect.getWidth());
                    int cy = (int)(100.0 * gradientCenter.getY() / rect.getHeight());
                    this.writeAttribute("cx", cx + "%");
                    this.writeAttribute("cy", cy + "%");
                    this.writeAttribute("r", "50%");
                    break;
                }
                this.writeAttribute("r", "75%");
                if (this.m_compType != 11) break;
                this.writeAttribute("cx", "50%");
                this.writeAttribute("cy", "100%");
                break;
            }
            case 10: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "0%");
                this.writeAttribute("cy", "0%");
                break;
            }
            case 11: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "100%");
                this.writeAttribute("cy", "0%");
                break;
            }
            case 12: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "0%");
                this.writeAttribute("cy", "100%");
                break;
            }
            case 13: {
                this.writeAttribute("r", "150%");
                this.writeAttribute("cx", "100%");
                this.writeAttribute("cy", "100%");
                break;
            }
            case 21: {
                int cx = (int)gradientCenter.getX();
                int cy = (int)gradientCenter.getY();
                this.writeAttribute("r", "40%");
                this.writeAttribute("cx", cx + "%");
                this.writeAttribute("cy", cy + "%");
                break;
            }
        }
        this._writeGradientStopElements(sfxMap);
        this.endElement();
    }

    private void _writeGradientStopElements(HashMap sfxMap) throws IOException, Exception {
        int stopCount = (Integer)sfxMap.get("SFX_NUM_STOPS");
        ArrayList stops = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
        ArrayList colors = (ArrayList)sfxMap.get("SFX_STOP_COLORS");
        int stop = 0;
        while (stop < stopCount) {
            this.startElement("stop");
            double offset = ((Double)stops.get(stop)).floatValue();
            this.writeAttribute("offset", offset);
            Color color = (Color)colors.get(stop);
            this.writeAttribute("stop-color", color);
            if (color != null) {
                this.writeOpacityAttribute(color, "stop-opacity");
            }
            this.endElement();
            ++stop;
        }
    }

    private String getNextGradientID() {
        return this.getFilteredBeanName() + "_" + GRADIENT_ID_BASE + this.m_gradientCount++;
    }

    protected String constructId(String id) {
        if (id == null || id.length() < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFilteredBeanName());
        sb.append("_");
        sb.append(id);
        return sb.toString();
    }

    private void $init$() {
        this.m_gradientCount = 0;
        this.m_map = null;
        this.m_compType = 0;
        this._svgMode = 1;
    }
}

