/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.List;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.ColorPinStripeObj;
import oracle.dss.graph.pfj.draw.ImageLoader;

public class GradientObj {
    public static final int RADIAL = 9;
    private static final int GRADIENT_MAX = 14;
    private int m_nDirection;
    private ColorPinStripeObj m_ColorStripe;
    private Point2D m_GradientCenter;
    private double m_pos1;
    private double m_pos2;
    private double m_pos3;
    private Color m_leftColor1;
    private Color m_rightColor1;
    private Color m_leftColor2;
    private Color m_rightColor2;
    private Color m_leftColor3;
    private Color m_rightColor3;
    private int m_numPins;

    private void $init$() {
        this.m_pos1 = -1.0;
        this.m_pos2 = -1.0;
        this.m_pos3 = -1.0;
        this.m_numPins = 0;
    }

    public GradientObj() {
        this.$init$();
        this.m_ColorStripe = new ColorPinStripeObj();
        this.m_nDirection = 9;
    }

    public void fillSfxRect(Graphics g, int x, int y, int width, int height, Shape shape, Rectangle r) {
        switch (this.m_nDirection) {
            case 9: {
                this.radialGradient(g, x, y, width, height, shape, r);
                break;
            }
            case 14: {
                this.offCenterRadialGradient(g, x, y, width, height);
                break;
            }
        }
    }

    public void insertPin(double fPosition, ColorObj leftColor, ColorObj rightColor) {
        this.m_ColorStripe.insertPin(fPosition, leftColor, rightColor);
        if (this.m_pos1 == -1.0) {
            this.m_pos1 = fPosition;
            this.m_leftColor1 = leftColor.getColor();
            this.m_rightColor1 = rightColor.getColor();
        } else if (this.m_pos2 == -1.0) {
            this.m_pos2 = fPosition;
            this.m_leftColor2 = leftColor.getColor();
            this.m_rightColor2 = rightColor.getColor();
        } else if (this.m_pos3 == -1.0) {
            this.m_pos3 = fPosition;
            this.m_leftColor3 = leftColor.getColor();
            this.m_rightColor3 = rightColor.getColor();
        }
        ++this.m_numPins;
    }

    private void radialGradient(Graphics g, int x, int y, int width, int height, Shape shape, Rectangle r) {
        int nMaxExtent;
        int xp = -width / 4 + x;
        int yp = -height / 4 + y;
        int wp = width + width / 2;
        int hp = height + height / 2;
        if (shape != null && r != null) {
            Rectangle rect = shape.getBounds();
            xp = -((int)(rect.getX() - r.getX())) - 2;
            yp = -((int)(rect.getY() - r.getY())) - 2;
            wp = (int)r.getWidth() + 4;
            hp = (int)r.getHeight() + 4;
        } else if (shape != null && shape instanceof Arc2D) {
            Rectangle rect = shape.getBounds();
            Rectangle inner = shape.getBounds2D().getBounds();
            xp = -((int)(inner.getX() - rect.getX())) - 2;
            yp = -((int)(inner.getY() - rect.getY())) - 2;
            wp = (int)rect.getWidth() + 4;
            hp = (int)rect.getHeight() + 4;
        }
        int nExtent = nMaxExtent = Math.max(wp, hp) / 2;
        while (nExtent >= 0) {
            ColorObj color = new ColorObj();
            double fCoef = (double)nExtent / (double)nMaxExtent;
            this.m_ColorStripe.getColorAt(fCoef, color);
            g.setColor(color.getColor());
            g.fillOval((int)((double)(xp + wp / 2) - fCoef * (double)wp / 2.0), (int)((double)(yp + hp / 2) - fCoef * (double)hp / 2.0), (int)(2.0 * (fCoef * (double)wp / 2.0)), (int)(2.0 * (fCoef * (double)hp / 2.0)));
            --nExtent;
        }
    }

    private void offCenterRadialGradient(Graphics g, int x, int y, int width, int height) {
        int nMaxExtent;
        if (this.m_GradientCenter == null) {
            this.m_GradientCenter = new Point2D.Double(x + width / 2, y + height / 2);
        }
        int diam = width;
        int distX = (int)Math.abs((double)(diam / 2) - this.m_GradientCenter.getX());
        int distY = (int)Math.abs((double)(diam / 2) - this.m_GradientCenter.getY());
        double wp = Math.sqrt(2.0) * (double)(diam + distX * 2);
        double hp = Math.sqrt(2.0) * (double)(diam + distY * 2);
        int xp = (int)(this.m_GradientCenter.getX() - wp / 2.0);
        int yp = (int)(this.m_GradientCenter.getY() - hp / 2.0);
        int nExtent = nMaxExtent = (int)Math.max(wp, hp) / 2;
        while (nExtent >= 0) {
            ColorObj color = new ColorObj();
            double fCoef = (double)nExtent / (double)nMaxExtent;
            double fColorPos = fCoef < 0.5 ? fCoef * 2.0 : 1.0;
            this.m_ColorStripe.getColorAt(fColorPos, color);
            g.setColor(color.getColor());
            g.fillOval((int)((double)xp + wp / 2.0 - fCoef * wp / 2.0), (int)((double)yp + hp / 2.0 - fCoef * hp / 2.0), (int)(2.0 * (fCoef * wp / 2.0)), (int)(2.0 * (fCoef * hp / 2.0)));
            --nExtent;
        }
    }

    public void setDirection(int nDirection) {
        this.m_nDirection = nDirection;
    }

    public int getDirection() {
        return this.m_nDirection;
    }

    public List getPins() {
        return this.m_ColorStripe.getPins();
    }

    public Color getColorAt(double fValue) {
        ColorObj color = new ColorObj();
        this.m_ColorStripe.getColorAt(fValue, color);
        return color.getColor();
    }

    public void fillPolygon(Graphics g, Shape shape, Rectangle rect) {
        Rectangle r = shape.getBounds2D().getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        BufferedImage img = new BufferedImage(r.width, r.height, 2);
        Graphics2D gos = (Graphics2D)((Image)img).getGraphics();
        gos.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fillSfxRect(gos, 0, 0, r.width, r.height, shape, rect);
        gos.dispose();
        if (shape instanceof Arc2D) {
            this.applyFilter(g, img, this.createArc2DMask(shape), r, r);
        } else if (shape instanceof Area) {
            this.applyFilter(g, img, this.createAreaMask((Area)shape), r, r);
        }
        img.flush();
    }

    protected Image createAreaMask(Area area) {
        Rectangle r = area.getBounds();
        BufferedImage img = new BufferedImage(r.width, r.height, 2);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gos.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        gos.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        area = area.createTransformedArea(transform);
        gos.fill(area);
        gos.dispose();
        return img;
    }

    protected Image createArc2DMask(Shape shape2D) {
        Rectangle r = shape2D.getBounds2D().getBounds();
        BufferedImage img = new BufferedImage(r.width, r.height, 2);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gos.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        gos.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        Shape shape = transform.createTransformedShape(shape2D);
        gos.fill(shape);
        gos.dispose();
        return img;
    }

    protected void applyFilter(Graphics g, Image img, Image imgMask, Rectangle rFill, Rectangle rBounds) {
        int[] pixels = this.extractPixels(img, rFill);
        int[] pixelsMask = this.extractPixels(imgMask, rFill);
        int y = 0;
        while (y < rFill.height) {
            int x = 0;
            while (x < rFill.width) {
                if ((pixelsMask[y * rFill.width + x] & 0xFFFFFF) == 0) {
                    pixels[y * rFill.width + x] = pixels[y * rFill.width + x] & 0xFFFFFF;
                }
                ++x;
            }
            ++y;
        }
        imgMask.flush();
        Image dest = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(rFill.width, rFill.height, pixels, 0, rFill.width));
        Point pt = new Point(rBounds.x, rBounds.y);
        g.drawImage(dest, pt.x, pt.y, null);
        dest.flush();
    }

    protected int[] extractPixels(Image img, Rectangle r) {
        int[] pixels = new int[r.width * r.height];
        this.waitForImage(img);
        PixelGrabber pg = new PixelGrabber(img, 0, 0, r.width, r.height, pixels, 0, r.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.out.println("interrupted waiting for pixels!");
            int[] nArray = null;
            return nArray;
        }
        catch (Throwable e) {
            int[] nArray = null;
            return nArray;
        }
        if ((pg.status() & 0x80) != 0) {
            System.out.println("image fetch aborted or errored");
            return null;
        }
        return pixels;
    }

    protected boolean waitForImage(Image image) {
        boolean loaded = ImageLoader.loadImage(image);
        return true;
    }

    public void setGradientCenter(Point2D gradientCenter) {
        this.m_GradientCenter = gradientCenter;
    }

    public Point2D getGradientCenter() {
        return this.m_GradientCenter;
    }
}

