/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.gauge.GradientObj;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.util.ErrorHandler;

public class Graphics2DRenderer
implements GaugeRenderer {
    private Graphics2D m_graphics;
    private ErrorHandler m_errorHandler;
    boolean m_circular;

    public Graphics2DRenderer(Graphics2D g, ErrorHandler eh) {
        this.$init$();
        this.m_graphics = g;
        this.m_errorHandler = eh;
    }

    public void drawShape(Shape shape, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(shape);
        }
    }

    public void fillShape(Shape shape, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, shape, null);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        if (!this.m_circular) {
            this.m_graphics.fill(shape);
        }
        this.m_circular = false;
    }

    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillShape(shape, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawShape(shape, borderColor);
        }
    }

    public void drawArc(Arc2D arc, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(arc);
        }
    }

    public void fillArc(Arc2D arc, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, arc, null);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        if (!this.m_circular) {
            this.m_graphics.fill(arc);
        }
        this.m_circular = false;
    }

    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillArc(arc, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawArc(arc, borderColor);
        }
    }

    public void drawArea(Area area, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(area);
        }
    }

    public void fillArea(Area area, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, area, null);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        if (!this.m_circular) {
            this.m_graphics.fill(area);
        }
        this.m_circular = false;
    }

    public void fillArea(Area area, Rectangle outer, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, area, outer);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        if (!this.m_circular) {
            this.m_graphics.fill(area);
        }
        this.m_circular = false;
    }

    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, HashMap sfxMap) {
        this.drawAndFillArea(area, null, borderColor, fillColor, sfxMap);
    }

    public void drawAndFillArea(Area area, Rectangle outer, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillArea(area, outer, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawArea(area, borderColor);
        }
    }

    public void drawPolygon(Polygon poly, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.draw(poly);
        }
    }

    public void fillPolygon(Polygon poly, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, poly, null);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fill(poly);
    }

    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillPolygon(polygon, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawPolygon(polygon, borderColor);
        }
    }

    public void drawRect(Rectangle rect, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void fillRect(Rectangle rect, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, rect, null);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        if (!this.m_circular) {
            this.m_graphics.fill(rect);
        }
        this.m_circular = false;
    }

    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillRect(rect, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawRect(rect, borderColor);
        }
    }

    public void drawRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
            this.m_graphics.drawRoundRect(rect.x, rect.y, rect.width, rect.height, arcWidth, arcHeight);
        }
    }

    public void fillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color c, HashMap sfxMap) {
        boolean handled = this.handleSFX(sfxMap, rect, null);
        if (!handled && c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.fillRoundRect(rect.x, rect.y, rect.width, rect.height, arcWidth, arcHeight);
    }

    public void drawAndFillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillRoundedRect(rect, arcWidth, arcHeight, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawRoundedRect(rect, arcWidth, arcHeight, borderColor);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        Stroke oldStroke = this.m_graphics.getStroke();
        BasicStroke stroke = new BasicStroke(thickness, 0, 0);
        this.m_graphics.setStroke(stroke);
        if (c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.drawLine(x1, y1, x2, y2);
        this.m_graphics.setStroke(oldStroke);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        if (c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawString(String label, int x, int y, Font f, Color c, double angle) {
        if (c != null) {
            this.m_graphics.setPaint(c);
        }
        this.m_graphics.setFont(f);
        AffineTransform saveAT = null;
        if (angle != 0.0) {
            this.m_graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            double rx = x + this.m_graphics.getFontMetrics(f).stringWidth(label) / 2;
            double ry = y - this.m_graphics.getFontMetrics(f).getHeight() / 2;
            AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(angle), rx, ry);
            saveAT = this.m_graphics.getTransform();
            this.m_graphics.transform(rotate);
        }
        this.m_graphics.drawString(label, x, y);
        if (saveAT != null) {
            this.m_graphics.setTransform(saveAT);
        }
    }

    public void drawImage(String strURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        try {
            boolean imgLoaded = false;
            if (image == null) {
                URL url = new URL(strURL);
                image = Toolkit.getDefaultToolkit().getImage(url);
                imgLoaded = true;
            }
            this.m_graphics.drawImage(image, x, y, width, height, imgObs);
            if (imgLoaded) {
                image.flush();
            }
        }
        catch (MalformedURLException murle) {
            this.m_errorHandler.error((Throwable)murle, this.getClass().getName(), "public void drawImage(String imgURL, int x, int y, int width, int height, ImageObserver imgObs)");
        }
    }

    public void applyTransform(AffineTransform transform) {
        this.m_graphics.transform(transform);
    }

    public AffineTransform getTransform() {
        return this.m_graphics.getTransform();
    }

    public void setTransform(AffineTransform transform) {
        this.m_graphics.setTransform(transform);
    }

    private boolean handleSFX(HashMap sfxMap, Shape shape, Rectangle rect) {
        ArrayList<GradientPaint> objects = new ArrayList<GradientPaint>();
        if (sfxMap == null || sfxMap.get("SFX_FILL_TYPE") == null) {
            return false;
        }
        int fillType = (Integer)sfxMap.get("SFX_FILL_TYPE");
        if (fillType != 2) {
            return false;
        }
        Rectangle2D bounds = shape.getBounds2D();
        int gradDir = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
        float minX = (float)bounds.getX();
        float minY = (float)bounds.getY();
        float maxX = minX + (float)bounds.getWidth();
        float maxY = minY + (float)bounds.getHeight();
        if (gradDir == 1) {
            float midY = (float)(bounds.getMinY() + bounds.getHeight() / 2.0);
            minX = (float)bounds.getMinX();
            maxX = (float)bounds.getMaxX();
            maxY = minY = midY;
        } else if (gradDir == 3) {
            float midX;
            maxX = minX = (midX = (float)(bounds.getMinX() + bounds.getWidth() / 2.0));
            minY = (float)bounds.getMinY();
            maxY = (float)bounds.getMaxY();
        } else if (gradDir == 5) {
            minX = (float)bounds.getMaxX();
            minY = (float)bounds.getMinY();
            maxX = (float)bounds.getMinX();
            maxY = (float)bounds.getMaxY();
        } else if (gradDir == 7) {
            minX = (float)bounds.getMinX();
            minY = (float)bounds.getMinY();
            maxX = (float)bounds.getMaxX();
            maxY = (float)bounds.getMaxY();
        } else {
            if (gradDir == 9) {
                minX = (float)bounds.getCenterX();
                minY = (float)bounds.getCenterY();
                if (shape instanceof Ellipse2D || shape instanceof Rectangle) {
                    shape = new Area(shape);
                }
                if (shape instanceof Arc2D || shape instanceof Area) {
                    this.handleCircularGradients(sfxMap, shape, rect);
                    return true;
                }
                return false;
            }
            if (gradDir == 14) {
                if (!(shape instanceof Area)) {
                    shape = new Area(shape);
                }
                this.handleCircularGradients(sfxMap, shape, rect);
                return true;
            }
            if (gradDir == 20) {
                Point2D start = (Point2D)sfxMap.get("SFX_START_POINT");
                Point2D end = (Point2D)sfxMap.get("SFX_END_POINT");
                minX = (float)(bounds.getX() + bounds.getWidth() * start.getX() / 100.0);
                minY = (float)(bounds.getY() + bounds.getHeight() * start.getY() / 100.0);
                maxX = (float)(bounds.getX() + bounds.getWidth() * end.getX() / 100.0);
                maxY = (float)(bounds.getY() + bounds.getHeight() * end.getY() / 100.0);
            } else {
                if (gradDir == 21) {
                    Point2D center = (Point2D)sfxMap.get("SFX_GRADIENT_CENTER");
                    double cx = bounds.getWidth() * center.getX() / 100.0;
                    double cy = bounds.getHeight() * center.getY() / 100.0;
                    sfxMap.put("SFX_GRADIENT_CENTER", new Point2D.Double(cx, cy));
                    sfxMap.put("SFX_GRADIENT_DIRECTION", 14);
                    if (!(shape instanceof Area)) {
                        shape = new Area(shape);
                    }
                    this.handleCircularGradients(sfxMap, shape, rect);
                    return true;
                }
                return false;
            }
        }
        Point2D.Float pt2 = null;
        Color clr1 = null;
        Color clr2 = null;
        boolean dirRev = (Boolean)sfxMap.get("SFX_GRADIENT_REVERSED");
        int numStops = (Integer)sfxMap.get("SFX_NUM_STOPS");
        ArrayList stops = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
        ArrayList colors = (ArrayList)sfxMap.get("SFX_STOP_COLORS");
        int stop = 0;
        while (stop < numStops - 1 && stop < stops.size()) {
            Point2D.Float pt1;
            if (stop + 1 < numStops) {
                float pos2;
                float pos1 = ((Double)stops.get(stop)).floatValue();
                if (pos1 == (pos2 = ((Double)stops.get(stop + 1)).floatValue())) {
                    pos1 -= 5.0E-4f;
                    pos2 += 5.0E-4f;
                }
                pt1 = new Point2D.Float(minX + (maxX - minX) * pos1, minY + (maxY - minY) * pos1);
                pt2 = new Point2D.Float(minX + (maxX - minX) * pos2, minY + (maxY - minY) * pos2);
            } else {
                pt2 = pt1 = new Point2D.Float(minX, minY);
            }
            if (dirRev) {
                clr1 = (Color)colors.get(numStops - 1 - stop);
                clr2 = (Color)colors.get(numStops - 2 - stop);
            } else {
                clr1 = (Color)colors.get(stop);
                clr2 = (Color)colors.get(stop + 1);
            }
            GradientPaint fillGrad = new GradientPaint(pt1, clr1, pt2, clr2);
            objects.add(fillGrad);
            ++stop;
        }
        if (!objects.isEmpty()) {
            this.m_graphics.setPaint((GradientPaint)objects.get(objects.size() - 1));
            return true;
        }
        return false;
    }

    private void handleCircularGradients(HashMap sfxMap, Shape shape, Rectangle rect) {
        this.m_circular = true;
        int numStops = (Integer)sfxMap.get("SFX_NUM_STOPS");
        GradientObj obj = new GradientObj();
        int gradDir = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
        obj.setDirection(gradDir);
        obj.setGradientCenter((Point2D)sfxMap.get("SFX_GRADIENT_CENTER"));
        ArrayList stops = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
        ArrayList colors = (ArrayList)sfxMap.get("SFX_STOP_COLORS");
        Color clr1 = null;
        Color startClr = null;
        int stop = 0;
        while (stop < numStops && stop < stops.size()) {
            if (stop < numStops) {
                float pos1 = ((Double)stops.get(stop)).floatValue();
                clr1 = (Color)colors.get(stop);
                if (stop == 0) {
                    startClr = clr1;
                }
                obj.insertPin(pos1, new ColorObj(clr1), new ColorObj(clr1));
            }
            ++stop;
        }
        obj.insertPin(0.0, new ColorObj(startClr), new ColorObj(startClr));
        obj.insertPin(1.0, new ColorObj(clr1), new ColorObj(clr1));
        obj.fillPolygon(this.m_graphics, shape, rect);
    }

    private void $init$() {
        this.m_circular = false;
    }
}

