/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import oracle.dss.gauge.BaseGaugeComponent;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.SFX;

public class Indicator
extends BaseGaugeComponent {
    protected static final String it_line = "IT_LINE";
    protected static final String it_fill = "IT_FILL";
    protected static final String it_needle = "IT_NEEDLE";
    protected SFX m_sfx;
    protected SFX m_base_sfx;
    protected SFX m_bar_sfx;

    public Indicator(CommonGauge gauge) {
        super(gauge, 14);
        this.$init$();
    }

    public Color getFillColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorFillColor");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorFillColor();
        }
        return (Color)obj;
    }

    public void setFillColor(Color color) {
        this.m_commonGauge.setAttribute("IndicatorFillColor", color);
    }

    public Color getBorderColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorBorderColor");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorBorderColor();
        }
        return (Color)obj;
    }

    public void setBorderColor(Color color) {
        this.m_commonGauge.setAttribute("IndicatorBorderColor", color);
    }

    public int getType() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorType");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorType();
        }
        return (Integer)this.m_commonGauge.getAttribute("IndicatorType");
    }

    public void setType(int type) {
        if (type < 0 || type > 2) {
            this.m_commonGauge.getErrorHandler().log("invalid type", this.getClass().getName(), "setIndicatorType");
            return;
        }
        this.m_commonGauge.setAttribute("IndicatorType", new Integer(type));
    }

    public boolean isUseThresholdFillColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorUseThresholdFillColor");
        if (obj == null) {
            return GaugeDefaultValues.isIndicatorUseThresholdFillColor();
        }
        return (Boolean)this.m_commonGauge.getAttribute("IndicatorUseThresholdFillColor");
    }

    public void setUseThresholdFillColor(boolean use) {
        this.m_commonGauge.setAttribute("IndicatorUseThresholdFillColor", use);
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGauge, 14);
        }
        return this.m_sfx;
    }

    public Color getBarFillColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorBarFillColor");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorBarFillColor();
        }
        return (Color)obj;
    }

    public void setBarFillColor(Color color) {
        this.m_commonGauge.setAttribute("IndicatorBarFillColor", color);
    }

    public Color getBarBorderColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorBarBorderColor");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorBarBorderColor();
        }
        return (Color)obj;
    }

    public void setBarBorderColor(Color color) {
        this.m_commonGauge.setAttribute("IndicatorBarBorderColor", color);
    }

    public Color getBaseFillColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorBaseFillColor");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorBaseFillColor();
        }
        return (Color)obj;
    }

    public void setBaseFillColor(Color color) {
        this.m_commonGauge.setAttribute("IndicatorBaseFillColor", color);
    }

    public Color getBaseBorderColor() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorBaseBorderColor");
        if (obj == null) {
            return GaugeDefaultValues.getIndicatorBaseBorderColor();
        }
        return (Color)obj;
    }

    public void setBaseBorderColor(Color color) {
        this.m_commonGauge.setAttribute("IndicatorBaseBorderColor", color);
    }

    public boolean isBaseVisible() {
        Object obj = this.m_commonGauge.getAttribute("IndicatorBaseVisible");
        if (obj == null) {
            return GaugeDefaultValues.isIndicatorBaseVisible();
        }
        return (Boolean)obj;
    }

    public void setBaseVisible(boolean visible) {
        this.m_commonGauge.setAttribute("IndicatorBaseVisible", visible);
    }

    public static int convertTypeToInt(String type) {
        int iType = 0;
        if (type.equals(it_fill)) {
            iType = 1;
        } else if (type.equals(it_needle)) {
            iType = 2;
        }
        return iType;
    }

    public static String convertTypeToString(int type) {
        String iType = it_line;
        if (type == 1) {
            iType = it_fill;
        } else if (type == 2) {
            iType = it_needle;
        }
        return iType;
    }

    public SFX getBaseSFX() {
        if (this.m_base_sfx == null) {
            this.m_base_sfx = new SFX(this.m_commonGauge, 30);
        }
        return this.m_base_sfx;
    }

    public SFX getBarSFX() {
        if (this.m_bar_sfx == null) {
            this.m_bar_sfx = new SFX(this.m_commonGauge, 31);
        }
        return this.m_bar_sfx;
    }

    private void $init$() {
        this.m_sfx = null;
        this.m_base_sfx = null;
        this.m_bar_sfx = null;
    }
}

