/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.Gauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;
import oracle.dss.gauge.KPIStyleCallback;
import oracle.dss.gauge.LEDStyleCallback;

public class LEDGauge
extends GaugeType {
    private static HashMap _ledImgs = null;
    private static final double HEIGHT_FULL_LED_GAUGE = 0.75;

    public LEDGauge(GaugeEngine engine) {
        super(engine);
    }

    public int getGaugeType() {
        return 2;
    }

    protected Collection getPlotAreaObject(Map map, int type) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getIndicatorObject(Map map) {
        ArrayList<Object> objects = new ArrayList<Object>(15);
        if (this._engine.isNullMetric()) {
            DrawableObject noDataObj = this.getNoDataLabelObject(map);
            if (noDataObj != null) {
                objects.add(noDataObj);
            }
            return objects;
        }
        Integer styleObj = (Integer)map.get("LEDStyle");
        int style = styleObj != null ? styleObj : GaugeDefaultValues.getLEDStyle();
        LEDStyleCallback styleCallback = (LEDStyleCallback)map.get("LEDStyleCallback");
        if (styleCallback == null) {
            if (style == 1) {
                styleCallback = new KPIStyleCallback();
            } else if (style == 4) {
                this._engine.getErrorHandler().error((Throwable)new NullPointerException("No LED style handler specified"), this.getClass().getName(), "public Collection getIndicatorObject(Map map)");
                return objects;
            }
        }
        double metric = this._engine.getMetric();
        double[] tValues = null;
        int imgIndex = -1;
        int thresholdCount = 1;
        if (map.get("ThresholdValues") != null) {
            tValues = (double[])map.get("ThresholdValues");
            thresholdCount = tValues.length;
            if (styleCallback != null) {
                styleCallback.setLEDCount(thresholdCount + 1);
            }
            int i = 0;
            while (i < tValues.length) {
                if (metric <= tValues[i]) {
                    imgIndex = i;
                    break;
                }
                ++i;
            }
            if (imgIndex == -1) {
                imgIndex = thresholdCount;
            }
        }
        ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
        HashMap tMap = null;
        Color indColor = null;
        HashMap sfxMap = null;
        if (tList != null && imgIndex < tList.size() && imgIndex != -1) {
            tMap = (HashMap)tList.get(imgIndex);
            sfxMap = (HashMap)LEDGauge.getThresholdAttribute(tMap, imgIndex, "ThresholdSFX");
        }
        if (imgIndex > -1) {
            indColor = (Color)LEDGauge.getThresholdAttribute(tMap, imgIndex, "ThresholdFillColor");
        }
        if (indColor == null) {
            Color[] defClrs = GaugeDefaultValues.getThresholdColors();
            if (imgIndex < defClrs.length && imgIndex != -1) {
                indColor = defClrs[imgIndex];
            } else {
                indColor = GaugeDefaultValues.getIndicatorFillColor();
                sfxMap = GaugeDefaultValues.getLEDIndicatorSFX();
            }
        }
        if (this._csParser != null && (this._csParser.defines("plotArea") || this._csParser.defines("ledFillArea"))) {
            Rectangle2D bounds = this._csParser.getBounds("plotArea");
            if (this._csParser.getBounds("ledFillArea") != null) {
                bounds = bounds != null ? bounds.createUnion(this._csParser.getBounds("ledFillArea")) : this._csParser.getBounds("ledFillArea");
            }
            AffineTransform scale = LEDGauge.getScalingTransform(bounds, this._innerBounds);
            AffineTransform move = LEDGauge.getTranslateTransform(bounds, this._innerBounds, scale);
            Color userBorderColor = (Color)map.get("PlotAreaBorderColor");
            Color userFillColor = (Color)map.get("PlotAreaFillColor");
            HashMap userSFXMap = (HashMap)map.get("PlotAreaSFX");
            List<CustomShape> plotAreaShapes = this._csParser.getShapes("plotArea");
            List<CustomShape> fillAreaShapes = this._csParser.getShapes("ledFillArea");
            int i = 0;
            int j = 0;
            while (i < plotAreaShapes.size() || j < fillAreaShapes.size()) {
                Color fillColor;
                int compid;
                Shape s;
                CustomShape plotArea = null;
                CustomShape fillArea = null;
                if (i < plotAreaShapes.size()) {
                    plotArea = plotAreaShapes.get(i);
                }
                if (j < fillAreaShapes.size()) {
                    fillArea = fillAreaShapes.get(j);
                }
                Color borderColor = null;
                HashMap sfx = null;
                if (fillArea == null || plotArea != null && plotArea.getZOrder() < fillArea.getZOrder()) {
                    s = plotArea.getShape();
                    compid = 11;
                    borderColor = userBorderColor != null ? userBorderColor : plotArea.getBorderColor();
                    fillColor = userFillColor != null ? userFillColor : plotArea.getFillColor();
                    sfx = userSFXMap != null ? userSFXMap : plotArea.getSFXMap();
                    ++i;
                } else {
                    s = fillArea.getShape();
                    compid = 14;
                    fillColor = indColor;
                    sfx = sfxMap;
                    ++j;
                }
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                objects.add(new DrawableObject.Shape(compid, s, borderColor, fillColor, sfx, null));
            }
        } else if (style == 0 || style == 5 || style == 2 || style == 3 || style == 6) {
            if (style == 0) {
                Integer fillType;
                int dotDiam = this._innerBounds.width > this._innerBounds.height ? this._innerBounds.height : this._innerBounds.width;
                Point2D.Double dotCtr = new Point2D.Double(this._innerBounds.x + this._innerBounds.width / 2, this._innerBounds.y + this._innerBounds.height / 2);
                Rectangle2D.Double dotBounds = new Rectangle2D.Double();
                dotBounds.setRect(((Point2D)dotCtr).getX() - (double)(dotDiam / 2), ((Point2D)dotCtr).getY() - (double)(dotDiam / 2), dotDiam, dotDiam);
                Ellipse2D.Double dot = new Ellipse2D.Double();
                dot.setFrame(dotBounds);
                objects.add(new DrawableObject.Shape(14, dot, null, indColor, sfxMap, null));
                Integer sh = (Integer)map.get("SpecularHighlight");
                if (sh == null || sh == 0) {
                    objects.add(this._getFocusSpotObject(dotCtr, dotDiam));
                }
                if (sfxMap != null && (fillType = (Integer)sfxMap.get("SFX_FILL_TYPE")) != null && fillType == 2) {
                    Point2D.Double gradientCtr = null;
                    Integer gradientDir = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
                    if (gradientDir != null) {
                        double dist = (double)(dotDiam / 2) * 0.4 / Math.sqrt(2.0);
                        if (gradientDir == 14) {
                            gradientCtr = new Point2D.Double((double)(dotDiam / 2) - dist, (double)(dotDiam / 2) - dist);
                            sfxMap.put("SFX_GRADIENT_CENTER", gradientCtr);
                        }
                    }
                }
            } else if (style == 5) {
                RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double();
                roundRect.setRoundRect(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._innerBounds.height, this._innerBounds.getHeight() / 2.0, this._innerBounds.getHeight() / 2.0);
                objects.add(new DrawableObject.Shape(14, roundRect, null, indColor, sfxMap, null));
                Color color = new Color(1.0f, 1.0f, 1.0f, 0.01f);
                objects.add(new DrawableObject.Shape(14, map, roundRect, null, color, null, null));
            } else {
                GeneralPath path = new GeneralPath();
                double rotation = Math.PI;
                if (imgIndex == 1) {
                    rotation = 1.5707963267948966;
                } else if (imgIndex == 2) {
                    rotation = 0.0;
                }
                if (style == 2) {
                    path.moveTo(0.0f, 60.0f);
                    path.lineTo(30.0f, 60.0f);
                    path.lineTo(30.0f, 100.0f);
                    path.lineTo(80.0f, 100.0f);
                    path.lineTo(80.0f, 60.0f);
                    path.lineTo(110.0f, 60.0f);
                    path.lineTo(55.0f, 0.0f);
                    path.closePath();
                } else if (style == 3) {
                    path.moveTo(0.0f, (float)Math.sqrt(3.0));
                    path.lineTo(1.0f, 0.0f);
                    path.lineTo(2.0f, (float)Math.sqrt(3.0));
                    path.closePath();
                } else {
                    path.moveTo(0.0f, 0.0f);
                    path.lineTo(0.0f, 1.0f);
                    path.lineTo(1.0f, 1.0f);
                    path.lineTo(1.0f, 0.0f);
                    path.closePath();
                }
                AffineTransform rotate = AffineTransform.getRotateInstance(rotation);
                Shape xformPoly = rotate.createTransformedShape(path);
                AffineTransform scale = LEDGauge.getScalingTransform(xformPoly, this._innerBounds);
                AffineTransform move = LEDGauge.getTranslateTransform(xformPoly, this._innerBounds, scale);
                xformPoly = scale.createTransformedShape(xformPoly);
                xformPoly = move.createTransformedShape(xformPoly);
                objects.add(new DrawableObject.Shape(14, xformPoly, null, indColor, sfxMap, null));
            }
        } else if (style == 1 || style == 4) {
            Image img;
            if (imgIndex == -1) {
                this._engine.getErrorHandler().error((Throwable)new NullPointerException("Threshold values are required for KPI or custom LED gauges."), this.getClass().getName(), "public Collection getIndicatorObject(Map map)");
                imgIndex = 0;
            }
            if ((img = styleCallback.getLEDImage(imgIndex)) == null) {
                img = ImageUtils.getNotLoadedImage();
            }
            ImageUtils.loadImage((Image)img);
            Dimension imgSize = new Dimension(img.getWidth(null), img.getHeight(null));
            Rectangle2D.Double rect2d = new Rectangle2D.Double((double)this._innerBounds.x + (double)(this._innerBounds.width / 2) - imgSize.getWidth() / 2.0, (double)this._innerBounds.y + (double)(this._innerBounds.height / 2) - imgSize.getHeight() / 2.0, imgSize.getWidth(), imgSize.getHeight());
            objects.add(new DrawableObject.Image(14, styleCallback.getLEDImagePath(imgIndex), img, rect2d, 1.0, null, null));
            Color color = new Color(1.0f, 1.0f, 1.0f, 0.01f);
            objects.add(new DrawableObject.Shape(14, map, rect2d, null, color, null, null));
        }
        return objects;
    }

    protected Collection getTickLabelObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getTickMarkObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("No data");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int drawWidth = this._innerBounds.width - 10;
        if (dim.width > drawWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - 3 - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    protected Collection getGaugeFrameObject(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected int getGaugeRadius(int availWidth, int availHeight) {
        return Math.min(availHeight, availWidth);
    }

    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        LEDStyleCallback styleCallback = (LEDStyleCallback)this._engine.getAttribute("LEDStyleCallback");
        if (styleCallback == null) {
            styleCallback = new KPIStyleCallback();
        }
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace;
        bounds.width = availWidth;
        bounds.height = availHeight;
        if (bounds.width < 5 || bounds.height < 5) {
            this._engine.getErrorHandler().log("Width allocated for gauge is too small.", this.getClass().getName(), "getInnerBounds");
            bounds.width = 5;
            bounds.x = rect.x + (rect.width - bounds.width) / 2;
            bounds.height = 5;
            bounds.y = rect.y + (rect.height - bounds.height) / 2;
        }
        return bounds;
    }

    protected int getMaxNumberOfSteps() {
        return 0;
    }

    protected int getGaugeSetGap(Map map, Graphics2D g, int dir) {
        boolean bMetLbl;
        int topLblPos = GaugeDefaultValues.getTopLabelPosition();
        if (map.get("TopLabelPosition") != null) {
            topLblPos = (Integer)map.get("TopLabelPosition");
        }
        int metLblPos = GaugeDefaultValues.getMetricLabelPosition();
        if (map.get("MetricLabelPosition") != null) {
            metLblPos = (Integer)map.get("MetricLabelPosition");
        }
        int btmLblPos = GaugeDefaultValues.getBottomLabelPosition();
        if (map.get("BottomLabelPosition") != null) {
            btmLblPos = (Integer)map.get("BottomLabelPosition");
        }
        String topLabel = (String)map.get("TopLabel");
        String btmLabel = (String)map.get("BottomLabel");
        String metLabel = this._engine.formatValue(this._engine.getMetric(), "MetricLabelViewFormat");
        boolean bTopLbl = topLabel != null && topLblPos == 3;
        boolean bBtmLbl = btmLabel != null && btmLblPos == 1;
        boolean bHasMetWithBtmLbl = btmLblPos == 1 && metLblPos == 2;
        boolean bl = bMetLbl = metLabel != null && (metLblPos == 1 || bHasMetWithBtmLbl);
        if (!(bTopLbl || bBtmLbl || bMetLbl)) {
            return 2;
        }
        return super.getGaugeSetGap(map, g, dir);
    }

    protected static Image loadImage(String strURL) {
        if (_ledImgs != null && _ledImgs.containsKey(strURL)) {
            return (Image)_ledImgs.get(strURL);
        }
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().getImage(strURL);
        }
        catch (Exception e) {
            image = ImageUtils.getImageResource(Gauge.class, (String)strURL);
        }
        if (image == null) {
            return null;
        }
        if (!ImageUtils.loadImage((Image)image)) {
            image = ImageUtils.getNotLoadedImage();
            ImageUtils.loadImage((Image)image);
        }
        if (_ledImgs == null) {
            _ledImgs = new HashMap(GaugeDefaultValues.getThresholdCount());
        }
        _ledImgs.put(strURL, image);
        return image;
    }

    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int availHeight = gaugeFrameBounds.height;
        String topLabel = (String)map.get("TopLabel");
        int topLblPos = GaugeDefaultValues.getTopLabelPosition();
        if (map.get("TopLabelPosition") != null) {
            topLblPos = (Integer)map.get("TopLabelPosition");
        }
        int btmLblPos = GaugeDefaultValues.getBottomLabelPosition();
        if (map.get("BottomLabelPosition") != null) {
            btmLblPos = (Integer)map.get("BottomLabelPosition");
        }
        int metLblPos = GaugeDefaultValues.getMetricLabelPosition();
        if (map.get("MetricLabelPosition") != null) {
            metLblPos = (Integer)map.get("MetricLabelPosition");
        }
        boolean showLowLbl = GaugeDefaultValues.isLowerLabelFrameVisible();
        if (map.get("LowLblFrameVisible") != null) {
            showLowLbl = (Boolean)map.get("LowLblFrameVisible");
        }
        int customLayout = GaugeDefaultValues.getCustomLayout();
        if (map.get("CustomLayout") != null) {
            customLayout = (Integer)map.get("CustomLayout");
        }
        boolean bTitleSeparator = (customLayout & 1) != 0 && topLblPos == 3;
        boolean bFullGauge = topLabel != null && bTitleSeparator && showLowLbl && (btmLblPos == 1 || metLblPos == 1);
        int ledHeight = availHeight;
        if (bFullGauge) {
            ledHeight = (int)(0.75 * (double)availHeight);
        }
        int reqAboveSpace = (availHeight - ledHeight) / 2;
        int reqBelowSpace = (availHeight - ledHeight) / 2;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        Rectangle bounds = this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
        if (this._csParser == null || !this._csParser.defines("gaugeFrame")) {
            this._gaugeFrameBounds = new Rectangle(bounds.x - reqLeftSpace, bounds.y - reqAboveSpace, bounds.width + reqLeftSpace + reqRightSpace, bounds.height + reqAboveSpace + reqBelowSpace);
        }
        return bounds;
    }

    private Collection _getFocusSpotObject(Point2D dotCtr, double dotDiam) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(2);
        double focusRadius = dotDiam * 0.15;
        int MIN_ALPHA = 20;
        Rectangle2D.Double baseRect = new Rectangle2D.Double();
        ((Rectangle2D)baseRect).setRect(dotCtr.getX() - focusRadius * 2.0, dotCtr.getY() - focusRadius * 2.0, focusRadius * 2.0, focusRadius * 2.0);
        double rectWidth = ((RectangularShape)baseRect).getWidth();
        int locOffset = 0;
        int i = 0;
        while (rectWidth > 2.0) {
            Rectangle2D tempRect = (Rectangle2D)baseRect.clone();
            if (i % 2 > 0) {
                ++locOffset;
            }
            if (i != 0) {
                tempRect.setRect(((RectangularShape)baseRect).getX() + (double)locOffset, ((RectangularShape)baseRect).getY() + (double)locOffset, ((RectangularShape)baseRect).getWidth() + (double)locOffset - (double)(i * 2), ((RectangularShape)baseRect).getHeight() + (double)locOffset - (double)(i * 2));
            }
            rectWidth = tempRect.getWidth();
            Arc2D.Double focusArc = new Arc2D.Double();
            focusArc.setArc(tempRect, 30.0, 210.0, 2);
            Color focusClr = new Color(255, 255, 255, MIN_ALPHA + i);
            objects.add(new DrawableObject.Shape(14, focusArc, null, focusClr, null, null));
            ++i;
        }
        return objects;
    }
}

