/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.gauge.Gauge;
import oracle.dss.util.ErrorHandler;

public abstract class LEDStyleCallback {
    public static int SOURCE_PATH = 0;
    public static int SOURCE_IMAGE = 1;
    private ArrayList m_imgList;
    private int m_ledCount;
    private int m_method;
    private static final String m_method__getImageFromPath = "Image _getImageFromPath(String path, ErrorHandler handler)";

    public LEDStyleCallback(int method) {
        this.$init$();
        this.m_method = method;
    }

    public int getMethod() {
        return this.m_method;
    }

    public abstract Image getLEDImage(int var1);

    public abstract String getLEDImagePath(int var1);

    public String getBaseImageURI() {
        return null;
    }

    public int getLEDCount() {
        return this.m_ledCount;
    }

    public void setLEDCount(int count) {
        this.m_ledCount = count;
    }

    public Image getLEDImage(int index, ErrorHandler handler) {
        if (this.m_imgList == null) {
            this.m_imgList = new ArrayList(index + 1);
        }
        if (index >= this.m_imgList.size()) {
            int i = 0;
            while (i <= index) {
                this.m_imgList.add(i, ImageUtils.getNotLoadedImage());
                ++i;
            }
        }
        if (this.getMethod() == SOURCE_PATH) {
            String imgPath = this.getLEDImagePath(index);
            this.m_imgList.set(index, this._getImageFromPath(imgPath, handler));
        } else {
            Image img = this.getLEDImage(index);
            if (img == null) {
                img = ImageUtils.getNotLoadedImage();
            }
            this.m_imgList.add(index, img);
        }
        return (Image)this.m_imgList.get(index);
    }

    private Image _getImageFromPath(String path, ErrorHandler handler) {
        Image image = null;
        if (path == null || path.equals("")) {
            ImageUtils.loadImage(image);
        } else {
            String totalPath = path;
            if (this.getBaseImageURI() != null) {
                totalPath = this.getBaseImageURI() + path;
            }
            URL url = null;
            try {
                url = new URL(totalPath);
                image = Toolkit.getDefaultToolkit().getImage(url);
            }
            catch (MalformedURLException murle) {
                // empty catch block
            }
            if (image == null) {
                image = ImageUtils.getImageResource(Gauge.class, (String)totalPath);
            }
            if (image == null) {
                handler.log("null image", this.getClass().getName(), m_method__getImageFromPath);
                image = ImageUtils.getNotLoadedImage();
                ImageUtils.loadImage((Image)image);
            } else if (!ImageUtils.loadImage((Image)image)) {
                handler.log("unable to load image", this.getClass().getName(), m_method__getImageFromPath);
                image = ImageUtils.getNotLoadedImage();
                ImageUtils.loadImage((Image)image);
            }
        }
        return image;
    }

    private void $init$() {
        this.m_imgList = null;
        this.m_ledCount = -1;
        this.m_method = SOURCE_PATH;
    }
}

