/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;
import oracle.dss.presutil.PresUtils;

public class LabelGauge
extends GaugeType {
    protected static final int GAP_GAUGESET_LABEL = 2;
    private static final int DEFAULT_TEXT_ROTATION_ANGLE = 270;

    public LabelGauge(GaugeEngine engine) {
        super(engine);
    }

    public int getGaugeType() {
        return 5;
    }

    protected Dimension autoLayout(Graphics2D g, Rectangle rect, Map map) {
        if (g == null) {
            g = this._engine.getGraphics();
        }
        int reqAboveSpace = this.getSpaceAboveGauge(map, g);
        int reqBelowSpace = this.getSpaceBelowGauge(map, g);
        int reqLeftSpace = this.getSpaceLeftOfGauge(map, g);
        int reqRightSpace = this.getSpaceRightOfGauge(map, g);
        this._gaugeFrameBounds = null;
        this._innerBounds = null;
        this._topLabelBounds = null;
        this._bottomLabelBounds = null;
        this._upperLabelFrameBounds = null;
        this._lowerLabelFrameBounds = null;
        this._calcLabelDimensions(map, g);
        this._gaugeFrameBounds = new Rectangle(rect.x + reqLeftSpace, rect.y + reqAboveSpace, rect.width - reqLeftSpace - reqRightSpace, rect.height - reqAboveSpace - reqBelowSpace);
        this._innerBounds = this._getPlotAreaBounds(this._gaugeFrameBounds, map, g);
        Dimension reqSize = new Dimension();
        reqSize.width = this._gaugeFrameBounds.width + reqLeftSpace + reqRightSpace;
        reqSize.height = this._gaugeFrameBounds.height + reqAboveSpace + reqBelowSpace;
        if (reqSize.width < 0) {
            reqSize.width = 10;
        }
        if (reqSize.height < 0) {
            reqSize.height = 10;
        }
        return reqSize;
    }

    protected Collection getLabelObjects(Map map, Rectangle outerBounds) {
        Color topFontColor;
        ArrayList<DrawableObject.Label> lblObjects = new ArrayList<DrawableObject.Label>();
        Graphics2D g = this._engine.getGraphics();
        String topLabel = (String)map.get("TopLabel");
        Font topFont = (Font)map.get("TopLabelFont");
        if (topFont == null) {
            topFont = GaugeDefaultValues.getTopLabelFont();
        }
        if ((topFontColor = (Color)map.get("TopLabelColor")) == null) {
            topFontColor = GaugeDefaultValues.getTopLabelFontColor();
        }
        Dimension topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
        int topLblPos = GaugeDefaultValues.getTopLabelPosition();
        if (map.get("TopLabelPosition") != null) {
            topLblPos = (Integer)map.get("TopLabelPosition");
        }
        if (this._innerBounds != null) {
            if (topLblDim != null && topLblDim.width > this._innerBounds.height) {
                FontMetrics fm = g.getFontMetrics(topFont);
                topLabel = PresUtils.truncateText(topLabel, fm, 0, this._innerBounds.height);
                topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
            }
            int angle = 270;
            int x = (int)(this._innerBounds.getCenterX() - topLblDim.getWidth() / 2.0);
            int y = (int)(this._innerBounds.getMaxY() - topLblDim.getHeight() / 2.0 - topLblDim.getWidth() / 2.0);
            Rectangle bounds = new Rectangle(x, y, topLblDim.width, topLblDim.height);
            DrawableObject.Label label = new DrawableObject.Label(16, g, topLabel, topFont, topFontColor, bounds, "TopLabel", null, angle);
            lblObjects.add(label);
        }
        return lblObjects;
    }

    protected Collection getPlotAreaObject(Map map, int type) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getIndicatorObject(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getTickLabelObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getTickMarkObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("No data");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int drawWidth = this._innerBounds.width - 10;
        if (dim.width > drawWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - 3 - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    protected Collection getGaugeFrameObject(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList list = new ArrayList();
        return list;
    }

    protected int getGaugeRadius(int availWidth, int availHeight) {
        return Math.min(availHeight, availWidth);
    }

    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace;
        bounds.width = availWidth;
        bounds.height = availHeight;
        return bounds;
    }

    protected int getMaxNumberOfSteps() {
        return 0;
    }

    protected int getGaugeSetGap(Map map, Graphics2D g, int dir) {
        return 2;
    }

    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int reqAboveSpace = 0;
        int reqBelowSpace = 0;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        return this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
    }
}

