/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.SFX;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGShapesHandler
extends DefaultHandler {
    private CustomShapesParser m_parser;
    private List<List<AffineTransform>> m_transformList;
    private int m_zOrder;
    private Map<String, Map> m_gradientMap;
    private Map m_currGradient;
    private static final String GRADIENT_ID = "id";
    private static final String GRADIENT_X1 = "x1";
    private static final String GRADIENT_Y1 = "y1";
    private static final String GRADIENT_X2 = "x2";
    private static final String GRADIENT_Y2 = "y2";
    private static final String GRADIENT_CX = "cx";
    private static final String GRADIENT_CY = "cy";
    private static final String GRADIENT_R = "r";
    private static final String GRADIENT_FX = "fx";
    private static final String GRADIENT_FY = "fy";
    private static final String GRADIENT_STOP_LIST = "stopList";
    private static final String GRADIENT_STOP_OFFSET = "offset";
    private static final String GRADIENT_STOP_COLOR = "stop-color";

    public SVGShapesHandler(CustomShapesParser parser) {
        this.m_parser = parser;
        this.m_transformList = new ArrayList<List<AffineTransform>>();
        this.m_zOrder = 0;
        this.m_gradientMap = new HashMap<String, Map>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        String id = atts.getValue(GRADIENT_ID);
        if (id != null) {
            id = id.split("_")[0];
        }
        Shape s = null;
        boolean bShapeElement = true;
        if (qName.equals("path")) {
            s = this._processPath(atts);
        } else if (qName.equals("rect")) {
            s = this._processRect(atts);
        } else if (qName.equals("circle") || qName.equals("ellipse")) {
            s = this._processCircleOrEllipse(atts);
        } else if (qName.equals("line")) {
            s = this._processLine(atts);
        } else if (qName.equals("polyline")) {
            s = this._processPolyline(atts);
        } else if (qName.equals("polygon")) {
            s = this._processPolygon(atts);
        } else {
            bShapeElement = false;
            if (qName.equals("linearGradient")) {
                this._processLinearGradient(atts);
            } else if (qName.equals("radialGradient")) {
                this._processRadialGradient(atts);
            } else if (qName.equals("stop")) {
                this._processStop(atts);
            }
        }
        this._processTransform(atts);
        if (bShapeElement) {
            Map<Object, Object> styleMap = new HashMap();
            String style = atts.getValue("style");
            if (style != null) {
                styleMap = SVGShapesHandler._convertStyleToMap(style);
            }
            Object fill = Color.black;
            if (atts.getValue("fill") != null) {
                fill = SVGShapesHandler._parseSFX(atts.getValue("fill"), this.m_gradientMap, s);
            } else if ((String)styleMap.get("fill") != null) {
                fill = SVGShapesHandler._parseSFX((String)styleMap.get("fill"), this.m_gradientMap, s);
            }
            Color fillColor = null;
            HashMap sfxMap = null;
            if (fill instanceof Color) {
                fillColor = (Color)fill;
            } else if (fill instanceof HashMap) {
                sfxMap = (HashMap)fill;
            }
            if (atts.getValue("fill-opacity") != null) {
                fillColor = SVGShapesHandler._setAlpha(atts.getValue("fill-opacity"), fillColor);
            } else if ((String)styleMap.get("fill-opacity") != null) {
                fillColor = SVGShapesHandler._setAlpha((String)styleMap.get("fill-opacity"), fillColor);
            }
            Color borderColor = null;
            if (atts.getValue("stroke") != null) {
                borderColor = SVGShapesHandler._parseColor(atts.getValue("stroke"));
            } else if ((String)styleMap.get("stroke") != null) {
                borderColor = SVGShapesHandler._parseColor((String)styleMap.get("stroke"));
            }
            if (atts.getValue("stroke-opacity") != null) {
                borderColor = SVGShapesHandler._setAlpha(atts.getValue("stroke-opacity"), borderColor);
            } else if ((String)styleMap.get("stroke-opacity") != null) {
                borderColor = SVGShapesHandler._setAlpha((String)styleMap.get("stroke-opacity"), borderColor);
            }
            int strokeWidth = 1;
            if (atts.getValue("stroke-width") != null) {
                strokeWidth = (int)SVGShapesHandler._parseValue(atts.getValue("stroke-width"));
            } else if ((String)styleMap.get("stroke-width") != null) {
                strokeWidth = (int)SVGShapesHandler._parseValue((String)styleMap.get("stroke-width"));
            }
            if (s != null) {
                s = this._applyTransforms(s);
                CustomShape cs = new CustomShape(s, fillColor, borderColor, sfxMap, strokeWidth, this.m_zOrder);
                ++this.m_zOrder;
                this.m_parser.addShape(id, cs);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.m_transformList.remove(this.m_transformList.size() - 1);
        if (qName.equals("linearGradient") || qName.equals("radialGradient")) {
            String id = (String)this.m_currGradient.get(GRADIENT_ID);
            this.m_gradientMap.put(id, this.m_currGradient);
            this.m_currGradient = null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    private Shape _processRect(Attributes atts) {
        RectangularShape rect = null;
        float x = SVGShapesHandler._parseValue(atts.getValue("x"));
        float y = SVGShapesHandler._parseValue(atts.getValue("y"));
        float w = SVGShapesHandler._parseValue(atts.getValue("width"));
        float h = SVGShapesHandler._parseValue(atts.getValue("height"));
        if (atts.getValue("rx") != null && atts.getValue("ry") != null) {
            float rx = SVGShapesHandler._parseValue(atts.getValue("rx"));
            float ry = SVGShapesHandler._parseValue(atts.getValue("ry"));
            rect = new RoundRectangle2D.Double(x, y, w, h, rx, ry);
        } else {
            rect = new Rectangle2D.Double(x, y, w, h);
        }
        return rect;
    }

    private Ellipse2D _processCircleOrEllipse(Attributes atts) {
        Ellipse2D.Double oval = null;
        float cx = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_CX));
        float cy = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_CY));
        if (atts.getValue(GRADIENT_R) != null) {
            float r = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_R));
            oval = new Ellipse2D.Double(cx - r, cy - r, 2.0f * r, 2.0f * r);
        } else if (atts.getValue("rx") != null && atts.getValue("ry") != null) {
            float rx = SVGShapesHandler._parseValue(atts.getValue("rx"));
            float ry = SVGShapesHandler._parseValue(atts.getValue("ry"));
            oval = new Ellipse2D.Double(cx - rx, cy - ry, 2.0f * rx, 2.0f * ry);
        }
        return oval;
    }

    private Line2D _processLine(Attributes atts) {
        float x1 = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_X1));
        float y1 = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_Y1));
        float x2 = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_X2));
        float y2 = SVGShapesHandler._parseValue(atts.getValue(GRADIENT_Y2));
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        return line;
    }

    private GeneralPath _processPolyline(Attributes atts) {
        GeneralPath path = new GeneralPath();
        if (atts.getValue("points") != null) {
            String[] points = atts.getValue("points").split("\\s+");
            String[] coords = points[0].split(",");
            float x = SVGShapesHandler._parseValue(coords[0]);
            float y = SVGShapesHandler._parseValue(coords[1]);
            path.moveTo(x, y);
            int i = 1;
            while (i < points.length) {
                if (points[i].length() > 0) {
                    coords = points[i].split(",");
                    x = SVGShapesHandler._parseValue(coords[0]);
                    y = SVGShapesHandler._parseValue(coords[1]);
                    path.lineTo(x, y);
                }
                ++i;
            }
        }
        return path;
    }

    private Polygon _processPolygon(Attributes atts) {
        Polygon polygon = new Polygon();
        if (atts.getValue("points") != null) {
            String[] points = atts.getValue("points").split("\\s+");
            int i = 0;
            while (i < points.length) {
                if (points[i].length() > 0) {
                    String[] coords = points[i].split(",");
                    int x = (int)SVGShapesHandler._parseValue(coords[0]);
                    int y = (int)SVGShapesHandler._parseValue(coords[1]);
                    polygon.addPoint(x, y);
                }
                ++i;
            }
        }
        return polygon;
    }

    private GeneralPath _processPath(Attributes atts) {
        GeneralPath path = new GeneralPath();
        String pathData = atts.getValue("d");
        String commands = pathData.replaceAll("[^a-zA-Z]", "");
        String[] coords = pathData.split("[a-zA-Z]");
        float currX = 0.0f;
        float currY = 0.0f;
        Point2D prevCubicControlPoint = null;
        Point2D prevQuadControlPoint = null;
        int i = 0;
        while (i < commands.length()) {
            char command = commands.charAt(i);
            boolean isRelative = false;
            if (Character.isLowerCase(command)) {
                isRelative = true;
            }
            String[] points = null;
            if (i + 1 < coords.length) {
                points = coords[i + 1].trim().split("[,\\s]+");
            }
            if (command == 'M' || command == 'm') {
                int j = 0;
                while (j < points.length) {
                    float x = SVGShapesHandler._parseValue(points[j]);
                    float y = SVGShapesHandler._parseValue(points[j + 1]);
                    if (isRelative) {
                        x += currX;
                        y += currY;
                    }
                    currX = x;
                    currY = y;
                    path.moveTo(x, y);
                    j += 2;
                }
            } else if (command == 'L' || command == 'l') {
                int j = 0;
                while (j < points.length) {
                    float x = SVGShapesHandler._parseValue(points[j]);
                    float y = SVGShapesHandler._parseValue(points[j + 1]);
                    if (isRelative) {
                        x += currX;
                        y += currY;
                    }
                    currX = x;
                    currY = y;
                    path.lineTo(x, y);
                    j += 2;
                }
            } else if (command == 'H' || command == 'h') {
                int j = 0;
                while (j < points.length) {
                    float x = SVGShapesHandler._parseValue(points[j]);
                    float y = currY;
                    if (isRelative) {
                        x += currX;
                    }
                    currX = x;
                    path.lineTo(x, y);
                    ++j;
                }
            } else if (command == 'V' || command == 'v') {
                int j = 0;
                while (j < points.length) {
                    float x = currX;
                    float y = SVGShapesHandler._parseValue(points[j]);
                    if (isRelative) {
                        y += currY;
                    }
                    currY = y;
                    path.lineTo(x, y);
                    ++j;
                }
            } else if (command == 'C' || command == 'c') {
                int j = 0;
                while (j < points.length) {
                    float x1 = SVGShapesHandler._parseValue(points[j]);
                    float y1 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x2 = SVGShapesHandler._parseValue(points[j + 2]);
                    float y2 = SVGShapesHandler._parseValue(points[j + 3]);
                    float x = SVGShapesHandler._parseValue(points[j + 4]);
                    float y = SVGShapesHandler._parseValue(points[j + 5]);
                    if (isRelative) {
                        x1 += currX;
                        y1 += currY;
                        x2 += currX;
                        y2 += currY;
                        x += currX;
                        y += currY;
                    }
                    currX = x;
                    currY = y;
                    prevCubicControlPoint = new Point2D.Double(x2, y2);
                    path.curveTo(x1, y1, x2, y2, x, y);
                    j += 6;
                }
            } else if (command == 'S' || command == 's') {
                int j = 0;
                while (j < points.length) {
                    float x2 = SVGShapesHandler._parseValue(points[j]);
                    float y2 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x = SVGShapesHandler._parseValue(points[j + 2]);
                    float y = SVGShapesHandler._parseValue(points[j + 3]);
                    float x1 = currX;
                    float y1 = currY;
                    if (prevCubicControlPoint != null) {
                        x1 = (float)((double)currX + ((double)currX - prevCubicControlPoint.getX()));
                        y1 = (float)((double)currY + ((double)currY - prevCubicControlPoint.getY()));
                    }
                    if (isRelative) {
                        x2 += currX;
                        y2 += currY;
                        x += currX;
                        y += currY;
                    }
                    currX = x;
                    currY = y;
                    prevCubicControlPoint = new Point2D.Double(x2, y2);
                    path.curveTo(x1, y1, x2, y2, x, y);
                    j += 4;
                }
            } else if (command == 'Q' || command == 'q') {
                int j = 0;
                while (j < points.length) {
                    float x1 = SVGShapesHandler._parseValue(points[j]);
                    float y1 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x = SVGShapesHandler._parseValue(points[j + 2]);
                    float y = SVGShapesHandler._parseValue(points[j + 3]);
                    if (isRelative) {
                        x1 += currX;
                        y1 += currY;
                        x += currX;
                        y += currY;
                    }
                    currX = x;
                    currY = y;
                    prevQuadControlPoint = new Point2D.Double(x1, y1);
                    path.quadTo(x1, y1, x, y);
                    j += 4;
                }
            } else if (command == 'T' || command == 't') {
                int j = 0;
                while (j < points.length) {
                    float x = SVGShapesHandler._parseValue(points[j]);
                    float y = SVGShapesHandler._parseValue(points[j + 1]);
                    float x1 = currX;
                    float y1 = currY;
                    if (prevQuadControlPoint != null) {
                        x1 = (float)((double)currX + ((double)currX - prevQuadControlPoint.getX()));
                        y1 = (float)((double)currY + ((double)currY - prevQuadControlPoint.getY()));
                    }
                    if (isRelative) {
                        x += currX;
                        y += currY;
                    }
                    currX = x;
                    currY = y;
                    prevQuadControlPoint = new Point2D.Double(x1, y1);
                    path.quadTo(x1, y1, x, y);
                    j += 2;
                }
            } else if (command == 'A' || command == 'a') {
                int j = 0;
                while (j < points.length) {
                    float rx = SVGShapesHandler._parseValue(points[j]);
                    float ry = SVGShapesHandler._parseValue(points[j + 1]);
                    double x_axis_rot = Math.toRadians(SVGShapesHandler._parseValue(points[j + 2]));
                    float large_arc_flag = SVGShapesHandler._parseValue(points[j + 3]);
                    float sweep_flag = SVGShapesHandler._parseValue(points[j + 4]);
                    float x = SVGShapesHandler._parseValue(points[j + 5]);
                    float y = SVGShapesHandler._parseValue(points[j + 6]);
                    if (isRelative) {
                        rx += currX;
                        ry += currY;
                        x += currX;
                        y += currY;
                    }
                    if (x != currX || y != currY) {
                        if (rx == 0.0f || ry == 0.0f) {
                            currX = x;
                            currY = y;
                            path.lineTo(x, y);
                        } else {
                            Rectangle2D.Double bounds;
                            Arc2D.Double arc;
                            double cyPrime;
                            double cxPrime;
                            if (rx < 0.0f) {
                                rx *= (float)-1;
                            }
                            if (ry < 0.0f) {
                                ry *= (float)-1;
                            }
                            if (x_axis_rot > 360.0) {
                                x_axis_rot %= 360.0;
                            }
                            if (large_arc_flag != 0.0f) {
                                large_arc_flag = 1.0f;
                            }
                            if (sweep_flag != 0.0f) {
                                sweep_flag = 1.0f;
                            }
                            double tempA = (currX - x) / 2.0f;
                            double tempB = (currY - y) / 2.0f;
                            double x1Prime = Math.cos(x_axis_rot) * tempA + Math.sin(x_axis_rot) * tempB;
                            double y1Prime = -1.0 * Math.sin(x_axis_rot) * tempA + Math.cos(x_axis_rot) * tempB;
                            tempA = (double)rx * y1Prime / (double)ry;
                            tempB = -1.0 * ((double)ry * x1Prime) / (double)rx;
                            double tempC = Math.sqrt(Math.max((Math.pow(rx, 2.0) * Math.pow(ry, 2.0) - Math.pow(rx, 2.0) * Math.pow(y1Prime, 2.0) - Math.pow(ry, 2.0) * Math.pow(x1Prime, 2.0)) / (Math.pow(rx, 2.0) * Math.pow(y1Prime, 2.0) + Math.pow(ry, 2.0) * Math.pow(x1Prime, 2.0)), 0.0));
                            if (large_arc_flag != sweep_flag) {
                                cxPrime = tempC * tempA;
                                cyPrime = tempC * tempB;
                            } else {
                                cxPrime = -1.0 * tempC * tempA;
                                cyPrime = -1.0 * tempC * tempB;
                            }
                            tempA = (currX + x) / 2.0f;
                            tempB = (currY + y) / 2.0f;
                            double cx = Math.cos(x_axis_rot) * cxPrime - Math.sin(x_axis_rot) * cyPrime + tempA;
                            double cy = Math.sin(x_axis_rot) * cxPrime + Math.cos(x_axis_rot) * cyPrime + tempB;
                            double ux = 1.0;
                            double uy = 0.0;
                            double vx = (x1Prime - cxPrime) / (double)rx;
                            double vy = (y1Prime - cyPrime) / (double)ry;
                            double lengthU = Math.sqrt(Math.pow(ux, 2.0) + Math.pow(uy, 2.0));
                            double lengthV = Math.sqrt(Math.pow(vx, 2.0) + Math.pow(vy, 2.0));
                            double angleStart = Math.toDegrees(Math.acos((ux * vx + uy * vy) / (lengthU * lengthV)));
                            if (ux * vy - uy * vx < 0.0) {
                                angleStart *= (double)-1;
                            }
                            ux = (x1Prime - cxPrime) / (double)rx;
                            uy = (y1Prime - cyPrime) / (double)ry;
                            vx = (-1.0 * x1Prime - cxPrime) / (double)rx;
                            vy = (-1.0 * y1Prime - cyPrime) / (double)ry;
                            lengthU = Math.sqrt(Math.pow(ux, 2.0) + Math.pow(uy, 2.0));
                            lengthV = Math.sqrt(Math.pow(vx, 2.0) + Math.pow(vy, 2.0));
                            double angleExtent = Math.toDegrees(Math.acos((ux * vx + uy * vy) / (lengthU * lengthV))) % 360.0;
                            if (ux * vy - uy * vx < 0.0) {
                                angleExtent *= (double)-1;
                            }
                            if (sweep_flag == 0.0f && angleExtent < 0.0 || sweep_flag == 1.0f && angleExtent > 0.0) {
                                angleExtent *= (double)-1;
                            }
                            if (((RectangularShape)(arc = new Arc2D.Double(bounds = new Rectangle2D.Double(cx - (double)rx, cy - (double)ry, 2.0f * rx, 2.0f * ry), angleStart, angleExtent, 0))).getX() >= 0.0 && ((RectangularShape)arc).getY() >= 0.0) {
                                path.append(arc, true);
                            }
                            currX = x;
                            currY = y;
                        }
                    }
                    j += 7;
                }
            } else if (command == 'Z' || command == 'z') {
                path.closePath();
            }
            if (command != 'C' && command != 'c' && command != 'S' && command != 's') {
                prevCubicControlPoint = null;
            }
            if (command != 'Q' && command != 'q' && command != 'T' && command != 't') {
                prevQuadControlPoint = null;
            }
            ++i;
        }
        return path;
    }

    private void _processLinearGradient(Attributes atts) {
        String y2;
        String x2;
        String y1;
        this.m_currGradient = new HashMap();
        String id = atts.getValue(GRADIENT_ID);
        if (id == null) {
            return;
        }
        String x1 = atts.getValue(GRADIENT_X1);
        if (x1 == null) {
            x1 = "0%";
        }
        if ((y1 = atts.getValue(GRADIENT_Y1)) == null) {
            y1 = "0%";
        }
        if ((x2 = atts.getValue(GRADIENT_X2)) == null) {
            x2 = "100%";
        }
        if ((y2 = atts.getValue(GRADIENT_Y2)) == null) {
            y2 = "0%";
        }
        this.m_currGradient.put(GRADIENT_ID, id);
        this.m_currGradient.put(GRADIENT_X1, x1);
        this.m_currGradient.put(GRADIENT_Y1, y1);
        this.m_currGradient.put(GRADIENT_X2, x2);
        this.m_currGradient.put(GRADIENT_Y2, y2);
    }

    private void _processRadialGradient(Attributes atts) {
        String fy;
        String fx;
        String r;
        String cy;
        this.m_currGradient = new HashMap();
        String id = atts.getValue(GRADIENT_ID);
        if (id == null) {
            return;
        }
        String cx = atts.getValue(GRADIENT_CX);
        if (cx == null) {
            cx = "50%";
        }
        if ((cy = atts.getValue(GRADIENT_CY)) == null) {
            cy = "50%";
        }
        if ((r = atts.getValue(GRADIENT_R)) == null) {
            r = "50%";
        }
        if ((fx = atts.getValue(GRADIENT_FX)) == null) {
            fx = cx;
        }
        if ((fy = atts.getValue(GRADIENT_FY)) == null) {
            fy = cy;
        }
        this.m_currGradient.put(GRADIENT_ID, id);
        this.m_currGradient.put(GRADIENT_CX, cx);
        this.m_currGradient.put(GRADIENT_CY, cy);
        this.m_currGradient.put(GRADIENT_R, r);
        this.m_currGradient.put(GRADIENT_FX, fx);
        this.m_currGradient.put(GRADIENT_FY, fy);
    }

    private void _processStop(Attributes atts) {
        if (this.m_currGradient == null) {
            return;
        }
        HashMap<String, Serializable> currStop = new HashMap<String, Serializable>();
        String offset = atts.getValue(GRADIENT_STOP_OFFSET);
        if (offset != null) {
            if (offset.contains("%")) {
                offset = offset.substring(0, offset.length() - 1);
                currStop.put(GRADIENT_STOP_OFFSET, Double.valueOf(Double.parseDouble(offset) / 100.0));
            } else {
                currStop.put(GRADIENT_STOP_OFFSET, Double.valueOf(Double.parseDouble(offset)));
            }
        }
        Map<Object, Object> styleMap = new HashMap();
        String style = atts.getValue("style");
        if (style != null) {
            styleMap = SVGShapesHandler._convertStyleToMap(style);
        }
        Color stopColor = Color.BLACK;
        if (atts.getValue(GRADIENT_STOP_COLOR) != null) {
            stopColor = SVGShapesHandler._parseColor(atts.getValue(GRADIENT_STOP_COLOR));
        } else if ((String)styleMap.get(GRADIENT_STOP_COLOR) != null) {
            stopColor = SVGShapesHandler._parseColor((String)styleMap.get(GRADIENT_STOP_COLOR));
        }
        if (atts.getValue("stop-opacity") != null) {
            stopColor = SVGShapesHandler._setAlpha(atts.getValue("stop-opacity"), stopColor);
        } else if ((String)styleMap.get("stop-opacity") != null) {
            stopColor = SVGShapesHandler._setAlpha((String)styleMap.get("stop-opacity"), stopColor);
        }
        currStop.put(GRADIENT_STOP_COLOR, stopColor);
        ArrayList stops = (ArrayList)this.m_currGradient.get(GRADIENT_STOP_LIST);
        if (stops == null) {
            stops = new ArrayList();
        }
        stops.add(currStop);
        this.m_currGradient.put(GRADIENT_STOP_LIST, stops);
    }

    private static float _parseValue(String s) {
        if (s == null) {
            return new Float(0.0f).floatValue();
        }
        s = s.replaceAll("px", "");
        float val = Float.valueOf(s).floatValue();
        return val;
    }

    private static Color _parseColor(String s) {
        if (s.equals("none")) {
            return null;
        }
        return DataviewUtils.hexStringToColor(s);
    }

    private static Object _parseSFX(String s, Map<String, Map> gradMap, Shape shape) {
        if (s.startsWith("url(#")) {
            s = s.substring(5, s.length() - 1);
            Map map = gradMap.get(s);
            HashMap sfxMap = SVGShapesHandler._convertGradientMapToSFXMap(map, shape);
            return sfxMap;
        }
        return SVGShapesHandler._parseColor(s);
    }

    private static Color _setAlpha(String alpha, Color c) {
        if (c == null) {
            return null;
        }
        int a = (int)(Double.parseDouble(alpha) * 255.0);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(r, g, b, a);
    }

    private static Map<String, String> _convertStyleToMap(String style) {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        String s = style.replaceAll("\\s", "");
        int start = 0;
        while (start < s.length() - 1) {
            String value;
            int end = s.indexOf(58, start);
            String key = s.substring(start, end);
            start = end + 1;
            if ((end = s.indexOf(59, start)) == -1) {
                value = s.substring(start);
                start = s.length();
            } else {
                value = s.substring(start, end);
                start = end + 1;
            }
            styleMap.put(key, value);
        }
        return styleMap;
    }

    private void _processTransform(Attributes atts) {
        String t = atts.getValue("transform");
        ArrayList<AffineTransform> list = new ArrayList<AffineTransform>();
        if (t == null) {
            this.m_transformList.add(list);
            return;
        }
        String[] transforms = t.split("\\x29");
        int i = 0;
        while (i < transforms.length) {
            String transform = transforms[i];
            int beginIndex = transform.indexOf("(");
            if (beginIndex >= 0) {
                String command = transform.substring(0, beginIndex);
                command = command.replaceAll("[\\s,]", "");
                String coords = transform.substring(beginIndex + 1);
                String[] points = coords.split(",");
                if (transforms[i] != null && !transforms[i].equals("")) {
                    if (command.equals("translate")) {
                        double tx = SVGShapesHandler._parseValue(points[0]);
                        double ty = 0.0;
                        if (points.length >= 2) {
                            ty = SVGShapesHandler._parseValue(points[1]);
                        }
                        AffineTransform at = new AffineTransform();
                        at.translate(tx, ty);
                        list.add(at);
                    } else if (command.equals("matrix")) {
                        double a = SVGShapesHandler._parseValue(points[0]);
                        double b = SVGShapesHandler._parseValue(points[1]);
                        double c = SVGShapesHandler._parseValue(points[2]);
                        double d = SVGShapesHandler._parseValue(points[3]);
                        double e = SVGShapesHandler._parseValue(points[4]);
                        double f = SVGShapesHandler._parseValue(points[5]);
                        AffineTransform at = new AffineTransform(a, b, c, d, e, f);
                        list.add(at);
                    } else if (command.equals("scale")) {
                        AffineTransform at = new AffineTransform();
                        double sx = SVGShapesHandler._parseValue(points[0]);
                        if (points.length >= 2) {
                            double sy = SVGShapesHandler._parseValue(points[1]);
                            at.scale(sx, sy);
                        } else {
                            at.scale(sx, sx);
                        }
                        list.add(at);
                    } else if (command.equals("rotate")) {
                        AffineTransform at = new AffineTransform();
                        double ang = Math.toRadians(SVGShapesHandler._parseValue(points[0]));
                        if (points.length >= 3) {
                            double cx = SVGShapesHandler._parseValue(points[1]);
                            double cy = SVGShapesHandler._parseValue(points[1]);
                            at.rotate(ang, cx, cy);
                        } else {
                            at.rotate(ang);
                        }
                        list.add(at);
                    } else if (command.equals("skewX")) {
                        double ang = Math.toRadians(SVGShapesHandler._parseValue(points[0]));
                        AffineTransform at = new AffineTransform(1.0, 0.0, Math.tan(ang), 1.0, 0.0, 0.0);
                        list.add(at);
                    } else if (command.equals("skewY")) {
                        double ang = Math.toRadians(SVGShapesHandler._parseValue(points[0]));
                        AffineTransform at = new AffineTransform(1.0, Math.tan(ang), 0.0, 1.0, 0.0, 0.0);
                        list.add(at);
                    }
                }
            }
            ++i;
        }
        this.m_transformList.add(list);
    }

    private Shape _applyTransforms(Shape s) {
        int i = 0;
        while (i < this.m_transformList.size()) {
            List<AffineTransform> trans = this.m_transformList.get(i);
            int j = 0;
            while (j < trans.size()) {
                AffineTransform at = trans.get(j);
                if (at != null) {
                    s = at.createTransformedShape(s);
                }
                ++j;
            }
            ++i;
        }
        return s;
    }

    private static HashMap _convertGradientMapToSFXMap(Map map, Shape shape) {
        HashMap sfxMap = SFX.cloneDefaultMap();
        if (shape == null || map == null) {
            return sfxMap;
        }
        sfxMap.put("SFX_FILL_TYPE", new Integer(2));
        ArrayList stopList = (ArrayList)map.get(GRADIENT_STOP_LIST);
        if (stopList == null) {
            return sfxMap;
        }
        ArrayList offsets = new ArrayList(stopList.size());
        ArrayList stopColors = new ArrayList(stopList.size());
        int i = 0;
        while (i < stopList.size()) {
            Map stop = (Map)stopList.get(i);
            offsets.add(stop.get(GRADIENT_STOP_OFFSET));
            stopColors.add(stop.get(GRADIENT_STOP_COLOR));
            ++i;
        }
        sfxMap.put("SFX_STOP_POSITIONS", offsets);
        sfxMap.put("SFX_STOP_COLORS", stopColors);
        sfxMap.put("SFX_NUM_STOPS", stopList.size());
        if (map.get(GRADIENT_X1) != null) {
            String x1String = (String)map.get(GRADIENT_X1);
            String y1String = (String)map.get(GRADIENT_Y1);
            String x2String = (String)map.get(GRADIENT_X2);
            String y2String = (String)map.get(GRADIENT_Y2);
            if (x1String != null && y1String != null && x2String != null && y2String != null) {
                double x1 = SVGShapesHandler._convertCoordToPercent(x1String, shape, GRADIENT_X1);
                double y1 = SVGShapesHandler._convertCoordToPercent(y1String, shape, GRADIENT_Y1);
                double x2 = SVGShapesHandler._convertCoordToPercent(x2String, shape, GRADIENT_X2);
                double y2 = SVGShapesHandler._convertCoordToPercent(y2String, shape, GRADIENT_Y2);
                sfxMap.put("SFX_START_POINT", new Point2D.Double(x1, y1));
                sfxMap.put("SFX_END_POINT", new Point2D.Double(x2, y2));
            }
            sfxMap.put("SFX_GRADIENT_DIRECTION", new Integer(20));
        } else {
            String cxString = (String)map.get(GRADIENT_CX);
            String cyString = (String)map.get(GRADIENT_CY);
            String rString = (String)map.get(GRADIENT_R);
            String fxString = (String)map.get(GRADIENT_FX);
            String fyString = (String)map.get(GRADIENT_FY);
            if (cxString != null && cyString != null && rString != null && fxString != null && fyString != null) {
                double cx = SVGShapesHandler._convertCoordToPercent(cxString, shape, GRADIENT_CX);
                double cy = SVGShapesHandler._convertCoordToPercent(cyString, shape, GRADIENT_CY);
                sfxMap.put("SFX_GRADIENT_CENTER", new Point2D.Double(cx, cy));
            }
            sfxMap.put("SFX_GRADIENT_DIRECTION", new Integer(21));
        }
        return sfxMap;
    }

    private static double _convertCoordToPercent(String s, Shape shape, String type) {
        double percent = 0.0;
        if (s.contains("%")) {
            percent = Double.parseDouble(s.substring(0, s.length() - 1));
        } else {
            Rectangle2D bounds = shape.getBounds2D();
            double coord = Double.parseDouble(s);
            if (type == GRADIENT_X1 || type == GRADIENT_X2) {
                percent = (coord - bounds.getX()) / bounds.getWidth();
            } else if (type == GRADIENT_Y1 || type == GRADIENT_Y2) {
                percent = (coord - bounds.getY()) / bounds.getHeight();
            }
        }
        if (percent > 100.0) {
            percent = 100.0;
        } else if (percent < 0.0) {
            percent = 0.0;
        }
        return percent;
    }
}

