/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;

public class VerticalStatusMeterGauge
extends GaugeType {
    private static int METER_WIDTH = 25;
    private static double INDICATOR_WIDTH = 0.4;
    private static int HORIZONTAL_TICKLBL_GAP = 3;
    private static int TICKMARK_LENGTH = 6;
    private static final double INCR_FACTOR = 0.02;
    private static double WIDTH_OVERLAY_REFLECTION = 0.5;
    private boolean _labelsRight;
    private double _tickMarkXPos;
    private ArrayList<Point2D> _tickMarkPositions;
    private int _tickMarkLength;
    private Area _plotArea;

    public VerticalStatusMeterGauge(GaugeEngine engine) {
        super(engine);
        this.$init$();
    }

    public int getGaugeType() {
        return 4;
    }

    protected Collection getPlotAreaObject(Map map, int type) {
        Color fillColor;
        ArrayList<Object> objects = new ArrayList<Object>(15);
        Color borderColor = (Color)map.get("PlotAreaBorderColor");
        if (borderColor == null) {
            borderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
        }
        if ((fillColor = (Color)map.get("PlotAreaFillColor")) == null) {
            fillColor = GaugeDefaultValues.getPlotAreaFillColor(this.getGaugeType());
        }
        HashMap sfxMap = (HashMap)map.get("PlotAreaSFX");
        double x = this._innerBounds.x;
        double y = this._innerBounds.y;
        double width = this._innerBounds.width;
        double height = this._innerBounds.height;
        double arcRadius = this._innerBounds.width / 3;
        Area plotArea = new Area(new Rectangle2D.Double(x, y, width, height));
        Area mask = this._labelsRight ? new Area(new RoundRectangle2D.Double(x, y, width * 2.0, height, arcRadius, arcRadius)) : new Area(new RoundRectangle2D.Double(x - width, y, width * 2.0, height, arcRadius, arcRadius));
        plotArea.intersect(mask);
        this._plotArea = (Area)plotArea.clone();
        if (this._csParser != null && this._csParser.defines("plotArea")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("plotArea");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = VerticalStatusMeterGauge.getScalingTransform(bounds, this._innerBounds);
                this._moveTransform = move = VerticalStatusMeterGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            Color userBorderColor = (Color)map.get("PlotAreaBorderColor");
            Color userFillColor = (Color)map.get("PlotAreaFillColor");
            if (map.get("PlotAreaUseThresholdFillColor") != null && ((Boolean)map.get("PlotAreaUseThresholdFillColor")).booleanValue()) {
                userFillColor = this._getIndicatorColor(map, true);
            }
            HashMap userSFXMap = (HashMap)map.get("PlotAreaSFX");
            List<CustomShape> shapesList = this._csParser.getShapes("plotArea");
            int i = 0;
            while (i < shapesList.size()) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                objects.add(new DrawableObject.Shape(11, s, csBorderColor, csFillColor, csSFXMap, null));
                ++i;
            }
            if (map.get("ThresholdValues") != null) {
                objects.add(this._getThresholdObjects(map, new Area(bounds)));
            }
        } else if (map.get("ThresholdValues") != null) {
            objects.add(new DrawableObject.Shape(11, plotArea, borderColor, null, sfxMap, null));
            objects.add(this._getThresholdObjects(map, plotArea));
        } else {
            objects.add(new DrawableObject.Shape(11, plotArea, borderColor, fillColor, sfxMap, null));
        }
        return objects;
    }

    protected Collection getIndicatorObject(Map map) {
        Color borderColor;
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        if (this._engine.getMetric() < this._engine.getMin()) {
            return objects;
        }
        if (this._engine.isNullMetric()) {
            DrawableObject noDataObj = this.getNoDataLabelObject(map);
            if (noDataObj != null) {
                objects.add(noDataObj);
            }
            return objects;
        }
        double metric = this._engine.getMetric();
        double[] tValues = (double[])map.get("ThresholdValues");
        ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
        Color fillColor = GaugeDefaultValues.getIndicatorBarFillColor();
        if (map.get("IndicatorBarFillColor") != null) {
            fillColor = (Color)map.get("IndicatorBarFillColor");
        }
        if ((borderColor = (Color)map.get("IndicatorBarBorderColor")) == null) {
            borderColor = GaugeDefaultValues.getIndicatorBarBorderColor();
        }
        HashMap sfxMap = (HashMap)map.get("IndicatorBarSFX");
        boolean autoColor = GaugeDefaultValues.isIndicatorUseThresholdFillColor();
        if (map.get("IndicatorUseThresholdFillColor") != null) {
            autoColor = (Boolean)map.get("IndicatorUseThresholdFillColor");
        }
        if (autoColor && tValues != null) {
            int index = -1;
            int i = 0;
            while (i < tValues.length) {
                if (metric <= tValues[i]) {
                    index = i;
                    break;
                }
                if (i == tValues.length - 1) {
                    index = tValues.length;
                }
                ++i;
            }
            if (tList != null && index < tList.size()) {
                HashMap tMap = (HashMap)tList.get(index);
                fillColor = ((Color)VerticalStatusMeterGauge.getThresholdAttribute(tMap, index, "ThresholdFillColor")).darker();
                sfxMap = (HashMap)VerticalStatusMeterGauge.getThresholdAttribute(tMap, index, "ThresholdSFX");
            } else {
                Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                if (index < defClrs.length) {
                    fillColor = defClrs[index].darker();
                }
            }
        }
        double barLength = (this._engine.getMetric() - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
        barLength = Math.min(barLength, 1.0);
        int barWidth = (int)(INDICATOR_WIDTH * (double)this._innerBounds.width);
        if ((this._innerBounds.width - barWidth) % 2 != 0) {
            --barWidth;
        }
        double x = this._innerBounds.x + (this._innerBounds.width - barWidth) / 2;
        double y = (double)this._innerBounds.y + (double)this._innerBounds.height * (1.0 - barLength);
        double width = barWidth;
        double height = (double)this._innerBounds.height * barLength;
        double arcRadius = barWidth / 2;
        Area indicator = new Area(new Rectangle2D.Double(x, y, width, height));
        Area indMask = new Area(new RoundRectangle2D.Double(x, y, width, height * 2.0, arcRadius, arcRadius));
        indicator.intersect(indMask);
        if (this._csParser != null && this._csParser.defines("indicator")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("indicator");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                Rectangle iBounds = new Rectangle(this._innerBounds.x + (this._innerBounds.width / 2 + barWidth), this._innerBounds.y, barWidth, this._innerBounds.height);
                scale = VerticalStatusMeterGauge.getScalingTransform(bounds, iBounds);
                this._moveTransform = move = VerticalStatusMeterGauge.getTranslateTransform(bounds, iBounds, scale);
                this._scaleTransform = scale;
            }
            Shape s = scale.createTransformedShape(bounds);
            s = move.createTransformedShape(s);
            Rectangle scaledBounds = s.getBounds();
            int maxY = this._innerBounds.y + this._innerBounds.height;
            int indLength = (int)((double)this._innerBounds.height * barLength);
            Area mask = new Area(new Rectangle2D.Double(scaledBounds.x, maxY - indLength, scaledBounds.width, indLength));
            Color userBorderColor = (Color)map.get("IndicatorBarBorderColor");
            Color userFillColor = (Color)map.get("IndicatorBarFillColor");
            if (map.get("IndicatorUseThresholdFillColor") != null && ((Boolean)map.get("IndicatorUseThresholdFillColor")).booleanValue()) {
                userFillColor = this._getIndicatorColor(map, true);
            }
            HashMap userSFXMap = (HashMap)map.get("IndicatorSFX");
            List<CustomShape> shapesList = this._csParser.getShapes("indicator");
            int i = 0;
            while (i < shapesList.size()) {
                CustomShape cs = shapesList.get(i);
                s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Area ind = new Area(s);
                ind.intersect(mask);
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                objects.add(new DrawableObject.Shape(14, ind, csBorderColor, csFillColor, csSFXMap, null));
                ++i;
            }
        } else {
            objects.add(new DrawableObject.Shape(14, indicator, borderColor, fillColor, sfxMap, null));
        }
        return objects;
    }

    protected Collection _getThresholdObjects(Map map, Area plotAreaMask) {
        Rectangle2D.Double tholdRect;
        Color tBorderColor;
        Color tColor;
        HashMap tMap;
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(15);
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        double currY = this._innerBounds.y + this._innerBounds.height;
        double currTholdLength = 0.0;
        double totalTholdLength = 0.0;
        boolean bBlended = false;
        boolean autoColor = GaugeDefaultValues.isPlotAreaUseThresholdFillColor();
        if (map.get("PlotAreaUseThresholdFillColor") != null) {
            autoColor = (Boolean)map.get("PlotAreaUseThresholdFillColor");
        }
        Area csThreshold = null;
        if (this._csParser != null && this._csParser.defines("thresholdFillArea")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("thresholdFillArea");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = VerticalStatusMeterGauge.getScalingTransform(bounds, this._innerBounds);
                this._moveTransform = move = VerticalStatusMeterGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            csThreshold = new Area();
            List<CustomShape> shapesList = this._csParser.getShapes("thresholdFillArea");
            int j = 0;
            while (j < shapesList.size()) {
                CustomShape cs = shapesList.get(j);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                csThreshold.add(new Area(s));
                ++j;
            }
        }
        double metric = this._engine.getMetric();
        double[] tValues = (double[])map.get("ThresholdValues");
        ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
        Color prevColor = null;
        HashMap sfxMap = null;
        int index = -1;
        int i = 0;
        while (i < tValues.length) {
            if (tList != null && i < tList.size()) {
                tMap = (HashMap)tList.get(i);
                tColor = (Color)VerticalStatusMeterGauge.getThresholdAttribute(tMap, i, "ThresholdFillColor");
                tBorderColor = (Color)VerticalStatusMeterGauge.getThresholdAttribute(tMap, i, "ThresholdBorderColor");
                sfxMap = (HashMap)VerticalStatusMeterGauge.getThresholdAttribute(tMap, i, "ThresholdSFX");
            } else {
                Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                tColor = i < defFillColors.length ? defFillColors[i] : Color.white;
                tBorderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
            }
            if (bBlended) {
                Color nextColor;
                if (tList != null && i + 1 < tList.size()) {
                    tMap = (HashMap)tList.get(i + 1);
                    nextColor = (Color)VerticalStatusMeterGauge.getThresholdAttribute(tMap, i + 1, "ThresholdFillColor");
                } else {
                    Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                    nextColor = i + 1 < defFillColors.length ? defFillColors[i + 1] : tColor;
                }
                Color endColor = this._blendColors(tColor, nextColor);
                if (prevColor == null) {
                    prevColor = tColor;
                }
                sfxMap = GaugeDefaultValues.getBlendedThresholdSFX(endColor, tColor, prevColor, 3);
                prevColor = endColor;
            }
            if (autoColor) {
                if (metric <= tValues[i]) {
                    if (csThreshold != null) {
                        objects.add(new DrawableObject.Shape(15, csThreshold, tBorderColor, tColor, sfxMap, null));
                        return objects;
                    }
                    index = i;
                    tBorderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
                    objects.add(new DrawableObject.Shape(15, plotAreaMask, tBorderColor, tColor, sfxMap, null));
                    return objects;
                }
                if (i == tValues.length - 1) {
                    index = tValues.length;
                }
            } else {
                currTholdLength = (tValues[i] - min) / (max - min) * (double)this._innerBounds.height - totalTholdLength;
                if (csThreshold != null) {
                    Rectangle csThresholdBounds = csThreshold.getBounds();
                    Rectangle2D.Double mask = new Rectangle2D.Double(((RectangularShape)csThresholdBounds).getX(), currY - Math.floor(currTholdLength), ((RectangularShape)csThresholdBounds).getWidth(), currTholdLength);
                    Area segment = new Area(mask);
                    segment.intersect(csThreshold);
                    objects.add(new DrawableObject.Shape(15, segment, tBorderColor, tColor, sfxMap, null));
                } else {
                    tholdRect = new Rectangle2D.Double();
                    ((Rectangle2D)tholdRect).setRect(this._innerBounds.x, currY - currTholdLength, this._innerBounds.width, currTholdLength);
                    Area tholdArea = new Area(tholdRect);
                    tholdArea.intersect(plotAreaMask);
                    objects.add(new DrawableObject.Shape(15, tholdArea, tBorderColor, tColor, sfxMap, null));
                }
                currY -= currTholdLength;
                totalTholdLength += currTholdLength;
            }
            ++i;
        }
        if (tList != null && tValues.length < tList.size()) {
            tMap = (HashMap)tList.get(tValues.length);
            tColor = (Color)VerticalStatusMeterGauge.getThresholdAttribute(tMap, tValues.length, "ThresholdFillColor");
            tBorderColor = (Color)VerticalStatusMeterGauge.getThresholdAttribute(tMap, tValues.length, "ThresholdBorderColor");
            sfxMap = (HashMap)VerticalStatusMeterGauge.getThresholdAttribute(tMap, tValues.length, "ThresholdSFX");
        } else {
            Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
            tColor = tValues.length < defFillColors.length ? defFillColors[tValues.length] : Color.white;
            tBorderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
        }
        if (bBlended) {
            if (prevColor == null) {
                prevColor = tColor;
            }
            sfxMap = GaugeDefaultValues.getBlendedThresholdSFX(tColor, tColor, prevColor, 3);
        }
        if (csThreshold != null) {
            Rectangle csThresholdBounds = csThreshold.getBounds();
            Rectangle2D.Double mask = new Rectangle2D.Double(((RectangularShape)csThresholdBounds).getX(), ((RectangularShape)csThresholdBounds).getY(), ((RectangularShape)csThresholdBounds).getWidth(), currY - ((RectangularShape)csThresholdBounds).getY());
            Area segment = new Area(mask);
            segment.intersect(csThreshold);
            objects.add(new DrawableObject.Shape(15, segment, tBorderColor, tColor, sfxMap, null));
        } else {
            tholdRect = new Rectangle2D.Double();
            ((Rectangle2D)tholdRect).setRect(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, currY - (double)this._innerBounds.y);
            Area tholdArea = new Area(tholdRect);
            tholdArea.intersect(plotAreaMask);
            objects.add(new DrawableObject.Shape(15, tholdArea, tBorderColor, tColor, sfxMap, null));
        }
        return objects;
    }

    protected Collection getOverlayEffectObjects(Map map) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        int visualEffects = GaugeDefaultValues.getVisualEffects();
        if (map.get("VisualEffects") != null) {
            visualEffects = (Integer)map.get("VisualEffects");
        }
        if (visualEffects == 0) {
            return objects;
        }
        if (!(this._plotArea == null || this._csParser != null && this._csParser.defines("plotArea"))) {
            Rectangle2D bounds = this._plotArea.getBounds2D();
            Rectangle2D.Double overlayBounds = new Rectangle2D.Double();
            double overlayWidth = WIDTH_OVERLAY_REFLECTION * bounds.getWidth();
            if (this._labelsRight) {
                ((Rectangle2D)overlayBounds).setRect(bounds.getX(), bounds.getY(), overlayWidth, bounds.getHeight());
            } else {
                ((Rectangle2D)overlayBounds).setRect(bounds.getX() + (bounds.getWidth() - overlayWidth), bounds.getY(), overlayWidth, bounds.getHeight());
            }
            Area overlay = new Area(overlayBounds);
            overlay.intersect(this._plotArea);
            HashMap sfxMap = GaugeDefaultValues.getVerticalStatusMeterOverlay(this._labelsRight);
            objects.add(new DrawableObject.Shape(34, overlay, null, null, sfxMap, null));
        }
        return objects;
    }

    protected Collection getTickLabelObjects(Map map) {
        ArrayList<DrawableObject.TickLabel> objects = new ArrayList<DrawableObject.TickLabel>(15);
        int tickContent = -1;
        if (this._tickMarkPositions != null) {
            Integer tickLabelPos;
            Color color;
            Font font = (Font)map.get("TickLabelFont");
            if (font == null) {
                font = GaugeDefaultValues.getTickLabelFont();
            }
            if ((color = (Color)map.get("TickLabelColor")) == null) {
                color = GaugeDefaultValues.getTickLabelFontColor();
            }
            if ((tickLabelPos = (Integer)map.get("TickLabelPosition")) == null) {
                tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
            }
            Graphics2D g = this._engine.getGraphics();
            double min = this._engine.getMin();
            double max = this._engine.getMax();
            double range = max - min;
            int i = 0;
            while (i < this._tickMarkPositions.size()) {
                Point2D pt = this._tickMarkPositions.get(i);
                double val = range * ((double)(this._innerBounds.y + this._innerBounds.height) - pt.getY()) / (double)this._innerBounds.height + min;
                val = Math.min(Math.max(val, min), max);
                String value = this._engine.formatValue(val, "TickLabelViewFormat");
                Dimension dim = DrawableObject.getLabelDimensions(g, font, value);
                int x = (int)pt.getX() + HORIZONTAL_TICKLBL_GAP + this._tickMarkLength;
                int y = (int)pt.getY() - dim.height / 2;
                Rectangle tickRect = new Rectangle(x, y, dim.width, dim.height);
                objects.add(DrawableObject.getTickLabelObject(g, value, font, color, tickRect, 4));
                ++i;
            }
        } else {
            tickContent = (Integer)map.get("TickLabelContent") == null ? (map.get("ThresholdValues") == null ? 7 : 11) : (Integer)map.get("TickLabelContent");
            this._addObjects(objects, this.getTickLabelObjects(map, tickContent));
        }
        return objects;
    }

    private Collection getTickLabelObjects(Map map, int type) {
        double y;
        Dimension dim;
        String value;
        Color fontColor;
        ArrayList<DrawableObject.TickLabel> objects = new ArrayList<DrawableObject.TickLabel>(15);
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getTickLabelFont();
        }
        if ((fontColor = (Color)map.get("TickLabelColor")) == null) {
            fontColor = GaugeDefaultValues.getTickLabelFontColor();
        }
        Graphics2D g = this._engine.getGraphics();
        double offset = Math.max(this._tickMarkLength - TICKMARK_LENGTH, 0);
        double x = this._labelsRight ? this._tickMarkXPos + (double)HORIZONTAL_TICKLBL_GAP + (double)TICKMARK_LENGTH + offset : this._tickMarkXPos - (double)HORIZONTAL_TICKLBL_GAP - offset;
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        Rectangle tickRect = null;
        if ((type & 0x10) != 0) {
            if (this._engine.isNullMetric()) {
                return objects;
            }
            double metric = this._engine.getMetric();
            value = this._engine.formatValue(metric, "MetricLabelViewFormat");
            dim = DrawableObject.getLabelDimensions(g, font, value);
            y = (double)(this._innerBounds.y + this._innerBounds.height) - (metric - min) / (max - min) * (double)this._innerBounds.height - (double)(dim.height / 2) - 1.0;
            tickRect = this._labelsRight ? new Rectangle((int)x, (int)y, dim.width, dim.height) : new Rectangle((int)x - dim.width, (int)y, dim.width, dim.height);
            objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
        }
        if ((type & 8) != 0) {
            double[] array = (double[])map.get("ThresholdValues");
            if (array == null) {
                return objects;
            }
            int i = 0;
            while (i < array.length) {
                if (!(array[i] > max) && !(array[i] < min)) {
                    value = this._engine.formatValue(array[i], "TickLabelViewFormat");
                    dim = DrawableObject.getLabelDimensions(g, font, value);
                    y = max - min != 0.0 ? (double)(this._innerBounds.y + this._innerBounds.height) - (array[i] - min) / (max - min) * (double)this._innerBounds.height - (double)(dim.height / 2) - 1.0 : (double)(this._innerBounds.y + this._innerBounds.height - dim.height / 2 - 1);
                    tickRect = this._labelsRight ? new Rectangle((int)x, (int)y, dim.width, dim.height) : new Rectangle((int)x - dim.width, (int)y, dim.width, dim.height);
                    objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
                }
                ++i;
            }
        }
        if ((type & 3) != 0) {
            value = this._engine.formatValue(min, "TickLabelViewFormat");
            dim = DrawableObject.getLabelDimensions(g, font, value);
            y = this._innerBounds.y + this._innerBounds.height - dim.height;
            tickRect = this._labelsRight ? new Rectangle((int)x, (int)y, dim.width, dim.height) : new Rectangle((int)x - dim.width, (int)y, dim.width, dim.height);
            objects.addAll(this.getTextShadow(g, font, tickRect, GaugeDefaultValues.TEXT_SHADOW_CLR));
            objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
            value = this._engine.formatValue(max, "TickLabelViewFormat");
            dim = DrawableObject.getLabelDimensions(g, font, value);
            y = this._innerBounds.y - 2;
            tickRect = this._labelsRight ? new Rectangle((int)x, (int)y, dim.width, dim.height) : new Rectangle((int)x - dim.width, (int)y, dim.width, dim.height);
            objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
        }
        if ((type & 4) != 0) {
            int i = 0;
            while (i < this._engine.getNumberOfSteps() - 1) {
                double incrVal = this._engine.getIncrement() * (double)(i + 1);
                value = this._engine.formatValue(incrVal + min, "TickLabelViewFormat");
                dim = DrawableObject.getLabelDimensions(g, font, value);
                y = (double)(this._innerBounds.y + this._innerBounds.height) - incrVal / (max - min) * (double)this._innerBounds.height - (double)(dim.height / 2) - 1.0;
                tickRect = this._labelsRight ? new Rectangle((int)x, (int)y, dim.width, dim.height) : new Rectangle((int)x - dim.width, (int)y, dim.width, dim.height);
                objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
                ++i;
            }
        }
        return objects;
    }

    protected Collection getTickMarkObjects(Map map) {
        ArrayList<Object> objects = new ArrayList<Object>(15);
        int tickMarks = -1;
        tickMarks = (Integer)map.get("TickMarkContent") == null ? (map.get("ThresholdValues") == null ? 7 : 11) : (Integer)map.get("TickMarkContent");
        this._tickMarkXPos = this._labelsRight ? (double)(this._innerBounds.x + this._innerBounds.width) : (double)(this._innerBounds.x - TICKMARK_LENGTH);
        if (this._csParser != null && this._csParser.defines("tickMarkPath")) {
            Rectangle2D bounds = this._csParser.getBounds("tickMarkPath");
            if (this._scaleTransform != null && this._moveTransform != null) {
                Shape s = bounds;
                s = this._scaleTransform.createTransformedShape(s);
                s = this._moveTransform.createTransformedShape(s);
                this._tickMarkXPos = s.getBounds().getCenterX();
            }
            objects.add(this.getTickMarkObjects(map, tickMarks, this._tickMarkXPos));
        } else if (this._csParser != null && this._csParser.defines("tickMark")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("tickMark");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = VerticalStatusMeterGauge.getScalingTransform(bounds, this._innerBounds);
                this._moveTransform = move = VerticalStatusMeterGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            Color userColor = (Color)map.get("MajorTickColor");
            List<CustomShape> shapesList = this._csParser.getShapes("tickMark");
            this._tickMarkPositions = new ArrayList();
            this._tickMarkLength = 0;
            int i = 0;
            while (i < shapesList.size()) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Rectangle2D sBounds = s.getBounds2D();
                double cx = sBounds.getCenterX();
                double cy = sBounds.getCenterY();
                double w = sBounds.getWidth();
                double h = sBounds.getHeight();
                Point2D.Double center = new Point2D.Double(cx, cy);
                int tmLength = (int)(w / 2.0);
                if (tmLength > this._tickMarkLength) {
                    this._tickMarkLength = tmLength;
                }
                this._tickMarkPositions.add(center);
                Color csColor = userColor != null ? userColor : cs.getFillColor();
                objects.add(new DrawableObject.Shape(13, s, cs.getBorderColor(), csColor, cs.getSFXMap(), null));
                ++i;
            }
        } else {
            this._addObjects(objects, this.getTickMarkObjects(map, tickMarks, this._tickMarkXPos));
        }
        return objects;
    }

    protected Collection getTickMarkObjects(Map map, int tickMarkType, double xPos) {
        double y;
        ArrayList objects = new ArrayList(15);
        int tmLength = TICKMARK_LENGTH;
        Color tmColor = (Color)map.get("MajorTickColor");
        if (tmColor == null) {
            tmColor = GaugeDefaultValues.getMajorTickMarkColor();
        }
        double x = xPos;
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        if ((tickMarkType & 3) != 0) {
            y = this._innerBounds.y + this._innerBounds.height;
            objects.addAll(this.getTickMarkObject(map, new Point2D.Double(x, y), tmColor));
            y = this._innerBounds.y;
            objects.addAll(this.getTickMarkObject(map, new Point2D.Double(x, y), tmColor));
        }
        if ((tickMarkType & 4) != 0) {
            int i = 0;
            while (i < this._engine.getNumberOfSteps() - 1) {
                double incrVal = this._engine.getIncrement() * (double)(i + 1);
                y = max - min != 0.0 ? (double)(this._innerBounds.y + this._innerBounds.height) - incrVal / (max - min) * (double)this._innerBounds.height : (double)(this._innerBounds.y + this._innerBounds.height);
                objects.addAll(this.getTickMarkObject(map, new Point2D.Double(x, y), tmColor));
                ++i;
            }
        }
        if ((tickMarkType & 8) != 0) {
            double[] array = (double[])map.get("ThresholdValues");
            if (array == null) {
                return objects;
            }
            int i = 0;
            while (i < array.length) {
                if (!(array[i] > max) && !(array[i] < min)) {
                    y = max - min != 0.0 ? (double)(this._innerBounds.y + this._innerBounds.height) - (array[i] - min) / (max - min) * (double)this._innerBounds.height : (double)(this._innerBounds.y + this._innerBounds.height);
                    objects.addAll(this.getTickMarkObject(map, new Point2D.Double(x, y + 1.0), tmColor));
                }
                ++i;
            }
        }
        if ((tickMarkType & 0x10) != 0) {
            if (this._engine.isNullMetric()) {
                return objects;
            }
            double metric = this._engine.getMetric();
            y = max - min != 0.0 ? (double)(this._innerBounds.y + this._innerBounds.height) - (metric - min) / (max - min) * (double)this._innerBounds.height : (double)(this._innerBounds.y + this._innerBounds.height);
            objects.addAll(this.getTickMarkObject(map, new Point2D.Double(x, y), tmColor));
        }
        return objects;
    }

    private Collection getTickMarkObject(Map map, Point2D pt, Color tmColor) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(15);
        if (this._csParser != null && this._csParser.defines("tickMark") && this._scaleTransform != null && this._moveTransform != null) {
            Rectangle2D bounds = this._csParser.getBounds("tickMark");
            bounds = this._scaleTransform.createTransformedShape(bounds).getBounds2D();
            bounds = this._moveTransform.createTransformedShape(bounds).getBounds2D();
            AffineTransform move = new AffineTransform();
            move.translate(pt.getX() - this._tickMarkXPos, pt.getY() - (double)(this._innerBounds.y + this._innerBounds.height));
            double maxX = bounds.getX() + bounds.getWidth();
            this._tickMarkLength = (int)(maxX - this._tickMarkXPos);
            Color userColor = (Color)map.get("MajorTickColor");
            List<CustomShape> shapesList = this._csParser.getShapes("tickMark");
            int i = 0;
            while (i < shapesList.size()) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = this._scaleTransform.createTransformedShape(s);
                s = this._moveTransform.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csColor = userColor != null ? userColor : cs.getFillColor();
                objects.add(new DrawableObject.Shape(13, s, cs.getBorderColor(), csColor, cs.getSFXMap(), null));
                ++i;
            }
            return objects;
        }
        int tmLength = TICKMARK_LENGTH;
        double x = pt.getX();
        double y = pt.getY();
        objects.add(new DrawableObject.Shape(13, new Line2D.Double(x, y, x + (double)tmLength, y), tmColor, null, null, null));
        return objects;
    }

    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle").getString("No data");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int plotAreaWidth = this._innerBounds.width - 10;
        if (dim.width > plotAreaWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - 3 - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    protected int getGaugeRadius(int availWidth, int availHeight) {
        return availHeight;
    }

    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int reqAboveSpace = 0;
        int reqBelowSpace = 0;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        reqBelowSpace = this.getSpaceBelowPlotArea(map, g);
        if (map.get("TickLabelContent") == null || ((Integer)map.get("TickLabelContent") & 3) != 0) {
            Font tickLblFont = (Font)map.get("TickLabelFont");
            if (tickLblFont == null) {
                tickLblFont = GaugeDefaultValues.getTickLabelFont();
            }
            Dimension tickLblDim = DrawableObject.getLabelDimensions(g, tickLblFont, "W");
            reqBelowSpace += tickLblDim.height / 2 + 3;
            reqAboveSpace += tickLblDim.height / 2 + 3;
        }
        Rectangle bounds = this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
        return bounds;
    }

    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + rect.width / 2 - METER_WIDTH / 2;
        bounds.width = METER_WIDTH;
        if (this._csParser != null && (this._csParser.defines("plotArea") || this._csParser.defines("plotAreaBounds") || this._csParser.defines("gaugeFrame"))) {
            Rectangle2D csBounds = this._csParser.getBounds("plotArea");
            if (csBounds == null) {
                csBounds = this._csParser.getBounds("plotAreaBounds");
            }
            if (csBounds == null) {
                csBounds = this._csParser.getBounds("gaugeFrame");
            }
            double ratio = csBounds.getWidth() / csBounds.getHeight();
            bounds.width = (int)(ratio * (double)availHeight);
        }
        bounds.y = rect.y + reqAboveSpace;
        bounds.height = availHeight;
        if (bounds.height < 10) {
            bounds.height = 10;
            bounds.y = rect.y + (rect.height - bounds.height) / 2;
        }
        return bounds;
    }

    protected int getMaxNumberOfSteps() {
        return (int)Math.round(0.02 * (double)this._innerBounds.width);
    }

    protected Collection getGaugeFrameObject(Map map) {
        ArrayList objects = new ArrayList();
        return objects;
    }

    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        Color clr = GaugeDefaultValues.getGaugeFrameBorderColor();
        if (map.get("GaugeFrameBorderColor") != null) {
            clr = (Color)map.get("GaugeFrameBorderColor");
        }
        Rectangle tempBounds = new Rectangle(this._innerBounds.x - 1, this._innerBounds.y - 1, this._innerBounds.width, this._innerBounds.height);
        Color color = new Color(1.0f, 1.0f, 1.0f, 0.01f);
        objects.add(new DrawableObject.Shape(11, map, (Shape)tempBounds, null, color, null, null));
        return objects;
    }

    private void $init$() {
        this._labelsRight = false;
        this._tickMarkLength = TICKMARK_LENGTH;
    }
}

