/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphFont;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Annotation
extends BaseGraphComponent {
    protected SFX m_sfx;
    protected GraphFont m_font;
    protected IdentObj m_idBox;

    public Annotation(CommonGraph graph, int series, int group) {
        super(graph);
        this.$init$();
        this.m_identObj = this.m_pfj.createAnnotation(series, group);
        this.m_idBox = this.m_pfj.getAnnotationBox(this.m_identObj);
    }

    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_idBox);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_idBox, newColor);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_idBox);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBackground( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_idBox, newColor);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
        this.m_pfj.setDisplay(this.m_idBox, yesNo);
    }

    public GraphFont getGraphFont() {
        if (this.m_font == null) {
            this.m_font = new GraphFont(this.m_commonGraph, this.m_identObj);
        } else {
            this.m_font.setObjectId(this.m_identObj);
        }
        return this.m_font;
    }

    public void setFont(Font f) {
        this.getGraphFont();
        this.m_font.setFont(f);
    }

    public Font getFont() {
        this.getGraphFont();
        return this.m_font.getFont();
    }

    public String getText() {
        return this.m_pfj.getTextString(this.m_identObj);
    }

    public void setText(String str) {
        this.m_pfj.setTextString(this.m_identObj, str);
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public int getID() {
        return this.m_identObj.getMiscID();
    }

    protected String getComponentName() {
        return "Annotation";
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ObjectNode graphFont;
        ContainerNode sfxNode;
        boolean nodeExists = false;
        ObjectNode node = new ObjectNode(this.getComponentName());
        Object val = this.m_pfj.getTextString(this.m_identObj);
        if (val != null) {
            node.addProperty("text", (String)val);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getFillColor(this.m_identObj)) != null) {
            node.addProperty("fillColor", Annotation.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        if ((graphFont = this.getGraphFont().getXML(allProperties)) != null) {
            node.addProperty(graphFont);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public void setXML(ObjectNode aNode, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(aNode);
        }
        catch (Exception e) {
            this.m_jsfHashMap = null;
        }
    }

    public void setXML(ObjectNode aNode) {
        ObjectNode graphFont;
        ContainerNode sfx;
        PropertyNode pNode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.m_jsfHashMap != null) {
            this.m_jsfHashMap.put(new Integer(this.m_identObj.getMiscID()), map);
        }
        if ((pNode = aNode.getProperty("text")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("text", pNode.getValueAsString());
            } else {
                this.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = aNode.getProperty("fillColor")) != null) {
            Color c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(Annotation.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                map.put("fillColor", c);
            } else {
                this.setFillColor(c);
            }
        }
        if ((sfx = aNode.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, true);
        }
        if ((graphFont = aNode.getPropertyValueAsObjectNode("GraphFont", true)) != null) {
            if (this.m_jsfHashMap != null) {
                map = new HashMap();
                this.m_jsfHashMap.put("GraphFont", map);
                this.getGraphFont().setXML(graphFont, map);
            } else {
                this.getGraphFont().setXML(graphFont);
            }
        }
    }

    private void $init$() {
        this.m_idBox = null;
    }
}

