/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DateGroupLabels;
import oracle.dss.graph.pfj.FunnelLabelContainer;
import oracle.dss.graph.pfj.FunnelSliceLabelContainer;
import oracle.dss.graph.pfj.FunnelStageLabelContainer;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.TitleObj;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.presutil.FontMetricsResolver;

public class BILabelLayout {
    private static final int MINIMUM_FRAME_DEPTH = 3000;
    private static final int MINIMUM_FRAME_EXTENT = 8000;
    private static final double MIN_FONTHEIGHT_RATIO = 1.0;
    private static final double MIN_FONTHEIGHT_RATIO_WRAP = 1.5;
    private static final int MIMIMUM_SIGNIFICANT_SHIFT = 100;
    private static final int DEFAULT_LABEL_MARGIN = 100;
    private static final int DEFAULT_WRAPPING_DEPTH = 40;
    private static final int MINIMUM_WRAPPING_GAIN = 15;
    private static final int WRAPPING_DEPTH_INCREMENT = 3;
    private static final int MAX_ROTATED_WRAPPED_LINES = 5;
    private static final int DEFAULT_MARGIN = 10;
    private static final int PAIR_MARGIN = 5;
    private static final int DEFAULT_AXIS_TITLE_MARGIN = 10;
    private static final int DEFAULT_AXIS_MARGIN_INSIDE = 5;
    private static final int INTERSECTING_EXTRA_MARGIN = 3;
    private static final int SIGNIFICANT_DIFF = 1000;
    private static final int LB_PLAIN = 0;
    private static final int LB_STAGGERED = 1;
    private static final int LB_WORDWRAPPED = 2;
    private static final int LB_ROTATED = 3;
    private static final int LEFT_SIDE = 0;
    private static final int TOP_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BOTTOM_SIDE = 3;
    private static final int GRAPH_MARGIN = 10;
    private static final int GRAPH_LEGEND_GAP = 10;
    private static final int FUNNEL_VERT_MARGIN = 7;
    private int m_commonGraphMarginV;
    private int m_commonGraphMarginH;
    private int m_commonGraphLegendGapV;
    private int m_commonGraphLegendGapH;
    private int m_maxBottomY;
    private boolean m_reset;
    private boolean m_legendDisplay;
    private boolean m_plotAreaDisplay;
    private CommonGraph m_commonGraph;

    public BILabelLayout(CommonGraph graph) {
        this.$init$();
        this.m_commonGraph = graph;
    }

    public boolean isAutoLayoutEnabled() {
        return this.m_reset || this.m_commonGraph.getAutoLayout() == 1 || this.m_commonGraph.getAutoLayout() == 2;
    }

    public void doAutoLayoutAndReset(boolean reset) {
        this.m_reset = reset;
    }

    public void logTruncatedError(IdentObj idObj) {
        if (idObj.getObjectID() == this.m_commonGraph.getPFJ().getLegendArea().getObjectID()) {
            this.m_commonGraph.processAlertEvent(0);
            this.m_commonGraph.getErrorHandler().trace("legend text truncated", this.getClass().getName(), "logTruncatedError");
        } else if (idObj.getObjectID() == this.m_commonGraph.getPFJ().getO1Label().getObjectID()) {
            if (this.m_commonGraph.getGraphType() == 100) {
                this.m_commonGraph.processAlertEvent(15);
                this.m_commonGraph.getErrorHandler().trace("O1 Labels truncated", this.getClass().getName(), "logTruncatedError");
            } else {
                this.m_commonGraph.processAlertEvent(13);
                this.m_commonGraph.getErrorHandler().trace("O1 Labels truncated", this.getClass().getName(), "logTruncatedError");
            }
        } else if (idObj.getObjectID() == 295 || idObj.getObjectID() == 622) {
            this.m_commonGraph.processAlertEvent(14);
            this.m_commonGraph.getErrorHandler().trace("Slice Labels truncated", this.getClass().getName(), "logTruncatedError");
        } else {
            this.m_commonGraph.processAlertEvent(2);
            this.m_commonGraph.getErrorHandler().trace("axis title truncated", this.getClass().getName(), "logTruncatedError");
        }
    }

    public void logAllMarkersError() {
        this.m_commonGraph.processAlertEvent(1);
        this.m_commonGraph.getErrorHandler().log("All legend markers are not displayed", this.getClass().getName(), "logAllMarkersError");
    }

    public boolean adjustProperties(Perspective pfj, Access access, JChart_Base chart, int ordType, LegendObj legend, TitleObj title, TitleObj subtitle, TitleObj footnote, Vector[] dataLabels, Object context, boolean plotAreaDisplay) {
        this.m_plotAreaDisplay = plotAreaDisplay;
        int graphType = this.m_commonGraph.getGraphType();
        this._setLegendDisplayed(legend);
        if (graphType >= 0 && graphType <= 14 && graphType != 12) {
            return false;
        }
        Graphics g = pfj.getGraphicsContext();
        boolean hasO1 = pfj.getJGraphType().getAxisDescriptor().hasO1() || pfj.isContinuousTimeAxis();
        boolean circular = chart instanceof JChart_2D_Circular;
        if (graphType == 12 || this.m_reset || this.m_commonGraph.getAutoLayout() == 2 || !this._isTitlesLayoutValid(pfj, g) || !this._isLegendLayoutValid(pfj, legend, g) || hasO1 && !this.isO1LabelsLayoutValid(pfj, g, access, ordType, context, circular, this.m_commonGraph) || !this.isDataAxisLayoutValid(pfj, g, dataLabels, context, this.m_commonGraph, circular)) {
            if (graphType != 12) {
                pfj.setAdditionalBottomAxisMargin(0);
                VC vc = pfj.getVC();
                this.m_commonGraphMarginV = vc.destToVirtHeight(10);
                this.m_commonGraphMarginH = vc.destToVirtWidth(10);
                this.m_commonGraphLegendGapV = vc.destToVirtHeight(10);
                this.m_commonGraphLegendGapH = vc.destToVirtWidth(10);
            }
            if (this._isLegendDisplayed() && this.m_commonGraph.getLegendArea().getAutomaticPlacement() == 1) {
                int position = this.m_commonGraph.getLegendArea().calcAutomaticPosition();
                if (this.m_reset) {
                    this.m_commonGraph.getLegendArea().setPosition(position);
                } else {
                    this.m_commonGraph.getLegendArea().setAutomaticPosition(position, this.m_reset);
                }
            }
            if (graphType == 12) {
                return true;
            }
            boolean alongEdge = this.m_commonGraph.getLegendArea().isAlongGraphEdge();
            if (alongEdge) {
                this.doLegendAutoLayout(g, legend, access, chart, pfj, this.m_reset, graphType, false);
                this.doTitlesAutoLayout(g, pfj, title, subtitle, footnote, alongEdge);
            } else {
                this.doTitlesAutoLayout(g, pfj, title, subtitle, footnote, alongEdge);
                this.doLegendAutoLayout(g, legend, access, chart, pfj, this.m_reset, graphType, false);
            }
            this.maximizePlotArea(legend, pfj, chart);
            if (graphType == 55) {
                this.doLegendAutoLayout(g, legend, access, chart, pfj, this.m_reset, graphType, true);
            }
            if (this.m_reset) {
                this.m_commonGraph.getLegendArea().setRectDefault(false);
            }
            if (graphType != 100) {
                this.doDataAxisAutoLayout(pfj, g, dataLabels, context, circular);
            } else {
                this.doFunnelLabelsAutoLayout(pfj, dataLabels);
            }
            if (hasO1 && graphType != 100) {
                this.doO1LabelsAutoLayout(pfj, g, access, ordType, context, circular, this.m_commonGraph);
            }
            this.centerLegend(pfj, legend);
            this.readjustTitles(pfj, alongEdge);
        }
        IdentObj idLabel = pfj.getO1Label();
        pfj.putToLookNoCalc(idLabel, Attr.Autofit, new Boolean(false), this.m_reset ^ true);
        pfj.putToLookNoCalc(new IdentObj(2000), Attr.O1LabelAutoAngle, new Integer(0), this.m_reset ^ true);
        pfj.putToLookNoCalc(pfj.getX1Title(), Attr.TitleTextWrap, Boolean.FALSE, this.m_reset ^ true);
        pfj.putToLookNoCalc(pfj.getY1Title(), Attr.TitleTextWrap, Boolean.FALSE, this.m_reset ^ true);
        pfj.putToLookNoCalc(pfj.getY2Title(), Attr.TitleTextWrap, Boolean.FALSE, this.m_reset ^ true);
        pfj.putToLookNoCalc(BILabelLayout.getO1AxisTitle(pfj), Attr.TitleTextWrap, Boolean.FALSE, this.m_reset ^ true);
        if (pfj.getAutoSkip(idLabel) == 1) {
            pfj.putToLookNoCalc(idLabel, Attr.AutoSkip, new Integer(0), this.m_reset ^ true);
        }
        if (this.m_commonGraph.isHorizontal()) {
            pfj.putToLookNoCalc(pfj.getY1Label(), Attr.RightTextJustHoriz, new Integer(0), this.m_reset ^ true);
            pfj.putToLookNoCalc(pfj.getY2Label(), Attr.RightTextJustHoriz, new Integer(0), this.m_reset ^ true);
        } else {
            pfj.putToLookNoCalc(pfj.getY1Label(), Attr.RightTextJustHoriz, new Integer(4), this.m_reset ^ true);
            pfj.putToLookNoCalc(pfj.getY2Label(), Attr.RightTextJustHoriz, new Integer(4), this.m_reset ^ true);
        }
        return true;
    }

    public void restoreProperties(Perspective pfj, Object context) {
    }

    public Object createContext() {
        return new _PropertyContext(null);
    }

    private void doCircularLabelsAutoLayout(Perspective pfj, Graphics g, Access access, Vector labels, boolean dataAxis) {
        int reqLeftWidth = 0;
        int reqRightWidth = 0;
        int reqTopHeight = 0;
        int reqBottomHeight = 0;
        Rectangle frameRect = pfj.getRect(pfj.getFrame());
        IdentObj labelsID = null;
        labelsID = dataAxis ? pfj.getX1Label() : pfj.getO1Label();
        if (pfj.getTextRotation(labelsID) != 0) {
            reqLeftWidth = reqRightWidth = (int)((double)frameRect.width * 0.1);
            reqBottomHeight = reqTopHeight = (int)((double)frameRect.height * 0.1);
            if (reqRightWidth > 0) {
                frameRect.width -= reqRightWidth;
            }
            if (reqLeftWidth > 0) {
                frameRect.x += reqLeftWidth;
                frameRect.width -= reqLeftWidth;
            }
            if (reqTopHeight > 0) {
                frameRect.height -= reqTopHeight + pfj.getVC().destToVirtHeight(10);
            }
            if (reqBottomHeight > 0) {
                frameRect.height -= reqBottomHeight + pfj.getVC().destToVirtHeight(10);
                frameRect.y = frameRect.y + reqBottomHeight + pfj.getVC().destToVirtHeight(10);
            }
            pfj.putToLookNoCalc(pfj.getFrame(), Attr.FrameRect, frameRect, this.m_reset ^ true);
            return;
        }
        Rectangle legendRect = this.m_commonGraph.getLegendArea().getRect();
        int start = 0;
        int stop = 0;
        if (access != null) {
            DataRange dr = access.getViewableDataRangeSG(pfj);
            start = dr.getColStart();
            stop = dr.getColStop();
        } else if (labels != null) {
            start = 0;
            stop = labels.size() - 1;
        } else {
            return;
        }
        int nNumLabels = stop - start + 1;
        FontMetrics fm = BILabelLayout.getFontMetrics(g, pfj, labelsID);
        int fontHeight = BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver());
        double spaceBetGroups = 1.0;
        if (nNumLabels > 1) {
            spaceBetGroups = 1.0 / (double)nNumLabels;
        }
        int position = this.m_commonGraph.getLegendArea().getAutomaticPosition();
        int leftX = -16000;
        int rightX = 16000;
        if (pfj.getDisplay(pfj.getLegendArea()) && position == 3) {
            leftX = legendRect.x + legendRect.width;
        } else if (pfj.getDisplay(pfj.getLegendArea()) && position == 2) {
            rightX = legendRect.x;
        }
        int numLabelsOnTop = 0;
        int numLabelsOnBottom = 0;
        int numLabelsOnRight = 0;
        int numLabelsOnLeft = 0;
        int i = start;
        while (i <= stop) {
            Rectangle r;
            double offset = (double)i * spaceBetGroups;
            double angle = CircularAxisObj.getAngleFromRelAngle(offset, pfj);
            Point pt = new Point(0, 0);
            Point centerFramePosVC = new Point();
            centerFramePosVC.x = frameRect.x + frameRect.width / 2;
            centerFramePosVC.y = frameRect.y + frameRect.height / 2;
            Dimension frameDim = new Dimension();
            frameDim.width = frameRect.width;
            frameDim.height = frameRect.height;
            Dimension dim = pfj.getVC().getVirtDimension();
            CircularAxisObj.polarToCartesian(pt, angle, 1.0, frameDim, centerFramePosVC, pfj.getVC());
            String label = null;
            label = dataAxis ? (String)labels.elementAt(i) : pfj.getGroupLabel(i);
            int labelWidth = 0;
            if (label != null) {
                labelWidth = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) + pfj.getVC().destToVirtWidth(10);
            }
            if (angle > 355.0 || angle < 5.0) {
                int maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                r = new Rectangle(pt.x, pt.y - maxHalfHeight, dim.width / 2 - pt.x, 2 * maxHalfHeight);
                if (labelWidth > rightX - pt.x && reqRightWidth < labelWidth - (rightX - pt.x)) {
                    reqRightWidth = labelWidth - (rightX - pt.x);
                }
                ++numLabelsOnRight;
            } else if (angle < 80.0) {
                r = new Rectangle(pt.x, pt.y, dim.width / 2 - pt.x, dim.height / 2 - pt.y);
                if (labelWidth > rightX - pt.x && reqRightWidth < labelWidth - (rightX - pt.x)) {
                    reqRightWidth = labelWidth - (rightX - pt.x);
                }
                ++numLabelsOnRight;
            } else if (angle < 100.0) {
                if (reqBottomHeight < pfj.getVC().destToVirtHeight(fontHeight)) {
                    reqBottomHeight = pfj.getVC().destToVirtHeight(fontHeight);
                }
                ++numLabelsOnBottom;
            } else if (angle < 175.0) {
                r = new Rectangle(-dim.width / 2, pt.y, pt.x + dim.width / 2, dim.height / 2 - pt.y);
                if (labelWidth > pt.x - leftX && reqLeftWidth < labelWidth - (pt.x - leftX)) {
                    reqLeftWidth = labelWidth - (pt.x - leftX);
                }
                ++numLabelsOnLeft;
            } else if (angle < 185.0) {
                int maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                r = new Rectangle(-dim.width / 2, pt.y - maxHalfHeight, pt.x + dim.width / 2, 2 * maxHalfHeight);
                if (labelWidth > pt.x - leftX && reqLeftWidth < labelWidth - (pt.x - leftX)) {
                    reqLeftWidth = labelWidth - (pt.x - leftX);
                }
                ++numLabelsOnLeft;
            } else if (angle < 260.0) {
                r = new Rectangle(-dim.width / 2, -dim.height / 2, pt.x + dim.width / 2, dim.height / 2 + pt.y);
                if (labelWidth > pt.x - leftX && reqLeftWidth < labelWidth - (pt.x - leftX)) {
                    reqLeftWidth = labelWidth - (pt.x - leftX);
                }
                ++numLabelsOnLeft;
            } else if (angle < 280.0) {
                if (reqTopHeight < pfj.getVC().destToVirtHeight(fontHeight)) {
                    reqTopHeight = pfj.getVC().destToVirtHeight(fontHeight);
                }
                ++numLabelsOnTop;
            } else {
                r = new Rectangle(pt.x, -dim.height / 2, dim.width / 2 - pt.x, pt.y + dim.height / 2);
                if (labelWidth > rightX - pt.x && reqRightWidth < labelWidth - (rightX - pt.x)) {
                    reqRightWidth = labelWidth - (rightX - pt.x);
                }
                ++numLabelsOnRight;
            }
            ++i;
        }
        int frameWidthDC = pfj.getVC().virtToDestWidth(frameRect.width);
        int notReqd = 0;
        int Reqd = 1;
        int notPossible = 2;
        int wordwrapRight = notReqd;
        if (reqRightWidth > frameRect.width / 4 && !dataAxis) {
            wordwrapRight = Reqd;
            reqRightWidth = frameRect.width / 4;
            int labelHeightDC = frameWidthDC / 2 / Math.max(numLabelsOnRight, numLabelsOnLeft);
            if (labelHeightDC >= fontHeight * 3) {
                if (reqTopHeight > 0) {
                    reqTopHeight += pfj.getVC().destToVirtHeight(fontHeight);
                }
                if (reqBottomHeight > 0) {
                    reqBottomHeight += pfj.getVC().destToVirtHeight(fontHeight);
                }
            } else {
                wordwrapRight = notPossible;
            }
        }
        int wordwrapLeft = notReqd;
        if (reqLeftWidth > frameRect.width / 4 && !dataAxis) {
            wordwrapLeft = Reqd;
            reqLeftWidth = frameRect.width / 4;
            int labelHeightDC = frameWidthDC / 2 / Math.max(numLabelsOnRight, numLabelsOnLeft);
            if (labelHeightDC >= fontHeight * 3) {
                if (reqTopHeight > 0) {
                    reqTopHeight += pfj.getVC().destToVirtHeight(fontHeight);
                }
                if (reqBottomHeight > 0) {
                    reqBottomHeight += pfj.getVC().destToVirtHeight(fontHeight);
                }
            } else {
                wordwrapLeft = notPossible;
            }
        }
        boolean wordwrap = false;
        if (wordwrapRight == notPossible || wordwrapLeft == notPossible) {
            wordwrap = false;
        } else if (wordwrapRight == Reqd || wordwrapLeft == Reqd) {
            wordwrap = true;
        }
        if (reqRightWidth > 0) {
            frameRect.width -= reqRightWidth;
        }
        if (reqLeftWidth > 0) {
            frameRect.x += reqLeftWidth;
            frameRect.width -= reqLeftWidth;
        }
        if (reqTopHeight > 0) {
            frameRect.height -= reqTopHeight;
        }
        if (reqBottomHeight > 0) {
            frameRect.height -= reqBottomHeight;
            frameRect.y += reqBottomHeight;
        }
        pfj.putToLookNoCalc(pfj.getFrame(), Attr.FrameRect, frameRect, this.m_reset ^ true);
        pfj.putToLookNoCalc(labelsID, Attr.TextWrap, new Boolean(wordwrap), this.m_reset ^ true);
    }

    private boolean isCircularLabelsLayoutValid(Perspective pfj, Graphics g, Access access, CommonGraph graph, boolean dataAxis, Vector labels) {
        if (!this.m_plotAreaDisplay) {
            return true;
        }
        int start = 0;
        int stop = 0;
        if (access != null) {
            DataRange dr = access.getViewableDataRangeSG(pfj);
            start = dr.getColStart();
            stop = dr.getColStop();
        } else if (labels != null) {
            start = 0;
            stop = labels.size() - 1;
        } else {
            return false;
        }
        int nNumLabels = stop - start + 1;
        IdentObj labelsID = null;
        labelsID = dataAxis ? pfj.getX1Label() : pfj.getO1Label();
        FontMetrics fm = BILabelLayout.getFontMetrics(g, pfj, labelsID);
        int fontHeight = BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver());
        double spaceBetGroups = 1.0 / (double)nNumLabels;
        Rectangle frameRect = pfj.getRect(pfj.getFrame());
        int position = graph.getLegendArea().getPosition();
        Rectangle legendRect = graph.getLegendArea().getRect();
        int leftWidth = Math.abs(-16000 - frameRect.x);
        int rightWidth = 16000 - (frameRect.x + frameRect.width);
        int leftX = -16000;
        int rightX = 16000;
        if (position == 3) {
            leftWidth = frameRect.x - (legendRect.x + legendRect.width);
            leftX = legendRect.x + legendRect.width;
        } else if (position == 2) {
            rightWidth = legendRect.x - (frameRect.x + frameRect.width);
            rightX = legendRect.x;
        }
        if (leftWidth < 0 || rightWidth < 0) {
            return false;
        }
        int i = start;
        while (i <= stop) {
            Rectangle r;
            double offset = (double)i * spaceBetGroups + spaceBetGroups / 2.0;
            double angle = CircularAxisObj.getAngleFromRelAngle(offset, pfj);
            Point pt = new Point(0, 0);
            Point centerFramePosVC = new Point();
            centerFramePosVC.x = frameRect.x + frameRect.width / 2;
            centerFramePosVC.y = frameRect.y + frameRect.height / 2;
            Dimension frameDim = new Dimension();
            frameDim.width = frameRect.width;
            frameDim.height = frameRect.height;
            Dimension dim = pfj.getVC().getVirtDimension();
            CircularAxisObj.polarToCartesian(pt, angle, 1.0, frameDim, centerFramePosVC, pfj.getVC());
            String label = null;
            label = dataAxis ? (String)labels.elementAt(i) : pfj.getGroupLabel(i);
            if (angle > 355.0 || angle < 5.0) {
                int maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                r = new Rectangle(pt.x, pt.y - maxHalfHeight, dim.width / 2 - pt.x, 2 * maxHalfHeight);
                if (label != null && pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) > rightX - pt.x) {
                    return false;
                }
            } else if (angle < 80.0) {
                r = new Rectangle(pt.x, pt.y, dim.width / 2 - pt.x, dim.height / 2 - pt.y);
                if (label != null && pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) > rightX - pt.x) {
                    return false;
                }
            } else if (!(angle < 100.0)) {
                if (angle < 175.0) {
                    r = new Rectangle(-dim.width / 2, pt.y, pt.x + dim.width / 2, dim.height / 2 - pt.y);
                    if (label != null && pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) > pt.x - leftX) {
                        return false;
                    }
                } else if (angle < 185.0) {
                    int maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(-dim.width / 2, pt.y - maxHalfHeight, pt.x + dim.width / 2, 2 * maxHalfHeight);
                    if (label != null && pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) > pt.x - leftX) {
                        return false;
                    }
                } else if (angle < 260.0) {
                    r = new Rectangle(-dim.width / 2, -dim.height / 2, pt.x + dim.width / 2, dim.height / 2 + pt.y);
                    if (label != null && pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) > pt.x - leftX) {
                        return false;
                    }
                } else if (!(angle < 280.0)) {
                    r = new Rectangle(pt.x, -dim.height / 2, dim.width / 2 - pt.x, pt.y + dim.height / 2);
                    if (label != null && pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(label, fm)) > rightX - pt.x) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isO1LabelsLayoutValid(Perspective pfj, Graphics g, Access access, int ordType, Object context, boolean circular, CommonGraph graph) {
        int depth;
        int extent;
        if (!this.m_plotAreaDisplay) {
            return true;
        }
        if (circular) {
            return this.isCircularLabelsLayoutValid(pfj, g, access, graph, false, null);
        }
        IdentObj idLabel = pfj.getO1Label();
        if (!pfj.getDisplay(idLabel)) {
            return true;
        }
        boolean bMarksOnEdge = ordType == 6;
        FontMetrics fm = BILabelLayout.getFontMetrics(g, pfj, idLabel);
        int fontHeight = BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver());
        int rotation = pfj.getTextRotation(idLabel);
        boolean rotated = rotation == 1 || rotation == 2;
        boolean isVertical = pfj.isChartOrientHorz();
        int labelGap = 0;
        labelGap = isVertical && !rotated || !isVertical && rotated ? 5 : TextStyleObj.calcAxisLabelGap(fm.getFont().getSize());
        if (pfj.isTimeAxis()) {
            Rectangle extra;
            Rectangle extra2;
            int nested_extent;
            Rectangle nestedSpace = BILabelLayout.getLabelSpace(g, pfj, BILabelLayout.getO1AxisTitle(pfj), pfj.getRect(pfj.getFrame()));
            int nest_label_extent = nested_extent = pfj.getVC().virtToDestWidth(nestedSpace.width);
            DateGroupLabels dgLabels = (DateGroupLabels)pfj.getO1LabelCallBack();
            Vector labels = dgLabels.getAllLabels(0);
            int numLabels = labels.size();
            if (!bMarksOnEdge) {
                nest_label_extent = nested_extent / numLabels;
            } else if (numLabels > 1) {
                nest_label_extent = nested_extent / (numLabels - 1);
            }
            int skipped_at_beg = 0;
            int skipped_at_end = (numLabels - 1) % (pfj.getNestedSkipCount(0) + 1);
            int last = numLabels - 1 - skipped_at_end;
            int first_offset = skipped_at_beg * nest_label_extent;
            int last_offset = skipped_at_end * nest_label_extent;
            if (!bMarksOnEdge) {
                first_offset += nest_label_extent / 2;
                last_offset += nest_label_extent / 2;
            }
            int first_req = pfj.getFontMetricsResolver().stringWidth((String)labels.elementAt(0), fm) / 2;
            int last_req = pfj.getFontMetricsResolver().stringWidth((String)labels.elementAt(last), fm) / 2;
            int left_extra = first_req - first_offset;
            if (left_extra > 0 && BILabelLayout.intersectsComponents(pfj, extra2 = new Rectangle(nestedSpace.x - (left_extra = pfj.getVC().destToVirtWidth(left_extra)), nestedSpace.y, left_extra, nestedSpace.height))) {
                return false;
            }
            int right_extra = last_req - last_offset;
            if (right_extra > 0 && BILabelLayout.intersectsComponents(pfj, extra = new Rectangle(nestedSpace.x + nestedSpace.width, nestedSpace.y, right_extra = pfj.getVC().destToVirtWidth(right_extra), nestedSpace.height))) {
                return false;
            }
            int titleHeight = BILabelLayout.getAxisTitleHeight(g, pfj, BILabelLayout.getO1AxisTitle(pfj), false);
            int labelsHeight = fontHeight;
            if (dgLabels.getAllLabels(1) == null) return nestedSpace.height >= pfj.getVC().destToVirtHeight(titleHeight + labelsHeight);
            labelsHeight *= 2;
            return nestedSpace.height >= pfj.getVC().destToVirtHeight(titleHeight + labelsHeight);
        }
        DataRange dr = access.getViewableDataRangeSG(pfj);
        int start = dr.getColStart();
        int stop = dr.getColStop();
        int nNumLabels = stop - start + 1;
        if (nNumLabels < 1) {
            return true;
        }
        String[] labels = new String[nNumLabels];
        int j = 0;
        int i = start;
        while (i <= stop) {
            labels[j++] = pfj.getGroupLabel(i);
            ++i;
        }
        ((_PropertyContext)context).m_O1Labels = labels;
        Rectangle rFrame = pfj.getRect(pfj.getFrame());
        Rectangle space = BILabelLayout.getLabelSpace(g, pfj, BILabelLayout.getO1AxisTitle(pfj), rFrame);
        if (isVertical) {
            extent = pfj.getVC().virtToDestHeight(space.height);
            depth = pfj.getVC().virtToDestWidth(space.width);
        } else {
            extent = pfj.getVC().virtToDestWidth(space.width);
            depth = pfj.getVC().virtToDestHeight(space.height);
        }
        int currentSkip = 0;
        int currentSkipStart = 0;
        if (pfj.getAutoSkip(idLabel) == 2 && (currentSkip = pfj.getSkipCount(idLabel)) > 0) {
            currentSkipStart = pfj.getSkipBegin(idLabel);
            if (currentSkipStart >= nNumLabels) {
                currentSkipStart = 0;
            } else if (currentSkipStart > currentSkip) {
                currentSkipStart %= currentSkip + 1;
            }
        }
        int currentLabelsAfterSkip = (nNumLabels - currentSkipStart + currentSkip) / (currentSkip + 1);
        boolean staggered = pfj.getLabelStagger(idLabel);
        boolean wordWrapped = pfj.getTextWrap(idLabel);
        if (bMarksOnEdge || currentSkip > 0 || staggered || currentLabelsAfterSkip == 1) {
            int right_extra;
            int label_extent = extent;
            if (!bMarksOnEdge) {
                label_extent = extent / nNumLabels;
            } else if (nNumLabels > 1) {
                label_extent = extent / (nNumLabels - 1);
            }
            int skipped_at_beg = currentSkipStart;
            int skipped_at_end = (nNumLabels - currentSkipStart - 1) % (currentSkip + 1);
            int last = nNumLabels - 1 - skipped_at_end;
            int first_offset = skipped_at_beg * label_extent;
            int last_offset = skipped_at_end * label_extent;
            if (!bMarksOnEdge) {
                first_offset += label_extent / 2;
                last_offset += label_extent / 2;
            }
            int first_req = 0;
            int last_req = 0;
            if (isVertical && !rotated || !isVertical && rotated) {
                last_req = first_req = fontHeight / 2;
            } else if (wordWrapped) {
                int c_extent = label_extent;
                if (staggered) {
                    c_extent *= 2;
                }
                last_req = first_req = (int)((double)(c_extent - labelGap) / 2.0);
            } else {
                first_req = pfj.getFontMetricsResolver().stringWidth(labels[0], fm) / 2;
                last_req = pfj.getFontMetricsResolver().stringWidth(labels[last], fm) / 2;
            }
            int left_extra = first_req - first_offset;
            if (left_extra > 0) {
                Rectangle extra;
                if (isVertical) {
                    left_extra = pfj.getVC().destToVirtHeight(left_extra);
                    extra = new Rectangle(space.x, space.y + space.height, space.width, left_extra);
                } else {
                    left_extra = pfj.getVC().destToVirtWidth(left_extra);
                    extra = new Rectangle(space.x - left_extra, space.y, left_extra, space.height);
                }
                if (BILabelLayout.intersectsComponents(pfj, extra)) {
                    return false;
                }
            }
            if ((right_extra = last_req - last_offset) > 0) {
                Rectangle extra;
                if (isVertical) {
                    right_extra = pfj.getVC().destToVirtHeight(right_extra);
                    extra = new Rectangle(space.x, space.y - right_extra, space.width, right_extra);
                } else {
                    right_extra = pfj.getVC().destToVirtWidth(right_extra);
                    extra = new Rectangle(space.x + space.width, space.y, right_extra, space.height);
                }
                if (BILabelLayout.intersectsComponents(pfj, extra)) {
                    return false;
                }
            }
        }
        int nMaxLabels = (int)((double)extent / ((double)fontHeight * 1.0));
        if (bMarksOnEdge) {
            ++nMaxLabels;
        }
        if (nMaxLabels <= 0) {
            nMaxLabels = 1;
        }
        if (currentLabelsAfterSkip > nMaxLabels) {
            return false;
        }
        if (currentLabelsAfterSkip <= 1) return true;
        int cellExtent = 0;
        int cellDepth = 0;
        if (isVertical && rotated || !isVertical && !rotated) {
            cellDepth = depth;
            cellExtent = !bMarksOnEdge || nNumLabels == 1 ? extent / nNumLabels : extent / (nNumLabels - 1);
            if (staggered) {
                cellDepth /= 2;
                cellExtent *= 2;
            }
            if (nNumLabels > 1) {
                cellExtent -= labelGap;
            }
            cellExtent *= currentSkip + 1;
        } else {
            cellExtent = depth;
            cellDepth = !bMarksOnEdge || nNumLabels == 1 ? extent / nNumLabels : extent / (nNumLabels - 1);
            if (staggered) {
                cellDepth *= 2;
                cellExtent /= 2;
                cellExtent -= labelGap;
            }
            cellDepth *= currentSkip + 1;
        }
        if (cellDepth < fontHeight) {
            return false;
        }
        int[] lengths = new int[currentLabelsAfterSkip];
        int maxWidth = BILabelLayout.getLongestLabelWidth(fm, labels, currentSkip, currentSkipStart, lengths, pfj.getFontMetricsResolver());
        if (!wordWrapped) {
            if (maxWidth <= cellExtent) return true;
            if (isVertical || rotated) return false;
            int step = 1;
            if (staggered) {
                step = 2;
            }
            if (BILabelLayout.verifyPairLengths(lengths, step, cellExtent - 5)) return true;
            return false;
        }
        if (cellExtent * (cellDepth / fontHeight) >= maxWidth && -1 != BILabelLayout.wordWrap(fm, labels, currentSkip, currentSkipStart, cellExtent, cellDepth, pfj.getFontMetricsResolver())) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doO1LabelsAutoLayout(Perspective pfj, Graphics g, Access access, int ordType, Object context, boolean circular, CommonGraph graph) {
        Rectangle rect2;
        Rectangle rect1;
        int skipForRotate;
        boolean layoutResolved;
        int skipstart;
        int skip;
        boolean wordwrap;
        boolean rotate;
        boolean stagger;
        boolean canSkip;
        boolean canRotate;
        int autorotate;
        int nNumLabels;
        String[] labels;
        int extent;
        int virtExtent;
        Point p;
        Rectangle rFrame;
        int labelGapV;
        int labelGapH;
        int fontHeight;
        FontMetrics fm;
        boolean isVertical;
        boolean bMarksOnEdge;
        IdentObj idLabel;
        block98: {
            block99: {
                Rectangle rLegend;
                int titleHeight;
                if (!this.m_plotAreaDisplay) {
                    return;
                }
                if (circular) {
                    this.doCircularLabelsAutoLayout(pfj, g, access, null, false);
                    return;
                }
                idLabel = null;
                idLabel = pfj.isContinuousTimeAxis() ? pfj.getX1Label() : pfj.getO1Label();
                if (!pfj.getDisplay(idLabel)) {
                    return;
                }
                boolean bl = bMarksOnEdge = ordType == 6;
                if (pfj.isContinuousTimeAxis()) {
                    bMarksOnEdge = true;
                }
                isVertical = pfj.isChartOrientHorz();
                fm = BILabelLayout.getFontMetrics(g, pfj, idLabel);
                fontHeight = BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver());
                labelGapH = TextStyleObj.calcAxisLabelGap(fm.getFont().getSize());
                labelGapV = 5;
                rFrame = new Rectangle(pfj.getRect(pfj.getFrame()));
                if (isVertical) {
                    titleHeight = BILabelLayout.getAxisTitleHeight(g, pfj, BILabelLayout.getO1AxisTitle(pfj), true);
                    rFrame.x += titleHeight;
                    rFrame.width -= titleHeight;
                } else {
                    titleHeight = BILabelLayout.getAxisTitleHeight(g, pfj, BILabelLayout.getO1AxisTitle(pfj), false);
                    rFrame.y += titleHeight;
                    rFrame.height -= titleHeight;
                }
                p = BILabelLayout.adjustFrameFor3D(pfj, rFrame);
                if (isVertical) {
                    p.y -= 100;
                    virtExtent = rFrame.height + 200;
                    extent = pfj.getVC().virtToDestHeight(virtExtent);
                } else {
                    p.x -= 100;
                    virtExtent = rFrame.width + 200;
                    extent = pfj.getVC().virtToDestWidth(virtExtent);
                }
                if (extent <= 0) {
                    return;
                }
                if (pfj.isTimeAxis() || pfj.isContinuousTimeAxis()) {
                    int right_space;
                    int reqHt;
                    Rectangle rLegend2;
                    int extra = rFrame.height - 3000;
                    if (extra <= 0) {
                        return;
                    }
                    int margin = pfj.getVC().destToVirtWidth(10);
                    int vert_margin = pfj.getVC().destToVirtHeight(10);
                    Rectangle virtual = pfj.getVC().getVirtCoords();
                    Rectangle rect12 = null;
                    Rectangle rect22 = null;
                    Rectangle rFull = new Rectangle(virtual.x + margin, p.y, virtual.width - 2 * margin, extra);
                    rect12 = new Rectangle(rFull);
                    rect22 = null;
                    IdentObj legend = pfj.getLegendArea();
                    if (this._isLegendDisplayed() && rFull.intersects(rLegend2 = pfj.getRect(legend))) {
                        Rectangle intct = rFull.intersection(rLegend2);
                        if (intct.x > p.x) {
                            if (intct.y <= rFull.y) {
                                rect12.width = intct.x - rect12.x - margin;
                            } else {
                                rect22 = new Rectangle(rFull.x, rFull.y, intct.x - rFull.x - margin, rFull.height);
                                rect12.height = intct.y - rFull.y - vert_margin;
                            }
                        } else {
                            int newX = intct.x + intct.width + margin;
                            if (intct.y <= rFull.y) {
                                rect12.x = newX;
                                rect12.width = rFull.x + rFull.width - newX;
                            } else {
                                rect22 = new Rectangle(newX, rFull.y, rFull.x + rFull.width - newX, virtExtent);
                                rect12.height = intct.y - rFull.y - vert_margin;
                            }
                        }
                    }
                    int labelsHeight = fontHeight;
                    DateGroupLabels dgLabels = (DateGroupLabels)pfj.getO1LabelCallBack();
                    int levels = 1;
                    if (dgLabels.getAllLabels(1) != null) {
                        labelsHeight *= 2;
                        levels = 2;
                    }
                    Rectangle rect = rect12.height > (reqHt = pfj.getVC().destToVirtHeight(5 + labelsHeight)) ? rect12 : rect22;
                    int left_space = p.x - rect.x;
                    boolean decrement = false;
                    Vector labels2 = dgLabels.getAllLabels(0);
                    int req_edge_space = 0;
                    if (bMarksOnEdge) {
                        req_edge_space = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth((String)labels2.elementAt(0), fm)) / 2;
                    }
                    if (left_space < req_edge_space) {
                        rFrame.width -= req_edge_space - left_space;
                        rFrame.x += req_edge_space - left_space;
                        left_space = req_edge_space;
                    }
                    if ((right_space = rect.width - (virtExtent = rFrame.width + 200) - left_space) < req_edge_space) {
                        rFrame.width -= req_edge_space - right_space;
                        right_space = req_edge_space;
                    }
                    pfj.setLeftRightOffsets(left_space + 100, right_space + 100);
                    rFrame.y += reqHt;
                    rFrame.height -= reqHt;
                    pfj.putToLookNoCalc(pfj.getFrame(), Attr.FrameRect, rFrame, this.m_reset ^ true);
                    pfj.formatDates();
                    if (dgLabels.getAllLabels(1) != null && levels == 1) {
                        rFrame.y += pfj.getVC().destToVirtHeight(fontHeight);
                        rFrame.height -= pfj.getVC().destToVirtHeight(fontHeight);
                    } else if (dgLabels.getAllLabels(1) == null && levels == 2) {
                        rFrame.y -= pfj.getVC().destToVirtHeight(fontHeight);
                        rFrame.height += pfj.getVC().destToVirtHeight(fontHeight);
                    }
                    pfj.putToLookNoCalc(pfj.getFrame(), Attr.FrameRect, rFrame, this.m_reset ^ true);
                    return;
                }
                labels = ((_PropertyContext)context).m_O1Labels;
                nNumLabels = 0;
                if (labels != null) {
                    nNumLabels = labels.length;
                } else {
                    DataRange dr = access.getViewableDataRangeSG(pfj);
                    int start = dr.getColStart();
                    int stop = dr.getColStop();
                    nNumLabels = stop - start + 1;
                    if (nNumLabels < 1) {
                        return;
                    }
                    labels = new String[nNumLabels];
                    int j = 0;
                    int i = start;
                    while (i <= stop) {
                        labels[j++] = pfj.getGroupLabel(i);
                        ++i;
                    }
                }
                autorotate = pfj.getO1LabelAutoAngle();
                canRotate = autorotate != 0;
                canSkip = pfj.getAutoSkip(idLabel) == 1;
                int minSkip = 0;
                if (canSkip) {
                    int nMaxLabels = (int)((double)extent / ((double)fontHeight * 1.0));
                    if (nMaxLabels == 0) {
                        minSkip = nNumLabels - 1;
                    } else if (nNumLabels > nMaxLabels) {
                        minSkip = (int)Math.ceil((double)(nNumLabels - nMaxLabels) / (double)nMaxLabels);
                    }
                }
                stagger = false;
                rotate = false;
                wordwrap = false;
                skip = 0;
                skipstart = 0;
                if (canSkip) {
                    skip = minSkip;
                } else if (pfj.getAutoSkip(idLabel) == 2 && (skip = pfj.getSkipCount(idLabel)) > 0) {
                    skipstart = pfj.getSkipBegin(idLabel);
                    if (skipstart >= nNumLabels) {
                        skipstart = 0;
                    } else if (skipstart > skip) {
                        skipstart %= skip + 1;
                    }
                }
                layoutResolved = false;
                Rectangle virtual = pfj.getVC().getVirtCoords();
                skipForRotate = skip;
                rect1 = null;
                rect2 = null;
                if (isVertical) break block99;
                int extra = rFrame.height - 3000;
                if (extra <= 0) {
                    return;
                }
                int margin = pfj.getVC().destToVirtWidth(10);
                int vert_margin = pfj.getVC().destToVirtHeight(10);
                Rectangle rFull = new Rectangle(virtual.x + margin, p.y, virtual.width - 2 * margin, extra);
                rect1 = new Rectangle(rFull);
                rect2 = null;
                IdentObj legend = pfj.getLegendArea();
                if (this._isLegendDisplayed() && rFull.intersects(rLegend = pfj.getRect(legend))) {
                    Rectangle intct = rFull.intersection(rLegend);
                    if (intct.x > p.x) {
                        if (intct.y <= rFull.y) {
                            rect1.width = intct.x - rect1.x - margin;
                            break block98;
                        } else {
                            rect2 = new Rectangle(rFull.x, rFull.y, intct.x - rFull.x - margin, rFull.height);
                            rect1.height = intct.y - rFull.y - vert_margin;
                        }
                        break block98;
                    } else {
                        int newX = intct.x + intct.width + margin;
                        if (intct.y <= rFull.y) {
                            rect1.x = newX;
                            rect1.width = rFull.x + rFull.width - newX;
                            break block98;
                        } else {
                            rect2 = new Rectangle(newX, rFull.y, rFull.x + rFull.width - newX, virtExtent);
                            rect1.height = intct.y - rFull.y - vert_margin;
                        }
                    }
                }
                break block98;
            }
            int extra = rFrame.width - 3000;
            if (extra <= 0) {
                return;
            }
            rect1 = new Rectangle(p.x, p.y, extra, virtExtent);
        }
        Rectangle[] rects = new Rectangle[]{rect1, rect2};
        int[] norm_order = new int[]{0, 1, 2, 3};
        int[] ww_order = new int[]{2, 0, 1, 3};
        int[] vert_norm_order = new int[]{3, 0, 1, 2};
        int[] vert_ww_order = new int[]{3, 2, 0, 1};
        while (!layoutResolved) {
            int delta;
            IdentObj label;
            IdentObj label2;
            int ep2;
            int ep1;
            double f1;
            double f2;
            int nLabelsAfterSkip = (nNumLabels - skipstart + skip) / (skip + 1);
            int skipped_at_end = (nNumLabels - skipstart - 1) % (skip + 1);
            int last = nNumLabels - 1 - skipped_at_end;
            double extra_offset = 0.0;
            if (!bMarksOnEdge) {
                extra_offset = 0.5;
            }
            if (isVertical) {
                f2 = 1.0 - ((double)skipstart + extra_offset) / (double)nNumLabels;
                f1 = 1.0 - ((double)skipped_at_end + extra_offset) / (double)nNumLabels;
            } else {
                f1 = 1.0 - ((double)skipstart + extra_offset) / (double)nNumLabels;
                f2 = 1.0 - ((double)skipped_at_end + extra_offset) / (double)nNumLabels;
            }
            int orig = p.x;
            if (isVertical) {
                orig = p.y;
            }
            int c1 = orig + (int)((1.0 - f1) * (double)virtExtent);
            int c2 = orig + (int)(f2 * (double)virtExtent);
            int b1 = pfj.getFontMetricsResolver().stringWidth(labels[skipstart], fm) / 2;
            int b2 = pfj.getFontMetricsResolver().stringWidth(labels[last], fm) / 2;
            int labelGapVC = 0;
            if (isVertical) {
                ep1 = c1 - pfj.getVC().destToVirtHeight(b2);
                ep2 = c2 + pfj.getVC().destToVirtHeight(b1);
                labelGapVC = pfj.getVC().destToVirtHeight(labelGapH);
            } else {
                ep1 = c1 - pfj.getVC().destToVirtWidth(b1);
                ep2 = c2 + pfj.getVC().destToVirtWidth(b2);
                labelGapVC = pfj.getVC().destToVirtWidth(labelGapH);
            }
            int cell_extent = virtExtent;
            if (!bMarksOnEdge) {
                cell_extent = virtExtent / nNumLabels;
            } else if (nNumLabels > 1) {
                cell_extent = virtExtent / (nNumLabels - 1);
            }
            int blockw = (int)((double)((cell_extent - labelGapVC) * (skip + 1)) / 2.0);
            int ew1 = c1 - blockw;
            int ew2 = c2 + blockw;
            int endp = orig + virtExtent;
            int[] lengths = new int[nLabelsAfterSkip];
            int maxWidth = BILabelLayout.getLongestLabelWidth(fm, labels, skip, skipstart, lengths, pfj.getFontMetricsResolver());
            int maxAvailDepth = 0;
            int requiredDepth = 0;
            int extra_l = 0;
            int extra_r = 0;
            int j = 0;
            while (j < rects.length && !layoutResolved) {
                block100: {
                    if (rects[j] == null) break;
                    maxAvailDepth = !isVertical ? pfj.getVC().virtToDestHeight(rects[j].height) - 5 : pfj.getVC().virtToDestWidth(rects[j].width) - 5;
                    requiredDepth = fontHeight;
                    if (j == 0 && rects[1] != null && maxAvailDepth < requiredDepth) break block100;
                    int[] check_order = norm_order;
                    int left = rects[j].x;
                    int right = rects[j].x + rects[j].width;
                    if (isVertical) {
                        check_order = vert_norm_order;
                        left = rects[j].y;
                        right = rects[j].y + rects[j].height;
                    }
                    if (ep1 < left && ew1 - ep1 > 1000 || right < ep2 && ep2 - ew2 > 1000) {
                        check_order = ww_order;
                        if (isVertical) {
                            check_order = vert_ww_order;
                        }
                    }
                    int[] plain_shifts = null;
                    int availWidth = 0;
                    int d1 = 0;
                    int d2 = 0;
                    int n = 0;
                    while (n < check_order.length && !layoutResolved) {
                        block103: {
                            block102: {
                                int avail_extent;
                                block105: {
                                    int extra2;
                                    int extra1;
                                    block104: {
                                        block101: {
                                            avail_extent = extent;
                                            if (check_order[n] != 3) break block101;
                                            if ((canRotate || isVertical || pfj.getTextRotation(idLabel) != 0) && (canRotate || !isVertical || pfj.getTextRotation(idLabel) == 0)) break block102;
                                            break block103;
                                        }
                                        if (!canRotate && !isVertical && pfj.getTextRotation(idLabel) != 0 || !canRotate && isVertical && pfj.getTextRotation(idLabel) == 0) break block103;
                                        if (check_order[n] != 2) break block104;
                                        int extra12 = left - ew1;
                                        int extra22 = ew2 - right;
                                        int[] shifts = BILabelLayout.getPlotAreaShifts(extra12, extra22, f1, f2, virtExtent - 8000, nLabelsAfterSkip);
                                        if (shifts == null) break block103;
                                        d1 = shifts[0];
                                        d2 = shifts[1];
                                        break block105;
                                    }
                                    if (plain_shifts == null && (plain_shifts = BILabelLayout.getPlotAreaShifts(extra1 = left - ep1, extra2 = ep2 - right, f1, f2, virtExtent - 8000, nLabelsAfterSkip)) == null) break block103;
                                    d1 = plain_shifts[0];
                                    d2 = plain_shifts[1];
                                }
                                avail_extent = isVertical ? pfj.getVC().virtToDestHeight(virtExtent - d1 - d2) : pfj.getVC().virtToDestWidth(virtExtent - d1 - d2);
                                availWidth = !bMarksOnEdge || nLabelsAfterSkip == 1 ? avail_extent * (skip + 1) / nNumLabels - labelGapH : avail_extent * (skip + 1) / (nNumLabels - 1) - labelGapH;
                            }
                            switch (check_order[n]) {
                                case 0: {
                                    if (maxWidth > availWidth && (isVertical || !BILabelLayout.verifyPairLengths(lengths, 1, availWidth - 5))) break;
                                    layoutResolved = true;
                                    break;
                                }
                                case 1: {
                                    int staggerDepth = fontHeight * 2;
                                    int staggerWidth = availWidth * 2 + labelGapH;
                                    if (staggerDepth > maxAvailDepth || maxWidth > staggerWidth && (isVertical || !BILabelLayout.verifyPairLengths(lengths, 2, staggerWidth - 5))) break;
                                    stagger = true;
                                    requiredDepth = staggerDepth;
                                    layoutResolved = true;
                                    break;
                                }
                                case 2: {
                                    int height;
                                    if (!((double)availWidth > (double)fontHeight * 1.5) || maxWidth >= maxAvailDepth / fontHeight * availWidth || (height = BILabelLayout.wordWrap(fm, labels, skip, skipstart, availWidth, maxAvailDepth, pfj.getFontMetricsResolver())) <= 0) break;
                                    layoutResolved = true;
                                    requiredDepth = height;
                                    wordwrap = true;
                                    b2 = b1 = availWidth / 2;
                                    break;
                                }
                                case 3: {
                                    int max_lines = 0;
                                    int[][] deltas = new int[5][2];
                                    int l = 0;
                                    while (l < 5) {
                                        int e2;
                                        int half = isVertical ? pfj.getVC().destToVirtHeight(fontHeight * (l + 1) / 2) : pfj.getVC().destToVirtWidth(fontHeight * (l + 1) / 2);
                                        int e1 = c1 - half;
                                        int[] shifts = BILabelLayout.getPlotAreaShifts(left - e1, (e2 = c2 + half) - right, f1, f2, virtExtent - 8000, nLabelsAfterSkip);
                                        if (shifts == null) break;
                                        deltas[l][0] = shifts[0];
                                        deltas[l][1] = shifts[1];
                                        int new_extent = isVertical ? pfj.getVC().virtToDestHeight(virtExtent - shifts[0] - shifts[1]) : pfj.getVC().virtToDestWidth(virtExtent - shifts[0] - shifts[1]);
                                        int new_avail_width = !bMarksOnEdge || nLabelsAfterSkip == 1 ? new_extent * (skip + 1) / nNumLabels - labelGapV : new_extent * (skip + 1) / (nNumLabels - 1) - labelGapV;
                                        if ((l + 1) * fontHeight > new_avail_width) break;
                                        max_lines = l + 1;
                                        ++l;
                                    }
                                    if (max_lines >= 1) {
                                        if (maxWidth <= maxAvailDepth && maxWidth <= 40) {
                                            layoutResolved = true;
                                            rotate = true;
                                            requiredDepth = maxWidth;
                                            d1 = deltas[0][0];
                                            d2 = deltas[0][1];
                                            b2 = b1 = fontHeight / 2;
                                            break;
                                        }
                                        if (maxWidth <= maxAvailDepth * max_lines) {
                                            Vector[] w_lengths = BILabelLayout.getWordLengths(fm, labels, skip, skipstart, pfj.getFontMetricsResolver());
                                            int depth = 40;
                                            while (depth <= maxAvailDepth && !layoutResolved) {
                                                int lines;
                                                if (maxWidth <= depth * max_lines && (lines = BILabelLayout.wordWrap(fm, w_lengths, depth, depth + 3 < maxAvailDepth, max_lines, pfj.getFontMetricsResolver())) > 0) {
                                                    layoutResolved = true;
                                                    rotate = true;
                                                    if (lines > 1) {
                                                        wordwrap = true;
                                                    }
                                                    requiredDepth = depth;
                                                    d1 = deltas[lines - 1][0];
                                                    d2 = deltas[lines - 1][1];
                                                    b2 = b1 = fontHeight * lines / 2;
                                                }
                                                depth += 3;
                                            }
                                            break block0;
                                        }
                                    }
                                    break block103;
                                }
                            }
                            if (layoutResolved) {
                                extra_l = d1;
                                extra_r = d2;
                            }
                        }
                        ++n;
                    }
                }
                ++j;
            }
            if (!layoutResolved) {
                if (nLabelsAfterSkip > 1 && canSkip) {
                    ++skip;
                } else {
                    layoutResolved = true;
                    if (nNumLabels > 1 && (canRotate || !isVertical && pfj.getTextRotation(idLabel) != 0 || isVertical && pfj.getTextRotation(idLabel) == 0)) {
                        skip = skipForRotate;
                        rotate = true;
                        requiredDepth = Math.min(maxAvailDepth, maxWidth);
                    }
                }
            }
            if (!layoutResolved) continue;
            if (isVertical) {
                int virtReq = pfj.getVC().destToVirtWidth(requiredDepth + 5);
                rFrame.x += virtReq;
                rFrame.width -= virtReq;
                rFrame.y += extra_l;
                rFrame.height -= extra_l + extra_r;
                continue;
            }
            int virtReq = pfj.getVC().destToVirtHeight(requiredDepth + 5);
            rFrame.y += virtReq;
            rFrame.height -= virtReq;
            rFrame.x += extra_l;
            rFrame.width -= extra_l + extra_r;
            boolean bLeft = false;
            boolean bRight = false;
            int width = pfj.getVC().virtToDestWidth(rFrame.width);
            if ((double)b1 > (1.0 - f1) * (double)width) {
                bLeft = true;
            }
            if ((double)b2 > (1.0 - f2) * (double)width) {
                bRight = true;
            }
            int extra_depth = 0;
            if (bLeft && pfj.getTextRotation(label2 = pfj.getY1Label()) == 0) {
                FontMetrics fnm = BILabelLayout.getFontMetrics(g, pfj, label2);
                extra_depth = BILabelLayout.getPFJFontHeight(fnm, pfj.getFontMetricsResolver()) / 2;
            }
            if (bRight && pfj.getJGraphType().getAxisDescriptor().hasY2() && pfj.getTextRotation(label = pfj.getY2Label()) == 0) {
                FontMetrics fnm = BILabelLayout.getFontMetrics(g, pfj, label);
                int y2_extra_depth = BILabelLayout.getPFJFontHeight(fnm, pfj.getFontMetricsResolver()) / 2;
                if (stagger && nLabelsAfterSkip % 2 == 0) {
                    y2_extra_depth -= fontHeight;
                }
                if (y2_extra_depth > extra_depth) {
                    extra_depth = y2_extra_depth;
                }
            }
            if (extra_depth <= false || (delta = extra_depth + 3 - 5) <= 0) continue;
            int v_delta = pfj.getVC().destToVirtHeight(delta);
            rFrame.y += v_delta;
            rFrame.height -= v_delta;
            pfj.setAdditionalBottomAxisMargin(v_delta);
        }
        if (canSkip) {
            pfj.putToLookNoCalc(idLabel, Attr.AutoSkip, new Integer(2), this.m_reset ^ true);
            pfj.putToLookNoCalc(idLabel, Attr.SkipCount, new Integer(skip), this.m_reset ^ true);
            pfj.putToLookNoCalc(idLabel, Attr.SkipBegin, new Integer(0), this.m_reset ^ true);
        }
        if (canRotate) {
            int rotation = 0;
            if (isVertical && !rotate || !isVertical && rotate) {
                rotation = autorotate == 1 ? 1 : 2;
            }
            pfj.putToLookNoCalc(idLabel, Attr.TextRotation, new Integer(rotation), this.m_reset ^ true);
        }
        int align = 0;
        int rotation = pfj.getTextRotation(idLabel);
        if (isVertical && rotation == 0 || !isVertical && rotation == 1) {
            align = 4;
        } else if (!isVertical && rotation == 2) {
            align = 2;
        }
        pfj.putToLookNoCalc(idLabel, Attr.TextJustHoriz, new Integer(align), this.m_reset ^ true);
        pfj.putToLookNoCalc(idLabel, Attr.LabelStagger, new Boolean(stagger), this.m_reset ^ true);
        pfj.putToLookNoCalc(idLabel, Attr.TextWrap, new Boolean(wordwrap), this.m_reset ^ true);
        pfj.putToLookNoCalc(pfj.getFrame(), Attr.FrameRect, rFrame, this.m_reset ^ true);
    }

    private boolean isDataAxisLayoutValid(Perspective pfj, Graphics g, Vector[] labels, Object context, CommonGraph graph, boolean circular) {
        if (!this.m_plotAreaDisplay) {
            return true;
        }
        if (circular) {
            return this.isCircularLabelsLayoutValid(pfj, g, null, graph, true, labels[7]);
        }
        boolean horiz_chart = pfj.isChartOrientHorz();
        IdentObj idFrame = pfj.getFrame();
        if (labels[8] != null) {
            IdentObj idLabel = pfj.getY1Label();
            IdentObj idTitle = pfj.getY1Title();
            return BILabelLayout.validateDataAxisSide(pfj, g, pfj.getPieFrame(), idLabel, idTitle, labels[8], 2, 1);
        }
        if (labels[7] != null) {
            IdentObj idLabel = pfj.getX1Label();
            IdentObj idTitle = pfj.getX1Title();
            int axis_side = pfj.getAxisSide(pfj.getX1Axis());
            int[] sides = BILabelLayout.getAxisSides(axis_side, horiz_chart, true);
            if (sides[0] != -1 && !BILabelLayout.validateDataAxisSide(pfj, g, idFrame, idLabel, idTitle, labels[7], sides[0], sides[2])) {
                return false;
            }
            if (sides[1] != -1 && !BILabelLayout.validateDataAxisSide(pfj, g, idFrame, idLabel, idTitle, labels[7], sides[1], sides[2])) {
                return false;
            }
        }
        if (labels[0] != null) {
            IdentObj idLabel = pfj.getY1Label();
            IdentObj idTitle = pfj.getY1Title();
            int axis_side = pfj.getAxisSide(pfj.getY1Axis());
            int[] sides = BILabelLayout.getAxisSides(axis_side, horiz_chart, false);
            if (sides[0] != -1 && !BILabelLayout.validateDataAxisSide(pfj, g, idFrame, idLabel, idTitle, labels[0], sides[0], sides[2])) {
                return false;
            }
            if (sides[1] != -1 && !BILabelLayout.validateDataAxisSide(pfj, g, idFrame, idLabel, idTitle, labels[0], sides[1], sides[2])) {
                return false;
            }
        }
        if (labels[1] != null) {
            IdentObj idLabel = pfj.getY2Label();
            IdentObj idTitle = pfj.getY2Title();
            int axis_side = pfj.getAxisSide(pfj.getY2Axis());
            int[] sides = BILabelLayout.getAxisSides(axis_side, horiz_chart, false);
            if (sides[0] != -1 && !BILabelLayout.validateDataAxisSide(pfj, g, idFrame, idLabel, idTitle, labels[1], sides[0], sides[2])) {
                return false;
            }
            if (sides[1] != -1 && !BILabelLayout.validateDataAxisSide(pfj, g, idFrame, idLabel, idTitle, labels[1], sides[1], sides[2])) {
                return false;
            }
        }
        return true;
    }

    private void doDataAxisAutoLayout(Perspective pfj, Graphics g, Vector[] labels, Object context, boolean circular) {
        if (!this.m_plotAreaDisplay) {
            return;
        }
        if (circular) {
            this.doCircularLabelsAutoLayout(pfj, g, null, labels[7], true);
            return;
        }
        int[] extra = new int[4];
        boolean horiz_chart = pfj.isChartOrientHorz();
        IdentObj idFrame = pfj.getFrame();
        Attr attr = Attr.FrameRect;
        if (labels[7] != null) {
            int space;
            int space2;
            int space3;
            IdentObj idLabel = pfj.getX1Label();
            IdentObj idTitle = pfj.getX1Title();
            int axis_side = pfj.getAxisSide(pfj.getX1Axis());
            int[] sides = BILabelLayout.getAxisSides(axis_side, horiz_chart, true);
            if (sides[0] != -1 && (space3 = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle, labels[7], sides[0])) > extra[sides[0]]) {
                extra[sides[0]] = space3;
            }
            if (sides[1] != -1 && (space2 = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle, labels[7], sides[1])) > extra[sides[1]]) {
                extra[sides[1]] = space2;
            }
            if (sides[2] != -1 && (space = BILabelLayout.getRequiredDataAxisPerpendSpace(pfj, g, idLabel, idTitle, labels[7], sides[2])) > extra[sides[2]]) {
                extra[sides[2]] = space;
            }
        }
        if (labels[0] != null) {
            int space;
            int space4;
            int space5;
            IdentObj idLabel = pfj.getY1Label();
            IdentObj idTitle = pfj.getY1Title();
            int axis_side = pfj.getAxisSide(pfj.getY1Axis());
            int[] sides = BILabelLayout.getAxisSides(axis_side, horiz_chart, false);
            if (sides[0] != -1 && (space5 = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle, labels[0], sides[0])) > extra[sides[0]]) {
                extra[sides[0]] = space5;
            }
            if (sides[1] != -1 && (space4 = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle, labels[0], sides[1])) > extra[sides[1]]) {
                extra[sides[1]] = space4;
            }
            if (sides[2] != -1 && (space = BILabelLayout.getRequiredDataAxisPerpendSpace(pfj, g, idLabel, idTitle, labels[0], sides[2])) > extra[sides[2]]) {
                extra[sides[2]] = space;
            }
        }
        if (labels[1] != null) {
            int space;
            int space6;
            int space7;
            IdentObj idLabel = pfj.getY2Label();
            IdentObj idTitle = pfj.getY2Title();
            int axis_side = pfj.getAxisSide(pfj.getY2Axis());
            int[] sides = BILabelLayout.getAxisSides(axis_side, horiz_chart, false);
            if (sides[0] != -1 && (space7 = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle, labels[1], sides[0])) > extra[sides[0]]) {
                extra[sides[0]] = space7;
            }
            if (sides[1] != -1 && (space6 = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle, labels[1], sides[1])) > extra[sides[1]]) {
                extra[sides[1]] = space6;
            }
            if (sides[2] != -1 && (space = BILabelLayout.getRequiredDataAxisPerpendSpace(pfj, g, idLabel, idTitle, labels[1], sides[2])) > extra[sides[2]]) {
                extra[sides[2]] = space;
            }
        }
        if (labels[8] != null) {
            IdentObj idTitle;
            idFrame = pfj.getPieFrame();
            attr = Attr.PieFrameRect;
            IdentObj idLabel = pfj.getY1Label();
            int space = BILabelLayout.getRequiredDataAxisSpace(pfj, g, idLabel, idTitle = pfj.getY1Title(), labels[8], 2);
            if (space > extra[2]) {
                extra[2] = space;
            }
            if ((space = BILabelLayout.getRequiredDataAxisPerpendSpace(pfj, g, idLabel, idTitle, labels[8], 1)) > extra[1]) {
                extra[1] = space;
            }
        }
        Rectangle rFrame = new Rectangle(pfj.getRect(idFrame));
        rFrame.x += extra[0];
        rFrame.width -= extra[0];
        rFrame.width -= extra[2];
        rFrame.y += extra[3];
        rFrame.height -= extra[3];
        rFrame.height -= extra[1];
        pfj.putToLookNoCalc(idFrame, attr, rFrame, this.m_reset ^ true);
    }

    private static int[] getAxisSides(int axis_side, boolean horiz_chart, boolean isX) {
        int[] sides = new int[3];
        if (axis_side == 0 || axis_side == 2) {
            if (horiz_chart && isX || !horiz_chart && !isX) {
                sides[0] = 0;
                sides[2] = 1;
            } else {
                sides[0] = 3;
                sides[2] = 2;
            }
        } else {
            sides[0] = -1;
        }
        if (axis_side == 1 || axis_side == 2) {
            if (horiz_chart && isX || !horiz_chart && !isX) {
                sides[1] = 2;
                sides[2] = 1;
            } else {
                sides[1] = 1;
                sides[2] = 2;
            }
        } else {
            sides[1] = -1;
        }
        return sides;
    }

    private static boolean validateDataAxisSide(Perspective pfj, Graphics g, IdentObj frame, IdentObj label, IdentObj title, Vector strings, int side, int side2) {
        int virt_height = BILabelLayout.getRequiredDataAxisSpace(pfj, g, label, title, strings, side);
        int perpendHeight = BILabelLayout.getRequiredDataAxisPerpendSpace(pfj, g, label, title, strings, side2);
        Rectangle rFrame = pfj.getRect(frame);
        Point p = BILabelLayout.adjustFrameFor3D(pfj, rFrame);
        int dx = p.x - rFrame.x;
        int dy = p.y - rFrame.y;
        Rectangle area = null;
        switch (side) {
            case 0: {
                if (dx < 0) {
                    area = new Rectangle(p.x - virt_height, p.y, virt_height, rFrame.height + perpendHeight);
                    break;
                }
                area = new Rectangle(rFrame.x - virt_height, rFrame.y, virt_height, rFrame.height + perpendHeight);
                break;
            }
            case 1: {
                if (dy > 0) {
                    area = new Rectangle(p.x, p.y + rFrame.height, rFrame.width + perpendHeight, virt_height);
                    break;
                }
                area = new Rectangle(rFrame.x, rFrame.y + rFrame.height, rFrame.width + perpendHeight, virt_height);
                break;
            }
            case 2: {
                if (dx > 0) {
                    area = new Rectangle(p.x + rFrame.width, p.y, virt_height, rFrame.height + perpendHeight);
                    break;
                }
                area = new Rectangle(rFrame.x + rFrame.width, rFrame.y, virt_height, rFrame.height + perpendHeight);
                break;
            }
            case 3: {
                if (dy < 0) {
                    area = new Rectangle(p.x, p.y - virt_height, rFrame.width + perpendHeight, virt_height);
                    break;
                }
                area = new Rectangle(rFrame.x, rFrame.y - virt_height, rFrame.width + perpendHeight, virt_height);
                break;
            }
        }
        return BILabelLayout.intersectsComponents(pfj, area) ^ true;
    }

    private static int getRequiredDataAxisPerpendSpace(Perspective pfj, Graphics g, IdentObj label, IdentObj title, Vector strings, int side) {
        boolean isVertical = side == 1;
        boolean rotated = pfj.getTextRotation(label) != 0;
        FontMetrics fm = BILabelLayout.getFontMetrics(g, pfj, label);
        int height = BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver());
        if (isVertical && rotated || !isVertical && !rotated) {
            height = 0;
            int i = 0;
            while (i < strings.size()) {
                int len;
                String str = (String)strings.elementAt(i);
                if (str != null && (len = pfj.getFontMetricsResolver().stringWidth(str, fm)) > height) {
                    height = len;
                }
                ++i;
            }
        }
        height = (double)(height /= 2) < 10.0 - (double)height * 0.4 ? 0 : (int)((double)height - (10.0 - (double)height * 0.4));
        int virt_height = isVertical ? pfj.getVC().destToVirtHeight(height) : pfj.getVC().destToVirtWidth(height);
        return virt_height;
    }

    private static int getRequiredDataAxisSpace(Perspective pfj, Graphics g, IdentObj label, IdentObj title, Vector strings, int side) {
        boolean isVertical = side == 0 || side == 2;
        int titleHeight = BILabelLayout.getAxisTitleHeight(g, pfj, title, isVertical);
        boolean rotated = pfj.getTextRotation(label) != 0;
        boolean staggered = pfj.getLabelStagger(label);
        FontMetrics fm = BILabelLayout.getFontMetrics(g, pfj, label);
        int height = BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver());
        if (isVertical && !rotated || !isVertical && rotated) {
            height = 0;
            int i = 0;
            while (i < strings.size()) {
                int len;
                String str = (String)strings.elementAt(i);
                if (str != null && (len = pfj.getFontMetricsResolver().stringWidth(str, fm)) > height) {
                    height = len;
                }
                ++i;
            }
        }
        if (staggered) {
            height *= 2;
        }
        int virt_height = isVertical ? pfj.getVC().destToVirtWidth(height) + titleHeight : pfj.getVC().destToVirtHeight(height += 5) + titleHeight;
        return virt_height;
    }

    private void doTitlesAutoLayout(Graphics g, Perspective pfj, TitleObj title, TitleObj subtitle, TitleObj footnote, boolean alongEdge) {
        Rectangle footnoteRect;
        IdentObj titleID = pfj.getTitle();
        IdentObj subtitleID = pfj.getSubtitle();
        if ((pfj.getCustomLayout() & 1) == 0) {
            Rectangle subtitleRect;
            Rectangle titleRect = this.calculateTitleRect(g, pfj, title, titleID, pfj.getTitleString(), subtitleID, alongEdge);
            if (titleRect != null) {
                pfj.putToLookNoCalc(pfj.getTitle(), Attr.TitleRect, titleRect, this.m_reset ^ true);
            }
            if ((subtitleRect = this.calculateTitleRect(g, pfj, subtitle, subtitleID, pfj.getSubtitleString(), titleID, alongEdge)) != null) {
                if (pfj.getDisplay(titleID)) {
                    subtitleRect.y = subtitleRect.y - titleRect.height - pfj.getVC().destToVirtHeight(5);
                }
                pfj.putToLookNoCalc(pfj.getSubtitle(), Attr.SubtitleRect, subtitleRect, this.m_reset ^ true);
            }
        } else if (!pfj.getDisplay(subtitleID) || pfj.getSubtitleString().equals("")) {
            Rectangle titleRect = this.calculateTitleRect(g, pfj, title, titleID, pfj.getTitleString(), subtitleID, alongEdge);
            if (titleRect != null) {
                pfj.putToLookNoCalc(pfj.getTitle(), Attr.TitleRect, titleRect, this.m_reset ^ true);
            }
        } else if (!pfj.getDisplay(titleID) || pfj.getTitleString().equals("")) {
            Rectangle subtitleRect = this.calculateTitleRect(g, pfj, subtitle, subtitleID, pfj.getSubtitleString(), titleID, alongEdge);
            if (subtitleRect != null) {
                pfj.putToLookNoCalc(pfj.getSubtitle(), Attr.SubtitleRect, subtitleRect, this.m_reset ^ true);
            }
        } else {
            this.calculateTitleSubtitleRect(g, pfj, title, subtitle, alongEdge);
        }
        if ((footnoteRect = this.calculateFootnoteRect(g, pfj, footnote, alongEdge)) != null) {
            pfj.putToLookNoCalc(pfj.getFootnote(), Attr.FootnoteRect, footnoteRect, this.m_reset ^ true);
        }
    }

    private void calculateTitleSubtitleRect(Graphics g, Perspective pfj, TitleObj title, TitleObj subtitle, boolean alongEdge) {
        Rectangle subtitleRect;
        IdentObj titleID = pfj.getTitle();
        IdentObj subtitleID = pfj.getSubtitle();
        String titleString = pfj.getTitleString();
        String subtitleString = pfj.getSubtitleString();
        if (!pfj.getDisplay(titleID) && !pfj.getDisplay(subtitleID)) {
            return;
        }
        if (titleString.equals("") && subtitleString.equals("")) {
            pfj.putToLookNoCalc(titleID, Attr.NoDisplay, new Boolean(false), this.m_reset ^ true);
            pfj.putToLookNoCalc(subtitleID, Attr.NoDisplay, new Boolean(false), this.m_reset ^ true);
            return;
        }
        pfj.putToLookNoCalc(titleID, Attr.TextRotation, new Integer(0), this.m_reset ^ true);
        pfj.putToLookNoCalc(subtitleID, Attr.TextRotation, new Integer(0), this.m_reset ^ true);
        pfj.putToLookNoCalc(titleID, Attr.TextJustVert, new Integer(3), this.m_reset ^ true);
        pfj.putToLookNoCalc(subtitleID, Attr.TextJustVert, new Integer(3), this.m_reset ^ true);
        int legendPosition = this.m_commonGraph.getLegendArea().getAutomaticPosition();
        int availableWidth = 32000 - 2 * this.m_commonGraphMarginH;
        int x = -16000 + this.m_commonGraphMarginH;
        int y = 16000 - this.m_commonGraphMarginV;
        if (alongEdge && this._isLegendDisplayed()) {
            Rectangle legendRect = pfj.getLegendRect();
            switch (legendPosition) {
                case 2: {
                    availableWidth -= legendRect.width;
                    break;
                }
                case 3: {
                    availableWidth -= legendRect.width;
                    x += legendRect.width;
                    break;
                }
                case 0: {
                    y -= legendRect.height;
                    break;
                }
            }
        }
        int fontSize = !pfj.getFontSizeAbsolute(titleID) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(titleID)) : pfj.getFontSize(titleID);
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(titleID));
        String fontName = pfj.getFontName(titleID);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics tfm = g.getFontMetrics(font);
        int tWidth = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(titleString, tfm));
        int tHeight = pfj.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(tfm, pfj.getFontMetricsResolver()));
        fontSize = !pfj.getFontSizeAbsolute(subtitleID) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(subtitleID)) : pfj.getFontSize(subtitleID);
        fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(subtitleID));
        fontName = pfj.getFontName(subtitleID);
        font = new Font(fontName, fontStyle, fontSize);
        FontMetrics stfm = g.getFontMetrics(font);
        int sWidth = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(subtitleString, stfm));
        int sHeight = pfj.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(stfm, pfj.getFontMetricsResolver()));
        int gap = pfj.getVC().destToVirtWidth(10);
        int width = tWidth + sWidth + gap;
        if (width > availableWidth) {
            if ((double)tWidth > (double)(availableWidth -= gap) * 0.6) {
                tWidth = (int)((double)availableWidth * 0.6);
            }
            sWidth = availableWidth - (tWidth + gap);
        }
        Vector tstrs = new Vector();
        TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        tsObj.extractLinesWordWrap(titleString, tstrs, pfj.getVC().virtToDestWidth(tWidth), tfm, pfj.getFontMetricsResolver());
        int size = tstrs.size();
        tHeight = size * tHeight;
        title.setTruncated(true, size);
        tWidth = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth((String)tstrs.elementAt(0), tfm));
        sWidth = availableWidth - (tWidth + gap);
        Vector sstrs = new Vector();
        TextStyleObj ssObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        tsObj.extractLinesWordWrap(subtitleString, sstrs, pfj.getVC().virtToDestWidth(sWidth), stfm, pfj.getFontMetricsResolver());
        size = sstrs.size();
        sHeight = size * sHeight;
        subtitle.setTruncated(true, size);
        sWidth = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth((String)sstrs.elementAt(0), stfm));
        sHeight = tHeight = tHeight > sHeight ? tHeight : sHeight;
        Rectangle titleRect = new Rectangle(x, y - tHeight, ++tWidth, tHeight);
        if (titleRect != null) {
            pfj.putToLookNoCalc(pfj.getTitle(), Attr.TitleRect, titleRect, this.m_reset ^ true);
        }
        if ((subtitleRect = new Rectangle(x + tWidth + gap, y - sHeight, sWidth, sHeight)) != null) {
            pfj.putToLookNoCalc(pfj.getSubtitle(), Attr.SubtitleRect, subtitleRect, this.m_reset ^ true);
        }
    }

    private void readjustTitles(Perspective pfj, boolean alongEdge) {
        this.adjustTitle(pfj, pfj.getTitle(), alongEdge);
        this.adjustTitle(pfj, pfj.getSubtitle(), alongEdge);
        this.adjustFootnote(pfj, pfj.getFootnote(), alongEdge);
    }

    private void adjustTitle(Perspective pfj, IdentObj titleID, boolean alongEdge) {
        if (!pfj.getDisplay(titleID)) {
            return;
        }
        int alignment = pfj.getTextJustHoriz(titleID);
        if (alignment != 0) {
            return;
        }
        Rectangle titleRect = pfj.getRect(titleID);
        int availableWidth = 32000 - 2 * this.m_commonGraphMarginH;
        if (this._isLegendDisplayed()) {
            Rectangle legendRect = pfj.getLegendRect();
            int legendPosition = this.m_commonGraph.getLegendArea().getAutomaticPosition();
            if (alongEdge) {
                if (legendPosition == 2 || legendPosition == 3) {
                    availableWidth -= legendRect.width;
                }
                titleRect.x += (availableWidth - titleRect.width) / 2;
            } else {
                int legendX = legendRect.x;
                int legendY = legendRect.y + legendRect.height;
                switch (legendPosition) {
                    case 2: {
                        if (titleRect.y < legendY + this.m_commonGraphMarginV) {
                            availableWidth -= legendRect.width + this.m_commonGraphMarginH;
                        }
                        titleRect.x += (availableWidth - titleRect.width) / 2;
                        break;
                    }
                    case 3: {
                        if (titleRect.y < legendY + this.m_commonGraphMarginV) {
                            availableWidth -= legendRect.width + this.m_commonGraphMarginH;
                        }
                        titleRect.x -= (availableWidth - titleRect.width) / 2;
                        break;
                    }
                    default: {
                        titleRect.x += (availableWidth - titleRect.width) / 2;
                        break;
                    }
                }
            }
        } else {
            titleRect.x += (availableWidth - titleRect.width) / 2;
        }
        Attr a = Attr.TitleRect;
        if (titleID.getObjectID() == 4) {
            a = Attr.SubtitleRect;
        }
        pfj.putToLookNoCalc(titleID, a, titleRect, this.m_reset ^ true);
    }

    private void adjustFootnote(Perspective pfj, IdentObj footnoteID, boolean alongEdge) {
        if (!pfj.getDisplay(footnoteID)) {
            return;
        }
        int alignment = pfj.getTextJustHoriz(footnoteID);
        if (alignment != 0) {
            return;
        }
        Rectangle footnoteRect = pfj.getRect(footnoteID);
        int availableWidth = 32000 - 2 * this.m_commonGraphMarginH;
        if (this._isLegendDisplayed()) {
            Rectangle legendRect = pfj.getLegendRect();
            int legendPosition = this.m_commonGraph.getLegendArea().getAutomaticPosition();
            if (alongEdge) {
                if (legendPosition == 2 || legendPosition == 3) {
                    availableWidth -= legendRect.width;
                }
                footnoteRect.x += (availableWidth - footnoteRect.width) / 2;
            } else {
                int legendX = legendRect.x;
                int legendY = legendRect.y;
                switch (legendPosition) {
                    case 2: {
                        if (footnoteRect.y > legendY - this.m_commonGraphMarginV) {
                            availableWidth -= legendRect.width + this.m_commonGraphMarginH;
                        }
                        footnoteRect.x += (availableWidth - footnoteRect.width) / 2;
                        break;
                    }
                    case 3: {
                        if (footnoteRect.y > legendY - this.m_commonGraphMarginV) {
                            availableWidth -= legendRect.width + this.m_commonGraphMarginH;
                        }
                        footnoteRect.x -= (availableWidth - footnoteRect.width) / 2;
                        break;
                    }
                    default: {
                        footnoteRect.x += (availableWidth - footnoteRect.width) / 2;
                        break;
                    }
                }
            }
        } else {
            footnoteRect.x += (availableWidth - footnoteRect.width) / 2;
        }
        pfj.putToLookNoCalc(footnoteID, Attr.FootnoteRect, footnoteRect, this.m_reset ^ true);
    }

    private Rectangle calculateTitleRect(Graphics g, Perspective pfj, TitleObj title, IdentObj titleID, String titleString, IdentObj otherTitleID, boolean alongEdge) {
        int alignment;
        if (!pfj.getDisplay(titleID)) {
            return null;
        }
        if (titleString.equals("")) {
            pfj.putToLookNoCalc(titleID, Attr.NoDisplay, new Boolean(false), this.m_reset ^ true);
            return null;
        }
        pfj.putToLookNoCalc(titleID, Attr.TextRotation, new Integer(0), this.m_reset ^ true);
        int legendPosition = this.m_commonGraph.getLegendArea().getAutomaticPosition();
        int availableWidth = 32000 - 2 * this.m_commonGraphMarginH;
        int x = -16000 + this.m_commonGraphMarginH;
        int y = 16000 - this.m_commonGraphMarginV;
        if (alongEdge && this._isLegendDisplayed()) {
            Rectangle legendRect = pfj.getLegendRect();
            switch (legendPosition) {
                case 2: {
                    availableWidth -= legendRect.width;
                    break;
                }
                case 3: {
                    availableWidth -= legendRect.width;
                    x += legendRect.width;
                    break;
                }
                case 0: {
                    y -= legendRect.height;
                    break;
                }
            }
        }
        int fontSize = !pfj.getFontSizeAbsolute(titleID) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(titleID)) : pfj.getFontSize(titleID);
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(titleID));
        String fontName = pfj.getFontName(titleID);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics tfm = g.getFontMetrics(font);
        int width = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(titleString, tfm));
        int height = pfj.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(tfm, pfj.getFontMetricsResolver()));
        boolean isLongWidth = false;
        if (width > availableWidth) {
            width = availableWidth;
            isLongWidth = true;
        }
        Vector strs = new Vector();
        TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        tsObj.extractLinesWordWrap(titleString, strs, pfj.getVC().virtToDestWidth(width), tfm, pfj.getFontMetricsResolver());
        if (pfj.getDisplay(otherTitleID)) {
            if (strs.size() >= 2 || isLongWidth) {
                title.setTruncated(true, 1);
                this.m_commonGraph.processAlertEvent(12);
                this.m_commonGraph.getErrorHandler().log("title text truncated", this.getClass().getName(), "adjustProperties");
            }
        } else if (strs.size() > 2) {
            height = 2 * height;
            title.setTruncated(true, 2);
            this.m_commonGraph.processAlertEvent(12);
            this.m_commonGraph.getErrorHandler().log("title text truncated", this.getClass().getName(), "adjustProperties");
        } else {
            int size = strs.size();
            height = size * height;
            if (pfj.getFontMetricsResolver().stringWidth((String)strs.elementAt(size - 1), tfm) > pfj.getVC().virtToDestWidth(width)) {
                title.setTruncated(true, size);
                this.m_commonGraph.processAlertEvent(12);
                this.m_commonGraph.getErrorHandler().log("title text truncated", this.getClass().getName(), "adjustProperties");
            } else {
                title.setTruncated(false, 2);
            }
        }
        if ((alignment = pfj.getTextJustHoriz(titleID)) == 10) {
            alignment = LocaleUtils.getReadingDirectionForLocale((Locale)pfj.getLocale());
            if (alignment == 1) {
                alignment = 2;
            } else if (alignment == 2) {
                alignment = 4;
            }
        }
        if (alignment == 4 || alignment == 0 && legendPosition == 3 && !alongEdge) {
            x += availableWidth - width;
        }
        return new Rectangle(x, y - height, ++width, height);
    }

    private Rectangle calculateFootnoteRect(Graphics g, Perspective pfj, TitleObj footnote, boolean alongEdge) {
        IdentObj footnoteID = pfj.getFootnote();
        if (!pfj.getDisplay(footnoteID)) {
            return null;
        }
        if (pfj.getFootnoteString().equals("")) {
            pfj.putToLookNoCalc(footnoteID, Attr.NoDisplay, new Boolean(false), this.m_reset ^ true);
            return null;
        }
        pfj.putToLookNoCalc(footnoteID, Attr.TextRotation, new Integer(0), this.m_reset ^ true);
        String footnoteString = pfj.getFootnoteString();
        int legendPosition = this.m_commonGraph.getLegendArea().getAutomaticPosition();
        int availableWidth = 32000 - 2 * this.m_commonGraphMarginH;
        int x = -16000 + this.m_commonGraphMarginH;
        int y = -16000 + this.m_commonGraphMarginV;
        if (alongEdge && this._isLegendDisplayed()) {
            Rectangle legendRect = pfj.getLegendRect();
            switch (legendPosition) {
                case 2: {
                    availableWidth -= legendRect.width;
                    break;
                }
                case 3: {
                    availableWidth -= legendRect.width;
                    x += legendRect.width;
                    break;
                }
                case 1: {
                    y += legendRect.height;
                    break;
                }
            }
        }
        int fontSize = !pfj.getFontSizeAbsolute(footnoteID) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(footnoteID)) : pfj.getFontSize(footnoteID);
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(footnoteID));
        String fontName = pfj.getFontName(footnoteID);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics tfm = g.getFontMetrics(font);
        int width = pfj.getVC().destToVirtWidth(pfj.getFontMetricsResolver().stringWidth(footnoteString, tfm));
        int height = pfj.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(tfm, pfj.getFontMetricsResolver()));
        if (width > availableWidth) {
            width = availableWidth;
            Vector strs = new Vector();
            TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
            tsObj.extractLinesWordWrap(footnoteString, strs, pfj.getVC().virtToDestWidth(width), tfm, pfj.getFontMetricsResolver());
            if (strs.size() <= 2) {
                height = strs.size() * height;
            } else {
                height = 2 * height;
                footnote.setTruncated(true, 2);
                this.m_commonGraph.processAlertEvent(12);
                this.m_commonGraph.getErrorHandler().log("title text truncated", this.getClass().getName(), "calculateFootnoteRect");
            }
        } else {
            footnote.setTruncated(false, 1);
        }
        int alignment = pfj.getTextJustHoriz(footnoteID);
        if (alignment == 10) {
            alignment = LocaleUtils.getReadingDirectionForLocale((Locale)pfj.getLocale());
            if (alignment == 1) {
                alignment = 2;
            } else if (alignment == 2) {
                alignment = 4;
            }
        }
        if (alignment == 4 || alignment == 0 && legendPosition == 3 && !alongEdge) {
            x += availableWidth - width;
        }
        return new Rectangle(x, y, ++width, height);
    }

    private boolean _isTitlesLayoutValid(Perspective pfj, Graphics g) {
        Rectangle titleRect = pfj.getRect(pfj.getTitle());
        Rectangle subtitleRect = pfj.getRect(pfj.getSubtitle());
        Rectangle footnoteRect = pfj.getRect(pfj.getFootnote());
        IdentObj titleID = pfj.getTitle();
        IdentObj subtitleID = pfj.getSubtitle();
        IdentObj footnoteID = pfj.getFootnote();
        if (pfj.getDisplay(titleID) && pfj.getDisplay(subtitleID) && titleRect.intersects(subtitleRect)) {
            return false;
        }
        if (pfj.getDisplay(titleID) && pfj.getDisplay(footnoteID) && titleRect.intersects(footnoteRect)) {
            return false;
        }
        if (pfj.getDisplay(subtitleID) && pfj.getDisplay(footnoteID) && subtitleRect.intersects(footnoteRect)) {
            return false;
        }
        return this._isTitleLayoutValid(pfj, g, pfj.getTitle(), pfj.getTitleString()) && this._isTitleLayoutValid(pfj, g, pfj.getSubtitle(), pfj.getTitleString()) && this._isTitleLayoutValid(pfj, g, pfj.getFootnote(), pfj.getTitleString());
    }

    private boolean _isTitleLayoutValid(Perspective pfj, Graphics g, IdentObj titleID, String titleString) {
        Rectangle frameRect;
        Rectangle legendRect;
        if (!pfj.getDisplay(titleID)) {
            return true;
        }
        Rectangle titleRect = pfj.getRect(titleID);
        int titleRotation = pfj.getTextRotation(titleID);
        int fontSize = !pfj.getFontSizeAbsolute(titleID) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(titleID)) : pfj.getFontSize(titleID);
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(titleID));
        String fontName = pfj.getFontName(titleID);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics tfm = g.getFontMetrics(font);
        Vector strs = new Vector();
        TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        if (titleRotation == 0) {
            tsObj.extractLinesWordWrap(titleString, strs, pfj.getVC().virtToDestWidth(titleRect.width), tfm, pfj.getFontMetricsResolver());
            int i = 0;
            while (i < strs.size()) {
                if (pfj.getFontMetricsResolver().stringWidth((String)strs.elementAt(i), tfm) > pfj.getVC().virtToDestWidth(titleRect.width)) {
                    return false;
                }
                ++i;
            }
            if (titleRect.height < pfj.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(tfm, pfj.getFontMetricsResolver())) * strs.size()) {
                return false;
            }
        } else {
            tsObj.extractLinesWordWrap(titleString, strs, pfj.getVC().virtToDestHeight(titleRect.height), tfm, pfj.getFontMetricsResolver());
            int i = 0;
            while (i < strs.size()) {
                if (pfj.getFontMetricsResolver().stringWidth((String)strs.elementAt(i), tfm) > pfj.getVC().virtToDestHeight(titleRect.height)) {
                    return false;
                }
                ++i;
            }
            if (titleRect.width < pfj.getVC().destToVirtWidth(BILabelLayout.getPFJFontHeight(tfm, pfj.getFontMetricsResolver())) * strs.size()) {
                return false;
            }
        }
        if (this._isLegendDisplayed() && (legendRect = pfj.getLegendRect()).intersects(titleRect)) {
            return false;
        }
        IdentObj frameID = null;
        frameID = this._isPieFrame(pfj.getGraphType()) ? pfj.getPieFrame() : (this._isFunnelFrame(pfj.getGraphType()) ? pfj.getFunnelFrame() : pfj.getFrame());
        return !pfj.getDisplay(frameID) || !titleRect.intersects(frameRect = pfj.getRect(frameID));
    }

    private boolean _isLegendLayoutValid(Perspective pfj, LegendObj legend, Graphics g) {
        if (this._isLegendDisplayed() && !this._isThreeDSurfaceGraph(pfj.getGraphType())) {
            IdentObj legendTextID;
            boolean bFontSizeAbsolute;
            Rectangle frameRect;
            Rectangle legendRect = pfj.getLegendRect();
            IdentObj frameID = null;
            frameID = this._isPieFrame(pfj.getGraphType()) ? pfj.getPieFrame() : (this._isFunnelFrame(pfj.getGraphType()) ? pfj.getFunnelFrame() : pfj.getFrame());
            if (pfj.getDisplay(frameID) && legendRect.intersects(frameRect = pfj.getRect(frameID))) {
                return false;
            }
            boolean bAlongEdge = this.m_commonGraph.getLegendArea().isAlongGraphEdge();
            int position = this.m_commonGraph.getLegendArea().getAutomaticPosition();
            if (!bAlongEdge || position == 0 || position == 1) {
                Rectangle footnoteRect;
                Rectangle subtitleRect;
                Rectangle titleRect;
                IdentObj titleID = pfj.getTitle();
                if (pfj.getDisplay(titleID) && legendRect.intersects(titleRect = pfj.getRect(titleID))) {
                    return false;
                }
                IdentObj subtitleID = pfj.getSubtitle();
                if (pfj.getDisplay(subtitleID) && legendRect.intersects(subtitleRect = pfj.getRect(subtitleID))) {
                    return false;
                }
                IdentObj footnoteID = pfj.getFootnote();
                if (pfj.getDisplay(footnoteID) && legendRect.intersects(footnoteRect = pfj.getRect(footnoteID))) {
                    return false;
                }
            }
            if ((bFontSizeAbsolute = pfj.getFontSizeAbsolute(legendTextID = pfj.getLegendText())) || !pfj.getLegendTextAutofit()) {
                legend.init();
                if (legend.getMarkersLabels().getNumLabels() > 0) {
                    legend.layoutCells();
                }
                int fontSize = pfj.getFontSize(legendTextID);
                if (!bFontSizeAbsolute) {
                    fontSize = pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(legendTextID));
                }
                int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(legendTextID));
                Font legTextFont = new Font(pfj.getFontName(legendTextID), fontStyle, fontSize);
                FontMetrics fm = g.getFontMetrics(legTextFont);
                int fontHeight = TextStyleObj.getFontHeight(fm, pfj.getFontMetricsResolver());
                Dimension dimCell = legend.getDimCell();
                int dimCellHeight = pfj.getVC().virtToDestHeight(dimCell.height);
                if (fontHeight > dimCellHeight) {
                    return false;
                }
            }
            int initialDetNodeCount = pfj.getDetectiv().getVectorList().size();
            legend.calc();
            Dimension labelCellDim = legend.getMarkersLabels().getDimLabelCell();
            TextStyleObj textStyleObj = legend.getMarkersLabels().getTextStyleObj();
            Dimension maxLabelDim = textStyleObj.getDimLargeTextVC(pfj.getVC());
            Vector detNodeList = pfj.getDetectiv().getVectorList();
            int node = detNodeList.size() - 1;
            while (node > initialDetNodeCount - 1) {
                BlackBoxIF bb;
                DetObj detObj = (DetObj)detNodeList.elementAt(node);
                if (detObj != null && (bb = detObj.getBlackBox()) != null) {
                    bb.releaseReferences();
                    detNodeList.removeElementAt(node);
                }
                --node;
            }
            if (maxLabelDim != null && labelCellDim != null && (maxLabelDim.width > labelCellDim.width || maxLabelDim.height > labelCellDim.height)) {
                return false;
            }
        }
        return true;
    }

    private boolean _isThreeDSurfaceGraph(int type) {
        return type == 12 || type == 13 || type == 14;
    }

    private boolean _isPieFrame(int graphType) {
        return graphType >= 55 && graphType <= 60 || graphType >= 93 && graphType <= 94;
    }

    private boolean _isFunnelFrame(int graphType) {
        return graphType == 100;
    }

    private boolean _isLegendDisplayed() {
        return this.m_legendDisplay;
    }

    private void _setLegendDisplayed(LegendObj legend) {
        this.m_legendDisplay = legend != null;
    }

    private static Point adjustFrameFor3D(Perspective pfj, Rectangle rFrame) {
        Point p = new Point(rFrame.x, rFrame.y);
        int depthAngle = pfj.getDepthAngle();
        int depthRadius = pfj.getDepthRadius();
        if (depthRadius > 0 && depthAngle > 0 && depthAngle < 180) {
            int rMax = rFrame.width / 3;
            int r = rMax * depthRadius / 100;
            int dx = (int)((double)r * Math.cos((double)depthAngle * Math.PI / 180.0));
            int dy = (int)((double)r * Math.sin((double)depthAngle * Math.PI / 180.0));
            if (dx >= 0 || dx < 0 && !pfj.isChartOrientHorz()) {
                p.x -= dx;
                p.y -= dy;
            }
        }
        return p;
    }

    private static boolean intersectsComponents(Perspective pfj, Rectangle rect) {
        if (!pfj.getVC().getVirtCoords().contains(rect)) {
            return true;
        }
        boolean ret = false;
        IdentObj[] ids = new IdentObj[]{pfj.getTitle(), pfj.getSubtitle(), pfj.getFootnote(), pfj.getLegendArea()};
        int i = 0;
        while (i < ids.length && !ret) {
            if (pfj.getDisplay(ids[i])) {
                ret = rect.intersects(pfj.getRect(ids[i]));
            }
            ++i;
        }
        return ret;
    }

    private static int getAxisTitleHeight(Graphics g, Perspective pfj, IdentObj idTitle, boolean isVertical) {
        int titleHeight = 0;
        String strTitle = pfj.getTextString(idTitle);
        if (strTitle.length() != 0 && pfj.getDisplay(idTitle)) {
            FontMetrics fm = BILabelLayout.getFontMetrics(g, pfj, idTitle);
            titleHeight = isVertical ? pfj.getVC().destToVirtWidth(BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver()) + 10) : pfj.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(fm, pfj.getFontMetricsResolver()) + 10);
        }
        return titleHeight;
    }

    private static Rectangle getLabelSpace(Graphics g, Perspective pfj, IdentObj idTitle, Rectangle rFrame) {
        boolean isVertical = pfj.isChartOrientHorz();
        int width = 0;
        int height = 0;
        int x = 0;
        int y = 0;
        Point p = BILabelLayout.adjustFrameFor3D(pfj, rFrame);
        Rectangle rect = new Rectangle(p.x, p.y, rFrame.width, rFrame.height);
        IdentObj idLegend = pfj.getLegendArea();
        Rectangle rLegend = null;
        if (pfj.getDisplay(idLegend)) {
            rLegend = pfj.getRect(idLegend);
        }
        IdentObj idFootnote = pfj.getFootnote();
        Rectangle rFootnote = null;
        if (pfj.getDisplay(idFootnote)) {
            rFootnote = pfj.getRect(idFootnote);
        }
        int titleHeight = BILabelLayout.getAxisTitleHeight(g, pfj, idTitle, isVertical);
        Rectangle virtual = pfj.getVC().getVirtCoords();
        if (isVertical) {
            rect.y -= 100;
            rect.height += 200;
            rect.x -= pfj.getVC().destToVirtWidth(5);
            y = rect.y;
            height = rect.height;
            int depthStart = virtual.x;
            if (rLegend != null && rLegend.x + rLegend.width < virtual.x + virtual.width / 2 && rLegend.y + rLegend.height > rect.y && rLegend.y < rect.y + rect.height) {
                depthStart = rLegend.x + rLegend.width;
            }
            x = depthStart + titleHeight;
            width = rect.x - x;
        } else {
            int newDepthStart;
            rect.x -= 100;
            rect.width += 200;
            rect.y -= pfj.getVC().destToVirtHeight(5);
            x = rect.x;
            width = rect.width;
            int depthStart = virtual.y;
            if (rLegend != null && rLegend.y + rLegend.height < virtual.y + virtual.height / 2 && rLegend.x + rLegend.width > rect.x && rLegend.x < rect.x + rect.width) {
                depthStart = rLegend.y + rLegend.height;
            }
            if (rFootnote != null && rFootnote.y + rFootnote.height < virtual.y + virtual.height / 2 && (newDepthStart = rFootnote.y + rFootnote.height) > depthStart) {
                depthStart = newDepthStart;
            }
            y = depthStart + titleHeight;
            height = rect.y - y;
        }
        return new Rectangle(x, y, width, height);
    }

    public static int getJavaFontStyle(int pfjStyle) {
        int fontStyle = 0;
        fontStyle |= (pfjStyle & 1) != 0 ? 2 : 0;
        return fontStyle |= (pfjStyle & 2) != 0 ? 1 : 0;
    }

    public static FontMetrics getFontMetrics(Graphics g, Perspective pfj, IdentObj idLabel) {
        int fontSize = pfj.getFontSize(idLabel);
        if (!pfj.getFontSizeAbsolute(idLabel)) {
            fontSize = pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(idLabel));
        }
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(idLabel));
        Font labelFont = new Font(pfj.getFontName(idLabel), fontStyle, fontSize);
        return g.getFontMetrics(labelFont);
    }

    private static int getLongestLabelWidth(FontMetrics fm, String[] labels, int skip, int skipstart, int[] lengths, FontMetricsResolver resolver) {
        int longest = 0;
        int size = labels.length;
        int index = 0;
        int i = skipstart;
        while (i < size) {
            String str = labels[i];
            if (str != null) {
                int len = resolver.stringWidth(BILabelLayout.limitString(str, false), fm);
                if (lengths != null) {
                    lengths[index++] = len;
                }
                if (len > longest) {
                    longest = len;
                }
            }
            i += skip + 1;
        }
        return longest;
    }

    private static boolean verifyPairLengths(int[] lengths, int step, int width) {
        boolean failed = true;
        if (lengths.length > step) {
            failed = false;
            int l = 0;
            while (!failed && l < lengths.length - step) {
                failed = (lengths[l] + lengths[l + step]) / 2 > width;
                ++l;
            }
        }
        return failed ^ true;
    }

    private static int wordWrap(FontMetrics fm, String[] labels, int skip, int skipstart, int maxWidth, int maxHeight, FontMetricsResolver resolver) {
        int ret = -1;
        int fontHeight = BILabelLayout.getPFJFontHeight(fm, resolver);
        int maxLines = maxHeight / fontHeight;
        if (maxLines > 1) {
            int linesNeeded = 1;
            boolean wrapFailed = false;
            int spaceWidth = resolver.charWidth(' ', fm);
            int size = labels.length;
            int i = skipstart;
            while (!wrapFailed && i < size) {
                String str = labels[i];
                if (str != null) {
                    str = BILabelLayout.limitString(str, false);
                    int colPos = 0;
                    int lines = 1;
                    String separators = " \t\n\r\f";
                    StringTokenizer tokenizer = new StringTokenizer(str, separators, true);
                    while (!wrapFailed && tokenizer.hasMoreTokens()) {
                        String word = tokenizer.nextToken();
                        if (separators.indexOf(word) != -1) {
                            if (!word.equals("\n")) continue;
                            colPos = 0;
                            if (linesNeeded < ++lines) {
                                linesNeeded = lines;
                            }
                            if (lines <= maxLines) continue;
                            wrapFailed = true;
                            continue;
                        }
                        int width = resolver.stringWidth(word = BILabelLayout.limitString(word, true), fm);
                        if (width < maxWidth) {
                            if (colPos != 0) {
                                colPos += spaceWidth;
                            }
                            if ((colPos += width) <= maxWidth) continue;
                            if (++lines <= maxLines) {
                                colPos = width;
                                if (linesNeeded >= lines) continue;
                                linesNeeded = lines;
                                continue;
                            }
                            wrapFailed = true;
                            continue;
                        }
                        wrapFailed = true;
                    }
                }
                i += skip + 1;
            }
            if (!wrapFailed) {
                ret = linesNeeded * fontHeight;
            }
        }
        return ret;
    }

    private static int wordWrap(FontMetrics fm, Vector[] words, int maxWidth, boolean canGrow, int maxLines, FontMetricsResolver resolver) {
        int ret = -1;
        int linesNeeded = 1;
        boolean wrapFailed = false;
        int spaceWidth = resolver.charWidth(' ', fm);
        int size = words.length;
        int i = 0;
        while (!wrapFailed && i < size) {
            int colPos = 0;
            int lines = 1;
            int n = 0;
            while (n < words[i].size() && !wrapFailed) {
                int width = (Integer)words[i].elementAt(n);
                if (width == -1) {
                    colPos = 0;
                    if (linesNeeded < ++lines) {
                        linesNeeded = lines;
                    }
                    if (lines > maxLines) {
                        wrapFailed = true;
                    }
                } else if (width < maxWidth) {
                    if (colPos != 0) {
                        colPos += spaceWidth;
                    }
                    if ((colPos += width) > maxWidth) {
                        if (++lines > maxLines || canGrow && n == words[i].size() - 1 && width < 15) {
                            wrapFailed = true;
                        } else {
                            colPos = width;
                            if (linesNeeded < lines) {
                                linesNeeded = lines;
                            }
                        }
                    }
                } else {
                    wrapFailed = true;
                }
                ++n;
            }
            ++i;
        }
        if (!wrapFailed) {
            ret = linesNeeded;
        }
        return ret;
    }

    private static Vector[] getWordLengths(FontMetrics fm, String[] labels, int skip, int skipstart, FontMetricsResolver resolver) {
        int size = (labels.length - skipstart + skip) / (skip + 1);
        Vector[] words = new Vector[size];
        int i = skipstart;
        int n = 0;
        while (i < labels.length) {
            words[n] = new Vector(10);
            String str = labels[i];
            if (str != null) {
                str = BILabelLayout.limitString(str, false);
                String separators = " \t\n\r\f";
                StringTokenizer tokenizer = new StringTokenizer(str, separators, true);
                while (tokenizer.hasMoreTokens()) {
                    String word = tokenizer.nextToken();
                    if (separators.indexOf(word) != -1) {
                        if (!word.equals("\n")) continue;
                        words[n].add(new Integer(-1));
                        continue;
                    }
                    word = BILabelLayout.limitString(word, true);
                    int width = resolver.stringWidth(word, fm);
                    words[n].add(new Integer(width));
                }
            }
            i += skip + 1;
            ++n;
        }
        return words;
    }

    private static String limitString(String input, boolean isWord) {
        return input;
    }

    private static int[] getPlotAreaShifts(int extra1, int extra2, double f1, double f2, int max_shift, int nLabels) {
        int[] shifts = new int[2];
        if (extra1 > 0 || extra2 > 0) {
            if (nLabels == 1) {
                if (-extra2 - extra1 < 0) {
                    return null;
                }
                if (extra1 > 0) {
                    shifts[0] = (int)((double)extra1 / f1);
                } else {
                    shifts[1] = (int)((double)extra2 / f2);
                }
                if (shifts[0] + shifts[1] > max_shift) {
                    return null;
                }
            } else {
                boolean shift_failed = false;
                do {
                    if (extra2 > 0) {
                        int delta = (int)((double)extra2 / f2);
                        shifts[1] = shifts[1] + delta;
                        extra2 = 0;
                        extra1 += (int)((double)delta * (1.0 - f1));
                    }
                    if (extra1 > 0) {
                        int delta = (int)((double)extra1 / f1);
                        shifts[0] = shifts[0] + delta;
                        extra1 = 0;
                        extra2 += (int)((double)delta * (1.0 - f2));
                    }
                    boolean bl = shift_failed = shifts[0] + shifts[1] > max_shift;
                } while (!shift_failed && extra2 > 100);
                if (shift_failed) {
                    return null;
                }
            }
        }
        return shifts;
    }

    private void doLegendAutoLayout(Graphics g, LegendObj legend, Access access, JChart_Base chart, Perspective pfj, boolean bReset, int graphType, boolean second) {
        int position;
        if (legend == null || !this._isLegendDisplayed() || this._isThreeDSurfaceGraph(graphType)) {
            return;
        }
        if (!second) {
            this.setLegendProps(pfj);
            legend.init();
        }
        if ((position = this.m_commonGraph.getLegendArea().getAutomaticPosition()) == 2 || position == 3) {
            this.doLegendAutoLayoutLR(g, legend, access, chart, pfj, position, graphType, second);
        } else if (!second) {
            this.doLegendAutoLayoutTB(g, legend, access, chart, pfj, position, graphType);
        }
    }

    private void doLegendAutoLayoutTB(Graphics g, LegendObj legend, Access access, JChart_Base chart, Perspective pfj, int position, int graphType) {
        int range;
        int totalNumSeries;
        Attr attr;
        IdentObj frameId;
        int maxLegendWidth = 32000;
        boolean alongEdge = this.m_commonGraph.getLegendArea().isAlongGraphEdge();
        if (!alongEdge) {
            maxLegendWidth -= 2 * this.m_commonGraphMarginH;
        }
        if (alongEdge) {
            maxLegendWidth -= pfj.getVC().destToVirtWidth(1);
        }
        pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendOrient, new Integer(1), this.m_reset ^ true);
        Rectangle titleRect = null;
        Rectangle subtitleRect = null;
        Rectangle footnoteRect = null;
        boolean titleVisible = pfj.getTitleDisplay();
        boolean subtitleVisible = pfj.getSubtitleDisplay();
        boolean footnoteVisible = pfj.getFootnoteDisplay();
        boolean isPie = this._isPieFrame(graphType);
        boolean isFunnel = this._isFunnelFrame(graphType);
        if (isPie) {
            frameId = pfj.getPieFrame();
            attr = Attr.PieFrameRect;
        } else if (isFunnel) {
            frameId = pfj.getFunnelFrame();
            attr = Attr.FunnelFrameRect;
        } else {
            frameId = pfj.getFrame();
            attr = Attr.FrameRect;
        }
        Rectangle rFrame = (Rectangle)pfj.getRect(frameId).clone();
        Rectangle rLegend = (Rectangle)pfj.getRect(pfj.getLegendArea()).clone();
        if (titleVisible) {
            titleRect = (Rectangle)pfj.getRect(pfj.getTitle()).clone();
        }
        if (subtitleVisible) {
            subtitleRect = (Rectangle)pfj.getRect(pfj.getSubtitle()).clone();
        }
        if (footnoteVisible) {
            footnoteRect = (Rectangle)pfj.getRect(pfj.getFootnote()).clone();
        }
        VC vc = pfj.getVC();
        int vspace = vc.destToVirtHeight(2);
        int plotAreaY1 = rFrame.y + rFrame.height;
        IdentObj idLegendText = pfj.getLegendText();
        int fontSize = !pfj.getFontSizeAbsolute(idLegendText) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(idLegendText)) : pfj.getFontSize(idLegendText);
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(idLegendText));
        String fontName = pfj.getFontName(idLegendText);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics fm = g.getFontMetrics(font);
        int fontHeight = TextStyleObj.getFontHeight(fm, pfj.getFontMetricsResolver());
        int markerSize = pfj.getLegendMarkerSize();
        int markerWidthVc = vc.destToVirtWidth(markerSize);
        int fontHeightVc = vc.destToVirtHeight(fontHeight);
        int markerHeightVc = vc.destToVirtHeight(markerSize);
        int markerLabelHeight = Math.max(fontHeightVc, markerHeightVc);
        String[] referenceLineLabels = this.getReferenceObjectLabels(pfj);
        String drillText = this.getDrillText(pfj);
        int minLen = pfj.getMinLength(idLegendText);
        int minWidth = 0;
        if (isFunnel) {
            range = totalNumSeries = pfj.getThresholdCount();
        } else {
            totalNumSeries = access.getNumTotalSeries();
            range = legend.getSeriesRange() - legend.getSeriesStart();
            if (chart.isSingleSeriesOnly()) {
                totalNumSeries = 1;
            }
        }
        int seriesLabelsInData = totalNumSeries++;
        String selectPointText = null;
        if (graphType == 99) {
            selectPointText = pfj.getTextString(new IdentObj(509));
        }
        if (!isFunnel) {
            totalNumSeries += referenceLineLabels.length;
            if (drillText != null) {
                ++totalNumSeries;
            }
        }
        maxLegendWidth -= legend.DOUBLE_BOX_MARGIN_W;
        String[] labels = new String[totalNumSeries];
        boolean exceedsWidth = false;
        int totalWidth = 0;
        int mW = 0;
        int j = 0;
        int k = 0;
        if (!isFunnel && drillText != null) {
            labels[k] = drillText;
            ++k;
        }
        int i = 0;
        while (i < totalNumSeries - k) {
            labels[i + k] = isFunnel ? pfj.getThresholdText(i) : (i == seriesLabelsInData && selectPointText != null ? selectPointText : (i >= seriesLabelsInData ? referenceLineLabels[j++] : pfj.getSeriesLabel(i)));
            ++i;
        }
        if (minLen > 0) {
            minWidth = totalNumSeries > 0 && labels[0] != null && labels[0].length() >= minLen ? pfj.getFontMetricsResolver().stringWidth(labels[0].substring(0, minLen) + "...", fm) : pfj.getFontMetricsResolver().stringWidth("a", fm) * minLen + pfj.getFontMetricsResolver().stringWidth("...", fm);
        }
        int i2 = 0;
        while (i2 < totalNumSeries) {
            if (!exceedsWidth) {
                int w = pfj.getFontMetricsResolver().stringWidth(labels[i2], fm);
                if (w > mW) {
                    mW = w;
                }
                if ((totalWidth = (vc.destToVirtWidth(mW) + markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN) * range) > maxLegendWidth) {
                    exceedsWidth = true;
                }
            }
            ++i2;
        }
        int reqWidth = 0;
        int reqHeight = 0;
        int maxLegendHeight = 8000 - legend.DOUBLE_BOX_MARGIN_HT;
        if (!this.m_plotAreaDisplay) {
            maxLegendHeight = 32000 - legend.DOUBLE_BOX_MARGIN_HT;
        }
        Dimension legendTitleDim = LegendObj.calcLegendTitleDim(maxLegendWidth, pfj);
        int legendTitleHeight = legendTitleDim.height;
        int legendTitleWidth = legendTitleDim.width;
        maxLegendHeight -= legendTitleHeight;
        if (!pfj.getLegendDisplay()) {
            reqWidth = legendTitleWidth + legend.DOUBLE_BOX_MARGIN_W;
            reqHeight = legendTitleHeight + legend.BOX_MARGIN_HT;
        } else if (!exceedsWidth) {
            if (!alongEdge) {
                reqWidth = totalWidth;
                if (legendTitleWidth > reqWidth) {
                    reqWidth = legendTitleWidth;
                }
            } else {
                reqWidth = maxLegendWidth;
            }
            reqWidth += legend.DOUBLE_BOX_MARGIN_W;
            reqHeight = markerLabelHeight + legend.DOUBLE_BOX_MARGIN_HT;
            reqHeight += legendTitleHeight;
        } else if (maxLegendHeight < markerLabelHeight || maxLegendWidth < markerWidthVc + legend.getMarkersLabels().MKR_MARGIN) {
            reqWidth = maxLegendWidth + legend.DOUBLE_BOX_MARGIN_W;
            reqHeight = maxLegendHeight + legend.DOUBLE_BOX_MARGIN_HT;
        } else {
            int maxRows = (maxLegendHeight + vspace) / (markerLabelHeight + vspace);
            int maxColumns = maxLegendWidth / (markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(minWidth));
            if (maxRows * maxColumns < labels.length) {
                this.logAllMarkersError();
                pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(maxColumns), this.m_reset ^ true);
                pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendSeriesCount, new Integer(maxRows * maxColumns), this.m_reset ^ true);
                if (minWidth <= 0) {
                    legend.getMarkersLabels().setDrawLabels(false);
                }
                reqHeight = maxRows * markerLabelHeight + (maxRows - 1) * vspace;
                reqWidth = (markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(minWidth)) * maxColumns;
            } else {
                int maxStrWidth = 0;
                int i3 = 0;
                while (i3 < totalNumSeries) {
                    int w;
                    if (labels[i3] != null && (w = pfj.getFontMetricsResolver().stringWidth(labels[i3], fm)) > maxStrWidth) {
                        maxStrWidth = w;
                    }
                    ++i3;
                }
                int widthPerCol = markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(maxStrWidth);
                int heightPerCol = markerLabelHeight + vspace;
                int columns = maxLegendWidth / widthPerCol;
                int rows = maxLegendHeight / heightPerCol;
                if (maxRows == 0) {
                    maxRows = 1;
                }
                if (columns == 0) {
                    columns = 1;
                }
                if (rows == 0) {
                    rows = 1;
                }
                if (rows > maxRows) {
                    rows = maxRows;
                    columns = range / rows;
                    if (range % rows != 0) {
                        ++columns;
                    }
                    reqWidth = maxLegendWidth;
                } else {
                    reqWidth = widthPerCol * columns;
                    rows = range / columns;
                    if (range % columns != 0) {
                        ++rows;
                    }
                    if (rows > maxRows) {
                        rows = maxRows;
                        columns = range / rows;
                        if (range % rows != 0) {
                            ++columns;
                        }
                        reqWidth = maxLegendWidth;
                    }
                }
                pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(columns), this.m_reset ^ true);
                reqHeight = markerLabelHeight * rows + (rows - 1) * vspace;
            }
            if (legendTitleWidth > reqWidth) {
                reqWidth = legendTitleWidth;
            }
            if (reqHeight > maxLegendHeight) {
                reqHeight = maxLegendHeight;
            }
            if (reqWidth > maxLegendWidth) {
                reqWidth = maxLegendWidth;
            }
            reqHeight += legend.DOUBLE_BOX_MARGIN_HT;
            reqHeight += legendTitleHeight;
            reqWidth += legend.DOUBLE_BOX_MARGIN_W;
            if (alongEdge) {
                reqWidth = 32000;
            }
        }
        int maxTopPos = 16000 - this.m_commonGraphMarginV;
        int maxBottomPos = -16000 + this.m_commonGraphMarginV;
        if (titleRect != null) {
            maxTopPos = titleRect.y - this.m_commonGraphMarginV;
        }
        if (subtitleRect != null) {
            maxTopPos = subtitleRect.y - this.m_commonGraphMarginV;
        }
        if (footnoteRect != null) {
            maxBottomPos = footnoteRect.y + footnoteRect.height + this.m_commonGraphMarginV;
        }
        if (position == 0) {
            int oldht = rLegend.height;
            rLegend.height = reqHeight;
            rLegend.width = reqWidth;
            rLegend.x = -(reqWidth / 2);
            if (!alongEdge) {
                rLegend.y = maxTopPos - reqHeight;
            } else {
                rLegend.y = 16000 - reqHeight;
                rLegend.width -= vc.destToVirtWidth(1);
                Rectangle defLRect = this.m_commonGraph.getLegendArea().getDefaultPFJRect(0, true);
                int diff = rLegend.height - defLRect.height;
                rFrame.height -= diff;
            }
        }
        if (position == 1) {
            rLegend.height = reqHeight;
            rLegend.width = reqWidth;
            rLegend.x = -(reqWidth / 2);
            if (!alongEdge) {
                rLegend.y = maxBottomPos;
            } else {
                rLegend.y = -16000 + vc.destToVirtHeight(1);
                rLegend.width -= vc.destToVirtWidth(1);
                Rectangle defLRect = this.m_commonGraph.getLegendArea().getDefaultPFJRect(1, true);
                int diff = rLegend.height - defLRect.height;
                rFrame.y += diff;
                rFrame.height -= diff;
            }
        }
        pfj.putToLookNoCalc(frameId, attr, rFrame, this.m_reset ^ true);
        pfj.putToLookNoCalc(pfj.getLegendArea(), Attr.LegendAreaRect, rLegend, this.m_reset ^ true);
    }

    private void doLegendAutoLayoutLR(Graphics g, LegendObj legend, Access access, JChart_Base chart, Perspective pfj, int position, int graphType, boolean second) {
        int reqWidth2;
        int reqHeight;
        int range;
        int totalNumSeries;
        int maxLegendWidth = 10666;
        if (!this.m_plotAreaDisplay) {
            maxLegendWidth = 32000;
        }
        pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendOrient, new Integer(0), this.m_reset ^ true);
        Rectangle titleRect = null;
        Rectangle subtitleRect = null;
        Rectangle footnoteRect = null;
        boolean wordWrap = false;
        boolean titleVisible = pfj.getTitleDisplay();
        boolean subtitleVisible = pfj.getSubtitleDisplay();
        boolean footnoteVisible = pfj.getFootnoteDisplay();
        boolean isPie = this._isPieFrame(graphType);
        boolean isFunnel = this._isFunnelFrame(graphType);
        IdentObj frameId = isPie ? pfj.getPieFrame() : (isFunnel ? pfj.getFunnelFrame() : pfj.getFrame());
        Rectangle rFrame = (Rectangle)pfj.getRect(frameId).clone();
        Rectangle rLegend = (Rectangle)pfj.getRect(pfj.getLegendArea()).clone();
        VC vc = pfj.getVC();
        int markerSize = pfj.getLegendMarkerSize();
        int markerWidthVc = vc.destToVirtWidth(markerSize);
        if (second) {
            int pieFrameWidthDc = pfj.getVC().virtToDestWidth(rFrame.width);
            JChart_2D_Pie pieChart = (JChart_2D_Pie)chart;
            int reqPieWidth = pieChart.calcReqWidth(rFrame);
            if (reqPieWidth < 0) {
                return;
            }
            int extraFrameWidth = pieFrameWidthDc - reqPieWidth;
            if (extraFrameWidth < 0) {
                return;
            }
            rFrame.width = pfj.getVC().destToVirtWidth(reqPieWidth);
            maxLegendWidth = 32000 - rFrame.width - (legend.getMarkersLabels().DOUBLE_MKR_MARGIN + markerWidthVc + legend.DOUBLE_BOX_MARGIN_W + this.m_commonGraphMarginH);
            if (position == 3) {
                rFrame.x = 16000 - this.m_commonGraphMarginH - rFrame.width;
            }
            pfj.putToLookNoCalc(frameId, Attr.PieFrameRect, rFrame, this.m_reset ^ true);
        }
        if (titleVisible) {
            titleRect = pfj.getRect(pfj.getTitle());
        }
        if (subtitleVisible) {
            subtitleRect = pfj.getRect(pfj.getSubtitle());
        }
        if (footnoteVisible) {
            footnoteRect = pfj.getRect(pfj.getFootnote());
        }
        int vspace = vc.destToVirtHeight(2);
        int plotAreaY1 = rFrame.y + rFrame.height;
        int maxTopPos = 16000;
        int maxBottomPos = -16000;
        boolean alongEdge = this.m_commonGraph.getLegendArea().isAlongGraphEdge();
        if (!alongEdge) {
            if (position == 2) {
                if (titleRect != null && titleRect.x + titleRect.width > 16000 - maxLegendWidth - this.m_commonGraphLegendGapH * 2) {
                    maxTopPos = titleRect.y - this.m_commonGraphMarginV;
                }
                if (subtitleRect != null && subtitleRect.x + subtitleRect.width > 16000 - maxLegendWidth - this.m_commonGraphLegendGapH * 2) {
                    maxTopPos = subtitleRect.y - this.m_commonGraphMarginV;
                }
                if (footnoteRect != null && footnoteRect.x + footnoteRect.width > 16000 - maxLegendWidth - this.m_commonGraphLegendGapH * 2) {
                    maxBottomPos = footnoteRect.y + footnoteRect.height + this.m_commonGraphMarginV;
                }
            } else {
                if (titleRect != null && titleRect.x < -16000 + maxLegendWidth + this.m_commonGraphLegendGapH * 2) {
                    maxTopPos = titleRect.y - this.m_commonGraphMarginV;
                }
                if (subtitleRect != null && subtitleRect.x < -16000 + maxLegendWidth + this.m_commonGraphLegendGapH * 2) {
                    maxTopPos = subtitleRect.y - this.m_commonGraphMarginV;
                }
                if (footnoteRect != null && footnoteRect.x < -16000 + maxLegendWidth + this.m_commonGraphLegendGapH * 2) {
                    maxBottomPos = footnoteRect.y + footnoteRect.height + this.m_commonGraphMarginV;
                }
            }
        }
        this.m_maxBottomY = maxBottomPos;
        int maxLegendHeight = maxTopPos - maxBottomPos;
        maxLegendHeight -= legend.DOUBLE_BOX_MARGIN_HT;
        Dimension legendTitleDim = LegendObj.calcLegendTitleDim(maxLegendWidth -= legend.DOUBLE_BOX_MARGIN_W, pfj);
        int legendTitleHeight = legendTitleDim.height;
        int legendTitleWidth = legendTitleDim.width;
        maxLegendHeight -= legendTitleHeight;
        String[] referenceLineLabels = this.getReferenceObjectLabels(pfj);
        String drillText = this.getDrillText(pfj);
        if (isFunnel) {
            range = totalNumSeries = pfj.getThresholdCount();
        } else {
            totalNumSeries = access.getNumTotalSeries();
            range = legend.getSeriesRange() - legend.getSeriesStart();
            if (chart.isSingleSeriesOnly()) {
                totalNumSeries = 1;
            }
        }
        int seriesLabelsInData = totalNumSeries++;
        String selectPointText = null;
        if (graphType == 99) {
            selectPointText = pfj.getTextString(new IdentObj(509));
        }
        if (!isFunnel) {
            totalNumSeries += referenceLineLabels.length;
            if (drillText != null) {
                ++totalNumSeries;
            }
        }
        String[] labels = new String[totalNumSeries];
        int[] numWrappedLines = new int[totalNumSeries];
        boolean truncatedText = false;
        int j = 0;
        int k = 0;
        if (!isFunnel && drillText != null) {
            labels[k] = drillText;
            ++k;
        }
        int i = 0;
        while (i < totalNumSeries - k) {
            labels[i + k] = isFunnel ? pfj.getThresholdText(i) : (i == seriesLabelsInData && selectPointText != null ? selectPointText : (i >= seriesLabelsInData ? referenceLineLabels[j++] : pfj.getSeriesLabel(i)));
            ++i;
        }
        IdentObj idLegendText = pfj.getLegendText();
        int fontSize = !pfj.getFontSizeAbsolute(idLegendText) ? pfj.getVC().virtToDestHeight(pfj.getFontSizeVC(idLegendText)) : pfj.getFontSize(idLegendText);
        int fontStyle = BILabelLayout.getJavaFontStyle(pfj.getFontStyle(idLegendText));
        String fontName = pfj.getFontName(idLegendText);
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics fm = g.getFontMetrics(font);
        int fontHeight = TextStyleObj.getFontHeight(fm, pfj.getFontMetricsResolver());
        int fontHeightVc = vc.destToVirtHeight(fontHeight);
        int markerHeightVc = vc.destToVirtHeight(markerSize);
        int markerLabelHeight = Math.max(fontHeightVc, markerHeightVc);
        int fontDescentVc = vc.destToVirtHeight(pfj.getFontMetricsResolver().getDescent(fm));
        int minLen = pfj.getMinLength(idLegendText);
        int minTextWidth = 0;
        if (minLen > 0) {
            minTextWidth = totalNumSeries > 0 && labels[0] != null && labels[0].length() >= minLen ? pfj.getFontMetricsResolver().stringWidth(labels[0].substring(0, minLen) + "...", fm) : pfj.getFontMetricsResolver().stringWidth("a", fm) * minLen + pfj.getFontMetricsResolver().stringWidth("...", fm);
        }
        int oldReqHeight = reqHeight = markerLabelHeight * range + (range - 1) * vspace;
        if (!pfj.getLegendDisplay()) {
            int reqWidth2 = legendTitleWidth + legend.DOUBLE_BOX_MARGIN_W;
            reqHeight = legendTitleHeight + legend.BOX_MARGIN_HT;
            this.setRectangles(position, rLegend, rFrame, graphType, isPie, frameId, pfj, reqWidth2, reqHeight, alongEdge);
            return;
        }
        if (reqHeight < maxLegendHeight) {
            if (maxLegendWidth <= markerWidthVc + legend.getMarkersLabels().MKR_MARGIN) {
                legend.getMarkersLabels().setDrawLabels(false);
                int reqWidth2 = maxLegendWidth + legend.getMarkersLabels().DOUBLE_MKR_MARGIN;
                this.setRectangles(position, rLegend, rFrame, graphType, isPie, frameId, pfj, reqWidth2, reqHeight += legendTitleHeight, alongEdge);
                return;
            }
            int minWrapHeight = fontHeightVc * 2 * range + (range - 1) * vspace;
            if (maxLegendHeight > minWrapHeight) {
                int minWidth;
                int maxStrWidth = 0;
                int i2 = 0;
                while (i2 < totalNumSeries) {
                    int w;
                    if (labels[i2] != null && (w = pfj.getFontMetricsResolver().stringWidth(labels[i2], fm)) > maxStrWidth) {
                        maxStrWidth = w;
                    }
                    ++i2;
                }
                int maxStrWidthVc = vc.destToVirtWidth(maxStrWidth);
                if (maxStrWidthVc < (minWidth = 3200)) {
                    reqWidth2 = maxStrWidthVc;
                } else {
                    boolean oneWord = true;
                    int wordWidth = 0;
                    int i3 = 0;
                    while (i3 < totalNumSeries) {
                        if (labels[i3] != null) {
                            int count = 0;
                            StringTokenizer tokens = new StringTokenizer(labels[i3], " ");
                            while (tokens.hasMoreTokens()) {
                                ++count;
                                String word = tokens.nextToken();
                                int w = pfj.getFontMetricsResolver().stringWidth(word, fm);
                                if (w <= wordWidth) continue;
                                wordWidth = w;
                            }
                            if (count > 1) {
                                oneWord = false;
                            }
                        }
                        ++i3;
                    }
                    if (oneWord) {
                        reqWidth2 = maxStrWidthVc;
                        if (reqWidth2 > maxLegendWidth) {
                            reqWidth2 = maxLegendWidth;
                        }
                    } else {
                        minWidth = Math.max(minWidth, vc.destToVirtWidth(wordWidth));
                        boolean done = false;
                        int wrappedLines = 0;
                        Vector allVectors = new Vector();
                        while (!done) {
                            if (minWidth > maxLegendWidth) {
                                minWidth = maxLegendWidth;
                                done = true;
                            }
                            if (second) {
                                minWidth = maxLegendWidth;
                            }
                            wordWrap = true;
                            Vector strs = null;
                            wrappedLines = 0;
                            int i4 = 0;
                            while (i4 < totalNumSeries) {
                                if (labels[i4] != null) {
                                    strs = new Vector();
                                    TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
                                    tsObj.setTextTruncate(true, -1, 1);
                                    numWrappedLines[i4] = tsObj.extractLinesWordWrap(labels[i4], strs, vc.virtToDestWidth(minWidth), fm, pfj.getFontMetricsResolver());
                                    if (tsObj.isTextTruncated()) {
                                        truncatedText = true;
                                    }
                                    tsObj = null;
                                    if (strs != null && numWrappedLines[i4] > wrappedLines) {
                                        wrappedLines = numWrappedLines[i4];
                                    }
                                    allVectors.addElement(strs);
                                    if (fontHeightVc * wrappedLines * range + (range - 1) * vspace > maxLegendHeight) break;
                                }
                                ++i4;
                            }
                            reqHeight = fontHeightVc * wrappedLines * range + (range - 1) * vspace;
                            if (!done && reqHeight > maxLegendHeight) {
                                minWidth += (int)((double)((float)reqHeight / (float)maxLegendHeight) * 0.5 * (double)minWidth);
                            }
                            if (reqHeight > maxLegendHeight) continue;
                            done = true;
                        }
                        if (minWidth < maxLegendWidth && reqHeight < maxLegendHeight) {
                            int longSubString = 0;
                            Enumeration e = allVectors.elements();
                            while (e.hasMoreElements()) {
                                Vector v = (Vector)e.nextElement();
                                Enumeration enum2 = v.elements();
                                while (enum2.hasMoreElements()) {
                                    String nextElem = (String)enum2.nextElement();
                                    int len = pfj.getFontMetricsResolver().stringWidth(nextElem, fm);
                                    if (len <= longSubString) continue;
                                    longSubString = len;
                                }
                            }
                            minWidth = vc.destToVirtWidth(longSubString);
                            if ((double)minWidth + (double)maxStrWidthVc * 0.1 >= (double)maxStrWidthVc || minWidth + vc.destToVirtWidth(15) >= maxStrWidthVc) {
                                wordWrap = false;
                                pfj.putToLookNoCalc(idLegendText, Attr.TextWrap, new Boolean(false), this.m_reset ^ true);
                                reqHeight = oldReqHeight;
                                minWidth = maxStrWidthVc;
                            }
                        }
                        if (reqHeight > maxLegendHeight) {
                            int i5 = 1;
                            while (i5 < wrappedLines) {
                                int ht = fontHeightVc * i5 * range + (range - 1) * vspace;
                                if (ht >= maxLegendHeight) break;
                                reqHeight = ht;
                                ++i5;
                            }
                        }
                        reqWidth2 = minWidth;
                    }
                }
                reqHeight += legend.DOUBLE_BOX_MARGIN_HT;
                if (alongEdge) {
                    reqHeight = maxLegendHeight + legend.DOUBLE_BOX_MARGIN_HT;
                }
                if ((reqWidth2 = reqWidth2 + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + markerWidthVc) < legendTitleWidth) {
                    reqWidth2 = legendTitleWidth;
                }
                reqWidth2 += legend.DOUBLE_BOX_MARGIN_W;
                pfj.putToLookNoCalc(idLegendText, Attr.TextWrap, new Boolean(wordWrap), this.m_reset ^ true);
                if (wordWrap) {
                    legend.setWrappedLines(numWrappedLines, truncatedText);
                }
            } else {
                reqHeight += legend.DOUBLE_BOX_MARGIN_HT;
                int maxStrWidth = 0;
                int i6 = 0;
                while (i6 < totalNumSeries) {
                    int w;
                    if (labels[i6] != null && (w = pfj.getFontMetricsResolver().stringWidth(labels[i6], fm)) > maxStrWidth) {
                        maxStrWidth = w;
                    }
                    ++i6;
                }
                reqWidth2 = vc.destToVirtWidth(maxStrWidth) + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + markerWidthVc;
                if (reqWidth2 < legendTitleWidth) {
                    reqWidth2 = legendTitleWidth;
                }
                if (reqWidth2 > maxLegendWidth) {
                    reqWidth2 = maxLegendWidth;
                }
                reqWidth2 += legend.DOUBLE_BOX_MARGIN_W;
                if (alongEdge) {
                    reqHeight = maxLegendHeight + legend.DOUBLE_BOX_MARGIN_HT;
                }
            }
        } else {
            int columns;
            if (maxLegendWidth <= markerWidthVc + legend.getMarkersLabels().MKR_MARGIN) {
                legend.getMarkersLabels().setDrawLabels(false);
                reqHeight = maxLegendHeight + legend.DOUBLE_BOX_MARGIN_HT;
                int reqWidth2 = maxLegendWidth + legend.DOUBLE_BOX_MARGIN_W;
                this.setRectangles(position, rLegend, rFrame, graphType, isPie, frameId, pfj, reqWidth2, reqHeight += legendTitleHeight, alongEdge);
                return;
            }
            if (maxLegendHeight <= 0) {
                columns = 1;
            } else {
                columns = reqHeight / maxLegendHeight;
                if (reqHeight % maxLegendHeight != 0) {
                    ++columns;
                }
            }
            int labelsPerColumn = range / columns;
            int reqHeightPerCol = markerLabelHeight * labelsPerColumn + (labelsPerColumn - 1) * vspace;
            if (reqHeightPerCol + markerLabelHeight + vspace < maxLegendHeight) {
                reqHeightPerCol = reqHeightPerCol + markerLabelHeight + vspace;
                ++labelsPerColumn;
            }
            if (labelsPerColumn == 0) {
                columns = 1;
            } else {
                columns = totalNumSeries / labelsPerColumn;
                if (totalNumSeries % labelsPerColumn != 0) {
                    ++columns;
                }
            }
            pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(columns), this.m_reset ^ true);
            int widthPerColumn = maxLegendWidth / columns;
            if (widthPerColumn < markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(minTextWidth)) {
                this.logAllMarkersError();
                columns = maxLegendWidth / (markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(minTextWidth));
                pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(columns), this.m_reset ^ true);
                pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendSeriesCount, new Integer(columns * labelsPerColumn), this.m_reset ^ true);
                if (minTextWidth <= 0) {
                    legend.getMarkersLabels().setDrawLabels(false);
                }
                reqWidth2 = columns * (markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(minTextWidth));
            } else {
                int maxStrWidth = 0;
                int i7 = 0;
                while (i7 < totalNumSeries) {
                    int w;
                    if (labels[i7] != null && (w = pfj.getFontMetricsResolver().stringWidth(labels[i7], fm)) > maxStrWidth) {
                        maxStrWidth = w;
                    }
                    ++i7;
                }
                int actualWidthPerCol = markerWidthVc + legend.getMarkersLabels().DOUBLE_MKR_MARGIN + vc.destToVirtWidth(maxStrWidth);
                reqWidth2 = actualWidthPerCol * columns;
                if (reqWidth2 > maxLegendWidth) {
                    reqWidth2 = maxLegendWidth;
                }
            }
            if (reqWidth2 < legendTitleWidth) {
                reqWidth2 = legendTitleWidth;
            }
            reqWidth2 += legend.DOUBLE_BOX_MARGIN_W;
            reqHeight = reqHeightPerCol + legend.DOUBLE_BOX_MARGIN_HT;
            if (alongEdge) {
                reqHeight = maxLegendHeight + legend.DOUBLE_BOX_MARGIN_HT;
            }
        }
        this.setRectangles(position, rLegend, rFrame, graphType, isPie, frameId, pfj, reqWidth2, reqHeight += legendTitleHeight, alongEdge);
    }

    private String getDrillText(Perspective pfj) {
        IdentObj idText = new IdentObj(235);
        if (!pfj.getDrillCallback().isDrillingEnabled() || pfj.getTextString(idText) == null || !pfj.getDisplay(idText)) {
            return null;
        }
        String szLabel = pfj.getTextString(idText);
        return szLabel;
    }

    private String[] getReferenceObjectLabels(Perspective pfj) {
        Vector<String> str = new Vector<String>();
        ArrayList referenceObjects = pfj.getReferenceObjectList();
        if (referenceObjects != null && !referenceObjects.isEmpty()) {
            int i = 0;
            while (i < referenceObjects.size()) {
                IdentObj roID = (IdentObj)referenceObjects.get(i);
                if (pfj.getDisplay(pfj.getReferenceLegendText(roID))) {
                    str.addElement(pfj.getTextString(roID));
                }
                ++i;
            }
        }
        String[] lines = new String[str.size()];
        int i = 0;
        while (i < lines.length) {
            lines[i] = (String)str.elementAt(i);
            ++i;
        }
        return lines;
    }

    private void setRectangles(int position, Rectangle rLegend, Rectangle rFrame, int graphType, boolean isPie, IdentObj frameId, Perspective pfj, int reqWidth, int reqHeight, boolean alongEdge) {
        if (position == 2) {
            if (alongEdge) {
                rLegend.x = 16000 - reqWidth - pfj.getVC().destToVirtWidth(1);
                rLegend.width = reqWidth;
                rLegend.height = reqHeight - pfj.getVC().destToVirtHeight(1);
            } else {
                rLegend.x = 16000 - this.m_commonGraphMarginH - reqWidth;
                rLegend.width = reqWidth;
                rLegend.height = reqHeight;
            }
            pfj.putToLookNoCalc(pfj.getLegendArea(), Attr.LegendAreaRect, rLegend, this.m_reset ^ true);
        } else {
            if (alongEdge) {
                rLegend.x = -16000;
                rLegend.height = reqHeight - pfj.getVC().destToVirtHeight(1);
            } else {
                rLegend.x = -16000 + this.m_commonGraphMarginH;
                rLegend.height = reqHeight;
            }
            rLegend.width = reqWidth;
            pfj.putToLookNoCalc(pfj.getLegendArea(), Attr.LegendAreaRect, rLegend, this.m_reset ^ true);
        }
    }

    public void maximizePlotArea(LegendObj legend, Perspective pfj, JChart_Base chart) {
        int vspace;
        Attr attr;
        IdentObj frameId;
        boolean alongEdge = this.m_commonGraph.getLegendArea().isAlongGraphEdge();
        int position = this.m_commonGraph.getLegendArea().getAutomaticPosition();
        Rectangle titleRect = null;
        Rectangle subtitleRect = null;
        Rectangle footnoteRect = null;
        boolean titleVisible = pfj.getTitleDisplay();
        boolean subtitleVisible = pfj.getSubtitleDisplay();
        boolean footnoteVisible = pfj.getFootnoteDisplay();
        int graphType = this.m_commonGraph.getGraphType();
        boolean isPie = this._isPieFrame(graphType);
        boolean isFunnel = this._isFunnelFrame(graphType);
        if (isPie) {
            frameId = pfj.getPieFrame();
            attr = Attr.PieFrameRect;
        } else if (isFunnel) {
            frameId = pfj.getFunnelFrame();
            attr = Attr.FunnelFrameRect;
        } else {
            frameId = pfj.getFrame();
            attr = Attr.FrameRect;
        }
        Rectangle rFrame = (Rectangle)pfj.getRect(frameId).clone();
        Rectangle rLegend = (Rectangle)pfj.getRect(pfj.getLegendArea()).clone();
        if (titleVisible) {
            titleRect = (Rectangle)pfj.getRect(pfj.getTitle()).clone();
        }
        if (subtitleVisible) {
            subtitleRect = (Rectangle)pfj.getRect(pfj.getSubtitle()).clone();
        }
        if (footnoteVisible) {
            footnoteRect = (Rectangle)pfj.getRect(pfj.getFootnote()).clone();
        }
        int plotAreaY1 = rFrame.y + rFrame.height;
        int maxTopY = 16000;
        boolean legendVisible = this._isLegendDisplayed();
        if (legendVisible) {
            legend.adjustForDataScroller(rLegend);
            legend.adjustForLegendScroller(rLegend);
        }
        if (legendVisible && position == 0 && !alongEdge) {
            maxTopY = rLegend.y;
            vspace = this.m_commonGraphLegendGapV;
        } else {
            vspace = this.m_commonGraphMarginV;
            if (legendVisible && position == 0 && alongEdge) {
                maxTopY = rLegend.y;
            }
            if (titleRect != null) {
                maxTopY = titleRect.y;
            }
            if (subtitleRect != null) {
                maxTopY = subtitleRect.y;
            }
            if ((pfj.getCustomLayout() & 2) != 0) {
                maxTopY -= pfj.getVC().destToVirtWidth(12);
            }
        }
        int maxBottomY = -16000;
        if (legendVisible && position == 1 && !alongEdge) {
            maxBottomY = rLegend.y + rLegend.height;
            vspace = this.m_commonGraphLegendGapV;
        } else {
            vspace = this.m_commonGraphMarginV;
            if (legendVisible && position == 1 && alongEdge) {
                maxBottomY = rLegend.y + rLegend.height;
            }
            if (footnoteRect != null) {
                maxBottomY = footnoteRect.y + footnoteRect.height;
            }
        }
        rFrame.y = maxBottomY + vspace;
        rFrame.height = maxTopY - maxBottomY - 2 * vspace;
        Point p = BILabelLayout.adjustFrameFor3D(pfj, rFrame);
        int oldFrameY = rFrame.y;
        rFrame.y += rFrame.y - p.y;
        rFrame.height -= Math.abs(oldFrameY - p.y);
        int spacing = legendVisible && position == 3 ? rFrame.x - (rLegend.x + this.m_commonGraphLegendGapH + (rFrame.x - p.x) + rLegend.width) : rFrame.x - (-16000 + this.m_commonGraphMarginH + (rFrame.x - p.x));
        rFrame.width += spacing;
        rFrame.x -= spacing;
        int frameX2 = rFrame.x + rFrame.width;
        spacing = legendVisible && position == 2 ? rLegend.x - this.m_commonGraphLegendGapH - frameX2 : 16000 - this.m_commonGraphMarginH - frameX2;
        rFrame.width += spacing;
        if (isPie && BILabelLayout.getDrillLabel(pfj) != null) {
            int titleHeight = BILabelLayout.getAxisTitleHeight(pfj.getGraphicsContext(), pfj, pfj.getO1DrillLabel(), false);
            rFrame.y += titleHeight;
            rFrame.height -= titleHeight;
        }
        if ((graphType == 35 || graphType == 23 || graphType == 47) && this.m_commonGraph.getMarkerText().isVisible() && this.m_commonGraph.getMarkerText().getMarkerTextPlace() == 1) {
            Font f = this.m_commonGraph.getMarkerText().getFont();
            FontMetrics fm = pfj.getGraphicsContext().getFontMetrics(f);
            int fontHeight = TextStyleObj.getFontHeight(fm, pfj.getFontMetricsResolver());
            rFrame.height -= pfj.getVC().destToVirtHeight(fontHeight);
        }
        pfj.putToLookNoCalc(frameId, attr, rFrame, this.m_reset ^ true);
        if (legendVisible && position == 2) {
            rLegend.y = !alongEdge ? rFrame.y + (rFrame.height - rLegend.height) : -16000 + pfj.getVC().destToVirtHeight(1);
            pfj.putToLookNoCalc(pfj.getLegendArea(), Attr.LegendAreaRect, rLegend, this.m_reset ^ true);
        } else if (legendVisible && position == 3) {
            rLegend.y = !alongEdge ? rFrame.y + (rFrame.height - rLegend.height) : -16000 + pfj.getVC().destToVirtHeight(1);
            pfj.putToLookNoCalc(pfj.getLegendArea(), Attr.LegendAreaRect, rLegend, this.m_reset ^ true);
        }
    }

    public void centerLegend(Perspective pfj, LegendObj legend) {
        if (!this._isLegendDisplayed()) {
            return;
        }
        Rectangle titleRect = null;
        Rectangle subtitleRect = null;
        Rectangle footnoteRect = null;
        boolean titleVisible = pfj.getTitleDisplay();
        boolean subtitleVisible = pfj.getSubtitleDisplay();
        boolean footnoteVisible = pfj.getFootnoteDisplay();
        if (titleVisible) {
            titleRect = (Rectangle)pfj.getRect(pfj.getTitle()).clone();
        }
        if (subtitleVisible) {
            subtitleRect = (Rectangle)pfj.getRect(pfj.getSubtitle()).clone();
        }
        if (footnoteVisible) {
            footnoteRect = (Rectangle)pfj.getRect(pfj.getFootnote()).clone();
        }
        int position = this.m_commonGraph.getLegendArea().getAutomaticPosition();
        boolean alongEdge = this.m_commonGraph.getLegendArea().isAlongGraphEdge();
        IdentObj frameId = this._isPieFrame(pfj.getGraphType()) ? pfj.getPieFrame() : pfj.getFrame();
        Rectangle rFrame = (Rectangle)pfj.getRect(frameId).clone();
        Rectangle rLegend = (Rectangle)pfj.getRect(pfj.getLegendArea()).clone();
        if (!(alongEdge || position != 2 && position != 3)) {
            if (rLegend.height < rFrame.height) {
                int center = rFrame.height / 2 + rFrame.y;
                rLegend.y = center - rLegend.height / 2;
            } else if (rLegend.height > rFrame.height + rFrame.y - this.m_maxBottomY) {
                rLegend.y = this.m_maxBottomY == -16000 ? this.m_maxBottomY + pfj.getVC().destToVirtHeight(1) : this.m_maxBottomY;
            }
        }
        if (!(alongEdge || position != 0 && position != 1)) {
            rLegend.x = -(rLegend.width / 2);
        }
        pfj.putToLookNoCalc(pfj.getLegendArea(), Attr.LegendAreaRect, rLegend, this.m_reset ^ true);
    }

    private void setLegendProps(Perspective pfj) {
        pfj.putToLookNoCalc(pfj.getLegendText(), Attr.Autofit, new Boolean(false), this.m_reset ^ true);
        IdentObj obj = new IdentObj(2000);
        pfj.putToLookNoCalc(obj, Attr.LegendAutomatic, new Boolean(false), this.m_reset ^ true);
        pfj.putToLookNoCalc(obj, Attr.LegendMarkerPosition, new Integer(0), this.m_reset ^ true);
        pfj.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(0), this.m_reset ^ true);
    }

    private static int getPFJFontHeight(FontMetrics fm, FontMetricsResolver resolver) {
        return TextStyleObj.getFontHeight(fm, resolver);
    }

    private static IdentObj getO1AxisTitle(Perspective pfj) {
        IdentObj obj = BILabelLayout.getDrillLabel(pfj);
        if (obj != null) {
            return obj;
        }
        return pfj.getO1Title();
    }

    private static IdentObj getDrillLabel(Perspective pfj) {
        IdentObj obj = pfj.getO1DrillLabel();
        if (pfj.getDrillCallback().isDrillingEnabled() && pfj.getTextString(obj) != null && pfj.getDisplay(obj)) {
            return obj;
        }
        return null;
    }

    private void doFunnelLabelsAutoLayout(Perspective perspective, Vector[] labels) {
        int extraSpaceVert = 0;
        boolean extraSpaceHoriz = false;
        IdentObj idFrame = perspective.getFunnelFrame();
        Attr attr = Attr.FunnelFrameRect;
        FunnelSliceLabelContainer funnelSliceLabelContainer = perspective.getFunnelLabelContainer().getFunnelSliceLabelContainer();
        FunnelStageLabelContainer funnelStageLabelContainer = perspective.getFunnelLabelContainer().getFunnelStageLabelContainer();
        int sliceLabelAngle = JChart_2D_Funnel.mappedRotationAngle(this.m_commonGraph.getSliceLabel().getTextRotation());
        int stageLabelAngle = JChart_2D_Funnel.mappedRotationAngle(this.m_commonGraph.getO1TickLabel().getTextRotation());
        int fontHeightSlice = perspective.getVC().destToVirtHeight(funnelSliceLabelContainer.getFontHeight());
        labels[0].trimToSize();
        String[] strSliceLabels = new String[labels[0].size()];
        int i = 0;
        while (i < strSliceLabels.length) {
            strSliceLabels[i] = (String)labels[0].elementAt(i);
            ++i;
        }
        int startSliceWidth = perspective.getVC().destToVirtWidth(funnelSliceLabelContainer.getFirstSliceLabelWidth());
        int lastSliceWidth = perspective.getVC().destToVirtWidth(funnelSliceLabelContainer.getLastSliceLabelWidth());
        int fontHeightStage = perspective.getVC().destToVirtHeight(funnelSliceLabelContainer.getFontHeight());
        int startStageWidth = perspective.getVC().destToVirtWidth(funnelStageLabelContainer.getFirstStageLabelWidth());
        int lastStageWidth = perspective.getVC().destToVirtWidth(funnelStageLabelContainer.getLastStageLabelWidth());
        if (sliceLabelAngle == 0) {
            extraSpaceVert += fontHeightSlice + perspective.getVC().destToVirtHeight(7);
        } else if (sliceLabelAngle == 360) {
            extraSpaceVert += fontHeightSlice + perspective.getVC().destToVirtHeight(14);
        } else if (stageLabelAngle == 0) {
            extraSpaceVert += fontHeightStage + perspective.getVC().destToVirtHeight(7);
        } else if (stageLabelAngle == 360) {
            extraSpaceVert += fontHeightStage + perspective.getVC().destToVirtHeight(14);
        }
        extraSpaceVert = (int)((double)extraSpaceVert + (double)startSliceWidth * FunnelLabelContainer.getHeightFactor(sliceLabelAngle));
        extraSpaceVert = (int)((double)extraSpaceVert + (double)startStageWidth * FunnelLabelContainer.getHeightFactor(stageLabelAngle));
        Rectangle rFrame = new Rectangle(perspective.getRect(idFrame));
        rFrame.y += extraSpaceVert / 2;
        rFrame.height -= extraSpaceVert;
        perspective.putToLookNoCalc(idFrame, attr, rFrame, this.m_reset ^ true);
    }

    private void $init$() {
        this.m_reset = false;
        this.m_legendDisplay = false;
        this.m_plotAreaDisplay = false;
    }

    private static class _PropertyContext {
        String[] m_O1Labels;

        private _PropertyContext() {
        }

        _PropertyContext(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

