/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.HashMap;
import oracle.dss.dataView.managers.Formattable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataEndPoints;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.Line;
import oracle.dss.graph.Visible;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseDataAxis
extends BaseGraphComponent
implements Visible,
Line,
Formattable,
ViewFormatCallback {
    protected IdentObj m_identObj2;
    protected IdentObj m_majorGridIdentObj;
    protected IdentObj m_labelIdentObj;
    protected ViewFormat m_viewFormat;
    protected int m_id;
    protected static final String a_axisMaxLabelVisible = "axisMaxLabelVisible";
    protected static final String a_axisMinLabelVisible = "axisMinLabelVisible";
    protected static final String a_ascending = "ascending";
    protected static final String a_axisLocation = "axisLocation";
    protected static final String a_minAutoMajorTickStep = "minAutoMajorTickStep";
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat viewFormat)";

    public BaseDataAxis(CommonGraph graph) {
        super(graph);
        this.$init$();
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_commonGraph);
    }

    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_pfj.getGlobal());
        this.m_pfj.setNoSelection();
        this.m_pfj.setSelection(this.m_identObj2);
        return this.m_identObj2.equals(this.m_pfj.getSelectionID());
    }

    public void resetToDefault() {
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_commonGraph);
    }

    public void setAscending(boolean yesNo) {
        this.m_pfj.setAxisDescending(this.m_identObj, yesNo ^ true);
    }

    public boolean isAscending() {
        return this.m_pfj.getAxisDescending(this.m_identObj) ^ true;
    }

    public abstract boolean isAxisAutoScaledFromZero();

    public abstract void setAxisAutoScaledFromZero(boolean var1);

    public abstract boolean isAxisMaxAutoScaled();

    public abstract void setAxisMaxAutoScaled(boolean var1);

    public abstract boolean isAxisMinAutoScaled();

    public abstract void setAxisMinAutoScaled(boolean var1);

    public abstract double getAxisMaxAutoValue();

    public abstract double getAxisMaxValue();

    public abstract void setAxisMaxValue(double var1);

    public abstract double getAxisMinAutoValue();

    public abstract double getAxisMinValue();

    public abstract void setAxisMinValue(double var1);

    public abstract double getAxisZoomMaxValue();

    public abstract void setAxisZoomMaxValue(double var1);

    public abstract double getAxisZoomMinValue();

    public abstract void setAxisZoomMinValue(double var1);

    public abstract double getAutoMajorTickStep();

    public int getAxisLocation() {
        return this.m_pfj.getAxisSide(this.m_identObj);
    }

    public void setAxisLocation(int location) {
        if (location < 0 || location > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid value for AxisLocation", this.getClass().getName(), "setAxisLocation( int location )");
        } else {
            this.m_pfj.setAxisSide(this.m_identObj, location);
            this.m_commonGraph.autoSetAxisTitleVerticalAlignment(this.m_identObj.getObjectID());
        }
    }

    public boolean isAxisMinLabelVisible() {
        return this.m_pfj.getExcludeMinLabel(this.m_labelIdentObj) ^ true;
    }

    public void setAxisMinLabelVisible(boolean visible) {
        this.m_pfj.setExcludeMinLabel(this.m_labelIdentObj, visible ^ true);
    }

    public boolean isAxisMaxLabelVisible() {
        return this.m_pfj.getExcludeMaxLabel(this.m_labelIdentObj) ^ true;
    }

    public void setAxisMaxLabelVisible(boolean visible) {
        this.m_pfj.setExcludeMaxLabel(this.m_labelIdentObj, visible ^ true);
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj2);
    }

    public void setLineColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj2, newColor);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj2);
    }

    public void setLineWidth(int width) {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj2, width);
        }
    }

    public double getMajorTickStep() {
        return this.m_pfj.getGridStep(this.m_identObj);
    }

    public void setMajorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else {
            this.m_pfj.setGridStep(this.m_identObj, value);
        }
    }

    public double getMinAutoMajorTickStep() {
        return this.m_pfj.getMinAutoGridStep(this.m_majorGridIdentObj);
    }

    public void setMinAutoMajorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid min auto major tick step", this.getClass().getName(), "setMinAutoMajorTickStep (double value)");
        } else {
            this.m_pfj.setMinAutoGridStep(this.m_majorGridIdentObj, value);
        }
    }

    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getGridStepAuto(this.m_identObj);
    }

    public void setMajorTickStepAutomatic(boolean yesNo) {
        this.m_pfj.setGridStepAuto(this.m_identObj, yesNo);
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            this.m_commonGraph.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        this.m_viewFormat = (ViewFormat)((Object)viewFormat.clone());
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_commonGraph);
        this.m_pfj.needRecalc();
    }

    public void formatChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        this.m_pfj.needRecalc();
    }

    public double getLogarithmicBase() {
        return this.m_pfj.getLogScaleBase(this.m_identObj);
    }

    public void setLogarithmicBase(double value) {
        if (value <= 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid logarithmicBase", this.getClass().getName(), "setLogarithmicBase (double value)");
        } else {
            this.m_pfj.setLogScaleBase(this.m_identObj, value);
        }
    }

    public boolean isScaledLogarithmic() {
        return this.m_pfj.getLogScale(this.m_identObj);
    }

    public void setScaledLogarithmic(boolean yesNo) {
        this.m_pfj.setLogScale(this.m_identObj, yesNo);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj2);
    }

    public void setVisible(boolean visible) {
        this.m_pfj.setDisplay(this.m_identObj2, visible);
    }

    public DataEndPoints getDataEndPoints() {
        return BaseDataAxis.getDataEndPoints(this.m_commonGraph, this.m_id);
    }

    public static DataEndPoints getDataEndPoints(CommonGraph graph, int id) {
        int columns = 0;
        int rows = 0;
        double data = 0.0;
        try {
            if (graph.isDataRowShownAsASeries()) {
                columns = graph.getColumnCount();
                rows = graph.getRowCount();
            } else {
                columns = graph.getRowCount();
                rows = graph.getColumnCount();
            }
        }
        catch (EdgeOutOfRangeException e) {
            DataEndPoints dataEndPoints = null;
            return dataEndPoints;
        }
        int skip = 0;
        int graphType = graph.getGraphType();
        int k = 1;
        int m = 0;
        boolean volumeGraph = false;
        switch (graphType) {
            case 61: 
            case 62: 
            case 65: 
            case 66: {
                if (id == 46 || id == 51) {
                    m = 1;
                }
                k = 2;
                break;
            }
            case 63: 
            case 64: 
            case 89: 
            case 91: {
                if (id == 46 || id == 51) {
                    m = 1;
                }
                k = 3;
                break;
            }
            case 82: 
            case 84: {
                if (id == 51) {
                    k = 3;
                    m = 2;
                }
                if (id == 46) {
                    skip = 3;
                }
                volumeGraph = true;
                rows = 1;
                break;
            }
            case 90: 
            case 92: {
                if (id == 46 || id == 51) {
                    m = 1;
                }
                k = 4;
                break;
            }
            case 88: {
                if (id == 51) {
                    k = 4;
                    m = 3;
                }
                if (id == 46) {
                    skip = 4;
                }
                volumeGraph = true;
                rows = 1;
                break;
            }
            case 71: 
            case 83: {
                if (id == 51) {
                    k = 5;
                    m = 4;
                }
                if (id == 46) {
                    skip = 5;
                }
                volumeGraph = true;
                rows = 1;
                break;
            }
            case 70: 
            case 72: {
                rows = 1;
                break;
            }
        }
        if (k > columns || m > columns - 1) {
            return null;
        }
        columns -= columns % k;
        double max = 0.0;
        double min = 0.0;
        boolean dual = BaseDataAxis.isDual(graphType);
        boolean first = true;
        boolean bAllNull = true;
        Object value = null;
        int i = 0;
        while (i < rows) {
            block45: {
                try {
                    if (!(!graph.getSeries().isAssignedToY2(i % graph.getSeriesObjectCount()) && id == 46 && dual || graph.getSeries().isAssignedToY2(i % graph.getSeriesObjectCount()) && id == 51 && dual || !dual) && (!dual || id != 41)) break block45;
                    int counter = 0;
                    int j = m;
                    while (j < columns) {
                        if (skip > 0 && ++counter == skip) {
                            ++j;
                            counter = 1;
                        }
                        if (j <= columns - 1) {
                            value = graph.isDataRowShownAsASeries() ? ((DataFilterImpl)graph.getDataFilter()).getValue(i, j) : ((DataFilterImpl)graph.getDataFilter()).getValue(j, i);
                            if (value != null) {
                                bAllNull = false;
                                if (value instanceof Number) {
                                    if (value instanceof Double) {
                                        data = (Double)value;
                                    } else if (value instanceof Integer) {
                                        data = ((Integer)value).doubleValue();
                                    } else if (value instanceof Long) {
                                        data = ((Long)value).doubleValue();
                                    } else if (value instanceof Float) {
                                        data = ((Float)value).doubleValue();
                                    } else if (value instanceof Short) {
                                        data = ((Short)value).doubleValue();
                                    }
                                    if (first) {
                                        max = data;
                                        min = data;
                                        first = false;
                                    }
                                    if (data > max) {
                                        max = data;
                                    } else if (data < min) {
                                        min = data;
                                    }
                                }
                            }
                            j += k;
                            continue;
                        }
                        break;
                    }
                }
                catch (SeriesOutOfRangeException se) {
                    DataEndPoints dataEndPoints = null;
                    return dataEndPoints;
                }
            }
            ++i;
        }
        if (bAllNull) {
            return null;
        }
        return new DataEndPoints(max, min);
    }

    protected String convertAxisLocationToString(int loc) {
        String str = "";
        switch (loc) {
            case 0: {
                str = "AL_LEFT";
                break;
            }
            case 1: {
                str = "AL_RIGHT";
                break;
            }
            case 2: {
                str = "AL_BOTH";
                break;
            }
        }
        return str;
    }

    protected int convertAxisLocationToInt(String str) {
        int loc = 0;
        if (str.equals("AL_RIGHT")) {
            loc = 1;
        } else if (str.equals("AL_BOTH")) {
            loc = 2;
        }
        return loc;
    }

    private static boolean isDual(int graphType) {
        switch (graphType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 91: 
            case 92: 
            case 98: {
                return true;
            }
        }
        return false;
    }

    protected void resetStyle() {
        this.setLineColor(Color.black);
        this.setLineWidth(1);
        this.setAscending(false);
        this.setAxisLocation(0);
        this.setAxisMinLabelVisible(true);
        this.setAxisMaxLabelVisible(true);
        this.setLogarithmicBase(10.0);
        this.setScaledLogarithmic(true);
        this.setVisible(false);
    }

    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        ObjectNode viewFormatXMl;
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getScaleMinAutoObj(this.m_identObj);
        if (val != null) {
            node.addProperty("axisMinAutoScaled", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if (allProperties || !this.isAxisMinAutoScaled()) {
            node.addProperty("axisMinValue", this.getAxisMinValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getScaleMaxAutoObj(this.m_identObj)) != null) {
            node.addProperty("axisMaxAutoScaled", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if (allProperties || !this.isAxisMaxAutoScaled()) {
            node.addProperty("axisMaxValue", this.getAxisMaxValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getGridStepAutoObj(this.m_majorGridIdentObj)) != null) {
            node.addProperty("majorTickStepAutomatic", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        nodeExists |= this.getMajorTickStepXML(allProperties, node);
        val = this.m_pfj.getMinAutoGridStepObj(this.m_identObj);
        if (val != null) {
            node.addProperty(a_minAutoMajorTickStep, ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getScaleMustIncludeZeroObj(this.m_identObj)) != null) {
            node.addProperty("axisAutoScaledFromZero", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((viewFormatXMl = this.getViewFormat().getXML(allProperties)) != null) {
            node.addProperty(viewFormatXMl);
            nodeExists = true;
        }
        return nodeExists;
    }

    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getLineWidthObj(this.m_identObj2);
        if (val != null) {
            node.addProperty("lineWidth", ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.getLineColor()) != null) {
            node.addProperty("lineColor", BaseDataAxis.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getExcludeMaxLabelObj(this.m_labelIdentObj)) != null) {
            node.addProperty(a_axisMaxLabelVisible, (Boolean)val ^ true);
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getExcludeMinLabelObj(this.m_labelIdentObj)) != null) {
            node.addProperty(a_axisMinLabelVisible, (Boolean)val ^ true);
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLogScaleObj(this.m_identObj)) != null) {
            node.addProperty("scaledLogarithmic", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getLogScaleBaseObj(this.m_identObj)) != null) {
            node.addProperty("logarithmicBase", ((Double)val).doubleValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getAxisDescendingObj(this.m_identObj)) != null) {
            node.addProperty(a_ascending, (Boolean)val ^ true);
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getAxisSideObj(this.m_identObj)) != null) {
            node.addProperty(a_axisLocation, this.convertAxisLocationToString((Integer)val));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj2)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        return styleOverridden;
    }

    public void setNonstyleXML(ObjectNode node, String version, int reset) {
        PropertyNode pNode;
        super.setNonstyleXML(node);
        ObjectNode viewFormat = node.getPropertyValueAsObjectNode("ViewFormat", true);
        if (viewFormat != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put("ViewFormat", map);
                this.getViewFormat().setXML(viewFormat, version, reset, map);
            } else {
                this.getViewFormat().setXML(viewFormat, version, reset);
            }
        }
        if ((pNode = node.getProperty("axisMinAutoScaled")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("axisMinAutoScaled", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setAxisMinAutoScaled(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("axisMinValue")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("axisMinValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setAxisMinValue(pNode.getValueAsDouble());
            }
        }
        if ((pNode = node.getProperty("axisMaxAutoScaled")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("axisMaxAutoScaled", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setAxisMaxAutoScaled(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("axisMaxValue")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("axisMaxValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setAxisMaxValue(pNode.getValueAsDouble());
            }
        }
        this.setMajorTickStepXML(node);
        pNode = node.getProperty("majorTickStepAutomatic");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("majorTickStepAutomatic", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setMajorTickStepAutomatic(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty(a_minAutoMajorTickStep)) != null) {
            this.setMinAutoMajorTickStep(pNode.getValueAsDouble());
        }
        if ((pNode = node.getProperty("axisAutoScaledFromZero")) != null) {
            this.setAxisAutoScaledFromZero(pNode.getValueAsBoolean());
        }
    }

    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("lineWidth");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineWidth", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setLineWidth(pNode.getValueAsInteger());
            }
        }
        if ((pNode = node.getProperty("lineColor")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("lineColor", new Color(BaseDataAxis.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setLineColor(new Color(BaseDataAxis.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((pNode = node.getProperty(a_axisMaxLabelVisible)) != null) {
            this.setAxisMaxLabelVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_axisMinLabelVisible)) != null) {
            this.setAxisMinLabelVisible(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty("scaledLogarithmic")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("scaledLogarithmic", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setScaledLogarithmic(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("logarithmicBase")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("logarithmicBase", new Double(pNode.getValueAsDouble()));
            } else {
                this.setLogarithmicBase(pNode.getValueAsDouble());
            }
        }
        if ((pNode = node.getProperty(a_ascending)) != null) {
            this.setAscending(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_axisLocation)) != null) {
            this.setAxisLocation(this.convertAxisLocationToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    protected void setMajorTickStepXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("majorTickStep");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("majorTickStep", new Double(pNode.getValueAsDouble()));
            } else {
                this.setMajorTickStep(pNode.getValueAsDouble());
            }
        }
    }

    protected boolean getMajorTickStepXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = false;
        Object val = this.m_pfj.getGridStepObj(this.m_majorGridIdentObj);
        if (val != null) {
            node.addProperty("majorTickStep", ((Double)val).doubleValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    private void $init$() {
        this.m_id = 0;
    }
}

