/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Rectangle;
import oracle.dss.graph.BaseGraphFrame;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Rect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseFrame
extends BaseGraphFrame
implements Rect {
    public BaseFrame(CommonGraph graph, IdentObj identObj) {
        this(graph);
        this.m_identObj = identObj;
    }

    public BaseFrame(CommonGraph graph) {
        super(graph);
    }

    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Rectangle getRect() {
        Rectangle rect = new Rectangle(this.m_pfj.getRect(this.m_identObj));
        rect.y += rect.height;
        return rect;
    }

    public void setRect(Rectangle loc) {
        if (loc.width >= 100 && loc.height >= 100) {
            loc.y -= loc.height;
            this.m_pfj.setRect(this.m_identObj, loc);
            this.m_commonGraph.setFrameSizeAutomatic(false);
        } else {
            if (loc.width < 100) {
                this.m_commonGraph.getErrorHandler().log("Rectangle width too small", this.getClass().getName(), "setRect");
            }
            if (loc.height < 100) {
                this.m_commonGraph.getErrorHandler().log("Rectangle height too small", this.getClass().getName(), "setRect");
            }
        }
    }

    private void setRectXML(ObjectNode node) {
        Rectangle rect = this.getRect();
        PropertyNode pNode = node.getProperty("height");
        if (pNode != null) {
            rect.height = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("width")) != null) {
            rect.width = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("x")) != null) {
            rect.x = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("y")) != null) {
            rect.y = pNode.getValueAsInteger();
        }
        this.setRect(rect);
    }

    protected ObjectNode getRectXML(boolean allProperties) {
        ObjectNode node = new ObjectNode("Rect");
        boolean nodeExists = false;
        Rectangle rect = this.m_pfj.getRect(this.m_identObj);
        if (rect != null && (!this.m_commonGraph.isFrameSizeAutomatic() || allProperties)) {
            rect.y += rect.height;
            node.addProperty("height", rect.height);
            node.addProperty("width", rect.width);
            node.addProperty("x", rect.x);
            node.addProperty("y", rect.y);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected void setXML(ObjectNode node, boolean allProperties) {
        super.setXML(node, allProperties);
        ObjectNode rectStyleXML = node.getPropertyValueAsObjectNode("Rect", true);
        if (rectStyleXML != null) {
            this.setRectXML(rectStyleXML);
        }
    }
}

