/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.Fill;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Border;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.SFX;
import oracle.dss.util.Utility;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseGraphFrame
extends BaseGraphComponent
implements Border,
Fill {
    protected SFX m_sfx;

    public BaseGraphFrame(CommonGraph graph) {
        super(graph);
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
        if (this.getComponentName().equals("ThreeDFloor") && this.m_commonGraph.isGroup3DPanels()) {
            this.m_pfj.setBorderColor(this.m_pfj.getCubeLeftWall(), newColor);
            this.m_pfj.setBorderColor(this.m_pfj.getCubeRightWall(), newColor);
        }
        if (this.getComponentName().equals("FunnelFrame")) {
            this.m_pfj.setBorderColor(this.m_pfj.getFunnelLeftSurface(), newColor);
        }
    }

    public boolean isBorderTransparent() {
        return this.m_pfj.getTransparentBorderColor(this.m_identObj);
    }

    public void setBorderTransparent(boolean yesNo) {
        this.m_pfj.setTransparentBorderColor(this.m_identObj, yesNo);
        if (this.getComponentName().equals("ThreeDFloor") && this.m_commonGraph.isGroup3DPanels()) {
            this.m_pfj.setTransparentBorderColor(this.m_pfj.getCubeLeftWall(), yesNo);
            this.m_pfj.setTransparentBorderColor(this.m_pfj.getCubeRightWall(), yesNo);
        }
        if (this.getComponentName().equals("FunnelFrame")) {
            this.m_pfj.setTransparentBorderColor(this.m_pfj.getFunnelLeftSurface(), yesNo);
        }
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        if (this.m_commonGraph.isGroup3DPanels()) {
            this.m_commonGraph.getPlotArea().setGroupFillColor(newColor);
            this.m_pfj.setFillColor(this.m_pfj.getCubeLeftWall(), newColor);
            this.m_pfj.setFillColor(this.m_pfj.getCubeRightWall(), newColor);
        } else if (this.getComponentName().equals("ThreeDLeftWall") || this.getComponentName().equals("ThreeDRightWall")) {
            this.m_pfj.setFillColor(this.m_identObj, newColor);
        } else {
            this.m_commonGraph.getPlotArea().setGroupFillColor(newColor);
        }
    }

    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    public void setFillTransparent(boolean yesNo) {
        if (this.m_commonGraph.isGroup3DPanels()) {
            this.m_commonGraph.getPlotArea().setGroupFillTransparent(yesNo);
            this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeLeftWall(), yesNo);
            this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeRightWall(), yesNo);
        } else if (this.getComponentName().equals("ThreeDLeftWall") || this.getComponentName().equals("ThreeDRightWall")) {
            this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
        } else {
            this.m_commonGraph.getPlotArea().setGroupFillTransparent(yesNo);
        }
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public ObjectNode getXML(boolean allProperties) {
        return this.getXML(allProperties, true);
    }

    public ObjectNode getStyleXML(boolean allProperties) {
        return this.getXML(allProperties, false);
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode sfxNode;
        ObjectNode rectStyleXML;
        boolean nodeExists = false;
        ObjectNode node = new ObjectNode(this.getComponentName());
        Object val = this.getBorderColor();
        if (this.getBorderColor() != null) {
            node.addProperty("borderColor", BaseGraphFrame.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentBorderColorObj(this.m_identObj)) != null) {
            node.addProperty("borderTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.getFillColor()) != null) {
            Color color = (Color)val;
            node.addProperty("fillColor", BaseGraphFrame.toHexString(color.getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentFillColorObj(this.m_identObj)) != null) {
            node.addProperty("fillTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((this.getComponentName().equals("PlotArea") || this.getComponentName().equals("PieFrame")) && (rectStyleXML = this.getRectXML(allProperties)) != null) {
            if (node == null) {
                node = new ObjectNode(this.getComponentName());
            }
            node.addProperty(rectStyleXML);
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    public void setXML(ObjectNode node) {
        this.setXML(node, true);
    }

    public void setStyleXML(ObjectNode node) {
        this.setXML(node, false);
    }

    protected void setNonStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("visible");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getDisplayObj(this.m_identObj);
        if (val != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    protected void setXML(ObjectNode node, boolean allProperties) {
        ContainerNode sfx;
        PropertyNode pNode = node.getProperty("borderColor");
        boolean borderColorSet = false;
        if (pNode != null) {
            borderColorSet = true;
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderColor", new Color(BaseGraphFrame.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setBorderColor(new Color(BaseGraphFrame.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((pNode = node.getProperty("borderTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderTransparent", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setBorderTransparent(pNode.getValueAsBoolean());
            }
        } else if (borderColorSet && this.getComponentName().equals("PieFrame") && Utility.compareXMLVersions((String)this.m_commonGraph.m_passedInXMLVersion, (String)this.m_commonGraph.getVersion()) < 0) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderTransparent", new Boolean(false));
            } else {
                this.setBorderTransparent(false);
            }
        }
        pNode = node.getProperty("fillColor");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", new Color(BaseGraphFrame.hexStringToInt(pNode.getValueAsString()), true));
            } else {
                this.setFillColor(new Color(BaseGraphFrame.hexStringToInt(pNode.getValueAsString()), true));
            }
        }
        if ((sfx = node.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, allProperties);
        }
        if ((pNode = node.getProperty("fillTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setFillTransparent(pNode.getValueAsBoolean());
            }
        }
    }

    protected ObjectNode getRectXML(boolean allProperties) {
        return null;
    }

    protected void resetStyle() {
        this.m_pfj.setBorderColor(this.m_identObj, Color.black);
        this.m_pfj.setTransparentBorderColor(this.m_identObj, false);
        this.m_pfj.setFillColor(this.m_identObj, Color.black);
        this.m_pfj.setTransparentFillColor(this.m_identObj, false);
        if (this.m_sfx != null) {
            this.getSFX().resetStyle();
        }
    }
}

