/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.WordWrapEnabled;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseLegendText
extends BaseText
implements WordWrapEnabled {
    private static final String a_maxAutoFontSize = "maxAutoFontSize";
    private static final String a_minAutoFontSize = "minAutoFontSize";
    public static final String a_minLength = "minLength";
    private static final String m_method_setMaxAutoFontSize = "void setMaxAutoFontSize(int size)";
    private static final String m_method_setMinAutoFontSize = "void setMinAutoFontSize(int size)";

    public BaseLegendText(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendText();
    }

    public boolean isTextFittingAutomatic() {
        return this.m_pfj.getLegendTextAutofit();
    }

    public void setTextFittingAutomatic(boolean yesNo) {
        this.m_pfj.setLegendTextAutofit(yesNo);
    }

    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", "oracle.dss.graph.LegendText", "setHorizontalAlignment(a)");
        }
    }

    public int getMaxAutoFontSize() {
        return this.m_pfj.getTextAutofitMax();
    }

    public void setMaxAutoFontSize(int size) {
        if (size < 1) {
            this.m_commonGraph.getErrorHandler().log("invalid size", this.getClass().getName(), m_method_setMaxAutoFontSize);
            return;
        }
        this.m_pfj.setTextAutofitMax(size);
    }

    public int getMinAutoFontSize() {
        return this.m_pfj.getTextAutofitMin();
    }

    public void setMinAutoFontSize(int size) {
        if (size < 1) {
            this.m_commonGraph.getErrorHandler().log("invalid size", this.getClass().getName(), m_method_setMinAutoFontSize);
            return;
        }
        this.m_pfj.setTextAutofitMin(size);
    }

    public boolean isWordWrapEnabled() {
        return this.m_pfj.getTextWrap(this.m_identObj);
    }

    public void setWordWrapEnabled(boolean yesNo) {
        this.m_pfj.setTextWrap(this.m_identObj, yesNo);
    }

    public void setMinLength(int min) {
        this.m_pfj.setMinLength(this.m_identObj, min);
    }

    public int getMinLength() {
        return this.m_pfj.getMinLength(this.m_identObj);
    }

    public void setXML(ObjectNode node) {
        this.setStyleXML(node);
        this.setNonstyleXML(node);
    }

    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        Object val = this.m_pfj.getAutofitObj(new IdentObj(14));
        if (val != null) {
            node.addProperty("textFittingAutomatic", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getMinLengthObj(new IdentObj(14))) != null) {
            node.addProperty(a_minLength, ((Integer)val).intValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getTextJustHorizObj(this.m_identObj);
        if (val != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.TextAutofitMax)) != null) {
            node.addProperty(a_maxAutoFontSize, ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.TextAutofitMin)) != null) {
            node.addProperty(a_minAutoFontSize, ((Integer)val).intValue());
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getTextWrapObj(this.m_identObj)) != null) {
            node.addProperty("wordWrapEnabled", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        return styleOverridden;
    }

    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        PropertyNode pNode = node.getProperty("textFittingAutomatic");
        if (pNode != null) {
            this.setTextFittingAutomatic(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_minLength)) != null) {
            this.setMinLength(pNode.getValueAsInteger());
        }
    }

    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("horizontalAlignment");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("horizontalAlignment", new Integer(BaseLegendText.convertHorizontalAlignmentToInt(pNode.getValueAsString())));
            } else {
                this.setHorizontalAlignment(BaseLegendText.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty(a_maxAutoFontSize)) != null) {
            this.setMaxAutoFontSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_minAutoFontSize)) != null) {
            this.setMinAutoFontSize(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("wordWrapEnabled")) != null) {
            this.setWordWrapEnabled(pNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.m_pfj.setTextJustHoriz(this.m_identObj, 2);
        this.m_pfj.setTextAutofitMax(100);
        this.m_pfj.setTextAutofitMin(10);
        this.m_pfj.setMinLength(this.m_identObj, 10);
        this.m_pfj.setTextWrap(this.m_identObj, false);
        super.resetStyle();
    }
}

