/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Font;
import java.util.HashMap;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphFont;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseText
extends BaseGraphComponent
implements DataviewFontAttribute,
FontAttribute {
    protected GraphFont m_font;

    public BaseText(CommonGraph graph) {
        super(graph);
    }

    public GraphFont getGraphFont() {
        if (this.m_font == null) {
            this.m_font = new GraphFont(this.m_commonGraph, this.m_identObj);
        } else {
            this.m_font.setObjectId(this.m_identObj);
        }
        return this.m_font;
    }

    public DataviewFont getDataviewFont() {
        return this.getGraphFont();
    }

    public void setFont(Font f) {
        this.getGraphFont();
        this.m_font.setFont(f);
    }

    public Font getFont() {
        this.getGraphFont();
        return this.m_font.getFont();
    }

    public boolean isFontSizeAbsolute() {
        return this.m_pfj.getFontSizeAbsolute(this.m_identObj);
    }

    public void setFontSizeAbsolute(boolean yesNo) {
        this.m_pfj.setFontSizeAbsolute(this.m_identObj, yesNo);
    }

    protected void resetStyle() {
        this.m_pfj.setFontSizeAbsolute(this.m_identObj, true);
        if (this.m_font != null) {
            this.m_font.resetStyle();
        }
    }

    protected GraphFont _getGraphFont() {
        return this.m_font;
    }

    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        ObjectNode graphFont;
        boolean styleOverridden = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getFontSizeAbsoluteObj(this.m_identObj);
        if (val != null) {
            node.addProperty("fontSizeAbsolute", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        if ((graphFont = this.getGraphFont().getStyleXML(allProperties)) != null) {
            node.addProperty(graphFont);
            styleOverridden = true;
        }
        return styleOverridden;
    }

    public void setStyleXML(ObjectNode node) {
        ObjectNode graphFont;
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("fontSizeAbsolute");
        if (pNode != null) {
            this.setFontSizeAbsolute(pNode.getValueAsBoolean());
        }
        if ((graphFont = node.getPropertyValueAsObjectNode("GraphFont", true)) != null) {
            if (this.m_jsfHashMap != null) {
                HashMap map = new HashMap();
                this.m_jsfHashMap.put("GraphFont", map);
                this.getGraphFont().setStyleXML(graphFont, map);
            } else {
                this.getGraphFont().setStyleXML(graphFont);
            }
        }
    }

    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        ObjectNode graphFont = node.getPropertyValueAsObjectNode("GraphFont", true);
        if (graphFont != null) {
            this.getGraphFont().setNonstyleXML(graphFont);
        }
    }
}

