/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Arrays;
import oracle.dss.graph.DataFilter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.ErrorHandler;

public abstract class DataFilterImpl
implements DataFilter {
    protected int m_graphType;
    protected int m_dataModelType;
    protected boolean m_seriesAreRows;
    protected boolean m_isDirtyFlag;
    protected boolean m_filterOn;
    protected boolean m_sortingOn;
    protected boolean m_oneGrpLabel;
    protected int[][] m_measuresArrays;
    protected int m_totalMeasures;
    protected int[] m_currentArray;
    protected int[] m_paretoIndex;
    protected int[] m_filteredParetoIndex;
    protected int m_graphCategory;
    protected int m_currentGroupSize;
    public static final int NON_FILTER_TYPE = -1;
    public static final int SCATTER_TYPE = 0;
    public static final int SCATTER_LABELS_TYPE = 1;
    public static final int BUBBLE_TYPE = 2;
    public static final int BUBBLE_LABELS_TYPE = 3;
    public static final int OHLCV_TYPE = 4;
    public static final int OHLC_TYPE = 5;
    public static final int HLV_TYPE = 6;
    public static final int OCV_TYPE = 7;
    public static final int OC_TYPE = 8;
    public static final int HL_TYPE = 9;
    public static final int HLC_TYPE = 10;
    public static final int HLCV_TYPE = 11;
    public static final int FUNNEL_TYPE = 12;
    public static final int TOTAL_CATEGORIES = 13;
    protected static final int GROUP_SIZE_TWO = 2;
    protected static final int GROUP_SIZE_THREE = 3;
    protected static final int GROUP_SIZE_FOUR = 4;
    protected static final int GROUP_SIZE_FIVE = 5;
    protected int d_totalMeasures;
    protected static final String m_method_setMeasures2 = "setMeasures(int measures[], int totalMeasures)";
    protected static final String m_method_setMeasures3 = "setMeasures(int graphType, int measures[], int totalMeasures)";
    protected static final String m_unequalLength = "measure array length is not equal to the group size";
    protected static final String m_nonFilterArray = "measure array set for graph type that does not need a filter";
    protected static final String m_lessTotalMeasures = "total number of measures are less than the group size";

    public void setGraphType(int graphType) {
        this.m_graphType = graphType;
        this.m_sortingOn = graphType != 96 ? false : this.sortParetoData();
        this.m_graphCategory = DataFilterImpl.getGraphCategory(graphType);
        this.m_currentGroupSize = this.getGroupSize(this.m_graphCategory);
        if (this.m_graphCategory != -1) {
            if (this.m_measuresArrays[this.m_graphCategory] != null) {
                this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
                this.m_filterOn = true;
                this.needRec();
            } else {
                this.m_currentArray = null;
                this.m_filterOn = false;
            }
        } else {
            this.m_currentArray = null;
            this.m_filterOn = false;
        }
    }

    public void setDataRowShownAsASeries(boolean seriesAreRows) {
        this.m_seriesAreRows = seriesAreRows;
    }

    public int[] getMeasures() {
        return this.m_currentArray;
    }

    public int[] getMeasures(int graphType) {
        int graphCategory = DataFilterImpl.getGraphCategory(graphType);
        return this.m_measuresArrays[graphCategory];
    }

    public void setMeasures(int[] measures, int totalMeasures) {
        if (measures.length != this.m_currentGroupSize) {
            this.getErrorHandler().log(m_unequalLength, this.getClass().getName(), m_method_setMeasures2);
        } else if (this.m_graphCategory == -1) {
            this.getErrorHandler().log(m_nonFilterArray, this.getClass().getName(), m_method_setMeasures2);
        } else if (totalMeasures < this.m_currentGroupSize) {
            this.getErrorHandler().log(m_lessTotalMeasures, this.getClass().getName(), m_method_setMeasures2);
        } else {
            int i = 0;
            while (i < this.m_currentGroupSize) {
                if (measures[i] > totalMeasures - 1) {
                    this.getErrorHandler().log("measure index in the specified array at index " + i + " is greater than (totalMeasures - 1)", this.getClass().getName(), m_method_setMeasures2);
                    return;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.m_currentGroupSize) {
                int j = i2 + 1;
                while (j < this.m_currentGroupSize) {
                    if (measures[i2] == measures[j]) {
                        this.getErrorHandler().log("measure index in the specified array at index " + i2 + " is same as the one at the index " + j + ". Measure indexes should be unique.", this.getClass().getName(), m_method_setMeasures2);
                        return;
                    }
                    ++j;
                }
                ++i2;
            }
            this.m_measuresArrays[this.m_graphCategory] = measures;
            this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
            this.m_totalMeasures = totalMeasures;
            this.m_filterOn = true;
            this.setDirty(true);
            this.needRec();
        }
    }

    public void setMeasures(int graphType, int[] measures, int totalMeasures) {
        int graphCategory = DataFilterImpl.getGraphCategory(graphType);
        this.setMeasuresForCategory(graphCategory, measures, totalMeasures);
    }

    public void setMeasuresForCategory(int graphCategory, int[] measures, int totalMeasures) {
        int groupSize = this.getGroupSize(graphCategory);
        if (graphCategory == -1) {
            this.getErrorHandler().log(m_nonFilterArray, this.getClass().getName(), m_method_setMeasures3);
        } else if (measures.length != groupSize) {
            this.getErrorHandler().log(m_unequalLength, this.getClass().getName(), m_method_setMeasures3);
        } else if (totalMeasures < groupSize) {
            this.getErrorHandler().log(m_lessTotalMeasures, this.getClass().getName(), m_method_setMeasures3);
        } else {
            int i = 0;
            while (i < groupSize) {
                if (measures[i] > totalMeasures - 1) {
                    this.getErrorHandler().log("measure index in the specified array at index " + i + " is greater than (totalMeasures - 1)", this.getClass().getName(), m_method_setMeasures3);
                    return;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < groupSize) {
                int j = i2 + 1;
                while (j < groupSize) {
                    if (measures[i2] == measures[j]) {
                        this.getErrorHandler().log("measure index in the specified array at index " + i2 + " is same as the one at the index " + j + ". Measure indexes should be unique.", this.getClass().getName(), m_method_setMeasures3);
                        return;
                    }
                    ++j;
                }
                ++i2;
            }
            this.m_measuresArrays[graphCategory] = measures;
            this.m_totalMeasures = totalMeasures;
            if (this.m_graphCategory == graphCategory) {
                this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
                this.m_filterOn = true;
                this.setDirty(true);
                this.needRec();
            }
        }
    }

    public void refresh() {
        this.m_filterOn = false;
        this.m_totalMeasures = -1;
        int i = 0;
        while (i < 13) {
            this.m_measuresArrays[i] = null;
            ++i;
        }
        this.m_currentArray = null;
    }

    public int getColumns() {
        try {
            int columns = this.getDataAccess().getEdgeExtent(0);
            if (this.m_seriesAreRows && this.m_filterOn) {
                this.m_oneGrpLabel = columns / this.m_totalMeasures == 1;
                columns = columns / this.m_totalMeasures * this.m_currentGroupSize;
            } else if (this.m_seriesAreRows) {
                boolean bl = this.m_oneGrpLabel = columns / this.m_currentGroupSize == 1;
            }
            if (this.isExcelOrDeskTop()) {
                columns = this.m_dataModelType == 1 ? (!this.m_seriesAreRows ? --columns : (columns *= 2)) : (!this.m_seriesAreRows ? (columns /= 2) : (columns *= 2));
            }
            if (columns < 0) {
                columns = 0;
            }
            int n = columns;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getRows() {
        try {
            int rows = this.getDataAccess().getEdgeExtent(1);
            if (!this.m_seriesAreRows && this.m_filterOn) {
                this.m_oneGrpLabel = rows / this.m_totalMeasures == 1;
                rows = rows / this.m_totalMeasures * this.m_currentGroupSize;
            } else if (!this.m_seriesAreRows) {
                boolean bl = this.m_oneGrpLabel = rows / this.m_currentGroupSize == 1;
            }
            if (this.isExcelOrDeskTop()) {
                rows = this.m_dataModelType == 1 ? (!this.m_seriesAreRows ? (rows *= 2) : --rows) : (!this.m_seriesAreRows ? (rows *= 2) : (rows /= 2));
            }
            if (rows < 0) {
                rows = 0;
            }
            int n = rows;
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isDirty() {
        boolean tempDirty = this.m_isDirtyFlag;
        if (tempDirty && this.m_graphType == 96) {
            this.m_sortingOn = this.sortParetoData();
        }
        this.m_isDirtyFlag = false;
        return tempDirty;
    }

    public void sortIfDirty() {
        if (this.m_isDirtyFlag && this.m_graphType == 96) {
            this.m_sortingOn = this.sortParetoData();
        }
    }

    public void setDirty(boolean isDirty) {
        this.m_isDirtyFlag = isDirty;
        this.m_oneGrpLabel = false;
    }

    private boolean sortParetoData() {
        try {
            int slices = 0;
            slices = this.m_seriesAreRows ? this.getDataAccess().getEdgeExtent(0) : this.getDataAccess().getEdgeExtent(1);
            if (slices <= 0) {
                boolean bl = false;
                return bl;
            }
            this.m_paretoIndex = new int[slices];
            this.m_filteredParetoIndex = new int[slices];
            double[] tmpValues = new double[slices];
            double[] values = new double[slices];
            double[] oldValues = new double[slices];
            int i = 0;
            while (i < slices) {
                this.m_paretoIndex[i] = i;
                Object value = this.getDataAccess().getValue(0, i, "dataValue");
                if (value instanceof Number) {
                    tmpValues[i] = ((Number)value).doubleValue();
                    oldValues[i] = tmpValues[i];
                }
                ++i;
            }
            Arrays.sort(tmpValues);
            int start = 0;
            int i2 = slices - 1;
            while (i2 >= 0) {
                values[start++] = tmpValues[i2];
                --i2;
            }
            int i3 = 0;
            while (i3 < slices) {
                int j = 0;
                while (j < slices) {
                    if (values[i3] == oldValues[j]) {
                        this.m_paretoIndex[i3] = j;
                        this.m_filteredParetoIndex[j] = i3;
                        oldValues[j] = Double.NaN;
                        break;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public int getDataAccessColumn(int filteredColumn) {
        if (filteredColumn < 0) {
            return filteredColumn;
        }
        if (this.m_seriesAreRows && this.m_filterOn) {
            return this.getDataAccessIndex(filteredColumn);
        }
        if (this.m_seriesAreRows && this.m_sortingOn) {
            return this.m_paretoIndex[filteredColumn];
        }
        return filteredColumn;
    }

    public int getDataAccessRow(int filteredRow) {
        if (filteredRow < 0) {
            return filteredRow;
        }
        if (!this.m_seriesAreRows && this.m_filterOn) {
            return this.getDataAccessIndex(filteredRow);
        }
        if (!this.m_seriesAreRows && this.m_sortingOn) {
            return this.m_paretoIndex[filteredRow];
        }
        return filteredRow;
    }

    public int getFilteredColumn(int dataAccessColumn) {
        int columns = 0;
        try {
            columns = this.getDataAccess().getEdgeExtent(0);
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        if (dataAccessColumn > columns - 1 || dataAccessColumn < 0) {
            return -1;
        }
        if (this.m_seriesAreRows && this.m_filterOn) {
            int col = this.getFilteredIndex(dataAccessColumn);
            if (col > this.getColumns() - 1) {
                return -1;
            }
            return col;
        }
        if (this.m_seriesAreRows && this.m_sortingOn) {
            return this.m_filteredParetoIndex[dataAccessColumn];
        }
        return dataAccessColumn;
    }

    public int getFilteredRow(int dataAccessRow) {
        int rows = 0;
        try {
            rows = this.getDataAccess().getEdgeExtent(1);
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        if (dataAccessRow > rows - 1 || dataAccessRow < 0) {
            return -1;
        }
        if (!this.m_seriesAreRows && this.m_filterOn) {
            int row = this.getFilteredIndex(dataAccessRow);
            if (row > this.getRows() - 1) {
                return -1;
            }
            return row;
        }
        if (!this.m_seriesAreRows && this.m_sortingOn) {
            return this.m_filteredParetoIndex[dataAccessRow];
        }
        return dataAccessRow;
    }

    public int getTotalMeasures() {
        return this.m_totalMeasures;
    }

    public void setTotalMeasures(int total) {
        this.m_totalMeasures = total;
    }

    public int[][] getMArray() {
        return this.m_measuresArrays;
    }

    public void setMArray(int[][] array) {
        this.m_measuresArrays = array;
    }

    protected void setDataModelType(int model) {
        this.m_dataModelType = model;
    }

    public abstract Object getValue(int var1, int var2);

    protected abstract void needRec();

    protected abstract DataAccess getDataAccess();

    protected abstract ErrorHandler getErrorHandler();

    protected int getGroupSize(int graphCategory) {
        int groupSize = -1;
        switch (graphCategory) {
            case 0: 
            case 8: 
            case 9: {
                groupSize = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                groupSize = 3;
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                groupSize = 4;
                break;
            }
            case 4: {
                groupSize = 5;
                break;
            }
            case 12: {
                groupSize = 2;
                break;
            }
            default: {
                groupSize = 1;
                break;
            }
        }
        return groupSize;
    }

    public static int getGraphCategory(int graphType) {
        int graphCategory = -1;
        switch (graphType) {
            case 61: 
            case 62: 
            case 65: 
            case 66: {
                graphCategory = 0;
                break;
            }
            case 63: 
            case 64: {
                graphCategory = 1;
                break;
            }
            case 89: 
            case 91: {
                graphCategory = 2;
                break;
            }
            case 90: 
            case 92: {
                graphCategory = 3;
                break;
            }
            case 71: 
            case 83: {
                graphCategory = 4;
                break;
            }
            case 70: 
            case 79: 
            case 80: 
            case 81: {
                graphCategory = 5;
                break;
            }
            case 82: {
                graphCategory = 6;
                break;
            }
            case 84: {
                graphCategory = 7;
                break;
            }
            case 72: {
                graphCategory = 8;
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                graphCategory = 9;
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                graphCategory = 10;
                break;
            }
            case 88: {
                graphCategory = 11;
                break;
            }
            case 100: {
                graphCategory = 12;
                break;
            }
            default: {
                graphCategory = -1;
                break;
            }
        }
        return graphCategory;
    }

    protected boolean isExcelOrDeskTop() {
        return this.m_dataModelType != 0 && (this.m_graphType == 61 || this.m_graphType == 62 || this.m_graphType == 65 || this.m_graphType == 66);
    }

    private int getFilteredIndex(int index) {
        if (index < 0) {
            return index;
        }
        int startIndex = index / this.m_totalMeasures * this.m_currentGroupSize;
        int measureNum = index % this.m_totalMeasures;
        int i = 0;
        while (i < this.m_currentGroupSize) {
            if (this.m_currentArray[i] == measureNum) {
                return startIndex + i;
            }
            ++i;
        }
        return -1;
    }

    private int getDataAccessIndex(int index) {
        int startIndex = index / this.m_currentGroupSize * this.m_totalMeasures;
        int measureNum = index % this.m_currentGroupSize;
        return startIndex + this.m_currentArray[measureNum];
    }

    private void $init$() {
        this.m_graphType = 17;
        this.m_dataModelType = 0;
        this.m_filterOn = false;
        this.m_sortingOn = false;
        this.m_oneGrpLabel = false;
        this.m_measuresArrays = new int[13][];
        this.m_totalMeasures = -1;
        this.m_currentArray = null;
        this.m_paretoIndex = null;
        this.m_filteredParetoIndex = null;
        this.m_graphCategory = -1;
        this.m_currentGroupSize = -1;
        this.d_totalMeasures = -1;
    }

    public DataFilterImpl() {
        this.$init$();
    }
}

