/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DataMarker
extends BaseDataComponent {
    public DataMarker(CommonGraph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    public int getMarkerSize() {
        return this.m_pfj.getMarkerSizeDefault();
    }

    public void setMarkerSize(int size) {
        if (size < 0 || size > 100) {
            this.m_commonGraph.getErrorHandler().log("invalid size", "oracle.dss.graph.DataMarker", "setMarkerSize(int size)");
        } else {
            this.m_pfj.setMarkerSizeDefault(size);
        }
    }

    protected String getComponentName() {
        return "DataMarker";
    }

    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.MarkerSize);
        if (val != null) {
            node.addProperty("markerSize", ((Integer)val).intValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("markerSize");
        if (pNode != null) {
            this.setMarkerSize(pNode.getValueAsInteger());
        }
    }

    protected void resetStyle() {
        this.setMarkerSize(1);
    }
}

