/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.CommonGraph;

public class DrillDataCallback {
    protected CommonGraph m_commonGraph;

    public DrillDataCallback(CommonGraph graph) {
        this.m_commonGraph = graph;
    }

    public void saveDrillState() {
        if (this.m_commonGraph.isDrillStateClear()) {
            this.m_commonGraph.saveDrillState();
        }
    }

    public boolean isDrillable(int id, int series, int group) {
        if (!this.m_commonGraph.isDrillingEnabled() || !this.m_commonGraph.isDrillingSupported()) {
            return false;
        }
        boolean seriesAreRows = this.m_commonGraph.getPFJ().getSeriesAreRows();
        boolean drillState = false;
        switch (id) {
            case 14: 
            case 274: {
                int edge = seriesAreRows ? 1 : 0;
                drillState = this.m_commonGraph.getDrillState(edge, series);
                break;
            }
            case 270: 
            case 296: {
                int edge = seriesAreRows ? 0 : 1;
                drillState = this.m_commonGraph.getDrillState(edge, group);
                break;
            }
        }
        return drillState;
    }

    public boolean isDrillingEnabled() {
        return this.m_commonGraph.isDrillingEnabled() && this.m_commonGraph.isDrillingSupported();
    }

    public String getDrillUpLabel(int id) {
        String label = null;
        if (!this.m_commonGraph.isDrillingEnabled() || !this.m_commonGraph.isDrillingSupported()) {
            return null;
        }
        boolean seriesAreRows = this.m_commonGraph.getPFJ().getSeriesAreRows();
        switch (id) {
            case 14: 
            case 274: {
                int edge = seriesAreRows ? 1 : 0;
                label = this.m_commonGraph.getDrillUpLabel(edge);
                break;
            }
            case 270: 
            case 296: {
                int edge = seriesAreRows ? 0 : 1;
                label = this.m_commonGraph.getDrillUpLabel(edge);
                break;
            }
        }
        return label;
    }
}

