/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.BeanInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JPanel;
import oracle.dss.dataView.AlertListener;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.ExportableGraph;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GroupComponentHandle;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.dataView.Titles;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.UIParetoLine;
import oracle.dss.dataView.UISeriesColor;
import oracle.dss.dataView.UIThresholdColor;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.Alert;
import oracle.dss.graph.Annotation;
import oracle.dss.graph.AreaMarker;
import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Connector;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.DataErrorTextCallback;
import oracle.dss.graph.DataFilter;
import oracle.dss.graph.DataLine;
import oracle.dss.graph.DataMarker;
import oracle.dss.graph.ExceptionalRiser;
import oracle.dss.graph.Fitline;
import oracle.dss.graph.FunnelFrame;
import oracle.dss.graph.GraphBackground;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.GraphController;
import oracle.dss.graph.GraphControllerAdapter;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphFootnote;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphModel;
import oracle.dss.graph.GraphModelAdapter;
import oracle.dss.graph.GraphStyleManager;
import oracle.dss.graph.GraphSubtitle;
import oracle.dss.graph.GraphTitle;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.ImagemapComponent;
import oracle.dss.graph.LegendArea;
import oracle.dss.graph.LegendMarker;
import oracle.dss.graph.LegendText;
import oracle.dss.graph.LegendTitle;
import oracle.dss.graph.MarkerText;
import oracle.dss.graph.NotEnoughData;
import oracle.dss.graph.O1Axis;
import oracle.dss.graph.O1MajorTick;
import oracle.dss.graph.O1TickLabel;
import oracle.dss.graph.O1Title;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.ParetoMarker;
import oracle.dss.graph.PieFeeler;
import oracle.dss.graph.PieFrame;
import oracle.dss.graph.PieLabel;
import oracle.dss.graph.PlotArea;
import oracle.dss.graph.QuadrantLine;
import oracle.dss.graph.ReferenceObject;
import oracle.dss.graph.ReferenceObjectMarker;
import oracle.dss.graph.ReferenceObjectText;
import oracle.dss.graph.RingTotalLabel;
import oracle.dss.graph.SampleDataSource;
import oracle.dss.graph.Series;
import oracle.dss.graph.Slice;
import oracle.dss.graph.SliceLabel;
import oracle.dss.graph.SplitDivider;
import oracle.dss.graph.StockMarker;
import oracle.dss.graph.ThickGraph;
import oracle.dss.graph.ThreeDFloor;
import oracle.dss.graph.ThreeDLeftWall;
import oracle.dss.graph.ThreeDMarker;
import oracle.dss.graph.ThreeDRightWall;
import oracle.dss.graph.ThreeDViewMatrix;
import oracle.dss.graph.Threshold;
import oracle.dss.graph.TickLabelCallback;
import oracle.dss.graph.TimeSelector;
import oracle.dss.graph.TwoDMarker;
import oracle.dss.graph.UIGraphType;
import oracle.dss.graph.UndefinedComponent;
import oracle.dss.graph.VolumeMarker;
import oracle.dss.graph.X1Axis;
import oracle.dss.graph.X1MajorTick;
import oracle.dss.graph.X1TickLabel;
import oracle.dss.graph.X1Title;
import oracle.dss.graph.XPanelGrid;
import oracle.dss.graph.Y1Axis;
import oracle.dss.graph.Y1BaseLine;
import oracle.dss.graph.Y1MajorTick;
import oracle.dss.graph.Y1TickLabel;
import oracle.dss.graph.Y1Title;
import oracle.dss.graph.Y1ZeroLine;
import oracle.dss.graph.Y2Axis;
import oracle.dss.graph.Y2BaseLine;
import oracle.dss.graph.Y2MajorTick;
import oracle.dss.graph.Y2TickLabel;
import oracle.dss.graph.Y2Title;
import oracle.dss.graph.Y2ZeroLine;
import oracle.dss.graph.Y3DMarkerGrid;
import oracle.dss.graph.YPanelGrid;
import oracle.dss.graph.ZPanelGrid;
import oracle.dss.graph.ZTickLabel;
import oracle.dss.graph.ZTitle;
import oracle.dss.graph.managers.GraphRuleFormatter;
import oracle.dss.graph.managers.GraphRuleStyles;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.ThickPFJ;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.presutil.FontMetricsResolver;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.CustomStyle;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;

public class Graph
extends Dataview
implements DataviewAttributes,
ExportableGraph,
GraphConstants,
UIGraphType,
ThickGraph,
UIDataview,
GraphAttribute {
    public static final String GRAPH_TYPE = "comp_subtype1";
    public static final String GRAPH_XML_VERSION_NUMBER = "11.1.1.0";
    protected PFJ m_pfj;
    protected GraphModel m_graphModel;
    protected GraphController m_graphController;
    protected SampleDataSource m_sampleDataSource;
    protected GraphTypeConverter m_converter;
    protected Image m_offscreenImage;
    protected boolean m_printOrPreviewMode;
    private static final String m_method_setFontName = "void setFontName(String name)";
    private GraphPanel m_gPanel;
    private String m_drillDimension;
    private boolean m_bExporting;
    private boolean m_drillEnabled;
    private boolean m_swapAllowed;
    private CommonGraph m_commonGraph;

    public Graph() {
        this.$init$();
        this._setupGraphView(null, null, null, 0, null);
        this.setDataSource(new SampleDataSource(this.getCommonGraph()));
    }

    public Graph(DataSource dataSource) {
        this.$init$();
        this._setupGraphView(null, null, dataSource, 0, null);
    }

    public Graph(DataSource dataSource, int type) {
        this.$init$();
        this._setupGraphView(null, null, dataSource, type, null);
    }

    public Graph(ErrorHandler errorHandler) {
        this.$init$();
        this._setupGraphView(null, null, null, 0, errorHandler);
        this.setDataSource(new SampleDataSource(this.getCommonGraph()));
    }

    private void _setupGraphView(GraphModel graphModel, GraphController graphController, DataSource dataSource, int type, ErrorHandler eh) {
        this.m_commonGraph = new CommonGraph(this.getLocale(), this.isJavaComponent(), this, eh);
        this.setCommonDataview(this.m_commonGraph);
        this.setUserOverrideMode(false);
        this.setStyleOverrideMode(false);
        this.m_pfj = this.m_commonGraph.getPFJ();
        this.m_pfj.setThinGraph(this.isJavaComponent() ^ true);
        if (graphModel == null) {
            graphModel = dataSource == null ? new GraphModelAdapter(this) : new GraphModelAdapter(this, dataSource);
        }
        this.m_graphModel = graphModel;
        if (this.isJavaComponent()) {
            this.m_gPanel = new GraphPanel(null);
            this.m_gPanel.addKeyListener(this.m_pfj);
            this.m_gPanel.addMouseListener(this.m_pfj);
            this.m_gPanel.addMouseMotionListener(this.m_pfj);
            this.add((Component)this.m_gPanel, "Center");
            this.m_pfj.setThickPFJ(this.m_gPanel);
        }
        this.setSwapAllowed(true);
        if (graphController == null) {
            graphController = new GraphControllerAdapter(this, graphModel);
        }
        this.m_graphController = graphController;
        super.setModel(graphModel);
        super.setController(graphController);
        this.setDataSource(this.getGraphModel().getDataSource());
        if (this.pagingControl != null) {
            this.getPagingControl().setDataSource(this.getGraphModel().getDataSource());
        }
        if (this.pagingControl != null) {
            this.pagingControl.setVisible(false);
        }
        this.addSubcomponent(this.m_pfj);
        if (this.pagingControl != null) {
            this.addSubcomponent(this.pagingControl);
            this.positionPagingControl(GraphDefaultValues.getPagingControlPosition());
        }
        this.m_commonGraph.setAlertListenerList(this.listenerList);
        this.m_commonGraph.setControllerActions((GraphModelAdapter)graphModel);
        this.m_commonGraph.setGraphFormatManager(graphModel.getGraphFormatManager());
        this.m_commonGraph.setGraphStyleManager(graphModel.getGraphStyleManager());
        this.m_commonGraph.createPropertyOverrideFlags();
        this.setUserOverrideMode(true);
        this.setStyleOverrideMode(true);
    }

    private ComponentHandle getGraphComponentHandle(int tdgID, int tdgSeries, int tdgGroup, int tdgMiscId) {
        return this.m_commonGraph.getGraphComponentHandle(tdgID, tdgSeries, tdgGroup, tdgMiscId);
    }

    protected void createPagingControl() {
        this.pagingControl = new ViewPagingControl(this);
    }

    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        this.boundSupport.firePropertyChange(propName, oldValue, newValue);
    }

    public void resetToDefault(int reset) {
        this.m_commonGraph.resetToDefault(reset);
        this.setSwapAllowed(true);
    }

    public void resetEverything(int reset) {
        if (reset == 5) {
            this.m_graphModel.setGraphFormatManager(new GraphRuleFormatter());
            this.m_graphModel.setGraphStyleManager(new GraphRuleStyles());
            this.m_graphModel.setDrillingEnabled(false);
        } else {
            this.m_graphModel = new GraphModelAdapter(this);
        }
        this.m_graphController.cleanUp();
        this.m_graphController = new GraphControllerAdapter(this, this.m_graphModel);
        this.setModel(this.m_graphModel);
        this.setController(this.m_graphController);
        if (reset != 5) {
            this.setDataSource(new SampleDataSource(this.getCommonGraph()));
        }
    }

    public void resetSuper(int reset, String version) {
        super.resetToDefault(reset, version);
    }

    public void resetXMLProps() {
        this.getGraphController().setSelectedObject(null);
    }

    public boolean setVersion(String version) {
        StringTokenizer tokenizer = new StringTokenizer(version, ".", false);
        while (tokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException nfe) {
                boolean bl = false;
                return bl;
            }
        }
        this.resetToDefault(1, version);
        return true;
    }

    public String getVersion() {
        return GRAPH_XML_VERSION_NUMBER;
    }

    public void cleanUp() {
        this.m_commonGraph.cleanUp();
        this.m_graphController.cleanUp();
        this.m_graphController = null;
        this.m_sampleDataSource = null;
        this.m_pfj = null;
        this.m_gPanel.removeKeyListener(this.m_pfj);
        this.m_gPanel.removeMouseListener(this.m_pfj);
        this.m_gPanel.removeMouseMotionListener(this.m_pfj);
        super.cleanUp();
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.m_gPanel.addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.m_gPanel.removeMouseMotionListener(l);
    }

    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.m_gPanel.addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.m_gPanel.removeMouseListener(l);
    }

    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.m_gPanel.addKeyListener(l);
    }

    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.m_gPanel.removeKeyListener(l);
    }

    public synchronized void addAlertListener(AlertListener l) {
        this.listenerList.add(AlertListener.class, l);
    }

    public synchronized void removeAlertListener(AlertListener l) {
        this.listenerList.remove(AlertListener.class, l);
    }

    public void exportToGIF(OutputStream os) {
        this.m_commonGraph.exportToGIF(os);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToGIFWithException(OutputStream os) throws IOException, Exception {
        this.m_commonGraph.exportToGIFWithException(os);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToPNG(OutputStream os) {
        this.m_commonGraph.exportToPNG(os);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToPNGWithException(OutputStream os) throws IOException, Exception {
        this.m_commonGraph.exportToPNGWithException(os);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVG(OutputStream os, int mode, String charEnc) {
        this.m_commonGraph.exportToSVG(os, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToFlash(OutputStream os, boolean renderDynamic, boolean showDrawing) {
        this.m_commonGraph.exportToFlash(os, renderDynamic, showDrawing);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVGWithException(OutputStream os, int mode, String charEnc) throws IOException, Exception {
        this.m_commonGraph.exportToSVGWithException(os, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVG(Writer writer, int mode, String charEnc) {
        this.m_commonGraph.exportToSVG(writer, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public void exportToSVGWithException(Writer writer, int mode, String charEnc) throws IOException, Exception {
        this.m_commonGraph.exportToSVGWithException(writer, mode, charEnc);
        if (this.isShowing()) {
            this.revalidate();
        }
    }

    public boolean isO1AxisSupported() {
        return this.m_commonGraph.isO1AxisSupported();
    }

    public ComponentHandle getGraphComponentHandle(TDGMouseState mouseState) {
        return this.getGraphComponentHandle(mouseState, false);
    }

    public ComponentHandle getGraphComponentHandle(TDGMouseState mouseState, boolean useDeadZone) {
        return this.m_commonGraph.getGraphComponentHandle(mouseState, useDeadZone);
    }

    public GraphController getGraphController() {
        return this.m_graphController;
    }

    public void setGraphController(GraphController graphController) {
        super.setController(graphController);
        GraphController oldController = this.m_graphController;
        if (oldController != null) {
            oldController.cleanUp();
        }
        this.m_graphController = graphController;
        this.firePropertyChange(this, "GraphController", oldController, this.m_graphController);
    }

    public GraphFormatManager getGraphFormatManager() {
        if (this.m_graphModel != null) {
            return this.m_graphModel.getGraphFormatManager();
        }
        return null;
    }

    public void setGraphFormatManager(GraphFormatManager m) {
        if (this.m_graphModel != null) {
            GraphFormatManager oldFm = this.m_graphModel.getGraphFormatManager();
            this.m_graphModel.setGraphFormatManager(m);
            this.firePropertyChange(this, "GraphFormatManager", oldFm, m);
            this.m_commonGraph.setGraphFormatManager(m);
        }
    }

    public GraphStyleManager getGraphStyleManager() {
        if (this.m_graphModel != null) {
            return this.m_graphModel.getGraphStyleManager();
        }
        return null;
    }

    public void setGraphStyleManager(GraphStyleManager m) {
        if (this.m_graphModel != null) {
            GraphStyleManager oldSm = this.m_graphModel.getGraphStyleManager();
            this.m_graphModel.setGraphStyleManager(m);
            this.m_commonGraph.setGraphStyleManager(m);
            this.firePropertyChange(this, "GraphStyleManager", oldSm, m);
        }
    }

    public GraphModel getGraphModel() {
        return this.m_graphModel;
    }

    public void setGraphModel(GraphModel graphModel) {
        super.setModel(graphModel);
        GraphModel oldModel = this.m_graphModel;
        this.m_graphModel = graphModel;
        this.firePropertyChange(this, "GraphModel", oldModel, this.m_graphModel);
    }

    public PFJ getPFJ() {
        return this.m_pfj;
    }

    public CommonGraph getCommonGraph() {
        return this.m_commonGraph;
    }

    public ComponentHandle getSelectedObject() {
        if (this.getGraphController().getSelectedObject() != null) {
            return this.getGraphController().getSelectedObject();
        }
        IdentObj selectionID = this.m_pfj.getSelectionID();
        if (selectionID == null) {
            return null;
        }
        int tdgID = ObjClassID.stripExceptionalOffset(selectionID.getObjectID());
        int tdgSeries = selectionID.getSeriesID();
        int tdgGroup = selectionID.getGroupID();
        int tdgMiscId = selectionID.getMiscID();
        return this.getGraphComponentHandle(tdgID, tdgSeries, tdgGroup, tdgMiscId);
    }

    public void modelDataChanged(DataChangedEvent e) {
        super.modelDataChanged(e);
        this.m_commonGraph.setDataAccess(this.getModel().getDataAccess());
    }

    public void modelDataAvailable(DataAvailableEvent e) {
        if (e.getType() == 1) {
            this.m_stopRepaints = true;
            return;
        }
        this.m_stopRepaints = false;
        super.modelDataAvailable(e);
        this.m_commonGraph.setDataAccess(this.getModel().getDataAccess());
    }

    protected void refreshData() {
        if (this.getGraphController() != null) {
            this.getGraphController().setSelectedObject(null);
        }
        this.m_commonGraph.refreshData();
        this.invalidate();
        this.repaint();
    }

    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
        this.m_commonGraph.setDataAccess(this.getModel().getDataAccess());
        this.m_commonGraph.setDataDirector(this.getModel().getDataDirector());
    }

    public void setDataDirector(DataDirector dd) {
        if (dd == null) {
            dd = new LocalXMLDataSource(new String[0], new String[0], new Double[0][0]);
        }
        super.setDataDirector((DataDirector)dd);
    }

    public boolean selectObject(ComponentHandle id) {
        if (id == null) {
            this.getPFJ().setSelection((IdentObj)null);
            this.getGraphController().setSelectedObject(null);
            return true;
        }
        if (id instanceof PageItemComponentHandle) {
            this.getGraphController().setSelectedObject(new PageItemComponentHandle(id.getID(), this.getNameFromID(id.getID()), this.getPagingControl(), ((PageItemComponentHandle)id).getPageItem()));
            return true;
        }
        if (id.getComponent() instanceof BaseTitle) {
            this.getGraphController().setSelectedObject(id);
            return true;
        }
        this.getGraphController().setSelectedObject(null);
        int series = 0;
        int group = 0;
        if (id instanceof SeriesComponentHandle) {
            series = ((SeriesComponentHandle)id).getSeries();
        } else if (id instanceof GroupComponentHandle) {
            group = ((GroupComponentHandle)id).getGroup();
            series = ((GroupComponentHandle)id).getLayer();
        } else if (id instanceof DataComponentHandle) {
            series = ((DataComponentHandle)id).getSeries();
            group = ((DataComponentHandle)id).getGroup();
        }
        ((BaseGraphComponent)id.getComponent()).selectObject(series, group);
        return this.getSelectedObject() != null && id.getID() == this.getSelectedObject().getID();
    }

    public void setEnabled(boolean yesNo) {
        super.setEnabled(yesNo);
        if (yesNo) {
            if (this.getMouseActions() == 0) {
                this.setMouseActions(1);
            }
        } else {
            this.setMouseActions(0);
        }
    }

    public void setStandardShape(boolean standardShape) {
        this.m_commonGraph.setStandardShapeAndWidth(standardShape);
    }

    public GraphTypeConverter getGraphTypeConverter() {
        return this.m_converter;
    }

    public void setGraphTypeConverter(GraphTypeConverter converter) {
        this.m_converter = converter;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_commonGraph.setLocale(loc);
        if (this.getGraphModel().getDataSource() instanceof SampleDataSource) {
            ((SampleDataSource)this.getGraphModel().getDataSource()).setLocale(loc);
        }
    }

    public void setTimeZone(TimeZone tz) {
        this.m_commonGraph.setTimeZone(tz);
    }

    public TimeZone getTimeZone() {
        return this.m_commonGraph.getTimeZone();
    }

    public int getGroupSize(int type) {
        return this.m_commonGraph.getGroupSize(type);
    }

    public int getMinimumGroups(int type) {
        return this.m_commonGraph.getMinimumGroups(type);
    }

    public int getMinimumSeries(int type) {
        return this.m_commonGraph.getMinimumSeries(type);
    }

    public ExceptionalRiser createExceptionalRiser(int series, int group) {
        return this.m_commonGraph.createExceptionalRiser(series, group);
    }

    public void destroyAllExceptionalRisers() {
        this.m_commonGraph.destroyAllExceptionalRisers();
    }

    public void setCustomLayout(int type) {
        this.m_commonGraph.setCustomLayout(type);
    }

    public int getCustomLayout() {
        return this.m_commonGraph.getCustomLayout();
    }

    public void setAutoLayout(int auto) {
        this.m_commonGraph.setAutoLayout(auto);
    }

    public int getAutoLayout() {
        return this.m_commonGraph.getAutoLayout();
    }

    public void doAutoLayout(int level) {
        this.m_commonGraph.doAutoLayout(level);
    }

    public int getBarShape() {
        return this.m_commonGraph.getBarShape();
    }

    public void setBarShape(int shape) {
        this.m_commonGraph.setBarShape(shape);
    }

    public void setColorMode(int mode) {
        this.m_commonGraph.setColorMode(mode);
    }

    public int getColorMode() {
        return this.m_commonGraph.getColorMode();
    }

    public int getDataDirectorType() {
        return 0;
    }

    public void setDataDirectorType(int type) {
    }

    public boolean isDataRowShownAsASeries() {
        return this.m_commonGraph.isDataRowShownAsASeries();
    }

    public void setDataRowShownAsASeries(boolean yesNo) {
        this.m_commonGraph.setDataRowShownAsASeries(yesNo);
    }

    public int getDepthAngle() {
        return this.m_commonGraph.getDepthAngle();
    }

    public void setDepthAngle(int angle) {
        this.m_commonGraph.setDepthAngle(angle);
    }

    public int getDepthRadius() {
        return this.m_commonGraph.getDepthRadius();
    }

    public void setDepthRadius(int depth) {
        this.m_commonGraph.setDepthRadius(depth);
    }

    public int getDisplayGroups() {
        return this.m_commonGraph.getDisplayGroups();
    }

    public void setDisplayGroups(int maxGroup) {
        this.m_commonGraph.setDisplayGroups(maxGroup);
    }

    public int getDisplayGroupsLimit() {
        return this.m_commonGraph.getDisplayGroupsLimit();
    }

    public void setDisplayGroupsLimit(int maxDisplayGroups) {
        this.m_commonGraph.setDisplayGroupsLimit(maxDisplayGroups);
    }

    public int getDisplaySeries() {
        return this.m_commonGraph.getDisplaySeries();
    }

    public void setDisplaySeries(int maxSeries) {
        this.m_commonGraph.setDisplaySeries(maxSeries);
    }

    public int getDisplaySeriesLimit() {
        return this.m_commonGraph.getDisplaySeriesLimit();
    }

    public void setDisplaySeriesLimit(int maxDisplaySeries) {
        this.m_commonGraph.setDisplaySeriesLimit(maxDisplaySeries);
    }

    public boolean isFrameSizeAutomatic() {
        return this.m_commonGraph.isFrameSizeAutomatic();
    }

    public void setFrameSizeAutomatic(boolean isAuto) {
        this.m_commonGraph.setFrameSizeAutomatic(isAuto);
    }

    public int getGraphType() {
        return this.m_commonGraph.getGraphType();
    }

    public void setGraphType(int type) {
        this.m_commonGraph.setGraphType(type);
    }

    public void setTimeAxisType(int timeAxis) {
        this.m_commonGraph.setTimeAxisType(timeAxis);
    }

    public int getTimeAxisType() {
        return this.m_commonGraph.getTimeAxisType();
    }

    public void setContinuousTimeAxisInterval(int interval) {
        this.m_commonGraph.setContinuousTimeAxisInterval(interval);
    }

    public int getContinuousTimeAxisInterval() {
        return this.m_commonGraph.getContinuousTimeAxisInterval();
    }

    public int getGroupTooltipLabelType() {
        return this.m_commonGraph.getGroupTooltipLabelType();
    }

    public void setGroupTooltipLabelType(int type) {
        this.m_commonGraph.setGroupTooltipLabelType(type);
    }

    public Dimension getImageSize() {
        return this.m_commonGraph.getImageSize();
    }

    public void setImageSize(Dimension d) {
        this.m_commonGraph.setImageSize(d);
    }

    public Dimension getDefaultImageSize() {
        return this.m_commonGraph.getDefaultImageSize();
    }

    public void setDefaultImageSize(Dimension d) {
        this.m_commonGraph.setDefaultImageSize(d);
    }

    public boolean isLineDataLineDisplayed() {
        return this.m_commonGraph.isLineDataLineDisplayed();
    }

    public void setLineDataLineDisplayed(boolean yesNo) {
        this.m_commonGraph.setLineDataLineDisplayed(yesNo);
    }

    public boolean isGraphicAntialiasing() {
        return this.m_commonGraph.isGraphicAntialiasing();
    }

    public void setGraphicAntialiasing(boolean yesNo) {
        this.m_commonGraph.setGraphicAntialiasing(yesNo);
    }

    public boolean isTextAntialiasing() {
        return this.m_commonGraph.isTextAntialiasing();
    }

    public void setTextAntialiasing(boolean yesNo) {
        this.m_commonGraph.setTextAntialiasing(yesNo);
    }

    public boolean isMarkerDisplayed() {
        return this.m_commonGraph.isMarkerDisplayed();
    }

    public void setMarkerDisplayed(boolean yesNo) {
        this.m_commonGraph.setMarkerDisplayed(yesNo);
    }

    public boolean isMarkerShapeInLegend() {
        return this.getMarkerShapeInLegend() == 1;
    }

    public void setMarkerShapeInLegend(boolean yesNo) {
        this.setMarkerShapeInLegend(yesNo ? 1 : 0);
    }

    public int getMarkerShapeInLegend() {
        return this.m_commonGraph.getMarkerShapeInLegend();
    }

    public void setMarkerShapeInLegend(int markerShapeInLegend) {
        this.m_commonGraph.setMarkerShapeInLegend(markerShapeInLegend);
    }

    public int getMarkerTooltipType() {
        return this.m_commonGraph.getMarkerTooltipType();
    }

    public void setMarkerTooltipType(int type) {
        this.m_commonGraph.setMarkerTooltipType(type);
    }

    public int getMouseActions() {
        return this.m_commonGraph.getMouseActions();
    }

    public void setMouseActions(int actions) {
        this.m_commonGraph.setMouseActions(actions);
    }

    public boolean isMouseMovingEnabled() {
        return this.m_commonGraph.isMouseMovingEnabled();
    }

    public void setMouseMovingEnabled(boolean yesNo) {
        this.m_commonGraph.setMouseMovingEnabled(yesNo);
    }

    public void setAlignTickMarks(boolean align) {
        this.m_commonGraph.setAlignTickMarks(align);
    }

    public boolean isAlignTickMarks() {
        return this.m_commonGraph.isAlignTickMarks();
    }

    public boolean isFontSizeAbsolute() {
        return this.m_commonGraph.isFontSizeAbsolute();
    }

    public void setFontSizeAbsolute(boolean yesNo) {
        this.m_commonGraph.setFontSizeAbsolute(yesNo);
    }

    public void setFontName(String name) {
        if (name == null) {
            this.getErrorHandler().log("null font name", this.getClass().getName(), m_method_setFontName);
            return;
        }
        Font oldDataErrorFont = this.getDataErrorFont();
        Font newDataErrorFont = new Font(name, oldDataErrorFont.getStyle(), oldDataErrorFont.getSize());
        this.setDataErrorFont(newDataErrorFont);
        ((GraphTitle)this.getTitle()).getGraphFont().setGraphFontTypeface(name);
        ((GraphSubtitle)this.getSubtitle()).getGraphFont().setGraphFontTypeface(name);
        ((GraphFootnote)this.getFootnote()).getGraphFont().setGraphFontTypeface(name);
        this.getO1Title().getGraphFont().setGraphFontTypeface(name);
        this.getX1Title().getGraphFont().setGraphFontTypeface(name);
        this.getY1Title().getGraphFont().setGraphFontTypeface(name);
        this.getY2Title().getGraphFont().setGraphFontTypeface(name);
        this.getZTitle().getGraphFont().setGraphFontTypeface(name);
        this.getLegendText().getGraphFont().setGraphFontTypeface(name);
        this.getMarkerText().getGraphFont().setGraphFontTypeface(name);
        this.getO1TickLabel().getGraphFont().setGraphFontTypeface(name);
        this.getPieLabel().getGraphFont().setGraphFontTypeface(name);
        this.getRingTotalLabel().getGraphFont().setGraphFontTypeface(name);
        this.getSliceLabel().getGraphFont().setGraphFontTypeface(name);
        this.getX1TickLabel().getGraphFont().setGraphFontTypeface(name);
        this.getY1TickLabel().getGraphFont().setGraphFontTypeface(name);
        this.getY2TickLabel().getGraphFont().setGraphFontTypeface(name);
        this.getZTickLabel().getGraphFont().setGraphFontTypeface(name);
        if (this.getPagingControl() != null) {
            this.getPagingControl().getViewStyle().setFontName(name);
        }
        Font font = this.getDataviewTitle().getFont();
        Font newFont = new Font(name, font.getStyle(), font.getSize());
        this.getDataviewTitle().setFont(newFont);
        font = this.getDataviewSubtitle().getFont();
        newFont = new Font(name, font.getStyle(), font.getSize());
        this.getDataviewSubtitle().setFont(newFont);
        font = this.getDataviewFootnote().getFont();
        newFont = new Font(name, font.getStyle(), font.getSize());
        this.getDataviewFootnote().setFont(newFont);
    }

    public boolean isParetoBarsConnected() {
        return this.m_commonGraph.isParetoBarsConnected();
    }

    public void setParetoBarsConnected(boolean connected) {
        this.m_commonGraph.setParetoBarsConnected(connected);
    }

    public int getPieDepth() {
        return this.m_commonGraph.getPieDepth();
    }

    public void setPieDepth(int depth) {
        this.m_commonGraph.setPieDepth(depth);
    }

    public int getPieRotation() {
        return this.m_commonGraph.getPieRotation();
    }

    public void setPieRotation(int degrees) {
        this.m_commonGraph.setPieRotation(degrees);
    }

    public int getPieTilt() {
        return this.m_commonGraph.getPieTilt();
    }

    public void setPieTilt(int tilt) {
        this.m_commonGraph.setPieTilt(tilt);
    }

    public int getPresentationHeight() {
        return this.m_gPanel.getBounds().height;
    }

    public int getPresentationWidth() {
        return this.m_gPanel.getBounds().width;
    }

    public boolean isScatterDataLineDisplayed() {
        return this.m_commonGraph.isScatterDataLineDisplayed();
    }

    public void setScatterDataLineDisplayed(boolean yesNo) {
        this.m_commonGraph.setScatterDataLineDisplayed(yesNo);
    }

    public int getSeriesEffect() {
        return this.m_commonGraph.getSeriesEffect();
    }

    public void setSeriesEffect(int effect) {
        this.m_commonGraph.setSeriesEffect(effect);
    }

    public int getSeriesObjectCount() {
        return this.m_commonGraph.getSeriesObjectCount();
    }

    public void setSeriesObjectCount(int count) {
        this.m_commonGraph.setSeriesObjectCount(count);
    }

    public void setThresholdObjectCount(int count) {
        this.m_commonGraph.setThresholdObjectCount(count);
    }

    public int getThresholdObjectCount() {
        return this.m_commonGraph.getThresholdObjectCount();
    }

    public int getSeriesTooltipLabelType() {
        return this.m_commonGraph.getSeriesTooltipLabelType();
    }

    public void setSeriesTooltipLabelType(int type) {
        this.m_commonGraph.setSeriesTooltipLabelType(type);
    }

    public void setSeriesRolloverBehavior(int behavior) {
        this.m_commonGraph.setSeriesRolloverBehavior(behavior);
    }

    public int getSeriesRolloverBehavior() {
        return this.m_commonGraph.getSeriesRolloverBehavior();
    }

    public int getScrollbarPresenceGroups() {
        return this.m_commonGraph.getScrollbarPresenceGroups();
    }

    public void setScrollbarPresenceGroups(int scroll) {
        this.m_commonGraph.setScrollbarPresenceGroups(scroll);
    }

    public int getScrollbarPresenceSeries() {
        return this.m_commonGraph.getScrollbarPresenceSeries();
    }

    public void setScrollbarPresenceSeries(int scroll) {
        this.m_commonGraph.setScrollbarPresenceSeries(scroll);
    }

    public int getStartGroup() {
        return this.m_commonGraph.getStartGroup();
    }

    public void setStartGroup(int group) {
        this.m_commonGraph.setStartGroup(group);
    }

    public int getStartColumn() {
        return this.m_commonGraph.getStartColumn();
    }

    public void setStartColumn(int column) {
        this.m_commonGraph.setStartColumn(column);
    }

    public int getStartSeries() {
        return this.m_commonGraph.getStartSeries();
    }

    public void setStartSeries(int series) {
        this.m_commonGraph.setStartSeries(series);
    }

    public int getStartRow() {
        return this.m_commonGraph.getStartRow();
    }

    public void setStartRow(int row) {
        this.m_commonGraph.setStartRow(row);
    }

    public int getToolTipDelay() {
        return this.m_commonGraph.getToolTipDelay();
    }

    public void setToolTipDelay(int delay) {
        this.m_commonGraph.setToolTipDelay(delay);
    }

    public int getZoomDirection() {
        return this.m_pfj.getZoomDirection();
    }

    public void setZoomDirection(int axes) {
        switch (axes) {
            case 0: 
            case 1: 
            case 2: {
                this.m_pfj.setZoomDirection(axes);
                break;
            }
            default: {
                this.getErrorHandler().log("invalid axes", this.getClass().getName(), "setZoomDirection(int axes)");
                break;
            }
        }
    }

    public boolean isHorizontal() {
        return this.m_pfj.isChartOrientHorz();
    }

    public CustomToolTipCallback getCustomToolTipCallback() {
        return this.m_commonGraph.getCustomToolTipCallback();
    }

    public void setCustomToolTipCallback(CustomToolTipCallback callback) {
        this.m_commonGraph.setCustomToolTipCallback(callback);
    }

    public DataErrorTextCallback getDataErrorTextCallback() {
        return this.m_commonGraph.getDataErrorTextCallback();
    }

    public void setDataErrorTextCallback(DataErrorTextCallback callback) {
        this.m_commonGraph.setDataErrorTextCallback(callback);
    }

    public AreaMarker getAreaMarker() {
        return this.m_commonGraph.getAreaMarker();
    }

    public Connector getConnector() {
        return this.m_commonGraph.getConnector();
    }

    public DataLine getDataLine() {
        return this.m_commonGraph.getDataLine();
    }

    public DataMarker getDataMarker() {
        return this.m_commonGraph.getDataMarker();
    }

    public GraphBackground getGraphBackground() {
        return this.m_commonGraph.getGraphBackground();
    }

    public Titles getFootnote() {
        return this.m_commonGraph.getFootnote();
    }

    public LegendArea getLegendArea() {
        return this.m_commonGraph.getLegendArea();
    }

    public LegendTitle getLegendTitle() {
        return this.m_commonGraph.getLegendTitle();
    }

    public LegendMarker getLegendMarker() {
        return this.m_commonGraph.getLegendMarker();
    }

    public LegendText getLegendText() {
        return this.m_commonGraph.getLegendText();
    }

    public FunnelFrame getFunnelFrame() {
        return this.m_commonGraph.getFunnelFrame();
    }

    public double getFunnelViewAngle() {
        return this.m_commonGraph.getFunnelViewAngle();
    }

    public void setFunnelViewAngle(double viewAngle) {
        this.m_commonGraph.setFunnelViewAngle(viewAngle);
        this.setFunnelRotateAngle(viewAngle);
    }

    public double getFunnelRotateAngle() {
        return this.m_commonGraph.getFunnelRotateAngle();
    }

    public void setFunnelRotateAngle(double rotateAngle) {
        this.m_commonGraph.setFunnelRotateAngle(rotateAngle);
    }

    public double getFunnelHeightRatio() {
        return this.m_commonGraph.getFunnelHeightRatio();
    }

    public void setFunnelHeightRatio(double heightRatio) {
        this.m_commonGraph.setFunnelHeightRatio(heightRatio);
    }

    public Fitline getFitline() {
        return this.m_commonGraph.getFitline();
    }

    public MarkerText getMarkerText() {
        return this.m_commonGraph.getMarkerText();
    }

    public O1Axis getO1Axis() {
        return this.m_commonGraph.getO1Axis();
    }

    public O1MajorTick getO1MajorTick() {
        return this.m_commonGraph.getO1MajorTick();
    }

    public O1TickLabel getO1TickLabel() {
        return this.m_commonGraph.getO1TickLabel();
    }

    public O1Title getO1Title() {
        return this.m_commonGraph.getO1Title();
    }

    public PieFeeler getPieFeeler() {
        return this.m_commonGraph.getPieFeeler();
    }

    public PieFrame getPieFrame() {
        return this.m_commonGraph.getPieFrame();
    }

    public PieLabel getPieLabel() {
        return this.m_commonGraph.getPieLabel();
    }

    public PlotArea getPlotArea() {
        return this.m_commonGraph.getPlotArea();
    }

    public QuadrantLine getQuadrantLine() {
        return this.m_commonGraph.getQuadrantLine();
    }

    public RingTotalLabel getRingTotalLabel() {
        return this.m_commonGraph.getRingTotalLabel();
    }

    public Series getSeries() {
        return this.m_commonGraph.getSeries();
    }

    public UISeriesColor getUISeriesColor() {
        return this.m_commonGraph.getSeries();
    }

    public UIThresholdColor getUIThresholdColor() {
        return this.m_commonGraph.getThreshold();
    }

    public Threshold getThreshold() {
        return this.m_commonGraph.getThreshold();
    }

    public Slice getSlice() {
        return this.m_commonGraph.getSlice();
    }

    public SliceLabel getSliceLabel() {
        return this.m_commonGraph.getSliceLabel();
    }

    public StockMarker getStockMarker() {
        return this.m_commonGraph.getStockMarker();
    }

    public UIParetoLine getParetoLine() {
        return this.m_commonGraph.getParetoLine();
    }

    public ParetoMarker getParetoMarker() {
        return this.m_commonGraph.getParetoMarker();
    }

    public Titles getSubtitle() {
        return this.m_commonGraph.getSubtitle();
    }

    public ThreeDFloor get3DFloor() {
        return this.m_commonGraph.get3DFloor();
    }

    public ThreeDLeftWall get3DLeftWall() {
        return this.m_commonGraph.get3DLeftWall();
    }

    public ThreeDRightWall get3DRightWall() {
        return this.m_commonGraph.get3DRightWall();
    }

    public ThreeDMarker get3DMarker() {
        return this.m_commonGraph.get3DMarker();
    }

    public ThreeDViewMatrix get3DViewMatrix() {
        return this.m_commonGraph.get3DViewMatrix();
    }

    public SplitDivider getSplitDivider() {
        return this.m_commonGraph.getSplitDivider();
    }

    public TimeSelector getTimeSelector() {
        return this.m_commonGraph.getTimeSelector();
    }

    public Titles getTitle() {
        return this.m_commonGraph.getTitle();
    }

    public TwoDMarker get2DMarker() {
        return this.m_commonGraph.get2DMarker();
    }

    public VolumeMarker getVolumeMarker() {
        return this.m_commonGraph.getVolumeMarker();
    }

    public X1Axis getX1Axis() {
        return this.m_commonGraph.getX1Axis();
    }

    public X1MajorTick getX1MajorTick() {
        return this.m_commonGraph.getX1MajorTick();
    }

    public X1TickLabel getX1TickLabel() {
        return this.m_commonGraph.getX1TickLabel();
    }

    public X1Title getX1Title() {
        return this.m_commonGraph.getX1Title();
    }

    public XPanelGrid getXPanelGrid() {
        return this.m_commonGraph.getXPanelGrid();
    }

    public Y1Axis getY1Axis() {
        return this.m_commonGraph.getY1Axis();
    }

    public Y1MajorTick getY1MajorTick() {
        return this.m_commonGraph.getY1MajorTick();
    }

    public Y1TickLabel getY1TickLabel() {
        return this.m_commonGraph.getY1TickLabel();
    }

    public Y1Title getY1Title() {
        return this.m_commonGraph.getY1Title();
    }

    public Y1ZeroLine getY1ZeroLine() {
        return this.m_commonGraph.getY1ZeroLine();
    }

    public Y2Axis getY2Axis() {
        return this.m_commonGraph.getY2Axis();
    }

    public Y2MajorTick getY2MajorTick() {
        return this.m_commonGraph.getY2MajorTick();
    }

    public Y1BaseLine getY1BaseLine() {
        return this.m_commonGraph.getY1BaseLine();
    }

    public Y2BaseLine getY2BaseLine() {
        return this.m_commonGraph.getY2BaseLine();
    }

    public Alert getAlert(int index) {
        return this.m_commonGraph.getAlert(index);
    }

    public Alert createAlert(Object xValue, Object yValue) {
        return this.m_commonGraph.createAlert(xValue, yValue);
    }

    public Annotation createAnnotation(int series, int group) {
        return this.m_commonGraph.createAnnotation(series, group);
    }

    public void setAnnotationsVisibility(int visibility) {
        this.m_commonGraph.setAnnotationsVisibility(visibility);
    }

    public int getAnnotationsVisibility() {
        return this.m_commonGraph.getAnnotationsVisibility();
    }

    public ReferenceObject createReferenceObject() {
        return this.m_commonGraph.createReferenceObject();
    }

    public ReferenceObject getReferenceObject(int id) {
        return this.m_commonGraph.getReferenceObject(id);
    }

    public List getReferenceObjects(int component) {
        return this.m_commonGraph.getReferenceObjects(component);
    }

    public void destroyReferenceObject(int id) {
        this.m_commonGraph.destroyReferenceObject(id);
    }

    public void destroyReferenceObjects(int component) {
        this.m_commonGraph.destroyReferenceObjects(component);
    }

    public int getReferenceObjectDisplay(int component) {
        return this.m_commonGraph.getReferenceObjectDisplay(component);
    }

    public void setReferenceObjectDisplay(int component, int display) {
        this.m_commonGraph.setReferenceObjectDisplay(component, display);
    }

    public ReferenceObjectMarker getReferenceObjectMarker() {
        return this.m_commonGraph.getReferenceObjectMarker();
    }

    public ReferenceObjectText getReferenceObjectText() {
        return this.m_commonGraph.getReferenceObjectText();
    }

    public Y2TickLabel getY2TickLabel() {
        return this.m_commonGraph.getY2TickLabel();
    }

    public Y2Title getY2Title() {
        return this.m_commonGraph.getY2Title();
    }

    public Y2ZeroLine getY2ZeroLine() {
        return this.m_commonGraph.getY2ZeroLine();
    }

    public Y3DMarkerGrid getY3DMarkerGrid() {
        return this.m_commonGraph.getY3DMarkerGrid();
    }

    public YPanelGrid getYPanelGrid() {
        return this.m_commonGraph.getYPanelGrid();
    }

    public ZPanelGrid getZPanelGrid() {
        return this.m_commonGraph.getZPanelGrid();
    }

    public ZTickLabel getZTickLabel() {
        return this.m_commonGraph.getZTickLabel();
    }

    public ZTitle getZTitle() {
        return this.m_commonGraph.getZTitle();
    }

    public void setTickLabelCallback(TickLabelCallback callback, int axisID) {
        this.m_commonGraph.setTickLabelCallback(callback, axisID);
    }

    public TickLabelCallback getTickLabelCallback(int axisID) {
        return this.m_commonGraph.getTickLabelCallback(axisID);
    }

    public UndefinedComponent getUndefinedComponent() {
        return this.m_commonGraph.getUndefinedComponent();
    }

    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        return this.m_commonGraph.setXML(xmlString, reset);
    }

    public boolean readXML(InputStream stream, int reset) throws BIIOException, BISAXException, BIParseException {
        return this.m_commonGraph.readXML(stream, reset);
    }

    public Enumeration getImagemapEnumeration(int filter) {
        return this.m_commonGraph.getImagemapEnumeration(filter);
    }

    public void writeImagemapXML(OutputStream os, int filter) {
        PrintWriter out = new PrintWriter(os);
        this.writeImagemapXML(out, filter);
    }

    public void writeImagemapXML(PrintWriter out, int filter) {
        Enumeration compEnum = this.getImagemapEnumeration(filter);
        out.println("<?xml version='1.0'?>");
        out.println("<!-- This document contains information for image map generation-->");
        out.println("<GraphMap>");
        while (compEnum.hasMoreElements()) {
            String[] tooltips;
            ImagemapComponent comp = (ImagemapComponent)compEnum.nextElement();
            ComponentHandle handle = comp.getComponentHandle();
            Polygon poly = comp.getPlacement();
            out.print("<");
            out.print(handle.getName());
            out.println(">");
            int series = -1;
            int group = -1;
            if (handle instanceof DataComponentHandle) {
                series = ((DataComponentHandle)handle).getSeries();
                group = ((DataComponentHandle)handle).getGroup();
            } else if (handle instanceof SeriesComponentHandle) {
                series = ((SeriesComponentHandle)handle).getSeries();
            } else if (handle instanceof GroupComponentHandle) {
                group = ((GroupComponentHandle)handle).getGroup();
            }
            if (group >= 0) {
                out.print("<Group>");
                out.print(group);
                out.println("</Group>");
            }
            if (series >= 0) {
                out.print("<Series>");
                out.print(series);
                out.println("</Series>");
            }
            if ((tooltips = comp.getTooltips()) != null && tooltips.length > 0) {
                out.println("<Tooltip>");
                int n = 0;
                while (n < tooltips.length) {
                    if (tooltips[n].length() > 0) {
                        out.print("<Line>");
                        out.print(tooltips[n]);
                        out.println("</Line>");
                    }
                    ++n;
                }
                out.println("</Tooltip>");
            }
            int iMax = poly.npoints;
            out.println("<Geometry>");
            int i = 0;
            while (i < iMax) {
                out.print("<Vertex x=\"");
                out.print(poly.xpoints[i]);
                out.print("\" y=\"");
                out.print(poly.ypoints[i]);
                out.println("\" />");
                ++i;
            }
            out.println("</Geometry>");
            out.print("</");
            out.print(handle.getName());
            out.println(">");
        }
        out.println("</GraphMap>");
        out.flush();
    }

    public void setScaleFontSizeForGIF(int scale) {
        this.m_commonGraph.setScaleFontSizeForGIF(scale);
    }

    public int getScaleFontSizeForGIF() {
        return this.m_commonGraph.getScaleFontSizeForGIF();
    }

    public void setBackgroundTransparent(boolean transparent) {
        this.setOpaque(transparent ^ true);
        this.m_gPanel.setOpaque(transparent ^ true);
    }

    protected void processAlertEvent(int eventID) {
        this.m_commonGraph.processAlertEvent(eventID);
    }

    public void drawImage(Image image, int x, int y, Graphics g) {
        this.m_gPanel.drawImage(image, x, y, g);
    }

    public void paint(Graphics g) {
        if (this.m_stopRepaints) {
            return;
        }
        if (!this.m_printOrPreviewMode) {
            super.paint(g);
        } else if (this.m_offscreenImage != null) {
            g.drawImage(this.m_offscreenImage, 0, 0, null);
        }
    }

    public void modelWaitDataAvailable(WaitDataAvailableEvent e) {
        this.m_pfj.setLazyDataFetchMessage(null);
        this.m_commonGraph.setDirty(true);
        this.m_pfj.needRecalc();
        super.modelWaitDataAvailable(e);
        this.m_commonGraph.clearDrillState();
    }

    public void setPieBarSeries(int series) {
        this.m_commonGraph.setPieBarSeries(series);
    }

    public int getPieBarSeries() {
        return this.m_commonGraph.getPieBarSeries();
    }

    public boolean isDualY() {
        return CommonGraph.isDualY(this.getGraphType());
    }

    public void setPrintOrPreviewMode(boolean bool) {
        Graphics offg = null;
        if (this.isJavaComponent()) {
            this.m_gPanel.setPrintOrPreviewMode(bool);
        }
        if (bool) {
            Dimension size = this.getSize();
            if (this.m_offscreenImage == null) {
                this.m_offscreenImage = this.createImage(size.width, size.height);
            }
            if (this.m_offscreenImage != null) {
                offg = this.m_offscreenImage.getGraphics();
                offg.setClip(0, 0, size.width, size.height);
                this.paint(offg);
            }
            this.m_printOrPreviewMode = bool;
        } else {
            this.m_printOrPreviewMode = bool;
            if (offg != null) {
                offg.dispose();
            }
            this.m_offscreenImage = null;
        }
    }

    public static String convertGraphTypeToString(int value) {
        return CommonGraph.convertGraphTypeToString(value);
    }

    public static int convertGraphTypeToInt(String string) {
        return CommonGraph.convertGraphTypeToInt(string);
    }

    public boolean isPrintOrPreviewMode() {
        return this.m_printOrPreviewMode;
    }

    public void updatePageItems() {
        if (this.getPagingControl() != null) {
            this.getPagingControl().updatePageItems();
        }
    }

    public void applyViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        if (viewFormat != null) {
            Object co = componentHandle.getComponent();
            if (co instanceof BaseDataAxis) {
                ((BaseDataAxis)co).setViewFormat(viewFormat);
            } else if (co instanceof SliceLabel) {
                ((SliceLabel)co).setViewFormat(viewFormat);
            } else if (co instanceof MarkerText) {
                ((MarkerText)co).setViewFormat(viewFormat, 0);
            }
        }
    }

    public ViewFormat getComponentViewFormat(ComponentHandle componentHandle) {
        Object co = componentHandle.getComponent();
        if (co instanceof SliceLabel) {
            return ((SliceLabel)co).getViewFormat();
        }
        if (co instanceof MarkerText) {
            return ((MarkerText)co).getViewFormat(0);
        }
        if (co instanceof BaseDataAxis) {
            return ((BaseDataAxis)co).getViewFormat();
        }
        return null;
    }

    protected void firePrintBegin(Object source) {
        super.firePrintBegin(source);
    }

    protected void firePrintEnd(Object source) {
        super.firePrintEnd(source);
    }

    protected void updateResourceBundle() {
        this.m_commonGraph.updateResourceBundle();
    }

    public void setContext() {
        this.m_commonGraph.setContext();
    }

    protected DataviewXML getViewXML() {
        return this.m_commonGraph.getViewXML();
    }

    protected ObjectNode getObjectNode(boolean allProperties) {
        return this.m_commonGraph.getObjectNode(allProperties);
    }

    public ObjectNode getPagingControlXML(boolean allProperties) {
        if (this.getPagingControl() == null) {
            return null;
        }
        return this.getPagingControl().getObjectNode(allProperties);
    }

    public void setPagingControlXML(ObjectNode pagingControl, String version, int reset) {
        if (this.getPagingControl() != null) {
            this.getPagingControl().setObjectNode(pagingControl, version, reset);
        }
    }

    protected void setXML(ObjectNode node, int reset) {
        this.m_commonGraph.setXML(node, reset);
    }

    public boolean setXMLAsString(String xml) throws BIPersistenceException {
        return this.m_commonGraph.setXMLAsString(xml);
    }

    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            super.setPersistableComponents(persistables);
            int i = 0;
            while (i < persistables.length) {
                Persistable aggregate = persistables[i].getPersistable();
                if (aggregate instanceof CustomStyle) {
                    this.setBaseStyle((CustomStyle)aggregate);
                    break;
                }
                ++i;
            }
        }
        try {
            this.loadCompleted();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        return this.m_commonGraph.getPersistableAttributes(oldAttrs);
    }

    public void loadCompleted() throws BIPersistenceException {
        this.m_commonGraph.loadCompleted();
    }

    public boolean setTabularData(List tableRows) {
        return this.m_commonGraph.setTabularData(tableRows);
    }

    public void applySampleData() {
        if (this.m_sampleDataSource == null) {
            this.m_sampleDataSource = new SampleDataSource(this.getCommonGraph());
        } else {
            this.m_sampleDataSource.setSampleDataSource();
        }
    }

    public boolean setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        return this.m_commonGraph.setGridData(columnLabels, rowLabels, data);
    }

    public int getColumnCount() throws EdgeOutOfRangeException {
        return this.m_commonGraph.getColumnCount();
    }

    public int getRowCount() throws EdgeOutOfRangeException {
        return this.m_commonGraph.getRowCount();
    }

    public Object getDataAccessSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (edge == 1) {
            return ((DataCallback)this.m_commonGraph.getDataFilter()).rowLabel(slice);
        }
        return ((DataCallback)this.m_commonGraph.getDataFilter()).columnLabel(slice);
    }

    protected void setMetadataDrillSupported(boolean supported) {
        this.m_commonGraph.setMetadataDrillSupported(supported);
    }

    protected boolean isMetadataDrillSupported() {
        return this.m_commonGraph.isMetadataDrillSupported();
    }

    protected void setDataUnformattedSupported(boolean supported) {
        super.setDataUnformattedSupported(supported);
    }

    protected void setMetadataLongLabelSupported(boolean supported) {
        super.setMetadataLongLabelSupported(supported);
    }

    protected void setMetadataMediumLabelSupported(boolean supported) {
        super.setMetadataMediumLabelSupported(supported);
    }

    protected void setMetadataShortLabelSupported(boolean supported) {
        super.setMetadataShortLabelSupported(supported);
    }

    protected void setMetadataValueSupported(boolean supported) {
        super.setMetadataValueSupported(supported);
    }

    protected void setMetadataDrillParentDateSupported(boolean supported) {
        this.m_commonGraph.setMetadataDrillParentDateSupported(supported);
    }

    protected boolean isMetadataDrillParentDateSupported() {
        return this.m_commonGraph.isMetadataDrillParentDateSupported();
    }

    protected void setMetadataDrillParentDateSpanSupported(boolean supported) {
        this.m_commonGraph.setMetadataDrillParentDateSpanSupported(supported);
    }

    protected boolean isMetadataDrillParentDateSpanSupported() {
        return this.m_commonGraph.isMetadataDrillParentDateSpanSupported();
    }

    protected void setMetadataDateSupported(boolean supported) {
        this.m_commonGraph.setMetadataDateSupported(supported);
    }

    protected void setMetadataDateSpanSupported(boolean supported) {
        this.m_commonGraph.setMetadataDateSpanSupported(supported);
    }

    protected boolean isMetadataDateSpanSupported() {
        return this.m_commonGraph.isMetadataDateSpanSupported();
    }

    protected void setLayerMetaMediumLabelSupported(boolean supported) {
        super.setLayerMetaMediumLabelSupported(supported);
    }

    protected void setLayerMetaShortLabelSupported(boolean supported) {
        super.setLayerMetaShortLabelSupported(supported);
    }

    protected void setLayerMetaNameSupported(boolean supported) {
        super.setLayerMetaNameSupported(supported);
    }

    protected void metadataLabelTypeChanged() {
        super.metadataLabelTypeChanged();
        this.m_commonGraph.setDirty(true);
        this.m_pfj.needRecalc();
        this.repaint();
    }

    public void beginAxisChanges() {
    }

    public void endAxisChanges() {
    }

    public void setSwapAllowed(boolean swap) {
        if (this.getPagingControl() == null) {
            this.m_swapAllowed = swap;
            return;
        }
        boolean oldSwapAllowed = this.getPagingControl().isSwapAllowed();
        this.getPagingControl().setSwapAllowed(swap);
        this.firePropertyChange(this, "SwapAllowed", new Boolean(oldSwapAllowed), new Boolean(swap));
    }

    public boolean isSwapAllowed() {
        if (this.getPagingControl() == null) {
            return this.m_swapAllowed;
        }
        return this.getPagingControl().isSwapAllowed();
    }

    protected void setLayerMetaLongLabelSupported(boolean supported) {
        super.setLayerMetaLongLabelSupported(supported);
    }

    public void notEnoughData(NotEnoughData neData) {
        this.m_commonGraph.notEnoughData(neData);
    }

    public boolean isGroupSeriesTooltipSupported(int edge) {
        return this.m_commonGraph.isGroupSeriesTooltipSupported(edge);
    }

    public DataFilter getDataFilter() {
        return this.m_commonGraph.getDataFilter();
    }

    protected boolean isStyleOverrideFlag(int attrID) {
        return this.m_commonGraph.isStyleOverrideFlag(attrID);
    }

    public void setMaxBarWidth(int width) {
        this.m_commonGraph.setMaxBarWidth(width);
    }

    public int getMaxBarWidth() {
        return this.m_commonGraph.getMaxBarWidth();
    }

    public void setDrillingEnabled(boolean b) {
        super.setDrillingEnabled(b);
        this.m_pfj.needRecalc();
    }

    protected void saveDrillState() {
        this.m_commonGraph.saveDrillState();
    }

    public int getMaxTickLabelAutoFontSize() {
        return this.m_commonGraph.getMaxTickLabelAutoFontSize();
    }

    public void setMaxTickLabelAutoFontSize(int size) {
        this.m_commonGraph.setMaxTickLabelAutoFontSize(size);
    }

    public int getMinTickLabelAutoFontSize() {
        return this.m_commonGraph.getMinTickLabelAutoFontSize();
    }

    public void setMinTickLabelAutoFontSize(int size) {
        this.m_commonGraph.setMinTickLabelAutoFontSize(size);
    }

    public int getLegendSeriesCount() {
        return this.m_commonGraph.getLegendSeriesCount();
    }

    public void setLegendSeriesCount(int count) {
        this.m_commonGraph.setLegendSeriesCount(count);
    }

    public int getLegendSeriesStart() {
        return this.m_commonGraph.getLegendSeriesStart();
    }

    public void setLegendSeriesStart(int start) {
        this.m_commonGraph.setLegendSeriesStart(start);
    }

    public int getLegendScrollbarPresence() {
        return this.m_commonGraph.getLegendScrollbarPresence();
    }

    public void setLegendScrollbarPresence(int presence) {
        this.m_commonGraph.setLegendScrollbarPresence(presence);
    }

    public boolean isGroup3DPanels() {
        return this.m_commonGraph.isGroup3DPanels();
    }

    public void setGroup3DPanels(boolean yesNo) {
        this.m_commonGraph.setGroup3DPanels(yesNo);
    }

    public void setExplicitTimeRangeStart(Date date) {
        this.m_commonGraph.setExplicitTimeRangeStart(date);
    }

    public Date getExplicitTimeRangeStart() {
        return this.m_commonGraph.getExplicitTimeRangeStart();
    }

    public void setExplicitTimeRangeEnd(Date date) {
        this.m_commonGraph.setExplicitTimeRangeEnd(date);
    }

    public Date getExplicitTimeRangeEnd() {
        return this.m_commonGraph.getExplicitTimeRangeEnd();
    }

    public void setTimeRangeMode(int mode) {
        this.m_commonGraph.setTimeRangeMode(mode);
    }

    public int getTimeRangeMode() {
        return this.m_commonGraph.getTimeRangeMode();
    }

    public void setRelativeTimeRange(long time) {
        this.m_commonGraph.setRelativeTimeRange(time);
    }

    public long getRelativeTimeRange() {
        return this.m_commonGraph.getRelativeTimeRange();
    }

    public void calculatePlacement() {
        Dimension oldSize = this.m_pfj.getImageSize();
        if (this.m_gPanel != null && this.m_gPanel.getBounds() != null && this.m_gPanel.getBounds().width > 0 && this.m_gPanel.getBounds().height > 0) {
            this.m_pfj.setImageSize(this.m_gPanel.getSize());
        }
        this.m_pfj.calcWithoutDrawing();
        this.m_pfj.setImageSize(oldSize);
    }

    public ViewStyle getComponentViewStyle(ComponentHandle componentHandle) {
        if (componentHandle instanceof PageItemComponentHandle) {
            return this.getGraphStyleManager().getMetadataStyle(this, null, this.getPagingControl().getViewStyle(), 2, ((PageItemComponentHandle)componentHandle).getPageItem(), 0);
        }
        return null;
    }

    public void applyViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        DataAccess dataAccess = this.getGraphModel().getDataAccess();
        if (dataAccess == null) {
            return;
        }
        if (componentHandle instanceof PageItemComponentHandle) {
            try {
                QDR qdr = null;
                qdr = dataAccess.getLayerQDR(2, ((PageItemComponentHandle)componentHandle).getPageItem(), 0);
                if (qdr != null) {
                    qdr.setTarget(new QDRMember(dataAccess.getLayerMetadata(2, ((PageItemComponentHandle)componentHandle).getPageItem(), "dimName").toString()));
                    QDRDiscriminator discriminator = new QDRDiscriminator(qdr, 4);
                    DiscriminatorRule rule = new DiscriminatorRule((Discriminator)discriminator, (Mergeable)viewStyle);
                    Vector<RuleBundle> ruleBundles = this.getGraphStyleManager().getBundles();
                    if (ruleBundles == null) {
                        ruleBundles = new Vector<RuleBundle>();
                    }
                    RuleBundle ruleBundle = null;
                    if (ruleBundles.size() == 0) {
                        ruleBundle = new RuleBundle();
                        ruleBundles.addElement(ruleBundle);
                    } else {
                        ruleBundle = (RuleBundle)ruleBundles.elementAt(0);
                    }
                    int count = ruleBundle.getCount();
                    int i = 0;
                    while (i < count) {
                        if (ruleBundle.getRule(i) instanceof DiscriminatorRule && rule != null && ((DiscriminatorRule)ruleBundle.getRule(i)).equals((Object)rule)) {
                            ruleBundle.removeRule(i);
                            break;
                        }
                        ++i;
                    }
                    ruleBundle.addRule((Rule)rule);
                    this.getGraphStyleManager().setBundles(this, ruleBundles);
                }
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
    }

    public String getIntlString(String key) {
        return this.m_commonGraph.getIntlString(key);
    }

    public int getViewType() {
        return 1;
    }

    public Font getDataErrorFont() {
        return this.m_commonGraph.getDataErrorFont();
    }

    public void setDataErrorFont(Font font) {
        this.m_commonGraph.setDataErrorFont(font);
    }

    public void setDataModelType(int dataModelType) {
        this.m_commonGraph.setDataModelType(dataModelType);
    }

    public int getDataModelType() {
        return this.m_commonGraph.getDataModelType();
    }

    public void setTimeAxisDateFormat(int element, String format) {
        this.m_commonGraph.setTimeAxisDateFormat(element, format);
    }

    public String getTimeAxisDateFormat(int element) {
        return this.m_commonGraph.getTimeAxisDateFormat(element);
    }

    public void setNoDataErrorText(String text) {
        this.m_commonGraph.setNoDataErrorText(text);
    }

    public String getNoDataErrorText() {
        return this.m_commonGraph.getNoDataErrorText();
    }

    public void applyFontSizes(float ratio) {
        this.m_commonGraph.applyFontSizes(ratio);
    }

    protected void resetFontSizes() {
        this.m_commonGraph.resetFontSizes();
    }

    public void setDirty(boolean yesNo) {
        this.m_commonGraph.setDirty(yesNo);
    }

    public void setFontMetricsResolver(FontMetricsResolver resolver) {
        this.getCommonGraph().setFontMetricsResolver(resolver);
    }

    public FontMetricsResolver getFontMetricsResolver() {
        return this.getCommonGraph().getFontMetricsResolver();
    }

    public DataviewCommon getDataviewCommon() {
        return this;
    }

    public ViewStyle getMetadataStyle(Object metaData, ViewStyle initStyle, int edge, int depth, int index) {
        return this.getGraphStyleManager().getMetadataStyle(this, metaData, initStyle, edge, depth, index);
    }

    public ViewStyle getPagingControlViewStyle() {
        if (this.getPagingControl() == null) {
            return null;
        }
        return this.getPagingControl().getViewStyle();
    }

    public boolean startExport() {
        this.m_bExporting = true;
        if (this.isDrillingEnabled()) {
            this.m_drillEnabled = true;
            super.setDrillingEnabled(false);
        }
        this.setPrintOrPreviewMode(true);
        return true;
    }

    public void endExport() {
        this.setPrintOrPreviewMode(false);
        this.m_bExporting = false;
        if (this.m_drillEnabled) {
            super.setDrillingEnabled(true);
        }
    }

    public boolean isExporting() {
        return this.m_bExporting;
    }

    protected boolean getDrillState(int edge, int slice) {
        return this.m_commonGraph.getDrillState(edge, slice);
    }

    protected boolean isPie(int graphType) {
        return this.m_commonGraph.isPie(graphType);
    }

    public boolean isExcelOrDeskTop() {
        return this.m_commonGraph.isExcelOrDeskTop();
    }

    public ThickPFJ getThickPFJ() {
        return this.m_gPanel;
    }

    private void $init$() {
        this.m_sampleDataSource = null;
        this.m_converter = null;
        this.m_offscreenImage = null;
        this.m_printOrPreviewMode = false;
        this.m_gPanel = null;
        this.m_drillDimension = null;
        this.m_bExporting = false;
        this.m_drillEnabled = false;
        this.m_swapAllowed = true;
    }

    public boolean isDrillingSupported() {
        return this.m_commonGraph.isDrillingSupported();
    }

    public int[] getDrillParameters(ComponentHandle handle) {
        return this.m_commonGraph.getDrillParameters(handle);
    }

    public String getAlternativeText(ComponentHandle handle) {
        return this.m_commonGraph.getAlternativeText(handle);
    }

    protected void applyStyle(CustomStyle style, int reset, boolean isStyleDefault) throws BIIOException, BISAXException, BIParseException {
        this.m_commonGraph.applyStyle(style, reset, isStyleDefault);
    }

    public CustomStyle getStyle() {
        return this.m_commonGraph.getStyle();
    }

    public void setStyle(CustomStyle style) throws BIIOException, BISAXException, BIParseException {
        this.m_commonGraph.setStyle(style);
    }

    public String getStylePath() {
        return this.m_commonGraph.getStylePath();
    }

    public void setStylePath(String stylePath) throws IOException, BIIOException, BISAXException, BIParseException {
        this.m_commonGraph.setStylePath(stylePath);
    }

    public CustomStyle createStyle() {
        CustomStyle newStyle = new CustomStyle();
        newStyle.setPersistableObjectType("GraphStyle");
        this.updateStyle(newStyle);
        return newStyle;
    }

    public void editStyle(CustomStyle style) throws BIIOException, BISAXException, BIParseException {
        this.m_commonGraph.editStyle(style);
    }

    public CustomStyle createGraphStyle() {
        CustomStyle newStyle = new CustomStyle(this.getXML(false));
        newStyle.setPersistableObjectType("Graph");
        newStyle.setBaseStyle(this.getBaseStyle());
        return newStyle;
    }

    public void updateStyle(CustomStyle style) {
        if (style == null) {
            this.getErrorHandler().log("invalid style argument", this.getClass().getName(), "public void updateStyle(CustomStyle style)");
        } else {
            style.setXMLAsString(this.getStyleXML());
            style.setBaseStyle(this.getBaseStyle());
        }
    }

    public String getStyleXML() {
        return this.m_commonGraph.getStyleXML();
    }

    public CustomStyle getBaseStyle() {
        return this.m_commonGraph.getBaseStyle();
    }

    public void setBaseStyle(CustomStyle baseStyle) {
        this.m_commonGraph.setBaseStyle(baseStyle);
    }

    public void set3DEffect(boolean yesNo) {
        this.m_commonGraph.set3DEffect(yesNo);
    }

    public boolean is3DEffect() {
        return this.m_commonGraph.is3DEffect();
    }

    public boolean exportGraphToStream(OutputStream out) {
        this.exportToPNG(out);
        return true;
    }

    private class GraphPanel
    extends JPanel
    implements ThickPFJ,
    ViewComponent {
        protected Image m_pfjOffscreenImage;
        protected boolean m_pfjPrintOrPreviewMode;

        public void setPrintOrPreviewMode(boolean bool) {
            Graphics offg = null;
            if (bool) {
                Dimension size = this.getSize();
                if (this.m_pfjOffscreenImage == null) {
                    this.m_pfjOffscreenImage = this.createImage(size.width, size.height);
                }
                if (this.m_pfjOffscreenImage != null) {
                    offg = this.m_pfjOffscreenImage.getGraphics();
                    offg.setClip(0, 0, size.width, size.height);
                    this.paint(offg);
                }
                this.m_pfjPrintOrPreviewMode = bool;
            } else {
                this.m_pfjPrintOrPreviewMode = bool;
                if (offg != null) {
                    offg.dispose();
                }
                this.m_pfjOffscreenImage = null;
            }
        }

        public void paint(Graphics g) {
            if (!this.m_pfjPrintOrPreviewMode) {
                super.paint(g);
            } else if (this.m_pfjOffscreenImage != null) {
                g.drawImage(this.m_pfjOffscreenImage, 0, 0, null);
            }
        }

        public void paintComponent(Graphics g) {
            Graph.this.getPFJ().paintComponent(g);
        }

        public void drawImage(Image image, int x, int y, Graphics g) {
            g.drawImage(image, x, y, this);
        }

        public void setSize(Dimension d) {
            super.setSize(d);
            Graph.this.getPFJ().doReshape();
            Graph.this.getPFJ().needRecalc();
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            Graph.this.getPFJ().doReshape();
            Graph.this.getPFJ().needRecalc();
        }

        public void setBounds(Rectangle r) {
            super.setBounds(r);
            Graph.this.getPFJ().doReshape();
            Graph.this.getPFJ().needRecalc();
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            Graph.this.getPFJ().doReshape();
            Graph.this.getPFJ().needRecalc();
        }

        public void updatePageItems() {
        }

        public int getID() {
            return 9;
        }

        public String getComponentName() {
            return "Graph";
        }

        public BeanInfo getBeanInfo() {
            return null;
        }

        private void $init$() {
            this.m_pfjOffscreenImage = null;
            this.m_pfjPrintOrPreviewMode = false;
        }

        private GraphPanel() {
            this.$init$();
        }

        GraphPanel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

