/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JFrame;
import oracle.bali.ewt.painter.PaintContext;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.PaginationRecord;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.graph.Graph;
import oracle.dss.graph.PFJ;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;

public class GraphPrinter
extends ViewPrinter {
    private boolean m_insuffSapce;
    private int pageNum;
    private int scaleFont;
    private int m_selectedIndex;
    private Rectangle pagingControlBounds;
    private Graph graph;
    private PFJ pfj;
    private JFrame m_frame;

    public GraphPrinter(Graph g) {
        super(g);
        this.$init$();
        this.graph = g;
        this.pfj = this.graph.getPFJ();
    }

    public int getViewPrinterType() {
        return 2;
    }

    public boolean startPrint() {
        return this.startPrint(false);
    }

    public boolean startPrint(boolean bPreviewMode) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "startPrint");
            return false;
        }
        if (this.graph.getParent() == null) {
            this.m_frame = new JFrame();
            this.graph.setSize(400, 400);
            this.m_frame.getContentPane().add("Center", this.graph);
            this.m_frame.pack();
        }
        if (this.paperHeight - (this.topMargin + this.bottomMargin) < 20 || this.paperWidth - (this.leftMargin + this.rightMargin) < 20) {
            this.logInsuffMsg("startPrint");
            return false;
        }
        this.m_insuffSapce = false;
        this.graph.firePrintBegin(this.graph);
        try {
            this.currLogPage.setHPos(this.graph.getGraphModel().getDataAccess().getEdgeCurrentHPos(2));
        }
        catch (EdgeOutOfRangeException e) {
            this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "startPrint");
        }
        this.graph.setPrintOrPreviewMode(true);
        this.saveTitlesFocus();
        this.graph.repaint();
        this.m_selectedIndex = 0;
        this.m_seqPageNumber = 0;
        this.pIndex = -1;
        return true;
    }

    public void endPrint() {
        try {
            int maxLayerSpecified = -1;
            if (this.currLogPage.getHPos() != null) {
                maxLayerSpecified = this.currLogPage.getHPos().length - 1;
            }
            this.changePageEdgeCurrentHPos(this.currLogPage.getHPos(), maxLayerSpecified);
        }
        catch (DataException e) {
            this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "endPrint");
        }
        this.m_insuffSapce = false;
        this.restoreTitlesFocus();
        this.graph.setPrintOrPreviewMode(false);
        this.m_bPreviewMode = false;
        this.pIndex = -1;
        this.graph.validate();
        this.graph.repaint();
        this.graph.firePrintEnd(this.graph);
        if (this.m_frame != null) {
            this.m_frame.remove(this.graph);
        }
        this.m_frame = null;
    }

    public boolean isFirstPhysicalPage() {
        return true;
    }

    public boolean isLastPhysicalPage() {
        return true;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
        this.setDataview(graph);
    }

    public void setScaleFontSize(int mask) {
        this.scaleFont = mask;
    }

    public int getScaleFontSize() {
        return this.scaleFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printPages(PrintJob pjob, boolean currentLogPage) {
        try {
            try {
                this.dimension = pjob.getPageDimension();
                int pageNum = 1;
                this.printableWidth = this.dimension.width - (this.leftMargin + this.rightMargin);
                if (this.printableWidth < 20) {
                    this.logInsuffMsg("printPages");
                }
                this.currentLogicalPage = currentLogPage;
                int[] hPos = null;
                if (currentLogPage) {
                    hPos = this.currLogPage.getHPos();
                } else if (this.rangeType == 1) {
                    hPos = this.graph.getGraphModel().getDataAccess().getFirstHPos(2);
                } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > 0) {
                    hPos = (int[])this.m_selectedHPos.elementAt(0);
                }
                if (hPos == null) {
                    hPos = new int[]{};
                }
                while (hPos != null) {
                    if (!currentLogPage) {
                        this.changePageEdgeCurrentHPos(hPos, hPos.length - 1);
                    }
                    this.fetchAllData();
                    Graphics g = pjob.getGraphics();
                    this.record = new PaginationRecord();
                    this.record.pageNum = pageNum++;
                    ++this.m_seqPageNumber;
                    this.viewLogPage.setHPos(hPos);
                    this.calcMargins(g);
                    this.printableHeight = this.dimension.height - (this.topMargin + this.bottomMargin);
                    if (this.printableHeight < 20) {
                        this.logInsuffMsg("printPages");
                        return;
                    }
                    this.printToGraphics(g, null);
                    this.printHeaderAndFooter(g);
                    g.dispose();
                    if (!currentLogPage) {
                        if (this.rangeType == 1) {
                            hPos = this.graph.getGraphModel().getDataAccess().getNextHPos(2, hPos);
                            continue;
                        }
                        ++this.m_selectedIndex;
                        if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
                            hPos = (int[])this.m_selectedHPos.elementAt(this.m_selectedIndex);
                            continue;
                        }
                        hPos = null;
                        continue;
                    }
                    hPos = null;
                }
                return;
            }
            finally {
                this.endPrint();
            }
        }
        catch (DataException exception) {
            this.graph.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "printPages");
            return;
        }
    }

    public boolean printPage(Graphics g) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "printPage");
            return false;
        }
        int oldLeftM = this.leftMargin;
        int oldTopM = this.topMargin;
        this.leftMargin = 0;
        this.topMargin = 0;
        this.printableWidth = this.viewDim.width;
        this.printableHeight = this.viewDim.height;
        this.printToGraphics(g, null);
        this.leftMargin = oldLeftM;
        this.topMargin = oldTopM;
        return true;
    }

    protected void printToGraphics(Graphics g, PaginationRecord record) {
        PaintContext printContext;
        Shape savedBounds = g.getClip();
        int savedPrintableHeight = this.printableHeight;
        g.translate(this.leftMargin, this.topMargin);
        g.setClip(null);
        int pageDims = 0;
        try {
            pageDims = this.graph.getGraphModel().getDataAccess().getLayerCount(2);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        this.calcAdornmentsDimension(this.printableWidth);
        int prefWidth = 0;
        int prefHeight = 0;
        int translatedWidth = this.leftMargin;
        int translatedHeight = this.topMargin;
        if (this.printableHeight < 20) {
            this.logInsuffMsg("printToGraphics");
            return;
        }
        if (this.m_topFormattedText != null) {
            g.setClip(0, 0, this.printableWidth, this.topFTAHeight);
            this.m_topFormattedText.print(new Dimension(this.printableWidth, this.topFTAHeight), g);
            g.translate(0, this.topFTAHeight);
            translatedHeight += this.topFTAHeight;
            this.printableHeight -= this.topFTAHeight;
        }
        if (this.graph.isPagingControlVisible() && this.graph.getPagingControlPosition() == 0 && pageDims > 0) {
            this.pagingControlBounds = this.graph.getPagingControl().getPagingComponent().getPageBounds(null, null, 0, 0, this.printableWidth, this.printableHeight);
            this.printableHeight -= this.pagingControlBounds.height;
            translatedHeight += this.pagingControlBounds.height;
            g.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.graph.getPagingControl().getPagingComponent().validate();
            printContext = this.graph.getPagingControl().getPagingComponent().getPrintPaintContext(g);
            this.graph.getPagingControl().getPagingComponent().printPage(printContext, null, g);
            g.translate(0, this.pagingControlBounds.height);
        }
        if (this.title.isVisible()) {
            this.title.setSize(this.printableWidth, this.title.getPreferredSize().height);
            prefHeight = this.title.getPreferredSize().height;
            prefWidth = this.title.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.title.setSize(this.printableWidth, prefHeight);
            this.titleHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.titleHeight);
            this.title.print(g);
            g.translate(0, this.titleHeight);
            translatedHeight += this.titleHeight;
            this.printableHeight -= this.titleHeight;
            this.title.setSize(this.oldTitleSize);
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.printableWidth, this.subtitle.getPreferredSize().height);
            prefHeight = this.subtitle.getPreferredSize().height;
            prefWidth = this.subtitle.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.subtitle.setSize(this.printableWidth, prefHeight);
            this.subtitleHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.subtitleHeight);
            this.subtitle.print(g);
            g.translate(0, this.subtitleHeight);
            this.printableHeight -= (translatedHeight += this.subtitleHeight);
            this.subtitle.setSize(this.oldSubtitleSize);
        }
        if (this.printableHeight < 20) {
            this.logInsuffMsg("printToGraphics");
            return;
        }
        if (this.graph.isPagingControlVisible() && this.graph.getPagingControlPosition() == 1 && pageDims > 0) {
            this.pagingControlBounds = this.graph.getPagingControl().getPagingComponent().getPageBounds(null, null, 0, 0, this.printableWidth, this.printableHeight);
            this.printableHeight -= this.pagingControlBounds.height;
            translatedHeight += this.pagingControlBounds.height;
            g.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.graph.getPagingControl().getPagingComponent().validate();
            printContext = this.graph.getPagingControl().getPagingComponent().getPrintPaintContext(g);
            this.graph.getPagingControl().getPagingComponent().printPage(printContext, null, g);
            g.translate(0, this.pagingControlBounds.height);
        }
        g.setClip(null);
        Dimension size = this.graph.getThickPFJ().getSize();
        int clipWidth = 0;
        int clipHeight = 0;
        this.printableHeight = this.printableHeight - this.footnoteHeight - this.bottomFTAHeight;
        if (this.printableHeight < 20) {
            this.logInsuffMsg("printToGraphics");
            return;
        }
        if (this.m_graphPrintScaleType == 0) {
            clipWidth = this.printableWidth < size.width ? this.printableWidth : size.width;
            clipHeight = this.printableHeight < size.height ? this.printableHeight : size.height;
            g.setClip(0, 0, clipWidth, clipHeight);
        } else if (this.m_graphPrintScaleType == 3) {
            if (this.scaleFont == -1) {
                this.graph.applyFontSizes((float)this.printableHeight / (float)this.graph.getThickPFJ().getSize().height);
            }
            this.graph.getThickPFJ().setSize(this.printableWidth, this.printableHeight);
            g.setClip(0, 0, this.printableWidth, this.printableHeight);
        } else if (this.m_graphPrintScaleType == 4) {
            float ratio_x = (float)this.printableWidth / (float)size.width;
            float ratio_y = (float)this.printableHeight / (float)size.height;
            float ratio = ratio_x < ratio_y ? ratio_x : ratio_y;
            int width = (int)((float)size.width * ratio);
            int height = (int)((float)size.height * ratio);
            if (this.scaleFont == -1) {
                this.graph.applyFontSizes((float)height / (float)this.graph.getThickPFJ().getSize().height);
            }
            this.graph.getThickPFJ().setSize(width, height);
            g.setClip(0, 0, width, height);
        } else if (this.m_graphPrintScaleType == 1 && this.printZoomFactor != 100) {
            int width = size.width * this.printZoomFactor / 100;
            int height = size.height * this.printZoomFactor / 100;
            clipWidth = this.printableWidth < width ? this.printableWidth : width;
            clipHeight = this.printableHeight < height ? this.printableHeight : height;
            if (this.scaleFont == -1) {
                this.graph.applyFontSizes((float)height / (float)this.graph.getThickPFJ().getSize().height);
            }
            this.graph.getThickPFJ().setSize(width, height);
            g.setClip(0, 0, clipWidth, clipHeight);
        }
        boolean drillEnabled = false;
        if (this.graph.isDrillingEnabled()) {
            drillEnabled = true;
            this.graph.setDrillingEnabled(false);
        }
        this.pfj.calcWithoutDrawing();
        if (drillEnabled) {
            this.graph.setDrillingEnabled(true);
        }
        this.pfj.print(g);
        this.graph.getThickPFJ().setSize(size);
        if (this.scaleFont == -1) {
            this.graph.resetFontSizes();
            this.pfj.calcWithoutDrawing();
        }
        this.printableHeight = savedPrintableHeight;
        g.translate(0, -translatedHeight);
        translatedHeight = 0;
        if (this.footnote.isVisible()) {
            int footnoteStart = this.printableHeight + this.topMargin - (this.bottomFTAHeight + this.footnoteHeight);
            g.translate(0, footnoteStart);
            translatedHeight += footnoteStart;
            this.footnote.setSize(this.printableWidth, this.footnote.getPreferredSize().height);
            prefHeight = this.footnote.getPreferredSize().height;
            prefWidth = this.footnote.getPreferredSize().width;
            if (prefWidth > this.printableWidth) {
                prefWidth = this.printableWidth;
            }
            this.footnote.setSize(this.printableWidth, prefHeight);
            this.footnoteHeight = prefHeight;
            g.setClip(0, 0, this.printableWidth, this.footnoteHeight);
            this.footnote.print(g);
            g.translate(0, this.footnoteHeight);
            translatedHeight += this.footnoteHeight;
            this.footnote.setSize(this.oldFootnoteSize);
        }
        if (this.m_bottomFormattedText != null) {
            if (!this.footnote.isVisible()) {
                int bottomFTAStart = this.printableHeight + this.topMargin - (this.bottomFTAHeight + this.footnoteHeight);
                g.translate(0, bottomFTAStart);
                translatedHeight += bottomFTAStart;
            }
            g.setClip(0, 0, this.printableWidth, this.bottomFTAHeight);
            this.m_bottomFormattedText.print(new Dimension(this.printableWidth, this.bottomFTAHeight), g);
            g.translate(0, this.bottomFTAHeight);
            translatedHeight += this.bottomFTAHeight;
        }
        g.translate(-translatedWidth, -translatedHeight);
        g.setClip(savedBounds);
    }

    public boolean goToFirstPage() {
        return this.prepareFirstPage(null);
    }

    public boolean prepareFirstPage(Graphics g) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "prepareFirstPage");
            return false;
        }
        this.pageNum = 0;
        this.m_seqPageNumber = 0;
        if (this.rangeType == 1) {
            try {
                this.viewLogPage.setHPos(this.graph.getGraphModel().getDataAccess().getFirstHPos(2));
                this.viewLogPageNum = 0;
            }
            catch (EdgeOutOfRangeException e) {
                this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareFirstPage");
            }
        } else if (this.rangeType == 0) {
            this.viewLogPage.setHPos(this.currLogPage.getHPos());
            this.viewLogPageNum = 0;
        } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
            this.viewLogPage.setHPos((int[])this.m_selectedHPos.elementAt(this.m_selectedIndex));
            this.viewLogPageNum = 0;
        } else {
            return false;
        }
        this.checkDataSourceLogPage();
        this.fetchAllData();
        if (this.checkForNoData()) {
            return false;
        }
        this.record = new PaginationRecord();
        this.record.pageNum = ++this.pageNum;
        ++this.m_seqPageNumber;
        this.printableWidth = this.paperWidth - (this.leftMargin + this.rightMargin);
        this.calcMargins(g);
        this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        if (this.printableHeight < 20 || this.printableWidth < 20) {
            this.logInsuffMsg("prepareFirstPage");
            this.m_insuffSapce = true;
            return false;
        }
        return true;
    }

    public boolean hasNextPage() {
        if (this.m_insuffSapce) {
            return false;
        }
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "hasNextPage");
            return false;
        }
        try {
            if (this.rangeType == 1 && this.graph.getGraphModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos()) != null) {
                boolean bl = true;
                return bl;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (DataException e) {
            this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "hasNextPage");
        }
        return false;
    }

    public boolean goToNextPage() {
        return this.prepareNextPage(null);
    }

    public boolean prepareNextPage(Graphics g) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "prepareNextPage");
            return false;
        }
        int[] nextHPos = null;
        try {
            if (this.rangeType == 1) {
                nextHPos = this.graph.getGraphModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos());
            } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                nextHPos = (int[])this.m_selectedHPos.elementAt(++this.m_selectedIndex);
            }
        }
        catch (DataException e) {
            this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareNextPage");
        }
        if (nextHPos != null) {
            this.viewLogPage.setHPos(nextHPos);
            ++this.viewLogPageNum;
            try {
                this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
            }
            catch (DataException e) {
                this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "prepareNextPage");
            }
            this.fetchAllData();
            if (this.checkForNoData()) {
                return false;
            }
            ++this.m_seqPageNumber;
            this.record.pageNum = ++this.pageNum;
            this.calcMargins(g);
            this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        }
        return true;
    }

    public boolean hasPrevPage() {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "hasPrevPage");
            return false;
        }
        try {
            if (this.rangeType == 1 && this.graph.getGraphModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos()) != null) {
                boolean bl = true;
                return bl;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (DataException e) {
            this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "hasPrevPage");
        }
        return false;
    }

    public boolean goToPrevPage() {
        return this.preparePrevPage(null);
    }

    public boolean preparePrevPage(Graphics g) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "preparePrevPage");
            return false;
        }
        int[] previous = null;
        try {
            if (this.rangeType == 1) {
                previous = this.graph.getGraphModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos());
            } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                previous = (int[])this.m_selectedHPos.elementAt(--this.m_selectedIndex);
            }
        }
        catch (DataException e) {
            this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "preparePrevPage");
        }
        if (previous != null) {
            try {
                this.viewLogPage.setHPos(previous);
                --this.viewLogPageNum;
                this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
            }
            catch (DataException e) {
                this.graph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "preparePrevPage");
            }
            this.fetchAllData();
            if (this.checkForNoData()) {
                return false;
            }
            this.record.pageNum = --this.pageNum;
            --this.m_seqPageNumber;
            this.calcMargins(g);
            this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        }
        return true;
    }

    public boolean setLogicalPage(int[] hPos) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "setLogicalPage");
            return false;
        }
        super.setLogicalPage(hPos);
        this.fetchAllData();
        return true;
    }

    protected void setDataview(Dataview dv) {
        super.setDataview(dv);
        if (dv instanceof Graph) {
            this.title = (Title)((Graph)this.dataView).getDataviewTitle();
            this.subtitle = (Subtitle)((Graph)this.dataView).getDataviewSubtitle();
            this.footnote = (Footnote)((Graph)this.dataView).getDataviewFootnote();
        }
    }

    protected boolean checkForNoData() {
        return false;
    }

    protected void fetchAllData() {
        try {
            int rowCount = this.graph.getModel().getDataAccess().getEdgeExtent(1);
            if (rowCount > 0) {
                this.fetchRowBlock(0, rowCount - 1);
                this.graph.getPFJ().setLazyDataFetchMessage(null);
                this.graph.setDirty(true);
            }
        }
        catch (EdgeOutOfRangeException eoore) {
            this.graph.getErrorHandler().error((Throwable)eoore, this.getClass().getName(), "fetchAllData");
        }
    }

    protected void resetCurrentLogicalPage() {
        this.fetchAllData();
    }

    private void logInsuffMsg(String method) {
        this.graph.getErrorHandler().log("Insufficient space to print the View", this.getClass().getName(), method);
    }

    private void $init$() {
        this.m_insuffSapce = false;
        this.pageNum = 0;
        this.scaleFont = -1;
        this.m_selectedIndex = 0;
        this.pagingControlBounds = null;
        this.graph = null;
        this.pfj = null;
        this.m_frame = null;
    }
}

