/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Vector;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraphType;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataException;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;

public class GraphUtils {
    public static final int DEFAULT_GROUP = 0;
    public static final int STOCK_GROUP = 1;
    public static final int BUBBLE_GROUP = 2;
    public static final int SCATTER_GROUP = 3;
    public static final int POLAR_GROUP = 4;

    public static int getGraphTypeGroup(int type) {
        int group = 0;
        switch (type) {
            case 65: 
            case 66: {
                group = 4;
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                group = 3;
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                group = 2;
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                group = 1;
                break;
            }
        }
        return group;
    }

    public static void verifyGraphMeasureLayout(CommonGraph graph) throws DataException {
        DataSource dsrc;
        int group = GraphUtils.getGraphTypeGroup(graph.getGraphType());
        if (group != 0 && (dsrc = graph.getDataSource()) instanceof LayoutContext) {
            LayoutAccess access = ((LayoutContext)dsrc).createCubeLayoutAccess();
            DataAccess da = graph.getModel().getDataAccess();
            DataDirector dd = graph.getModel().getDataDirector();
            int groupsEdge = 0;
            if (!graph.isDataRowShownAsASeries()) {
                groupsEdge = 1;
            }
            int measureEdge = access.getMeasureEdge();
            int measureLayer = access.getMeasureLayer();
            if (measureEdge >= 0 && measureLayer >= 0) {
                int groupsLayerCount = da.getLayerCount(groupsEdge);
                if (measureEdge != groupsEdge || measureLayer != groupsLayerCount - 1) {
                    int targetLayer = 0;
                    int flags = 4;
                    if (groupsLayerCount != 0) {
                        flags = 3;
                        targetLayer = groupsLayerCount - 1;
                    }
                    dd.pivot(measureEdge, groupsEdge, measureLayer, targetLayer, flags);
                }
                if (group == 1) {
                    int timeEdge = -1;
                    int timeLayer = -1;
                    int edgeCount = da.getEdgeCount();
                    groupsLayerCount = da.getLayerCount(groupsEdge);
                    int edge = 0;
                    while (edge < edgeCount && timeLayer == -1) {
                        int layerCount = da.getLayerCount(edge);
                        int layer = 0;
                        while (layer < layerCount && timeLayer == -1) {
                            if (access.isSpecialDimension(edge, layer, "time")) {
                                timeEdge = edge;
                                timeLayer = layer;
                            }
                            ++layer;
                        }
                        ++edge;
                    }
                    if (timeLayer != -1 && (timeEdge != groupsEdge || timeLayer != groupsLayerCount - 2)) {
                        dd.pivot(timeEdge, groupsEdge, timeLayer, groupsLayerCount - 1, 2);
                    }
                }
            }
        }
    }

    public static boolean is3DDisabled(GraphTypeConverter converter, UIGraphType graph) {
        Type type = null;
        if (converter != null && graph != null) {
            GraphTypeAndSubtype typeSubtype = converter.getTypeAndSubtype(graph);
            Vector types = converter.getTypes();
            int i = 0;
            while (i < types.size()) {
                type = (Type)types.elementAt(i);
                if (typeSubtype.type == type.id) break;
                ++i;
            }
        }
        if (type == null) {
            return true;
        }
        return (type.supports3D && type.supportsNon3D) ^ true;
    }

    public static boolean isGradientDisabled(int graphType) {
        return graphType == 76 || graphType == 79 || graphType == 12;
    }

    public static boolean is3DDisabled(Graph graph) {
        Type type = GraphUtils.getCurrentType(graph);
        if (type == null) {
            return true;
        }
        return (type.supports3D && type.supportsNon3D) ^ true;
    }

    public static boolean isGradientDisabled(Graph graph) {
        if (graph != null) {
            int graphType = graph.getGraphType();
            return graphType == 76 || graphType == 79 || graphType == 12;
        }
        return true;
    }

    private static Type getCurrentType(Graph graph) {
        if (graph != null) {
            GraphTypeConverter converter = graph.getGraphTypeConverter();
            GraphTypeAndSubtype typeSubtype = converter.getTypeAndSubtype(graph);
            Vector types = converter.getTypes();
            int i = 0;
            while (i < types.size()) {
                Type type = (Type)types.elementAt(i);
                if (typeSubtype.type == type.id) {
                    return type;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isBubbleGraph(int graphType) {
        return graphType >= 89 && graphType <= 92;
    }

    public static boolean isLineGraph(int graphType) {
        return graphType >= 41 && graphType <= 54;
    }

    public static boolean isPieGraph(int graphType) {
        return graphType >= 55 && graphType <= 60 || graphType >= 93 && graphType <= 94;
    }

    public static boolean isPolarGraph(int graphType) {
        return graphType == 65 || graphType == 66;
    }

    public static boolean isRadarGraph(int graphType) {
        return graphType >= 67 && graphType <= 69;
    }

    public static boolean isScatterGraph(int graphType) {
        return graphType >= 61 && graphType <= 64;
    }

    public static boolean isStockGraph(int graphType) {
        return graphType >= 70 && graphType <= 84 || graphType == 88;
    }

    public static boolean isPercentGraph(int graphType) {
        switch (graphType) {
            case 23: 
            case 30: 
            case 35: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    public static boolean is3DGraph(int graphType) {
        return graphType >= 0 && graphType <= 14;
    }

    public static boolean isDotType(int graphType) {
        return GraphUtils.isScatterGraph(graphType) || GraphUtils.isBubbleGraph(graphType) || GraphUtils.isPolarGraph(graphType);
    }

    public static boolean isLegendEnabled(int graphType) {
        return !(GraphUtils.is3DGraph(graphType) && graphType != 12 || graphType == 96 || graphType >= 70 && graphType <= 72) && graphType != 84;
    }

    public static boolean isCandleOrVolume(int graphType) {
        switch (graphType) {
            case 70: 
            case 71: 
            case 72: 
            case 83: 
            case 84: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    public static int getSeriesCount(CommonGraph graph) {
        int seriesCount = 0;
        int graphType = graph.getGraphType();
        if (GraphUtils.isCandleOrVolume(graphType)) {
            seriesCount = 1;
        } else if (graphType == 96) {
            seriesCount = 2;
        } else {
            try {
                seriesCount = graph.isDataRowShownAsASeries() ? graph.getRowCount() : graph.getColumnCount();
                if (seriesCount > graph.getSeriesObjectCount()) {
                    seriesCount = graph.getSeriesObjectCount();
                }
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                // empty catch block
            }
        }
        return seriesCount;
    }

    public static boolean isAllSeriesSupported(int graphType) {
        return graphType != 12 && !GraphUtils.isCandleOrVolume(graphType) && graphType != 96;
    }

    public static boolean isMarkerTypeSupported(int graphType) {
        return graphType == 97 || graphType == 98;
    }

    public static boolean isLineSupported(CommonGraph graph) {
        int graphType = graph.getGraphType();
        return GraphUtils.isLineGraph(graphType) || GraphUtils.isRadarGraph(graphType) || graphType == 97 || graphType == 98 || graphType == 96;
    }

    public static boolean isMarkerShapeSupported(int graphType) {
        return GraphUtils.isLineGraph(graphType) || GraphUtils.isScatterGraph(graphType) || GraphUtils.isPolarGraph(graphType) || GraphUtils.isRadarGraph(graphType) || graphType == 96 || graphType == 97 || graphType == 98;
    }

    public static boolean isFitlineSupported(int graphType) {
        switch (graphType) {
            case 0: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 88: 
            case 93: 
            case 94: 
            case 96: {
                return false;
            }
        }
        return true;
    }

    public static boolean isAssignedToY2Supported(int graphType) {
        return CommonGraph.isDualY(graphType);
    }

    public static boolean isReferenceLineSupported(int graphType) {
        return !GraphUtils.isPieGraph(graphType) && !GraphUtils.is3DGraph(graphType) && !GraphUtils.isStockGraph(graphType);
    }

    public static boolean isDataLabelInTheCenterSupported(int graphType) {
        boolean yesNo = false;
        switch (graphType) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 93: 
            case 94: 
            case 96: {
                yesNo = true;
                break;
            }
            default: {
                yesNo = false;
                break;
            }
        }
        return yesNo;
    }

    public static String getDataLabelString(CommonGraph graph) {
        String str = "";
        switch (graph.getGraphType()) {
            case 0: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 96: {
                str = str + "bars";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                if (graph.isLineDataLineDisplayed()) {
                    str = str + "lines";
                    break;
                }
                str = str + "points";
                break;
            }
            case 6: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                str = str + "areas";
                break;
            }
            case 55: 
            case 57: 
            case 93: {
                str = str + "pie slices";
                break;
            }
            case 56: 
            case 58: 
            case 94: {
                str = str + "ring slices";
                break;
            }
            case 61: 
            case 62: 
            case 65: 
            case 97: 
            case 98: {
                str = str + "markers";
                break;
            }
            case 67: {
                str = str + "lines";
                break;
            }
            case 89: 
            case 91: {
                str = str + "bubbles";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 79: 
            case 83: 
            case 84: 
            case 88: {
                str = str + "stock markers";
                break;
            }
            case 4: {
                str = str + "cubes";
                break;
            }
            case 7: {
                str = str + "ribbons";
                break;
            }
            case 12: {
                str = str + "surface";
                break;
            }
        }
        return str;
    }

    public static boolean isGridlineSupported(int graphType) {
        switch (graphType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 35: 
            case 40: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 93: 
            case 94: {
                return false;
            }
        }
        return true;
    }

    public static boolean isO1AxisSupported(int graphType) {
        return !(graphType >= 55 && graphType <= 66 || graphType >= 85 && graphType <= 87) && (graphType < 89 || graphType > 94);
    }

    public static boolean hasGradient(CommonGraph graph) {
        return graph.getSeriesEffect() == 1 || graph.getSeriesEffect() == 2;
    }

    public static boolean isBarGraph(int graphType) {
        switch (graphType) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 95: {
                return true;
            }
        }
        return false;
    }

    public static boolean isHorizontalBarGraph(int graphType) {
        switch (graphType) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAreaGraph(int graphType) {
        switch (graphType) {
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                return true;
            }
        }
        return false;
    }
}

