/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseMajorTick;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class O1MajorTick
extends BaseMajorTick {
    public O1MajorTick(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO1MajorGrid();
    }

    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getTickStyle() {
        return this.m_pfj.getO1MajorGridStyle();
    }

    public void setTickStyle(int style) {
        if (style < 0 || style > 6) {
            this.m_commonGraph.getErrorHandler().log("invalid style", "oracle.dss.graph.O1MajorTick", "setTickStyle(int style)");
        } else {
            this.m_pfj.setO1MajorGridStyle(style);
        }
    }

    public void setSkippedWithLabels(boolean skipped) {
        this.m_pfj.setIgnoreGridSkip(skipped ^ true);
    }

    public boolean isSkippedWithLabels() {
        return this.m_pfj.getIgnoreGridSkip() ^ true;
    }

    public boolean isVisible() {
        return this.getTickStyle() != 6;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setTickStyle(5);
        } else {
            this.setTickStyle(6);
        }
    }

    protected String getComponentName() {
        return "O1MajorTick";
    }

    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.IgnoreGridSkip);
        if (val != null) {
            node.addProperty("skippedWithLabels", (Boolean)val ^ true);
            nodeExists = true;
        }
        return nodeExists;
    }

    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("skippedWithLabels");
        if (pNode != null) {
            this.setSkippedWithLabels(pNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.setSkippedWithLabels(true);
        super.resetStyle();
    }
}

