/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.HashMap;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.SFX;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ReferenceObject
extends BaseGraphComponent {
    private static final String x1axis = "X1AXIS";
    private static final String y1axis = "Y1AXIS";
    private static final String y2axis = "Y2AXIS";
    private static final String series = "SERIES";
    protected SFX m_sfx;
    protected Object m_value;
    protected int m_display;
    protected String m_elementName;
    protected boolean[] m_legend;
    public static final boolean d_referenceLineVisible = false;
    public static final int d_referenceLineWidth = 1;
    public static final int d_referenceLineStyle = 0;
    public static final double d_referenceLineValue = 0.0;
    public static final boolean d_referenceLineDisplayedInLegend = false;

    public ReferenceObject(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.createReferenceObject();
    }

    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getType() {
        return this.m_pfj.getReferenceObjectType(this.m_identObj);
    }

    public void setType(int type) {
        this.m_pfj.setReferenceObjectType(this.m_identObj, new Integer(type));
    }

    public int getLocation() {
        return this.m_pfj.getReferenceObjectLocation(this.m_identObj);
    }

    public void setLocation(int location) {
        this.m_pfj.setReferenceObjectLocation(this.m_identObj, new Integer(location));
    }

    public int getAssociation() {
        return this.m_pfj.getReferenceAssociation(this.m_identObj);
    }

    public void setAssociation(int component) {
        this.m_pfj.setReferenceAssociation(this.m_identObj, new Integer(component));
    }

    public int getSeries() {
        return this.m_pfj.getReferenceSeries(this.m_identObj);
    }

    public void setSeries(int series) {
        this.m_pfj.setReferenceSeries(this.m_identObj, new Integer(series));
    }

    public Color getColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setColor(Color newColor) {
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setLineWidth(int width) {
        this.m_pfj.setLineWidth(this.m_identObj, width);
    }

    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_identObj);
    }

    public void setLineStyle(int style) {
        if (style < 0 || style > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style)");
            return;
        }
        this.m_pfj.setLineStyle(this.m_identObj, style);
    }

    public String getText() {
        return this.m_pfj.getTextString(this.m_identObj);
    }

    public void setText(String str) {
        this.m_pfj.setTextString(this.m_identObj, str);
    }

    public boolean isDisplayedInLegend() {
        return this.m_pfj.getDisplay(this.m_pfj.getReferenceLegendText(this.m_identObj));
    }

    public void setDisplayedInLegend(boolean visible) {
        this.m_pfj.setDisplay(this.m_pfj.getReferenceLegendText(this.m_identObj), visible);
    }

    public Object getLineValue() {
        return this.m_pfj.getReferenceLineValue(this.m_identObj);
    }

    public void setLineValue(Object value) {
        this.m_pfj.setReferenceLineValue(this.m_identObj, (Double)value);
    }

    public Object getLowValue() {
        return this.m_pfj.getReferenceAreaLowValue(this.m_identObj);
    }

    public void setLowValue(Object value) {
        this.m_pfj.setReferenceAreaLowValue(this.m_identObj, (Double)value);
    }

    public Object getHighValue() {
        return this.m_pfj.getReferenceAreaHighValue(this.m_identObj);
    }

    public void setHighValue(Object value) {
        this.m_pfj.setReferenceAreaHighValue(this.m_identObj, (Double)value);
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public int getID() {
        return this.m_identObj.getMiscID();
    }

    protected String getComponentName() {
        return "ReferenceObject";
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode sfxNode;
        boolean nodeExists = false;
        ObjectNode node = new ObjectNode(this.getComponentName());
        Object val = this.m_pfj.getReferenceAssociation(this.m_identObj);
        if (val != null) {
            node.addProperty("association", this.convertAssociationToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getReferenceSeries(this.m_identObj)) != null) {
            node.addProperty("series", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getReferenceObjectType(this.m_identObj)) != null) {
            node.addProperty("type", this.convertTypeToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getReferenceObjectLocation(this.m_identObj)) != null) {
            node.addProperty("location", this.convertLocationToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextString(this.m_identObj)) != null) {
            node.addProperty("text", (String)val);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getReferenceLineValue(this.m_identObj)) != null || allProperties) {
            node.addProperty("lineValue", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getReferenceAreaLowValue(this.m_identObj)) != null || allProperties) {
            node.addProperty("low", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getReferenceAreaHighValue(this.m_identObj)) != null || allProperties) {
            node.addProperty("high", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getFillColor(this.m_identObj)) != null) {
            node.addProperty("color", ReferenceObject.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLineWidthObj(this.m_identObj)) != null) {
            node.addProperty("lineWidth", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLineStyleObj(this.m_identObj)) != null) {
            node.addProperty("lineStyle", ReferenceObject.convertLineStyleToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_pfj.getReferenceLegendText(this.m_identObj))) != null) {
            node.addProperty("displayedInLegend", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected void setReferenceLineXML(ObjectNode referenceNode) {
        PropertyNode pNode = referenceNode.getProperty("lineWidth");
        if (pNode != null) {
            this.setLineWidth(pNode.getValueAsInteger());
        }
        if ((pNode = referenceNode.getProperty("lineStyle")) != null) {
            this.setLineStyle(ReferenceObject.convertLineStyleToInt(pNode.getValueAsString()));
        }
        if ((pNode = referenceNode.getProperty("text")) != null) {
            this.setText(pNode.getValueAsString());
        }
        if ((pNode = referenceNode.getProperty("value")) != null) {
            this.setLineValue(pNode.getValueAsDouble());
        }
        if ((pNode = referenceNode.getProperty("displayedInLegend")) != null) {
            this.setDisplayedInLegend(pNode.getValueAsBoolean());
        }
        if ((pNode = referenceNode.getProperty("lineColor")) != null) {
            Color c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(ReferenceObject.hexStringToInt(pNode.getValueAsString()), true);
            this.setColor(c);
        }
    }

    public void setXML(ObjectNode referenceNode, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(referenceNode);
        }
        catch (Exception e) {
            this.m_jsfHashMap = null;
        }
    }

    public void setXML(ObjectNode referenceNode) {
        ContainerNode sfx;
        PropertyNode pNode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.m_jsfHashMap != null) {
            this.m_jsfHashMap.put(new Integer(this.m_identObj.getMiscID()), map);
        }
        if ((pNode = referenceNode.getProperty("association")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("association", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setAssociation(ReferenceObject.convertAssociationToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = referenceNode.getProperty("series")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("series", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setSeries(pNode.getValueAsInteger());
            }
        }
        if ((pNode = referenceNode.getProperty("type")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("type", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setType(ReferenceObject.convertTypeToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = referenceNode.getProperty("location")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("location", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setLocation(ReferenceObject.convertLocationToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = referenceNode.getProperty("text")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("text", pNode.getValueAsString());
            } else {
                this.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = referenceNode.getProperty("lineValue")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("lineValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setLineValue(pNode.getValueAsDouble());
            }
        }
        if ((pNode = referenceNode.getProperty("low")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("low", new Double(pNode.getValueAsDouble()));
            } else {
                this.setLowValue(pNode.getValueAsDouble());
            }
        }
        if ((pNode = referenceNode.getProperty("high")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("high", new Double(pNode.getValueAsDouble()));
            } else {
                this.setHighValue(pNode.getValueAsDouble());
            }
        }
        if ((pNode = referenceNode.getProperty("color")) != null) {
            Color c = null;
            c = pNode.getValueAsString().equals("") ? null : new Color(ReferenceObject.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                map.put("color", c);
            } else {
                this.setColor(c);
            }
        }
        if ((pNode = referenceNode.getProperty("lineWidth")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("lineWidth", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setLineWidth(pNode.getValueAsInteger());
            }
        }
        if ((pNode = referenceNode.getProperty("lineStyle")) != null) {
            this.setLineStyle(ReferenceObject.convertLineStyleToInt(pNode.getValueAsString()));
        }
        if ((pNode = referenceNode.getProperty("displayedInLegend")) != null) {
            this.setDisplayedInLegend(pNode.getValueAsBoolean());
        }
        if ((sfx = referenceNode.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, true);
        }
    }

    private String convertTypeToString(int type) {
        if (type == 0) {
            return "RO_LINE";
        }
        return "RO_AREA";
    }

    private String convertLocationToString(int location) {
        if (location == 0) {
            return "RO_FRONT";
        }
        return "RO_BACK";
    }

    private String convertAssociationToString(int association) {
        switch (association) {
            case 41: {
                return x1axis;
            }
            case 46: {
                return y1axis;
            }
            case 51: {
                return y2axis;
            }
            case 31: {
                return series;
            }
        }
        return y1axis;
    }
}

