/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.dataView.BaseComponentXML;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.presutil.GradientSupport;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class SFX
extends BaseComponentXML
implements GradientSupport {
    protected static final int fillType = 1;
    protected static final int gradientDirection = 1;
    protected static final int gradientNumPins = 2;
    protected static final int textureDisplayMode = 0;
    protected static final double position = 0.5;
    protected static final String gradientPinLeftColor = "#ffffff";
    protected static final String gradientPinRightColor = "#ffffff";
    protected static final String a_fillType = "fillType";
    protected static final String a_gradientDirection = "gradientDirection";
    protected static final String a_gradientNumPins = "gradientNumPins";
    protected static final String a_textureDisplayMode = "textureDisplayMode";
    protected static final String a_pinIndex = "pinIndex";
    protected static final String a_gradientPinLeftColor = "gradientPinLeftColor";
    protected static final String a_gradientPinRightColor = "gradientPinRightColor";
    protected static final String a_textureURL = "textureURL";
    protected static final String GRADIENTPINSTYLE_NAME = "GradientPinStyle";
    protected static final String a_gradientStopColor = "gradientStopColor";
    protected static final String a_gradientStopPosition = "gradientStopPosition";
    protected static final String a_gradientNumStops = "gradientNumStops";
    protected static final String a_gradientReversed = "gradientReversed";
    protected static final String GRADIENTSTOPSTYLE_NAME = "GradientStopStyle";
    protected CommonGraph m_commonGraph;
    protected PFJ m_pfj;
    protected IdentObj m_identObj;
    protected IdentObj m_identObj2;
    protected IdentObj m_frameSide;
    protected IdentObj m_frameBottom;
    protected boolean m_isSeries;
    protected boolean m_isPlotArea;
    private boolean m_url;
    private int m_series;
    private Vector m_isDefaultColor;
    private Vector m_isDefaultPosition;
    private boolean m_isCalledFromNumStops;
    private boolean m_isCalledFromFillType;
    private boolean m_depDirection;

    public SFX(CommonGraph graph, IdentObj identObj) {
        this(graph, identObj, null);
    }

    public SFX(CommonGraph graph, IdentObj identObj, IdentObj identObj2) {
        this.$init$();
        this.m_commonGraph = graph;
        this.m_pfj = graph.getPFJ();
        this.m_identObj = identObj;
        this.m_identObj2 = identObj2;
        if (this.m_identObj2 == null) {
            this.m_isSeries = false;
        } else {
            this.m_isSeries = true;
            this.m_series = this.m_identObj.getSeriesID();
        }
        this.m_isDefaultColor = new Vector();
        this.m_isDefaultPosition = new Vector();
        int i = 0;
        while (i < this.getGradientNumStops()) {
            this.m_isDefaultColor.addElement(Boolean.TRUE);
            this.m_isDefaultPosition.addElement(Boolean.TRUE);
            ++i;
        }
        if (this.m_identObj.equals(this.m_pfj.getFrame())) {
            this.m_frameSide = this.m_pfj.getFrameSide();
            this.m_frameBottom = this.m_pfj.getFrameBottom();
            this.m_isPlotArea = true;
        } else {
            this.m_isPlotArea = false;
        }
    }

    public int getFillType() {
        return this.m_pfj.getFillType(this.m_identObj);
    }

    public void setFillType(int type) {
        if (type < 1 || type > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid fill type", this.getClass().getName(), "setFillType(int type)");
        } else {
            if (this.m_pfj.getFillType(this.m_identObj) == type) {
                return;
            }
            this.m_pfj.setFillType(this.m_identObj, type);
            if (this.m_isPlotArea) {
                if (type == 1) {
                    Color newColor = this.m_pfj.getFillColor(this.m_identObj);
                    this.m_pfj.setFillColor(this.m_frameSide, newColor);
                    this.m_pfj.setFillColor(this.m_frameBottom, newColor);
                }
                this.m_pfj.setFillType(this.m_frameSide, type);
                this.m_pfj.setFillType(this.m_frameBottom, type);
            }
            if (this.m_isSeries) {
                this.m_pfj.setFillType(this.m_identObj2, type);
            }
            if (type == 2) {
                this.m_isCalledFromFillType = true;
                this.setGradientNumStops(this.getGradientNumStops());
            }
        }
    }

    public int getGradientDirection() {
        int dir = this.m_pfj.getGradientDirection(this.m_identObj);
        if (!this.isGradientReversed()) {
            return dir;
        }
        return SFX._calcReversedGradientDirection(dir);
    }

    public void setGradientDirection(int dir) {
        if (dir < 1 || dir > 13) {
            this.m_commonGraph.getErrorHandler().log("invalid gradient direction", this.getClass().getName(), "setGradientDirection(int dir)");
            return;
        }
        switch (dir) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                this.m_depDirection = true;
                break;
            }
            default: {
                this.m_depDirection = false;
                break;
            }
        }
        int actualDir = dir;
        if (this.isGradientReversed()) {
            actualDir = SFX._calcReversedGradientDirection(dir);
        }
        this.m_pfj.setGradientDirection(this.m_identObj, actualDir);
        if (this.m_isSeries) {
            this.m_pfj.setGradientDirection(this.m_identObj2, actualDir);
        }
        this.updateFrameWalls();
    }

    public Color getGradientStopColor(int index) {
        return this.m_pfj.getGradientPinRightColor(this.m_identObj, index);
    }

    public void setGradientStopColor(Color newColor, int index) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGradientStopColor( Color newColor, int index )");
            return;
        }
        if (index < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid stop index", this.getClass().getName(), "setGradientStopColor( Color newColor, int index )");
            return;
        }
        if (this.m_pfj.getGradientPinRightColor(this.m_identObj, index).equals(newColor) && this.m_pfj.getGradientPinLeftColor(this.m_identObj, index).equals(newColor)) {
            return;
        }
        int size = this.m_isDefaultColor.size();
        if (size <= index) {
            int i = 0;
            while (i < index - size + 1) {
                this.m_isDefaultColor.addElement(Boolean.TRUE);
                this.m_isDefaultPosition.addElement(Boolean.TRUE);
                ++i;
            }
        }
        this.m_pfj.setGradientPinRightColor(this.m_identObj, newColor, index);
        this.m_pfj.setGradientPinLeftColor(this.m_identObj, newColor, index);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinRightColor(this.m_identObj2, newColor, index);
            this.m_pfj.setGradientPinLeftColor(this.m_identObj2, newColor, index);
        }
        if (!this.m_isCalledFromNumStops) {
            this.m_isDefaultColor.set(index, Boolean.FALSE);
        }
        this.updateFrameWalls();
    }

    public double getGradientStopPosition(int index) {
        return 100.0 * this.m_pfj.getGradientPinPosition(this.m_identObj, index);
    }

    public void setGradientStopPosition(double newPos, int index) {
        if (index < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid stop index", this.getClass().getName(), "setGradientStopPosition(double newPos, int index)");
            return;
        }
        if (newPos < 0.0 || newPos > 100.0) {
            this.m_commonGraph.getErrorHandler().log("invalid stop Position", this.getClass().getName(), "setGradientStopPosition(double newPos, int index)");
            return;
        }
        if (100.0 * this.m_pfj.getGradientPinPosition(this.m_identObj, index) == newPos) {
            return;
        }
        int size = this.m_isDefaultColor.size();
        if (size <= index) {
            int i = 0;
            while (i < index - size + 1) {
                this.m_isDefaultColor.addElement(Boolean.TRUE);
                this.m_isDefaultPosition.addElement(Boolean.TRUE);
                ++i;
            }
        }
        this.m_pfj.setGradientPinPosition(this.m_identObj, newPos /= 100.0, index);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinPosition(this.m_identObj2, newPos, index);
        }
        this.m_isDefaultPosition.set(index, Boolean.FALSE);
    }

    public int getGradientNumStops() {
        return this.m_pfj.getGradientNumPins(this.m_identObj);
    }

    public void setGradientNumStops(int numStops) {
        int size = this.m_isDefaultColor.size();
        if (size < numStops) {
            int i = 0;
            while (i < numStops - size) {
                this.m_isDefaultColor.addElement(Boolean.TRUE);
                this.m_isDefaultPosition.addElement(Boolean.TRUE);
                ++i;
            }
        }
        if (numStops < 2) {
            this.m_commonGraph.getErrorHandler().log("invalid number of stops", this.getClass().getName(), "setGradientNumStops(int numStops)");
            return;
        }
        if (this.m_pfj.getGradientNumPins(this.m_identObj) == numStops) {
            return;
        }
        this.m_pfj.setGradientNumPins(this.m_identObj, numStops);
        if (this.m_isSeries) {
            this.m_pfj.setGradientNumPins(this.m_identObj2, numStops);
        }
        int index = 0;
        while (index < numStops) {
            if (((Boolean)this.m_isDefaultPosition.elementAt(index)).booleanValue()) {
                double position = (double)index / (double)(numStops - 1);
                this.m_pfj.setGradientPinPosition(this.m_identObj, position, index);
                if (this.m_isSeries) {
                    this.m_pfj.setGradientPinPosition(this.m_identObj2, position, index);
                }
            }
            if (((Boolean)this.m_isDefaultColor.elementAt(index)).booleanValue()) {
                this.m_isCalledFromNumStops = true;
                if (index % 2 == 0) {
                    if (this.m_isSeries) {
                        this.setGradientStopColor(this.m_pfj.getFillColor(this.m_pfj.getSeries(this.m_series)), index);
                    } else {
                        this.setGradientStopColor(new Color(-2302756), index);
                    }
                } else {
                    this.setGradientStopColor(Color.white, index);
                }
            }
            ++index;
        }
        this.updateFrameWalls();
        this.m_isCalledFromNumStops = false;
        this.m_isCalledFromFillType = false;
    }

    public void setGradientReversed(boolean reverse) {
        int forwardDir = this.getGradientDirection();
        int reverseDir = SFX._calcReversedGradientDirection(forwardDir);
        int dir = forwardDir;
        if (reverse) {
            dir = reverseDir;
        }
        this.m_pfj.setGradientDirection(this.m_identObj, dir);
        if (this.m_isSeries) {
            this.m_pfj.setGradientDirection(this.m_identObj2, dir);
        }
        this.m_pfj.setGradientReversed(this.m_identObj, reverse);
        this.updateFrameWalls();
    }

    public static int _calcReversedGradientDirection(int dir) {
        switch (dir) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 9: {
                return 9;
            }
        }
        return dir;
    }

    public boolean isGradientReversed() {
        return this.m_pfj.getGradientReversed(this.m_identObj);
    }

    public int getTextureDisplayMode() {
        return this.m_pfj.getTextureDisplayMode(this.m_identObj);
    }

    public void setTextureDisplayMode(int mode) {
        if (mode != 1 && mode != 0) {
            this.m_commonGraph.getErrorHandler().log("invalid texture mode", this.getClass().getName(), "setTextureDisplayMode(int mode)");
        } else {
            this.m_pfj.setTextureDisplayMode(this.m_identObj, mode);
            if (this.m_isSeries) {
                this.m_pfj.setTextureDisplayMode(this.m_identObj2, mode);
            }
        }
    }

    public String getTexture() {
        return this.m_pfj.getTexture(this.m_identObj);
    }

    public String getTextureURL() {
        String str = "";
        if (this.m_url) {
            str = this.m_pfj.getTexture(this.m_identObj);
        }
        return str;
    }

    public void setTextureURL(String url) {
        if (url == null) {
            this.m_commonGraph.getErrorHandler().log("invalid URL", this.getClass().getName(), "setTextureURL");
            return;
        }
        this.m_pfj.setTextureURL(this.m_identObj, url);
        if (this.m_isSeries) {
            this.m_pfj.setTextureURL(this.m_identObj2, url);
        }
        this.m_url = true;
    }

    public void setTextureImage(String imageName, Image image) {
        this.m_pfj.setTextureURL(this.m_identObj, imageName, image);
        if (this.m_isSeries) {
            this.m_pfj.setTextureURL(this.m_identObj2, imageName, image);
        }
        this.m_url = false;
    }

    private void updateFrameWalls() {
        if (!this.m_isPlotArea) {
            return;
        }
        if (this.getFillType() != 2) {
            return;
        }
        this.m_pfj.setFillType(this.m_frameSide, 1);
        this.m_pfj.setFillType(this.m_frameBottom, 1);
        int direction = this.getGradientDirection();
        int stops = this.getGradientNumStops();
        stops = stops == 0 ? 2 : stops;
        int middleStop = stops / 2 + stops % 2;
        Color startColor = this.getGradientStopColor(0);
        Color endColor = this.getGradientStopColor(stops - 1);
        switch (direction) {
            case 1: 
            case 2: {
                this.m_pfj.setFillColor(this.m_frameSide, this._getDarker(startColor));
                this.m_pfj.setFillType(this.m_frameBottom, 2);
                this.m_pfj.setGradientDirection(this.m_frameBottom, direction);
                int i = 0;
                while (i < stops) {
                    this.m_pfj.setGradientNumPins(this.m_frameBottom, stops);
                    this.m_pfj.setGradientPinPosition(this.m_frameBottom, this.getGradientStopPosition(i) / 100.0, i);
                    Color color = this._getBrighter(this.getGradientStopColor(i));
                    this.m_pfj.setGradientPinRightColor(this.m_frameBottom, color, i);
                    this.m_pfj.setGradientPinLeftColor(this.m_frameBottom, color, i);
                    ++i;
                }
                break;
            }
            case 3: 
            case 4: {
                this.m_pfj.setFillType(this.m_frameSide, 2);
                this.m_pfj.setGradientDirection(this.m_frameSide, direction);
                int i = 0;
                while (i < stops) {
                    this.m_pfj.setGradientNumPins(this.m_frameSide, stops);
                    this.m_pfj.setGradientPinPosition(this.m_frameSide, this.getGradientStopPosition(i) / 100.0, i);
                    Color color = this._getDarker(this.getGradientStopColor(i));
                    this.m_pfj.setGradientPinRightColor(this.m_frameSide, color, i);
                    this.m_pfj.setGradientPinLeftColor(this.m_frameSide, color, i);
                    ++i;
                }
                this.m_pfj.setFillColor(this.m_frameBottom, this._getBrighter(endColor));
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: {
                this.m_pfj.setFillColor(this.m_frameBottom, this._getBrighter(endColor));
                this.m_pfj.setFillColor(this.m_frameSide, this._getDarker(this.getGradientStopColor(middleStop)));
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                this.m_pfj.setFillColor(this.m_frameSide, this._getDarker(startColor));
                this.m_pfj.setFillColor(this.m_frameBottom, this._getBrighter(endColor));
                break;
            }
            case 9: {
                this.m_pfj.setFillColor(this.m_frameSide, this._getDarker(endColor));
                this.m_pfj.setFillColor(this.m_frameBottom, this._getBrighter(endColor));
                break;
            }
        }
    }

    protected String getComponentName() {
        return "SFX";
    }

    protected ObjectNode getGradientStopStyleXML(boolean allProperties, int stopIndex) {
        Color col;
        ObjectNode node = new ObjectNode(GRADIENTSTOPSTYLE_NAME);
        boolean nodeExists = false;
        node.addProperty("stopIndex", stopIndex);
        Object val = this.m_pfj.getGradientPinPositionObj(this.m_identObj, stopIndex);
        if (val != null) {
            node.addProperty(a_gradientStopPosition, 100.0 * (Double)val);
            nodeExists = true;
        }
        if ((col = this.m_pfj.getGradientPinRightColor(this.m_identObj, stopIndex)) != null) {
            node.addProperty(a_gradientStopColor, BaseGraphComponent.toHexString(col.getRGB()));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected void resetStyle() {
        this.resetStyle(this.m_identObj);
        if (this.m_isPlotArea) {
            this.resetStyle(this.m_frameSide);
            this.resetStyle(this.m_frameBottom);
            this.m_pfj.setFillColor(this.m_frameSide, Color.white);
            this.m_pfj.setFillColor(this.m_frameBottom, Color.white);
        }
        if (this.m_isSeries) {
            this.resetStyle(this.m_identObj2);
        }
    }

    protected void resetStyle(IdentObj identObj) {
        this.m_pfj.setTextureURL(identObj, "");
        this.m_pfj.setTextureDisplayMode(identObj, 0);
        this.m_pfj.setFillType(identObj, 2);
        this.m_pfj.setGradientDirection(identObj, 1);
        this.m_pfj.setGradientNumPins(identObj, 2);
        this.m_pfj.setGradientReversed(identObj, false);
        this.m_pfj.setGradientPinPosition(identObj, 0.0, 1);
        this.m_pfj.setGradientPinRightColor(identObj, Color.white, 1);
        this.m_pfj.setGradientPinLeftColor(identObj, Color.white, 1);
    }

    protected ContainerNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode node = new ContainerNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.m_pfj.getFillTypeObj(this.m_identObj);
        if (val != null) {
            int tmp = (Integer)val;
            if (tmp == 1) {
                node.addProperty(a_fillType, "FT_COLOR");
            } else if (tmp == 2) {
                node.addProperty(a_fillType, "FT_GRADIENT");
            } else if (tmp == 3) {
                node.addProperty(a_fillType, "FT_TEXTURE");
            }
            nodeExists = true;
        }
        val = this.getTexture();
        if (this.m_url) {
            System.out.println("Texture URL not null");
            node.addProperty(a_textureURL, (String)val);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getGradientDirectionObj(this.m_identObj)) != null) {
            boolean isSet = true;
            int tmp = (Integer)val;
            if (this.isGradientReversed()) {
                tmp = SFX._calcReversedGradientDirection(tmp);
            }
            if (tmp == 1) {
                node.addProperty(a_gradientDirection, "GD_RIGHT");
            } else if (tmp == 3) {
                node.addProperty(a_gradientDirection, "GD_DOWN");
            } else if (tmp == 5) {
                node.addProperty(a_gradientDirection, "GD_DIAGONAL_45");
            } else if (tmp == 9) {
                node.addProperty(a_gradientDirection, "GD_RADIAL");
            } else if (tmp == 7) {
                node.addProperty(a_gradientDirection, "GD_DIAGONAL_135");
            } else if (tmp == 13) {
                node.addProperty(a_gradientDirection, "GD_RADIAL_BOTTOM_RIGHT");
            } else if (tmp == 12) {
                node.addProperty(a_gradientDirection, "GD_RADIAL_BOTTOM_RIGHT");
            } else if (tmp == 11) {
                node.addProperty(a_gradientDirection, "GD_RADIAL_TOP_RIGHT");
            } else if (tmp == 10) {
                node.addProperty(a_gradientDirection, "GD_RADIAL_TOP_LEFT");
            } else {
                isSet = false;
            }
            if (isSet) {
                nodeExists = true;
            }
        }
        if (this.m_depDirection && allOverriddenProperties && val != null) {
            boolean isSet = true;
            int tmp = (Integer)val;
            if (this.isGradientReversed()) {
                tmp = SFX._calcReversedGradientDirection(tmp);
            }
            if (tmp == 2) {
                node.addProperty(a_gradientDirection, "GD_LEFT");
            } else if (tmp == 4) {
                node.addProperty(a_gradientDirection, "GD_UP");
            } else if (tmp == 6) {
                node.addProperty(a_gradientDirection, "GD_UP_LEFT");
            } else if (tmp == 8) {
                node.addProperty(a_gradientDirection, "GD_UP_RIGHT");
            } else {
                isSet = false;
            }
            if (isSet) {
                nodeExists = true;
            }
        }
        if ((val = this.m_pfj.getTextureDisplayModeObj(this.m_identObj)) != null) {
            int tmp = (Integer)val;
            if (tmp == 1) {
                node.addProperty(a_textureDisplayMode, "TDM_STRETCHED");
            } else if (tmp == 0) {
                node.addProperty(a_textureDisplayMode, "TDM_TILED");
            }
            nodeExists = true;
        }
        if ((val = this.m_pfj.getGradientNumPinsObj(this.m_identObj)) != null) {
            node.addProperty(a_gradientNumStops, ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getGradientReversedObj(this.m_identObj)) != null) {
            node.addProperty(a_gradientReversed, ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        int i = 0;
        while (i < this.getGradientNumStops()) {
            ObjectNode subNode = this.getGradientStopStyleXML(allProperties, i);
            if (subNode != null) {
                node.addContainedObject((BaseNode)subNode);
                nodeExists = true;
            }
            ++i;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected void setXML(ContainerNode node, boolean allProperties) {
        PropertyNode pNode = node.getProperty(a_fillType);
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals("FT_COLOR")) {
                this.setFillType(1);
            } else if (tmp.equals("FT_GRADIENT")) {
                this.setFillType(2);
            } else if (tmp.equals("FT_TEXTURE")) {
                this.setFillType(3);
            }
        }
        if ((pNode = node.getProperty(a_textureURL)) != null) {
            this.setTextureURL(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_gradientDirection)) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals("GD_RIGHT")) {
                this.setGradientDirection(1);
            } else if (tmp.equals("GD_LEFT")) {
                this.setGradientDirection(2);
            } else if (tmp.equals("GD_DOWN")) {
                this.setGradientDirection(3);
            } else if (tmp.equals("GD_UP")) {
                this.setGradientDirection(4);
            } else if (tmp.equals("GD_DOWN_LEFT")) {
                this.setGradientDirection(5);
            } else if (tmp.equals("GD_DOWN_RIGHT")) {
                this.setGradientDirection(7);
            } else if (tmp.equals("GD_UP_RIGHT")) {
                this.setGradientDirection(8);
            } else if (tmp.equals("GD_RADIAL_TOP_LEFT")) {
                this.setGradientDirection(10);
            } else if (tmp.equals("GD_RADIAL_BOTTOM_RIGHT")) {
                this.setGradientDirection(12);
            } else if (tmp.equals("GD_RADIAL_BOTTOM_RIGHT")) {
                this.setGradientDirection(13);
            } else if (tmp.equals("GD_RADIAL_TOP_RIGHT")) {
                this.setGradientDirection(11);
            } else if (tmp.equals("GD_RADIAL")) {
                this.setGradientDirection(9);
            } else if (tmp.equals("GD_UP_LEFT")) {
                this.setGradientDirection(6);
            } else if (tmp.equals("GD_DIAGONAL_45")) {
                this.setGradientDirection(5);
            } else if (tmp.equals("GD_DIAGONAL_135")) {
                this.setGradientDirection(7);
            }
        }
        if ((pNode = node.getProperty(a_textureDisplayMode)) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals("TDM_STRETCHED")) {
                this.setTextureDisplayMode(1);
            } else if (tmp.equals("TDM_TILED")) {
                this.setTextureDisplayMode(0);
            }
        }
        if ((pNode = node.getProperty(a_gradientNumStops)) != null) {
            this.setGradientNumStops(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_gradientReversed)) != null) {
            this.setGradientReversed(pNode.getValueAsBoolean());
        }
        Enumeration e = node.getContainedObject();
        while (e.hasMoreElements()) {
            ObjectNode gradientStopStyleNode = (ObjectNode)e.nextElement();
            PropertyNode sNode = gradientStopStyleNode.getProperty("stopIndex");
            if (sNode == null) continue;
            int stopIndex = sNode.getValueAsInteger();
            pNode = gradientStopStyleNode.getProperty(a_gradientStopPosition);
            if (pNode != null) {
                this.setGradientStopPosition(pNode.getValueAsDouble(), stopIndex);
            }
            if ((pNode = gradientStopStyleNode.getProperty(a_gradientStopColor)) == null) continue;
            this.setGradientStopColor(new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true), stopIndex);
        }
    }

    private Color _getBrighter(Color c) {
        double COLOR_FACTOR = 1.25;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(0.25 / COLOR_FACTOR);
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        r = (int)((double)r * COLOR_FACTOR);
        g = (int)((double)g * COLOR_FACTOR);
        b = (int)((double)b * COLOR_FACTOR);
        if (r >= 255 && g >= 255 && b >= 255) {
            return c;
        }
        return new Color(Math.min(r, 255), Math.min(g, 255), Math.min(b, 255));
    }

    private Color _getDarker(Color c) {
        double COLOR_FACTOR = 0.9;
        return new Color(Math.max((int)((double)c.getRed() * COLOR_FACTOR), 0), Math.max((int)((double)c.getGreen() * COLOR_FACTOR), 0), Math.max((int)((double)c.getBlue() * COLOR_FACTOR), 0));
    }

    private void $init$() {
        this.m_frameSide = null;
        this.m_frameBottom = null;
        this.m_url = false;
        this.m_isCalledFromNumStops = false;
        this.m_isCalledFromFillType = false;
        this.m_depDirection = false;
    }
}

