/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Slice
extends BaseDataComponent {
    public Slice(CommonGraph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    public int getLabelPosition() {
        if (this.m_commonGraph.getGraphType() == 100) {
            return this.m_pfj.getFunnelTextDisplay();
        }
        return this.m_pfj.getPieFeelerTextDisplay();
    }

    public void setLabelPosition(int position) {
        if (position < 0 || position > 4) {
            this.m_commonGraph.getErrorHandler().log("invalid label position", "oracle.dss.graph.Slice", "setLabelPosition(int position)");
        } else if (position == 0) {
            this.m_commonGraph.getSliceLabel().setVisible(false);
        } else {
            this.m_pfj.setPieFeelerTextDisplay(position);
        }
    }

    public static String convertLabelPositionToString(int value) {
        String lPosition = "LP_OUTSIDE_WITH_FEELER";
        switch (value) {
            case 1: {
                lPosition = "LP_OUTSIDE_WITH_FEELER";
                break;
            }
            case 2: {
                lPosition = "LP_OUTSIDE_WITHOUT_FEELER";
                break;
            }
            case 3: {
                lPosition = "LP_INSIDE";
                break;
            }
            case 4: {
                lPosition = "LP_OUTSIDE_FEELER_IF_NEEDED";
                break;
            }
        }
        return lPosition;
    }

    public static int convertLabelPositionToInt(String string) {
        if (string.equals("LP_NO_LABELS")) {
            return 0;
        }
        if (string.equals("LP_OUTSIDE_WITH_FEELER")) {
            return 1;
        }
        if (string.equals("LP_OUTSIDE_WITHOUT_FEELER")) {
            return 2;
        }
        if (string.equals("LP_INSIDE")) {
            return 3;
        }
        if (string.equals("LP_OUTSIDE_FEELER_IF_NEEDED")) {
            return 4;
        }
        return -1;
    }

    protected String getComponentName() {
        return "Slice";
    }

    protected void setObjectId(IdentObj id) {
        this.m_identObj = id;
    }

    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.PieFeelerTextDisplay);
        if (val != null) {
            node.addProperty("labelPosition", Slice.convertLabelPositionToString((Integer)val));
            nodeExists = true;
        }
        return nodeExists;
    }

    protected void resetStyle() {
        this.setLabelPosition(0);
    }

    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("labelPosition");
        if (pNode != null) {
            int pos = Slice.convertLabelPositionToInt(pNode.getValueAsString());
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("labelPosition", new Integer(pos));
            } else {
                this.setLabelPosition(pos);
            }
        }
    }
}

