/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphNumberFormatCallback;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SeriesOutOfRangeException;

public class ToolTipTextCallback {
    static final String RETURN = "[R]";
    static final String OBJ_NAME = "[ON]";
    static final String OBJ_DESC = "[OD]";
    static final String OBJ_ID = "[OID]";
    static final String OBJ_INST = "[OIN]";
    static final String SERIES_LBL = "[SL]";
    static final String GROUP_LBL = "[GL]";
    protected boolean m_GraphIsOpenAndClose;
    protected boolean m_AxisLabelTipDisplayed;
    protected boolean m_GraphIsPieBar;
    protected boolean m_GraphIsSingleY;
    protected boolean m_GraphIsStacked;
    protected boolean m_MarkerTipDisplayed;
    protected boolean m_SeriesAreRows;
    protected boolean m_ShowColDimName;
    protected boolean m_ShowRowDimName;
    protected boolean m_ShowGroupLabels;
    protected boolean m_ShowSeriesLabels;
    protected boolean m_CumValTip;
    protected boolean m_PercentTip;
    protected boolean m_TextTip;
    protected boolean m_ValueTip;
    protected int m_ObjectID;
    protected int m_GroupID;
    protected int m_SeriesID;
    protected int m_ColID;
    protected int m_RowID;
    protected int m_MarkerTipType;
    protected int m_TipGroupLabelType;
    protected int m_TipSeriesLabelType;
    protected int m_ValuesPerGroup;
    protected int m_DataValuesPerMarker;
    protected String m_txtCl;
    protected String m_txtHi;
    protected String m_txtLo;
    protected String m_txtOp;
    protected String m_txtVo;
    protected String m_txtX;
    protected String m_txtY;
    protected String m_txtZ;
    protected String m_txtGr;
    protected String m_txtSe;
    protected String m_txtCu;
    protected String m_txtPe;
    protected String m_txtVa;
    protected String m_txtBV;
    protected String m_txtStart;
    protected String m_txtEnd;
    protected String m_txtTarget;
    protected String m_txtActual;
    protected String m_DimNameType;
    protected String m_DimMemberNameType;
    protected boolean m_excelOrDeskTop;
    protected CommonGraph m_commonGraph;
    protected DataAccess m_dataAccess;
    protected GraphFormatManager m_fmtMgr;
    protected GraphNumberFormatCallback m_numFormatCallback;
    protected CustomToolTipCallback m_customToolTipCallback;
    protected ResourceBundle rBundle;
    protected String m_measureDim;
    private static final String m_method_getFormattedValue = "public String getFormattedValue(double dVal, int axis, boolean isPercent, boolean isPieSlice)";

    public ToolTipTextCallback(CommonGraph graph, GraphNumberFormatCallback numFormatCallback) {
        this.$init$();
        this.m_commonGraph = graph;
        this.m_numFormatCallback = numFormatCallback;
        this.m_fmtMgr = this.m_commonGraph.getGraphFormatManager();
        this.m_SeriesAreRows = this.m_commonGraph.isDataRowShownAsASeries();
        this.setGraphType(graph.getGraphType());
        this.updateResourceBundle();
        this.m_txtGr = this.rBundle.getString("af_dvt_graph.LABEL_GROUP");
        this.m_txtSe = this.rBundle.getString("af_dvt_graph.LABEL_SERIES");
        this.m_txtCu = this.rBundle.getString("af_dvt_graph.LABEL_CUMULATIVE");
        this.m_txtPe = this.rBundle.getString("af_dvt_graph.LABEL_PERCENT");
        this.m_txtVa = this.rBundle.getString("af_dvt_graph.LABEL_VALUE");
        this.m_txtOp = this.rBundle.getString("af_dvt_graph.LABEL_OPEN");
        this.m_txtHi = this.rBundle.getString("af_dvt_graph.LABEL_HIGH");
        this.m_txtLo = this.rBundle.getString("af_dvt_graph.LABEL_LOW");
        this.m_txtCl = this.rBundle.getString("af_dvt_graph.LABEL_CLOSE");
        this.m_txtVo = this.rBundle.getString("af_dvt_graph.LABEL_VOLUME");
        this.m_txtX = this.rBundle.getString("af_dvt_graph.LABEL_X");
        this.m_txtY = this.rBundle.getString("af_dvt_graph.LABEL_Y");
        this.m_txtZ = this.rBundle.getString("af_dvt_graph.LABEL_Z");
        this.m_txtBV = this.rBundle.getString("af_dvt_graph.LABEL_BASE_LINE_VALUE");
        this.m_txtStart = this.rBundle.getString("af_dvt_graph.LABEL_START");
        this.m_txtEnd = this.rBundle.getString("af_dvt_graph.LABEL_END");
        this.m_txtTarget = this.rBundle.getString("af_dvt_graph.LABEL_TARGET");
        this.m_txtActual = this.rBundle.getString("af_dvt_graph.LABEL_ACTUAL");
    }

    public void getDataAccess() {
        this.m_dataAccess = this.m_commonGraph.getDataAccess();
    }

    /*
     * Unable to fully structure code
     */
    public String getDynamicToolTip(TDGMouseState aMouseState, boolean UserOrDeveloper) {
        toolTipText = "";
        this.m_ObjectID = aMouseState.getElementObjectID();
        this.m_SeriesID = aMouseState.getElementSeriesID();
        this.m_GroupID = aMouseState.getElementGroupID();
        this.m_excelOrDeskTop = this.m_commonGraph.isExcelOrDeskTop();
        if (this.m_commonGraph.getPFJ().isMixedFreqTimeAxis()) {
            this.m_ValuesPerGroup = 2;
            this.m_DataValuesPerMarker = 2;
        }
        if (this.m_commonGraph.getPFJ().isTimeAxis() && (missingGroups = this.m_commonGraph.getPFJ().getMissingGroups()) != null) {
            k = 0;
            while (k < missingGroups.length) {
                if (this.m_GroupID > missingGroups[k]) {
                    this.m_GroupID -= k + 1;
                    break;
                }
                ++k;
            }
        }
        if (this.m_txtGr == null) {
            this.m_txtGr = this.rBundle.getString("af_dvt_graph.LABEL_GROUP");
        }
        if (this.m_txtSe == null) {
            this.m_txtSe = this.rBundle.getString("af_dvt_graph.LABEL_SERIES");
        }
        if (this.m_txtCu == null) {
            this.m_txtCu = this.rBundle.getString("af_dvt_graph.LABEL_CUMULATIVE");
        }
        if (this.m_txtPe == null) {
            this.m_txtPe = this.rBundle.getString("af_dvt_graph.LABEL_PERCENT");
        }
        if (this.m_txtVa == null) {
            this.m_txtVa = this.rBundle.getString("af_dvt_graph.LABEL_VALUE");
        }
        if (this.m_txtOp == null) {
            this.m_txtOp = this.rBundle.getString("af_dvt_graph.LABEL_OPEN");
        }
        if (this.m_txtHi == null) {
            this.m_txtHi = this.rBundle.getString("af_dvt_graph.LABEL_HIGH");
        }
        if (this.m_txtLo == null) {
            this.m_txtLo = this.rBundle.getString("af_dvt_graph.LABEL_LOW");
        }
        if (this.m_txtCl == null) {
            this.m_txtCl = this.rBundle.getString("af_dvt_graph.LABEL_CLOSE");
        }
        if (this.m_txtVo == null) {
            this.m_txtVo = this.rBundle.getString("af_dvt_graph.LABEL_VOLUME");
        }
        if (this.m_txtX == null) {
            this.m_txtX = this.rBundle.getString("af_dvt_graph.LABEL_X");
        }
        if (this.m_txtY == null) {
            this.m_txtY = this.rBundle.getString("af_dvt_graph.LABEL_Y");
        }
        if (this.m_txtZ == null) {
            this.m_txtZ = this.rBundle.getString("af_dvt_graph.LABEL_Z");
        }
        if (this.m_txtBV == null) {
            this.m_txtBV = this.rBundle.getString("af_dvt_graph.LABEL_BASE_LINE_VALUE");
        }
        if (this.m_txtStart == null) {
            this.m_txtStart = this.rBundle.getString("af_dvt_graph.LABEL_START");
        }
        if (this.m_txtEnd == null) {
            this.m_txtEnd = this.rBundle.getString("af_dvt_graph.LABEL_END");
        }
        if (this.m_txtTarget == null) {
            this.m_txtTarget = this.rBundle.getString("af_dvt_graph.LABEL_TARGET");
        }
        if (this.m_txtActual == null) {
            this.m_txtActual = this.rBundle.getString("af_dvt_graph.LABEL_ACTUAL");
        }
        try {
            if (this.m_SeriesAreRows) {
                this.m_RowID = this.m_SeriesID;
                this.m_ColID = this.m_GroupID * this.m_ValuesPerGroup;
            } else {
                this.m_RowID = this.m_GroupID * this.m_ValuesPerGroup;
                this.m_ColID = this.m_SeriesID;
            }
            block1 : switch (aMouseState.getElementObjectID()) {
                case 259: 
                case 277: 
                case 312: 
                case 313: 
                case 330: 
                case 331: 
                case 334: 
                case 335: 
                case 474: 
                case 602: 
                case 606: 
                case 607: 
                case 608: 
                case 609: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID);
                            }
                            if (this.m_ShowGroupLabels && !this.m_commonGraph.getPFJ().isMixedFreqTimeAxis()) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID);
                            }
                        }
                        if (this.m_ValueTip) {
                            valueLabel = null;
                            switch (this.m_DataValuesPerMarker) {
                                case 1: {
                                    valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (valueLabel != null) {
                                        this.m_txtVa = valueLabel;
                                    }
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtVa, new Object[]{"[YV]"}) + "[R]";
                                    break;
                                }
                                case 2: {
                                    valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (valueLabel != null) {
                                        this.m_txtX = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                        this.m_txtY = valueLabel;
                                    }
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtX, new Object[]{"[XV]"}) + "[R]" + MessageFormat.format(this.m_txtY, new Object[]{"[YV]"}) + "[R]";
                                    break;
                                }
                                case 3: {
                                    valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (valueLabel != null) {
                                        this.m_txtX = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                        this.m_txtY = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) != null) {
                                        this.m_txtZ = valueLabel;
                                    }
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtX, new Object[]{"[XV]"}) + "[R]" + MessageFormat.format(this.m_txtY, new Object[]{"[YV]"}) + "[R]" + MessageFormat.format(this.m_txtZ, new Object[]{"[ZV]"}) + "[R]";
                                    break;
                                }
                            }
                        }
                        if (this.m_GraphIsStacked && this.m_CumValTip) {
                            graphType = this.m_commonGraph.getGraphType();
                            switch (this.m_commonGraph.getGraphType()) {
                                case 23: 
                                case 30: 
                                case 35: 
                                case 40: 
                                case 47: 
                                case 54: {
                                    dCumVal = 0.0;
                                    if (this.m_SeriesAreRows && !this.m_GraphIsPieBar || !this.m_SeriesAreRows && this.m_GraphIsPieBar) {
                                        bY2 = this.isAssignedToY2(this.m_RowID);
                                        i = 0;
                                        while (i <= this.m_RowID) {
                                            if (bY2 == this.isAssignedToY2(i) || this.m_GraphIsSingleY) {
                                                dCumVal += this.getValue(i, this.m_ColID);
                                            }
                                            ++i;
                                        }
                                    } else {
                                        bY2 = this.isAssignedToY2(this.m_ColID);
                                        i = 0;
                                        while (i <= this.m_ColID) {
                                            if (bY2 == this.isAssignedToY2(i) || this.m_GraphIsSingleY) {
                                                dCumVal += this.getValue(this.m_RowID, i);
                                            }
                                            ++i;
                                        }
                                    }
                                    yValue = this.m_GraphIsSingleY != false ? 76 : (bY2 != false ? 77 : 76);
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtCu, new Object[]{this.getFormattedValue(dCumVal, yValue, false, false)});
                                    ** break;
                                }
                                default: {
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtCu, new Object[]{"[CUMSTKV]"});
                                    ** break;
                                }
                            }
                        }
lbl123:
                        // 4 sources

                    } else {
                        var46_12 = null;
                        return var46_12;
                    }
                    if (!this.m_PercentTip) break;
                    switch (this.m_commonGraph.getGraphType()) {
                        case 23: 
                        case 30: 
                        case 35: 
                        case 40: 
                        case 47: 
                        case 54: {
                            columnTotal = 0.0;
                            if (this.m_SeriesAreRows) {
                                i = 0;
                                while (i < this.m_commonGraph.getRowCount()) {
                                    columnTotal += Math.abs(this.getValue(i, this.m_ColID));
                                    ++i;
                                }
                            } else {
                                i = 0;
                                while (i < this.m_commonGraph.getColumnCount()) {
                                    columnTotal += Math.abs(this.getValue(this.m_RowID, i));
                                    ++i;
                                }
                            }
                            percent = Math.abs(this.getValue(this.m_RowID, this.m_ColID)) / columnTotal;
                            yValue = 76;
                            toolTipText = toolTipText + MessageFormat.format(this.m_txtPe, new Object[]{this.getFormattedValue(percent, yValue, true, false)});
                            break block1;
                        }
                    }
                    break;
                }
                case 298: 
                case 299: 
                case 300: 
                case 332: 
                case 333: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID);
                            }
                            if (this.m_ShowGroupLabels && !this.m_GraphIsPieBar) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID);
                            }
                        }
                        if (this.m_ValueTip) {
                            valueLabel = null;
                            valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                            if (valueLabel != null) {
                                this.m_txtVa = valueLabel;
                            }
                            toolTipText = toolTipText + MessageFormat.format(this.m_txtVa, new Object[]{"[YV]"}) + "[R]";
                        }
                        if (this.m_PercentTip) {
                            toolTipText = toolTipText + MessageFormat.format(this.m_txtPe, new Object[]{"[PIEPCTV]%"});
                        }
                        break;
                    }
                    var47_16 = null;
                    return var47_16;
                }
                case 621: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip && this.m_ShowGroupLabels) {
                            toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID);
                        }
                        if (this.m_ValueTip) {
                            valueLabel = null;
                            valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                            if (valueLabel != null) {
                                this.m_txtActual = valueLabel;
                            }
                            if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                this.m_txtTarget = valueLabel;
                            }
                            toolTipText = toolTipText + MessageFormat.format(this.m_txtActual, new Object[]{"[AV]"}) + "[R]" + MessageFormat.format(this.m_txtTarget, new Object[]{"[TV]"});
                        }
                        if (this.m_PercentTip) {
                            toolTipText = toolTipText + MessageFormat.format(this.m_txtPe, new Object[]{"[PIEPCTV]%"});
                        }
                        break;
                    }
                    var48_18 = null;
                    return var48_18;
                }
                case 310: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getRowLabels(this.m_RowID - 1, this.m_ColID) : toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID);
                            }
                            if (this.m_ShowGroupLabels) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID);
                            }
                        }
                        if (this.m_ValueTip) {
                            toolTipText = toolTipText + MessageFormat.format(this.m_txtVo, new Object[]{"[VV]"}) + "[R]";
                        }
                        break;
                    }
                    var49_19 = null;
                    return var49_19;
                }
                case 303: 
                case 306: 
                case 307: 
                case 308: 
                case 319: 
                case 320: {
                    if (this.m_MarkerTipDisplayed) {
                        if (this.m_TextTip) {
                            if (this.m_ShowSeriesLabels) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID);
                            }
                            if (this.m_ShowGroupLabels) {
                                toolTipText = this.m_SeriesAreRows != false ? toolTipText + this.getColumnLabels(this.m_RowID, this.m_ColID) : toolTipText + this.getRowLabels(this.m_RowID, this.m_ColID);
                            }
                        }
                        if (this.m_ValueTip) {
                            valueLabel = null;
                            switch (this.m_DataValuesPerMarker) {
                                case 2: {
                                    if (this.m_GraphIsOpenAndClose) {
                                        valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                        if (valueLabel != null) {
                                            this.m_txtOp = valueLabel;
                                        }
                                        if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                            this.m_txtCl = valueLabel;
                                        }
                                        toolTipText = toolTipText + MessageFormat.format(this.m_txtOp, new Object[]{"[OV]"}) + "[R]" + MessageFormat.format(this.m_txtCl, new Object[]{"[CV]"});
                                        break block1;
                                    }
                                    valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (valueLabel != null) {
                                        this.m_txtHi = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                        this.m_txtLo = valueLabel;
                                    }
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtHi, new Object[]{"[HV]"}) + "[R]" + MessageFormat.format(this.m_txtLo, new Object[]{"[LV]"});
                                    break block1;
                                }
                                case 3: {
                                    valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (valueLabel != null) {
                                        this.m_txtHi = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                        this.m_txtLo = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) != null) {
                                        this.m_txtCl = valueLabel;
                                    }
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtHi, new Object[]{"[HV]"}) + "[R]" + MessageFormat.format(this.m_txtLo, new Object[]{"[LV]"}) + "[R]" + MessageFormat.format(this.m_txtCl, new Object[]{"[CV]"});
                                    break block1;
                                }
                                case 4: {
                                    valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (valueLabel != null) {
                                        this.m_txtOp = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                        this.m_txtHi = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) != null) {
                                        this.m_txtLo = valueLabel;
                                    }
                                    if ((valueLabel = this.getValueLabel(this.m_RowID, this.m_ColID, 3)) != null) {
                                        this.m_txtCl = valueLabel;
                                    }
                                    toolTipText = toolTipText + MessageFormat.format(this.m_txtOp, new Object[]{"[OV]"}) + "[R]" + MessageFormat.format(this.m_txtHi, new Object[]{"[HV]"}) + "[R]" + MessageFormat.format(this.m_txtLo, new Object[]{"[LV]"}) + "[R]" + MessageFormat.format(this.m_txtCl, new Object[]{"[CV]"});
                                    break block1;
                                }
                            }
                        }
                        break;
                    }
                    var50_21 = null;
                    return var50_21;
                }
                case 13: 
                case 14: {
                    if (!this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) break;
                    if (this.m_commonGraph.getGraphType() <= 14) ** GOTO lbl260
                    if (this.m_commonGraph.getGraphType() == 100) {
                        labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                        if (labels != null) {
                            toolTipText = toolTipText + labels.elementAt(this.m_SeriesID);
                        }
                    } else {
                        toolTipText = toolTipText + this.getWrappedText(this.m_commonGraph.getPFJ().getSeriesLabel(this.m_SeriesID));
                        break;
lbl260:
                        // 1 sources

                        labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                        if (labels != null) {
                            toolTipText = toolTipText + labels.elementAt(this.m_SeriesID);
                        }
                    }
                    break;
                }
                case 18: {
                    if (this.m_commonGraph.getPFJ().isLegendLabelsTruncated() && (labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels()) != null) {
                        toolTipText = toolTipText + labels.elementAt(aMouseState.getIdentObj().getMiscID());
                    }
                    break;
                }
                case 73: {
                    if (this.m_commonGraph.getPFJ().isLegendLabelsTruncated() && (labels = this.m_commonGraph.getPFJ().getLegendObj().getMarkersLabels().getLabels()) != null) {
                        toolTipText = toolTipText + labels.elementAt(aMouseState.getIdentObj().getMiscID());
                    }
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (this.m_commonGraph.getPFJ().isAxisTitleTruncated(this.m_ObjectID)) {
                        toolTipText = toolTipText + this.getWrappedText(this.m_commonGraph.getPFJ().getTextString(this.m_ObjectID));
                    }
                    break;
                }
                case 5: {
                    if (this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) {
                        toolTipText = toolTipText + this.getWrappedText(this.m_commonGraph.getPFJ().getTitleString());
                    }
                    break;
                }
                case 4: {
                    if (this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) {
                        toolTipText = toolTipText + this.getWrappedText(this.m_commonGraph.getPFJ().getSubtitleString());
                    }
                    break;
                }
                case 3: {
                    if (this.m_commonGraph.getPFJ().isTitleTruncated(this.m_ObjectID)) {
                        toolTipText = toolTipText + this.getWrappedText(this.m_commonGraph.getPFJ().getFootnoteString());
                    }
                    break;
                }
                case 270: 
                case 280: {
                    if ((this.m_commonGraph.getGraphType() >= 65 && this.m_commonGraph.getGraphType() <= 68 || this.m_commonGraph.getGraphType() == 100) && this.m_commonGraph.getPFJ().isO1LabelsTruncated()) {
                        toolTipText = toolTipText + this.getWrappedText(this.m_commonGraph.getPFJ().getGroupLabel(this.m_GroupID));
                    }
                    break;
                }
                case 356: {
                    annotation = this.m_commonGraph.getAnnotation(this.m_SeriesID, this.m_GroupID, aMouseState.getIdentObj().getMiscID());
                    toolTipText = toolTipText + this.getWrappedText(annotation.getText());
                    break;
                }
                case 390: {
                    index = aMouseState.getIdentObj().getMiscID();
                    alert = this.m_commonGraph.getAlert(index - 1);
                    toolTipText = toolTipText + this.getWrappedText(alert.getText());
                    break;
                }
                case 357: {
                    value = 0.0;
                    label = "";
                    miscID = aMouseState.getIdentObj().getMiscID();
                    r = this.m_commonGraph.getReferenceObject(miscID);
                    if (r != null) {
                        label = this.m_commonGraph.getReferenceObject(miscID).getText();
                        nf = this.m_commonGraph.getLocale() != null ? NumberFormat.getInstance(this.m_commonGraph.getLocale()) : NumberFormat.getInstance();
                        nf.setGroupingUsed(false);
                        if (r.getType() == 0) {
                            value = (Double)r.getLineValue();
                            val = nf.format(value);
                            toolTipText = toolTipText + this.getWrappedText(label + ": " + val);
                            break;
                        }
                        value = (Double)r.getLowValue();
                        val = MessageFormat.format(this.m_txtLo, new Object[]{nf.format(value)}) + "[R]";
                        value = (Double)r.getHighValue();
                        toolTipText = val + MessageFormat.format(this.m_txtHi, new Object[]{nf.format(value)});
                    }
                    break;
                }
                case 503: 
                case 504: {
                    label = "";
                    miscID = aMouseState.getIdentObj().getMiscID();
                    if (this.m_commonGraph.getReferenceObject(miscID) != null && this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) {
                        label = this.m_commonGraph.getReferenceObject(miscID).getText();
                        toolTipText = toolTipText + this.getWrappedText(label);
                    }
                    break;
                }
                case 234: 
                case 235: {
                    if (this.m_commonGraph.getPFJ().isLegendLabelsTruncated()) {
                        label = this.m_commonGraph.getPFJ().getDrillCallback().getDrillUpLabel(14);
                        toolTipText = toolTipText + this.getWrappedText(label);
                    }
                    break;
                }
                case 508: {
                    value = 0.0;
                    switch (this.m_SeriesID) {
                        case 283: {
                            value = this.m_commonGraph.getY1BaseLine().getValue();
                            break;
                        }
                        case 287: {
                            value = this.m_commonGraph.getY2BaseLine().getValue();
                            break;
                        }
                    }
                    toolTipText = toolTipText + this.m_txtBV + value;
                    break;
                }
                case 295: 
                case 622: {
                    if (this.m_commonGraph.getPFJ().isSliceLabelsTruncated()) {
                        toolTipText = toolTipText + this.getWrappedText(aMouseState.getElementText());
                    }
                    break;
                }
                case 511: {
                    if (this.m_SeriesID == 0) {
                        toolTipText = toolTipText + MessageFormat.format(this.m_txtX, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineFixedValueX, 75, false, false)}) + "[R]" + MessageFormat.format(this.m_txtY, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineFixedValueY, 76, false, false)}) + "[R]";
                        break;
                    }
                    toolTipText = toolTipText + MessageFormat.format(this.m_txtX, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineSelectValueX, 75, false, false)}) + "[R]" + MessageFormat.format(this.m_txtY, new Object[]{this.getFormattedValue(this.m_commonGraph.getPFJ().m_lineSelectValueY, 76, false, false)}) + "[R]";
                    break;
                }
                case 513: {
                    if (this.m_commonGraph.getTimeSelector().getMode() == 1) {
                        startDate = this.m_commonGraph.getTimeSelector().getExplicitStart();
                        endDate = this.m_commonGraph.getTimeSelector().getExplicitEnd();
                        startDateFreq = this.calcDateFreq(startDate);
                        endDateFreq = this.calcDateFreq(endDate);
                        dateFreq = startDateFreq;
                        dateFreq = startDateFreq == 6 || endDateFreq == 6 ? 6 : (startDateFreq == 5 || endDateFreq == 5 ? 5 : (startDateFreq == 4 || endDateFreq == 4 ? 4 : (startDateFreq == 2 || endDateFreq == 2 ? 2 : (startDateFreq == 1 || endDateFreq == 1 ? 1 : 0))));
                        toolTipText = toolTipText + MessageFormat.format(this.m_txtStart, new Object[]{this.formatDate(startDate, dateFreq)}) + "[R]" + MessageFormat.format(this.m_txtEnd, new Object[]{this.formatDate(endDate, dateFreq)}) + "[R]";
                    }
                    break;
                }
            }
        }
        catch (EdgeOutOfRangeException e) {
            this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDynamicToolTip");
        }
        if (this.m_customToolTipCallback != null) {
            toolTipText = this.m_customToolTipCallback.getToolTipText(toolTipText, this.m_commonGraph.getGraphComponentHandle(aMouseState));
        }
        return toolTipText;
    }

    public String getFormattedValue(double dVal, int axis, boolean isPercent, boolean isPieSlice) {
        ViewFormat viewFormat = null;
        QDR qdr = null;
        qdr = new DataComponentInfo(this.m_RowID, this.m_ColID).getQDR(this.m_dataAccess, 1);
        if (isPieSlice) {
            viewFormat = this.m_commonGraph.getSliceLabel().getViewFormat();
            return this.m_fmtMgr.formatPieValue(dVal, viewFormat, isPercent, qdr, true);
        }
        viewFormat = this.m_numFormatCallback.getMarkerTextViewFormat(this.m_SeriesID, this.m_GroupID);
        return this.m_fmtMgr.formatDataValue(dVal, viewFormat, axis, this.m_ColID, this.m_RowID, isPercent, qdr, true);
    }

    private String getValueLabel(int row, int col, int offset) {
        block29: {
            if (row < 0 || col < 0) {
                return null;
            }
            DataCallback dcb = (DataCallback)this.m_commonGraph.getDataFilter();
            QDR myQDR = null;
            try {
                int groupEdge = 0;
                if (this.m_ValuesPerGroup > 1) {
                    Object dimensionValue;
                    int slice = 0;
                    if (!this.m_excelOrDeskTop) {
                        if (this.m_SeriesAreRows) {
                            groupEdge = 0;
                            slice = dcb.getDataAccessColumn(col + offset);
                        } else {
                            groupEdge = 1;
                            slice = dcb.getDataAccessRow(row + offset);
                        }
                    } else if (this.m_SeriesAreRows) {
                        groupEdge = 1;
                        slice = dcb.getDataAccessRow(row, col + offset);
                    } else {
                        groupEdge = 0;
                        slice = dcb.getDataAccessColumn(row + offset, col);
                    }
                    int layerCount = this.m_dataAccess.getLayerCount(groupEdge);
                    if (layerCount > 1 && (dimensionValue = this.m_dataAccess.getMemberMetadata(groupEdge, layerCount - 1, slice, this.m_commonGraph.getMemberMetadataLabelType(groupEdge))) != null) {
                        String string = dimensionValue.toString() + ": ";
                        return string;
                    }
                }
                if ((myQDR = this.m_dataAccess.getValueQDR(dcb.getDataAccessRow(row, col), dcb.getDataAccessColumn(row, col), 1)) != null) {
                    this.m_measureDim = myQDR.getMeasureDim();
                    int edge = 0;
                    while (edge < this.m_dataAccess.getEdgeCount()) {
                        int slice = -1;
                        if (edge == 2) {
                            slice = this.m_dataAccess.getEdgeCurrentSlice(edge);
                        } else if (edge == 0) {
                            if (this.m_excelOrDeskTop) {
                                slice = row + offset;
                                slice = dcb.getDataAccessColumn(slice, col);
                            } else {
                                slice = col + offset;
                                slice = dcb.getDataAccessColumn(row, slice);
                            }
                        } else if (this.m_excelOrDeskTop) {
                            slice = col + offset;
                            slice = dcb.getDataAccessRow(row, slice);
                        } else {
                            slice = row + offset;
                            slice = dcb.getDataAccessRow(slice, col);
                        }
                        int layer = 0;
                        while (layer < this.m_dataAccess.getLayerCount(edge)) {
                            String layerName = null;
                            Object obj = null;
                            try {
                                obj = this.m_dataAccess.getLayerMetadata(edge, layer, "dimName");
                                if (obj != null) {
                                    layerName = obj.toString();
                                }
                            }
                            catch (LayerOutOfRangeException e) {
                                layerName = null;
                            }
                            if (layerName != null && layerName.equals(this.m_measureDim)) {
                                Object dimensionValue = this.m_dataAccess.getMemberMetadata(edge, layer, slice, this.m_commonGraph.getMemberMetadataLabelType(edge));
                                if (dimensionValue != null) {
                                    if (this.m_commonGraph.getPFJ().isMixedFreqTimeAxis() && offset == 0) {
                                        int dateEdge = this.m_SeriesAreRows ? 0 : 1;
                                        String label = (String)this.m_dataAccess.getLayerMetadata(dateEdge, 0, "dimLongName");
                                        String string = label + ": ";
                                        return string;
                                    }
                                    String string = dimensionValue.toString() + ": ";
                                    return string;
                                }
                                String string = null;
                                return string;
                            }
                            int depth = this.m_dataAccess.getMemberDepth(edge, layer, slice);
                            if (depth > 1) {
                                layer += depth - 1;
                            }
                            ++layer;
                        }
                        ++edge;
                    }
                    break block29;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
        }
        return null;
    }

    public Object getColumnLabels(int row, int col) {
        return this.getWrappedText(this.getLabels(row, col, 0, this.m_ShowColDimName, this.m_SeriesAreRows));
    }

    public Object getRowLabels(int row, int col) {
        return this.getWrappedText(this.getLabels(row, col, 1, this.m_ShowRowDimName, this.m_SeriesAreRows ^ true));
    }

    protected Object getLabels(int row, int col, int edge, boolean showDimName, boolean series) {
        String layerLabelType;
        int modelEdge = edge;
        DataCallback dcb = (DataCallback)this.m_commonGraph.getDataFilter();
        if (this.m_excelOrDeskTop) {
            int n = modelEdge = edge == 0 ? 1 : 0;
        }
        if (!this.m_commonGraph.isLayerMetadataLabelTypeSupported(layerLabelType = this.m_commonGraph.getLayerMetadataLabelType(modelEdge)) || col < 0 || row < 0) {
            return this.getDefaultLabels(row, col, edge, showDimName, series);
        }
        boolean timeAxis = false;
        if ((this.m_commonGraph.getPFJ().isTimeAxis() || this.m_commonGraph.getPFJ().isIrregularTimeAxis()) && (edge == 0 && this.m_SeriesAreRows || edge == 1 && !this.m_SeriesAreRows)) {
            timeAxis = true;
        }
        String label = "";
        Vector<QDR> myQDRs = new Vector<QDR>();
        int max = edge == 0 && series || edge == 1 && series ? this.m_DataValuesPerMarker : 1;
        boolean isColumn = edge == 0;
        int i = 0;
        while (i < max) {
            try {
                int cr = 0;
                cr = isColumn ? (this.m_excelOrDeskTop ? dcb.getDataAccessRow(row, col + i) : dcb.getDataAccessColumn(row, col + i)) : (this.m_excelOrDeskTop ? dcb.getDataAccessColumn(row + i, col) : dcb.getDataAccessRow(row + i, col));
                QDR edgeQDR = this.m_dataAccess.getSliceQDR(modelEdge, cr, 1);
                if (edgeQDR != null) {
                    myQDRs.addElement(edgeQDR);
                }
            }
            catch (Exception e) {
                this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getLabels");
            }
            ++i;
        }
        this.m_measureDim = "";
        if (this.m_ValuesPerGroup > 1) {
            int slice = 0;
            try {
                Object obj;
                int groupEdge;
                if (!this.m_excelOrDeskTop) {
                    if (this.m_SeriesAreRows) {
                        groupEdge = 0;
                        slice = dcb.getDataAccessColumn(row, col);
                    } else {
                        groupEdge = 1;
                        slice = dcb.getDataAccessRow(row, col);
                    }
                } else if (this.m_SeriesAreRows) {
                    groupEdge = 1;
                    slice = dcb.getDataAccessRow(row, col);
                } else {
                    groupEdge = 0;
                    slice = dcb.getDataAccessColumn(row, col);
                }
                int layerCount = this.m_dataAccess.getLayerCount(groupEdge);
                if (layerCount > 1 && (obj = this.m_dataAccess.getLayerMetadata(groupEdge, layerCount - 1, "dimName")) != null) {
                    this.m_measureDim = obj.toString();
                }
            }
            catch (Exception e) {
                this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getLabels");
            }
        }
        if (this.m_measureDim.equals("")) {
            if (this.m_excelOrDeskTop) {
                this.getDefaultLabels(row, col, edge, showDimName, series);
            }
            if (myQDRs.size() == 0) {
                return this.getDefaultLabels(row, col, edge, showDimName, series);
            }
            this.m_measureDim = ((QDR)myQDRs.elementAt(0)).getMeasureDim();
        }
        if (this.m_measureDim.equals("")) {
            return this.getDefaultLabels(row, col, edge, showDimName, series);
        }
        Vector QDRDimValuePairs = new Vector(myQDRs.size());
        int i2 = 0;
        while (i2 < myQDRs.size()) {
            Enumeration dimensionIDs = ((QDR)myQDRs.elementAt(i2)).getDimensions();
            Vector<DimValuePairs> singleQDRDimValuePairs = new Vector<DimValuePairs>();
            while (dimensionIDs.hasMoreElements()) {
                String dim = (String)dimensionIDs.nextElement();
                if (dim == null || dim.equals(this.m_measureDim)) continue;
                try {
                    int layer = 0;
                    while (layer < this.m_dataAccess.getLayerCount(modelEdge)) {
                        int depth;
                        String layerName = null;
                        String dimensionValue = null;
                        Object obj = null;
                        try {
                            obj = this.m_dataAccess.getLayerMetadata(modelEdge, layer, "dimName");
                            if (obj != null) {
                                layerName = obj.toString();
                            }
                        }
                        catch (LayerOutOfRangeException e) {
                            layerName = null;
                        }
                        int cr1 = 0;
                        cr1 = isColumn ? (this.m_excelOrDeskTop ? dcb.getDataAccessRow(row, col + i2) : dcb.getDataAccessColumn(row, col)) : (this.m_excelOrDeskTop ? dcb.getDataAccessColumn(row + i2, col) : dcb.getDataAccessRow(row, col));
                        if (layerName != null && layerName.equals(dim)) {
                            if (timeAxis && this.m_dataAccess.getLayerCount(modelEdge) == 2) {
                                obj = null;
                                if (this.m_commonGraph.isMetadataDateSupported() && layer == 0) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, "date");
                                }
                                if (obj == null) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, "value");
                                }
                                if (obj != null) {
                                    obj = this.convertDateToString(obj);
                                }
                            } else if (timeAxis) {
                                obj = null;
                                if (this.m_commonGraph.isMetadataDateSupported()) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, "date");
                                }
                                if (obj == null) {
                                    obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, "value");
                                }
                                if (obj != null) {
                                    obj = this.convertDateToString(obj);
                                }
                            } else {
                                obj = this.m_dataAccess.getMemberMetadata(modelEdge, layer, cr1, this.m_commonGraph.getMemberMetadataLabelType(edge));
                            }
                            if (obj != null) {
                                dimensionValue = obj.toString();
                            }
                            if (dimensionValue != null) {
                                obj = this.m_dataAccess.getLayerMetadata(modelEdge, layer, layerLabelType);
                                String layerLongName = null;
                                if (obj != null) {
                                    layerLongName = obj.toString();
                                }
                                singleQDRDimValuePairs.addElement(new DimValuePairs(layerLongName, dimensionValue));
                            }
                        }
                        if ((depth = this.m_dataAccess.getMemberDepth(modelEdge, layer, cr1)) > 1) {
                            layer += depth - 1;
                        }
                        ++layer;
                    }
                }
                catch (Exception e) {
                    this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getLabels");
                    this.getDefaultLabels(row, col, edge, showDimName, series);
                }
            }
            QDRDimValuePairs.addElement(singleQDRDimValuePairs);
            ++i2;
        }
        Vector commonDimValuePairs = this.getCommonDimensionsWithNoDuplicats(QDRDimValuePairs);
        int i3 = 0;
        while (i3 < commonDimValuePairs.size()) {
            if (commonDimValuePairs.elementAt(i3) != null) {
                label = label + ((DimValuePairs)commonDimValuePairs.elementAt((int)i3)).dim + ": " + ((DimValuePairs)commonDimValuePairs.elementAt((int)i3)).value + RETURN;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < QDRDimValuePairs.size()) {
            Vector singleQDRDimValuePairs = (Vector)QDRDimValuePairs.elementAt(i4);
            int j = 0;
            while (j < singleQDRDimValuePairs.size()) {
                if (!this.hasSameValues(commonDimValuePairs, (DimValuePairs)singleQDRDimValuePairs.elementAt(j))) {
                    label = label + ((DimValuePairs)singleQDRDimValuePairs.elementAt((int)j)).dim + ": " + ((DimValuePairs)singleQDRDimValuePairs.elementAt((int)j)).value + RETURN;
                }
                ++j;
            }
            ++i4;
        }
        return label.trim() + RETURN;
    }

    private boolean hasSameValues(Vector commonDimValuePairs, DimValuePairs dvp) {
        int i = 0;
        while (i < commonDimValuePairs.size()) {
            if (commonDimValuePairs.elementAt(i) != null && dvp.equals((DimValuePairs)commonDimValuePairs.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Vector getCommonDimensionsWithNoDuplicats(Vector QDRDimValuePairs) {
        Object a = QDRDimValuePairs.elementAt(0);
        Vector v = (Vector)a;
        Vector commonDims = (Vector)v.clone();
        int i = 0;
        while (i < commonDims.size()) {
            String testDimName = ((DimValuePairs)commonDims.elementAt((int)i)).dim;
            String testValueName = ((DimValuePairs)commonDims.elementAt((int)i)).value;
            int qdr = 1;
            while (qdr < QDRDimValuePairs.size()) {
                Vector curQDRDimValuePairs = (Vector)QDRDimValuePairs.elementAt(qdr);
                boolean hasDimFlag = false;
                int dim = 0;
                while (dim < curQDRDimValuePairs.size()) {
                    if (testDimName.equals(((DimValuePairs)curQDRDimValuePairs.elementAt((int)dim)).dim)) {
                        hasDimFlag = true;
                        String val = ((DimValuePairs)curQDRDimValuePairs.elementAt((int)dim)).value;
                        if (!testValueName.equals(val)) {
                            commonDims.setElementAt(null, i);
                        }
                    }
                    ++dim;
                }
                if (!hasDimFlag) {
                    commonDims.setElementAt(null, i);
                }
                ++qdr;
            }
            ++i;
        }
        return commonDims;
    }

    protected Object getDefaultLabels(int row, int col, int edge, boolean showDimName, boolean series) {
        this.m_DimNameType = this.m_commonGraph.getLayerMetadataLabelType(edge);
        this.m_DimMemberNameType = this.m_commonGraph.getMemberMetadataLabelType(edge);
        DataCallback dcb = (DataCallback)this.m_commonGraph.getDataFilter();
        int cr = 0;
        cr = edge == 0 ? dcb.getDataAccessColumn(row, col) : dcb.getDataAccessRow(row, col);
        String label = "";
        int dims = 0;
        try {
            dims = this.m_dataAccess.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            this.m_commonGraph.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDefaultLabels");
        }
        boolean timeAxis = false;
        if ((this.m_commonGraph.getPFJ().isTimeAxis() || this.m_commonGraph.getPFJ().isIrregularTimeAxis()) && (edge == 0 && this.m_SeriesAreRows || edge == 1 && !this.m_SeriesAreRows)) {
            timeAxis = true;
        }
        if (this.m_commonGraph.isLayerMetadataLabelTypeSupported(this.m_DimNameType) || this.m_commonGraph.isMemberMetadataLabelTypeSupported(this.m_DimMemberNameType)) {
            try {
                Object obj = null;
                Object str = null;
                int i = 0;
                while (i < dims) {
                    if (showDimName) {
                        label = this.m_commonGraph.isLayerMetadataLabelTypeSupported(this.m_DimNameType) ? ((obj = this.m_dataAccess.getLayerMetadata(edge, i, this.m_DimNameType)) != null ? label + obj.toString() + ":" : label + ":") : label + ":";
                    }
                    if (this.m_commonGraph.isMemberMetadataLabelTypeSupported(this.m_DimMemberNameType)) {
                        if (timeAxis && dims == 2) {
                            obj = null;
                            if (this.m_commonGraph.isMetadataDateSupported() && i == 0 && (obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, "date")) == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, "value");
                            }
                            if (obj == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, this.m_DimMemberNameType);
                            }
                            if (obj != null) {
                                obj = this.convertDateToString(obj);
                            }
                        } else if (timeAxis) {
                            obj = null;
                            if (this.m_commonGraph.isMetadataDateSupported()) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, "date");
                            }
                            if (obj == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, "value");
                            }
                            if (obj == null) {
                                obj = this.m_dataAccess.getMemberMetadata(edge, i, cr, this.m_DimMemberNameType);
                            }
                            if (obj != null) {
                                obj = this.convertDateToString(obj);
                            }
                        } else {
                            obj = this.m_excelOrDeskTop ? (this.m_SeriesAreRows ? (edge == 1 ? dcb.rowLabel(row) : dcb.columnLabel(this.m_GroupID)) : (edge == 1 ? dcb.rowLabel(this.m_GroupID) : dcb.columnLabel(col))) : this.m_dataAccess.getMemberMetadata(edge, i, cr, this.m_DimMemberNameType);
                        }
                        label = obj != null ? label + obj.toString() + " " : label + " ";
                    } else {
                        label = label + " ";
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (showDimName) {
            return label.trim() + RETURN;
        }
        if (series) {
            return MessageFormat.format(this.m_txtGr, label.trim()) + RETURN;
        }
        return MessageFormat.format(this.m_txtSe, label.trim()) + RETURN;
    }

    public double getValue(int row, int col) {
        Object value = ((DataCallback)this.m_commonGraph.getDataFilter()).getValue(row, col);
        if (value != null && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    public boolean isAssignedToY2(int seriesID) {
        boolean bY2 = false;
        try {
            bY2 = this.m_commonGraph.getSeries().isAssignedToY2(seriesID);
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return bY2;
    }

    public void updateResourceBundle() {
        this.rBundle = this.m_commonGraph != null ? ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle", this.m_commonGraph.getLocale()) : ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle");
        this.m_txtGr = null;
        this.m_txtSe = null;
        this.m_txtCu = null;
        this.m_txtPe = null;
        this.m_txtVa = null;
        this.m_txtOp = null;
        this.m_txtHi = null;
        this.m_txtLo = null;
        this.m_txtCl = null;
        this.m_txtVo = null;
        this.m_txtX = null;
        this.m_txtY = null;
        this.m_txtZ = null;
        this.m_txtBV = null;
        this.m_txtStart = null;
        this.m_txtEnd = null;
        this.m_txtTarget = null;
        this.m_txtActual = null;
    }

    public void setAxisLabelTipDisplayed(boolean yesNo) {
        this.m_AxisLabelTipDisplayed = yesNo;
    }

    public void setDataRowShownAsASeries(boolean yesNo) {
        if (this.m_SeriesAreRows != yesNo) {
            boolean temp = this.m_ShowColDimName;
            this.m_ShowColDimName = this.m_ShowRowDimName;
            this.m_ShowRowDimName = temp;
            this.m_SeriesAreRows = yesNo;
        }
    }

    public void setGraphFormatManager(GraphFormatManager m) {
        this.m_fmtMgr = m;
    }

    public void setGraphType(int type) {
        this.m_GraphIsPieBar = false;
        this.m_GraphIsSingleY = true;
        switch (type) {
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 46: 
            case 51: 
            case 53: 
            case 98: {
                this.m_GraphIsSingleY = false;
            }
            case 18: 
            case 23: 
            case 25: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 47: 
            case 49: 
            case 54: 
            case 95: 
            case 96: 
            case 97: {
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 93: 
            case 94: {
                this.m_GraphIsPieBar = true;
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 33: 
            case 38: 
            case 43: 
            case 45: 
            case 50: 
            case 52: 
            case 69: {
                this.m_GraphIsSingleY = false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 48: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 87: 
            case 100: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 62: 
            case 66: 
            case 74: 
            case 75: {
                this.m_GraphIsSingleY = false;
            }
            case 61: 
            case 65: 
            case 73: 
            case 99: {
                this.m_GraphIsOpenAndClose = false;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 2;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 72: {
                this.m_GraphIsOpenAndClose = true;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 2;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 64: {
                this.m_GraphIsSingleY = false;
            }
            case 63: 
            case 82: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 84: {
                this.m_GraphIsOpenAndClose = true;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 77: 
            case 78: 
            case 91: {
                this.m_GraphIsSingleY = false;
            }
            case 76: 
            case 89: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 3;
                break;
            }
            case 92: {
                this.m_GraphIsSingleY = false;
            }
            case 88: 
            case 90: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 4;
                this.m_DataValuesPerMarker = 3;
                break;
            }
            case 80: 
            case 81: {
                this.m_GraphIsSingleY = false;
            }
            case 70: 
            case 79: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 4;
                this.m_DataValuesPerMarker = 4;
                break;
            }
            case 71: 
            case 83: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 5;
                this.m_DataValuesPerMarker = 4;
                break;
            }
            default: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 0;
                this.m_DataValuesPerMarker = 0;
                this.m_commonGraph.getErrorHandler().log("invalid graph type", "oracle.dss.graph.ToolTipTextCallback", "setGraphType(int type)");
                break;
            }
        }
    }

    public int getGroupTooltipLabelType() {
        return this.m_TipGroupLabelType;
    }

    public void setGroupTooltipLabelType(int type) {
        if (type < 0 || type > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid tooltip type", "oracle.dss.graph.ToolTipTextCallback", "setGroupTooltipLabelType (int type)");
            return;
        }
        this.m_TipGroupLabelType = type;
        this.m_ShowGroupLabels = type != 0;
        if (this.m_SeriesAreRows) {
            this.m_ShowColDimName = type == 2;
        } else {
            this.m_ShowRowDimName = type == 2;
        }
    }

    public int getMarkerTooltipType() {
        return this.m_MarkerTipType;
    }

    public void setMarkerTooltipType(int type) {
        if (type < 0 || type >= 16) {
            this.m_commonGraph.getErrorHandler().log("invalid tool tip type", "oracle.dss.graph.ToolTipTextCallback", "setMarkerTooltipType(int type)");
            return;
        }
        this.m_MarkerTipType = type;
        this.m_MarkerTipDisplayed = type != 0;
        this.m_TextTip = (type & 8) == 8;
        this.m_ValueTip = (type & 1) == 1;
        this.m_CumValTip = (type & 2) == 2;
        this.m_PercentTip = (type & 4) == 4;
    }

    public int getSeriesTooltipLabelType() {
        return this.m_TipSeriesLabelType;
    }

    public void setSeriesTooltipLabelType(int type) {
        if (type < 0 || type > 2) {
            this.m_commonGraph.getErrorHandler().log("invalid tooltip type", "oracle.dss.graph.ToolTipTextCallback", "setSeriesTooltipLabelType (int type)");
            return;
        }
        this.m_TipSeriesLabelType = type;
        this.m_ShowSeriesLabels = type != 0;
        if (this.m_SeriesAreRows) {
            this.m_ShowRowDimName = type == 2;
        } else {
            this.m_ShowColDimName = type == 2;
        }
    }

    protected int calcDateFreq(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(this.m_commonGraph.getLocale());
        calendar.setTime(date);
        int dateFreq = -1;
        dateFreq = calendar.get(14) > 0 ? 6 : (calendar.get(13) > 0 ? 6 : (calendar.get(12) > 0 ? 5 : (calendar.get(11) > 0 ? 4 : (calendar.get(5) > 1 ? 2 : (calendar.get(2) > 0 ? 1 : 0)))));
        return dateFreq;
    }

    public String convertDateToString(Object obj) {
        Date date = (Date)obj;
        PFJ pfj = this.m_commonGraph.getPFJ();
        int dateFreq = pfj.getDateFrequency();
        return this.formatDate(date, dateFreq);
    }

    protected String formatDate(Date date, int dateFreq) {
        String yearFormat;
        String monthFormat;
        Perspective pfj = this.m_commonGraph.getPFJ();
        String dmyOrder = pfj.getDMYOrder(pfj.getLocale());
        if (pfj.isContinuousTimeAxis()) {
            if (dateFreq == 0) {
                dateFreq = 1;
            } else if (dateFreq == 1) {
                dateFreq = 2;
            } else if (dateFreq == 2) {
                dateFreq = 4;
            } else if (dateFreq == 4) {
                dateFreq = 5;
            } else if (dateFreq == 5) {
                dateFreq = 6;
            }
        }
        if (dateFreq == 0) {
            String yearFormat2 = this.m_commonGraph.getTimeAxisDateFormat(0);
            if (yearFormat2.equals("AUTO") || yearFormat2.equals("NONE")) {
                yearFormat2 = "YYYY";
            }
            return pfj.formatDate(date, 0, yearFormat2);
        }
        if (dateFreq == 1) {
            String monthFormat2 = this.m_commonGraph.getTimeAxisDateFormat(1);
            if (monthFormat2.equals("AUTO") || monthFormat2.equals("NONE")) {
                monthFormat2 = "Month";
            }
            String str = pfj.formatDate(date, 1, monthFormat2);
            String yearFormat3 = this.m_commonGraph.getTimeAxisDateFormat(0);
            if (yearFormat3.equals("NONE")) {
                yearFormat3 = null;
            } else if (yearFormat3.equals("AUTO")) {
                yearFormat3 = "YYYY";
            }
            if (yearFormat3 != null) {
                str = pfj.isYearLast(dmyOrder) ? str + " " + pfj.formatDate(date, 0, yearFormat3) : pfj.formatDate(date, 0, yearFormat3) + " " + str;
            }
            return str;
        }
        if (dateFreq == 7) {
            String quarterFormat = this.m_commonGraph.getTimeAxisDateFormat(4);
            if (quarterFormat.equals("AUTO") || quarterFormat.equals("NONE")) {
                quarterFormat = "Q";
            }
            return pfj.formatDate(date, 4, quarterFormat);
        }
        if (dateFreq == 2 || dateFreq == 3) {
            String yearFormat4;
            String dayFormat = this.m_commonGraph.getTimeAxisDateFormat(2);
            if (dayFormat.equals("AUTO") || dayFormat.equals("NONE")) {
                dayFormat = "DD";
            }
            String str = pfj.formatDate(date, 2, dayFormat);
            String monthFormat3 = this.m_commonGraph.getTimeAxisDateFormat(1);
            if (monthFormat3.equals("NONE")) {
                monthFormat3 = null;
            } else if (monthFormat3.equals("AUTO")) {
                monthFormat3 = "Month";
            }
            if (monthFormat3 != null) {
                str = pfj.isDayMonth(dmyOrder) ? str + " " + pfj.formatDate(date, 1, monthFormat3) : pfj.formatDate(date, 1, monthFormat3) + " " + str;
            }
            if ((yearFormat4 = this.m_commonGraph.getTimeAxisDateFormat(0)).equals("NONE")) {
                yearFormat4 = null;
            } else if (yearFormat4.equals("AUTO")) {
                yearFormat4 = "YYYY";
            }
            if (yearFormat4 != null) {
                str = pfj.isYearLast(dmyOrder) ? str + " " + pfj.formatDate(date, 0, yearFormat4) : pfj.formatDate(date, 0, yearFormat4) + " " + str;
            }
            return str;
        }
        Date testDate = new Date(1030155120000L);
        DateFormat format = DateFormat.getTimeInstance(3, this.m_commonGraph.getLocale());
        String testStr = format.format(testDate);
        boolean ampm = true;
        if (testStr.indexOf(" ") == -1) {
            ampm = false;
        }
        String str = "";
        String dayFormat = this.m_commonGraph.getTimeAxisDateFormat(2);
        if (dayFormat.equals("NONE")) {
            dayFormat = null;
        } else if (dayFormat.equals("AUTO")) {
            dayFormat = "DD";
        }
        if (dayFormat != null) {
            str = pfj.formatDate(date, 2, dayFormat);
        }
        if ((monthFormat = this.m_commonGraph.getTimeAxisDateFormat(1)).equals("NONE")) {
            monthFormat = null;
        } else if (monthFormat.equals("AUTO")) {
            monthFormat = "Month";
        }
        if (monthFormat != null) {
            str = pfj.isDayMonth(dmyOrder) ? str + " " + pfj.formatDate(date, 1, monthFormat) : pfj.formatDate(date, 1, monthFormat) + " " + str;
        }
        if ((yearFormat = this.m_commonGraph.getTimeAxisDateFormat(0)).equals("NONE")) {
            yearFormat = null;
        } else if (yearFormat.equals("AUTO")) {
            yearFormat = "YYYY";
        }
        if (yearFormat != null) {
            str = pfj.isYearLast(dmyOrder) ? str + " " + pfj.formatDate(date, 0, yearFormat) : pfj.formatDate(date, 0, yearFormat) + " " + str;
        }
        boolean bAutoTime = false;
        String timeFormat = this.m_commonGraph.getTimeAxisDateFormat(3);
        if (dateFreq == 4) {
            if (timeFormat.equals("AUTO") || timeFormat.equals("NONE")) {
                bAutoTime = true;
                timeFormat = ampm ? "HH:MI" : "HH24:MI";
            }
        } else if (dateFreq == 5) {
            if (timeFormat.equals("AUTO") || timeFormat.equals("NONE")) {
                bAutoTime = true;
                timeFormat = ampm ? "HH:MI" : "HH24:MI";
            } else if (timeFormat.equals("HH")) {
                timeFormat = "HH:MI";
            } else if (timeFormat.equals("HH24")) {
                timeFormat = "HH24:MI";
            }
        } else if (dateFreq == 6) {
            if (timeFormat.equals("AUTO") || timeFormat.equals("NONE")) {
                bAutoTime = true;
                timeFormat = ampm ? "HH:MI:SS" : "HH24:MI:SS";
            } else if (timeFormat.equals("HH") || timeFormat.equals("HH:MI")) {
                timeFormat = "HH:MI:SS";
            } else if (timeFormat.equals("HH24") || timeFormat.equals("HH24:MI")) {
                timeFormat = "HH24:MI:SS";
            }
        }
        if (bAutoTime && ampm || !bAutoTime && (timeFormat.equals("HH") || timeFormat.equals("HH:MI") || timeFormat.equals("HH:MI:SS"))) {
            timeFormat = timeFormat + " AM";
        }
        str = str + " " + pfj.formatDate(date, 3, timeFormat);
        return str;
    }

    protected CustomToolTipCallback getCustomToolTipCallback() {
        return this.m_customToolTipCallback;
    }

    protected void setCustomToolTipCallback(CustomToolTipCallback callback) {
        this.m_customToolTipCallback = callback;
    }

    protected Object getWrappedText(Object obj) {
        if (obj == null) {
            return obj;
        }
        Graphics gc = this.m_commonGraph.getPFJ().getGraphicsContext();
        if (gc == null) {
            return obj;
        }
        String wrappedString = "";
        Font font = new Font("SansSerif", 0, 10);
        FontMetrics fm = gc.getFontMetrics(font);
        VC vc = this.m_commonGraph.getPFJ().getVC();
        Vector subStrings = new Vector();
        TextStyleObj tsObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        tsObj.extractLinesWordWrap(obj.toString(), subStrings, vc.virtToDestWidth(32000 - vc.destToVirtWidth(20)), fm, this.m_commonGraph.getPFJ().getFontMetricsResolver());
        int i = 0;
        while (i < subStrings.size()) {
            wrappedString = wrappedString + (String)subStrings.elementAt(i) + RETURN;
            ++i;
        }
        return wrappedString;
    }

    private void $init$() {
        this.m_GraphIsOpenAndClose = false;
        this.m_AxisLabelTipDisplayed = true;
        this.m_GraphIsPieBar = false;
        this.m_GraphIsSingleY = false;
        this.m_GraphIsStacked = false;
        this.m_MarkerTipDisplayed = true;
        this.m_SeriesAreRows = true;
        this.m_ShowColDimName = false;
        this.m_ShowRowDimName = false;
        this.m_ShowGroupLabels = true;
        this.m_ShowSeriesLabels = true;
        this.m_CumValTip = false;
        this.m_PercentTip = false;
        this.m_TextTip = true;
        this.m_ValueTip = true;
        this.m_MarkerTipType = 1 | 8;
        this.m_TipGroupLabelType = 1;
        this.m_TipSeriesLabelType = 1;
        this.m_ValuesPerGroup = 0;
        this.m_DataValuesPerMarker = 0;
        this.m_DimNameType = "dimShortName";
        this.m_DimMemberNameType = "shortName";
        this.m_excelOrDeskTop = false;
        this.m_commonGraph = null;
        this.m_dataAccess = null;
        this.m_fmtMgr = null;
        this.m_numFormatCallback = null;
        this.m_customToolTipCallback = null;
        this.rBundle = null;
        this.m_measureDim = "";
    }

    protected class DimValuePairs {
        public String dim;
        public String value;

        public DimValuePairs() {
            this.dim = null;
            this.value = null;
        }

        public DimValuePairs(String inDim, String inValue) {
            this.dim = inDim;
            this.value = inValue;
        }

        public boolean equals(DimValuePairs dvp) {
            return this.dim.equals(dvp.dim) && this.value.equals(dvp.value);
        }
    }
}

