/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Y2Axis
extends BaseDataAxis {
    protected static final String a_paretoMajorTickStep = "paretoMajorTickStep";

    public Y2Axis(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getY2Axis();
        this.m_identObj2 = this.m_pfj.getY2AxisLine();
        this.m_majorGridIdentObj = this.m_pfj.getY2MajorGrid();
        this.m_labelIdentObj = this.m_pfj.getY2Label();
        this.m_id = 51;
    }

    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getY2MustIncludeZero();
    }

    public void setAxisAutoScaledFromZero(boolean yesNo) {
        this.m_pfj.setY2MustIncludeZero(yesNo);
    }

    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getY2ScaleMaxAuto();
    }

    public void setAxisMaxAutoScaled(boolean yesNo) {
        this.m_pfj.setY2ScaleMaxAuto(yesNo);
    }

    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getY2ScaleMinAuto();
    }

    public void setAxisMinAutoScaled(boolean yesNo) {
        this.m_pfj.setY2ScaleMinAuto(yesNo);
    }

    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2ScaleMaxAutoValue();
    }

    public double getAxisMaxValue() {
        return this.m_pfj.getY2ScaleMax();
    }

    public void setAxisMaxValue(double value) {
        this.m_pfj.setY2ScaleMax(value);
    }

    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2ScaleMinAutoValue();
    }

    public double getAxisMinValue() {
        return this.m_pfj.getY2ScaleMin();
    }

    public void setAxisMinValue(double value) {
        this.m_pfj.setY2ScaleMin(value);
    }

    public double getAxisZoomMaxValue() {
        return this.m_pfj.getY2ScaleZoomMax();
    }

    public void setAxisZoomMaxValue(double value) {
        this.m_pfj.setY2ScaleZoomMax(value);
    }

    public double getAxisZoomMinValue() {
        return this.m_pfj.getY2ScaleZoomMin();
    }

    public void setAxisZoomMinValue(double value) {
        this.m_pfj.setY2ScaleZoomMin(value);
    }

    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        if (this.m_commonGraph.getGraphType() == 96) {
            return this.m_pfj.getParetoY2MajorGridStep();
        }
        return this.m_pfj.getY2MajorGridStep();
    }

    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2MajorGridStepAutoValue();
    }

    public void setMajorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else if (this.m_commonGraph.getGraphType() == 96) {
            this.m_pfj.setParetoY2MajorGridStep(value);
        } else {
            this.m_pfj.setY2MajorGridStep(value);
        }
    }

    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getY2MajorGridStepAuto();
    }

    public void setMajorTickStepAutomatic(boolean yesNo) {
        this.m_pfj.setY2MajorGridStepAuto(yesNo);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_pfj.setY2LabelDisplay(visible);
        this.m_pfj.setY2MajorGridDisplay(visible);
    }

    protected String getComponentName() {
        return "Y2Axis";
    }

    private void logError() {
        this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setXML()");
    }

    protected void setMajorTickStepXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("majorTickStep");
        if (pNode != null) {
            double value = pNode.getValueAsDouble();
            if (value < 0.0) {
                this.logError();
            } else if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("majorTickStep", new Double(value));
            } else {
                this.m_pfj.setY2MajorGridStep(value);
            }
        }
        if ((pNode = node.getProperty(a_paretoMajorTickStep)) != null) {
            double value = pNode.getValueAsDouble();
            if (value < 0.0) {
                this.logError();
            } else {
                this.m_pfj.setParetoY2MajorGridStep(value);
            }
        }
    }

    protected boolean getMajorTickStepXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = false;
        Object val = this.m_pfj.getGridStepObj(this.m_majorGridIdentObj);
        if (val != null) {
            node.addProperty("majorTickStep", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.ParetoY2MajorGridStep)) != null) {
            node.addProperty(a_paretoMajorTickStep, ((Double)val).doubleValue());
            nodeExists = true;
        }
        return nodeExists;
    }
}

