/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.BLAChartRenderer;
import oracle.dss.graph.flash.MovieClipObj;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;

public class AreaChartRenderer
extends BLAChartRenderer {
    private boolean m_bDownGradient;

    public AreaChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document, vc, renderDynamic, pfj);
    }

    protected void asPushGradientProperties(ConstantPool cp, DoAction doAction) {
        super.asPushGradientProperties(cp, doAction);
        ActionScript.createAndInitializeGlobalVar(cp, doAction, "isDownGradient", new Boolean(this.m_bDownGradient));
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        super.createChartContext(cp, updatedActions);
        this.asCreateDataArray(cp, updatedActions, "dataArray", this.m_numSeries);
        this.asCreateFillColorArray(cp, updatedActions, "fillColorArray", this.m_numSeries);
        this.asCreateFillAlphaArray(cp, updatedActions, "fillAlphaArray", this.m_numSeries);
    }

    protected void createMCObjArray() {
        this.m_mcObjs = new Vector[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            this.m_mcObjs[i] = new Vector();
            this.m_mcObjs[i].setSize(this.m_numGroups + 1);
            ++i;
        }
    }

    protected int getChartType() {
        return 2;
    }

    protected boolean includeRendererAsset(String asset) {
        if (super.includeRendererAsset(asset)) {
            return true;
        }
        return asset.equals("__Packages.BLAChartRenderer") || asset.equals("__Packages.AreaChartRenderer") || this.is3DEffect() && asset.equals("__Packages.Area3D") || !this.is3DEffect() && asset.equals("__Packages.Area2D") || asset.equals("__Packages.Bar2D");
    }

    protected void populateMCDrawProperties(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth) {
        MovieClipObj mc = new MovieClipObj(blackBox, identObj, pfj, shape, borderWidth, this.m_bHasGradient);
        mc.calcProperties();
        if (this.m_bHasGradient) {
            boolean bl = this.m_bDownGradient = this.m_pfj.getGradientDirection(blackBox.getIdentObj()) == 3;
        }
        if (identObj.getObjectID() == 256) {
            this.m_mcObjs[mc.getSeries()].setElementAt(mc, this.m_numGroups);
        } else if (identObj.getObjectID() == 259) {
            this.m_mcObjs[mc.getSeries()].setElementAt(mc, mc.getGroup());
        }
    }

    protected int[][] getMCHeightValues() {
        int[][] mcHeightValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcHeightValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcHeightValues[i2][j] = ((Rectangle)shape).height;
                    } else if (shape instanceof Polygon) {
                        mcHeightValues[i2][j] = ((Polygon)shape).getBounds().height;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcHeightValues;
    }

    protected int[][] getMCWidthValues() {
        int[][] mcWidthValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcWidthValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcWidthValues[i2][j] = ((Rectangle)shape).width;
                    } else if (shape instanceof Polygon) {
                        mcWidthValues[i2][j] = ((Polygon)shape).getBounds().width;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcWidthValues;
    }

    protected int[][] getXValues() {
        int[][] mcXMinValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcXMinValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcXMinValues[i2][j] = ((Rectangle)shape).x;
                    } else if (shape instanceof Polygon) {
                        Polygon polygon = (Polygon)shape;
                        mcXMinValues[i2][j] = ((Polygon)shape).getBounds().x;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcXMinValues;
    }

    protected int[][] getYValues() {
        int[][] mcYMinValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcYMinValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcYMinValues[i2][j] = ((Rectangle)shape).y;
                    } else if (shape instanceof Polygon) {
                        Polygon polygon = (Polygon)shape;
                        mcYMinValues[i2][j] = polygon.getBounds().y;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcYMinValues;
    }
}

