/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.ChartRenderer;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.IdentObj;

public abstract class BLAChartRenderer
extends ChartRenderer {
    public BLAChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document, vc, renderDynamic, pfj);
    }

    protected boolean includeRendererAsset(String asset) {
        if (super.includeRendererAsset(asset)) {
            return true;
        }
        return asset.equals("__Packages.GroupLabels") || asset.equals("__Packages.BLAGroupLabels") || asset.equals("__Packages.BLAChartRenderer") || asset.equals("__Packages.Y1Axis") || asset.equals("__Packages.MinMaxObj") || asset.equals("__Packages.FP") || asset.equals("__Packages.BLAFrameObj") || this.m_pfj.getY1MajorGridDisplay() && asset.equals("__Packages.Line2D");
    }

    protected void asPush3DContext(ConstantPool cp, DoAction updatedActions) {
        super.asPush3DContext(cp, updatedActions);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "depthRadius", new Integer(this.m_pfj.getDepthRadius()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "depthAngle", new Integer(this.m_pfj.getDepthAngle()));
    }

    private void _asPushYAxisProperties(ConstantPool cp, DoAction updatedActions) {
        int scaling = this.m_pfj.getJGraphType().getScalingMethod();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "scaling", new Integer(scaling));
        boolean bMustIncludeZero = this.m_pfj.getY1MustIncludeZero();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "mustIncludeZero", new Boolean(bMustIncludeZero));
        boolean logScale = this.m_pfj.getY1LogScale();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "logScale", new Boolean(logScale));
        boolean bVerticalChart = this.m_pfj.getJGraphType().getOrientation() == 2;
        ActionScript.pushPrimitiveVal(cp, updatedActions, "verticalAxis", new Boolean(bVerticalChart));
        boolean bAutoMax = this.m_pfj.getY1ScaleMaxAuto();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "autoMax", new Boolean(bAutoMax));
        boolean bAutoMin = this.m_pfj.getY1ScaleMinAuto();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "autoMin", new Boolean(bAutoMin));
        boolean bAutoStep = this.m_pfj.getY1MajorGridStepAuto();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "autoStep", new Boolean(bAutoStep));
        double logScaleBase = this.m_pfj.getLogScaleBase(2004);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "logScaleBase", new Double(logScaleBase));
        this._pushAxisLabelsTextStyle(cp, updatedActions);
        this._pushYAxisMajorGridlinesProperties(cp, updatedActions);
    }

    private void _pushAxisLabelsTextStyle(ConstantPool cp, DoAction updatedActions) {
        IdentObj idLabel = this.m_pfj.getY1Label();
        String fontName = this.m_pfj.getFontName(idLabel);
        if (fontName.equalsIgnoreCase("SansSerif")) {
            fontName = "_sans";
        }
        if (fontName.equalsIgnoreCase("Dialog")) {
            fontName = "Arial";
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisLabelFontName", fontName);
        int fontStyle = this.m_pfj.getFontStyle(idLabel);
        boolean bold = false;
        if ((fontStyle & 2) != 0) {
            bold = true;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisLabelBold", new Boolean(bold));
        boolean italic = false;
        if ((fontStyle & 1) != 0) {
            italic = true;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisLabelItalic", new Boolean(italic));
        boolean underline = false;
        if ((fontStyle & 4) != 0) {
            underline = true;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisLabelUnderline", new Boolean(underline));
        int fontSize = this.m_pfj.getFontSize(idLabel);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisLabelFontHeight", new Integer(fontSize));
        int fontColor = this.m_pfj.getFillColor(idLabel).getRGB();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisLabelFontColor", new Integer(fontColor));
    }

    private void _pushYAxisMajorGridlinesProperties(ConstantPool cp, DoAction updatedActions) {
        if (this.m_pfj.getY1MajorGridStyle() != 6) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisMajorGridDisplay", new Boolean(true));
            IdentObj gridId = this.m_pfj.getY1MajorGrid();
            int gridColor = this.m_pfj.getBorderColor(gridId).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisMajorGridColor", new Integer(gridColor));
            int lineWidth = this.m_pfj.getLineWidth(gridId);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisMajorGridLineWidth", new Integer(lineWidth));
        } else {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "yAxisMajorGridDisplay", new Boolean(false));
        }
    }

    private void _asPushY1AxisValues(ConstantPool cp, DoAction updatedActions) {
        if (!this.m_pfj.getY1ScaleMinAuto()) {
            double minY = this.m_pfj.getY1ScaleMin();
            ActionScript.createAndInitializeGlobalVar(cp, updatedActions, "y1ScaleMin", new Double(minY));
        }
        if (!this.m_pfj.getY1ScaleMaxAuto()) {
            double maxY = this.m_pfj.getY1ScaleMax();
            ActionScript.createAndInitializeGlobalVar(cp, updatedActions, "y1ScaleMax", new Double(maxY));
        }
        if (!this.m_pfj.getY1MajorGridStepAuto()) {
            double gridStep = this.m_pfj.getY1MajorGridStep();
            ActionScript.createAndInitializeGlobalVar(cp, updatedActions, "scaleStep", new Double(gridStep));
        }
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        super.createChartContext(cp, updatedActions);
        this._asCreateMCHeightArray(cp, updatedActions, "heightArray");
        this._asCreateMCWidthArray(cp, updatedActions, "widthArray");
        this._asCreateXArray(cp, updatedActions, "xArray");
        this._asCreateYArray(cp, updatedActions, "yArray");
        this._asPushY1AxisValues(cp, updatedActions);
        this._asPushYAxisProperties(cp, updatedActions);
    }

    private void _asCreateMCHeightArray(ConstantPool cp, DoAction doAction, String heightArray) {
        int[][] heightValues = this.getMCHeightValues();
        ActionScript.createArray(cp, doAction, heightArray, heightValues);
    }

    private void _asCreateMCWidthArray(ConstantPool cp, DoAction doAction, String widthArray) {
        int[][] widthValues = this.getMCWidthValues();
        ActionScript.createArray(cp, doAction, widthArray, widthValues);
    }

    private void _asCreateXArray(ConstantPool cp, DoAction doAction, String xArray) {
        int[][] xValues = this.getXValues();
        ActionScript.createArray(cp, doAction, xArray, xValues);
    }

    private void _asCreateYArray(ConstantPool cp, DoAction doAction, String yArray) {
        int[][] yValues = this.getYValues();
        ActionScript.createArray(cp, doAction, yArray, yValues);
    }

    protected abstract int[][] getMCHeightValues();

    protected abstract int[][] getMCWidthValues();

    protected abstract int[][] getXValues();

    protected abstract int[][] getYValues();
}

