/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Vector;
import oracle.dss.graph.flash.BLAChartRenderer;
import oracle.dss.graph.flash.MovieClipObj;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;

public class BarChartRenderer
extends BLAChartRenderer {
    public BarChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document, vc, renderDynamic, pfj);
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        super.createChartContext(cp, updatedActions);
        this.asCreateDataArray(cp, updatedActions, "dataArray", this.m_numGroups);
        this.asCreateFillColorArray(cp, updatedActions, "fillColorArray", this.m_numGroups);
        this.asCreateFillAlphaArray(cp, updatedActions, "fillAlphaArray", this.m_numGroups);
    }

    protected int getChartType() {
        if (this.m_pfj.getGraphType() == 18) {
            return 5;
        }
        return 0;
    }

    protected boolean includeRendererAsset(String asset) {
        if (super.includeRendererAsset(asset)) {
            return true;
        }
        return !this.isStacked() && asset.equals("__Packages.BarChartRenderer") || this.isStacked() && asset.equals("__Packages.StackedBarChartRenderer") || this.is3DEffect() && asset.equals("__Packages.Bar3D") || !this.is3DEffect() && asset.equals("__Packages.Bar2D");
    }

    protected void createMCObjArray() {
        this.m_mcObjs = new Vector[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            this.m_mcObjs[i] = new Vector();
            this.m_mcObjs[i].setSize(this.m_numSeries);
            ++i;
        }
    }

    protected void populateMCDrawProperties(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth) {
        if (shape instanceof Line2D) {
            shape = shape.getBounds();
        }
        MovieClipObj mc = new MovieClipObj(blackBox, identObj, pfj, shape, borderWidth, this.m_bHasGradient);
        mc.calcProperties();
        this.m_mcObjs[mc.getGroup()].set(mc.getSeries(), mc);
    }

    protected int[][] getMCHeightValues() {
        int[][] mcHeightValues = new int[this.m_numGroups][];
        int i = 0;
        while (i < this.m_numGroups) {
            mcHeightValues[i] = new int[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    int height = 0;
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Polygon) {
                        height = ((Polygon)shape).getBounds().height;
                    } else if (shape instanceof Rectangle) {
                        height = ((Rectangle)shape).height;
                    }
                    mcHeightValues[i2][j] = height;
                }
                ++j;
            }
            ++i2;
        }
        return mcHeightValues;
    }

    protected int[][] getMCWidthValues() {
        int[][] mcWidthValues = new int[this.m_numGroups][];
        int i = 0;
        while (i < this.m_numGroups) {
            mcWidthValues[i] = new int[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    int width = 0;
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Polygon) {
                        width = ((Polygon)shape).getBounds().width;
                    } else if (shape instanceof Rectangle) {
                        width = ((Rectangle)shape).width;
                    }
                    mcWidthValues[i2][j] = width;
                }
                ++j;
            }
            ++i2;
        }
        return mcWidthValues;
    }

    protected int[][] getXValues() {
        int[][] mcXMinValues = new int[this.m_numGroups][];
        int i = 0;
        while (i < this.m_numGroups) {
            mcXMinValues[i] = new int[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    int x = 0;
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Polygon) {
                        x = ((Polygon)shape).getBounds().x;
                    } else if (shape instanceof Rectangle) {
                        x = ((Rectangle)shape).x;
                    }
                    mcXMinValues[i2][j] = x;
                }
                ++j;
            }
            ++i2;
        }
        return mcXMinValues;
    }

    protected int[][] getYValues() {
        int[][] mcYMinValues = new int[this.m_numGroups][];
        int i = 0;
        while (i < this.m_numGroups) {
            mcYMinValues[i] = new int[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    int y = 0;
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Polygon) {
                        y = ((Polygon)shape).getBounds().y;
                    } else if (shape instanceof Rectangle) {
                        y = ((Rectangle)shape).y;
                    }
                    mcYMinValues[i2][j] = y;
                }
                ++j;
            }
            ++i2;
        }
        return mcYMinValues;
    }

    private boolean isStacked() {
        return this.m_pfj.getGraphType() == 18;
    }
}

