/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.GroupComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.DrillInfo;
import oracle.dss.graph.flash.FlashRenderer;
import oracle.dss.graph.flash.GroupLabelObj;
import oracle.dss.graph.flash.LegendObj;
import oracle.dss.graph.flash.MovieClipObj;
import oracle.dss.graph.flash.ToolTipActionScript;
import oracle.dss.graph.flash.ToolTipObj;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape4;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.util.ChartHelper;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.ColorPinObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public abstract class ChartRenderer
extends FlashRenderer {
    protected boolean m_bHasGradient;
    protected int m_numGroups;
    protected int m_numSeries;
    protected Perspective m_pfj;
    protected Vector m_ttObjs;
    protected Vector<DrillInfo> m_drillInfoVect;
    protected VC m_vc;
    protected LegendObj m_legend;
    private SWFDocument m_document;
    private CommonGraph m_commonGraph;
    private Rectangle m_boundingRect;
    private boolean m_bRenderDynamic;
    private Graphics m_graphics;
    private GroupLabelObj m_groupLabels;
    protected GroupLabelObj m_funnelSliceLabels;
    private boolean m_isToolTip;
    private boolean m_vertGradient;

    public ChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document);
        this.m_document = document;
        this.m_vc = vc;
        this.m_bRenderDynamic = renderDynamic;
        this.m_pfj = pfj;
        this.m_commonGraph = this.m_pfj.getCommonGraph();
        this.m_numGroups = this.m_pfj.getNumGroups();
        this.m_numSeries = this.m_pfj.getNumNonIgnoredSeries();
        this.m_ttObjs = new Vector();
        this.m_drillInfoVect = new Vector();
        this._checkGradient();
        if (renderDynamic) {
            this.createMCObjArray();
        }
    }

    public void drawImage(Image image, int x, int y, ImageObserver imgObs) {
    }

    public void drawLine(BlackBoxIF blackBox, IdentObj identObj, double x1, double y1, double x2, double y2, int width, boolean lightColor, String[] tooltipArray) {
        boolean intelligent = this._isIntelligentComponent(identObj);
        boolean dropShadowNeeded = this._isDropShadowNeeded(identObj);
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        int[] params = null;
        String handleType = null;
        DrillInfo drillInfo = null;
        if (this.m_bRenderDynamic && this._isDrillableComponent(identObj)) {
            ComponentHandle handle = this.m_pfj.getCommonGraph().getGraphComponentHandle(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getMiscID());
            if (handle instanceof DataComponentHandle) {
                handleType = "bi_data_handle";
            } else if (handle instanceof SeriesComponentHandle) {
                handleType = "bi_series_handle";
            } else if (handle instanceof GroupComponentHandle) {
                handleType = "bi_group_handle";
            }
            params = this.m_pfj.getCommonGraph().getDrillParameters(handle);
            if (params != null) {
                drillInfo = new DrillInfo(params[0], params[1], params[2], handleType, handle.getID());
                this.m_drillInfoVect.add(drillInfo);
            }
        }
        if (this._isIntelligentComponent(identObj) && this.m_bRenderDynamic) {
            this.populateMCDrawProperties(blackBox, identObj, this.m_pfj, line, -1);
            return;
        }
        FillStyleArray fsArray = this._getFillStyleArray(blackBox, identObj, null);
        LineStyleArray lsArray = this._getLineStyleArray(blackBox, identObj, width);
        if (lightColor) {
            LineStyle2 lineStyle = (LineStyle2)lsArray.getStyle(1);
            RGBA rgba = lineStyle.getColor();
            Color col = new Color(rgba.getRed(), rgba.getGreen(), rgba.getBlue(), rgba.getAlpha());
            col = this.m_pfj.getBrighter(col);
            rgba = new RGBA(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
            lineStyle.setColor(rgba);
        }
        DefinitionTag defShape = this.drawLine(x1, y1, x2, y2, width, fsArray, lsArray, this._getFillStyleIndex(identObj), this._getLineStyleIndex(identObj), intelligent, this._isDefineShape4Needed(identObj), dropShadowNeeded);
        Rect originalRect = this.getSwiffRect(line);
        if (!intelligent) {
            this.addToDisplay(defShape.getCharacterId(), null, dropShadowNeeded);
        } else if (defShape instanceof DefineShape3) {
            this._createSprite(blackBox, identObj, (DefineShape3)defShape, originalRect, tooltipArray);
        } else {
            this._createSprite(blackBox, identObj, (DefineShape4)defShape, originalRect, tooltipArray);
        }
    }

    public void drawLine(BlackBoxIF blackBox, IdentObj identObj, double x1, double y1, double x2, double y2, int width, String[] tooltipArray) {
        if (identObj.getObjectID() == 259) {
            return;
        }
        boolean intelligent = this._isIntelligentComponent(identObj);
        boolean dropShadowNeeded = this._isDropShadowNeeded(identObj);
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        int[] params = null;
        String handleType = null;
        DrillInfo drillInfo = null;
        if (this.m_bRenderDynamic && this._isDrillableComponent(identObj)) {
            ComponentHandle handle = this.m_pfj.getCommonGraph().getGraphComponentHandle(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getMiscID());
            if (handle instanceof DataComponentHandle) {
                handleType = "bi_data_handle";
            } else if (handle instanceof SeriesComponentHandle) {
                handleType = "bi_series_handle";
            } else if (handle instanceof GroupComponentHandle) {
                handleType = "bi_group_handle";
            }
            params = this.m_pfj.getCommonGraph().getDrillParameters(handle);
            if (params != null) {
                drillInfo = new DrillInfo(params[0], params[1], params[2], handleType, handle.getID());
                this.m_drillInfoVect.add(drillInfo);
            }
        }
        if (intelligent && this.m_bRenderDynamic) {
            if (identObj.getObjectID() == 2) {
                return;
            }
            if (identObj.getObjectID() == 285) {
                return;
            }
            if (identObj.getObjectID() == 294) {
                return;
            }
            if (identObj.getObjectID() == 13) {
                this.m_legend.setMarker(identObj.getSeriesID(), line.getBounds());
                this.m_legend.setMarkerShape(identObj.getSeriesID(), 1);
            }
            this.populateMCDrawProperties(blackBox, identObj, this.m_pfj, line, width);
            return;
        }
        FillStyleArray fsArray = this._getFillStyleArray(blackBox, identObj, null);
        LineStyleArray lsArray = this._getLineStyleArray(blackBox, identObj, width);
        DefinitionTag defShape = this.drawLine(x1, y1, x2, y2, width, fsArray, lsArray, this._getFillStyleIndex(identObj), this._getLineStyleIndex(identObj), intelligent, this._isDefineShape4Needed(identObj), dropShadowNeeded);
        Rect originalRect = this.getSwiffRect(line);
        if (!intelligent) {
            this.addToDisplay(defShape.getCharacterId(), null, dropShadowNeeded);
        } else if (defShape instanceof DefineShape3) {
            this._createSprite(blackBox, identObj, (DefineShape3)defShape, originalRect, tooltipArray);
        } else {
            this._createSprite(blackBox, identObj, (DefineShape4)defShape, originalRect, tooltipArray);
        }
    }

    public void drawLine(BlackBoxIF blackBox, IdentObj identObj, Point2D p1, Point2D p2, int width, boolean lightColor, String[] tooltipArray) {
        this.drawLine(blackBox, identObj, p1.getX(), p1.getY(), p2.getX(), p2.getY(), width, lightColor, tooltipArray);
    }

    public void drawLine(BlackBoxIF blackBox, IdentObj identObj, Point2D p1, Point2D p2, int width, String[] tooltipArray) {
        if (identObj.getObjectID() != 283 && identObj.getObjectID() != 269) {
            this.drawLine(blackBox, identObj, p1.getX(), p1.getY(), p2.getX(), p2.getY(), width, tooltipArray);
        }
    }

    public void drawRectangle(BlackBoxIF blackBox, IdentObj identObj, Rectangle r, int type, String[] tooltipArray) {
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (type == 2) {
            x1 = r.x;
            y1 = r.y + r.height;
            x2 = r.x + r.width;
            y2 = y1;
            this.drawLine(blackBox, identObj, (double)x1, (double)y1, x2, y2, 1, tooltipArray);
        } else if (type == 1) {
            x1 = r.x;
            y1 = r.y;
            x2 = x1 + r.width;
            y2 = y1;
            this.drawLine(blackBox, identObj, (double)x1, (double)y1, x2, y2, 1, tooltipArray);
        } else if (type == 3) {
            x1 = r.x;
            y1 = r.y;
            x2 = r.x;
            y2 = r.y + r.height;
            this.drawLine(blackBox, identObj, (double)x1, (double)y1, x2, y2, 1, tooltipArray);
        } else if (type == 4) {
            x1 = r.x + r.width;
            y1 = r.y;
            x2 = x1;
            y2 = r.y + r.height;
            this.drawLine(blackBox, identObj, (double)x1, (double)y1, x2, y2, 1, tooltipArray);
        } else {
            this.drawRectangle(blackBox, identObj, r, tooltipArray);
        }
    }

    public void drawRectangle(BlackBoxIF blackBox, IdentObj identObj, Rectangle rectangle, String[] tooltipArray) {
        boolean intelligent = this._isIntelligentComponent(identObj);
        boolean dropShadowNeeded = this._isDropShadowNeeded(identObj);
        int[] params = null;
        String handleType = null;
        DrillInfo drillInfo = null;
        if (this.m_bRenderDynamic && this._isDrillableComponent(identObj)) {
            ComponentHandle handle = this.m_pfj.getCommonGraph().getGraphComponentHandle(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getMiscID());
            if (handle instanceof DataComponentHandle) {
                handleType = "bi_data_handle";
            } else if (handle instanceof SeriesComponentHandle) {
                handleType = "bi_series_handle";
            } else if (handle instanceof GroupComponentHandle) {
                handleType = "bi_group_handle";
            }
            params = this.m_pfj.getCommonGraph().getDrillParameters(handle);
            if (params != null) {
                drillInfo = new DrillInfo(params[0], params[1], params[2], handleType, handle.getID());
                this.m_drillInfoVect.add(drillInfo);
            }
        }
        if (this.m_pfj.isFunnel() && (identObj.getObjectID() == 12 || identObj.getObjectID() == 13)) {
            intelligent = false;
        }
        if (intelligent && this.m_bRenderDynamic) {
            if (identObj.getObjectID() == 2) {
                return;
            }
            if (identObj.getObjectID() == 12) {
                if (this.m_legend == null) {
                    this.m_legend = new LegendObj(blackBox, this.m_pfj, rectangle, this.m_numSeries);
                }
            } else if (identObj.getObjectID() == 13) {
                this.m_legend.setMarker(identObj.getSeriesID(), rectangle);
                this.m_legend.setMarkerShape(identObj.getSeriesID(), 0);
            } else {
                this.populateMCDrawProperties(blackBox, identObj, this.m_pfj, rectangle, -1);
            }
            return;
        }
        if (identObj.getObjectID() == 620) {
            return;
        }
        FillStyleArray fsArray = this._getFillStyleArray(blackBox, identObj, rectangle);
        LineStyleArray lsArray = this._getLineStyleArray(blackBox, identObj);
        DefineShape3 shape3 = (DefineShape3)this.drawRectangle(rectangle, fsArray, lsArray, this._getFillStyleIndex(identObj), this._getLineStyleIndex(identObj), intelligent, this._isDefineShape4Needed(identObj), dropShadowNeeded);
        if (!intelligent) {
            this.addToDisplay(shape3.getCharacterId(), null, dropShadowNeeded);
        } else {
            this._createSprite(blackBox, identObj, shape3, this.getSwiffRect(rectangle), tooltipArray);
        }
    }

    public void drawShape(BlackBoxIF blackBox, IdentObj identObj, Shape shape, String[] tooltipArray) {
        boolean intelligent = this._isIntelligentComponent(identObj);
        boolean dropShadowNeeded = this._isDropShadowNeeded(identObj);
        int[] params = null;
        String handleType = null;
        DrillInfo drillInfo = null;
        if (this.m_bRenderDynamic && this._isDrillableComponent(identObj)) {
            ComponentHandle handle = this.m_pfj.getCommonGraph().getGraphComponentHandle(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getMiscID());
            if (handle instanceof DataComponentHandle) {
                handleType = "bi_data_handle";
            } else if (handle instanceof SeriesComponentHandle) {
                handleType = "bi_series_handle";
            } else if (handle instanceof GroupComponentHandle) {
                handleType = "bi_group_handle";
            }
            params = this.m_pfj.getCommonGraph().getDrillParameters(handle);
            if (params != null) {
                drillInfo = new DrillInfo(params[0], params[1], params[2], handleType, handle.getID());
                this.m_drillInfoVect.add(drillInfo);
            }
        }
        if (identObj.getObjectID() == 626 && identObj.getMiscID() != 623) {
            intelligent = false;
        }
        if (this.m_bRenderDynamic) {
            if (!this._isExported(identObj)) {
                return;
            }
            if (intelligent) {
                this.populateMCDrawProperties(blackBox, identObj, this.m_pfj, shape, -1);
                return;
            }
            return;
        }
        FillStyleArray fsArray = this._getFillStyleArray(blackBox, identObj, shape);
        LineStyleArray lsArray = this._getLineStyleArray(blackBox, identObj);
        DefineShape3 shape3 = (DefineShape3)this.drawShape(shape, fsArray, lsArray, this._getFillStyleIndex(identObj), this._getLineStyleIndex(identObj), intelligent, this._isDefineShape4Needed(identObj), dropShadowNeeded, this._isClosingLIneNeeded(identObj));
        if (!intelligent) {
            this.addToDisplay(shape3.getCharacterId(), null, dropShadowNeeded);
        } else {
            this._createSprite(blackBox, identObj, shape3, this.getSwiffRect(shape), tooltipArray);
        }
    }

    public void drawText(BlackBoxIF blackBox, IdentObj identObj, TextStyleObj textStyle, String text, Rectangle bounds) {
        Font font = textStyle.getFont(this.m_vc);
        int fontHeight = textStyle.getFontSizeDC(this.m_vc);
        if (bounds != null) {
            boolean intelligent = this._isIntelligentComponent(identObj);
            if (this.m_pfj.isFunnel() && identObj.getObjectID() == 14) {
                intelligent = false;
            }
            if (this.m_bRenderDynamic && intelligent) {
                boolean underline = false;
                if ((textStyle.getFontStyle() & 4) != 0) {
                    underline = true;
                }
                if (identObj.getObjectID() == 270 || identObj.getObjectID() == 296) {
                    int groupId = identObj.getGroupID();
                    if (this.m_groupLabels == null) {
                        this.m_groupLabels = new GroupLabelObj(this.m_numGroups, font, fontHeight, blackBox.getFillColor().getRGB(), underline);
                    }
                    this.m_groupLabels.setText(groupId, text, bounds);
                } else if (identObj.getObjectID() == 622) {
                    int groupId = identObj.getGroupID();
                    if (this.m_funnelSliceLabels == null) {
                        this.m_funnelSliceLabels = new GroupLabelObj(this.m_numGroups, font, fontHeight, blackBox.getFillColor().getRGB(), underline);
                    }
                    this.m_funnelSliceLabels.setText(groupId, text, bounds);
                } else if (identObj.getObjectID() == 14) {
                    int seriesId = identObj.getSeriesID();
                    this.m_legend.setText(seriesId, text, bounds);
                    if (seriesId == 0) {
                        this.m_legend.setTextProps(font, fontHeight, blackBox.getFillColor().getRGB(), underline);
                    }
                }
                return;
            }
            if (identObj.getObjectID() == 14 && this.m_pfj.getLegendObj().isHorz()) {
                Dimension rSize = this.m_pfj.getImageSize();
                Rectangle frameRect = new Rectangle(rSize);
                int width = frameRect.x + frameRect.width - bounds.x;
                Rect rect = new Rect(0L, width * 20, 0L, (bounds.y + bounds.height) * 20);
                this.drawText(font, fontHeight, text, bounds.x, bounds.y, blackBox.getFillColor(), rect);
            } else if (identObj.getObjectID() == 270 && this.m_pfj.isChartOrientHorz()) {
                Rect rect = new Rect(0L, (bounds.width + this.GUTTER_ADJUSTMENT) * 20, 0L, (bounds.y + bounds.height + this.GUTTER_ADJUSTMENT) * 20);
                this.drawText(font, fontHeight, text, bounds.x, bounds.y, blackBox.getFillColor(), rect);
            } else if (identObj.getObjectID() == 5) {
                Rectangle titleBox = this.m_vc.virtToDest(this.m_pfj.getRect(this.m_pfj.getTitle()));
                Rect rect = new Rect(0L, (titleBox.width + this.GUTTER_ADJUSTMENT) * 20, 0L, (bounds.y + bounds.height + this.GUTTER_ADJUSTMENT) * 20);
                this.drawText(font, fontHeight, text, bounds.x, bounds.y, blackBox.getFillColor(), rect, (short)0);
            } else {
                this.drawText(font, fontHeight, text, bounds.x, bounds.y, blackBox.getFillColor(), new Rect(0L, 0L, 0L, 0L));
            }
        }
    }

    public int drawToolTipRectangle(ToolTipObj tooltipObj, Rectangle tooltipRect) {
        BlackBoxIF blackBox = tooltipObj.getBlackBox();
        IdentObj identObj = tooltipObj.getIdentObj();
        FillStyleArray fsArray = this._getFillStyleArray(blackBox, identObj, tooltipRect);
        LineStyleArray lsArray = this._getLineStyleArray(blackBox, identObj);
        DefinitionTag shape = this.drawRectangle(tooltipRect, fsArray, lsArray, this._getFillStyleIndex(identObj), this._getLineStyleIndex(identObj), true, false, false);
        return shape.getCharacterId();
    }

    public int drawToolTipTextBox(ToolTipObj tooltipObj, Rectangle tooltipRect) {
        int offset = 3;
        String text = tooltipObj.getText().trim();
        Font font = tooltipObj.getFont();
        int fontHeight = font.getSize();
        int x = offset * 20;
        int y = offset * 20;
        int width = tooltipRect.width * 20;
        int height = tooltipRect.height * 20;
        Rect swiffRect = new Rect(x, x + width, y, y + height);
        int textId = this.drawText(font, fontHeight, text, 0, 0, Color.BLACK, swiffRect);
        return textId;
    }

    public void implementTooltips() {
        if (this.m_ttObjs != null) {
            Enumeration enumerator = this.m_ttObjs.elements();
            int i = 0;
            while (enumerator.hasMoreElements()) {
                ToolTipObj tooltipObj = (ToolTipObj)enumerator.nextElement();
                this._drawToolTips(tooltipObj);
                DefineFunction2 rollOverFunc = tooltipObj.getRollOverFunc();
                this._asAttachTooltipToStage(tooltipObj.getActionScript(), tooltipObj.getMCSymbolName(), tooltipObj.getTextBoxDepth(), rollOverFunc);
                DefineFunction2 rollOutFunc = tooltipObj.getRollOutFunc();
                ToolTipActionScript actionScript = tooltipObj.getActionScript();
                actionScript.callFunction(rollOutFunc, tooltipObj.getMCSymbolName(), "removeMovieClip");
                DefineFunction2 onClickFunc = tooltipObj.getOnDragOutFunc();
                actionScript.callFunction(onClickFunc, tooltipObj.getMCSymbolName(), "removeMovieClip");
                ++i;
            }
        }
    }

    public void implementDrills() {
        ToolTipActionScript drillAS = new ToolTipActionScript(this.m_document);
        drillAS.startDoAction();
        drillAS.setVariable("LCID", this.m_pfj.getCommonGraph().getFlashChartLCID(), null, false, null);
        drillAS.endAction();
        if (this.m_drillInfoVect != null) {
            int[] spriteDepths = new int[this.m_drillInfoVect.size()];
            int i = 0;
            while (i < this.m_drillInfoVect.size()) {
                DrillInfo drillInfo = this.m_drillInfoVect.elementAt(i);
                spriteDepths[i] = drillInfo.getSpriteDepth();
                ToolTipActionScript drillAndSelectionAS = drillInfo.getActionScript();
                drillAndSelectionAS.setVariable("HANDLETYPE", drillInfo.getHandleType(), null, false, null);
                drillAndSelectionAS.setVariable("HANDLEID", drillInfo.getHandleId(), null, false, null);
                drillAndSelectionAS.setVariable("ROW", drillInfo.getRow(), null, false, null);
                drillAndSelectionAS.setVariable("COLUMN", drillInfo.getColumn(), null, false, null);
                drillAndSelectionAS.setVariable("EDGE", drillInfo.getEdge(), null, false, null);
                drillAndSelectionAS.setVariable("LAYER", drillInfo.getLayer(), null, false, null);
                drillAndSelectionAS.setVariable("SLICE", drillInfo.getSlice(), null, false, null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "handleType", "HANDLETYPE", null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "handleId", "HANDLEID", null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "row", "ROW", null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "column", "COLUMN", null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "edge", "EDGE", null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "layer", "LAYER", null);
                drillAndSelectionAS.assignValueToMember((Object)drillInfo.getSpriteName(), "slice", "SLICE", null);
                ++i;
            }
            DoAction action = new DoAction();
            this.m_document.addTag(action);
            ActionScript.createArray(null, action, "depthArray", spriteDepths);
        }
    }

    public boolean isFlashAnimationOn() {
        return this.m_pfj.isFlashAnimationOn();
    }

    public void setBoundingRect(Rectangle rectangle) {
        if (this.m_boundingRect == null || !this.m_boundingRect.equals(rectangle)) {
            this.m_boundingRect = rectangle;
        }
    }

    public void setGraphics(Graphics graphics) {
        if (this.m_graphics == null) {
            this.m_graphics = graphics;
        }
    }

    protected void asCreateDataArray(ConstantPool cp, DoAction doAction, String dataArray, int size) {
        double[][] dataValues = this._getDataValues(size);
        ActionScript.createArray(cp, doAction, dataArray, dataValues);
    }

    protected void asCreateFillAlphaArray(ConstantPool cp, DoAction doAction, String fillAlphaArray, int size) {
        int[][] fillAlphaValues = this._getFillAlphaValues(size);
        ActionScript.createArray(cp, doAction, fillAlphaArray, fillAlphaValues);
    }

    protected void asCreateFillColorArray(ConstantPool cp, DoAction doAction, String fillColorArray, int size) {
        int[][] fillColorValues = this._getFillColorValues(size);
        ActionScript.createArray(cp, doAction, fillColorArray, fillColorValues);
    }

    protected void asPushGradientProperties(ConstantPool cp, DoAction doAction) {
        ActionScript.createAndInitializeGlobalVar(cp, doAction, "hasGradient", new Boolean(this.m_bHasGradient));
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        ActionScript.pushPrimitiveVal(cp, updatedActions, "groups", new Integer(this.m_numGroups));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "series", new Integer(this.m_numSeries));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "chartType", new Integer(this.getChartType()));
        if (!this.m_pfj.getCommonGraph().isAnimationEnabled()) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "animationEnabled", this.m_pfj.getCommonGraph().isAnimationEnabled());
        }
        if (this.m_pfj.getCommonGraph().getTransitionDuration() != 1) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "transitionDuration", new Integer(this.m_pfj.getCommonGraph().getTransitionDuration()));
        }
        if (this.m_pfj.getCommonGraph().getTransitionColor() != null) {
            try {
                ActionScript.pushPrimitiveVal(cp, updatedActions, "transitionColor", new Integer(Integer.parseInt(this.m_pfj.getCommonGraph().getTransitionColor().replace("#", ""), 16)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.m_pfj.getCommonGraph().isShowTransitionColor()) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "showTransitionColor", this.m_pfj.getCommonGraph().isShowTransitionColor());
        }
        if (this.m_pfj.getCommonGraph().getFlashChartLCID() != null) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "lcId", this.m_pfj.getCommonGraph().getFlashChartLCID());
        }
        if (this.is3DEffect()) {
            this.asPush3DContext(cp, updatedActions);
        }
        this._pushGroupLabels(cp, updatedActions);
        this.pushLegends(cp, updatedActions);
        this.asPushGradientProperties(cp, updatedActions);
        this.pushKeys(cp, updatedActions);
        try {
            if (this.m_pfj.getCommonGraph().isDrillingEnabled() && this.m_pfj.getCommonGraph().isDrillingSupported()) {
                this._pushDrillData(cp, updatedActions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._asPushFrameBounds(cp, updatedActions);
        this._asPushFrameProperties(cp, updatedActions);
    }

    private void _asPushFrameBounds(ConstantPool cp, DoAction updatedActions) {
        Rectangle r = this.m_vc.virtToDest(this.m_pfj.getFrameRect(false));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameX", new Integer(r.x));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameY", new Integer(r.y));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameWidth", new Integer(r.width));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameHeight", new Integer(r.height));
    }

    private void _asPushFrameProperties(ConstantPool cp, DoAction updatedActions) {
        this._asPushMainFrameProperties(cp, updatedActions);
        if (this.is3DEffect()) {
            this._asPushSideFrameProperties(cp, updatedActions);
            this._asPushBottomFrameProperties(cp, updatedActions);
        }
    }

    private void _asPushMainFrameProperties(ConstantPool cp, DoAction updatedActions) {
        IdentObj frameId = this.m_pfj.getFrame();
        int fillType = this.m_pfj.getFillType(frameId);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameFillType", new Integer(fillType));
        if (fillType == 1) {
            int fillColor = this.m_pfj.getFillColor(frameId).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameFillColor", new Integer(fillColor));
        }
        int gradDirection = 0;
        if (fillType == 2) {
            gradDirection = this.m_pfj.getGradientDirection(frameId);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameGradientDirection", new Integer(gradDirection));
            int framePinColor = this.m_pfj.getGradientPinLeftColor(frameId, 0).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "framePinColor0", new Integer(framePinColor));
            framePinColor = this.m_pfj.getGradientPinLeftColor(frameId, 1).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "framePinColor1", new Integer(framePinColor));
        }
        if (fillType == 3) {
            String texture = this.m_pfj.getTexture(frameId);
            int textureDisplayMode = this.m_pfj.getTextureDisplayMode(frameId);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameTexture", texture);
            boolean displayTile = true;
            if (textureDisplayMode == 1) {
                displayTile = false;
            }
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameTextureTile", displayTile);
        }
        int alpha = this.m_pfj.getFillColor(frameId).getAlpha();
        alpha = (int)(0.39215686274509803 * (double)alpha);
        boolean bTransparentFillColor = this.m_pfj.getTransparentFillColor(frameId);
        if (bTransparentFillColor) {
            alpha = 0;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameFillAlpha", new Integer(alpha));
        int borderWidth = this.m_pfj.getLineWidth(frameId);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBorderWidth", new Integer(borderWidth));
        int borderColor = this.m_pfj.getBorderColor(frameId).getRGB();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBorderColor", new Integer(borderColor));
        alpha = this.m_pfj.getBorderColor(frameId).getAlpha();
        alpha = (int)(0.39215686274509803 * (double)alpha);
        boolean bBorderTransparent = this.m_pfj.getTransparentBorderColor(frameId);
        if (bBorderTransparent) {
            alpha = 0;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBorderAlpha", new Integer(alpha));
    }

    private void _asPushBottomFrameProperties(ConstantPool cp, DoAction updatedActions) {
        IdentObj frameId = this.m_pfj.getFrameBottom();
        int fillColor = this.m_pfj.getFillColor(frameId).getRGB();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBottomFillColor", new Integer(fillColor));
        int alpha = this.m_pfj.getFillColor(frameId).getAlpha();
        alpha = (int)(0.39215686274509803 * (double)alpha);
        boolean bTransparentFillColor = this.m_pfj.getTransparentFillColor(frameId);
        if (bTransparentFillColor) {
            alpha = 0;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBottomFillAlpha", new Integer(alpha));
        int borderWidth = this.m_pfj.getLineWidth(frameId);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBottomBorderWidth", new Integer(borderWidth));
        int borderColor = this.m_pfj.getBorderColor(frameId).getRGB();
        IdentObj mainFrameID = this.m_pfj.getFrame();
        if (!this.m_pfj.getTransparentBorderColor(mainFrameID)) {
            borderColor = this.m_pfj.getBorderColor(mainFrameID).getRGB();
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBottomBorderColor", new Integer(borderColor));
        alpha = this.m_pfj.getBorderColor(frameId).getAlpha();
        alpha = (int)(0.39215686274509803 * (double)alpha);
        boolean bBorderTransparent = this.m_pfj.getTransparentBorderColor(frameId);
        if (bBorderTransparent) {
            alpha = 0;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameBottomBorderAlpha", new Integer(alpha));
    }

    private void _asPushSideFrameProperties(ConstantPool cp, DoAction updatedActions) {
        IdentObj frameId = this.m_pfj.getFrameSide();
        int fillType = this.m_pfj.getFillType(frameId);
        if (fillType == 1) {
            int fillColor = this.m_pfj.getFillColor(frameId).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSideFillColor", new Integer(fillColor));
        }
        if (fillType == 2) {
            int framePinColor = this.m_pfj.getGradientPinLeftColor(frameId, 0).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSidePinColor0", new Integer(framePinColor));
            framePinColor = this.m_pfj.getGradientPinLeftColor(frameId, 1).getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSidePinColor1", new Integer(framePinColor));
        }
        int alpha = this.m_pfj.getFillColor(frameId).getAlpha();
        alpha = (int)(0.39215686274509803 * (double)alpha);
        boolean bTransparentFillColor = this.m_pfj.getTransparentFillColor(frameId);
        if (bTransparentFillColor) {
            alpha = 0;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSideFillAlpha", new Integer(alpha));
        int borderWidth = this.m_pfj.getLineWidth(frameId);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSideBorderWidth", new Integer(borderWidth));
        int borderColor = this.m_pfj.getBorderColor(frameId).getRGB();
        IdentObj mainFrameID = this.m_pfj.getFrame();
        if (!this.m_pfj.getTransparentBorderColor(mainFrameID)) {
            borderColor = this.m_pfj.getBorderColor(mainFrameID).getRGB();
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSideBorderColor", new Integer(borderColor));
        alpha = this.m_pfj.getBorderColor(frameId).getAlpha();
        alpha = (int)(0.39215686274509803 * (double)alpha);
        boolean bBorderTransparent = this.m_pfj.getTransparentBorderColor(frameId);
        if (bBorderTransparent) {
            alpha = 0;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "frameSideBorderAlpha", new Integer(alpha));
    }

    private void _pushDrillData(ConstantPool cp, DoAction doAction) {
        DrillInfo drillInfo = null;
        int i = 0;
        int[][] drillParamsArray = new int[this.m_numSeries][];
        String[] handleTypeArray = new String[this.m_numSeries];
        int[] handleIdArray = new int[this.m_numSeries];
        i = 0;
        while (i < this.m_drillInfoVect.size()) {
            drillInfo = this.m_drillInfoVect.elementAt(i);
            drillParamsArray[drillInfo.getSlice()] = new int[3];
            drillParamsArray[drillInfo.getSlice()][0] = drillInfo.getEdge();
            drillParamsArray[drillInfo.getSlice()][1] = drillInfo.getLayer();
            drillParamsArray[drillInfo.getSlice()][2] = drillInfo.getSlice();
            handleTypeArray[drillInfo.getSlice()] = drillInfo.getHandleType();
            handleIdArray[drillInfo.getSlice()] = drillInfo.getHandleId();
            ++i;
        }
        if (this.m_drillInfoVect.size() > 0) {
            ActionScript.createArray(cp, doAction, "drillParams", drillParamsArray);
            ActionScript.createArray(cp, doAction, "handleTypes", handleTypeArray);
            ActionScript.createArray(cp, doAction, "handleIds", handleIdArray);
            this.m_drillInfoVect.clear();
        }
    }

    protected void pushKeys(ConstantPool cp, DoAction doAction) {
        String[][] keys = ChartHelper.generateDataKeys(this.m_pfj);
        ActionScript.createArray(cp, doAction, "dataKeys", keys);
    }

    protected String getMCSymbolId(IdentObj identObj) {
        int objId = identObj.getObjectID();
        String symbol = null;
        switch (objId) {
            case 277: {
                symbol = "bar_mc_symbol";
                break;
            }
            case 298: {
                symbol = "pie_slice_mc_symbol";
                break;
            }
            case 332: {
                symbol = "pie_bar_slice_mc_symbol";
                break;
            }
            case 331: {
                symbol = "pie_bar__mc_symbol";
                break;
            }
            case 256: {
                symbol = "area_riser_mc_symbol";
                break;
            }
            case 259: {
                symbol = "line_marker_mc_symbol";
                break;
            }
            case 258: {
                symbol = "line_mc_symbol";
                break;
            }
            case 473: {
                symbol = "pareto_line_mc_symbol";
                break;
            }
            case 310: {
                symbol = "stock_volume_riser_mc_symbol";
                break;
            }
            case 303: {
                symbol = "stock_riser_mc_symbol";
                break;
            }
            case 319: {
                symbol = "stock_rising_riser_mc_symbol";
                break;
            }
            case 320: {
                symbol = "stock_falling_riser_mc_symbol";
                break;
            }
            case 307: {
                symbol = "stock_close_tick_mc_symbol";
                break;
            }
            case 321: {
                symbol = "stock_high_line_mc_symbol";
                break;
            }
            case 322: {
                symbol = "stock_low_line_mc_symbol";
                break;
            }
            case 621: {
                symbol = "funnel_slice_mc_symbol";
                break;
            }
        }
        return symbol;
    }

    public boolean is3DEffect() {
        return this.m_pfj.getDepthRadius() > 0 && this.m_pfj.getDepthAngle() > 0 && this.m_pfj.getJGraphType().wantDepthEffect();
    }

    public Vector[] getMovieClip() {
        return this.m_mcObjs;
    }

    public SWFDocument getSWFDocument() {
        return this.m_document;
    }

    private void _asAttachTooltipToStage(ToolTipActionScript actionScript, String mcSymbolId, int id, DefineFunction2 df2) {
        String mcInstVar = "mc_inst_var";
        actionScript.addConstant(mcInstVar);
        String targetObj = "this";
        actionScript.addConstant(targetObj);
        String mcInstName = mcSymbolId + "_inst";
        actionScript.attachMovie(mcInstVar, targetObj, mcSymbolId, mcInstName, id, df2);
        actionScript.setMCXYMouseXY(mcInstVar, df2);
        DefineFunction2 defFuncMouseMove = actionScript.defineFunctionWithNoParam("_root", "onMouseMove", df2, 1);
        actionScript.setMCXYMouseXY(mcInstVar, defFuncMouseMove);
        actionScript.setFunction(defFuncMouseMove, df2);
    }

    private void _attachMovieToSprite(String mcSymbolId, int mcDepth, int xMin, int yMin, ToolTipObj toolTipObj, DrillInfo drillInfo) {
        ToolTipActionScript actionScript = new ToolTipActionScript(this.m_document);
        actionScript.startDoAction();
        this.asAttachMovieAndSetStageLocation(actionScript, mcSymbolId, mcDepth, xMin, yMin);
        if (toolTipObj != null) {
            DefineFunction2 dfRollOver = actionScript.defineMouseFunction(mcSymbolId, "onRollOver", 0);
            actionScript.setFunction(dfRollOver, null);
            DefineFunction2 dfRollOut = actionScript.defineMouseFunction(mcSymbolId, "onRollOut", 0);
            actionScript.setFunction(dfRollOut, null);
            DefineFunction2 dfOnDragOut = actionScript.defineMouseFunction(mcSymbolId, "onDragOut", 0);
            actionScript.setFunction(dfOnDragOut, null);
            toolTipObj.setRollOverFunc(dfRollOver);
            toolTipObj.setRollOutFunc(dfRollOut);
            toolTipObj.setOnDragOutFunc(dfOnDragOut);
            toolTipObj.setActionScript(actionScript);
        }
        if (drillInfo != null) {
            drillInfo.setActionScript(actionScript);
            drillInfo.setSpriteDepth(mcDepth);
        }
        actionScript.endAction();
    }

    private void _checkGradient() {
        int seriesGradientEffect = this.m_pfj.getIntegerProp(Attr.SeriesEffect);
        this.m_bHasGradient = seriesGradientEffect == 2 || seriesGradientEffect == 1;
    }

    private String _concatTooltipArrayToString(String[] textArray) {
        if (textArray == null || textArray.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (textArray[0] != null && textArray[0].length() > 0) {
            sb.append(textArray[0]);
        }
        int i = 1;
        while (i < textArray.length) {
            if (textArray[i] != null && textArray[i].length() > 0) {
                sb.append("\n");
                sb.append(textArray[i]);
            }
            ++i;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private void _createSprite(BlackBoxIF blackBox, IdentObj identObj, DefinitionTag shape, Rect swiffRect, String[] tooltipArray) {
        String symbolId = this.getMCSymbolId(identObj);
        String symbolName = symbolId + shape.getCharacterId();
        DrillInfo drillInfo = null;
        CommonGraph graph = this.m_pfj.getCommonGraph();
        int[] params = null;
        int row = -1;
        int column = -1;
        int series = identObj.getSeriesID();
        int group = identObj.getGroupID();
        String handleType = null;
        ComponentHandle handle = graph.getGraphComponentHandle(identObj.getObjectID(), identObj.getSeriesID(), identObj.getGroupID(), identObj.getMiscID());
        if (handle instanceof DataComponentHandle) {
            handleType = "bi_data_handle";
            boolean dataRowShownAsSeries = graph.isDataRowShownAsASeries();
            int pfjRow = dataRowShownAsSeries ? series : group * this.m_pfj.getNumColumnsInGroup();
            int pfjColumn = dataRowShownAsSeries ? group * this.m_pfj.getNumColumnsInGroup() : series;
            DataCallback grid = this.m_pfj.getDataGridCallback();
            row = grid.getDataAccessRow(pfjRow, pfjColumn);
            column = grid.getDataAccessColumn(pfjRow, pfjColumn);
        } else if (handle instanceof SeriesComponentHandle) {
            handleType = "bi_series_handle";
        } else if (handle instanceof GroupComponentHandle) {
            handleType = "bi_group_handle";
        }
        params = this.m_pfj.getCommonGraph().getDrillParameters(handle);
        if (params != null) {
            drillInfo = new DrillInfo(params[0], params[1], params[2], row, column, handleType, handle.getID(), symbolName + "_inst");
            this.m_drillInfoVect.add(drillInfo);
        } else {
            drillInfo = new DrillInfo(-1, -1, -1, row, column, handleType, handle.getID(), symbolName + "_inst");
            this.m_drillInfoVect.add(drillInfo);
        }
        int mcDepth = this.createSprite(shape, symbolId, this._isDropShadowNeeded(identObj));
        ToolTipObj tooltipObj = null;
        if (tooltipArray != null) {
            tooltipObj = new ToolTipObj(blackBox, identObj, symbolName);
            tooltipObj.setFontMetrics(this.m_graphics);
            tooltipObj.setText(tooltipArray);
            this.m_ttObjs.add(tooltipObj);
        }
        long x = swiffRect.getXMin() / (long)20;
        long y = swiffRect.getYMin() / (long)20;
        this._attachMovieToSprite(symbolName, mcDepth, (int)x, (int)y, tooltipObj, drillInfo);
    }

    private void _drawToolTips(ToolTipObj toolTipObj) {
        String accessibleName = toolTipObj.getText().trim();
        this.m_isToolTip = true;
        Rectangle rect = toolTipObj.getBounds();
        int rectId = this.drawToolTipRectangle(toolTipObj, rect);
        int textBoxId = this.drawToolTipTextBox(toolTipObj, rect);
        toolTipObj.setRectDepth(rectId);
        toolTipObj.setTextBoxDepth(textBoxId);
        this.createSprite(rectId, textBoxId, toolTipObj.getMCSymbolName(), accessibleName);
        this.m_isToolTip = false;
    }

    private double[][] _getDataValues(int size) {
        double data = 0.0;
        double[][] dataValues = new double[size][];
        int i = 0;
        while (i < size) {
            dataValues[i] = new double[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                data = this.m_pfj.getJGraphType().isBarType() || this.m_pfj.getJGraphType().isPieType() ? this.m_pfj.getGraphObject().getDataValue((int)j, (int)i2).m_fValue : this.m_pfj.getGraphObject().getDataValue((int)i2, (int)j).m_fValue;
                dataValues[i2][j] = data;
                ++j;
            }
            ++i2;
        }
        return dataValues;
    }

    private int[][] _getFillAlphaValues(int size) {
        int[][] mcFillAlphaValues = new int[size][];
        int i = 0;
        while (i < size) {
            mcFillAlphaValues[i] = new int[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                mcFillAlphaValues[i2][j] = mcObj != null ? mcObj.getFillAlpha() : 100;
                ++j;
            }
            ++i2;
        }
        return mcFillAlphaValues;
    }

    private int[][] _getFillColorValues(int size) {
        int[][] mcFillColorValues = new int[size][];
        int i = 0;
        while (i < size) {
            mcFillColorValues[i] = new int[this.m_mcObjs[i].size()];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                int chartType;
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                mcFillColorValues[i2][j] = mcObj != null ? mcObj.getFillColor() : (this._isGroupSeriesOrder(chartType = this.getChartType()) ? this.m_pfj.getSeriesFillColor(j).getRGB() : this.m_pfj.getSeriesFillColor(i2).getRGB());
                ++j;
            }
            ++i2;
        }
        return mcFillColorValues;
    }

    private FillStyleArray _getFillStyleArray(BlackBoxIF blackBox, IdentObj identObj, Shape shape) {
        int alpha = -1;
        if (blackBox.getTransparentFillColor() || this.m_pfj.getTransparentFillColor(identObj)) {
            alpha = 0;
        }
        if (!this.m_isToolTip && blackBox.getFillType() == 2 && shape != null && !this._isSliceCrust(identObj)) {
            int gradDirection = 0;
            FillObj fillObj = blackBox.getFillObj();
            gradDirection = fillObj != null && fillObj instanceof FillGradientObj ? ((FillGradientObj)fillObj).getDirection() : this.m_pfj.getGradientDirection(blackBox.getIdentObj());
            if (gradDirection == 1) {
                return this._getFillStyleArray(blackBox, identObj, shape, alpha, (short)16);
            }
            if (gradDirection == 9) {
                return this._getFillStyleArray(blackBox, identObj, shape, alpha, (short)18);
            }
            if (gradDirection == 10) {
                return this._getFillStyleArray(blackBox, identObj, shape, alpha, (short)16);
            }
            if (gradDirection == 3) {
                return this._getFillStyleArray(blackBox, identObj, shape, alpha, (short)16);
            }
            Color col = this.m_pfj.getFillColor(blackBox.getIdentObj());
            return this.getFillStyleArray(col, alpha);
        }
        Color col = blackBox.getFillColor();
        if (col == null) {
            col = new Color(255, 255, 255);
            alpha = 0;
        } else if (alpha == -1) {
            alpha = col.getAlpha();
        }
        if (identObj.getObjectID() == 626 && identObj.getMiscID() == 623 && !this.m_pfj.getFunnelGradientEffect()) {
            col = this.m_pfj.getFillColor(this.m_pfj.getFunnelFrame());
            col = this.m_pfj.getDarker(col);
        }
        if (this.m_isToolTip) {
            col = new Color(255, 255, 255);
            alpha = 205;
        }
        return this.getFillStyleArray(col, alpha);
    }

    private FillStyleArray _getFillStyleArray(BlackBoxIF blackBox, IdentObj identObj, Shape shape, int alpha, short type) {
        Color[] gradColors = null;
        int[] ratios = null;
        int numOfPins = 0;
        FillObj fillObj = blackBox.getFillObj();
        List pins = null;
        if (fillObj != null && fillObj instanceof FillGradientObj) {
            pins = ((FillGradientObj)fillObj).getPins();
            numOfPins = pins.size();
        } else {
            numOfPins = this.m_pfj.getGradientNumPins(blackBox.getIdentObj());
        }
        Rectangle2D rect2d = this._getGradientRectangle(shape, identObj);
        Point2D point = this._getGradientRectXY(shape, identObj, rect2d);
        if ((identObj.getObjectID() == 298 || identObj.getObjectID() == 332) && this.m_pfj.isChartPieRing()) {
            gradColors = new Color[3];
            ratios = new int[3];
            gradColors[0] = new Color(0, 0, 51, 255);
            gradColors[1] = this.m_pfj.getGradientPinLeftColor(blackBox.getIdentObj(), 0);
            gradColors[2] = this.m_pfj.getDarker(this.m_pfj.getGradientPinLeftColor(blackBox.getIdentObj(), 1));
            ratios[0] = 0;
            ratios[1] = 180;
            ratios[2] = 255;
        } else {
            gradColors = new Color[numOfPins];
            ratios = new int[numOfPins];
            int i = 0;
            while (i < numOfPins) {
                ColorPinObj colorPinObj = null;
                if (pins != null) {
                    colorPinObj = (ColorPinObj)pins.get(i);
                }
                gradColors[i] = colorPinObj == null ? this.m_pfj.getGradientPinLeftColor(blackBox.getIdentObj(), i) : colorPinObj.getLeftColor().getColor();
                ratios[i] = i * (255 / (numOfPins - 1));
                ++i;
            }
        }
        int gradDirection = 0;
        gradDirection = fillObj != null && fillObj instanceof FillGradientObj ? ((FillGradientObj)fillObj).getDirection() : this.m_pfj.getGradientDirection(blackBox.getIdentObj());
        if (gradDirection == 3) {
            this.m_vertGradient = true;
            return this.getFillStyleArray(alpha, type, ratios, gradColors, rect2d, point, -3);
        }
        return this.getFillStyleArray(alpha, type, ratios, gradColors, rect2d, point, -1);
    }

    private int _getFillStyleIndex(IdentObj identObj) {
        int fillStyleIndex = 0;
        if (identObj.getObjectID() == 620 || identObj.getObjectID() == 621) {
            fillStyleIndex = !this.m_vertGradient ? 1 : 2;
        } else if (identObj.getObjectID() == 626) {
            if (identObj.getMiscID() == 623) {
                fillStyleIndex = 1;
            }
        } else if (!this._isLine(identObj)) {
            if (!this.m_vertGradient) {
                fillStyleIndex = 1;
            } else {
                this.m_vertGradient = false;
                fillStyleIndex = 3;
            }
        }
        return fillStyleIndex;
    }

    private Rectangle2D _getGradientRectangle(Shape shape, IdentObj identObj) {
        if (this.m_pfj.isFunnel() && identObj.getObjectID() == 621 && this.m_boundingRect != null) {
            return this.m_boundingRect;
        }
        if (identObj.getObjectID() == 298 || identObj.getObjectID() == 332) {
            if (this.m_pfj.isChartPieRing()) {
                return this.m_boundingRect;
            }
            return shape.getBounds();
        }
        return shape.getBounds2D();
    }

    private Point2D _getGradientRectXY(Shape shape, IdentObj identObj, Rectangle2D rect2d) {
        double x = 0.0;
        double y = 0.0;
        if (this._isIntelligentComponent(identObj)) {
            if (identObj.getObjectID() == 298 || identObj.getObjectID() == 332) {
                x = rect2d.getX() - shape.getBounds2D().getX();
                y = rect2d.getY() - shape.getBounds2D().getY();
            } else if (this.m_pfj.isFunnel() && identObj.getObjectID() == 621 && this.m_boundingRect != null) {
                x = this.m_boundingRect.getX() - shape.getBounds2D().getX();
                y = this.m_boundingRect.getY() - shape.getBounds2D().getY();
            } else {
                x = 0.0;
                y = 0.0;
            }
        } else {
            x = (int)rect2d.getX();
            y = (int)rect2d.getY();
        }
        return new Point2D.Double(x, y);
    }

    private LineStyleArray _getLineStyleArray(BlackBoxIF blackBox, IdentObj identObj) {
        return this._getLineStyleArray(blackBox, identObj, -1);
    }

    private LineStyleArray _getLineStyleArray(BlackBoxIF blackBox, IdentObj identObj, int width) {
        Color col = blackBox.getBorderColor();
        int alpha = -1;
        alpha = !(identObj.getObjectID() == 258 || identObj.getObjectID() == 13 && this.m_pfj.isLegendALine() && !this.m_pfj.getMarkerDisplay() || !blackBox.getTransparentBorderColor() && !this.m_pfj.getTransparentBorderColor(identObj)) ? 0 : col.getAlpha();
        if (this.m_isToolTip) {
            col = identObj.getObjectID() == 331 ? blackBox.getFillColor() : (identObj.getObjectID() == 474 ? blackBox.getFillColor() : (this.m_pfj.isChartStockType() ? blackBox.getFillColor() : (identObj.getObjectID() == 606 ? blackBox.getFillColor() : this.m_pfj.getSeriesFillColor(identObj.getSeriesID()))));
            width = 3;
            alpha = 255;
        }
        if (col == null) {
            col = new Color(255, 255, 255);
            alpha = 0;
        } else if (alpha != 0 && !this.m_isToolTip) {
            alpha = col.getAlpha();
        }
        if (width == -1) {
            width = identObj.getObjectID() == 626 || identObj.getObjectID() == 620 || identObj.getObjectID() == 621 ? (identObj.getMiscID() == 623 ? this.m_pfj.getLineWidth(this.m_pfj.getFunnelFrame()) : this.m_pfj.getLineWidth(blackBox.getIdentObj())) : this.m_pfj.getLineWidth(identObj);
        }
        if (this.m_isToolTip) {
            return this.getLineStyleArray(col, alpha, width, false);
        }
        return this.getLineStyleArray(col, alpha, width, this._isDefineShape4Needed(identObj));
    }

    private int _getLineStyleIndex(IdentObj identObj) {
        int lineStyleIndex = 0;
        if (identObj.getObjectID() == 620 || identObj.getObjectID() == 621) {
            if (this.m_isToolTip) {
                lineStyleIndex = 1;
            }
        } else if (identObj.getObjectID() == 626) {
            lineStyleIndex = identObj.getMiscID() == 623 ? 1 : 1;
        } else if (this._isBorderNeeded(identObj)) {
            lineStyleIndex = 1;
        }
        return lineStyleIndex;
    }

    private boolean _isBorderNeeded(IdentObj identObj) {
        if (this.m_isToolTip) {
            return true;
        }
        if (this.m_pfj.isChart3DType()) {
            return false;
        }
        int objId = identObj.getObjectID();
        switch (objId) {
            case 13: {
                if (this.m_pfj.isLegendALine() && !this.m_pfj.getMarkerDisplay()) {
                    if (this.m_pfj.isChartCombo()) {
                        if (this.m_pfj.getSeriesType(identObj.getSeriesID()) == 2) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
            }
            case 256: 
            case 277: 
            case 298: 
            case 331: 
            case 332: {
                return false;
            }
            case 259: {
                if (this.m_pfj.getCommonGraph().is3DEffect()) {
                    return true;
                }
            }
            case 73: 
            case 279: 
            case 310: 
            case 319: 
            case 320: {
                return false;
            }
            case 269: 
            case 283: 
            case 287: {
                if (this.m_pfj.getTransparentFillColor(this.m_pfj.getFrame())) {
                    return true;
                }
            }
            case 15: 
            case 16: {
                if (this.m_pfj.getTransparentFillColor(identObj)) {
                    return true;
                }
            }
            case 299: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 333: 
            case 334: 
            case 335: {
                return false;
            }
        }
        return true;
    }

    private boolean _isClosingLIneNeeded(IdentObj identObj) {
        int id = identObj.getObjectID();
        if (this._isSliceCrust(identObj)) {
            return true;
        }
        switch (id) {
            case 334: 
            case 335: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _isDefineShape4Needed(IdentObj identObj) {
        int objId = identObj.getObjectID();
        switch (objId) {
            case 258: 
            case 303: 
            case 307: 
            case 321: 
            case 322: {
                return true;
            }
            case 473: {
                return !this.m_pfj.getCommonGraph().is3DEffect();
            }
            case 13: {
                if (!this.m_pfj.isLegendALine() || this.m_pfj.getMarkerDisplay()) return false;
                if (!this.m_pfj.isChartCombo()) return true;
                if (this.m_pfj.getSeriesType(identObj.getSeriesID()) == 2) {
                    return true;
                }
            }
            case 285: {
                if (!this.m_pfj.getJGraphType().isRadarType()) return false;
                return true;
            }
        }
        return false;
    }

    private boolean _isDropShadowNeeded(IdentObj identObj) {
        int objId = identObj.getObjectID();
        if (this.m_pfj.getCommonGraph().is3DEffect() || this.m_pfj.isChart3DType()) {
            return false;
        }
        switch (objId) {
            case 258: 
            case 277: 
            case 331: {
                return true;
            }
            case 259: {
                return this.m_pfj.isChartBubble();
            }
            case 256: 
            case 303: 
            case 310: 
            case 319: 
            case 320: 
            case 473: 
            case 620: {
                return true;
            }
        }
        return false;
    }

    private boolean _isExported(IdentObj identObj) {
        int objId = identObj.getObjectID();
        switch (objId) {
            case 15: 
            case 16: 
            case 299: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 316: 
            case 621: {
                return false;
            }
        }
        return true;
    }

    private boolean _isIntelligentComponent(IdentObj identObj) {
        int objId = identObj.getObjectID();
        switch (objId) {
            case 256: 
            case 258: 
            case 259: 
            case 270: 
            case 277: 
            case 284: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 298: 
            case 299: 
            case 303: 
            case 307: 
            case 310: 
            case 312: 
            case 313: 
            case 315: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 331: 
            case 332: 
            case 473: 
            case 474: 
            case 606: 
            case 621: 
            case 622: 
            case 623: 
            case 626: {
                return true;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                return this.m_bRenderDynamic;
            }
        }
        return false;
    }

    private boolean _isDrillableComponent(IdentObj identObj) {
        int objId = identObj.getObjectID();
        switch (objId) {
            case 259: 
            case 277: 
            case 298: 
            case 299: 
            case 300: 
            case 303: 
            case 306: 
            case 307: 
            case 308: 
            case 310: 
            case 312: 
            case 313: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 474: 
            case 606: 
            case 621: {
                return true;
            }
        }
        return false;
    }

    private boolean _isLine(IdentObj identObj) {
        int objId = identObj.getObjectID();
        switch (objId) {
            case 2: {
                return identObj.getMiscID() > 100;
            }
            case 17: 
            case 258: 
            case 269: 
            case 271: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 289: 
            case 290: 
            case 294: 
            case 301: 
            case 303: 
            case 307: 
            case 308: 
            case 321: 
            case 322: 
            case 388: {
                return true;
            }
            case 473: {
                if (this.m_pfj.getCommonGraph().is3DEffect()) {
                    return false;
                }
            }
            case 281: 
            case 292: 
            case 293: 
            case 328: {
                return true;
            }
        }
        return false;
    }

    private boolean _isSliceCrust(IdentObj identObj) {
        int id = identObj.getObjectID();
        switch (id) {
            case 299: 
            case 333: {
                return true;
            }
        }
        return false;
    }

    protected void asPush3DContext(ConstantPool cp, DoAction updatedActions) {
        ActionScript.pushPrimitiveVal(cp, updatedActions, "has3DEffect", new Boolean(this.is3DEffect()));
        Point pt = this.m_pfj.getFrameDepthOffset();
        int dx = this.m_vc.virtToDestWidth(pt.x);
        int dy = this.m_vc.virtToDestHeight(pt.y);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "depthX", new Integer(dx));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "depthY", new Integer(dy));
    }

    private void _pushGroupLabels(ConstantPool cp, DoAction updatedActions) {
        if (this.m_groupLabels != null) {
            Font font = this.m_groupLabels.getFont();
            String fontName = font.getFontName();
            if (fontName.equalsIgnoreCase("SansSerif.plain") || fontName.equalsIgnoreCase("SansSerif.bold") || fontName.equalsIgnoreCase("SansSerif.italic") || fontName.equalsIgnoreCase("SansSerif.bolditalic")) {
                fontName = "_sans";
            }
            if (fontName.equalsIgnoreCase("Dialog.plain") || fontName.equalsIgnoreCase("Dialog.bold") || fontName.equalsIgnoreCase("Dialog.italic") || fontName.equalsIgnoreCase("Dialog.bolditalic")) {
                fontName = "Arial";
            }
            ActionScript.pushPrimitiveVal(cp, updatedActions, "groupLabelFontName", fontName);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "groupLabelBold", new Boolean(font.isBold()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "groupLabelItalic", new Boolean(font.isItalic()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "groupLabelUnderline", new Boolean(this.m_groupLabels.isUnderline()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "groupLabelFontHeight", new Integer(this.m_groupLabels.getFontHeight()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "groupLabelFontColor", new Integer(this.m_groupLabels.getFontColor()));
            this._pushGroupLabelXArray(cp, updatedActions, "groupLabelXArray");
            this._pushGroupLabelYArray(cp, updatedActions, "groupLabelYArray");
            if (!this.m_pfj.isPie()) {
                this._rePopulateGroupLabelsText();
            }
            this._pushGroupLabelTextArray(cp, updatedActions, "groupLabelTextArray");
        }
    }

    private void _rePopulateGroupLabelsText() {
        DataCallback grid = this.m_pfj.getDataGridCallback();
        int numColumns = grid.getColumns();
        int i = 0;
        while (i < numColumns) {
            this.m_groupLabels.setText(i, grid.columnLabel(i).toString(), this.m_groupLabels.getBounds(i));
            ++i;
        }
    }

    private void _pushGroupLabelTextArray(ConstantPool cp, DoAction doAction, String groupLabelTextArray) {
        String[] groupLabelText = new String[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            String groupLabel = this.m_groupLabels.getText(i);
            if (this.m_commonGraph.isMetadataDateSupported()) {
                groupLabel = ChartHelper.formatDate(groupLabel, this.m_commonGraph.getTimeAxisDateFormat(0), this.m_commonGraph.getTimeAxisDateFormat(4), this.m_commonGraph.getTimeAxisDateFormat(1), this.m_commonGraph.getTimeAxisDateFormat(2), this.m_commonGraph.getTimeAxisDateFormat(3));
            }
            groupLabelText[i] = this.isBidiRequired() ? ChartHelper.applyBidi(groupLabel) : groupLabel;
            ++i;
        }
        ActionScript.createArray(cp, doAction, groupLabelTextArray, groupLabelText);
    }

    private void _pushGroupLabelXArray(ConstantPool cp, DoAction doAction, String groupLabelXArray) {
        int[] groupLabelXValues = new int[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            if (this.m_groupLabels.getBounds(i) != null) {
                groupLabelXValues[i] = this.m_groupLabels.getBounds((int)i).x;
            }
            ++i;
        }
        ActionScript.createArray(cp, doAction, groupLabelXArray, groupLabelXValues);
    }

    private void _pushGroupLabelYArray(ConstantPool cp, DoAction doAction, String groupLabelYArray) {
        int[] groupLabelYValues = new int[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            if (this.m_groupLabels.getBounds(i) != null) {
                groupLabelYValues[i] = this.m_groupLabels.getBounds((int)i).y;
            }
            ++i;
        }
        ActionScript.createArray(cp, doAction, groupLabelYArray, groupLabelYValues);
    }

    private void _pushLegendMarkerXArray(ConstantPool cp, DoAction doAction, String legendMarkerXArray) {
        int[] legendMarkerXValues = new int[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            legendMarkerXValues[i] = this.m_legend.getMarkerX(i);
            ++i;
        }
        ActionScript.createArray(cp, doAction, legendMarkerXArray, legendMarkerXValues);
    }

    private void _pushLegendMarkerYArray(ConstantPool cp, DoAction doAction, String legendMarkerYArray) {
        int[] legendMarkerYValues = new int[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            legendMarkerYValues[i] = this.m_legend.getMarkerY(i);
            ++i;
        }
        ActionScript.createArray(cp, doAction, legendMarkerYArray, legendMarkerYValues);
    }

    protected void pushLegends(ConstantPool cp, DoAction updatedActions) {
        if (this.m_legend != null) {
            Font font = this.m_legend.getFont();
            String fontName = font.getFontName();
            if (fontName.equalsIgnoreCase("SansSerif.plain") || fontName.equalsIgnoreCase("SansSerif.bold") || fontName.equalsIgnoreCase("SansSerif.italic") || fontName.equalsIgnoreCase("SansSerif.bolditalic")) {
                fontName = "_sans";
            }
            if (fontName.equalsIgnoreCase("Dialog.plain") || fontName.equalsIgnoreCase("Dialog.bold") || fontName.equalsIgnoreCase("Dialog.italic") || fontName.equalsIgnoreCase("Dialog.bolditalic")) {
                fontName = "Arial";
            }
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendFontName", fontName);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendBold", new Boolean(font.isBold()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendItalic", new Boolean(font.isItalic()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendUnderline", new Boolean(this.m_legend.isUnderline()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendFontHeight", new Integer(this.m_legend.getFontHeight()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendFontColor", new Integer(this.m_legend.getFontColor()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendX", new Integer(this.m_legend.getAreaRect().x));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendY", new Integer(this.m_legend.getAreaRect().y));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendWidth", new Integer(this.m_legend.getAreaRect().width));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendHeight", new Integer(this.m_legend.getAreaRect().height));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendBorderWidth", new Integer(this.m_legend.getBorderWidth()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendBorderColor", new Integer(this.m_legend.getBorderColor()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendBorderAlpha", new Integer(this.m_legend.getBorderAlpha()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendFillColor", new Integer(this.m_legend.getFillColor()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendFillAlpha", new Integer(this.m_legend.getFillAlpha()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendMarkerWidth", new Integer(this.m_legend.getMarkerWidth()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendMarkerHeight", new Integer(this.m_legend.getMarkerHeight()));
            this._pushLegendMarkerXArray(cp, updatedActions, "legendMarkerX");
            this._pushLegendMarkerYArray(cp, updatedActions, "legendMarkerY");
            this._pushLegendTextXArray(cp, updatedActions, "legendTextX");
            this._pushLegendTextYArray(cp, updatedActions, "legendTextY");
            this._pushLegendTextArray(cp, updatedActions, "legendText");
            this._pushLegendMarkerShapesArray(cp, updatedActions, "legendMarkerShape");
            int automaticPlacement = this.m_pfj.getIntegerProp(Attr.AutomaticPlacement);
            int legendPosition = automaticPlacement == 1 ? this.m_commonGraph.getLegendArea().getAutomaticPosition() : this.m_pfj.getIntegerProp(Attr.LegendPosition);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendPosition", new Integer(legendPosition));
            int legendRows = this.m_pfj.getLegendObj().getNumOfRows();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendRows", new Integer(legendRows));
            int legendCols = this.m_pfj.getLegendObj().getNumOfCols();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "legendCols", new Integer(legendCols));
        } else {
            this._pushLegendTextArray(cp, updatedActions, "legendText");
        }
    }

    private void _pushLegendTextArray(ConstantPool cp, DoAction doAction, String legendTextArray) {
        String[] legendText = new String[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            legendText[i] = this.m_legend != null ? (this.isBidiRequired() ? ChartHelper.applyBidi(this.m_legend.getText(i)) : this.m_legend.getText(i)) : (this.isBidiRequired() ? ChartHelper.applyBidi(this.m_pfj.getSeriesLabel(i)) : this.m_pfj.getSeriesLabel(i));
            ++i;
        }
        ActionScript.createArray(cp, doAction, legendTextArray, legendText);
    }

    private void _pushLegendTextXArray(ConstantPool cp, DoAction doAction, String legendTextXArray) {
        int[] legendTextXValues = new int[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            if (this.m_legend.getTextBounds(i) != null) {
                legendTextXValues[i] = this.m_legend.getTextBounds((int)i).x;
            }
            ++i;
        }
        ActionScript.createArray(cp, doAction, legendTextXArray, legendTextXValues);
    }

    private void _pushLegendTextYArray(ConstantPool cp, DoAction doAction, String legendTextYArray) {
        int[] legendTextYValues = new int[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            if (this.m_legend.getTextBounds(i) != null) {
                legendTextYValues[i] = this.m_legend.getTextBounds((int)i).y;
            }
            ++i;
        }
        ActionScript.createArray(cp, doAction, legendTextYArray, legendTextYValues);
    }

    private void _pushLegendMarkerShapesArray(ConstantPool cp, DoAction doAction, String legendMarkerShapesArray) {
        int[] legendMarkersShapesValues = new int[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            legendMarkersShapesValues[i] = this.m_legend.getMarkerShape(i);
            ++i;
        }
        ActionScript.createArray(cp, doAction, legendMarkerShapesArray, legendMarkersShapesValues);
    }

    private boolean _isGroupSeriesOrder(int chartType) {
        switch (chartType) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected String getIntlString(String key) {
        ResourceBundle rBundle = this.m_pfj.getResourceBundle();
        return this.m_pfj.getIntlString(key, rBundle);
    }

    protected boolean includeRendererAsset(String asset) {
        return asset.equals("__Packages.ChartRenderer") || asset.equals("__Packages.FrameObj") || this.m_legend != null && asset.equals("__Packages.Legends");
    }

    protected boolean isBidiRequired() {
        return ChartHelper.isBidiRequired(this.m_pfj.getLocale());
    }

    protected abstract void createMCObjArray();

    protected abstract int getChartType();

    protected abstract void populateMCDrawProperties(BlackBoxIF var1, IdentObj var2, Perspective var3, Shape var4, int var5);
}

