/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Vector;
import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.BLAChartRenderer;
import oracle.dss.graph.flash.MovieClipObj;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.util.ChartHelper;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;

public class ComboChartRenderer
extends BLAChartRenderer {
    private boolean m_bDownGradient;

    public ComboChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document, vc, renderDynamic, pfj);
    }

    protected void asPushGradientProperties(ConstantPool cp, DoAction doAction) {
        super.asPushGradientProperties(cp, doAction);
        ActionScript.createAndInitializeGlobalVar(cp, doAction, "isDownGradient", new Boolean(this.m_bDownGradient));
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        super.createChartContext(cp, updatedActions);
        this.asCreateDataArray(cp, updatedActions, "dataArray", this.m_numSeries);
        this.asCreateFillColorArray(cp, updatedActions, "fillColorArray", this.m_numSeries);
        this.asCreateFillAlphaArray(cp, updatedActions, "fillAlphaArray", this.m_numSeries);
        this._asPushSeriesTypeArray(cp, updatedActions, "seriesType");
        this.pushSeriesLabels(cp, updatedActions);
    }

    protected void createMCObjArray() {
        this.m_mcObjs = new Vector[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            this.m_mcObjs[i] = new Vector();
            if (this.isSeriesTypeBar(i)) {
                this.m_mcObjs[i].setSize(this.m_numGroups);
            } else {
                this.m_mcObjs[i].setSize(this.m_numGroups + 1);
            }
            ++i;
        }
    }

    protected int getChartType() {
        return 3;
    }

    protected boolean includeRendererAsset(String asset) {
        if (super.includeRendererAsset(asset)) {
            return true;
        }
        return asset.equals("__Packages.BLAChartRenderer") || asset.equals("__Packages.ComboChartRenderer") || asset.equals("__Packages.ComboAnimHandler") || asset.equals("__Packages.ComboChartHelper") || asset.equals("__Packages.ComboBarAnimHandler") || asset.equals("__Packages.ComboLineAnimHandler") || asset.equals("__Packages.ComboAreaAnimHandler") || asset.equals("__Packages.ComboBarRenderer") || asset.equals("__Packages.ComboLineRenderer") || asset.equals("__Packages.ComboAreaRenderer") || asset.equals("__Packages.ComboLARenderer") || asset.equals("__Packages.ComboChartSplitter") || this.is3DEffect() && (asset.equals("__Packages.Line3D") || asset.equals("__Packages.Area3D") || asset.equals("__Packages.Bar3D")) || asset.equals("__Packages.Combo3DCalcEngine") || !this.is3DEffect() && (asset.equals("__Packages.Line2D") || asset.equals("__Packages.Area2D")) || asset.equals("__Packages.Bar2D");
    }

    protected void populateMCDrawProperties(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth) {
        MovieClipObj mc = new MovieClipObj(blackBox, identObj, pfj, shape, borderWidth, this.m_bHasGradient);
        mc.calcProperties();
        if (this.m_bHasGradient) {
            boolean bl = this.m_bDownGradient = this.m_pfj.getGradientDirection(blackBox.getIdentObj()) == 3;
        }
        if (this.is3DEffect()) {
            if (identObj.getObjectID() == 259) {
                if (identObj.getMiscID() == 4) {
                    this.m_mcObjs[mc.getSeries()].setElementAt(mc, mc.getGroup());
                }
            } else if (identObj.getObjectID() == 318 && this.m_mcObjs[mc.getSeries()].get(this.m_numGroups) == null) {
                this.m_mcObjs[mc.getSeries()].setElementAt(mc, this.m_numGroups);
            }
        } else if (identObj.getObjectID() == 258) {
            if (this.m_mcObjs[mc.getSeries()].get(this.m_numGroups) == null) {
                this.m_mcObjs[mc.getSeries()].setElementAt(mc, this.m_numGroups);
            }
        } else if (identObj.getObjectID() == 259) {
            this.m_mcObjs[mc.getSeries()].setElementAt(mc, mc.getGroup());
        }
        if (identObj.getObjectID() == 256) {
            this.m_mcObjs[mc.getSeries()].setElementAt(mc, this.m_numGroups);
        } else if (identObj.getObjectID() == 277) {
            this.m_mcObjs[mc.getSeries()].setElementAt(mc, mc.getGroup());
        }
    }

    private void _asPushSeriesTypeArray(ConstantPool cp, DoAction doAction, String seriesType) {
        int[] seriesTypes = this._createSeriesTypeArray();
        ActionScript.createArray(cp, doAction, seriesType, seriesTypes);
    }

    private int[] _createSeriesTypeArray() {
        int[] mcSeriesType = new int[this.m_numSeries];
        int i = 0;
        while (i < this.m_numSeries) {
            if (this.isSeriesTypeBar(i)) {
                mcSeriesType[i] = 0;
            } else if (this.isSeriesTypeArea(i)) {
                mcSeriesType[i] = 2;
            } else if (this.isSeriesTypeLine(i)) {
                mcSeriesType[i] = 1;
            }
            ++i;
        }
        return mcSeriesType;
    }

    protected int[][] getMCHeightValues() {
        int[][] mcHeightValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcHeightValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcHeightValues[i2][j] = ((Rectangle)shape).height;
                    } else if (shape instanceof Line2D) {
                        mcHeightValues[i2][j] = ((Line2D)shape).getBounds().height;
                    } else if (shape instanceof Polygon) {
                        mcHeightValues[i2][j] = ((Polygon)shape).getBounds().height;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcHeightValues;
    }

    protected int[][] getMCWidthValues() {
        int[][] mcWidthValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcWidthValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcWidthValues[i2][j] = ((Rectangle)shape).width;
                    } else if (shape instanceof Line2D) {
                        mcWidthValues[i2][j] = mcObj.getBorderWidth();
                    } else if (shape instanceof Polygon) {
                        mcWidthValues[i2][j] = ((Polygon)shape).getBounds().width;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcWidthValues;
    }

    protected int[][] getXValues() {
        int[][] mcXMinValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcXMinValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcXMinValues[i2][j] = ((Rectangle)shape).x;
                    } else if (shape instanceof Line2D) {
                        Line2D line = (Line2D)shape;
                        mcXMinValues[i2][j] = (int)line.getP1().getX();
                    } else if (shape instanceof Polygon) {
                        mcXMinValues[i2][j] = ((Polygon)shape).getBounds().x;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcXMinValues;
    }

    protected int[][] getYValues() {
        int[][] mcYMinValues = new int[this.m_numSeries][];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcYMinValues[i] = new int[this.m_mcObjs[i].size()];
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_mcObjs.length) {
            int j = 0;
            while (j < this.m_mcObjs[i2].size()) {
                MovieClipObj mcObj = (MovieClipObj)this.m_mcObjs[i2].elementAt(j);
                if (mcObj != null) {
                    Shape shape = mcObj.getShape();
                    if (shape instanceof Rectangle) {
                        mcYMinValues[i2][j] = ((Rectangle)shape).y;
                    } else if (shape instanceof Line2D) {
                        Line2D line = (Line2D)shape;
                        mcYMinValues[i2][j] = (int)line.getP1().getY();
                    } else if (shape instanceof Polygon) {
                        mcYMinValues[i2][j] = ((Polygon)shape).getBounds().y;
                    }
                }
                ++j;
            }
            ++i2;
        }
        return mcYMinValues;
    }

    private boolean isSeriesTypeArea(int seriesID) {
        return this.m_pfj.getSeriesType(seriesID) == 3;
    }

    private boolean isSeriesTypeBar(int seriesID) {
        return this.m_pfj.getSeriesType(seriesID) == 1;
    }

    private boolean isSeriesTypeLine(int seriesID) {
        return this.m_pfj.getSeriesType(seriesID) == 2;
    }

    private void pushSeriesLabels(ConstantPool cp, DoAction doAction) {
        String[] seriesLabels = ChartHelper.generateSeriesLabels(this.m_pfj);
        ActionScript.createArray(cp, doAction, "seriesLabels", seriesLabels);
    }
}

