/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.flash.ChartConstants;
import oracle.dss.graph.flash.ToolTipActionScript;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFReader;
import oracle.dss.graph.flash.jswiff.hl.factories.ImageDocumentFactory;
import oracle.dss.graph.flash.jswiff.listeners.SWFDocumentReader;
import oracle.dss.graph.flash.jswiff.swfrecords.AlphaBitmapData;
import oracle.dss.graph.flash.jswiff.swfrecords.CurvedEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.DropShadowFilter;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.GradRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.Gradient;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyle2;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Matrix;
import oracle.dss.graph.flash.jswiff.swfrecords.RGBA;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.ShapeWithStyle;
import oracle.dss.graph.flash.jswiff.swfrecords.StraightEdgeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.StyleChangeRecord;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.Action;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsJPEG2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineBitsLossless2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineEditText;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineFont2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineShape4;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefineSprite;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DefinitionTag;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoInitAction;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ExportAssets;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject2;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.PlaceObject3;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.ShowFrame;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.Tag;
import oracle.dss.graph.flash.jswiff.util.ImageUtilities;
import oracle.dss.graph.flash.util.ChartHelper;
import oracle.dss.graph.flash.util.CurveHelper;

public abstract class FlashRenderer {
    protected final int GUTTER_ADJUSTMENT;
    protected SWFDocument m_document;
    protected Vector[] m_mcObjs;
    protected SWFDocument m_resourceDoc;
    private boolean m_animationEnabled;
    private double m_lastX;
    private double m_lastY;
    private Vector m_shapeRecords;

    private void $init$() {
        this.GUTTER_ADJUSTMENT = 2;
        this.m_mcObjs = null;
    }

    protected FlashRenderer(SWFDocument document) {
        this.$init$();
        this.m_document = document;
    }

    public void enableAnimation(boolean enableAnimation) {
        this.m_animationEnabled = enableAnimation;
    }

    public boolean isFlashAnimationOn() {
        return this.m_animationEnabled;
    }

    protected void addToDisplay(int id, Matrix m, boolean dropShadowNeeded) {
        PlaceObject3 placeObject3 = new PlaceObject3(id);
        placeObject3.setCharacterId(id);
        if (m != null) {
            placeObject3.setMatrix(m);
        }
        if (dropShadowNeeded) {
            placeObject3.setFilters(this._getFilterList());
        }
        this.m_document.addTag(placeObject3);
        if (this.isFlashAnimationOn()) {
            this.m_document.addTag(new ShowFrame());
        }
    }

    protected void asAttachMovieAndSetStageLocation(ToolTipActionScript actionScript, String mcSymbolId, int mcDepth, long x, long y) {
        String mcInstVar = "mc_inst_var";
        actionScript.addConstant(mcInstVar);
        String targetObj = "this";
        actionScript.addConstant(targetObj);
        String mcInstName = mcSymbolId + "_inst";
        actionScript.attachMovie(mcInstVar, targetObj, mcSymbolId, mcInstName, mcDepth, null);
        actionScript.setMCXY(mcInstVar, (int)x, (int)y);
    }

    protected void attachMovieToSprite(String mcSymbolId, int mcDepth, long x, long y) {
        ToolTipActionScript actionScript = new ToolTipActionScript(this.m_document);
        actionScript.startDoAction();
        this.asAttachMovieAndSetStageLocation(actionScript, mcSymbolId, mcDepth, x, y);
        actionScript.endAction();
    }

    protected int createSprite(DefinitionTag shape, String mcSymbolID, boolean dropShadowNeeded) {
        int charId = shape.getCharacterId();
        String symbolName = mcSymbolID + charId;
        int id = this.m_document.getNewCharacterId();
        DefineSprite sprite = new DefineSprite(id);
        PlaceObject3 placeObject3 = new PlaceObject3(id);
        placeObject3.setCharacterId(charId);
        if (dropShadowNeeded) {
            placeObject3.setFilters(this._getFilterList());
        }
        sprite.addControlTag(placeObject3);
        sprite.addControlTag(new ShowFrame());
        this.m_document.addTag(sprite);
        ExportAssets.ExportMapping[] expMapping = new ExportAssets.ExportMapping[]{new ExportAssets.ExportMapping(id, symbolName)};
        ExportAssets expAsset = new ExportAssets(expMapping);
        this.m_document.addTag(expAsset);
        if (this.isFlashAnimationOn()) {
            this.m_document.addTag(new ShowFrame());
        }
        return id;
    }

    protected void createSprite(int id1, int id2, String symbolName, String accessibleName) {
        int id = this.m_document.getNewCharacterId();
        DefineSprite sprite = new DefineSprite(id);
        PlaceObject3 placeObject3 = new PlaceObject3(id1);
        placeObject3.setCharacterId(id1);
        placeObject3.setFilters(this._getFilterList());
        sprite.addControlTag(placeObject3);
        placeObject3 = new PlaceObject3(id2);
        placeObject3.setCharacterId(id2);
        placeObject3.setName(accessibleName);
        placeObject3.setMatrix(new Matrix(0, 0));
        sprite.addControlTag(placeObject3);
        sprite.addControlTag(new ShowFrame());
        this.m_document.addTag(sprite);
        ExportAssets.ExportMapping[] expMapping = new ExportAssets.ExportMapping[]{new ExportAssets.ExportMapping(id, symbolName)};
        ExportAssets expAsset = new ExportAssets(expMapping);
        this.m_document.addTag(expAsset);
    }

    protected FillStyleArray getFillStyleArray(Color fillColor, int alpha) {
        if (fillColor == null) {
            fillColor = new Color(255, 255, 255);
        }
        if (alpha < 0) {
            alpha = fillColor.getAlpha();
        }
        RGBA rgba = new RGBA((short)fillColor.getRed(), (short)fillColor.getGreen(), (short)fillColor.getBlue(), (short)alpha);
        FillStyle fillStyle = new FillStyle(rgba);
        FillStyleArray fsArray = new FillStyleArray();
        fsArray.addStyle(fillStyle);
        return fsArray;
    }

    protected FillStyleArray getFillStyleArray(int alpha, short type, int[] ratios, Color[] gradColors, Rectangle2D gradBounds, Point2D pointXY, int direction) {
        FillStyleArray fsArray = new FillStyleArray();
        Color gradColor = null;
        RGBA rgba = null;
        Matrix gradMatrix = null;
        FillStyle fillStyle = null;
        if (pointXY == null) {
            pointXY = new Point2D.Double(gradBounds.getX(), gradBounds.getY());
        }
        double x = pointXY.getX() * 20.0;
        double y = pointXY.getY() * 20.0;
        double width = gradBounds.getWidth() * 20.0;
        double height = gradBounds.getHeight() * 20.0;
        double xFactor = width / 32768.0;
        double yFactor = height / 32768.0;
        int numOfPins = gradColors.length;
        GradRecord[] gradientRecord = new GradRecord[numOfPins];
        int i = 0;
        while (i < numOfPins) {
            gradColor = gradColors[i];
            if (alpha != 0) {
                alpha = gradColor.getAlpha();
            }
            rgba = new RGBA((int)((short)gradColor.getRed()), (int)((short)gradColor.getGreen()), (int)((short)gradColor.getBlue()), alpha);
            gradientRecord[i] = new GradRecord((short)ratios[i], rgba);
            ++i;
        }
        Gradient gradient = new Gradient(gradientRecord);
        if (direction == -3) {
            gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
            gradMatrix.setScale(xFactor, yFactor);
            gradMatrix.setRotateSkew(0.0, 0.0);
            fillStyle = new FillStyle(gradient, gradMatrix, type);
            fsArray.addStyle(fillStyle);
            gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
            gradMatrix.setScale(0.0, 0.0);
            gradMatrix.setRotateSkew(xFactor, -yFactor);
            fillStyle = new FillStyle(gradient, gradMatrix, type);
            fsArray.addStyle(fillStyle);
            gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
            gradMatrix.setScale(0.0, 0.0);
            gradMatrix.setRotateSkew(yFactor, -yFactor);
            fillStyle = new FillStyle(gradient, gradMatrix, type);
            fsArray.addStyle(fillStyle);
        } else {
            gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
            gradMatrix.setScale(xFactor, yFactor);
            fillStyle = new FillStyle(gradient, gradMatrix, type);
            fsArray.addStyle(fillStyle);
        }
        return fsArray;
    }

    protected FillStyleArray getFillStyleArray(int alpha, short type, int[] ratios, Color[] gradColors, Rectangle2D gradBounds, Point2D pointXY, int direction, double angle) {
        Color gradColor = null;
        RGBA rgba = null;
        if (pointXY == null) {
            pointXY = new Point2D.Double(gradBounds.getX(), gradBounds.getY());
        }
        double x = pointXY.getX() * 20.0;
        double y = pointXY.getY() * 20.0;
        double width = gradBounds.getWidth() * 20.0;
        double height = gradBounds.getHeight() * 20.0;
        double xFactor = width / 32768.0;
        double yFactor = height / 32768.0;
        int numOfPins = gradColors.length;
        GradRecord[] gradientRecord = new GradRecord[numOfPins];
        int i = 0;
        while (i < numOfPins) {
            gradColor = gradColors[i];
            if (alpha == -1) {
                alpha = gradColor.getAlpha();
            }
            rgba = new RGBA((int)((short)gradColor.getRed()), (int)((short)gradColor.getGreen()), (int)((short)gradColor.getBlue()), alpha);
            gradientRecord[i] = new GradRecord((short)ratios[i], rgba);
            ++i;
        }
        Gradient gradient = new Gradient(gradientRecord);
        double theta = angle / 180.0 * Math.PI;
        Matrix gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
        gradMatrix.setScale(xFactor, yFactor);
        gradMatrix.setRotateSkew(0.0, 0.0);
        FillStyle fillStyle = new FillStyle(gradient, gradMatrix, 16);
        FillStyleArray fsArray = new FillStyleArray();
        fsArray.addStyle(fillStyle);
        gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
        gradMatrix.setScale(xFactor * Math.cos(theta), yFactor * Math.cos(theta));
        gradMatrix.setRotateSkew(xFactor * Math.sin(theta), -yFactor * Math.sin(theta));
        fillStyle = new FillStyle(gradient, gradMatrix, 16);
        fsArray.addStyle(fillStyle);
        gradMatrix = new Matrix((int)(x + width / 2.0), (int)(y + height / 2.0));
        gradMatrix.setScale(xFactor * Math.cos(theta), yFactor * Math.cos(theta));
        gradMatrix.setRotateSkew(yFactor * Math.sin(theta), -yFactor * Math.sin(theta));
        fillStyle = new FillStyle(gradient, gradMatrix, 16);
        fsArray.addStyle(fillStyle);
        return fsArray;
    }

    protected LineStyleArray getLineStyleArray(Color borderColor, int alpha, int thickness, boolean defineShape4Needed) {
        Color col = borderColor;
        if (col == null) {
            col = new Color(255, 255, 255);
        }
        RGBA rgba = new RGBA((int)((short)col.getRed()), (int)((short)col.getGreen()), (int)((short)col.getBlue()), alpha);
        thickness = thickness <= 0 ? 20 : (thickness *= 20);
        LineStyleArray lsArray = new LineStyleArray();
        if (defineShape4Needed) {
            LineStyle2 lineStyle = new LineStyle2(thickness);
            lineStyle.setColor(rgba);
            lsArray.addStyle(lineStyle);
        } else {
            LineStyle lineStyle = new LineStyle(thickness, rgba);
            lsArray.addStyle(lineStyle);
        }
        return lsArray;
    }

    protected Rect getSwiffRect(Shape shape) {
        Rectangle2D rect = shape.getBounds2D();
        Rect swiffRect = new Rect((long)(rect.getX() * 20.0), (long)(rect.getX() * 20.0 + rect.getWidth() * 20.0), (long)(rect.getY() * 20.0), (long)(rect.getY() * 20.0 + rect.getHeight() * 20.0));
        return swiffRect;
    }

    protected int initDraw() {
        this.m_shapeRecords = new Vector();
        this.m_lastX = Double.MAX_VALUE;
        this.m_lastY = Double.MAX_VALUE;
        return this.m_document.getNewCharacterId();
    }

    protected void drawImage(Image image, int x, int y, ImageObserver imgObs) {
        int img_id = 0;
        BufferedImage bimg = new BufferedImage(image.getWidth(imgObs), image.getHeight(imgObs), 2);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(image, 0, 0, imgObs);
        g.dispose();
        RGBA[] bitmapAlpha = ImageUtilities.getRGBAArray(bimg);
        AlphaBitmapData alphaMapData = new AlphaBitmapData(bitmapAlpha);
        DefineBitsLossless2 bitsLossless2 = new DefineBitsLossless2(this.m_document.getNewCharacterId(), 5, bimg.getWidth(), bimg.getHeight(), alphaMapData);
        img_id = bitsLossless2.getCharacterId();
        this.m_document.addTag(bitsLossless2);
        Rect shapeBounds = new Rect(0L, bimg.getWidth() * 20, 0L, bimg.getHeight() * 20);
        ShapeWithStyle styles = this._createImageShapeWithStyle(bimg, shapeBounds, img_id);
        DefineShape shape = new DefineShape(this.m_document.getNewCharacterId(), shapeBounds, styles);
        this.m_document.addTag(shape);
        PlaceObject2 placeObject2 = new PlaceObject2(img_id);
        placeObject2.setMatrix(new Matrix(x * 20, y * 20));
        placeObject2.setCharacterId(shape.getCharacterId());
        this.m_document.addTag(placeObject2);
        if (this.isFlashAnimationOn()) {
            this.m_document.addTag(new ShowFrame());
        }
    }

    protected void drawImage(String imgURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        int img_id = 0;
        BufferedImage bimg = new BufferedImage(image.getWidth(imgObs), image.getHeight(imgObs), 2);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(image, 0, 0, imgObs);
        g.dispose();
        if (imgURL.endsWith(".gif") || imgURL.endsWith(".png")) {
            RGBA[] bitmapAlpha = ImageUtilities.getRGBAArray(bimg);
            AlphaBitmapData alphaMapData = new AlphaBitmapData(bitmapAlpha);
            DefineBitsLossless2 bitsLossless2 = new DefineBitsLossless2(this.m_document.getNewCharacterId(), 5, bimg.getWidth(), bimg.getHeight(), alphaMapData);
            img_id = bitsLossless2.getCharacterId();
            this.m_document.addTag(bitsLossless2);
        } else if (imgURL.endsWith(".jpeg") || imgURL.endsWith(".jpg") || imgURL.endsWith(".bmp")) {
            ImageDocumentFactory docFactory = new ImageDocumentFactory(bimg);
            byte[] imgByte = this._createImageByteArray(docFactory, bimg, 10);
            DefineBitsJPEG2 bitsJPEG2 = new DefineBitsJPEG2(this.m_document.getNewCharacterId(), imgByte);
            img_id = bitsJPEG2.getCharacterId();
            this.m_document.addTag(bitsJPEG2);
        }
        Rect shapeBounds = new Rect(0L, bimg.getWidth() * 20, 0L, bimg.getHeight() * 20);
        ShapeWithStyle styles = this._createImageShapeWithStyle(bimg, shapeBounds, img_id);
        DefineShape shape = new DefineShape(this.m_document.getNewCharacterId(), shapeBounds, styles);
        this.m_document.addTag(shape);
        PlaceObject2 placeObject2 = new PlaceObject2(img_id);
        placeObject2.setMatrix(new Matrix(x * 20, y * 20));
        placeObject2.setCharacterId(shape.getCharacterId());
        this.m_document.addTag(placeObject2);
        if (this.m_animationEnabled) {
            this.m_document.addTag(new ShowFrame());
        }
    }

    protected DefinitionTag drawLine(double x1, double y1, double x2, double y2, int width, FillStyleArray fsArray, LineStyleArray lsArray, int fillStyleIndex, int lineStyleIndex, boolean intelligent, boolean defineShape4Needed, boolean dropShadowNeeded) {
        int id = this.initDraw();
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        if (intelligent) {
            int x = (int)line.getBounds2D().getX();
            int y = (int)line.getBounds2D().getY();
            this._getShapeRecords(line, AffineTransform.getTranslateInstance(-x, -y), fillStyleIndex, lineStyleIndex, false);
        } else {
            this._drawLine(x1 * 20.0, y1 * 20.0, x2 * 20.0, y2 * 20.0, fillStyleIndex, lineStyleIndex);
        }
        Object[] shapeRec = new ShapeRecord[this.m_shapeRecords.size()];
        this.m_shapeRecords.copyInto(shapeRec);
        Rect swiffRect = this.getSwiffRect(line);
        if (intelligent) {
            swiffRect = new Rect(0L, swiffRect.getXMax() - swiffRect.getXMin(), 0L, swiffRect.getYMax() - swiffRect.getYMin());
        }
        Rect shapeRect = new Rect(swiffRect.getXMin() - (long)(width * 10), swiffRect.getXMax() + (long)(width * 10), swiffRect.getYMin() - (long)(width * 10), swiffRect.getYMax() + (long)(width * 10));
        DefinitionTag defShape = this._addShapeToLibrary(id, (ShapeRecord[])shapeRec, swiffRect, shapeRect, fsArray, lsArray, defineShape4Needed);
        return defShape;
    }

    protected void drawLine(int x1, int y1, int x2, int y2, FillStyleArray fsArray, LineStyleArray lsArray, int fillStyleIndex, int lineStyleIndex) {
        int id = this.m_document.getNewCharacterId();
        this._drawLine(x1 * 20, y1 * 20, x2 * 20, y2 * 20, fillStyleIndex, lineStyleIndex);
        Object[] shapeRec = new ShapeRecord[this.m_shapeRecords.size()];
        this.m_shapeRecords.copyInto(shapeRec);
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        Rect swiffRect = this.getSwiffRect(line);
        ShapeWithStyle sws = new ShapeWithStyle(fsArray, lsArray, (ShapeRecord[])shapeRec);
        DefineShape3 defShape = new DefineShape3(id, swiffRect, sws);
        this.m_document.addTag(defShape);
        PlaceObject2 placeObject2 = new PlaceObject2(id);
        placeObject2.setCharacterId(id);
        this.m_document.addTag(placeObject2);
        if (this.isFlashAnimationOn()) {
            this.m_document.addTag(new ShowFrame());
        }
    }

    protected void drawRectangle(Rectangle rectangle, FillStyleArray fsArray, LineStyleArray lsArray, int fillStyleIndex, int lineStyleIndex) {
        int id = this.initDraw();
        this._drawRectangle(rectangle.x * 20, rectangle.y * 20, rectangle.width * 20, rectangle.height * 20, fillStyleIndex, lineStyleIndex);
        Object[] shapeRec = new ShapeRecord[this.m_shapeRecords.size()];
        this.m_shapeRecords.copyInto(shapeRec);
        Rect swiffRect = this.getSwiffRect(rectangle);
        this._addShapeToLibrary(id, (ShapeRecord[])shapeRec, swiffRect, null, fsArray, lsArray, false);
        this.addToDisplay(id, null, false);
    }

    protected DefinitionTag drawRectangle(Rectangle rectangle, FillStyleArray fsArray, LineStyleArray lsArray, int fillStyleIndex, int lineStyleIndex, boolean intelligent, boolean defineShape4Needed, boolean dropShadowNeeded) {
        int id = this.initDraw();
        if (intelligent) {
            this._drawRectangle(0.0, 0.0, rectangle.width * 20, rectangle.height * 20, fillStyleIndex, lineStyleIndex);
        } else {
            this._drawRectangle(rectangle.x * 20, rectangle.y * 20, rectangle.width * 20, rectangle.height * 20, fillStyleIndex, lineStyleIndex);
        }
        Object[] shapeRec = new ShapeRecord[this.m_shapeRecords.size()];
        this.m_shapeRecords.copyInto(shapeRec);
        Rect swiffRect = this.getSwiffRect(rectangle);
        if (intelligent) {
            swiffRect = new Rect(0L, swiffRect.getXMax() - swiffRect.getXMin(), 0L, swiffRect.getYMax() - swiffRect.getYMin());
        }
        DefineShape3 defShape = (DefineShape3)this._addShapeToLibrary(id, (ShapeRecord[])shapeRec, swiffRect, null, fsArray, lsArray, defineShape4Needed);
        return defShape;
    }

    protected void drawShape(Shape shape, FillStyleArray fsArray, LineStyleArray lsArray, int fillStyleIndex, int lineStyleIndex) {
        int id = this.initDraw();
        this._getShapeRecords(shape, null, fillStyleIndex, lineStyleIndex, false);
        Object[] shapeRec = new ShapeRecord[this.m_shapeRecords.size()];
        this.m_shapeRecords.copyInto(shapeRec);
        Rect swiffRect = this.getSwiffRect(shape);
        this._addShapeToLibrary(id, (ShapeRecord[])shapeRec, swiffRect, null, fsArray, lsArray, false);
        this.addToDisplay(id, null, false);
    }

    protected DefinitionTag drawShape(Shape shape, FillStyleArray fsArray, LineStyleArray lsArray, int fillStyleIndex, int lineStyleIndex, boolean intelligent, boolean defineShape4Needed, boolean dropShadowNeeded, boolean drawClosingLine) {
        int id = this.initDraw();
        if (intelligent) {
            int x = (int)shape.getBounds2D().getX();
            int y = (int)shape.getBounds2D().getY();
            this._getShapeRecords(shape, AffineTransform.getTranslateInstance(-x, -y), fillStyleIndex, lineStyleIndex, drawClosingLine);
        } else {
            this._getShapeRecords(shape, null, fillStyleIndex, lineStyleIndex, drawClosingLine);
        }
        Object[] shapeRec = new ShapeRecord[this.m_shapeRecords.size()];
        this.m_shapeRecords.copyInto(shapeRec);
        Rect swiffRect = this.getSwiffRect(shape);
        if (intelligent) {
            swiffRect = new Rect(0L, swiffRect.getXMax() - swiffRect.getXMin(), 0L, swiffRect.getYMax() - swiffRect.getYMin());
        }
        DefineShape3 defShape = (DefineShape3)this._addShapeToLibrary(id, (ShapeRecord[])shapeRec, swiffRect, null, fsArray, lsArray, defineShape4Needed);
        return defShape;
    }

    protected int drawText(Font font, int fontHeight, String text, int x, int y, Color textColor, Rect bounds) {
        return this.drawText(font, fontHeight, text, x, y, textColor, bounds, (short)-1);
    }

    protected int drawText(Font font, int fontHeight, String text, int x, int y, Color textColor, Rect bounds, short alignment) {
        int fontId = this.m_document.getNewCharacterId();
        String fontName = font.getFontName();
        DefineFont2 defineFont2 = new DefineFont2(fontId, fontName, null, null);
        if (font.isBold()) {
            defineFont2.setBold(true);
        }
        if (font.isItalic()) {
            defineFont2.setItalic(true);
        }
        this.m_document.addTag(defineFont2);
        int textId = this.m_document.getNewCharacterId();
        DefineEditText defineEditText = new DefineEditText(textId, bounds, null);
        defineEditText.setFont(fontId, 20 * fontHeight);
        if (alignment != -1) {
            defineEditText.setLayout(alignment, 0, 0, 0, 0);
        }
        defineEditText.setNoSelect(true);
        RGBA rgba = new RGBA((short)textColor.getRed(), (short)textColor.getGreen(), (short)textColor.getBlue(), 255);
        defineEditText.setTextColor(rgba);
        defineEditText.setReadOnly(true);
        if (bounds.getXMax() != 0L) {
            defineEditText.setWordWrap(true);
        } else {
            defineEditText.setAutoSize(true);
        }
        if (this.isBidiRequired()) {
            text = ChartHelper.applyBidi(text);
        }
        defineEditText.setInitialText(text);
        this.m_document.addTag(defineEditText);
        if (x != 0 && y != 0) {
            Matrix m = new Matrix((x -= 2) * 20, (y -= 2) * 20);
            this.addToDisplay(textId, m, false);
        }
        return textId;
    }

    private DefinitionTag _addShapeToLibrary(int id, ShapeRecord[] shapeRec, Rect swiffRect, Rect shapeRect, FillStyleArray fsArray, LineStyleArray lsArray, boolean defineShape4Needed) {
        DefinitionTag shape = null;
        ShapeWithStyle sws = new ShapeWithStyle(fsArray, lsArray, shapeRec);
        if (defineShape4Needed && shapeRect != null) {
            shape = new DefineShape4(id, shapeRect, swiffRect, sws);
            this.m_document.addTag(shape);
        } else {
            shape = new DefineShape3(id, swiffRect, sws);
            this.m_document.addTag(shape);
        }
        return shape;
    }

    private StyleChangeRecord _addStyleChangeRecord() {
        StyleChangeRecord scr = new StyleChangeRecord();
        this.m_shapeRecords.addElement(scr);
        return scr;
    }

    private void _drawAWTPathIterator(PathIterator pi, int fillStyleIndex, int lineStyleIndex, boolean drawClosingLine) {
        double[] coords = new double[6];
        double last_move_x = 0.0;
        double last_move_y = 0.0;
        boolean close = false;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    last_move_x = coords[0] * 20.0;
                    last_move_y = coords[1] * 20.0;
                    this._movePenTo(last_move_x, last_move_y, fillStyleIndex, lineStyleIndex);
                    break;
                }
                case 4: {
                    this._drawLineTo(last_move_x, last_move_y);
                    close = true;
                    break;
                }
                case 1: {
                    double x = coords[0] * 20.0;
                    double y = coords[1] * 20.0;
                    this._drawLineTo(x, y);
                    break;
                }
                case 2: {
                    double cx = coords[0] * 20.0;
                    double cy = coords[1] * 20.0;
                    double ax = coords[2] * 20.0;
                    double ay = coords[3] * 20.0;
                    this._drawCurveTo(cx, cy, ax, ay);
                    break;
                }
                case 3: {
                    double c1x = coords[0] * 20.0;
                    double c1y = coords[1] * 20.0;
                    double c2x = coords[2] * 20.0;
                    double c2y = coords[3] * 20.0;
                    double ax = coords[4] * 20.0;
                    double ay = coords[5] * 20.0;
                    Point2D.Double p0 = new Point2D.Double(this.m_lastX, this.m_lastY);
                    Point2D.Double p1 = new Point2D.Double(c1x, c1y);
                    Point2D.Double p2 = new Point2D.Double(c2x, c2y);
                    Point2D.Double p3 = new Point2D.Double(ax, ay);
                    Point2D[] quad_curves = CurveHelper.CubicToQudratricBezier(p0, p1, p2, p3);
                    int i = 0;
                    while (i < quad_curves.length) {
                        Point2D anchor1 = quad_curves[i];
                        Point2D control = quad_curves[i + 1];
                        Point2D anchor2 = quad_curves[i + 2];
                        this._drawCurve(anchor1, control, anchor2, fillStyleIndex, lineStyleIndex);
                        i += 3;
                    }
                    break;
                }
            }
            pi.next();
        }
        if (drawClosingLine && !close) {
            this._drawLineTo(last_move_x, last_move_y);
        }
    }

    private void _drawCurve(double ax1, double ay1, double cx, double cy, double ax2, double ay2, int fillStyleIndex, int lineStyleIndex) {
        this._movePenTo(ax1, ay1, fillStyleIndex, lineStyleIndex);
        this._drawCurveTo(cx, cy, ax2, ay2);
    }

    private void _drawCurve(Point2D anchor1, Point2D control, Point2D anchor2, int fillStyleIndex, int lineStyleIndex) {
        this._drawCurve((int)anchor1.getX(), (int)anchor1.getY(), (int)control.getX(), (int)control.getY(), (int)anchor2.getX(), (int)anchor2.getY(), fillStyleIndex, lineStyleIndex);
    }

    private void _drawCurveTo(double cx, double cy, double ax, double ay) {
        this.m_shapeRecords.addElement(new CurvedEdgeRecord((int)(cx - this.m_lastX), (int)(cy - this.m_lastY), (int)(ax - cx), (int)(ay - cy)));
        this.m_lastX = (int)ax;
        this.m_lastY = (int)ay;
    }

    private void _drawLine(double x1, double y1, double x2, double y2, int fillStyleIndex, int lineStyleIndex) {
        this._movePenTo(x1, y1, fillStyleIndex, lineStyleIndex);
        this._drawLineTo(x2, y2);
    }

    private void _drawLineTo(double x, double y) {
        double deltaX = (double)((int)x) - this.m_lastX;
        double deltaY = (double)((int)y) - this.m_lastY;
        this.m_shapeRecords.addElement(new StraightEdgeRecord((int)deltaX, (int)deltaY));
        this.m_lastX = (int)x;
        this.m_lastY = (int)y;
    }

    private void _drawRectangle(double x, double y, double width, double height, int fillStyleIndex, int lineStyleIndex) {
        this._movePenTo(x, y, fillStyleIndex, lineStyleIndex);
        this._drawLineTo(x + width, y);
        this._drawLineTo(x + width, y + height);
        this._drawLineTo(x, y + height);
        this._drawLineTo(x, y);
    }

    private List _getFilterList() {
        ArrayList<DropShadowFilter> filterList = new ArrayList<DropShadowFilter>();
        DropShadowFilter drpShdwFiltr = new DropShadowFilter();
        drpShdwFiltr.setColor(new RGBA(ChartConstants.DROPSHADOW_COLOR.getRed(), ChartConstants.DROPSHADOW_COLOR.getGreen(), ChartConstants.DROPSHADOW_COLOR.getBlue(), 50));
        drpShdwFiltr.setDistance(2.0);
        drpShdwFiltr.setAngle(125.0);
        filterList.add(drpShdwFiltr);
        return filterList;
    }

    private void _getShapeRecords(Shape shape, AffineTransform at, int fillStyleIndex, int lineStyleIndex, boolean drawClosingLine) {
        PathIterator pi = shape.getPathIterator(at);
        this._drawAWTPathIterator(pi, fillStyleIndex, lineStyleIndex, drawClosingLine);
    }

    private StyleChangeRecord _getStyleChange() {
        ShapeRecord item;
        if (this.m_shapeRecords.size() > 0 && (item = (ShapeRecord)this.m_shapeRecords.elementAt(this.m_shapeRecords.size() - 1)) instanceof StyleChangeRecord) {
            return (StyleChangeRecord)item;
        }
        return this._addStyleChangeRecord();
    }

    private void _movePenTo(double x, double y, int fillStyleIndex, int lineStyleIndex) {
        if ((int)this.m_lastX != (int)x || (int)this.m_lastY != (int)y) {
            StyleChangeRecord sc = this._getStyleChange();
            sc.setMoveTo((int)x, (int)y);
            sc.setFillStyle1(fillStyleIndex);
            sc.setLineStyle(lineStyleIndex);
            this.m_lastX = (int)x;
            this.m_lastY = (int)y;
        }
    }

    private byte[] _createImageByteArray(ImageDocumentFactory docFactory, BufferedImage image, int quality) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (quality >= 0) {
                ImageUtilities.saveImageAsJPEG(image, baos, quality);
            } else {
                ImageUtilities.saveImageAsJPEG(image, baos);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] imageData = baos.toByteArray();
        int imageDataLength = imageData.length;
        int headerLength = ChartConstants.JPEG_DATA_HEADER.length;
        byte[] extendedImageData = new byte[headerLength + imageDataLength];
        System.arraycopy(ChartConstants.JPEG_DATA_HEADER, 0, extendedImageData, 0, headerLength);
        System.arraycopy(imageData, 0, extendedImageData, headerLength, imageDataLength);
        return extendedImageData;
    }

    private ShapeWithStyle _createImageShapeWithStyle(BufferedImage image, Rect shapeBounds, int imageCharacterId) {
        Matrix bitmapMatrix = new Matrix(0, 0);
        int shapeXMax = (int)shapeBounds.getXMax();
        int shapeYMax = (int)shapeBounds.getYMax();
        bitmapMatrix.setScale((float)shapeXMax / (float)image.getWidth(), (float)shapeYMax / (float)image.getHeight());
        FillStyle fillStyle = new FillStyle(imageCharacterId, bitmapMatrix, 65);
        FillStyleArray fillStyles = new FillStyleArray();
        fillStyles.addStyle(fillStyle);
        ShapeRecord[] shapeRecords = new ShapeRecord[5];
        StyleChangeRecord styleChangeRecord = new StyleChangeRecord();
        styleChangeRecord.setFillStyle1(1);
        styleChangeRecord.setMoveTo(shapeXMax, shapeYMax);
        shapeRecords[0] = styleChangeRecord;
        shapeRecords[1] = new StraightEdgeRecord(-shapeXMax, 0);
        shapeRecords[2] = new StraightEdgeRecord(0, -shapeYMax);
        shapeRecords[3] = new StraightEdgeRecord(shapeXMax, 0);
        shapeRecords[4] = new StraightEdgeRecord(0, shapeYMax);
        ShapeWithStyle shapeWithStyle = new ShapeWithStyle(fillStyles, new LineStyleArray(), shapeRecords);
        return shapeWithStyle;
    }

    public void generateActionScript(String swfResource) {
        this.generateActionScript(swfResource, true);
    }

    public void generateActionScript(String swfResource, boolean bRenderDynamic) {
        SWFReader reader = null;
        InputStream swfInputStream = null;
        try {
            try {
                swfInputStream = this.getClass().getResourceAsStream(swfResource);
                reader = new SWFReader(swfInputStream);
                SWFDocumentReader docReader = new SWFDocumentReader();
                reader.addListener(docReader);
                reader.read();
                this.m_resourceDoc = docReader.getDocument();
                int charId = 0;
                String assetName = null;
                if (this.m_resourceDoc != null) {
                    List tags = this.m_resourceDoc.getTags();
                    int i = 0;
                    while (i < tags.size()) {
                        if (tags.get(i) instanceof DoAction) {
                            DoAction doAction = (DoAction)tags.get(i);
                            List actions = doAction.getActions().getActions();
                            DoAction updatedActions = new DoAction();
                            ConstantPool cp = (ConstantPool)actions.get(0);
                            updatedActions.addAction(cp);
                            if (bRenderDynamic) {
                                this.createChartContext(cp, updatedActions);
                            }
                            int j = 0;
                            while (j < actions.size()) {
                                if (!(actions.get(j) instanceof ConstantPool)) {
                                    updatedActions.addAction((Action)actions.get(j));
                                }
                                ++j;
                            }
                            this.m_document.addTag(updatedActions);
                        } else {
                            Tag tag = (Tag)tags.get(i);
                            if (!(tag instanceof ShowFrame)) {
                                if (tag instanceof DefineSprite) {
                                    DefineSprite ds = (DefineSprite)tag;
                                    charId = this.m_document.getNewCharacterId();
                                    ds.setCharacterId(charId);
                                } else if (tag instanceof ExportAssets) {
                                    ExportAssets expAsset = (ExportAssets)tag;
                                    ExportAssets.ExportMapping[] expMap = expAsset.getExportMappings();
                                    expMap[0].setCharacterId(charId);
                                    assetName = expMap[0].getName();
                                } else if (tag instanceof DoInitAction) {
                                    DoInitAction dis = (DoInitAction)tag;
                                    dis.setSpriteId(charId);
                                }
                                if (tag instanceof ExportAssets || tag instanceof DoInitAction) {
                                    if (assetName != null) {
                                        if (this.isRendererAsset(assetName)) {
                                            if (this.includeRendererAsset(assetName)) {
                                                this.m_document.addTag(tag);
                                            }
                                        } else {
                                            this.m_document.addTag(tag);
                                        }
                                    }
                                } else {
                                    this.m_document.addTag(tag);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {}
        }
        finally {
            try {
                swfInputStream.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected boolean isRendererAsset(String asset) {
        return asset.equals("__Packages.ChartRenderer") || asset.equals("__Packages.BarChartRenderer") || asset.equals("__Packages.StackedBarChartRenderer") || asset.equals("__Packages.LineChartRenderer") || asset.equals("__Packages.AreaChartRenderer") || asset.equals("__Packages.BLAChartRenderer") || asset.equals("__Packages.ComboChartRenderer") || asset.equals("__Packages.LineChartHelper") || asset.equals("__Packages.Combo3DCalcEngine") || asset.equals("__Packages.ComboAnimHandler") || asset.equals("__Packages.ComboChartHelper") || asset.equals("__Packages.ComboBarAnimHandler") || asset.equals("__Packages.ComboLineAnimHandler") || asset.equals("__Packages.ComboAreaAnimHandler") || asset.equals("__Packages.ComboBarRenderer") || asset.equals("__Packages.ComboLineRenderer") || asset.equals("__Packages.ComboAreaRenderer") || asset.equals("__Packages.ComboLARenderer") || asset.equals("__Packages.ComboChartSplitter") || asset.equals("__Packages.PieChartRenderer") || asset.equals("__Packages.PieChartRenderer_3D") || asset.equals("__Packages.PieAnimHelper") || asset.equals("__Packages.EllipticalArc") || asset.equals("__Packages.Bar2D") || asset.equals("__Packages.Bar3D") || asset.equals("__Packages.Line2D") || asset.equals("__Packages.Line3D") || asset.equals("__Packages.Area2D") || asset.equals("__Packages.Area3D") || asset.equals("__Packages.Legends") || asset.equals("__Packages.CircularArc2D") || asset.equals("__Packages.EllipticalArc2D") || asset.equals("__Packages.EllipticalArc3D") || asset.equals("__Packages.PieSliceLabels") || asset.equals("__Packages.PieChartLayoutManager") || asset.equals("__Packages.GroupLabels") || asset.equals("__Packages.Y1Axis") || asset.equals("__Packages.MinMaxObj") || asset.equals("__Packages.FP") || asset.equals("__Packages.GaugeFlashRenderer") || asset.equals("__Packages.FunnelChartRenderer") || asset.equals("__Packages.FunnelSliceArc");
    }

    protected abstract void createChartContext(ConstantPool var1, DoAction var2);

    protected abstract boolean includeRendererAsset(String var1);

    protected abstract boolean isBidiRequired();
}

