/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Vector;
import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.ChartRenderer;
import oracle.dss.graph.flash.MovieClipObj;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.util.ChartHelper;
import oracle.dss.graph.pfj.JChart_2D_Funnel;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;

public class FunnelChartRenderer
extends ChartRenderer {
    private int m_skeletonBorderColor;
    private int m_skeletonBorderWidth;
    private int m_skeletonBorderAlpha;
    private int m_leftSurfaceFillColor;
    private int m_leftSurfaceFillAlpha;
    private int m_numOfMeasures;
    private Vector m_mcObjVect;

    private void $init$() {
        this.m_numOfMeasures = 2;
    }

    public FunnelChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document, vc, renderDynamic, pfj);
        this.$init$();
    }

    public Vector getMovieClipVect() {
        return this.m_mcObjVect;
    }

    protected void createMCObjArray() {
        this.m_mcObjVect = new Vector();
    }

    protected int getChartType() {
        return 7;
    }

    protected void populateMCDrawProperties(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth) {
        MovieClipObj mc = new MovieClipObj(blackBox, identObj, this.m_pfj, shape, borderWidth, this.m_bHasGradient);
        mc.calcProperties();
        this.m_mcObjVect.add(mc);
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        super.createChartContext(cp, updatedActions);
        this.asCreateDataArray(cp, updatedActions, "dataArray");
        this.asCreateTooltipTagArray(cp, updatedActions, "tooltipTagArray");
        this._setSkeletonBorderProps();
        this._setFunnelLeftSurfaceFillProps();
        this._asPushFunnelParameters(cp, updatedActions);
        this._asPushFunnelTangentLines(cp, updatedActions, "funnelTangents");
        this._asPushPercentValues(cp, updatedActions, "funnelSlicePercents");
        this._asPushSliceThresholdProps(cp, updatedActions);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "skelBorderColor", this.m_skeletonBorderColor);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "skelBorderWidth", this.m_skeletonBorderWidth);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "skelBorderAlpha", this.m_skeletonBorderAlpha);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "leftSurfaceFillColor", this.m_leftSurfaceFillColor);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "leftSurfaceFillAlpha", this.m_leftSurfaceFillAlpha);
        this._pushFunnelSliceLabels(cp, updatedActions);
    }

    protected void asCreateTooltipTagArray(ConstantPool cp, DoAction updatedActions, String tooltipTagArray) {
        String[] tooltipTagValues = this._getTooltipTagValues();
        ActionScript.createArray(cp, updatedActions, tooltipTagArray, tooltipTagValues);
    }

    private String[] _getTooltipTagValues() {
        String[] tooltipTags = new String[]{"af_dvt_graph.LABEL_GROUP", "af_dvt_graph.LABEL_ACTUAL", "af_dvt_graph.LABEL_TARGET"};
        String[] mcTooltipTagValues = new String[tooltipTags.length];
        int i = 0;
        while (i < tooltipTags.length) {
            mcTooltipTagValues[i] = this.getIntlString(tooltipTags[i]);
            ++i;
        }
        return mcTooltipTagValues;
    }

    protected void pushLegends(ConstantPool cp, DoAction updatedActions) {
    }

    protected void pushKeys(ConstantPool cp, DoAction doAction) {
        String[] keys = ChartHelper.generateFunnelDataKeys(this.m_pfj);
        ActionScript.createArray(cp, doAction, "dataKeys", keys);
    }

    private void asCreateDataArray(ConstantPool cp, DoAction updatedActions, String dataArray) {
        double[][] dataValues = this._getDataValues();
        ActionScript.createArray(cp, updatedActions, dataArray, dataValues);
    }

    private double[][] _getDataValues() {
        double[][] dataValues = new double[this.m_numGroups][];
        int i = 0;
        while (i < this.m_numGroups) {
            dataValues[i] = new double[this.m_numOfMeasures];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_numGroups) {
            dataValues[i2][0] = this.m_pfj.getFunnelLabelContainer().getFunnelSliceLabelContainer().getActualValue(i2);
            dataValues[i2][1] = this.m_pfj.getFunnelLabelContainer().getFunnelSliceLabelContainer().getTargetValue(i2);
            ++i2;
        }
        return dataValues;
    }

    private void _setSkeletonBorderProps() {
        MovieClipObj mcObj = (MovieClipObj)this.m_mcObjVect.elementAt(0);
        this.m_skeletonBorderColor = mcObj.getBorderColor();
        this.m_skeletonBorderWidth = mcObj.getBorderWidth();
        this.m_skeletonBorderAlpha = mcObj.getBorderAlpha();
    }

    private void _setFunnelLeftSurfaceFillProps() {
        int i = 0;
        while (i < this.m_mcObjVect.size()) {
            MovieClipObj mcObj = (MovieClipObj)this.m_mcObjVect.elementAt(i);
            if (mcObj.getIdentObj().getObjectID() == 626 && mcObj.getIdentObj().getMiscID() == 623) {
                this.m_leftSurfaceFillColor = mcObj.getFillColor();
                this.m_leftSurfaceFillAlpha = mcObj.getFillAlpha();
                break;
            }
            ++i;
        }
    }

    private void _asPushFunnelParameters(ConstantPool cp, DoAction updatedActions) {
        JChart_2D_Funnel chart = (JChart_2D_Funnel)this.m_pfj.getGraphObject();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "isStandardFunnel", new Boolean(this.m_pfj.isStandardShapeAndWidth()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "lastStageOnly", new Boolean(this.m_pfj.isLastStageOnly()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "rotateAngle", new Double(this.m_pfj.getFunnelRotateAngle()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "viewAngle", new Double(this.m_pfj.getFunnelViewAngle()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelLength", new Double(chart.getFunnelLength()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "leftSurfaceCenterX", new Double(this._getLeftSurfaceCenterX()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "leftSurfaceCenterY", new Double(this._getLeftSurfaceCenterY()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "leftSurfaceWidth", new Double(chart.getLeftSurfaceWidth()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "leftSurfaceHeight", new Double(chart.getLeftSurfaceHeight()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "rightSurfaceWidth", new Double(chart.getRightSurfaceWidth()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "rightSurfaceHeight", new Double(chart.getRightSurfaceHeight()));
    }

    private double _getLeftSurfaceCenterX() {
        double centerX = 0.0;
        MovieClipObj mcObj = null;
        int i = 0;
        while (i < this.m_mcObjVect.size()) {
            mcObj = (MovieClipObj)this.m_mcObjVect.elementAt(i);
            Shape shape = mcObj.getShape();
            if (shape instanceof Ellipse2D.Double) {
                centerX = ((Ellipse2D.Double)shape).getCenterX();
            }
            ++i;
        }
        return centerX;
    }

    private double _getLeftSurfaceCenterY() {
        double centerY = 0.0;
        MovieClipObj mcObj = null;
        int i = 0;
        while (i < this.m_mcObjVect.size()) {
            mcObj = (MovieClipObj)this.m_mcObjVect.elementAt(i);
            Shape shape = mcObj.getShape();
            if (shape instanceof Ellipse2D.Double) {
                centerY = ((Ellipse2D.Double)shape).getCenterY();
            }
            ++i;
        }
        return centerY;
    }

    private void _asPushFunnelTangentLines(ConstantPool cp, DoAction updatedActions, String funnelTangents) {
        double[][] tangentLines = this._getTangentLines();
        ActionScript.createArray(cp, updatedActions, funnelTangents, tangentLines);
    }

    private double[][] _getTangentLines() {
        double[][] tangentLines = new double[2][4];
        int lineNum = 0;
        MovieClipObj mcObj = null;
        int i = 0;
        while (i < this.m_mcObjVect.size()) {
            mcObj = (MovieClipObj)this.m_mcObjVect.elementAt(i);
            Shape shape = mcObj.getShape();
            if (shape instanceof Line2D) {
                tangentLines[lineNum][0] = ((Line2D)shape).getX1();
                tangentLines[lineNum][1] = ((Line2D)shape).getY1();
                tangentLines[lineNum][2] = ((Line2D)shape).getX2();
                tangentLines[lineNum][3] = ((Line2D)shape).getY2();
                ++lineNum;
            }
            ++i;
        }
        return tangentLines;
    }

    private void _asPushPercentValues(ConstantPool cp, DoAction updatedActions, String funnelSlicePercents) {
        double[] percentValues = this.m_pfj.getFunnelLabelContainer().getFunnelSliceLabelContainer().getPercents();
        ActionScript.createArray(cp, updatedActions, funnelSlicePercents, percentValues);
    }

    private void _asPushSliceThresholdProps(ConstantPool cp, DoAction updatedActions) {
        double[][] thresholds = this._getThresholds();
        double[] thresholdColors = this._getThresholdColors();
        ActionScript.createArray(cp, updatedActions, "thresholds", thresholds);
        ActionScript.createArray(cp, updatedActions, "thresholdColors", thresholdColors);
    }

    private double[][] _getThresholds() {
        int thresholdCount = this.m_pfj.getThresholdCount();
        double[][] thresholds = new double[thresholdCount][2];
        double min = 0.0;
        double max = 0.0;
        int i = 0;
        while (i < thresholdCount) {
            IdentObj idThreshold = this.m_pfj.getThreshold(i);
            Double val = this.m_pfj.getThresholdMinValue(idThreshold);
            if (val != null) {
                min = val;
            }
            if ((val = this.m_pfj.getThresholdMaxValue(idThreshold)) != null) {
                max = val;
            }
            thresholds[i][0] = min;
            thresholds[i][1] = max;
            ++i;
        }
        return thresholds;
    }

    private double[] _getThresholdColors() {
        int thresholdCount = this.m_pfj.getThresholdCount();
        double[] thresholdColors = new double[thresholdCount];
        int i = 0;
        while (i < thresholdCount) {
            IdentObj idThreshold = this.m_pfj.getThreshold(i);
            thresholdColors[i] = this.m_pfj.getFillColor(idThreshold).getRGB();
            ++i;
        }
        return thresholdColors;
    }

    private void _pushFunnelSliceLabels(ConstantPool cp, DoAction updatedActions) {
        if (this.m_funnelSliceLabels != null) {
            Font font = this.m_funnelSliceLabels.getFont();
            String fontName = font.getFontName();
            if (fontName.equalsIgnoreCase("SansSerif.plain") || fontName.equalsIgnoreCase("SansSerif.bold") || fontName.equalsIgnoreCase("SansSerif.italic") || fontName.equalsIgnoreCase("SansSerif.bolditalic")) {
                fontName = "_sans";
            }
            if (fontName.equalsIgnoreCase("Dialog.plain") || fontName.equalsIgnoreCase("Dialog.bold") || fontName.equalsIgnoreCase("Dialog.italic") || fontName.equalsIgnoreCase("Dialog.bolditalic")) {
                fontName = "Arial";
            }
            ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelSliceLabelFontName", fontName);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelSliceLabelBold", new Boolean(font.isBold()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelSliceLabelItalic", new Boolean(font.isItalic()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelSliceLabelUnderline", new Boolean(this.m_funnelSliceLabels.isUnderline()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelSliceLabelFontHeight", new Integer(this.m_funnelSliceLabels.getFontHeight()));
            ActionScript.pushPrimitiveVal(cp, updatedActions, "funnelSliceLabelFontColor", new Integer(this.m_funnelSliceLabels.getFontColor()));
            this._pushFunnelSliceLabelXArray(cp, updatedActions, "funnelSliceLabelXArray");
            this._pushFunnelSliceLabelYArray(cp, updatedActions, "funnelSliceLabelYArray");
        }
    }

    private void _pushFunnelSliceLabelXArray(ConstantPool cp, DoAction doAction, String groupLabelXArray) {
        int[] groupLabelXValues = new int[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            if (this.m_funnelSliceLabels.getBounds(i) != null) {
                groupLabelXValues[i] = this.m_funnelSliceLabels.getBounds((int)i).x;
            }
            ++i;
        }
        ActionScript.createArray(cp, doAction, groupLabelXArray, groupLabelXValues);
    }

    private void _pushFunnelSliceLabelYArray(ConstantPool cp, DoAction doAction, String groupLabelYArray) {
        int[] groupLabelYValues = new int[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            if (this.m_funnelSliceLabels.getBounds(i) != null) {
                groupLabelYValues[i] = this.m_funnelSliceLabels.getBounds((int)i).y;
            }
            ++i;
        }
        ActionScript.createArray(cp, doAction, groupLabelYArray, groupLabelYValues);
    }

    protected boolean includeRendererAsset(String asset) {
        if (super.includeRendererAsset(asset)) {
            return !asset.equals("__Packages.Legends");
        }
        return asset.equals("__Packages.GroupLabels") || asset.equals("__Packages.FunnelChartRenderer") || asset.equals("__Packages.EllipticalArc") || asset.equals("__Packages.EllipticalArc2D") || asset.equals("__Packages.Line2D") || asset.equals("__Packages.FunnelSliceArc");
    }
}

