/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.FlashRenderer;
import oracle.dss.graph.flash.RangeGauge;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.FillStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.LineStyleArray;
import oracle.dss.graph.flash.jswiff.swfrecords.Rect;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.flash.util.ChartHelper;

public class GaugeFlashRenderer
extends FlashRenderer
implements GaugeRenderer {
    private CommonGauge m_commonGauge;
    private boolean m_noStroke;
    private boolean m_angularGradient;
    private boolean m_noFill;
    private int m_compType;
    private int m_nRows;
    private int m_nCols;
    private boolean m_renderDynamic;
    private transient int t_row;
    private transient int t_col;
    private boolean topLabelVisible;
    private boolean bottomLabelVisible;

    private void $init$() {
        this.topLabelVisible = false;
        this.bottomLabelVisible = false;
    }

    public GaugeFlashRenderer(SWFDocument document, CommonGauge gauge, boolean renderDynamic) {
        super(document);
        this.$init$();
        this.m_commonGauge = gauge;
        this.m_renderDynamic = renderDynamic;
        this.enableAnimation(false);
    }

    public void init() {
        this.m_nRows = this.m_commonGauge.getRowCount();
        this.m_nCols = this.m_commonGauge.getColCount();
        this.createMCObjArray();
    }

    public Vector[] getMovieClip() {
        return this.m_mcObjs;
    }

    public SWFDocument getSWFDocument() {
        return this.m_document;
    }

    protected void createMCObjArray() {
        this.m_mcObjs = new Vector[this.m_nRows];
        int i = 0;
        while (i < this.m_nRows) {
            this.m_mcObjs[i] = new Vector();
            ++i;
        }
    }

    public void drawArc(Arc2D arc, Color c) {
        this.m_noStroke = false;
        this._drawShape(arc, c, null, null);
    }

    public void drawArea(Area area, Color c) {
        this.m_noStroke = false;
        this._drawShape(area, c, null, null);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Color c) {
        this.m_noFill = true;
        this.m_noStroke = false;
        this.drawLine(x1, y1, x2, y2, 1, c);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, Color c) {
        this.m_noFill = true;
        this.m_noStroke = false;
        FillStyleArray fsArray = this._getFillStyleArray(null, null, null);
        LineStyleArray lsArray = this.getLineStyleArray(c, -1, thickness, false);
        this.drawLine(x1, y1, x2, y2, fsArray, lsArray, this._getFillStyleIndex(), this._getLineStyleIndex());
    }

    public void drawPolygon(Polygon poly, Color c) {
        this.m_noStroke = false;
        this._drawShape(poly, c, null, null);
    }

    public void drawRect(Rectangle rectangle, Color c) {
        this.m_noStroke = this.m_commonGauge.getGaugeType() == 1 ? this.m_compType != 14 && this.m_compType != 11 : true;
        this._drawRectangle(rectangle, c, null, null);
    }

    public void drawShape(Shape shape, Color c) {
        this.m_noStroke = false;
        this._drawShape(shape, c, null, null);
    }

    public void drawString(String label, int x, int y, Font font, Color textColor, double angle) {
        int yPos = y - font.getSize();
        if (this.m_renderDynamic && this.m_compType == 18) {
            if (RangeGauge.LABEL_FONT == null) {
                RangeGauge.LABEL_FONT = font;
                RangeGauge.LABEL_FONT_SIZE = font.getSize();
                RangeGauge.LABEL_TEXT_COLOR = textColor;
            }
            RangeGauge gauge = (RangeGauge)this.m_mcObjs[this.t_row].get(this.t_col);
            gauge.setMetricLabelX(x);
            gauge.setMetricLabelY(yPos);
            return;
        }
        if (this.m_renderDynamic && this.m_compType == 16) {
            if (label == null) {
                return;
            }
            this.topLabelVisible = true;
            if (RangeGauge.TOPLABEL_FONT == null) {
                RangeGauge.TOPLABEL_FONT = font;
                RangeGauge.TOPLABEL_FONT_SIZE = font.getSize();
                RangeGauge.TOPLABEL_TEXT_COLOR = textColor;
            }
            RangeGauge gauge = (RangeGauge)this.m_mcObjs[this.t_row].get(this.t_col);
            gauge.setTopLabelX(x);
            gauge.setTopLabelY(yPos);
            gauge.setTopLabelValue(label);
            return;
        }
        if (this.m_renderDynamic && this.m_compType == 17) {
            if (label == null) {
                return;
            }
            this.bottomLabelVisible = true;
            if (RangeGauge.BOTTOMLABEL_FONT == null) {
                RangeGauge.BOTTOMLABEL_FONT = font;
                RangeGauge.BOTTOMLABEL_FONT_SIZE = font.getSize();
                RangeGauge.BOTTOMLABEL_TEXT_COLOR = textColor;
            }
            RangeGauge gauge = (RangeGauge)this.m_mcObjs[this.t_row].get(this.t_col);
            gauge.setBottomLabelX(x);
            gauge.setBottomLabelY(yPos);
            gauge.setBottomLabelValue(label);
            return;
        }
        this.drawText(font, font.getSize(), label, x, yPos, textColor, new Rect(0L, 0L, 0L, 0L));
    }

    public void drawImage(String imgURL, Image image, int x, int y, int width, int height, ImageObserver imgObs) {
        this.drawImage(imgURL, image, x, y, width, height, imgObs);
    }

    public void fillArc(Arc2D arc, Color c, HashMap sfxMap) {
        this.m_noStroke = true;
        this._drawShape(arc, null, c, sfxMap);
    }

    public void fillArea(Area area, Color c, HashMap sfxMap) {
        this.m_noStroke = true;
        this._drawShape(area, null, c, sfxMap);
    }

    public void fillPolygon(Polygon poly, Color c, HashMap sfxMap) {
        this.m_noStroke = true;
        this._drawShape(poly, null, c, sfxMap);
    }

    public void fillRect(Rectangle rect, Color c, HashMap sfxMap) {
        this.m_noStroke = this.m_commonGauge.getGaugeType() == 1 ? this.m_compType != 14 && this.m_compType != 11 : true;
        this._drawRectangle(rect, null, c, sfxMap);
    }

    public void fillShape(Shape shape, Color c, HashMap sfxMap) {
        this.m_noStroke = true;
        this._drawShape(shape, null, c, sfxMap);
    }

    public void drawAndFillArc(Arc2D arc, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillArc(arc, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawArc(arc, borderColor);
        }
    }

    public void drawAndFillArea(Area area, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillArea(area, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawArea(area, borderColor);
        }
    }

    public void drawAndFillPolygon(Polygon polygon, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillPolygon(polygon, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawPolygon(polygon, borderColor);
        }
    }

    public void drawAndFillRect(Rectangle rect, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillRect(rect, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawRect(rect, borderColor);
        }
    }

    public void drawAndFillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillRoundedRect(rect, arcWidth, arcHeight, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawRoundedRect(rect, arcWidth, arcHeight, borderColor);
        }
    }

    public void drawAndFillShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (fillColor != null || sfxMap != null) {
            this.fillShape(shape, fillColor, sfxMap);
        }
        if (borderColor != null) {
            this.drawShape(shape, borderColor);
        }
    }

    public void setCompType(int compType) {
        this.m_compType = compType;
    }

    public boolean isRenderDynamicOn() {
        return this.m_renderDynamic;
    }

    public void setMCObj(RangeGauge gauge) {
        this.t_row = gauge.getRow();
        this.t_col = gauge.getColumn();
        this.m_mcObjs[this.t_row].add(gauge);
    }

    public void applyTransform(AffineTransform transform) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public void setTransform(AffineTransform transform) {
    }

    public void drawRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color borderColor) {
        if (this.m_compType != 26) {
            return;
        }
        this.m_noStroke = false;
        GeneralPath path = new GeneralPath();
        path.moveTo(rect.x + rect.height, rect.y);
        path.lineTo(rect.x + (rect.width - rect.height), rect.y);
        Arc2D.Double arc = new Arc2D.Double(rect.x + (rect.width - rect.height), rect.y, rect.height, rect.height, 90.0, -180.0, 0);
        path.append(arc, true);
        path.lineTo(rect.x + rect.height, rect.y + rect.height);
        arc = new Arc2D.Double(rect.x, rect.y, rect.height, rect.height, -90.0, -180.0, 0);
        path.append(arc, true);
        path.closePath();
        this._drawShape(path, borderColor, null, null);
    }

    public void fillRoundedRect(Rectangle rect, int arcWidth, int arcHeight, Color fillColor, HashMap sfxMap) {
        if (this.m_compType != 26) {
            return;
        }
        this.m_noStroke = true;
        GeneralPath path = new GeneralPath();
        path.moveTo(rect.x + rect.height, rect.y);
        path.lineTo(rect.x + (rect.width - rect.height), rect.y);
        Arc2D.Double arc = new Arc2D.Double(rect.x + (rect.width - rect.height), rect.y, rect.height, rect.height, 90.0, -180.0, 0);
        path.append(arc, true);
        path.lineTo(rect.x + rect.height, rect.y + rect.height);
        arc = new Arc2D.Double(rect.x, rect.y, rect.height, rect.height, -90.0, -180.0, 0);
        path.append(arc, true);
        path.closePath();
        this._drawShape(path, null, fillColor, sfxMap);
    }

    protected boolean includeRendererAsset(String asset) {
        return asset.equals("__Packages.GaugeFlashRenderer") || asset.equals("__Packages.CircularArc2D") || asset.equals("__Packages.EllipticalArc2D") || asset.equals("__Packages.EllipticalArc");
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        this._pushChartType(cp, updatedActions);
        this._pushNumRows(cp, updatedActions);
        this._pushNumColumns(cp, updatedActions);
        this._pushCenterX(cp, updatedActions);
        this._pushCenterY(cp, updatedActions);
        this._pushRadiusX(cp, updatedActions);
        this._pushRadiusY(cp, updatedActions);
        this._pushMaxValue(cp, updatedActions);
        this._pushMinValue(cp, updatedActions);
        this._pushMetricValue(cp, updatedActions);
        this._pushKeys(cp, updatedActions);
        this._pushMetricLabelsProps(cp, updatedActions);
        this._pushIndicatorType(cp, updatedActions);
        this._pushIndicatorFillColor(cp, updatedActions);
        this._pushIndicatorBorderColor(cp, updatedActions);
        this._pushIndicatorBaseProperties(cp, updatedActions);
        this._pushFlashGaugeLCID(cp, updatedActions);
        this._pushMetricNumberType(cp, updatedActions);
        if (this.topLabelVisible) {
            this._pushTopLabelValue(cp, updatedActions);
            this._pushTopLabelsProps(cp, updatedActions);
        }
        if (this.bottomLabelVisible) {
            this._pushBottomLabelValue(cp, updatedActions);
            this._pushBottomLabelsProps(cp, updatedActions);
        }
    }

    protected boolean isBidiRequired() {
        return this.m_commonGauge.getLocale().getDisplayLanguage().equals("Arabic") || this.m_commonGauge.getLocale().getDisplayLanguage().equals("Hebrew");
    }

    private void _drawShape(Shape shape, Color borderColor, Color fillColor, HashMap sfxMap) {
        RangeGauge gauge;
        if (borderColor == null && fillColor == null && sfxMap == null) {
            return;
        }
        if (this.m_renderDynamic && (this.m_compType == 14 || this.m_compType == 30)) {
            return;
        }
        if (this.m_renderDynamic && this.m_compType == 11) {
            RangeGauge gauge2;
            if (shape instanceof Arc2D && (gauge2 = (RangeGauge)this.m_mcObjs[this.t_row].get(this.t_col)).getCenterX() == -1.0) {
                Arc2D arc = (Arc2D)shape;
                gauge2.setCenterX(arc.getCenterX());
                gauge2.setCenterY(arc.getCenterY());
                gauge2.setRadiusX(arc.getWidth() / 2.0);
                gauge2.setRadiusY(arc.getHeight() / 2.0);
            }
        } else if (this.m_renderDynamic && this.m_compType == 15 && shape instanceof Arc2D && (gauge = (RangeGauge)this.m_mcObjs[this.t_row].get(this.t_col)).getCenterX() == -1.0) {
            Arc2D arc = (Arc2D)shape;
            gauge.setCenterX(arc.getCenterX());
            gauge.setCenterY(arc.getCenterY());
            gauge.setRadiusX(arc.getWidth() / 2.0);
            gauge.setRadiusY(arc.getHeight() / 2.0);
        }
        FillStyleArray fsArray = this._getFillStyleArray(shape, fillColor, sfxMap);
        LineStyleArray lsArray = this.getLineStyleArray(borderColor, -1, -1, false);
        this.drawShape(shape, fsArray, lsArray, this._getFillStyleIndex(), this._getLineStyleIndex());
    }

    private void _drawRectangle(Rectangle rectangle, Color borderColor, Color fillColor, HashMap sfxMap) {
        if (borderColor == null && fillColor == null && sfxMap == null) {
            return;
        }
        FillStyleArray fsArray = this._getFillStyleArray(rectangle, fillColor, sfxMap);
        LineStyleArray lsArray = this.getLineStyleArray(borderColor, -1, -1, false);
        this.drawRectangle(rectangle, fsArray, lsArray, this._getFillStyleIndex(), this._getLineStyleIndex());
    }

    private FillStyleArray _getFillStyleArray(HashMap sfxMap, Shape shape) {
        if (sfxMap == null) {
            return null;
        }
        int fillType = (Integer)sfxMap.get("SFX_FILL_TYPE");
        if (fillType != 2) {
            return null;
        }
        int pos = 0;
        Color[] gradColors = null;
        int[] ratios = null;
        int gradDir = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
        boolean dirRev = (Boolean)sfxMap.get("SFX_GRADIENT_REVERSED");
        int numOfPins = (Integer)sfxMap.get("SFX_NUM_STOPS");
        ArrayList pins = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
        ArrayList colors = (ArrayList)sfxMap.get("SFX_STOP_COLORS");
        gradColors = new Color[numOfPins];
        ratios = new int[numOfPins];
        if (dirRev) {
            int i = numOfPins - 1;
            while (i >= 0) {
                gradColors[i] = (Color)colors.get(i);
                pos = (int)((Double)pins.get(i)).floatValue();
                ratios[i] = pos * 255;
                --i;
            }
        } else {
            int i = 0;
            while (i < numOfPins) {
                gradColors[i] = (Color)colors.get(i);
                pos = (int)((Double)pins.get(i)).floatValue();
                ratios[i] = pos * 255;
                ++i;
            }
        }
        if (gradDir == 1) {
            return this.getFillStyleArray(-1, (short)16, ratios, gradColors, shape.getBounds2D(), null, -2);
        }
        if (gradDir == 3) {
            this.m_angularGradient = true;
            return this.getFillStyleArray(-1, (short)16, ratios, gradColors, shape.getBounds2D(), null, -2, 90.0);
        }
        if (gradDir == 5) {
            this.m_angularGradient = true;
            return this.getFillStyleArray(-1, (short)16, ratios, gradColors, shape.getBounds2D(), null, -2, 45.0);
        }
        if (gradDir == 7) {
            this.m_angularGradient = true;
            return this.getFillStyleArray(-1, (short)16, ratios, gradColors, shape.getBounds2D(), null, -2, 135.0);
        }
        if (gradDir == 9) {
            return this.getFillStyleArray(-1, (short)18, ratios, gradColors, shape.getBounds2D(), null, -2);
        }
        if (gradDir == 10) {
            return null;
        }
        if (gradDir == 11) {
            return null;
        }
        if (gradDir == 12) {
            return null;
        }
        if (gradDir == 13) {
            return null;
        }
        return null;
    }

    private FillStyleArray _getFillStyleArray(Shape shape, Color fillColor, HashMap sfxMap) {
        FillStyleArray fsArray = null;
        fsArray = this._getFillStyleArray(sfxMap, shape);
        if (fsArray == null) {
            fsArray = fillColor == null ? this.getFillStyleArray(fillColor, 0) : this.getFillStyleArray(fillColor, -1);
        }
        return fsArray;
    }

    private int _getFillStyleIndex() {
        int fillStyleIndex = 0;
        if (!this.m_noFill) {
            if (this.m_angularGradient) {
                this.m_angularGradient = false;
                fillStyleIndex = 3;
            } else {
                fillStyleIndex = 1;
            }
        } else {
            this.m_noFill = false;
            fillStyleIndex = 0;
        }
        return fillStyleIndex;
    }

    private int _getLineStyleIndex() {
        int lineStyleIndex = 0;
        if (this.m_noStroke) {
            lineStyleIndex = 0;
        } else {
            lineStyleIndex = 1;
            this.m_noStroke = true;
        }
        return lineStyleIndex;
    }

    private void _pushChartType(ConstantPool cp, DoAction updatedActions) {
        ActionScript.pushPrimitiveVal(cp, updatedActions, "chartType", 6);
    }

    private void _pushNumRows(ConstantPool cp, DoAction updatedActions) {
        ActionScript.pushPrimitiveVal(cp, updatedActions, "nRows", this.m_commonGauge.getRowCount());
    }

    private void _pushNumColumns(ConstantPool cp, DoAction updatedActions) {
        ActionScript.pushPrimitiveVal(cp, updatedActions, "nCols", this.m_commonGauge.getColCount());
    }

    private void _pushRadiusX(ConstantPool cp, DoAction updatedActions) {
        double[][] radiusX = this._getRadiusXArray();
        ActionScript.createArray(cp, updatedActions, "radiusXArray", radiusX);
    }

    private void _pushRadiusY(ConstantPool cp, DoAction updatedActions) {
        double[][] radiusY = this._getRadiusYArray();
        ActionScript.createArray(cp, updatedActions, "radiusYArray", radiusY);
    }

    private void _pushCenterX(ConstantPool cp, DoAction updatedActions) {
        double[][] centerX = this._getCenterXArray();
        ActionScript.createArray(cp, updatedActions, "centerXArray", centerX);
    }

    private void _pushCenterY(ConstantPool cp, DoAction updatedActions) {
        double[][] centerY = this._getCenterYArray();
        ActionScript.createArray(cp, updatedActions, "centerYArray", centerY);
    }

    private void _pushMaxValue(ConstantPool cp, DoAction updatedActions) {
        double[][] maxValue = this._getMaxValue();
        ActionScript.createArray(cp, updatedActions, "maxValue", maxValue);
    }

    private void _pushMinValue(ConstantPool cp, DoAction updatedActions) {
        double[][] minValue = this._getMinValue();
        ActionScript.createArray(cp, updatedActions, "minValue", minValue);
    }

    private void _pushMetricValue(ConstantPool cp, DoAction updatedActions) {
        double[][] metricValue = this._getMetricValue();
        ActionScript.createArray(cp, updatedActions, "metricValue", metricValue);
    }

    private void _pushTopLabelValue(ConstantPool cp, DoAction updatedActions) {
        String[][] topLabelValue = this._getTopLabelValue();
        ActionScript.createArray(cp, updatedActions, "topLabelValue", topLabelValue);
    }

    private void _pushBottomLabelValue(ConstantPool cp, DoAction updatedActions) {
        String[][] bottomLabelValue = this._getBottomLabelValue();
        ActionScript.createArray(cp, updatedActions, "bottomLabelValue", bottomLabelValue);
    }

    private void _pushKeys(ConstantPool cp, DoAction doAction) {
        String[][] keys = ChartHelper.generateDataKeys(this.m_commonGauge);
        ActionScript.createArray(cp, doAction, "dataKeys", keys);
    }

    private void _pushMetricLabelsProps(ConstantPool cp, DoAction updatedActions) {
        Font font = RangeGauge.LABEL_FONT;
        ActionScript.pushPrimitiveVal(cp, updatedActions, "mLabelFont", this._getMappedLabelFontName(font.getFontName()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "mLabelFontSz", RangeGauge.LABEL_FONT_SIZE);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "mLabelTextColor", RangeGauge.LABEL_TEXT_COLOR);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "mLabelFontBold", new Boolean(RangeGauge.LABEL_FONT.isBold()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "mLabelFontItalic", new Boolean(RangeGauge.LABEL_FONT.isItalic()));
        double[][] metricLabelX = this._getMetricLabelX();
        ActionScript.createArray(cp, updatedActions, "mLabelX", metricLabelX);
        double[][] metricLabelY = this._getMetricLabelY();
        ActionScript.createArray(cp, updatedActions, "mLabelY", metricLabelY);
    }

    private void _pushTopLabelsProps(ConstantPool cp, DoAction updatedActions) {
        Font font = RangeGauge.TOPLABEL_FONT;
        ActionScript.pushPrimitiveVal(cp, updatedActions, "tLabelFont", this._getMappedLabelFontName(font.getFontName()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "tLabelFontSz", RangeGauge.TOPLABEL_FONT_SIZE);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "tLabelTextColor", RangeGauge.TOPLABEL_TEXT_COLOR);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "tLabelFontBold", new Boolean(RangeGauge.TOPLABEL_FONT.isBold()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "tLabelFontItalic", new Boolean(RangeGauge.TOPLABEL_FONT.isItalic()));
        double[][] topLabelX = this._getTopLabelX();
        ActionScript.createArray(cp, updatedActions, "tLabelX", topLabelX);
        double[][] topLabelY = this._getTopLabelY();
        ActionScript.createArray(cp, updatedActions, "tLabelY", topLabelY);
    }

    private void _pushBottomLabelsProps(ConstantPool cp, DoAction updatedActions) {
        Font font = RangeGauge.BOTTOMLABEL_FONT;
        ActionScript.pushPrimitiveVal(cp, updatedActions, "bLabelFont", this._getMappedLabelFontName(font.getFontName()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "bLabelFontSz", RangeGauge.BOTTOMLABEL_FONT_SIZE);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "bLabelTextColor", RangeGauge.BOTTOMLABEL_TEXT_COLOR);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "bLabelFontBold", new Boolean(RangeGauge.BOTTOMLABEL_FONT.isBold()));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "bLabelFontItalic", new Boolean(RangeGauge.BOTTOMLABEL_FONT.isItalic()));
        double[][] bottomLabelX = this._getBottomLabelX();
        ActionScript.createArray(cp, updatedActions, "bLabelX", bottomLabelX);
        double[][] bottomLabelY = this._getBottomLabelY();
        ActionScript.createArray(cp, updatedActions, "bLabelY", bottomLabelY);
    }

    private void _pushIndicatorType(ConstantPool cp, DoAction updatedActions) {
        int[][] indicatorTypes = this._getIndicatorTypes();
        ActionScript.createArray(cp, updatedActions, "mIndicatorType", indicatorTypes);
    }

    private void _pushIndicatorFillColor(ConstantPool cp, DoAction updatedActions) {
        int[][] indicatorFillColors = this._getIndicatorFillColors();
        ActionScript.createArray(cp, updatedActions, "mIndicatorFillColor", indicatorFillColors);
    }

    private void _pushIndicatorBorderColor(ConstantPool cp, DoAction updatedActions) {
        int[][] indicatorBorderColors = this._getIndicatorBorderColors();
        ActionScript.createArray(cp, updatedActions, "mIndicatorBorderColor", indicatorBorderColors);
    }

    private void _pushIndicatorBaseProperties(ConstantPool cp, DoAction updatedActions) {
        int fillType;
        HashMap sfxMap;
        Color indicatorBaseFillColor = GaugeDefaultValues.getIndicatorBaseFillColor();
        if (indicatorBaseFillColor != null) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "mIndicatorBaseFillColor", indicatorBaseFillColor);
        }
        if ((sfxMap = GaugeDefaultValues.getIndicatorBaseSFX()) != null && (fillType = ((Integer)sfxMap.get("SFX_FILL_TYPE")).intValue()) == 2) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "hasGradient", true);
            ArrayList colors = (ArrayList)sfxMap.get("SFX_STOP_COLORS");
            ArrayList pins = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
            int numOfPins = (Integer)sfxMap.get("SFX_NUM_STOPS");
            boolean dirRev = (Boolean)sfxMap.get("SFX_GRADIENT_REVERSED");
            int[] indicatorBaseGradColors = this._getIndicatorBaseGradColors(colors, numOfPins, dirRev);
            ActionScript.createArray(cp, updatedActions, "mIndicatorBaseGradColor", indicatorBaseGradColors);
            int[] indicatorBaseGradRatios = this._getIndicatorBaseGradRatio(pins, numOfPins, dirRev);
            ActionScript.createArray(cp, updatedActions, "mIndicatorBaseGradRatio", indicatorBaseGradRatios);
            int direction = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION");
            double indicatorBaseGradAngle = this._getIndicatorBaseGradAngle(direction);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "mIndicatorBaseGradAngle", indicatorBaseGradAngle);
        }
    }

    private void _pushFlashGaugeLCID(ConstantPool cp, DoAction updatedActions) {
        if (this.m_commonGauge.getFlashGaugeLCID() != null) {
            ActionScript.pushPrimitiveVal(cp, updatedActions, "lcId", this.m_commonGauge.getFlashGaugeLCID());
        }
    }

    private void _pushMetricNumberType(ConstantPool cp, DoAction updatedActions) {
        if (this.m_commonGauge.getMetricLabel() != null) {
            int numberType = this.m_commonGauge.getMetricLabel().getNumberType();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "mLabelNumType", numberType);
        }
    }

    private double[][] _getRadiusXArray() {
        double[][] radiusX = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                radiusX[i][j] = gauge.getRadiusX();
                ++j;
            }
            ++i;
        }
        return radiusX;
    }

    private double[][] _getRadiusYArray() {
        double[][] radiusY = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                radiusY[i][j] = gauge.getRadiusY();
                ++j;
            }
            ++i;
        }
        return radiusY;
    }

    private double[][] _getCenterXArray() {
        double[][] centerX = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                centerX[i][j] = gauge.getCenterX();
                ++j;
            }
            ++i;
        }
        return centerX;
    }

    private double[][] _getCenterYArray() {
        double[][] centerY = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                centerY[i][j] = gauge.getCenterY();
                ++j;
            }
            ++i;
        }
        return centerY;
    }

    private double[][] _getMaxValue() {
        double[][] maxValue = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                maxValue[i][j] = gauge.getMaxValue();
                ++j;
            }
            ++i;
        }
        return maxValue;
    }

    private double[][] _getMinValue() {
        double[][] minValue = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                minValue[i][j] = gauge.getMinValue();
                ++j;
            }
            ++i;
        }
        return minValue;
    }

    private double[][] _getMetricValue() {
        double[][] metricValue = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                metricValue[i][j] = gauge.getMetricValue();
                ++j;
            }
            ++i;
        }
        return metricValue;
    }

    private String[][] _getTopLabelValue() {
        String[][] topLabelValue = new String[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                topLabelValue[i][j] = gauge.getTopLabelValue();
                ++j;
            }
            ++i;
        }
        return topLabelValue;
    }

    private String[][] _getBottomLabelValue() {
        String[][] bottomLabelValue = new String[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                bottomLabelValue[i][j] = gauge.getBottomLabelValue();
                ++j;
            }
            ++i;
        }
        return bottomLabelValue;
    }

    private String _getMappedLabelFontName(String fontName) {
        if (fontName.equalsIgnoreCase("SansSerif.plain") || fontName.equalsIgnoreCase("SansSerif.bold") || fontName.equalsIgnoreCase("SansSerif.italic") || fontName.equalsIgnoreCase("SansSerif.bolditalic")) {
            fontName = "_sans";
        }
        if (fontName.equalsIgnoreCase("Dialog.plain") || fontName.equalsIgnoreCase("Dialog.bold") || fontName.equalsIgnoreCase("Dialog.italic") || fontName.equalsIgnoreCase("Dialog.bolditalic")) {
            fontName = "Arial";
        }
        return fontName;
    }

    private double[][] _getMetricLabelX() {
        double[][] metricLabelX = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                metricLabelX[i][j] = gauge.getMetricLabelX();
                ++j;
            }
            ++i;
        }
        return metricLabelX;
    }

    private double[][] _getMetricLabelY() {
        double[][] metricLabelY = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                metricLabelY[i][j] = gauge.getMetricLabelY();
                ++j;
            }
            ++i;
        }
        return metricLabelY;
    }

    private double[][] _getTopLabelX() {
        double[][] topLabelX = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                topLabelX[i][j] = gauge.getTopLabelX();
                ++j;
            }
            ++i;
        }
        return topLabelX;
    }

    private double[][] _getTopLabelY() {
        double[][] topLabelY = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                topLabelY[i][j] = gauge.getTopLabelY();
                ++j;
            }
            ++i;
        }
        return topLabelY;
    }

    private double[][] _getBottomLabelX() {
        double[][] bottomLabelX = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                bottomLabelX[i][j] = gauge.getBottomLabelX();
                ++j;
            }
            ++i;
        }
        return bottomLabelX;
    }

    private double[][] _getBottomLabelY() {
        double[][] bottomLabelY = new double[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                bottomLabelY[i][j] = gauge.getBottomLabelY();
                ++j;
            }
            ++i;
        }
        return bottomLabelY;
    }

    private int[][] _getIndicatorTypes() {
        int[][] indicatorTypes = new int[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                indicatorTypes[i][j] = gauge.getIndicatorType();
                ++j;
            }
            ++i;
        }
        return indicatorTypes;
    }

    private int[][] _getIndicatorFillColors() {
        int[][] indicatorFillColors = new int[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                indicatorFillColors[i][j] = gauge.getIndicatorFillColor();
                ++j;
            }
            ++i;
        }
        return indicatorFillColors;
    }

    private int[][] _getIndicatorBorderColors() {
        int[][] indicatorBorderColors = new int[this.m_nRows][this.m_nCols];
        int i = 0;
        while (i < this.m_nRows) {
            int j = 0;
            while (j < this.m_nCols) {
                RangeGauge gauge = (RangeGauge)this.m_mcObjs[i].get(j);
                indicatorBorderColors[i][j] = gauge.getIndicatorBorderColor();
                ++j;
            }
            ++i;
        }
        return indicatorBorderColors;
    }

    private int[] _getIndicatorBaseGradColors(ArrayList colors, int numOfPins, boolean dirRev) {
        int[] gradColors = new int[numOfPins];
        if (dirRev) {
            int i = numOfPins - 1;
            while (i >= 0) {
                gradColors[i] = ((Color)colors.get(i)).getRGB();
                --i;
            }
        } else {
            int i = 0;
            while (i < numOfPins) {
                gradColors[i] = ((Color)colors.get(i)).getRGB();
                ++i;
            }
        }
        return gradColors;
    }

    private int[] _getIndicatorBaseGradRatio(ArrayList pins, int numOfPins, boolean dirRev) {
        int[] ratios = new int[numOfPins];
        if (dirRev) {
            int i = numOfPins - 1;
            while (i >= 0) {
                int pos = (int)((Double)pins.get(i)).floatValue();
                ratios[i] = pos * 255;
                --i;
            }
        } else {
            int i = 0;
            while (i < numOfPins) {
                int pos = (int)((Double)pins.get(i)).floatValue();
                ratios[i] = pos * 255;
                ++i;
            }
        }
        return ratios;
    }

    private double _getIndicatorBaseGradAngle(int direction) {
        double angle = 0.0;
        if (direction == 1) {
            angle = 0.0;
        } else if (direction == 3) {
            angle = 90.0;
        } else if (direction == 5) {
            angle = 45.0;
        } else if (direction == 7) {
            angle = 135.0;
        } else if (direction == 9) {
            angle = -1.0;
        }
        return angle;
    }
}

