/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;

public class LegendObj {
    public static final int MARKER_SQUARE = 0;
    public static final int MARKER_LINE = 1;
    public static final int MARKER_CIRCLE = 2;
    private Rectangle m_rect;
    private int m_borderWidth;
    private int m_borderColor;
    private int m_borderAlpha;
    private int m_fillColor;
    private int m_fillAlpha;
    private int m_series;
    private int[] m_markerX;
    private int[] m_markerY;
    private int m_markerWidth;
    private int m_markerHeight;
    private String[] m_text;
    private Rectangle[] m_textBounds;
    private Font m_textFont;
    private int m_fontHeight;
    private int m_fontColor;
    private boolean m_bUnderline;
    private int[] m_markerShape;

    public LegendObj(BlackBoxIF blackBox, Perspective pfj, Rectangle rect, int series) {
        this.m_rect = rect;
        this.m_series = series;
        this.m_markerX = new int[series];
        this.m_markerY = new int[series];
        this.m_text = new String[series];
        this.m_textBounds = new Rectangle[series];
        this.m_markerShape = new int[series];
        this._calcProperties(blackBox, pfj);
    }

    private void _calcProperties(BlackBoxIF blackBox, Perspective pfj) {
        Color borderColor = blackBox.getBorderColor();
        this.m_borderAlpha = blackBox.getTransparentBorderColor() ? 0 : 255;
        if (borderColor == null) {
            borderColor = new Color(255, 255, 255);
            this.m_borderAlpha = 0;
        }
        this.m_borderColor = borderColor.getRGB();
        this.m_borderWidth = pfj.getLineWidth(blackBox.getIdentObj());
        Color fillColor = blackBox.getFillColor();
        this.m_fillAlpha = blackBox.getTransparentFillColor() ? 0 : 255;
        if (fillColor == null) {
            fillColor = new Color(255, 255, 255);
            this.m_fillAlpha = 0;
        }
        this.m_fillColor = fillColor.getRGB();
    }

    public void setMarker(int series, Rectangle rect) {
        if (series == 0) {
            this.m_markerWidth = rect.width;
            this.m_markerHeight = rect.height;
        }
        this.m_markerX[series] = rect.x;
        this.m_markerY[series] = rect.y;
    }

    public int getMarkerX(int series) {
        return this.m_markerX[series];
    }

    public int getMarkerY(int series) {
        return this.m_markerY[series];
    }

    public int getMarkerWidth() {
        return this.m_markerWidth;
    }

    public int getMarkerHeight() {
        return this.m_markerHeight;
    }

    public void setText(int series, String text, Rectangle bounds) {
        this.m_text[series] = text;
        this.m_textBounds[series] = bounds;
    }

    public String getText(int series) {
        return this.m_text[series];
    }

    public Rectangle getTextBounds(int series) {
        return this.m_textBounds[series];
    }

    public void setTextProps(Font font, int fontHeight, int fontColor, boolean underline) {
        this.m_textFont = font;
        this.m_fontHeight = fontHeight;
        this.m_fontColor = fontColor;
        this.m_bUnderline = underline;
    }

    public Font getFont() {
        return this.m_textFont;
    }

    public int getFontHeight() {
        return this.m_fontHeight;
    }

    public int getFontColor() {
        return this.m_fontColor;
    }

    public boolean isUnderline() {
        return this.m_bUnderline;
    }

    public Rectangle getAreaRect() {
        return this.m_rect;
    }

    public int getBorderWidth() {
        return this.m_borderWidth;
    }

    public int getBorderColor() {
        return this.m_borderColor;
    }

    public int getBorderAlpha() {
        return this.m_borderAlpha;
    }

    public int getFillColor() {
        return this.m_fillColor;
    }

    public int getFillAlpha() {
        return this.m_fillAlpha;
    }

    public void setMarkerShape(int series, int shape) {
        this.m_markerShape[series] = shape;
    }

    public int getMarkerShape(int series) {
        return this.m_markerShape[series];
    }
}

