/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Color;
import java.awt.Shape;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;

public class MovieClipObj {
    private boolean m_bHasGradient;
    private BlackBoxIF m_blackBox;
    private int m_borderAlpha;
    private int m_borderColor;
    private int m_borderWidth;
    private int m_depth;
    private int m_fillAlpha;
    private int m_fillColor;
    private IdentObj m_identObj;
    private String m_mcName;
    private Perspective m_pfj;
    private Shape m_shape;

    public MovieClipObj(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth, int depth, String mcSymbolId) {
        this.m_blackBox = blackBox;
        this.m_identObj = identObj;
        this.m_pfj = pfj;
        this.m_shape = shape;
        this.m_borderWidth = borderWidth;
        this.m_depth = depth;
        this.m_mcName = mcSymbolId + depth;
    }

    public MovieClipObj(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth, boolean hasGradient) {
        this.m_blackBox = blackBox;
        this.m_identObj = identObj;
        this.m_pfj = pfj;
        this.m_shape = shape;
        this.m_borderWidth = borderWidth;
        this.m_bHasGradient = hasGradient;
    }

    public MovieClipObj(Shape shape, int depth, String mcSymbolId) {
        this.m_shape = shape;
        this.m_depth = depth;
        this.m_mcName = mcSymbolId + depth;
    }

    public void calcProperties() {
        this._calcBorderStyles();
        this._calcFillStyles();
    }

    public int getBorderAlpha() {
        return this.m_borderAlpha;
    }

    public int getBorderColor() {
        return this.m_borderColor;
    }

    public int getBorderWidth() {
        return this.m_borderWidth;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public int getFillAlpha() {
        return this.m_fillAlpha;
    }

    public int getFillColor() {
        return this.m_fillColor;
    }

    public int getGroup() {
        return this.m_identObj.getGroupID();
    }

    public String getMCSymbolName() {
        return this.m_mcName;
    }

    public int getSeries() {
        return this.m_identObj.getSeriesID();
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public IdentObj getIdentObj() {
        return this.m_identObj;
    }

    private void _calcBorderStyles() {
        Color borderColor = this.m_blackBox.getBorderColor();
        this.m_borderAlpha = this.m_blackBox.getTransparentBorderColor() ? 0 : 255;
        if (borderColor == null) {
            borderColor = new Color(255, 255, 255);
            this.m_borderAlpha = 0;
        }
        this.m_borderColor = borderColor.getRGB();
        if (this.m_borderWidth == -1) {
            this.m_borderWidth = this.m_identObj.getObjectID() == 626 || this.m_identObj.getObjectID() == 620 || this.m_identObj.getObjectID() == 621 ? (this.m_identObj.getMiscID() == 623 ? this.m_pfj.getLineWidth(this.m_pfj.getFunnelFrame()) : this.m_pfj.getLineWidth(this.m_blackBox.getIdentObj())) : 1;
        }
    }

    private void _calcFillStyles() {
        Color fillColor = null;
        fillColor = !this.m_bHasGradient ? this.m_blackBox.getFillColor() : this.m_pfj.getSeriesFillColor(this.m_identObj.getSeriesID());
        if (this.m_identObj.getObjectID() == 626 && this.m_identObj.getMiscID() == 623) {
            fillColor = this.m_pfj.getFillColor(this.m_pfj.getFunnelFrame());
            fillColor = this.m_pfj.getDarker(fillColor);
        }
        if (fillColor == null) {
            fillColor = new Color(255, 255, 255);
            this.m_fillAlpha = 0;
        }
        this.m_fillAlpha = this.m_blackBox.getTransparentFillColor() ? 0 : fillColor.getAlpha();
        this.m_fillAlpha = (int)(0.39215686274509803 * (double)this.m_fillAlpha);
        this.m_fillColor = fillColor.getRGB();
    }
}

