/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.util.Vector;
import oracle.dss.graph.flash.ActionScript;
import oracle.dss.graph.flash.ChartRenderer;
import oracle.dss.graph.flash.MovieClipObj;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.ConstantPool;
import oracle.dss.graph.flash.jswiff.swfrecords.tags.DoAction;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.IdentObj;

public class PieChartRenderer
extends ChartRenderer {
    public PieChartRenderer(SWFDocument document, VC vc, boolean renderDynamic, Perspective pfj) {
        super(document, vc, renderDynamic, pfj);
    }

    protected void populateMCDrawProperties(BlackBoxIF blackBox, IdentObj identObj, Perspective pfj, Shape shape, int borderWidth) {
        MovieClipObj mc = new MovieClipObj(blackBox, identObj, pfj, shape, borderWidth, this.m_bHasGradient);
        mc.calcProperties();
        this.m_mcObjs[mc.getGroup()].setElementAt(mc, mc.getSeries());
    }

    protected void createChartContext(ConstantPool cp, DoAction updatedActions) {
        super.createChartContext(cp, updatedActions);
        this.asCreateDataArray(cp, updatedActions, "dataArray", this.m_numGroups);
        this.asCreateFillColorArray(cp, updatedActions, "fillColorArray", this.m_numGroups);
        this.asCreateFillAlphaArray(cp, updatedActions, "fillAlphaArray", this.m_numGroups);
        this._asCreateCenterXArray(cp, updatedActions, "centerXArray");
        this._asCreateCenterYArray(cp, updatedActions, "centerYArray");
        this._asCreateRadiusXArray(cp, updatedActions, "radiusXArray");
        this._asCreateRadiusYArray(cp, updatedActions, "radiusYArray");
        this._asPushPieFeelerInfo(cp, updatedActions);
        this._asPushPieSliceLabelTextStyle(cp, updatedActions);
        this._asPushPieContextMenuLabels(cp, updatedActions);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelType", new Integer(this.m_pfj.getPieLabelDisplay()));
    }

    protected int getChartType() {
        return 4;
    }

    protected boolean includeRendererAsset(String asset) {
        if (super.includeRendererAsset(asset)) {
            return true;
        }
        return this.is3DEffect() ? asset.equals("__Packages.PieChartRenderer") || asset.equals("__Packages.PieChartRenderer_3D") || asset.equals("__Packages.PieSliceLabels") || asset.equals("__Packages.EllipticalArc") || asset.equals("__Packages.PieAnimHelper") || asset.equals("__Packages.EllipticalArc2D") || asset.equals("__Packages.EllipticalArc3D") || asset.equals("__Packages.CircularArc2D") || asset.equals("__Packages.PieChartLayoutManager") : asset.equals("__Packages.PieChartRenderer") || asset.equals("__Packages.PieAnimHelper") || asset.equals("__Packages.PieSliceLabels") || asset.equals("__Packages.CircularArc2D") || asset.equals("__Packages.PieChartLayoutManager");
    }

    protected void createMCObjArray() {
        if (this.m_pfj.getGraphType() == 55) {
            this.m_numGroups = 1;
        }
        this.m_mcObjs = new Vector[this.m_numGroups];
        int i = 0;
        while (i < this.m_numGroups) {
            this.m_mcObjs[i] = new Vector();
            this.m_mcObjs[i].setSize(this.m_numSeries);
            ++i;
        }
    }

    public boolean is3DEffect() {
        return this.m_pfj.getDepthRadius() > 0 && this.m_pfj.getDepthAngle() > 0;
    }

    protected void asPush3DContext(ConstantPool cp, DoAction updatedActions) {
        super.asPush3DContext(cp, updatedActions);
        ActionScript.createAndInitializeGlobalVar(cp, updatedActions, "pieDepth", this.m_pfj.getPieDepth());
        ActionScript.createAndInitializeGlobalVar(cp, updatedActions, "pieTilt", this.m_pfj.getPieTilt());
    }

    private void _asPushPieSliceLabelTextStyle(ConstantPool cp, DoAction updatedActions) {
        IdentObj pieSliceLabelId = this.m_pfj.getPieSliceLabel();
        String fontName = this.m_pfj.getFontName(pieSliceLabelId);
        if (fontName.equalsIgnoreCase("SansSerif")) {
            fontName = "_sans";
        }
        if (fontName.equalsIgnoreCase("Dialog")) {
            fontName = "Arial";
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelFontName", fontName);
        int fontSize = this.m_pfj.getFontSize(pieSliceLabelId);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelFontHeight", new Integer(fontSize));
        int fontColor = this.m_pfj.getFillColor(pieSliceLabelId).getRGB();
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelFontColor", new Integer(fontColor));
        int fontStyle = this.m_pfj.getFontStyle(pieSliceLabelId);
        boolean underline = false;
        if ((fontStyle & 4) != 0) {
            underline = true;
        }
        boolean bold = false;
        if ((fontStyle & 2) != 0) {
            bold = true;
        }
        boolean italic = false;
        if ((fontStyle & 1) != 0) {
            italic = true;
        }
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelBold", new Boolean(bold));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelItalic", new Boolean(underline));
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieSliceLabelUnderline", new Boolean(italic));
    }

    private void _asPushPieContextMenuLabels(ConstantPool cp, DoAction updatedActions) {
        String explode = this.getIntlString("af_dvt_graph.LABEL_EXPLODE");
        String unite = this.getIntlString("af_dvt_graph.LABEL_UNITE");
        String explodeAll = this.getIntlString("af_dvt_graph.LABEL_EXPLODE_ALL");
        String uniteAll = this.getIntlString("af_dvt_graph.LABEL_UNITE_ALL");
        ActionScript.pushPrimitiveVal(cp, updatedActions, "explode", explode);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "unite", unite);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "explodeAll", explodeAll);
        ActionScript.pushPrimitiveVal(cp, updatedActions, "uniteAll", uniteAll);
    }

    private void _asPushPieFeelerInfo(ConstantPool cp, DoAction updatedActions) {
        boolean feelerLineRequired = this.m_pfj.getPieFeelerTextDisplay() == 1;
        ActionScript.pushPrimitiveVal(cp, updatedActions, "pieFeelersRequired", feelerLineRequired);
        if (feelerLineRequired) {
            int feelerWidth = this.m_pfj.getLineWidth(this.m_pfj.getPieFeelerLine());
            IdentObj idColor = new IdentObj(294);
            BlackBoxObj blackBox = new BlackBoxObj(this.m_pfj, idColor);
            int feelerColor = blackBox.getBorderColor().getRGB();
            ActionScript.pushPrimitiveVal(cp, updatedActions, "pieFeelerWidth", feelerWidth);
            ActionScript.pushPrimitiveVal(cp, updatedActions, "pieFeelerColor", feelerColor);
        }
    }

    private void _asCreateCenterXArray(ConstantPool cp, DoAction doAction, String centerXArray) {
        double[] centerXValues = this._getCenterXValues();
        ActionScript.createArray(cp, doAction, centerXArray, centerXValues);
    }

    private double[] _getCenterXValues() {
        double[] centerXValues = new double[this.m_mcObjs.length];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            MovieClipObj mcObj = null;
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcObj = (MovieClipObj)this.m_mcObjs[i].elementAt(j);
                if (mcObj != null) break;
                ++j;
            }
            Arc2D.Double arc = (Arc2D.Double)mcObj.getShape();
            centerXValues[i] = arc.getCenterX();
            ++i;
        }
        return centerXValues;
    }

    private void _asCreateCenterYArray(ConstantPool cp, DoAction doAction, String centerYArray) {
        double[] centerYValues = this._getCenterYValues();
        ActionScript.createArray(cp, doAction, centerYArray, centerYValues);
    }

    private double[] _getCenterYValues() {
        double[] centerYValues = new double[this.m_mcObjs.length];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            MovieClipObj mcObj = null;
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcObj = (MovieClipObj)this.m_mcObjs[i].elementAt(j);
                if (mcObj != null) break;
                ++j;
            }
            Arc2D.Double arc = (Arc2D.Double)mcObj.getShape();
            centerYValues[i] = arc.getCenterY();
            ++i;
        }
        return centerYValues;
    }

    private void _asCreateRadiusXArray(ConstantPool cp, DoAction doAction, String radiusXArray) {
        double[] radiusXValues = this._getRadiusXValues();
        ActionScript.createArray(cp, doAction, radiusXArray, radiusXValues);
    }

    private double[] _getRadiusXValues() {
        double[] radiusXValues = new double[this.m_mcObjs.length];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            MovieClipObj mcObj = null;
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcObj = (MovieClipObj)this.m_mcObjs[i].elementAt(j);
                if (mcObj != null) break;
                ++j;
            }
            Arc2D.Double arc = (Arc2D.Double)mcObj.getShape();
            radiusXValues[i] = arc.getWidth() / 2.0;
            ++i;
        }
        return radiusXValues;
    }

    private void _asCreateRadiusYArray(ConstantPool cp, DoAction doAction, String radiusYArray) {
        double[] radiusYValues = this._getRadiusYValues();
        ActionScript.createArray(cp, doAction, radiusYArray, radiusYValues);
    }

    private double[] _getRadiusYValues() {
        double[] radiusYValues = new double[this.m_mcObjs.length];
        int i = 0;
        while (i < this.m_mcObjs.length) {
            MovieClipObj mcObj = null;
            int j = 0;
            while (j < this.m_mcObjs[i].size()) {
                mcObj = (MovieClipObj)this.m_mcObjs[i].elementAt(j);
                if (mcObj != null) break;
                ++j;
            }
            Arc2D.Double arc = (Arc2D.Double)mcObj.getShape();
            radiusYValues[i] = arc.getHeight() / 2.0;
            ++i;
        }
        return radiusYValues;
    }
}

