/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.dss.graph.flash.ToolTipActionScript;
import oracle.dss.graph.flash.jswiff.swfrecords.actions.DefineFunction2;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;

public class ToolTipObj {
    private ToolTipActionScript actionScript;
    private String m_associatedMcName;
    private BlackBoxIF m_blackBox;
    private Rectangle m_bounds;
    private int m_depth;
    private int m_textBoxDepth;
    private int m_rectDepth;
    private Font m_font;
    private FontMetrics m_fontMetrics;
    private IdentObj m_identObj;
    private String m_mcName;
    private int m_numOfLines;
    private String m_text;
    private String[] m_textArray;
    private DefineFunction2 rollOverFunc;
    private DefineFunction2 rollOutFunc;
    private DefineFunction2 onDragOutFunc;

    private void $init$() {
        this.m_text = "";
    }

    public ToolTipObj(BlackBoxIF blackBox, IdentObj identObj, String mcSymbolId) {
        this.$init$();
        this.m_blackBox = blackBox;
        this.m_identObj = identObj;
        this.m_associatedMcName = mcSymbolId;
        this.m_mcName = mcSymbolId + "_tooltip";
        this.m_font = new Font("SansSerif", 0, 10);
    }

    public ToolTipObj(String mcSymbolId) {
        this.$init$();
        this.m_associatedMcName = mcSymbolId;
        this.m_mcName = mcSymbolId + "_tooltip";
    }

    public ToolTipActionScript getActionScript() {
        return this.actionScript;
    }

    public BlackBoxIF getBlackBox() {
        return this.m_blackBox;
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public Font getFont() {
        return this.m_font;
    }

    public IdentObj getIdentObj() {
        return this.m_identObj;
    }

    public String getMCSymbolName() {
        return this.m_mcName;
    }

    public DefineFunction2 getOnDragOutFunc() {
        return this.onDragOutFunc;
    }

    public int getRectDepth() {
        return this.m_rectDepth;
    }

    public DefineFunction2 getRollOutFunc() {
        return this.rollOutFunc;
    }

    public DefineFunction2 getRollOverFunc() {
        return this.rollOverFunc;
    }

    public String getText() {
        return this.m_text;
    }

    public int getTextBoxDepth() {
        return this.m_textBoxDepth;
    }

    public void setActionScript(ToolTipActionScript actionScript) {
        this.actionScript = actionScript;
    }

    public void setFontMetrics(Graphics graphics) {
        this.m_fontMetrics = graphics.getFontMetrics(this.m_font);
    }

    public void setOnDragOutFunc(DefineFunction2 onClickFunc) {
        this.onDragOutFunc = onClickFunc;
    }

    public void setRectDepth(int depth) {
        this.m_rectDepth = depth;
    }

    public void setRollOutFunc(DefineFunction2 rollOutFunc) {
        this.rollOutFunc = rollOutFunc;
    }

    public void setRollOverFunc(DefineFunction2 rollOverFunc) {
        this.rollOverFunc = rollOverFunc;
    }

    public void setText(String[] textArray) {
        this.m_textArray = textArray;
        this.m_text = this._concatTooltipText(textArray);
        this._calcSize();
    }

    public void setTextBoxDepth(int boxDepth) {
        this.m_textBoxDepth = boxDepth;
    }

    private void _calcSize() {
        int width = this._findLongestString() + 10;
        int height = this._getFontHeight() * this.m_numOfLines + 5;
        this.m_bounds = new Rectangle(5, -5, width, height);
    }

    private String _concatTooltipText(String[] textArray) {
        if (textArray == null || textArray.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (textArray[0] != null && textArray[0].length() > 0) {
            sb.append(textArray[0]);
            ++this.m_numOfLines;
        }
        int i = 1;
        while (i < textArray.length) {
            if (textArray[i] != null && textArray[i].length() > 0) {
                ++this.m_numOfLines;
                sb.append("\n");
                sb.append(textArray[i]);
            }
            ++i;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private int _findLongestString() {
        int longest = 0;
        int i = 0;
        while (i < this.m_textArray.length) {
            int width = this.m_fontMetrics.stringWidth(this.m_textArray[i]);
            if (longest < width) {
                longest = width;
            }
            ++i;
        }
        return longest;
    }

    private int _getFontHeight() {
        return this.m_fontMetrics.getHeight();
    }
}

