/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.flash.jswiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.dss.graph.flash.jswiff.SWFDocument;
import oracle.dss.graph.flash.jswiff.SWFWriter;
import oracle.dss.graph.flash.jswiff.hl.factories.ImageDocumentFactory;
import oracle.dss.graph.flash.jswiff.hl.factories.MP3DocumentFactory;
import oracle.dss.graph.flash.jswiff.hl.factories.WAVDocumentFactory;
import oracle.dss.graph.flash.jswiff.util.ImageUtilities;

public class MediaImporter {
    public static final int TYPE_MP3 = 0;
    public static final int TYPE_WAV = 1;

    public static SWFDocument importImageAsJPEG(InputStream imageStream, int qualityPercent) throws IOException {
        BufferedImage image = ImageUtilities.loadImage(imageStream);
        ImageDocumentFactory factory = new ImageDocumentFactory(image);
        factory.setQuality(qualityPercent);
        return factory.getDocument();
    }

    public static SWFDocument importImageAsLossless(InputStream imageStream) throws IOException {
        BufferedImage image = ImageUtilities.loadImage(imageStream);
        ImageDocumentFactory factory = new ImageDocumentFactory(image);
        factory.setLossless(true);
        return factory.getDocument();
    }

    public static SWFDocument importSound(InputStream soundStream, int soundType) throws IOException {
        switch (soundType) {
            case 0: {
                MP3DocumentFactory mp3Factory = new MP3DocumentFactory(soundStream);
                return mp3Factory.getDocument();
            }
            case 1: {
                WAVDocumentFactory wavFactory = new WAVDocumentFactory(soundStream);
                return wavFactory.getDocument();
            }
        }
        throw new IllegalArgumentException("Unknown sound type: " + soundType);
    }

    public static void writeJPEGImageDocument(InputStream imageInStream, OutputStream swfOutStream, int qualityPercent, boolean compressed) throws IOException {
        SWFDocument doc = MediaImporter.importImageAsJPEG(imageInStream, qualityPercent);
        doc.setCompressed(compressed);
        SWFWriter writer = new SWFWriter(doc, swfOutStream);
        writer.write();
    }

    public static void writeLosslessImageDocument(InputStream imageInStream, OutputStream swfOutStream, boolean compressed) throws IOException {
        SWFDocument doc = MediaImporter.importImageAsLossless(imageInStream);
        doc.setCompressed(compressed);
        SWFWriter writer = new SWFWriter(doc, swfOutStream);
        writer.write();
    }

    public static void writeSoundDocument(InputStream soundInStream, int soundType, OutputStream swfOutStream, boolean compressed) throws IOException {
        SWFDocument doc = MediaImporter.importSound(soundInStream, soundType);
        doc.setCompressed(compressed);
        SWFWriter writer = new SWFWriter(doc, swfOutStream);
        writer.write();
    }
}

